//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _eriroot_9.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot9(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[9] = {6.670223095819444e-02,6.032363570817492e-01,1.692395079793181e+00,3.369176270243263e+00,5.694423342957752e+00,
    8.769756730268591e+00,1.277182535486918e+01,1.804650546772897e+01,2.548597916609908e+01};
  constexpr double aw[9] = {4.834956947254558e-01,2.848072856699794e-01,9.730174764131549e-02,1.864004238754467e-02,1.888522630268423e-03,
    9.181126867929429e-05,1.810654481093432e-06,1.046720579579196e-08,7.828199772115708e-12};
  constexpr double x[3456] = {  1.364589678108787e-02, -3.567844718759797e-04,  6.948809034988296e-06, -1.192399517051635e-07,  1.895880548687806e-09,
 -2.852383139983493e-11,  4.096899817958795e-13, -5.635743539448736e-15,  7.412101852962115e-17, -9.266342721982231e-19,  1.086133631427855e-20, -1.161517568985484e-22,
  1.207949834553854e-01, -2.996175800560409e-03,  5.226120551227273e-05, -7.337492300267332e-07,  8.151566084683161e-09, -5.871490805010141e-11, -1.491367500355750e-13,
  1.488888761951310e-14, -3.215237692707799e-16,  4.530630627913158e-18, -3.898747769884238e-20, -7.513035365445165e-23,  3.244542675924523e-01, -7.213518047231881e-03,
  9.764523780942001e-05, -7.253753697464953e-07, -3.294495819902518e-09,  1.933455156373826e-10, -2.788870954001633e-12,  7.607288486780552e-15,  5.286777148379084e-16,
 -1.212159883934520e-17,  9.909892459461280e-20,  1.290925704574339e-21,  6.039650692347921e-01, -1.127020413921434e-02,  9.112578289927534e-05,  4.608652699910540e-07,
 -2.023759238025789e-08,  1.188912379244963e-10,  3.393480636500854e-12, -6.852312557557610e-14, -1.090723307622382e-16,  2.039160298155942e-17, -2.137182574544390e-19,
 -3.461779136701457e-21,  9.299877833223175e-01, -1.341731227945762e-02,  2.135095810904501e-05,  1.582425096911053e-06, -7.266660136235552e-09, -3.281170010732165e-10,
  2.570977648290334e-12,  8.048047807769534e-14, -9.303205076543574e-16, -2.120837152017918e-17,  3.395113085220874e-19,  5.717848584035636e-21,  1.266740863403423e+00,
 -1.263906491521169e-02, -6.670733450922055e-05,  1.147515858759575e-06,  1.919031230354065e-08, -1.257232540904769e-10, -5.572517855970697e-12, -5.386299348551308e-15,
  1.533113258511548e-15,  1.266002644323035e-17, -3.759613926310512e-19, -6.777515739894123e-21,  1.575330649385416e+00, -9.181121923083110e-03, -1.076334126562839e-04,
 -3.364250474116889e-07,  1.384278401777269e-08,  2.744597562414141e-10,  9.601024654823162e-13, -5.455132521755428e-14, -1.138154240317580e-15, -3.346949433241196e-18,
  2.753803944089175e-19,  5.633746669725794e-21,  1.818217296542947e+00, -4.567012749240973e-03, -7.719394877116381e-05, -9.628668083861962e-07, -7.341374012907845e-09,
  2.515784312630773e-11,  2.086705499060439e-12,  4.116414865086652e-14,  4.439203121904962e-16,  3.632339237375088e-20, -1.146972187858619e-19, -2.765932944340293e-21,
  1.964506166712064e+00, -9.674835637845980e-04, -1.941602016927220e-05, -3.375653842677218e-07, -5.315061482595058e-09, -7.665263485424140e-11, -1.005215425278976e-12,
 -1.162560729104799e-14, -1.082521876632829e-16, -5.175810904304263e-19,  8.735557168758552e-21,  3.480833514663428e-22,  1.232155252741935e-02, -3.064419711689360e-04,
  5.682703154325658e-06, -9.298463764562144e-08,  1.412212190074296e-09, -2.034491755614144e-11,  2.806245212117353e-13, -3.722915313033047e-15,  4.747769812026721e-17,
 -5.806744899764722e-19,  6.746917620622146e-21, -7.353397520269919e-23,  1.095937063093679e-01, -2.611178778538290e-03,  4.419972423798033e-05, -6.127903830029443e-07,
  6.969834713568938e-09, -5.831422230195548e-11,  1.460839582420812e-13,  6.909869580258669e-15, -1.861822876174123e-16,  3.019693305648515e-18, -3.454316185418746e-20,
  2.080251413760764e-22,  2.971064838802064e-01, -6.467799525333814e-03,  8.874055960378296e-05, -7.506867715572351e-07, -7.138603934830432e-11,  1.305065001371541e-10,
 -2.398720944644078e-12,  1.837954342482465e-14,  1.714685237730669e-16, -7.642557161737377e-18,  1.124771935708584e-19, -4.166807166488087e-22,  5.603697902525417e-01,
 -1.052437474315458e-02,  9.480437774292049e-05,  1.598601128632427e-07, -1.720013650122621e-08,  1.775301675688974e-10,  1.523271028622246e-12, -6.212849026750989e-14,
  4.475686334843515e-16,  1.021295439235974e-17, -2.636848359291173e-19,  8.318562213768979e-22,  8.767769976474301e-01, -1.317299816833828e-02,  3.943869254785576e-05,
  1.417709988710415e-06, -1.304944082016216e-08, -2.433377988100722e-10,  4.313848011185734e-12,  4.149330349812612e-14, -1.406239318468781e-15, -4.539359762092144e-18,
  4.439055787571249e-19, -1.045231914905744e-21,  1.215211555445818e+00, -1.311266120900526e-02, -5.120128038334644e-05,  1.427231301288626e-06,  1.535624422740553e-08,
 -2.554254319465876e-10, -4.991674248794748e-12,  4.755960280345253e-14,  1.658980706886213e-15, -6.864755714948588e-18, -5.531497059289680e-19, -3.785456697811772e-22,
  1.536864331175273e+00, -1.005414995798163e-02, -1.101580057061133e-04, -7.036892530107400e-08,  1.941725452871876e-08,  2.750340596929438e-10, -1.077389161902779e-12,
 -9.029382763643351e-14, -1.001748116575808e-15,  1.242790114316576e-17,  4.984691800056606e-19,  3.533148374096797e-21,  1.798638220596795e+00, -5.232720819616136e-03,
 -8.942656436186716e-05, -1.073162057126512e-06, -6.235882353890702e-09,  9.063823890386234e-11,  3.430533167978515e-12,  5.423659701010147e-14,  3.287036732119091e-16,
 -7.488500857076356e-18, -2.732936848159669e-19, -4.344018819588637e-21,  1.960297715137083e+00, -1.140586167247644e-03, -2.403220723094592e-05, -4.362994987733107e-07,
 -7.117817274957758e-09, -1.050893777321454e-10, -1.381339713556779e-12, -1.528282162422541e-14, -1.157152319330901e-16,  2.749343643832085e-19,  3.510116875356420e-20,
  9.322944354755384e-22,  1.118014537328137e-02, -2.650881978713872e-04,  4.690127674951574e-06, -7.331107873757865e-08,  1.065031757910257e-09, -1.470674866022526e-11,
  1.948477978296969e-13, -2.491773048776592e-15,  3.073652886963861e-17, -3.663549244185857e-19,  4.171672063988665e-21, -4.564415752556109e-23,  9.981217617232317e-02,
 -2.285186246382965e-03,  3.747762665371626e-05, -5.103579435232955e-07,  5.851195652898460e-09, -5.306834585124706e-11,  2.707018662114101e-13,  2.443803142711586e-15,
 -9.997185521379628e-17,  1.836933651340432e-18, -2.448439969564053e-20,  2.260167894329094e-22,  2.725982921624506e-01, -5.793748479032038e-03,  7.980196581352265e-05,
 -7.338926716851563e-07,  2.006970796931181e-09,  7.950843297391760e-11, -1.842721010552187e-12,  2.028371697432176e-14, -2.901438497348747e-17, -3.706227898771921e-18,
  8.122177490964675e-20, -8.566726668727145e-22,  5.197950744423273e-01, -9.762664927115363e-03,  9.519355229721504e-05, -8.550958904530019e-08, -1.341530653677140e-08,
  1.951014886133213e-10,  2.558418305411603e-14, -4.384273388439065e-14,  6.408055023656037e-16,  1.083138590517168e-18, -1.807854925013114e-19,  2.496271361830986e-21,
  8.248183193625516e-01, -1.279331973646877e-02,  5.505694208632075e-05,  1.175912915919050e-06, -1.681325369618015e-08, -1.309813101493432e-10,  4.844495849475632e-12,
 -2.887175921945636e-15, -1.276491349431850e-15,  1.066723279373463e-17,  2.837180897416473e-19, -5.497306543980026e-21,  1.162055494601809e+00, -1.345001531583464e-02,
 -3.278848339409670e-05,  1.626110280106370e-06,  9.187082755678114e-09, -3.536256563341903e-10, -2.983799299643567e-12,  9.254647482504491e-14,  1.033359604829676e-15,
 -2.671880930352729e-17, -3.771387727373676e-19,  8.046683918726312e-21,  1.494887845617847e+00, -1.093310580433888e-02, -1.089638960228380e-04,  2.819896056224230e-07,
  2.443812893429289e-08,  2.157721308267243e-10, -3.958498871910837e-12, -1.111548622711122e-13, -1.761882201369386e-16,  3.337799185415452e-17,  4.850019547486585e-19,
 -5.198461628082462e-21,  1.776192778856146e+00, -6.001171802931426e-03, -1.028273882622109e-04, -1.153426930481846e-06, -3.472000504356918e-09,  1.920491011961567e-10,
  5.038622728325470e-12,  5.794717941950694e-14, -1.850982984707199e-16, -2.234523938577940e-17, -4.652171538348006e-19, -3.665712150605556e-21,  1.955314736891657e+00,
 -1.355894438053490e-03, -3.002672062048758e-05, -5.689529329754649e-07, -9.587868879905653e-09, -1.437738482832708e-10, -1.857129137176373e-12, -1.845843869340491e-14,
 -6.789483140572423e-17,  2.815648833072438e-18,  1.014420474066903e-19,  2.247222686193219e-21,  1.018964442736851e-02, -2.308172332800382e-04,  3.903694040262843e-06,
 -5.839143644110089e-08,  8.125355054520667e-10, -1.076761959354176e-11,  1.370740212068881e-13, -1.690592825692548e-15,  2.012056189798134e-17, -2.339339537310387e-19,
  2.575856579323167e-21, -2.819011379444778e-23,  9.123442952099491e-02, -2.008349168108805e-03,  3.188121394329964e-05, -4.248592720376362e-07,  4.858707646307056e-09,
 -4.605706888355649e-11,  3.030434534532717e-13,  1.323737060397364e-16, -4.920458308358163e-17,  1.041683814761895e-18, -1.569295002543792e-20,  1.703201463387833e-22,
  2.506452653565722e-01, -5.189907517251069e-03,  7.123313490930683e-05, -6.912728576459562e-07,  3.199900276784902e-09,  4.189085389360551e-11, -1.303788472252662e-12,
  1.777424972938039e-14, -1.129379632981443e-16, -1.194438701328189e-18,  4.540170949698541e-20, -7.209663779402014e-22,  4.822562502957186e-01, -9.008575064026483e-03,
  9.300740286817845e-05, -2.692805741777709e-07, -9.594608037518873e-09,  1.832930050867752e-10, -9.177642508898621e-13, -2.389219466220455e-14,  5.762284427150079e-16,
 -3.959485057849862e-18, -7.410929307355569e-20,  2.142237433867348e-21,  7.746086532493390e-01, -1.230115208969331e-02,  6.748757648571641e-05,  8.921557574788217e-07,
 -1.829885223433362e-08, -1.987831156802122e-11,  4.262280843660744e-12, -3.589450786940371e-14, -7.493073241197530e-16,  1.693397531198467e-17,  3.162778559455832e-20,
 -5.258880153589973e-21,  1.107857194925114e+00, -1.363232918791040e-02, -1.263665406135840e-05,  1.713568637881399e-06,  1.623574722281340e-09, -3.913784640905933e-10,
 -9.041890923335565e-14,  1.081002483657906e-13, -1.009045032132801e-16, -3.332071782443539e-17,  6.664422056165096e-20,  1.069620332800393e-20,  1.449443199278869e+00,
 -1.178434511017674e-02, -1.031111569512782e-04,  7.013070906424485e-07,  2.755329216219126e-08,  8.401226401529453e-11, -6.946044205337057e-12, -9.447834184482320e-14,
  1.287869407583050e-15,  4.474097633818241e-17,  4.876691878418197e-22, -1.631469548295331e-20,  1.750454301613851e+00, -6.879762531177714e-03, -1.168523330124698e-04,
 -1.171151935358008e-06,  1.702573185455613e-09,  3.308989113638030e-10,  6.430247908787455e-12,  3.532960898652450e-14, -1.349910193832905e-15, -4.257103720951761e-17,
 -4.888223742023010e-19,  4.279741049830554e-21,  1.949363500423786e+00, -1.626260999213307e-03, -3.787781400363526e-05, -7.479629717963355e-07, -1.295167262266191e-08,
 -1.946653757549062e-10, -2.382260894463747e-12, -1.799564393820313e-14,  1.360985250098918e-16,  9.504616739717825e-18,  2.518803157647540e-19,  4.843478279511125e-21,
  9.324688656420105e-03, -2.021847406543324e-04,  3.274431554316712e-06, -4.694982156837481e-08,  6.265920144687366e-10, -7.980252658733573e-12,  9.761426197408928e-14,
 -1.163787495472944e-15,  1.328992899467808e-17, -1.518731296783769e-19,  1.617178904887284e-21, -1.575485700577711e-23,  8.368061964024659e-02, -1.772438577826026e-03,
  2.722021762830739e-05, -3.540954489245375e-07,  4.009809766776196e-09, -3.888680840374103e-11,  2.895601716170812e-13, -9.496292660030537e-16, -2.134259895790341e-17,
  5.482958603736654e-19, -9.298204170084397e-21,  1.267480090790695e-22,  2.309741284930061e-01, -4.652299725048302e-03,  6.326763557782240e-05, -6.349105905791925e-07,
  3.762881882333322e-09,  1.613504798003405e-11, -8.610063236106237e-13,  1.376564232109660e-14, -1.301316622416193e-16,  7.226216798187705e-20,  2.020446017405574e-20,
 -4.106211281866598e-22,  4.476862751540268e-01, -8.279781195329537e-03,  8.897151509038477e-05, -3.948560064635862e-07, -6.193049847839024e-09,  1.551746340364518e-10,
 -1.353114196340208e-12, -8.137437518087974e-15,  4.005785761275047e-16, -5.310766440338554e-18, -2.257794039087452e-22,  1.228327394859686e-21,  7.265446265687904e-01,
 -1.172340126364678e-02,  7.644060467198553e-05,  6.013683595230665e-07, -1.776649449957688e-08,  6.820800516301854e-11,  3.012529842960125e-12, -5.028151075450478e-14,
 -1.656251173505072e-16,  1.437132799956980e-17, -1.370577796078413e-19, -2.187935304775780e-21,  1.053255767231751e+00, -1.365132014045930e-02,  7.826106869391990e-06,
  1.677816083359537e-06, -5.986975156100194e-09, -3.586598598462687e-10,  2.719584786046477e-12,  8.705661706922088e-14, -1.148329548451480e-15, -2.236201484018289e-17,
  4.416890436089661e-19,  5.377181158712692e-21,  1.400720009399101e+00, -1.256801233790532e-02, -9.202646264228272e-05,  1.145747206465354e-06,  2.738247526930998e-08,
 -1.083290746130138e-10, -8.780985677759901e-12, -2.900152736610627e-14,  2.711133222570656e-15,  2.900799228371746e-17, -7.916122139938282e-19, -1.675334037431657e-20,
  1.720977993680657e+00, -7.869774698536953e-03, -1.304964890323640e-04, -1.082352732557059e-06,  9.912254421740553e-09,  4.906773758040209e-10,  6.560877271530344e-12,
 -3.551959648999993e-14, -3.146353951518033e-15, -5.350954735551886e-17,  8.143700967423802e-20,  2.329850201374125e-20,  1.942190176266676e+00, -1.969025460899511e-03,
 -4.823570846102114e-05, -9.896003056085089e-07, -1.745336201002018e-08, -2.569968731724402e-10, -2.757138345184990e-12, -5.740582406244526e-15,  7.207997868890252e-16,
  2.493691595588971e-17,  5.486462775405311e-19,  8.773862029591776e-21,  8.564998009742674e-03, -1.780838013289821e-04,  2.766303560831061e-06, -3.808417598854264e-08,
  4.880033670070963e-10, -5.985121915292761e-12,  7.024233002743094e-14, -8.146543420263943e-16,  8.851068483827174e-18, -9.762048766410976e-20,  1.179467659421144e-21,
 -4.276930566966592e-24,  7.700094242428038e-02, -1.570639454668553e-03,  2.333154420615643e-05, -2.957930139864864e-07,  3.299084334980595e-09, -3.231767699484347e-11,
  2.559266728216877e-13, -1.377869434605750e-15, -6.984350782240929e-18,  2.852972665652883e-19, -3.837464425901469e-21,  1.279380195665583e-22,  2.133304274024691e-01,
 -4.175592997581047e-03,  5.601729525066425e-05, -5.731229626067161e-07,  3.907757922728100e-09, -3.671848666879058e-13, -5.325385174323915e-13,  9.769875399223694e-15,
 -1.163948974340645e-16,  6.227631429761096e-19,  9.891908326302753e-21, -6.011193721264335e-23,  4.159586036039187e-01, -7.588422557192072e-03,  8.373525609204542e-05,
 -4.709349757169328e-07, -3.426016409030598e-09,  1.212398664629126e-10, -1.429707874793060e-12,  1.713508698195124e-15,  2.203917628708771e-16, -4.435598484630682e-18,
  4.009702476438999e-20,  6.928401034055118e-22,  6.809131187626944e-01, -1.108771643340918e-02,  8.200786241793876e-05,  3.314623337449785e-07, -1.579458179719599e-08,
  1.234519203157272e-10,  1.599891191152045e-12, -4.848909506572602e-14,  2.390804053601085e-16,  7.967030456027586e-18, -1.596981760379126e-19,  1.006104939264470e-21,
  9.989002342944627e-01, -1.351032291140913e-02,  2.716198872009838e-05,  1.528931059964371e-06, -1.233417050115059e-08, -2.689041452168396e-10,  4.548020554201089e-12,
  4.116696381057958e-14, -1.598824197601310e-15, -2.196912789033879e-18,  5.142550778485911e-19, -1.695553170912786e-21,  1.349072816723994e+00, -1.324201981130006e-02,
 -7.575767426507952e-05,  1.554993989206764e-06,  2.309654258719515e-08, -3.182991159168945e-10, -8.272295583065874e-12,  6.713651282247768e-14,  3.043860814517769e-15,
 -1.317085597746138e-17, -1.180065381032532e-18,  1.844681620056866e-21,  1.687333548768802e+00, -8.962204582864427e-03, -1.421830503328418e-04, -8.372578645338653e-07,
  2.115376545750911e-08,  6.231263077096101e-10,  3.885253633132930e-12, -1.639876398285015e-13, -4.706211408954083e-15, -2.318052215164852e-17,  1.579467435154306e-18,
  4.249001994922809e-20,  1.933459846872161e+00, -2.407573290400733e-03, -6.196770893120288e-05, -1.313564397551802e-06, -2.325042665529508e-08, -3.214897530291066e-10,
 -2.425101907696197e-12,  3.674422910912902e-14,  2.116170880571606e-15,  5.559929044684991e-17,  1.000598429479945e-18,  1.078511049119826e-20,  7.894205368437658e-03,
 -1.576572149662808e-04,  2.352468406293353e-06, -3.114936375950609e-08,  3.834642466070843e-10, -4.543951985475308e-12,  5.093260021070936e-14, -5.787420892119525e-16,
  6.165821711089507e-18, -5.155337248837521e-20,  1.172742354194525e-21,  2.183795540257698e-24,  7.107041377771485e-02, -1.397334835982282e-03,  2.007845481538289e-05,
 -2.478582229257837e-07,  2.710934971082864e-09, -2.665494821889259e-11,  2.156151095826097e-13, -1.455423363883379e-15,  1.911744776621797e-18,  2.472582633189479e-19,
  1.911725185664293e-21,  1.221688715304951e-22,  1.974822694785474e-01, -3.753906265400892e-03,  4.951270921324781e-05, -5.112662868636049e-07,  3.792685600878506e-09,
 -1.026289756161268e-11, -3.072157396465665e-13,  6.480413419026112e-15, -8.670770117132891e-17,  1.048070898880842e-18,  1.292794486932761e-20,  1.464716199364569e-22,
  3.869077986918003e-01, -6.941904958624301e-03,  7.782919323754774e-05, -5.081883180456752e-07, -1.336925339402684e-09,  8.816446916375533e-11, -1.304468810340825e-12,
  6.575984975269313e-15,  9.627589546686605e-17, -2.292794726876068e-18,  6.526153059483322e-20,  4.306119906044606e-22,  6.378937666105269e-01, -1.041984048518731e-02,
  8.455614949670616e-05,  1.001445111030253e-07, -1.304610163171100e-08,  1.466453287096037e-10,  3.843333921140665e-13, -3.735597823456753e-14,  4.274578651914513e-16,
  3.078864129342507e-18, -7.363932989969580e-20,  2.502867766341168e-21,  9.454045084307510e-01, -1.322336188443141e-02,  4.416763631791574e-05,  1.294778602548324e-06,
 -1.655704995418552e-08, -1.516371839117586e-10,  4.999591114962226e-12, -7.516394387451725e-15, -1.337335799732672e-15,  1.566484687207412e-17,  3.572850729214380e-19,
 -4.699965782540163e-21,  1.295018941944767e+00, -1.376770918358505e-02, -5.512329339124371e-05,  1.863652177736053e-06,  1.495135025920498e-08, -4.840212840865704e-10,
 -5.161915491612538e-12,  1.484530304396944e-13,  1.807882819493814e-15, -5.132714194229012e-17, -5.573143426858664e-19,  2.470471116146126e-20,  1.649155572336354e+00,
 -1.013313248434528e-02, -1.497767227658442e-04, -3.959032365837293e-07,  3.408748915734486e-08,  6.440111626019035e-10, -2.831957130267432e-12, -3.120734595871565e-13,
 -3.955048075262422e-15,  7.639161460570815e-17,  3.272020245725951e-18,  2.435616648624034e-20,  1.922728644052415e+00, -2.973196991924188e-03, -8.018360483641893e-05,
 -1.739657872982991e-06, -3.013043937258181e-08, -3.575469416659787e-10, -8.728991851098747e-14,  1.450454858988070e-13,  4.936323026337360e-15,  1.029920920309358e-16,
  1.269125718831278e-18, -3.538205514349188e-21,  7.298987307679935e-03, -1.402348359983397e-04,  2.012690609768047e-06, -2.567967927472861e-08,  3.036055847506937e-10,
 -3.495118874807262e-12,  3.727643517774195e-14, -4.019594613081176e-16,  5.164782284584705e-18, -4.446044911566491e-21,  1.096272266126904e-21, -9.806609587138337e-24,
  6.578448228662612e-02, -1.247905774574292e-03,  1.734768707477412e-05, -2.084805118432160e-07,  2.226356051228997e-09, -2.195330707700528e-11,  1.772171284061868e-13,
 -1.228022489969370e-15,  1.324552127800681e-17,  4.021488808610497e-19,  4.746778805458988e-21, -2.834827753780319e-23,  1.832214244205094e-01, -3.381331680271094e-03,
  4.373369643585524e-05, -4.525694536428602e-07,  3.526934940420850e-09, -1.573347019765952e-11, -1.581592016749377e-13,  4.420258744702156e-15, -3.841457944534523e-17,
  1.651876176104271e-18,  1.499292627195124e-20, -1.687268028436397e-22,  3.603464734238150e-01, -6.343904803737969e-03,  7.165545143096726e-05, -5.171057627729807e-07,
  1.297494834540202e-10,  5.935737036433526e-11, -1.085859384926173e-12,  8.866942769090260e-15,  6.366739524593745e-17,  5.033045003068532e-19,  6.774581548605690e-20,
 -5.141793563845642e-22,  5.975702003067646e-01, -9.741908383938533e-03,  8.460296499297684e-05, -8.495535807923606e-08, -1.009731255704045e-08,  1.449507357940400e-10,
 -4.563058560697897e-13, -2.226443961941955e-14,  5.103965950634172e-16,  2.130713635704468e-18,  1.486071014679631e-20,  9.363372488023579e-22,  8.933095369921064e-01,
 -1.281256375320824e-02,  5.803615189422080e-05,  1.011972322969061e-06, -1.842939385910356e-08, -3.839892562684185e-11,  4.292030261005133e-12, -3.894968979905176e-14,
 -5.682975689564661e-16,  2.556586674360612e-17,  1.305306068376822e-19, -5.794183718710827e-21,  1.239212495364298e+00, -1.411594548825352e-02, -3.166130085565482e-05,
  2.020207190953290e-06,  4.394916712236661e-09, -5.532947962078474e-10, -4.905621849753695e-13,  1.747312683768539e-13, -1.565854254125950e-16, -4.987208016177981e-17,
  6.180928848750412e-19,  2.293299940214095e-20,  1.606210857097019e+00, -1.134013857388480e-02, -1.508507250533595e-04,  2.456589538427225e-07,  4.552052923326955e-08,
  4.603618779177681e-10, -1.274170417967507e-11, -3.684222369220108e-13,  1.229027066681247e-15,  2.079362141996656e-16,  2.672125572400132e-18, -6.157710181390900e-20,
  1.909408426964847e+00, -3.706900776511471e-03, -1.041837227692060e-04, -2.277317101271003e-06, -3.686536342521767e-08, -2.893015342502824e-10,  6.807300724728065e-12,
  3.710586364140395e-13,  9.397949303608728e-15,  1.361762624769548e-16, -1.061334967495976e-19, -7.266768586702917e-20,  6.768409314420046e-03, -1.252883694126923e-04,
  1.731521626328632e-06, -2.133609027087793e-08,  2.418348073443345e-10, -2.716742453743955e-12,  2.836427876603353e-14, -2.321459390519582e-16,  5.609414239153120e-18,
  2.161691849609306e-20, -5.527800910368680e-23, -4.535837653311192e-23,  6.105539041431535e-02, -1.118557695251361e-03,  1.504588102490199e-05, -1.761508990179262e-07,
  1.827345465384244e-09, -1.805028405077873e-11,  1.511644668354564e-13, -5.436037755300504e-16,  3.002042869257620e-17,  4.744576324148985e-19, -3.729225987947004e-21,
 -3.810445805886624e-22,  1.703627629348286e-01, -3.052251169727332e-03,  3.863050716475559e-05, -3.988217678382139e-07,  3.183860937907559e-09, -1.812451754856034e-11,
 -4.198881732980057e-14,  4.229581976514041e-15,  2.785947392676374e-17,  1.853160359477081e-18, -1.210529982750441e-20, -1.141863420775587e-21,  3.360781991139470e-01,
 -5.795365516056998e-03,  6.549746885546059e-05, -5.068596116482211e-07,  1.077724628816600e-09,  3.654002799317120e-11, -8.030205708932045e-13,  1.164097924433073e-14,
  1.201496652312356e-16,  2.199904167789141e-18,  1.344803321902066e-21, -2.651011279091546e-21,  5.599461647284892e-01, -9.071693445048478e-03,  8.270740160757125e-05,
 -2.240930614847342e-07, -7.348450124630930e-09,  1.284398817131555e-10, -8.385673332135869e-13, -4.577550714422119e-15,  5.970959854231369e-16,  2.344197740686786e-18,
 -3.831378115848120e-20, -3.691384030475797e-21,  8.430576598938466e-01, -1.230473661839119e-02,  6.840230633208261e-05,  7.161583696188726e-07, -1.826254566324426e-08,
  5.034096525453736e-11,  3.089261057914254e-12, -4.195043805076287e-14,  3.766431867008620e-16,  2.475675672852906e-17, -2.009198266068755e-19, -9.858300172176516e-21,
  1.182396251895052e+00, -1.427190754735028e-02, -7.359671015789836e-06,  2.002993018741940e-06, -6.401633306562700e-09, -5.083720721771786e-10,  4.105192885611718e-12,
  1.472990179989402e-13, -1.333038635432682e-15, -1.293451619923863e-17,  9.898729818899786e-19, -9.283501853676515e-21,  1.558473607285981e+00, -1.252219612000018e-02,
 -1.432920143050213e-04,  1.027697261412351e-06,  5.088865547644977e-08,  4.270292524079101e-11, -2.127459517486463e-11, -1.958953413320392e-13,  9.699106346499132e-15,
  2.297459312581472e-16, -2.251179085062651e-18, -1.506963642517970e-19,  1.892726169349943e+00, -4.660071007747727e-03, -1.352015408773088e-04, -2.900374353833995e-06,
 -3.998195919014913e-08,  3.703513572974269e-11,  2.209058540689315e-11,  7.407612157151937e-13,  1.307914247099496e-14,  2.526471534129751e-17, -6.697986087147093e-18,
 -2.444202358705335e-19,  6.293426351267158e-03, -1.123984482746322e-04,  1.497026303363307e-06, -1.786626202437815e-08,  1.938883529401405e-10, -2.093123130525846e-12,
  2.446507436672239e-14, -4.522451313411775e-17,  5.761780862195636e-18, -3.174676718794546e-20, -2.844883012770360e-21, -7.607952774036780e-23,  5.680917338137197e-02,
 -1.006175025114117e-03,  1.309621170081725e-05, -1.496073359235903e-07,  1.502007621559822e-09, -1.448261973435138e-11,  1.515316769128131e-13,  6.219762234755092e-16,
  3.935907827248978e-17, -1.187381235928915e-19, -2.818102349378765e-20, -6.796753924803951e-22,  1.587427220046820e-01, -2.761512242234716e-03,  3.413827305713238e-05,
 -3.507918560615266e-07,  2.821647122498771e-09, -1.755486165497981e-11,  9.761879543241504e-14,  5.977499526239291e-15,  7.085741453001847e-17,  5.464240400151119e-20,
 -8.423546907824847e-20, -1.992052138619128e-21,  3.139066544358360e-01, -5.295372562744282e-03,  5.953966311979845e-05, -4.846972224535022e-07,  1.644738784053867e-09,
  2.168049568890081e-11, -4.127909899717514e-13,  1.649414489434502e-14,  1.660603718819302e-16, -7.356301598596090e-19, -1.616082813529375e-19, -4.438533364497616e-21,
  5.249631048681977e-01, -8.422601408930851e-03,  7.939403814172062e-05, -3.222152865777549e-07, -4.979869879432896e-09,  1.089931623062974e-10, -6.909470685185892e-13,
  1.517645246745498e-14,  6.012751896139905e-16, -3.881353995548787e-18, -3.032445618510845e-19, -7.723843609192270e-21,  7.949806971332329e-01, -1.172800913666119e-02,
  7.528826581128260e-05,  4.356755482161219e-07, -1.659918884940051e-08,  1.124950979113288e-10,  2.200926123394945e-12, -1.813232454946238e-14,  1.004460750366331e-15,
  6.523770691010264e-18, -7.415874072175944e-19, -1.387740201510048e-20,  1.125339669300481e+00, -1.423711384303488e-02,  1.574711890028280e-05,  1.825893023769637e-06,
 -1.527559650108075e-08, -3.653643438564506e-10,  7.608965671699540e-12,  1.033779856602517e-13, -1.282963843981419e-15,  7.917212799855579e-18, -1.719984377921735e-19,
 -3.942454706503704e-20,  1.506189647474292e+00, -1.360548276331461e-02, -1.261393964870843e-04,  1.819861390978046e-06,  4.640289274729950e-08, -4.919417114491344e-10,
 -2.137127270073261e-11,  2.162916547511750e-13,  1.474071851752262e-14,  8.578978669068783e-18, -8.431589445775090e-18, -9.894002062966515e-20,  1.871687235876395e+00,
 -5.891494515565532e-03, -1.737052521955457e-04, -3.497463012253745e-06, -3.202009467272347e-08,  8.618003134944268e-10,  4.831913944306572e-11,  1.097378575136052e-12,
  6.016408156728415e-15, -5.171682751752247e-16, -2.158112484761301e-17, -3.913332609806120e-19,  5.866497661827657e-03, -1.012300557612542e-04,  1.299965998621428e-06,
 -1.506712383441338e-08,  1.578947542037064e-10, -1.502324421931695e-12,  2.541417075950982e-14,  9.247983783703470e-17,  1.791238823506183e-18, -2.079549015318695e-19,
 -5.645866595785083e-21, -3.029089823566450e-23,  5.298319192320689e-02, -9.081986280097710e-04,  1.143621999873912e-05, -1.276864924864483e-07,  1.250819270112715e-09,
 -1.050772260346072e-11,  1.840503422762488e-13,  1.537968350320934e-15,  7.810576799146305e-18, -1.805392047332019e-18, -5.327607888490709e-20, -2.674467238914185e-22,
  1.482172749638666e-01, -2.504502134684642e-03,  3.018864115130392e-05, -3.082657081311352e-07,  2.508768957558707e-09, -1.297300422892736e-11,  2.914088832137263e-13,
  7.457618098339956e-15, -8.269380020789139e-18, -4.952147899762278e-18, -1.576757548410272e-19, -7.842856414952015e-22,  2.936416334276469e-01, -4.841843077510423e-03,
  5.389421021438005e-05, -4.552838006085623e-07,  2.019494290432103e-09,  1.783754980272504e-11,  1.083758686811004e-13,  1.976183798681276e-14, -2.227660206668038e-17,
 -1.084638129601685e-17, -3.257056858133395e-19, -1.830949823209393e-21,  4.925168153130284e-01, -7.804109278718227e-03,  7.511888754008869e-05, -3.851743036441594e-07,
 -2.921083086517886e-09,  9.945461319126027e-11, -3.818170790508394e-14,  2.917988681346222e-14,  1.628631135753128e-16, -2.247131207633096e-17, -5.954997339506419e-19,
 -3.309753500689669e-21,  7.493002582954716e-01, -1.110911651318243e-02,  7.900608095677574e-05,  1.908510148524892e-07, -1.384333569660164e-08,  1.628403252526260e-10,
  2.130968723438989e-12,  1.089137006871757e-14,  5.662296382804144e-16, -3.420090013765450e-17, -1.229351484163293e-18, -4.573057401037451e-21,  1.068775424448267e+00,
 -1.402813532411946e-02,  3.598487099777992e-05,  1.533850192957762e-06, -2.054557981868818e-08, -1.525238642991144e-10,  9.941947616145014e-12,  6.206824505534774e-14,
 -1.549636137858290e-15, -3.394109993788812e-17, -1.824241667902266e-18, -2.571143190197353e-20,  1.449904417356784e+00, -1.451553775394036e-02, -1.002534418545155e-04,
  2.458726417135616e-06,  3.219318821606927e-08, -8.810748850434711e-10, -9.163805188209944e-12,  6.223073854607921e-13,  8.391842902202964e-15, -3.635765612044126e-16,
 -8.729295624626619e-18,  9.637925997158926e-20,  1.845066177594469e+00, -7.455952433774149e-03, -2.179469727175837e-04, -3.798334941219242e-06, -6.834336919829159e-10,
  2.387996949410055e-09,  7.757568215388649e-11,  7.954841439726005e-13, -3.162155860028909e-14, -1.634022015536206e-15, -2.963641818387929e-17,  2.669095710882709e-19,
  5.481289690975093e-03, -9.151266607868974e-05,  1.133436685832514e-06, -1.274714674566803e-08,  1.341557863264675e-10, -8.633261492375688e-13,  2.736786800557355e-14,
 -1.343040085325713e-17, -9.645223223461543e-18, -4.093601985320258e-19, -2.749611791955349e-21,  2.000843222949384e-22,  4.952413406647724e-02, -8.225119376488032e-04,
  1.001794232608414e-05, -1.091003836855095e-07,  1.088162008004955e-09, -5.620402659358475e-12,  2.178960377870535e-13,  3.388395771881483e-16, -9.438192038365573e-17,
 -3.703508458322218e-18, -2.625469719274687e-20,  1.847640977888028e-21,  1.386597973861093e-01, -2.277124282825828e-03,  2.672315041788453e-05, -2.697531715916963e-07,
  2.335147115763897e-09, -3.711970374808004e-12,  4.609960310498069e-13,  3.129020965054323e-15, -2.967548846543796e-16, -1.058605603812478e-17, -7.925548733134865e-20,
  5.374938798474222e-21,  2.751027804109588e-01, -4.431964775213241e-03,  4.863740528551147e-05, -4.197953948347001e-07,  2.444795856199431e-09,  2.654612981873243e-11,
  5.749292293683526e-13,  1.028507904443783e-14, -6.419441015428190e-16, -2.258966238235671e-17, -1.664594221579641e-19,  1.124376652420853e-20,  4.624720860435464e-01,
 -7.222288848142583e-03,  7.028261102116494e-05, -4.157715064140058e-07, -8.757099189691540e-10,  1.080176683349034e-10,  6.971278956116334e-13,  1.684951568799893e-14,
 -1.064859895467096e-15, -4.391337116781680e-17, -3.020850880237711e-19,  2.071807019635948e-20,  7.061374281826928e-01, -1.047140622981221e-02,  8.008414215437066e-05,
 -1.686518799890257e-09, -1.004588251753387e-08,  2.182127901203386e-10,  2.436991590158006e-12, -6.341794017996362e-17, -1.517721705537596e-15, -7.793355688129802e-17,
 -6.478056351832374e-19,  3.807197568163450e-20,  1.013347127654993e+00, -1.367236509486375e-02,  5.236135638035044e-05,  1.194151756939561e-06, -2.110492673958306e-08,
  9.966548068282493e-11,  1.069372954839766e-11, -2.231470527908515e-14, -4.190946051554510e-15, -1.100837295318978e-16, -1.354192311081590e-18,  6.071148105151270e-20,
  1.390435610988168e+00, -1.519217571833792e-02, -6.826127630038534e-05,  2.827189686651581e-06,  1.388135856930253e-08, -8.757970917964307e-10,  9.638001403756688e-12,
  6.259234072827110e-13, -9.417680088564370e-15, -5.690855391075675e-16, -1.785957924831852e-19,  2.846842721447396e-19,  1.811471926654253e+00, -9.377720611289822e-03,
 -2.616747699721767e-04, -3.321283952675339e-06,  6.665094724292030e-08,  4.341368814329276e-09,  7.549868069850835e-11, -1.330683382049453e-12, -1.038182742324200e-13,
 -1.995564857729718e-15,  2.900289804740556e-17,  2.609071633902047e-18,  5.132455303740190e-03, -8.302162945799448e-05,  9.928934392995370e-07, -1.070403166136361e-08,
  1.231880121188487e-10, -2.597179838661130e-13,  2.043536650109413e-14, -5.554076832359220e-16, -2.325264825063063e-17, -2.346841411267389e-19,  1.408987510385065e-20,
  5.429758942972191e-22,  4.638649066357296e-02, -7.473159489076840e-04,  8.810402719934239e-06, -9.230944433216477e-08,  1.026520374437786e-09, -7.437438672835283e-13,
  1.648245589636217e-13, -4.798716517541891e-15, -2.179244828212094e-16, -2.127486285224507e-18,  1.291055060854358e-19,  5.011992500369057e-21,  1.299592636662258e-01,
 -2.075653754887781e-03,  2.370980868087597e-05, -2.323777241905190e-07,  2.371569821313375e-09,  6.970849826900755e-12,  3.575388441033879e-13, -1.244007402690717e-14,
 -6.513577883354095e-16, -6.103194771329382e-18,  3.739002643290505e-19,  1.465520096513535e-20,  2.581222138313585e-01, -4.062305224184287e-03,  4.385465542611069e-05,
 -3.756352606345092e-07,  3.121772259723485e-09,  4.071231941470344e-11,  4.513190983955160e-13, -2.321601416894936e-14, -1.399223558804484e-15, -1.312307437984957e-17,
  7.908012225283374e-19,  3.113679230603905e-20,  4.346757419861759e-01, -6.680052643791331e-03,  6.528375097843562e-05, -4.115189442070073e-07,  1.463945252871542e-09,
  1.250722737917638e-10,  4.512652457772122e-13, -4.238064800490626e-14, -2.538236610063492e-15, -2.614994620654697e-17,  1.474010039460540e-18,  5.813019610914538e-20,
  6.655296264303847e-01, -9.833194718526459e-03,  7.925349964774242e-05, -1.244622611213384e-07, -5.136581532325003e-09,  2.685234741753890e-10,  1.322793422553214e-12,
 -9.402296311879775e-14, -4.198981502590319e-15, -4.967997012724211e-17,  2.569806833123835e-18,  1.053040078764510e-19,  9.595784112697909e-01, -1.320165574345550e-02,
  6.477470995379176e-05,  8.858296982837290e-07, -1.669040756159762e-08,  3.298006767571823e-10,  7.563122991301512e-12, -2.226494098325628e-13, -8.115711456412035e-15,
 -6.999242874508138e-17,  4.370590312578905e-18,  1.947434985993529e-19,  1.328793304452283e+00, -1.560000838723677e-02, -3.352541846341850e-05,  2.926840215155646e-06,
 -1.562611660011070e-10, -4.865469500373872e-10,  2.001150696137424e-11,  2.284627132633150e-14, -2.656656010731946e-14, -2.770346262524720e-16,  1.588349634158390e-17,
  4.297497925604010e-19,  1.769556817757585e+00, -1.160526574090313e-02, -2.919999533730528e-04, -1.481944093536730e-06,  1.664073987543638e-07,  5.278732270611077e-09,
 -1.598594988951934e-11, -5.317216717319231e-12, -1.219335260520664e-13,  1.953702612303722e-15,  1.696697728960357e-16,  2.578402376614700e-18,  4.815488536780324e-03,
 -7.555902256609168e-05,  8.761678013604009e-07, -8.754783301383195e-09,  1.211887548169685e-10, -4.271138343580612e-14, -5.754194254675027e-15, -1.279009202344449e-15,
 -1.587933559360023e-17,  7.792220174694185e-19,  3.338505381778548e-20,  7.980323822629947e-23,  4.353157189884026e-02, -6.809843872562034e-04,  7.801280630176576e-06,
 -7.584951754717598e-08,  1.036111787034749e-09,  7.873702539902986e-13, -6.905000690693602e-14, -1.156787151894123e-14, -1.490957885514347e-16,  7.200066929517994e-18,
  3.077424902589493e-19,  7.619656097306199e-22,  1.220192724187367e-01, -1.896471489749631e-03,  2.115462894741823e-05, -1.930131793159645e-07,  2.556026252446623e-09,
  8.948538966578265e-12, -2.876398145780900e-13, -3.264342014097891e-14, -4.480833527834792e-16,  2.106936970862151e-17,  8.995125818252401e-19,  2.372392537937932e-21,
  2.425474025149494e-01, -3.728585123286120e-03,  3.967466905399024e-05, -3.188993684290009e-07,  3.964693229914361e-09,  3.853316108924575e-11, -8.373066686700789e-13,
 -6.673999011735952e-14, -9.741882589762742e-16,  4.461502540248682e-17,  1.918628142462357e-18,  5.490877116360003e-21,  4.089696103344279e-01, -6.176946116618664e-03,
  6.056900197515549e-05, -3.680705387512471e-07,  3.928339299072710e-09,  1.121481006158585e-10, -1.903364799433155e-12, -1.222146857402716e-13, -1.802381423800348e-15,
  8.193150693481238e-17,  3.608014509370554e-18,  1.141279046024595e-20,  6.274540174154478e-01, -9.206124298170679e-03,  7.744652166031309e-05, -1.631395300454002e-07,
  2.559561019023030e-10,  2.527821656982447e-10, -3.264680192620689e-12, -2.279348398834750e-13, -3.014450449441426e-15,  1.429043954148859e-16,  6.500706902084400e-18,
  2.382058460632639e-20,  9.078698237793443e-01, -1.264492538289319e-02,  7.404490500719429e-05,  6.787514266402863e-07, -8.939983147498609e-09,  4.064665912499831e-10,
 -2.344734679118319e-12, -4.716460667463015e-13, -5.381167179602864e-15,  2.742054719578882e-16,  1.187031046122252e-17,  5.205225608736865e-20,  1.266078475243419e+00,
 -1.572834211929213e-02,  1.341347391006243e-06,  2.871008952491501e-06, -5.549310937252180e-09, -9.858530480540046e-11,  8.334642626462057e-12, -8.283497592033090e-13,
 -2.078749283709956e-14,  6.966078449016375e-16,  2.993175235150838e-17,  1.288674374044506e-20,  1.718425096552683e+00, -1.395952677188246e-02, -2.905463380112234e-04,
  1.947095490273482e-06,  2.542653111385475e-07,  2.782783790327120e-09, -1.988727473089247e-10, -6.683784080992215e-12,  7.837863228658216e-14,  8.703778853404981e-15,
  9.205487699159429e-17, -7.516359767749090e-18,  4.526652080248376e-03, -6.893712330322639e-05,  7.826571742421030e-07, -6.842889260754933e-09,  1.158986171985260e-10,
 -6.331789868145585e-13, -4.272213896747559e-14, -1.101916846106832e-15,  3.266621401811219e-17,  1.688220139085944e-18, -1.579687787133642e-21, -1.717715451123473e-21,
  4.092708828631510e-02, -6.219330577998357e-04,  6.990465242186711e-06, -5.935173301401943e-08,  1.007582432838971e-09, -4.974356025182829e-12, -4.047170938208382e-13,
 -1.001058088214917e-14,  2.992444407436869e-16,  1.559523519356521e-17, -1.413340320465713e-20, -1.585781019102636e-20,  1.147581859213791e-01, -1.735794309432551e-03,
  1.908764549147230e-05, -1.513886269894740e-07,  2.587409692129517e-09, -9.602715909834648e-12, -1.241353419920884e-12, -2.845921350457327e-14,  8.646076874634463e-16,
  4.570614598982114e-17, -3.830846164461252e-20, -4.646302706309284e-20,  2.282452070444458e-01, -3.425368397248336e-03,  3.624854548828197e-05, -2.510654518060849e-07,
  4.373011257990441e-09, -5.513187108525422e-12, -2.800501729957753e-12, -5.855514459054395e-14,  1.818492703704989e-15,  9.750187484389546e-17, -6.972552872371633e-20,
 -9.933360192821000e-20,  3.852046620190826e-01, -5.708844740217060e-03,  5.659188833547381e-05, -2.909916231676793e-07,  5.418741434052798e-09,  2.257692466135961e-11,
 -5.499850471443752e-12, -1.069103085163370e-13,  3.390359027332895e-15,  1.823040377276910e-16, -9.633260728163571e-20, -1.872105181738342e-19,  5.918568222124857e-01,
 -8.593967936207153e-03,  7.566023220508970e-05, -1.251440219746316e-07,  3.981372523122503e-09,  9.344371571337574e-11, -9.880839240475609e-12, -1.953674448199430e-13,
  6.201000950813474e-15,  3.258210171930512e-16, -1.157493935583432e-19, -3.401308233341098e-19,  8.585237541338770e-01, -1.202184299475813e-02,  8.157725570237879e-05,
  5.929973203543576e-07, -2.493182383744884e-09,  1.845846552532117e-10, -1.584843501635839e-11, -4.002051627995117e-13,  1.195746577128516e-14,  6.087818140671124e-16,
 -4.353625791821113e-19, -6.455188971682782e-19,  1.203402472663538e+00, -1.558143493149418e-02,  3.520686436101658e-05,  2.768451711059876e-06, -7.660623055052579e-09,
 -2.210210633492395e-10, -1.886558578496075e-11, -8.845249495426464e-13,  2.216562185569288e-14,  1.471742342180088e-15, -3.333986024327503e-18, -1.584873444253132e-18,
  1.658186974444737e+00, -1.611901369876023e-02, -2.419283944746042e-04,  6.146532199455936e-06,  2.497568606060250e-07, -3.656990692308426e-09, -3.033629690982010e-10,
  7.292756543656649e-13,  3.538549315299513e-13,  3.413171240273214e-15, -3.691240459479531e-16, -8.691465076085630e-18,  4.262948772059630e-03, -6.297416559377532e-05,
  7.110483683950238e-07, -5.153211228315964e-09,  9.131697897062251e-11, -1.858896502451780e-12, -5.082841179247488e-14,  7.410707090873266e-16,  7.223447104532690e-17,
 -2.264400964281487e-20, -7.831780936518742e-20, -9.025361346072839e-22,  3.854706493428037e-02, -5.685955183080710e-04,  6.369780103678840e-06, -4.462357926394184e-08,
  7.959206115344453e-10, -1.649099779147428e-11, -4.759823629795597e-13,  6.937159576551570e-15,  6.650379740754520e-16, -1.988179658792444e-19, -7.236689424978024e-19,
 -8.357115538011409e-21,  1.081098652573433e-01, -1.589682188668873e-03,  1.750722783322847e-05, -1.133413966571613e-07,  2.055109808769499e-09, -4.442924044031202e-11,
 -1.431004608723470e-12,  2.083203530454167e-14,  1.938049829720371e-15, -5.484191260537645e-19, -2.123601850586508e-18, -2.462591898453007e-20,  2.151062648692835e-01,
 -3.146275970156054e-03,  3.363894961394397e-05, -1.860308471056564e-07,  3.504759468797435e-09, -8.283127017304150e-11, -3.155912516834295e-12,  4.581515157379038e-14,
  4.111263532214017e-15, -1.225054171930964e-18, -4.547830047315628e-18, -5.304320060832129e-20,  3.632547004628849e-01, -5.268619509129257e-03,  5.360976992552474e-05,
 -2.085745113792624e-07,  4.395438217569979e-09, -1.274811195641056e-10, -6.095925282158616e-12,  8.798997150132094e-14,  7.676356323238653e-15, -3.155858484017127e-18,
 -8.582682585047672e-18, -1.006354846623875e-19,  5.586836051304035e-01, -7.993558865510324e-03,  7.455683160102466e-05, -6.069993222335205e-08,  3.194959971301648e-09,
 -1.769070440116707e-10, -1.100348826350230e-11,  1.572840770145781e-13,  1.381937201423097e-14, -1.036374405570736e-17, -1.561526245362562e-17, -1.823638774502284e-19,
  8.117859111403393e-01, -1.134130781353925e-02,  8.850076378076816e-05,  5.591878128005207e-07, -3.208675231850270e-09, -2.683924797629169e-10, -1.878291333576382e-11,
  2.677925096600381e-13,  2.589912880896813e-14, -3.875356197689416e-17, -2.978433711596106e-17, -3.299855253560026e-19,  1.141846817574772e+00, -1.516950768275207e-02,
  6.744906174790420e-05,  2.579528168033314e-06, -1.800797873482250e-08, -8.464580259952060e-10, -2.677718751385612e-11,  4.984969609873101e-13,  5.452798736409816e-14,
 -1.425242111043271e-16, -7.032799577701885e-17, -5.801258074714015e-19,  1.590392697613112e+00, -1.769947251333467e-02, -1.478130317511835e-04,  9.192249524939234e-06,
  1.121461480099396e-07, -9.413623105280812e-09, -1.288665177178729e-10,  1.078063094327718e-11,  1.751665123851687e-13, -1.257668261052526e-14, -2.511591048654078e-16,
  1.455686163625817e-17,  4.022068102179020e-03, -5.751149730177379e-05,  6.565648189639358e-07, -4.044317585880165e-09,  4.488652512861493e-11, -2.591577575003772e-12,
 -2.253304706278565e-15,  2.428524680915436e-15,  1.641346945919308e-17, -2.736447391035743e-18, -2.762753681899992e-20,  2.962112978308976e-21,  3.637147605791352e-02,
 -5.195913206236313e-04,  5.898091254038257e-06, -3.504089177915722e-08,  3.792484039625673e-10, -2.339109380115243e-11, -2.566405409269628e-14,  2.245776524138170e-14,
  1.496233607644781e-16, -2.526841505356490e-17, -2.543890843889998e-19,  2.742221379866019e-20,  1.020233248440117e-01, -1.454583941444154e-03,  1.630988665395843e-05,
 -8.911611763045454e-08,  9.042702656943669e-10, -6.538735980386745e-11, -1.021202022098776e-13,  6.596447541435925e-14,  4.269919475467632e-16, -7.406389685084765e-17,
 -7.403515808434006e-19,  8.080182020341013e-20,  2.030463958776687e-01, -2.885289988900449e-03,  3.167684593408878e-05, -1.466326274802281e-07,  1.266566892182165e-09,
 -1.296458572376005e-10, -2.942040502479683e-13,  1.411898660256582e-13,  8.748975076752533e-16, -1.584038199315870e-16, -1.559793794393594e-18,  1.742693006876437e-19,
  3.430235017964590e-01, -4.848796674360714e-03,  5.142239072471279e-05, -1.652818543130106e-07,  7.164678989255648e-10, -2.190039327130225e-10, -6.938273982008159e-13,
  2.649077106212084e-13,  1.547425459305622e-15, -2.986273951888164e-16, -2.849968064610924e-18,  3.326210715994128e-19,  5.278984339293059e-01, -7.399499964563472e-03,
  7.397806899393439e-05, -4.988590784267516e-08, -2.386671914662637e-09, -3.429460232676793e-10, -1.342547995854713e-12,  4.721502149328246e-13,  2.552807217793878e-15,
 -5.426968134105126e-16, -4.837814571883908e-18,  6.157701735877923e-19,  7.678772431542487e-01, -1.060788134491993e-02,  9.465732525395643e-05,  4.445482665588057e-07,
 -1.202920697978077e-08, -5.452356096578956e-10, -1.553298040523135e-12,  8.450753977109407e-13,  4.035033996001734e-15, -1.026396933607522e-15, -7.728940420364689e-18,
  1.202822716926831e-18,  1.082435163785229e+00, -1.451247231180550e-02,  9.602385104140086e-05,  2.129090462982507e-06, -3.930501591863503e-08, -1.148510234506072e-09,
  7.030731523633642e-12,  1.640487769947657e-12,  3.586243471181321e-15, -2.267446010866219e-15, -8.883371755663583e-18,  2.892373155880292e-18,  1.517951887017205e+00,
 -1.842510964454107e-02, -3.320202638795792e-05,  9.420626537544173e-06, -8.124728106435627e-08, -8.703841418187859e-09,  1.777080357577539e-10,  8.614441299942478e-12,
 -2.841930850869846e-13, -8.352966329855128e-15,  4.084314919779442e-16,  7.614874954205260e-18,  3.802231941077176e-03, -5.244474016548111e-05,  6.106853000213319e-07,
 -3.720724972396767e-09, -2.064008313369515e-12, -1.862386536901401e-12,  5.830646219557735e-14,  1.428530818363084e-15, -6.986732705441129e-17, -1.273846546609129e-18,
  8.549772173906949e-20,  9.796945979753836e-22,  3.438491690610480e-02, -4.740201069319559e-04,  5.499045506783903e-06, -3.253639722135955e-08, -4.462858439600437e-11,
 -1.676997829483241e-11,  5.336644064185947e-13,  1.317244917041244e-14, -6.459996040106474e-16, -1.169506255548950e-17,  7.910786634560010e-19,  8.980598297917702e-21,
  9.645939335846784e-02, -1.328233595606488e-03,  1.528542869814248e-05, -8.461931087005523e-08, -2.810191891571938e-10, -4.661872742888675e-11,  1.536500007457365e-12,
  3.844921472234251e-14, -1.897884766545363e-15, -3.384698329950830e-17,  2.328259530428009e-18,  2.588461543034390e-20,  1.920011529214506e-01, -2.638761970203417e-03,
  2.995569548877610e-05, -1.461621348631467e-07, -1.083072405565244e-09, -9.141650279045438e-11,  3.198161674106142e-12,  8.139525040540469e-14, -4.069754844707447e-15,
 -7.077960749182671e-17,  5.011321711197672e-18,  5.362275715371624e-20,  3.244383559925026e-01, -4.445482482604690e-03,  4.936716701061237e-05, -1.872702614115960e-07,
 -3.243046428960061e-09, -1.510358165285500e-10,  5.815464953981084e-12,  1.498657966965132e-13, -7.683198969308974e-15, -1.283678819176077e-16,  9.531468668660118e-18,
  9.517264907808080e-20,  4.994787008336777e-01, -6.811229586702169e-03,  7.293047301146919e-05, -1.402673072725532e-07, -8.526359592108107e-09, -2.253270920550909e-10,
  1.013368980473581e-11,  2.579926872199625e-13, -1.392140562620385e-14, -2.174145008351167e-16,  1.752460295650867e-17,  1.526958503293146e-19,  7.269883403885717e-01,
 -9.833358806598474e-03,  9.849234080840848e-05,  1.706879585181511e-07, -2.145889174709104e-08, -3.176436874674609e-10,  1.854363258652146e-11,  4.270793274038481e-13,
 -2.598479656571740e-14, -3.540362027503904e-16,  3.364913082480081e-17,  2.089916940528348e-19,  1.026066239135594e+00, -1.365438710981678e-02,  1.171125052074726e-04,
  1.340525712577754e-06, -5.710962652167883e-08, -4.874440644231959e-10,  4.320644570890222e-11,  6.170141513378264e-13, -5.635700550055061e-14, -4.718885116162766e-16,
  7.617221403517801e-17,  2.810224476906246e-21,  1.444389835476079e+00, -1.827203604070486e-02,  6.722603417548290e-05,  7.020925939416506e-06, -1.991896032963113e-07,
 -2.729747704268887e-09,  2.703275770386330e-10, -1.954184953018300e-12, -2.807870142980177e-13,  7.142942889029722e-15,  2.159010267109214e-16, -1.210704673256275e-17,
  3.601937326559855e-03, -4.774070292764704e-05,  5.648810800477590e-07, -3.966949802771956e-09, -2.347563995687209e-11, -2.539236204786546e-13,  6.489475680208079e-14,
 -8.791442455035873e-16, -5.610425779161160e-17,  1.700817159869320e-18,  3.792548516804420e-20, -2.357931074601297e-21,  3.257430393472249e-02, -4.316221567493092e-04,
  5.095745449579549e-06, -3.515715998359906e-08, -2.349820187409578e-10, -2.037931093130555e-12,  5.940110839740041e-13, -8.120195603468243e-15, -5.163196124092130e-16,
  1.575231053428316e-17,  3.476400211109547e-19, -2.183171238262637e-20,  9.138441141325591e-02, -1.210144887867014e-03,  1.421942544171292e-05, -9.433640649659933e-08,
 -7.952821576042696e-10, -4.157011023208375e-12,  1.709498052006227e-12, -2.382987278057540e-14, -1.501693082340428e-15,  4.644873991649711e-17,  1.002440276210973e-18,
 -6.433537262611179e-20,  1.819137262164321e-01, -2.406535933155988e-03,  2.805239117543854e-05, -1.734536890456032e-07, -2.040147865849921e-09, -2.976469162282146e-12,
  3.549310308924024e-12, -5.116156533107863e-14, -3.165283256582744e-15,  1.002403080739150e-16,  2.081639459429399e-18, -1.387019977097301e-19,  3.074305883435027e-01,
 -4.060591589675032e-03,  4.673610108244028e-05, -2.548429023759541e-07, -4.680135556387262e-09,  9.496857397497496e-12,  6.400885317469697e-12, -9.741732010378507e-14,
 -5.810225548732420e-15,  1.912376079616538e-16,  3.725583532572588e-18, -2.641814501269635e-19,  4.733864024937149e-01, -6.237086106866838e-03,  7.032724903835506e-05,
 -2.980213536273700e-07, -1.028881945852133e-08,  5.183586458852619e-11,  1.089990375937151e-11, -1.812975752790035e-13, -1.003636779231894e-14,  3.525509846986049e-16,
  6.142327067808479e-18, -4.854651070548414e-19,  6.892350921771635e-01, -9.043376518930222e-03,  9.835612002993645e-05, -1.969813229576051e-07, -2.289480398271002e-08,
  1.742817374039170e-10,  1.873890507178922e-11, -3.629601842122008e-13, -1.706641350672698e-14,  6.775588187347528e-16,  9.372468174556618e-18, -9.246513141150164e-19,
  9.734019426253567e-01, -1.266903633921104e-02,  1.275842658228234e-04,  4.073257522335501e-07, -5.613677018540733e-08,  5.570254710005782e-10,  3.652246831712719e-11,
 -9.397304075475185e-13, -2.864422469761041e-14,  1.539805076735440e-15,  9.403749517832603e-18, -2.011200387448664e-18,  1.372831636829460e+00, -1.745341663990118e-02,
  1.316078058241657e-04,  3.716194820324079e-06, -1.974420023114464e-07,  2.358094637912339e-09,  1.345005069388327e-10, -6.153531538686823e-12,  1.278059807543893e-14,
  6.501301382401578e-15, -1.755756810628554e-16, -3.001739920854992e-18,  3.419702227870717e-03, -4.341834307875894e-05,  5.151006064398378e-07, -4.309796313076870e-09,
 -1.575942224928549e-11,  8.674284974848638e-13,  2.530071317870402e-14, -1.594990366907766e-15,  9.336770226064026e-18,  1.413884923736142e-18, -3.873138789823141e-20,
 -6.349395372398021e-22,  3.092658671207453e-02, -3.926062121458652e-04,  4.652189100072441e-06, -3.857195480133767e-08, -1.588174354646949e-10,  8.197561202897925e-12,
  2.292216511414512e-13, -1.466887682732631e-14,  8.768589150706005e-17,  1.300225409459140e-17, -3.590098508184635e-19, -5.778672500087432e-21,  8.676387586786595e-02,
 -1.101127233316698e-03,  1.301471037194556e-05, -1.057999742132881e-07, -5.431201283066378e-10,  2.512257583707358e-11,  6.452180847108750e-13, -4.262724515517974e-14,
  2.662791282918288e-16,  3.776029504444000e-17, -1.060389530806153e-18, -1.640073631098635e-20,  1.727224830013698e-01, -2.190975050609009e-03,  2.578639423836266e-05,
 -2.025909137681637e-07, -1.407714655678602e-09,  5.719425300714409e-11,  1.289683064000960e-12, -8.986015411437394e-14,  6.031499229541241e-16,  7.940936687381262e-17,
 -2.294346222593689e-18, -3.309183617597061e-20,  2.919149146233552e-01, -3.700145411140972e-03,  4.325874450286041e-05, -3.210769909564670e-07, -3.254523173939691e-09,
  1.162257292954473e-10,  2.185397941725335e-12, -1.655780575742774e-13,  1.238530312107461e-15,  1.453004536641557e-16, -4.392413428160427e-18, -5.623695558435433e-20,
  4.495369007643358e-01, -5.691411233497751e-03,  6.583757770351853e-05, -4.423551726752374e-07, -7.182111844014746e-09,  2.286690867076251e-10,  3.347261097692771e-12,
 -2.901720369003558e-13,  2.547367951551725e-15,  2.499201082513695e-16, -8.129521678133475e-18, -8.354276359121626e-20,  6.546120460110437e-01, -8.271807008825854e-03,
  9.397716122663034e-05, -5.152438907734940e-07, -1.595483354085789e-08,  4.636519288401560e-10,  4.693882547744451e-12, -5.169462778605118e-13,  5.774581633517628e-15,
  4.226126462534231e-16, -1.565379024457279e-17, -9.516051043272084e-20,  9.247779913002397e-01, -1.164297339232023e-02,  1.275774472491989e-04, -3.642719910129073e-07,
 -3.868295139453837e-08,  1.064303255393318e-09,  5.372062317249049e-12, -1.039223479993134e-12,  1.708678600781559e-14,  7.050427030202691e-16, -3.501486970659899e-17,
  7.491229700112139e-20,  1.305336128125038e+00, -1.627143664760255e-02,  1.592191538204235e-04,  1.054324884708722e-06, -1.309857101059255e-07,  3.729884775961277e-09,
 -7.066462891091311e-12, -3.418795102438104e-12,  1.171185552027064e-13, -2.190697259335308e-16, -1.120747041346676e-16,  3.640852308492310e-18,  3.253938790529790e-03,
 -3.950723333837204e-05,  4.625105838856738e-07, -4.404251633447673e-09,  4.376832849887108e-12,  1.008220184775796e-12, -9.777860020574314e-15, -7.966775912322089e-16,
  3.133259175150359e-17, -9.901961967610705e-20, -2.648492189763227e-20,  7.851594183424776e-22,  2.942762250989142e-02, -3.572696032868622e-04,  4.180099980149154e-06,
 -3.963194744105254e-08,  2.997156724140698e-11,  9.415155758789132e-12, -9.269988877403426e-14, -7.284640608094506e-15,  2.887162793086504e-16, -9.577334573022567e-19,
 -2.432041815157684e-19,  7.269894392522806e-21,  8.255940785761876e-02, -1.002193922883336e-03,  1.171123935802382e-05, -1.100043373587944e-07,  2.669186470222873e-11,
  2.819637851873432e-11, -2.859778888586212e-13, -2.090759589087052e-14,  8.422866189416245e-16, -3.076943149225165e-18, -7.040904067476651e-19,  2.142134474542658e-20,
  1.643553511411856e-01, -1.994697287589194e-03,  2.326117625167475e-05, -2.150704106042304e-07, -1.380356383827254e-10,  6.211497684423441e-11, -6.580174088673112e-13,
 -4.315400272070835e-14,  1.786269833660571e-15, -7.538095918803751e-18, -1.472806494353434e-18,  4.615286291180108e-20,  2.777810685966719e-01, -3.370184524464609e-03,
  3.917532367459336e-05, -3.531496310451717e-07, -7.419553080245768e-10,  1.211002796526071e-10, -1.358495526281531e-12, -7.685679903827396e-14,  3.318523742995738e-15,
 -1.700071385287747e-17, -2.671556541349099e-18,  8.771914013358686e-20,  4.277887585556679e-01, -5.187534000212842e-03,  5.999793125400517e-05, -5.188298133285980e-07,
 -2.388943810493302e-09,  2.267494938985613e-10, -2.735938491946200e-12, -1.273314414849946e-13,  5.875777143350747e-15, -3.865791734145573e-17, -4.528240586258357e-18,
  1.602671512902288e-19,  6.229841192205555e-01, -7.548339034678779e-03,  8.657617262304153e-05, -6.946240410686937e-07, -6.575775640627243e-09,  4.332770789271346e-10,
 -5.750088777721883e-12, -2.048687319705329e-13,  1.058377182255054e-14, -9.629669605890599e-17, -7.447068574495639e-18,  3.007660082816276e-19,  8.802069345366583e-01,
 -1.064874121846934e-02,  1.201938674433167e-04, -8.144774831732658e-07, -1.807904395228286e-08,  9.202417784754517e-10, -1.402784833533582e-11, -3.272253597210151e-13,
  2.133901401416125e-14, -3.033625655356296e-16, -1.156999800641786e-17,  6.306846680652133e-19,  1.242834955989263e+00, -1.497722610813763e-02,  1.616570085181074e-04,
 -4.791444068766831e-07, -6.376842248350797e-08,  2.804331899926217e-09, -5.594557790829452e-11, -3.679850759620467e-13,  6.383276712970402e-14, -1.927284204998865e-15,
  9.176600504085335e-18,  1.424265258883093e-18,  3.102978863778461e-03, -3.601594229600040e-05,  4.106878357945262e-07, -4.191304138916012e-09,  2.093799053064622e-11,
  6.102208037089023e-13, -1.965594365046611e-14,  1.033210635184403e-17,  1.665741802922939e-17, -5.244065902288801e-19,  1.979845981861070e-21,  3.784770654860093e-22,
  2.806244272355069e-02, -3.257097300898093e-04,  3.713070058234847e-06, -3.781836997762926e-08,  1.845705801411833e-10,  5.703059110948764e-12, -1.823315322771147e-13,
  1.335927958178266e-16,  1.526255925239764e-16, -4.835241287814136e-18,  1.910159735063326e-20,  3.466770139900247e-21,  7.872971441844577e-02, -9.137372953724325e-04,
  1.041073339786720e-05, -1.055858664096464e-07,  4.893104445590614e-10,  1.710197447662569e-11, -5.389970373566015e-13,  6.222619203890467e-16,  4.399144090672750e-16,
 -1.412353295619664e-17,  6.104246380327644e-20,  9.982482917036517e-21,  1.567324579600042e-01, -1.818881551862952e-03,  2.070443994113663e-05, -2.084996906162341e-07,
  8.796156186544612e-10,  3.772107079824352e-11, -1.165567091329740e-12,  2.109701547771790e-15,  9.141335948997076e-16, -3.000459156731185e-17,  1.482252951755777e-19,
  2.068893018927697e-20,  2.649002361456994e-01, -3.073765165030738e-03,  3.493898113685289e-05, -3.479451672837829e-07,  1.237219216268527e-09,  7.355083659596971e-11,
 -2.220758329014677e-12,  6.083121441314340e-15,  1.644067287128264e-15, -5.585367749654611e-17,  3.297317508111276e-19,  3.696343672376882e-20,  4.079586606501694e-01,
 -4.732787246856628e-03,  5.367828526349558e-05, -5.251967210422986e-07,  1.301490653185578e-09,  1.373413765860114e-10, -4.051682256356838e-12,  1.631389277365229e-14,
  2.761972137344950e-15, -9.904428108873414e-17,  7.340632768892938e-19,  6.105701541653280e-20,  5.941214635398057e-01, -6.890257429751212e-03,  7.786729151595328e-05,
 -7.393284364539490e-07,  4.237585964078603e-10,  2.600498936502059e-10, -7.537747354390139e-12,  4.422215384227681e-14,  4.535956533624652e-15, -1.781678107226650e-16,
  1.766585403172034e-18,  9.553489836374613e-20,  8.394679106064755e-01, -9.729933120454745e-03,  1.092271585976438e-04, -9.766736565596059e-07, -3.434798136526746e-09,
  5.387010086213962e-10, -1.563395840970885e-11,  1.376739659335570e-13,  7.504993168061576e-15, -3.542416267223434e-16,  5.213036062171043e-18,  1.294468788813049e-19,
  1.185456680151464e+00, -1.372052861957638e-02,  1.513987709052235e-04, -1.123827107956875e-06, -2.100580251455734e-08,  1.509473514130026e-09, -4.707753377529410e-11,
  7.160519604772145e-13,  9.967521099420814e-15, -9.556446073846674e-16,  2.734654618073698e-17, -2.362256133453927e-19,  2.965176619116276e-03, -3.292516192030268e-05,
  3.627243627867228e-07, -3.783323196667865e-09,  2.868971801396798e-11,  1.859029727204407e-13, -1.449443707304669e-14,  2.791681342002538e-16,  1.729425926044470e-18,
 -2.697465602722562e-19,  7.628844070926881e-21, -4.763019380006661e-23,  2.681621913385176e-02, -2.977630844744130e-04,  3.279985321102348e-06, -3.418127176542336e-08,
  2.573828133669962e-10,  1.773959829267485e-12, -1.340633255296606e-13,  2.586135674750732e-15,  1.535439674240925e-17, -2.472407845852223e-18,  7.032312407350152e-20,
 -4.509939798250199e-22,  7.523352901162665e-02, -8.353649030955197e-04,  9.199759924352306e-06, -9.569460939590714e-08,  7.097443781114670e-10,  5.529075060143431e-12,
 -3.939359068692584e-13,  7.625511186881002e-15,  4.124126374358925e-17, -7.130857455201068e-18,  2.052864058801384e-19, -1.390146475258526e-21,  1.497727581010178e-01,
 -1.662967001853212e-03,  1.830703078833484e-05, -1.898429183621398e-07,  1.372192999063782e-09,  1.283792647539512e-11, -8.437291494866753e-13,  1.643288973309863e-14,
  7.521363423381699e-17, -1.483126449617741e-17,  4.355968229617881e-19, -3.207581545436599e-21,  2.531383549147707e-01, -2.810524533988775e-03,  3.092194176525635e-05,
 -3.191349384702476e-07,  2.212416844237129e-09,  2.653324770013336e-11, -1.584892155045377e-12,  3.118829432821842e-14,  1.054855298559550e-16, -2.670202161359889e-17,
  8.089975210407570e-19, -6.695106068085883e-21,  3.898471826879449e-01, -4.328040606317214e-03,  4.757516907439689e-05, -4.873860646184618e-07,  3.151602204539432e-09,
  5.257239394048667e-11, -2.832045794351267e-12,  5.670597197942425e-14,  9.664768320193450e-17, -4.489827071763904e-17,  1.428009842659818e-18, -1.382412231552429e-20,
  5.677507286315479e-01, -6.302357141285547e-03,  6.917753157298556e-05, -7.001233741839016e-07,  3.977858998571742e-09,  1.051066562850626e-10, -5.103222627657405e-12,
  1.053380476968625e-13, -7.503877769665056e-17, -7.372822232957823e-17,  2.543374655283846e-18, -3.042165634609413e-20,  8.022211889484814e-01, -8.903236064712241e-03,
  9.747129733822845e-05, -9.641614222702296e-07,  3.995355745133244e-09,  2.266986233808998e-10, -1.001262595322184e-11,  2.192190453633787e-13, -9.923440591301800e-16,
 -1.215245921647712e-16,  4.927972175568676e-18, -7.980051343550416e-20,  1.132906034485233e+00, -1.256706489691693e-02,  1.367131242722079e-04, -1.272666000511101e-06,
 -4.141113971528524e-10,  6.313640443553370e-10, -2.638303961569543e-11,  6.684842599924044e-13, -8.202638172064066e-15, -1.594986253458230e-16,  1.192479259019283e-17,
 -3.330149558969637e-19,  2.839003279628166e-03, -3.019698983997079e-05,  3.201474901968830e-07, -3.310769161090530e-09,  2.956370879029504e-11, -6.892565307357142e-14,
 -6.978881977525754e-15,  2.315662789302947e-16, -3.327653627225687e-18, -3.901776715837648e-20,  3.590881849793565e-21, -9.665204041563932e-23,  2.567514989395690e-02,
 -2.730922110072531e-04,  2.895191081315518e-06, -2.992938614151159e-08,  2.665564171754248e-10, -5.833227315579467e-13, -6.461879192942296e-14,  2.135944965855956e-15,
 -3.083594262918699e-17, -3.513810405907002e-19,  3.290173580310238e-20, -8.902027796285841e-22,  7.203227262769125e-02, -7.661616853406148e-04,  8.121744522898767e-06,
 -8.389497534263090e-08,  7.430332180139556e-10, -1.398816609042995e-12, -1.902470232351351e-13,  6.242079111819962e-15, -9.098907363828007e-17, -9.751206599009963e-19,
  9.482346484881028e-20, -2.593997066545623e-21,  1.433999191184117e-01, -1.525236835531578e-03,  1.616598310654501e-05, -1.667778598777479e-07,  1.463446815787490e-09,
 -2.000586596417285e-12, -4.084398932290898e-13,  1.326079584284970e-14, -1.963507237355758e-16, -1.894649676769893e-18,  1.969578444732464e-19, -5.487220258969533e-21,
  2.423676412100864e-01, -2.577837327443946e-03,  2.731633900094831e-05, -2.812631991913548e-07,  2.432399389928735e-09, -1.326911668023127e-12, -7.687734498687473e-13,
  2.464321775684422e-14, -3.735714804629523e-16, -3.031453077864909e-18,  3.537925220743167e-19, -1.013973418183002e-20,  3.732604702071072e-01, -3.969917981756747e-03,
  4.205328104317422e-05, -4.317112418345326e-07,  3.648757640519822e-09,  2.870634555839717e-12, -1.373927936705489e-12,  4.345373298847143e-14, -6.820915395275601e-16,
 -4.070630836401064e-18,  5.925102998442262e-19, -1.774882556090393e-20,  5.435966208070618e-01, -5.781339436125754e-03,  6.120841250792863e-05, -6.253423225734817e-07,
  5.084637284331747e-09,  1.592751791615797e-11, -2.463764206168037e-12,  7.707342680193989e-14, -1.276152211149789e-15, -3.718922591645589e-18,  9.656036613321741e-19,
 -3.113853566698699e-20,  7.680964029987527e-01, -8.168388986409104e-03,  8.639770043275140e-05, -8.750378154126972e-07,  6.592175189382274e-09,  5.360679300688633e-11,
 -4.746645276191783e-12,  1.484216751070351e-13, -2.687444285467496e-15,  4.705889264853651e-18,  1.564732206382280e-18, -5.842483600736057e-20,  1.084729322711540e+00,
 -1.153379507635684e-02,  1.217226469818125e-04, -1.206887487367016e-06,  7.231455153402780e-09,  1.904651956585411e-10, -1.169495012494299e-11,  3.812433215847110e-13,
 -8.322051434250136e-15,  8.703030640489807e-17,  1.936900263000602e-18, -1.270754721130801e-19,  2.723097213774386e-03, -2.778683936807465e-05,  2.831868894096116e-07,
 -2.855898775266356e-09,  2.697075517412917e-11, -1.711416098542771e-13, -2.043080339684783e-15,  1.229257749800167e-16, -3.030047016748350e-18,  3.546152342699343e-20,
  5.547539165470025e-22, -4.051228699200187e-23,  2.462693008601507e-02, -2.512961311270734e-04,  2.561020478519203e-06, -2.582382443565193e-08,  2.436273182917800e-10,
 -1.532349848710730e-12, -1.912007442958422e-14,  1.132697908509693e-15, -2.791927684070335e-17,  3.288959496335227e-19,  5.010696253901979e-21, -3.709525750086987e-22,
  6.909147860198649e-02, -7.050160506975237e-04,  7.184756839093417e-06, -7.242503068275327e-08,  6.817954158178952e-10, -4.207758477396388e-12, -5.746041937245196e-14,
  3.302848023706341e-15, -8.141862796680533e-17,  9.722777238454932e-19,  1.399737908906863e-20, -1.067580758954798e-21,  1.375455066849728e-01, -1.403522178143704e-03,
  1.430240738677609e-05, -1.441023008174285e-07,  1.351711356070478e-09, -8.076875219679587e-12, -1.269826059754707e-13,  6.989771318551436e-15, -1.724188317158904e-16,
  2.104396694729806e-18,  2.753033544991531e-20, -2.212146050348217e-21,  2.324729017994128e-01, -2.372153102275780e-03,  2.417114922164935e-05, -2.433497861505685e-07,
  2.270128791790581e-09, -1.287103831311332e-11, -2.475897501083440e-13,  1.290842243999951e-14, -3.190584213120249e-16,  4.021466505139580e-18,  4.506899387704154e-20,
 -3.958315082547405e-21,  3.580222352229972e-01, -3.653226815790880e-03,  3.722014045110954e-05, -3.742945187368252e-07,  3.462143548792892e-09, -1.797565064074337e-11,
 -4.600865888510826e-13,  2.252908361738944e-14, -5.596030404453736e-16,  7.388952547240005e-18,  6.366709777482459e-20, -6.587458787022810e-21,  5.214050338140321e-01,
 -5.320298902592363e-03,  5.419434092924606e-05, -5.440012001025174e-07,  4.963090747385608e-09, -2.183711304739781e-11, -8.580205211307176e-13,  3.925688278977713e-14,
 -9.860517772597224e-16,  1.394565074336952e-17,  6.989069915628969e-20, -1.061722732964285e-20,  7.367413032818450e-01, -7.517368535258587e-03,  7.654887724378437e-05,
 -7.659320468498883e-07,  6.813395984493184e-09, -1.968101830637300e-11, -1.708135866083310e-12,  7.303665230904901e-14, -1.882806117103101e-15,  2.970610546213152e-17,
 -8.398041459908358e-21, -1.681464373774926e-20,  1.040453034588534e+00, -1.061577115655486e-02,  1.080192260248163e-04, -1.072831444628939e-06,  8.956611341483064e-09,
  1.099923654026020e-11, -4.221303985246197e-12,  1.716497021431462e-13, -4.761727158659108e-15,  9.272433100677552e-17, -8.728371996174452e-19, -1.920797867769749e-20,
  2.616273796420317e-03, -2.565136372799157e-05,  2.513864710756845e-07, -2.453424368543112e-09,  2.328508339655579e-11, -1.885676090834878e-13,  2.476236540544385e-16,
  4.798444063115172e-17, -1.665008906725841e-18,  3.454452833298475e-20, -3.506828324462307e-22, -6.066895512539930e-24,  2.366084961361517e-02, -2.319836887257353e-04,
  2.273456108113733e-06, -2.218678056808833e-08,  2.104880311675659e-10, -1.699929157571179e-12,  1.995137736807274e-15,  4.428194241442338e-16, -1.531501711501675e-17,
  3.181386967001868e-19, -3.255125738815383e-21, -5.480489721649102e-23,  6.638111913667050e-02, -6.508356955959945e-04,  6.378163111529883e-06, -6.223789061853844e-08,
  5.899642234271408e-10, -4.737127145150214e-12,  4.150336456472917e-15,  1.294951121323022e-15, -4.449806308810583e-17,  9.268266696898478e-19, -9.638773732331415e-21,
 -1.531452851204397e-22,  1.321498065840714e-01, -1.295665228583672e-03,  1.269723381733063e-05, -1.238765392960583e-07,  1.172640691948056e-09, -9.325626988571050e-12,
  3.512311915008329e-15,  2.751355048373641e-15, -9.366114623281682e-17,  1.959726053119859e-18, -2.091640645600028e-20, -3.014130369837115e-22,  2.233533771385118e-01,
 -2.189868352793739e-03,  2.145963313177355e-05, -2.093060382419729e-07,  1.977190566513158e-09, -1.549035075459975e-11, -6.412054447957789e-15,  5.103864759942624e-15,
 -1.716960690260994e-16,  3.618887022825479e-18, -4.011699082433660e-20, -4.942137326171669e-22,  3.439776934889677e-01, -3.372520418717161e-03,  3.304767009956199e-05,
 -3.221949806281925e-07,  3.033917480047278e-09, -2.321948654431626e-11, -3.906194100985777e-14,  8.942862880210542e-15, -2.968059965397692e-16,  6.329922736251808e-18,
 -7.406566559770204e-20, -7.013014480914102e-22,  5.009514584524077e-01, -4.911545117931670e-03,  4.812562625652114e-05, -4.688889862917229e-07,  4.393010137834260e-09,
 -3.233973718383927e-11, -1.253516891201981e-13,  1.560102577348063e-14, -5.108921473957384e-16,  1.111313104298055e-17, -1.406178088101222e-19, -7.850589505027459e-22,
  7.078409626828099e-01, -6.939930400535099e-03,  6.799320615852271e-05, -6.617088589962098e-07,  6.144377517813222e-09, -4.198606459668985e-11, -3.525493113433291e-13,
  2.881001411513813e-14, -9.352154630780618e-16,  2.110241616488996e-17, -3.012906680305073e-19, -1.910498499893643e-23,  9.996401472664732e-01, -9.800689119375351e-03,
  9.599831231918405e-05, -9.319091249002704e-07,  8.475921805199521e-09, -4.703840944067902e-11, -1.100189873173176e-12,  6.507631051249623e-14, -2.141500267645416e-15,
  5.264714112404911e-17, -9.368788118378291e-19,  8.339104051346238e-21,  2.517512633316679e-03, -2.375198543525285e-05,  2.240583554844529e-07, -2.110348759211312e-09,
  1.965537108325408e-11, -1.714780423921975e-13,  1.011231577296246e-15,  1.163703569369970e-17, -6.996275874025813e-19,  1.914864322077373e-20, -3.530176318433008e-22,
  3.286321833805827e-24,  2.276768142437790e-02, -2.148063022480824e-04,  2.026317463467662e-06, -1.908501366787306e-08,  1.777277859388035e-10, -1.549023394642295e-12,
  9.060474091560321e-15,  1.085594036754428e-16, -6.434078135641541e-18,  1.759795101345266e-19, -3.250112530449659e-21,  3.051386421710408e-23,  6.387531404387624e-02,
 -6.026444537218734e-04,  5.684863537894290e-06, -5.354119124115335e-08,  4.984436149810398e-10, -4.335342745494356e-12,  2.491805009672367e-14,  3.242088975105288e-16,
 -1.868506911447399e-17,  5.104124061821270e-19, -9.462469156406317e-21,  9.041031719860120e-23,  1.271613185690675e-01, -1.199728510848833e-03,  1.131720737590449e-05,
 -1.065809338467616e-07,  9.917151926047310e-10, -8.596504839818101e-12,  4.796688100148169e-14,  7.098644729313728e-16, -3.928645490969378e-17,  1.071426733900691e-18,
 -1.998808035414255e-20,  1.963707192346566e-22,  2.149220789746282e-01, -2.027723580524286e-03,  1.912762925933059e-05, -1.801189597452924e-07,  1.674680129758181e-09,
 -1.444145013256219e-11,  7.683544194175568e-14,  1.367125702357224e-15, -7.185926527129850e-17,  1.956707391858255e-18, -3.685844100796105e-20,  3.770626087325677e-22,
  3.309930062250201e-01, -3.122814462998835e-03,  2.945728815830219e-05, -2.773500390242048e-07,  2.575705211794233e-09, -2.203599420247869e-11,  1.084104657903740e-13,
  2.500372474498528e-15, -1.236746348922908e-16,  3.365484432351531e-18, -6.434232360862594e-20,  6.969771031307895e-22,  4.820412739634271e-01, -4.547901481196793e-03,
  4.289914903967831e-05, -4.038190069315784e-07,  3.743392259877500e-09, -3.162316991693903e-11,  1.349400865097293e-13,  4.565349862520240e-15, -2.109928097191060e-16,
  5.753851856186973e-18, -1.126287117537897e-19,  1.324094598507586e-21,  6.811211154442987e-01, -6.426141168088179e-03,  6.061398105939518e-05, -5.703546975062325e-07,
  5.270589575137941e-09, -4.352817274952512e-11,  1.332603662663826e-13,  8.806919925608635e-15, -3.787864656006950e-16,  1.043010581193021e-17, -2.127495600977499e-19,
  2.831120469544892e-21,  9.619056905998689e-01, -9.075207046767437e-03,  8.559480026016030e-05, -8.047549189610140e-07,  7.385232587355924e-09, -5.780894193703469e-11,
  4.787711077078206e-16,  2.043472158188272e-14, -8.219489756003079e-16,  2.344719507066339e-17, -5.231696968739831e-19,  8.662441548747127e-21,  2.425936454050665e-03,
 -2.205572075962118e-05,  2.005123910512882e-07, -1.821908133089691e-09,  1.648419623763107e-11, -1.452812335499841e-13,  1.109609947507905e-15, -2.138769883755026e-18,
 -2.262335280526308e-19,  8.217886894349426e-21, -1.943765289441686e-22,  3.284602924614974e-24,  2.193949207819077e-02, -1.994657753278879e-04,  1.813377045995903e-06,
 -1.647671635837578e-08,  1.490696019944931e-10, -1.313335165393705e-12,  1.000759439000305e-14, -1.820731992186399e-17, -2.085348869219796e-18,  7.546431025949458e-20,
 -1.785428272097710e-21,  3.023202636204723e-23,  6.155180790891373e-02, -5.596063134824014e-04,  5.087469690603519e-06, -4.622519079647387e-08,  4.181664077635367e-10,
 -3.681368196247058e-12,  2.791486888989925e-14, -4.437444502142626e-17, -6.083449679066390e-18,  2.185042073096837e-19, -5.172972932904363e-21,  8.796890929482696e-23,
  1.225357438260844e-01, -1.114049625845386e-03,  1.012798295296392e-05, -9.202177487877732e-08,  8.323055045462016e-10, -7.318278738612875e-12,  5.504524189802727e-14,
 -6.642421615591521e-17, -1.287443923453899e-17,  4.573334111357367e-19, -1.084077958796556e-20,  1.856537763933305e-22,  2.071041526954760e-01, -1.882913995338602e-03,
  1.711779016873953e-05, -1.555254357936042e-07,  1.406291224064309e-09, -1.234213229248918e-11,  9.168034020864689e-14, -5.569956012946952e-17, -2.374083592813718e-17,
  8.312878646384489e-19, -1.975136767343540e-20,  3.418894241414486e-22,  3.189529325586689e-01, -2.899800854064477e-03,  2.636231803115919e-05, -2.395061182389687e-07,
  2.164778762110800e-09, -1.894550377249731e-11,  1.380457159820324e-13,  4.648468199018545e-17, -4.122929717632401e-17,  1.418944549394055e-18, -3.386065695895672e-20,
  5.956287006560399e-22,  4.645067399143252e-01, -4.223120154850749e-03,  3.839247579512356e-05, -3.487765717805272e-07,  3.150433817206098e-09, -2.745044358790461e-11,
  1.938508478984990e-13,  3.727736933645370e-16, -7.093224498264360e-17,  2.394790303121514e-18, -5.762165195472519e-20,  1.039312674610446e-21,  6.563449660145666e-01,
 -5.967237448599569e-03,  5.424771397346421e-05, -4.927528871305892e-07,  4.446181439147270e-09, -3.844635998381027e-11,  2.562701941506179e-13,  1.286534096406491e-15,
 -1.278516327508292e-16,  4.236565797496506e-18, -1.036919989318251e-19,  1.951598864023572e-21,  9.269159388836004e-01, -8.427155183670430e-03,  7.660899370560989e-05,
 -6.956902293537360e-07,  6.262993647041498e-09, -5.325080693786096e-11,  3.064993425504955e-13,  4.275590925334715e-15, -2.732324856773782e-16,  8.977059529386266e-18,
 -2.295219504128537e-19,  4.722672655157913e-21,  2.340789354698543e-03, -2.053480109724863e-05,  1.801406932840481e-07, -1.579991111872228e-09,  1.383678512497873e-11,
 -1.199610588378754e-13,  9.836557572237124e-16, -5.889210997309236e-18, -3.957252655133360e-20,  2.885045338772583e-21, -8.342846148307922e-23,  1.776628426446403e-24,
  2.116944549518652e-02, -1.857110072118173e-04,  1.629141863473457e-06, -1.428896765760195e-08,  1.251335081282189e-10, -1.084733811581936e-12,  8.887562019928399e-15,
 -5.289860966038401e-17, -3.711465779230096e-19,  2.650576855394299e-20, -7.655118005800646e-22,  1.631298901046221e-23,  5.939142254774240e-02, -5.210169864580942e-04,
  4.570597656111247e-06, -4.008788394147323e-08,  3.510504922752433e-10, -3.042304189698245e-12,  2.488512711719210e-14, -1.462749550313974e-16, -1.119596862487318e-18,
  7.681341230438349e-20, -2.212941289171088e-21,  4.722779537413014e-23,  1.182349049148064e-01, -1.037227083705036e-03,  9.099022057415323e-06, -7.980533393331871e-08,
  6.988143898152098e-10, -6.053477823878472e-12,  4.938093758826957e-14, -2.842522343398363e-16, -2.484659841976827e-18,  1.609464556093885e-19, -4.620167611723902e-21,
  9.885261722190282e-23,  1.998350776749025e-01, -1.753072374842913e-03,  1.537872585542642e-05, -1.348817349350080e-07,  1.180981541070531e-09, -1.022349131593550e-11,
  8.305262951533334e-14, -4.625885835228722e-16, -4.858971230555950e-18,  2.928259790674941e-19, -8.368582351437566e-21,  1.797843263509005e-22,  3.077581185392784e-01,
 -2.699837418161001e-03,  2.368413835027472e-05, -2.077226445952794e-07,  1.818504650570957e-09, -1.572684824044275e-11,  1.269628483556669e-13, -6.710245105028643e-16,
 -9.022508892054317e-18,  4.998836868877483e-19, -1.421676845827385e-20,  3.074259898857000e-22,  4.482031887156851e-01, -3.931904786317934e-03,  3.449230064381459e-05,
 -3.025091055637452e-07,  2.647755737825973e-09, -2.286347409836509e-11,  1.827694365649902e-13, -8.829171109225967e-16, -1.668083711339469e-17,  8.417807444367532e-19,
 -2.383896211494566e-20,  5.211694816698533e-22,  6.333081634867798e-01, -5.555754748868173e-03,  4.873723750604424e-05, -4.274257408441075e-07,  3.739793737499981e-09,
 -3.220982406780449e-11,  2.531095938318846e-13, -1.017212529503050e-15, -3.234655334852813e-17,  1.476578947070782e-18, -4.177708640369997e-20,  9.319251525392161e-22,
  8.943824913107310e-01, -7.846051033854303e-03,  6.882818311917855e-05, -6.035765819448511e-07,  5.277193944965110e-09, -4.520198144498321e-11,  3.418287252502738e-13,
 -7.196804659692349e-16, -7.378676712624058e-17,  3.037278731701118e-18, -8.702606271200640e-20,  2.033392973847462e-21,  2.261417405151143e-03, -1.916592581121969e-05,
  1.624339548669695e-07, -1.376571241685359e-09,  1.165987944551224e-11, -9.839887193463563e-14,  8.128288144068243e-16, -6.006659824672102e-18,  1.980627621958840e-20,
  7.633220461144918e-22, -3.009129340203681e-23,  7.544854838575790e-25,  2.045162774379564e-02, -1.733312825020400e-04,  1.469007271917814e-06, -1.244931782929357e-08,
  1.054480096704809e-10, -8.898469234509717e-13,  7.348580025355141e-15, -5.421379842714410e-17,  1.749542500689042e-19,  7.040698093814845e-21, -2.760517081005896e-22,
  6.919408593610735e-24,  5.737756644874617e-02, -4.862853584920807e-04,  4.121337170530999e-06, -3.492683245364416e-08,  2.958330747850457e-10, -2.496223950760933e-12,
  2.060241600790016e-14, -1.514578936984150e-16,  4.662673969065045e-19,  2.056416875177106e-20, -7.976201893425684e-22,  1.998189570538272e-23,  1.142257724511523e-01,
 -9.680842825787676e-04,  8.204649865515249e-06, -6.953127757043106e-08,  5.889238265268316e-10, -4.968562458499531e-12,  4.096869011603235e-14, -2.994392073984165e-16,
  8.482661791994189e-19,  4.358588418456997e-20, -1.663655965216366e-21,  4.165028659369374e-23,  1.930590306449847e-01, -1.636210523158120e-03,  1.386711001209156e-05,
 -1.175181033888225e-07,  9.953384229942989e-10, -8.395456381566809e-12,  6.912595983348817e-14, -5.007833084370823e-16,  1.228590121717560e-18,  8.048425792900732e-20,
 -3.007921091476042e-21,  7.526636836753267e-23,  2.973225962626158e-01, -2.519863227678724e-03,  2.135618116106979e-05, -1.809841023459817e-07,  1.532806440034019e-09,
 -1.292454341554064e-11,  1.061888778533975e-13, -7.589905335577236e-16,  1.417067810221547e-18,  1.398348232829690e-19, -5.092564989034160e-21,  1.274506009664205e-22,
  4.330054285041358e-01, -3.669799877799105e-03,  3.110203314164765e-05, -2.635740268781792e-07,  2.232134799259318e-09, -1.881158050270464e-11,  1.540447342285672e-13,
 -1.077733166717854e-15,  9.839735682962957e-19,  2.400812999436286e-19, -8.483625207276043e-21,  2.127307115735946e-22,  6.118338301020019e-01, -5.185402929817708e-03,
  4.394692911155577e-05, -3.724238162080028e-07,  3.153604172348604e-09, -2.655460473800843e-11,  2.162309717181270e-13, -1.456504363842562e-15, -1.234610839721867e-18,
  4.290969600111137e-19, -1.466579059091502e-20,  3.701687535831786e-22,  8.640556057305379e-01, -7.323027708772227e-03,  6.206345746159639e-05, -5.259386141271110e-07,
  4.452535648257086e-09, -3.742592095671539e-11,  3.011382353647896e-13, -1.857135014408153e-15, -9.837038708873056e-18,  8.907776537302281e-19, -2.948703922968100e-20,
  7.604122693803786e-22,  2.187252314307786e-03, -1.792950106242908e-05,  1.469727859502327e-07, -1.204752701201784e-09,  9.873810026695704e-12, -8.081911292229295e-14,
  6.563118196176912e-16, -5.111506294123859e-18,  3.199405559239531e-20,  5.143236545776423e-23, -8.974833177019418e-24,  2.734408254726512e-25,  1.978089936613029e-02,
 -1.621494025417409e-04,  1.329180830751259e-06, -1.089544501220528e-08,  8.929580131033753e-11, -7.308933574350042e-13,  5.934830725111963e-15, -4.619591596576509e-17,
  2.881084060482411e-19,  5.077142858612020e-22, -8.244388337032316e-23,  2.506444408128052e-24,  5.549582077902400e-02, -4.549143092166552e-04,  3.729050821691210e-06,
 -3.056743818515422e-08,  2.505206046852081e-10, -2.050468834048334e-12,  1.664638383744163e-14, -1.294208740898844e-16,  8.010159596090116e-19,  1.675278426326763e-21,
 -2.388399658324574e-22,  7.230049917897122e-24,  1.104796419516302e-01, -9.056316167015186e-04,  7.423697398989015e-06, -6.085282395876488e-08,  4.987265194554926e-10,
 -4.081790250591848e-12,  3.312646319729671e-14, -2.570551683014128e-16,  1.571019294848320e-18,  4.150977774260754e-21, -5.000652122545973e-22,  1.504145144148748e-23,
  1.867274970315012e-01, -1.530655978678651e-03,  1.254718347343631e-05, -1.028504816546611e-07,  8.429155016622927e-10, -6.898267455455529e-12,  5.595647692224609e-14,
 -4.329540172008009e-16,  2.594945494528613e-18,  9.106092362030649e-21, -9.084328321625305e-22,  2.709715329081380e-23,  2.875716512457408e-01, -2.357302872953366e-03,
  1.932342027918597e-05, -1.583957416742159e-07,  1.298121383883251e-09, -1.062242519688547e-11,  8.610264037361038e-14, -6.633202780105198e-16,  3.857615644525891e-18,
  1.885677990743050e-20, -1.546127549964840e-21,  4.565367828504266e-23,  4.188046509210296e-01, -3.433055364210208e-03,  2.814163710464745e-05, -2.306789621698360e-07,
  1.890474660373738e-09, -1.546702936820218e-11,  1.252316575730317e-13, -9.583028162078767e-16,  5.305835739383273e-18,  3.841792552380369e-20, -2.588087066631057e-21,
  7.555360636980539e-23,  5.917682250309708e-01, -4.850884659496359e-03,  3.976393888743157e-05, -3.259467186732597e-07,  2.671129143086635e-09, -2.184800307985263e-11,
  1.765673894732590e-13, -1.335799876669614e-15,  6.750564029106106e-18,  8.079868793985928e-20, -4.482563093804686e-21,  1.293869339202219e-22,  8.357181767572296e-01,
 -6.850608438287421e-03,  5.615615925447318e-05, -4.603115158545331e-07,  3.771995240906402e-09, -3.083528552374047e-11,  2.482488710549079e-13, -1.832921394025816e-15,
  7.303260537649013e-18,  1.951065500901248e-19, -8.919996527656099e-21,  2.559939847691742e-22,  2.117797949729198e-03, -1.680897874605935e-05,  1.334129430014373e-07,
 -1.058893546730158e-09,  8.403947479335307e-12, -6.666967345428601e-14,  5.274213325126557e-16, -4.108281175257230e-18,  2.962380649466055e-20, -1.363231409953326e-22,
 -1.763660004951493e-24,  8.534002090046036e-26,  1.915277348107695e-02, -1.520157115834863e-04,  1.206549410203380e-06, -9.576337121157739e-09,  7.600290907831631e-11,
 -6.029387524417580e-13,  4.769672408222187e-15, -3.714561415673960e-17,  2.675597114005656e-19, -1.220398273455628e-21, -1.634029615659525e-23,  7.825578127870762e-25,
  5.373359749121973e-02, -4.264839796605093e-04,  3.385005305818851e-06, -2.686665644156425e-08,  2.132278423877939e-10, -1.691541598245096e-12,  1.338038890688035e-14,
 -1.041628688405282e-16,  7.485903716112390e-19, -3.350496101404765e-21, -4.814174265241272e-23,  2.258991479894420e-24,  1.069714534988719e-01, -8.490332548518639e-04,
  6.738780763030212e-06, -5.348543350487370e-08,  4.244875964725726e-10, -3.367417434030977e-12,  2.663394566029832e-14, -2.072028376547572e-16,  1.483622025493869e-18,
 -6.432180249634463e-21, -1.033093088548912e-22,  4.704033348001775e-24,  1.807981218442218e-01, -1.434996092067833e-03,  1.138957023402874e-05, -9.039854026233435e-08,
  7.174467950907565e-10, -5.691299757194661e-12,  4.500687413536025e-14, -3.497938031119497e-16,  2.490629835569024e-18, -1.026457137242162e-20, -1.937248273421561e-22,
  8.482027255038930e-24,  2.784400544751926e-01, -2.209980864243497e-03,  1.754062728907952e-05, -1.392191690504093e-07,  1.104906573506013e-09, -8.764604742043317e-12,
  6.929385772247583e-14, -5.377680259285972e-16,  3.797030805057010e-18, -1.441442573170927e-20, -3.424681909612730e-22,  1.429652408588294e-23,  4.055058602860414e-01,
 -3.218503141224405e-03,  2.554527179239840e-05, -2.027515576185753e-07,  1.609118666041731e-09, -1.276357246395214e-11,  1.008731178191075e-13, -7.811033274529938e-16,
  5.443523970462440e-18, -1.786466467216407e-20, -5.985017714532561e-22,  2.363380905479399e-23,  5.729771212043306e-01, -4.547723818115942e-03,  3.609529916431916e-05,
 -2.864863424680826e-07,  2.273649483018059e-09, -1.803311905211857e-11,  1.424335976542474e-13, -1.098847196762621e-15,  7.488278177127499e-18, -1.779431152545053e-20,
 -1.085993662698114e-21,  4.026427094637197e-23,  8.091806470754511e-01, -6.422472985252936e-03,  5.097518352771885e-05, -4.045864327361393e-07,  3.210868766412605e-09,
 -2.546227437108244e-11,  2.008699051958225e-13, -1.537970440341332e-15,  9.983801270967021e-18, -3.062297411635790e-21, -2.261156733478208e-21,  7.818990796421360e-23,
  };
  constexpr double w[3456] = {  3.275160917397238e-01, -5.286154679298699e-03,  9.632045433651562e-05, -1.826684165903604e-06,  3.461715935546855e-08,
 -6.462651988229814e-10,  1.183925838316089e-11, -2.128978912268673e-13,  3.762065923499545e-15, -6.542744259755366e-17,  1.121162160739750e-18, -1.894770616360207e-20,
  3.035555463588489e-01, -1.202047910662565e-02,  4.621100309492548e-04, -1.562634734973927e-05,  4.809282725536074e-07, -1.377158669210259e-08,  3.718332347860888e-10,
 -9.550608652866109e-12,  2.348554391217942e-13, -5.555638971915294e-15,  1.268935606441885e-16, -2.805420507705207e-18,  2.622335891576053e-01, -2.212507330849835e-02,
  1.370789444452082e-03, -6.889474853941304e-05,  3.001460004712146e-06, -1.172492606671758e-07,  4.193042057219606e-09, -1.392014288863355e-10,  4.332836005318473e-12,
 -1.273894115571486e-13,  3.558007611845219e-15, -9.477271781968039e-17,  2.131115161495297e-01, -3.105918831297410e-02,  2.820436728240852e-03, -1.956557374707561e-04,
  1.128391673348613e-05, -5.655242981263646e-07,  2.530655302547174e-08, -1.029639923146660e-09,  3.858551635707719e-11, -1.344735985414929e-12,  4.390909838390571e-14,
 -1.350171736995047e-15,  1.643753414341042e-01, -3.554754911824440e-02,  4.393387412729479e-03, -3.960312048444108e-04,  2.870663226717437e-05, -1.762289494863031e-06,
  9.459521562819466e-08, -4.536117993086882e-09,  1.973328544117073e-10, -7.877958994705699e-12,  2.912065460504517e-13, -1.002812921841439e-14,  1.205739447118389e-01,
 -3.456774091951607e-02,  5.428735021151759e-03, -6.021813429751024e-04,  5.238432819980536e-05, -3.781920945776798e-06,  2.347317432422144e-07, -1.282862800860966e-08,
  6.281138309674574e-10, -2.791246379518946e-11,  1.137269914016852e-12, -4.278209370269712e-14,  8.282847694636665e-02, -2.883374011811133e-02,  5.401331397513610e-03,
 -7.003159438346249e-04,  6.996765096231976e-05, -5.715198875057325e-06,  3.962096095348577e-07, -2.391741877020558e-08,  1.280843517066493e-09, -6.171817948704520e-11,
  2.705700380785467e-12, -1.087455300253555e-13,  5.020035109141194e-02, -1.977198241641432e-02,  4.168634198912995e-03, -6.013129803747281e-04,  6.609323074717422e-05,
 -5.880249920065321e-06,  4.401054120008514e-07, -2.845949158220688e-08,  1.621406943261060e-09, -8.260888727866684e-11,  3.808303381680558e-12, -1.601489776181784e-13,
  2.096713363101189e-02, -8.810037354060675e-03,  1.980739149502382e-03, -3.030049814191181e-04,  3.511491229805258e-05, -3.276165675994989e-06,  2.558855600974613e-07,
 -1.719274284949252e-08,  1.013803648383151e-09, -5.327561694780777e-11,  2.525389907695124e-12, -1.088892441814229e-13,  3.077858853281169e-01, -4.594747194867706e-03,
  7.734196166094539e-05, -1.362580822282869e-06,  2.411250485062929e-08, -4.219559539469062e-10,  7.262853978932155e-12, -1.229410730224095e-13,  2.047486644552593e-15,
 -3.360383208075951e-17,  5.438491454900970e-19, -8.691497157905583e-21,  2.618403493569040e-01, -8.961030315427094e-03,  3.130281522368444e-04, -9.727786061179376e-06,
  2.767911981352219e-07, -7.362297095026635e-09,  1.853643597027270e-10, -4.454400058423390e-12,  1.027738871814317e-13, -2.286893903231288e-15,  4.924752425813607e-17,
 -1.028771140012438e-18,  1.913854170589870e-01, -1.379760126539152e-02,  7.694755556093252e-04, -3.525287350887512e-05,  1.413106657222577e-06, -5.114574683053954e-08,
  1.704061966931090e-09, -5.294856119085545e-11,  1.548661354370280e-12, -4.293453601660900e-14,  1.134305312778768e-15, -2.866287412883820e-17,  1.225525272978988e-01,
 -1.550329417534199e-02,  1.267685570240934e-03, -8.036236584545666e-05,  4.279425324080907e-06, -1.995790546188704e-07,  8.362463418403228e-09, -3.202396676543700e-10,
  1.134577354330349e-11, -3.752834870863997e-13,  1.167069618062062e-14, -3.428765133360243e-16,  7.067155571921771e-02, -1.365090736498394e-02,  1.540217920449266e-03,
 -1.283934660181440e-04,  8.687621889549744e-06, -5.014922567880630e-07,  2.546229297169523e-08, -1.160683579843519e-09,  4.820418113008809e-11, -1.844059395178751e-12,
  6.553482784422606e-14, -2.176256236471205e-15,  3.785753048130881e-02, -1.002781079526056e-02,  1.470697070372993e-03, -1.537179201468571e-04,  1.268967609633588e-05,
 -8.744021701303983e-07,  5.204714180620109e-08, -2.739006881794315e-09,  1.295857358273842e-10, -5.581457743966149e-12,  2.210096541488198e-13, -8.099678417338059e-15,
  1.927223663441213e-02, -6.402554179646731e-03,  1.149006201715696e-03, -1.434277579237919e-04,  1.385610905124321e-05, -1.098459769916246e-06,  7.414009370665687e-08,
 -4.369096311205294e-09,  2.289495370846753e-10, -1.081711883949515e-11,  4.658158920346496e-13, -1.841996777015399e-14,  9.159666554563843e-03, -3.531460960074146e-03,
  7.293594017038009e-04, -1.032679638425124e-04,  1.116326948362400e-05, -9.784923573521086e-07,  7.226153524866352e-08, -4.616818118574335e-09,  2.601813378163768e-10,
 -1.312564595809385e-11,  5.996859181763233e-13, -2.501307123376074e-14,  3.295190850059458e-03, -1.375782630537378e-03,  3.073105305709775e-04, -4.672693155562591e-05,
  5.385040805394420e-06, -4.998543523203666e-07,  3.885838967886530e-08, -2.599606222120558e-09,  1.526806722167237e-10, -7.993839228748285e-12,  3.776307666485924e-13,
 -1.623091267609934e-14,  2.905492964095498e-01, -4.035441937178224e-03,  6.305507381260011e-05, -1.035873108766136e-06,  1.717165307918818e-08, -2.825362351010849e-10,
  4.582021698286934e-12, -7.322532560940673e-14,  1.152245326151160e-15, -1.789836823173244e-17,  2.741051690936753e-19, -4.156856408788062e-21,  2.303586508554187e-01,
 -6.858258304395778e-03,  2.186888786409889e-04, -6.271955342337530e-06,  1.655712333764303e-07, -4.102985860540436e-09,  9.657990484021955e-11, -2.176281572948935e-12,
  4.720607824139887e-14, -9.898011277147120e-16,  2.012695778255048e-17, -3.977892970731271e-19,  1.462830959584135e-01, -9.015023144007877e-03,  4.543717964064686e-04,
 -1.902334777790564e-05,  7.029309579339429e-07, -2.360590772218163e-08,  7.335177881882622e-10, -2.134787008033739e-11,  5.869943235070288e-13, -1.534874312696750e-14,
  3.835774110485219e-16, -9.193442206547437e-18,  7.603192621013909e-02, -8.300323298154120e-03,  6.109151418255827e-04, -3.536331387322673e-05,  1.737334982327785e-06,
 -7.532185573929603e-08,  2.951789430065373e-09, -1.062589378478667e-10,  3.554227179959348e-12, -1.114141950023597e-13,  3.294716894492078e-15, -9.233232210445103e-17,
  3.350190645449307e-02, -5.719962655261913e-03,  5.860184629951114e-04, -4.497997354683215e-05,  2.830351991309226e-06, -1.530973460014684e-07,  7.328750484993481e-09,
 -3.165946494846067e-10,  1.251531919954245e-11, -4.574753564645885e-13,  1.558755784896267e-14, -4.978280859130838e-16,  1.314585859761562e-02, -3.179210823393651e-03,
  4.318835400015898e-04, -4.225470305674807e-05,  3.291633579280675e-06, -2.154136983617737e-07,  1.224214250232680e-08, -6.178592925092857e-10,  2.814192130255547e-11,
 -1.170830517910160e-12,  4.491429673558804e-14, -1.598920429792179e-15,  4.861403279609991e-03, -1.526582318543036e-03,  2.604562436886505e-04, -3.110348751942391e-05,
  2.889865433618437e-06, -2.213077077365353e-07,  1.448288426974850e-08, -8.301542969340405e-10,  4.242855885938857e-11, -1.959808221801128e-12,  8.268088620448305e-14,
 -3.209115151018247e-15,  1.749869268227879e-03, -6.570184873663185e-04,  1.323234223582105e-04, -1.831868625498594e-05,  1.941090963415935e-06, -1.671443497667095e-07,
  1.214910593845125e-08, -7.652327177941876e-10,  4.257522700079937e-11, -2.123092744044518e-12,  9.598656766571446e-14, -3.965667435907820e-15,  5.259026717632573e-04,
 -2.178720895477726e-04,  4.828737585439161e-05, -7.289276102769241e-06,  8.345325459432782e-07, -7.699992529267681e-08,  5.953224924703638e-09, -3.962758549339217e-10,
  2.316728400273630e-11, -1.207829227149948e-12,  5.683514412070394e-14, -2.434003496791362e-15,  2.753437562109580e-01, -3.576446383321562e-03,  5.210421619778977e-05,
 -8.009865916885695e-07,  1.247379480740504e-08, -1.935326031930720e-10,  2.964297852445037e-12, -4.485836323294714e-14,  6.680622311571898e-16, -9.861302508974223e-18,
  1.428234345170644e-19, -2.066794145449290e-21,  2.060042466487540e-01, -5.370275771496041e-03,  1.569701976161272e-04, -4.171373434161785e-06,  1.025151678025502e-07,
 -2.373713509059522e-09,  5.237270122036999e-11, -1.109143573316215e-12,  2.266438724296388e-14, -4.486072140743073e-16,  8.627620513335740e-18, -1.615537984849752e-19,
  1.162765560485915e-01, -6.132512666698628e-03,  2.806156711644623e-04, -1.076756980947020e-05,  3.675741405109813e-07, -1.147322325121065e-08,  3.329603904186676e-10,
 -9.086114387343163e-12,  2.350639992180855e-13, -5.800431946721364e-15,  1.371684026645470e-16, -3.118772623227544e-18,  5.046018507976739e-02, -4.731592202699203e-03,
  3.137999624070156e-04, -1.658855235510242e-05,  7.518003781932303e-07, -3.029083655787441e-08,  1.109667489952986e-09, -3.752354041087232e-11,  1.183930772889907e-12,
 -3.513603503742143e-14,  9.869134541775536e-16, -2.634938797038566e-17,  1.742315918429188e-02, -2.603841039060976e-03,  2.412561002610038e-04, -1.699274493713409e-05,
  9.914027962225989e-07, -5.010991815142565e-08,  2.255511226653475e-09, -9.209541918381499e-11,  3.456454774201291e-12, -1.204206359899999e-13,  3.924223444567202e-15,
 -1.202453485361733e-16,  5.062316046466771e-03, -1.103947043206275e-03,  1.378115086526817e-04, -1.254168074464325e-05,  9.169862540168454e-07, -5.672244183437452e-08,
  3.064535303368942e-09, -1.477460545675270e-10,  6.454944470396696e-12, -2.585269576779081e-13,  9.577324012495499e-15, -3.302035805772860e-16,  1.342037346170756e-03,
 -3.939097323537056e-04,  6.335017914259248e-05, -7.187167244655234e-06,  6.384456065076885e-07, -4.698937888525039e-08,  2.968223951019065e-09, -1.648282947490522e-10,
  8.187088437371228e-12, -3.685267242244760e-13,  1.518738455557681e-14, -5.770591701748445e-16,  3.531869959097818e-04, -1.282999060642630e-04,  2.505633243198213e-05,
 -3.375631308301991e-06,  3.492104250836325e-07, -2.943839168206255e-08,  2.099765311305725e-09, -1.300467547262010e-10,  7.126832658227869e-12, -3.505870044489093e-13,
  1.565649810586814e-14, -6.396888442846817e-16,  8.550921405328382e-05, -3.508666636815830e-05,  7.702605113707189e-06, -1.152667354591805e-06,  1.309307627272031e-07,
 -1.199490946658300e-08,  9.214196453922136e-10, -6.097550210302631e-11,  3.545749354055511e-12, -1.839539243919203e-13,  8.617146509376688e-15, -3.675089162887285e-16,
  2.618151944978641e-01, -3.194938151148274e-03,  4.357358039520250e-05, -6.288930830295645e-07,  9.224058827381757e-09, -1.353387442664720e-10,  1.961127089827964e-12,
 -2.821365500628187e-14,  3.972690783154482e-16, -5.615800707660520e-18,  7.684840397917868e-20, -1.041825311320229e-21,  1.867527526742593e-01, -4.290067366179592e-03,
  1.153840677148154e-04, -2.851885681212299e-06,  6.546272011032440e-08, -1.420331118540731e-09,  2.944752967099165e-11, -5.874346989730714e-13,  1.133126312734796e-14,
 -2.121085085037542e-16,  3.864693693992693e-18, -6.866433449174479e-20,  9.553927171957581e-02, -4.319443854865707e-03,  1.803217822482978e-04, -6.361272108624531e-06,
  2.011061679745526e-07, -5.845923000334151e-09,  1.587039174183343e-10, -4.066190400608764e-12,  9.908162922253127e-14, -2.309203446366654e-15,  5.170679236145437e-17,
 -1.115777252318416e-18,  3.553187383587547e-02, -2.851099865523024e-03,  1.707868023689417e-04, -8.252154232835284e-06,  3.452035044287547e-07, -1.292924234445903e-08,
  4.427706268984760e-10, -1.406141338077107e-11,  4.183310571884806e-13, -1.174705430332910e-14,  3.131783408271038e-16, -7.959184400602336e-18,  9.876396448935522e-03,
 -1.280430835343396e-03,  1.070245030579075e-04, -6.900973649507357e-06,  3.725037742557284e-07, -1.755663301493194e-08,  7.415090328273101e-10, -2.855751064730835e-11,
  1.015440583096812e-12, -3.364740959740758e-14,  1.046472534790495e-15, -3.069987568085964e-17,  2.162644752116104e-03, -4.198844733117946e-04,  4.782067605563821e-05,
 -4.024774645172899e-06,  2.748383428253463e-07, -1.599873775120796e-08,  8.184096857058965e-10, -3.755069515682232e-11,  1.568154174238500e-12, -6.026249672229549e-14,
  2.149243083853961e-15, -7.155576883253703e-17,  4.090075614107380e-04, -1.107812539897086e-04,  1.663953895953710e-05, -1.780154021998797e-06,  1.502449258176971e-07,
 -1.056999321387883e-08,  6.414037238546015e-10, -3.435924259105007e-11,  1.652233649853819e-12, -7.222466080364123e-14,  2.898341217719230e-15, -1.074963753858081e-16,
  7.611349204043744e-05, -2.652845106183491e-05,  4.989306009759591e-06, -6.503934683492716e-07,  6.537313463435775e-08, -5.373073382633915e-09,  3.747510841332706e-10,
 -2.275147768109141e-11,  1.224796120737939e-12, -5.929427716447494e-14,  2.610054107146315e-15, -1.052629384824093e-16,  1.422373934995473e-05, -5.766532063971229e-06,
  1.251136963749588e-06, -1.852486901967941e-07,  2.084302722759449e-08, -1.893275876407576e-09,  1.443263043380723e-10, -9.485002917026166e-12,  5.481055978267481e-13,
 -2.827373939790492e-14,  1.317555828779695e-15, -5.592391185747382e-17,  2.496881135441485e-01, -2.874217768436429e-03,  3.683065676645188e-05, -5.006499805922751e-07,
  6.930668083785456e-09, -9.648254730847836e-11,  1.322497989991237e-12, -1.822025909307550e-14,  2.411642031359475e-16, -3.267497380738924e-18,  4.476568915357538e-20,
 -4.621808405816856e-22,  1.712444599627370e-01, -3.488013956477979e-03,  8.661914465707474e-05, -1.998271704891681e-06,  4.297648331166434e-08, -8.761132535579889e-10,
  1.711067833279786e-11, -3.222106729543634e-13,  5.879257309563153e-15, -1.042598898010335e-16,  1.802630675663983e-18, -3.045065469695947e-20,  8.073018463474384e-02,
 -3.135220084211757e-03,  1.200126165672352e-04, -3.905095776500938e-06,  1.146254562476286e-07, -3.109592295054649e-09,  7.911471762236758e-11, -1.905933976222592e-12,
  4.380027531068392e-14, -9.651352804569769e-16,  2.047887524744398e-17, -4.197593802423426e-19,  2.634357618018586e-02, -1.803483973628923e-03,  9.792776830229117e-05,
 -4.331126239480616e-06,  1.674197088478445e-07, -5.833386786848708e-09,  1.868354510015965e-10, -5.573680686556864e-12,  1.563539562904666e-13, -4.153581074939830e-15,
  1.050678263054619e-16, -2.540527050507328e-18,  6.056986449882017e-03, -6.756883333962735e-04,  5.090772267263970e-05, -3.000794337056539e-06,  1.496660141406419e-07,
 -6.568557337437641e-09,  2.599347576959275e-10, -9.427753236611633e-12,  3.170897019187894e-13, -9.976483599786059e-15,  2.956143429747695e-16, -8.288171853392883e-18,
  1.022807489597587e-03, -1.745713827763738e-04,  1.802826733902892e-05, -1.396278207570836e-06,  8.867033446835001e-08, -4.838578534255336e-09,  2.335141781933027e-10,
 -1.016208037790559e-11,  4.043418107409837e-13, -1.486339599129509e-14,  5.088398720335837e-16, -1.631328035916093e-17,  1.386177605739137e-04, -3.415256998091860e-05,
  4.745142389388187e-06, -4.750652516951814e-07,  3.785133700900777e-08, -2.531223340277891e-09,  1.468244378704399e-10, -7.553684674640954e-12,  3.502440544534511e-13,
 -1.481388016216493e-14,  5.769361085868251e-16, -2.082309218731718e-17,  1.772543136666661e-05, -5.865435604233206e-06,  1.053513254303184e-06, -1.319838491818309e-07,
  1.281647758979503e-08, -1.022098100782354e-09,  6.941786077259522e-11, -4.116294352377732e-12,  2.169914584817819e-13, -1.030929930493213e-14,  4.462003612909915e-16,
 -1.772369104105396e-17,  2.433748255205651e-06, -9.716415483050967e-07,  2.077341239070665e-07, -3.035703062279207e-08,  3.376131952904278e-09, -3.035250131807723e-10,
  2.292625485053129e-11, -1.494330317927934e-12,  8.571375599009718e-14, -4.391910833053035e-15,  2.034180600598031e-16, -8.586308212774355e-18,  2.387449647399350e-01,
 -2.601854822849220e-03,  3.142966990244810e-05, -4.036310066583404e-07,  5.281180986752177e-09, -7.008973418782233e-11,  9.049585371196598e-13, -1.207194539369782e-14,
  1.519593221821708e-16, -1.766734145709578e-18,  3.272031456090402e-20, -1.285356029740727e-22,  1.585413547610106e-01, -2.880488784279607e-03,  6.625211878843086e-05,
 -1.431238729437789e-06,  2.892678546086690e-08, -5.554887928877465e-10,  1.024431821206093e-11, -1.824625926514307e-13,  3.155854421994135e-15, -5.313124448405127e-17,
  8.718097761142023e-19, -1.406314028082445e-20,  6.985125019036469e-02, -2.335521730580459e-03,  8.239384569870042e-05, -2.481114644453654e-06,  6.779882853990315e-08,
 -1.720083366484659e-09,  4.109567513961769e-11, -9.322878344148274e-13,  2.023454477724018e-14, -4.221712348456304e-16,  8.491468315769633e-18, -1.655935615516140e-19,
  2.042163361224380e-02, -1.189929107072028e-03,  5.884184830396719e-05, -2.386531286059323e-06,  8.537751926456718e-08, -2.770503536532985e-09,  8.306397950969849e-11,
 -2.329002816224676e-12,  6.162669884073832e-14, -1.549092216327418e-15,  3.717658822346299e-17, -8.551789063134299e-19,  3.987320274441463e-03, -3.799120249372489e-04,
  2.582538083466517e-05, -1.390845117613471e-06,  6.406343600873061e-08, -2.616267555171073e-09,  9.692212659934378e-11, -3.307254281111461e-12,  1.050969250097191e-13,
 -3.135799321414670e-15,  8.840726200447434e-17, -2.365566918976456e-18,  5.332219788758744e-04, -7.901646555131294e-05,  7.365691077603775e-06, -5.228462076613096e-07,
  3.077114949989370e-08, -1.568964054506279e-09,  7.121807675567770e-11, -2.930920515147691e-12,  1.107973519356228e-13, -3.885177279005529e-15,  1.273308471800844e-16,
 -3.920698669231963e-18,  5.250783570391806e-05, -1.158499078005045e-05,  1.474857929290641e-06, -1.371444432383627e-07,  1.025057152935069e-08, -6.479952829736231e-10,
  3.575253692905953e-11, -1.758628889436378e-12,  7.830625772096546e-14, -3.192630840687799e-15,  1.202538189062302e-16, -4.210174584222687e-18,  4.519867452695624e-06,
 -1.401411442685844e-06,  2.380242287543090e-07, -2.843193494389465e-08,  2.649893109521802e-09, -2.039093587191787e-10,  1.342135103826554e-11, -7.740918629705124e-13,
  3.981308624870697e-14, -1.850339019500951e-15,  7.851917475828318e-17, -3.064047843839426e-18,  4.314432444768758e-07, -1.688456593485153e-07,  3.543110247993082e-08,
 -5.093478482943549e-09,  5.584006162683196e-10, -4.957350423843927e-11,  3.702997843447459e-12, -2.389840310644748e-13,  1.358720571745395e-14, -6.906843509344043e-16,
  3.176119633134568e-17, -1.331961576048851e-18,  2.288116407312029e-01, -2.368454673074162e-03,  2.705036283302764e-05, -3.292721072921475e-07,  4.071819748872098e-09,
 -5.192738621805893e-11,  6.272081052843869e-13, -7.983276816994449e-15,  1.108307945986327e-16, -5.468559236936286e-19,  2.803335463796641e-20, -1.651184917056122e-22,
  1.479807537874760e-01, -2.412068622521906e-03,  5.152657781094163e-05, -1.045482002696332e-06,  1.991408652213382e-08, -3.610746171405112e-10,  6.303432597378696e-12,
 -1.063952847463811e-13,  1.746029458837823e-15, -2.805379615822807e-17,  4.349887036028173e-19, -6.720144100106533e-21,  6.166187834117353e-02, -1.779328829378108e-03,
  5.814605801127889e-05, -1.625676307941195e-06,  4.147177113917222e-08, -9.858769096913890e-10,  2.216805860559434e-11, -4.743867145947656e-13,  9.729649108700975e-15,
 -1.928718608462994e-16,  3.672640266778890e-18, -6.820686002333765e-20,  1.645001251153823e-02, -8.141283992305238e-04,  3.686985274967432e-05, -1.374190918007377e-06,
  4.558589336281391e-08, -1.379505310779334e-09,  3.876399632158218e-11, -1.022451303762819e-12,  2.553137132473485e-14, -6.077467059285353e-16,  1.383696813029143e-17,
 -3.028376526569497e-19,  2.795403515514875e-03, -2.259324411465158e-04,  1.389592477284422e-05, -6.838251779183692e-07,  2.909494355688364e-08, -1.105492044202235e-09,
  3.832780327466699e-11, -1.229816444575969e-12,  3.689842339063356e-14, -1.043263720275765e-15,  2.795805389432687e-17, -7.132045321119815e-19,  3.045630703040809e-04,
 -3.871337088836231e-05,  3.248965620070006e-06, -2.107341981307178e-07,  1.146449873781238e-08, -5.448401882701247e-10,  2.320437566544271e-11, -9.009076622476382e-13,
  3.227926725395664e-14, -1.077176390841401e-15,  3.371679348568028e-17, -9.947968633081081e-19,  2.228052325753042e-05, -4.329285171530467e-06,  5.006157425152939e-07,
 -4.293440692220317e-08,  2.992606851245394e-09, -1.779000226127439e-10,  9.292326882990425e-12, -4.351269178629432e-13,  1.853138525097017e-14, -7.255989052986639e-16,
  2.634083091550465e-17, -8.916736395464951e-19,  1.279263497277242e-06, -3.656888674999246e-07,  5.807005242282457e-08, -6.554715001348032e-09,  5.820315972692754e-10,
 -4.294648627524227e-11,  2.724770107117284e-12, -1.521420075432358e-13,  7.603038091329953e-15, -3.444015057777684e-16,  1.428242290378666e-17, -5.459578406645819e-19,
  8.000378383224474e-08, -3.049368301342897e-08,  6.247032065079866e-09, -8.796287700276051e-10,  9.472415011728549e-11, -8.279700649932586e-12,  6.101140536912373e-13,
 -3.890625355878684e-14,  2.188573382670325e-15, -1.102016224157331e-16,  5.024657090741506e-18, -2.091097786825435e-19,  2.197470689480402e-01, -2.166823261131964e-03,
  2.345817882774626e-05, -2.716824448989182e-07,  3.167716606044724e-09, -3.916693618636216e-11,  4.517962479906670e-13, -4.556473250689587e-15,  1.084659365766415e-16,
  2.994040419831328e-19,  1.011171291656750e-20, -7.328922431747146e-22,  1.390844329689755e-01, -2.045122540899642e-03,  4.067834452462933e-05, -7.773190503458897e-07,
  1.399317868918312e-08, -2.400534040135571e-10,  3.975731627933793e-12, -6.382514643058851e-14,  9.894149555210617e-16, -1.535575179161956e-17,  2.252220312667640e-19,
 -3.214151495717598e-21,  5.536551001196188e-02, -1.382243339958785e-03,  4.205121425738285e-05, -1.094917564080580e-06,  2.615653435319083e-08, -5.835852781573550e-10,
  1.237293264046744e-11, -2.507498259968806e-13,  4.840757709755286e-15, -9.188620125781675e-17,  1.658932296359914e-18, -2.894161037307023e-20,  1.369408036456138e-02,
 -5.745421943681896e-04,  2.398597755271927e-05, -8.232879213811302e-07,  2.538365558229965e-08, -7.173469616781591e-10,  1.891773852361865e-11, -4.702008138656369e-13,
  1.107619602574272e-14, -2.501493751264793e-16,  5.405671455463266e-18, -1.124098501123852e-19,  2.071343079035613e-03, -1.410801797166293e-04,  7.888360725420655e-06,
 -3.548918821579897e-07,  1.396073779867672e-08, -4.936925055724236e-10,  1.602141077666285e-11, -4.834351601407873e-13,  1.368839140112024e-14, -3.666533557056498e-16,
  9.334558868362823e-18, -2.268271056826981e-19,  1.891920274875428e-04, -2.038551963520529e-05,  1.539944258770969e-06, -9.107666314504003e-08,  4.572807973942834e-09,
 -2.021993813912640e-10,  8.065423376545480e-12, -2.948772289329984e-13,  9.994657889834954e-15, -3.167934363329235e-16,  9.451808432960133e-18, -2.666798957218007e-19,
  1.058174434490295e-05, -1.779465195128785e-06,  1.855589548166934e-07, -1.458665037734184e-08,  9.432179651453293e-10, -5.248045225811713e-11,  2.583937179436494e-12,
 -1.147225765855561e-13,  4.655509537912852e-15, -1.744391057394878e-16,  6.082685864864371e-18, -1.984552567362353e-19,  4.071242780982345e-07, -1.052309375941582e-07,
  1.542990151965019e-08, -1.629885527503826e-09,  1.367893849619070e-10, -9.613016676488462e-12,  5.844595961729140e-13, -3.143115431277637e-14,  1.519234531186071e-15,
 -6.680276643680828e-17,  2.697549657828448e-18, -1.006824148745256e-19,  1.571682831944782e-08, -5.780907055418242e-09,  1.147810146255397e-09, -1.573960749361711e-10,
  1.657191581780260e-11, -1.420783314871971e-12,  1.029548383229652e-13, -6.469888002573336e-15,  3.592874183958874e-16, -1.788589121941366e-17,  8.072538825219782e-19,
 -3.329108612204058e-20,  2.114356014052380e-01, -1.991392861282728e-03,  2.047804726332809e-05, -2.267127271379970e-07,  2.484548535282469e-09, -2.945166527359585e-11,
  3.745485996439668e-13, -9.125302332147216e-16,  1.165597696402005e-16, -1.815263315489951e-19, -3.991865398561229e-20, -1.504313227383201e-21,  1.315006514209296e-01,
 -1.753534929496858e-03,  3.255070091046771e-05, -5.872016105671393e-07,  1.001805985807399e-08, -1.629581219908551e-10,  2.559766062546054e-12, -3.950815005421030e-14,
  5.704362665090461e-16, -8.562126849653255e-18,  1.273665412928819e-19, -1.432068812417192e-21,  5.043513592082866e-02, -1.092068013646973e-03,  3.108448617458113e-05,
 -7.557596613973339e-07,  1.696461572159637e-08, -3.560357885955326e-10,  7.102075402394354e-12, -1.380785028961695e-13,  2.476444067069810e-15, -4.506336790438745e-17,
  8.022374758453054e-19, -1.227803128791905e-20,  1.172560499569217e-02, -4.162175632726571e-04,  1.613911050508212e-05, -5.111055575953859e-07,  1.468699338843526e-08,
 -3.882946409968933e-10,  9.610091161834189e-12, -2.261639319055213e-13,  5.011634067966533e-15, -1.075151810785306e-16,  2.220195788357094e-18, -4.346658416951926e-20,
  1.610782781439405e-03, -9.184516969628967e-05,  4.700998736160471e-06, -1.934649988658196e-07,  7.047683610215563e-09, -2.321479566213790e-10,  7.052611122961732e-12,
 -2.003538387167145e-13,  5.350343011414055e-15, -1.357740513128904e-16,  3.285420297740032e-18, -7.594246828818385e-20,  1.267897349260580e-04, -1.144455195439638e-05,
  7.802753147622290e-07, -4.201654934863854e-08,  1.945751114318846e-09, -7.997045794033261e-11,  2.983907331260896e-12, -1.026150396909514e-13,  3.285285848099285e-15,
 -9.876172071371356e-17,  2.804476541405165e-18, -7.553945268696120e-20,  5.603442042132209e-06, -8.008844165849947e-07,  7.495616314074196e-08, -5.372516502568023e-09,
  3.209259798790419e-10, -1.664644525094300e-11,  7.696810396978950e-13, -3.228577873704662e-14,  1.244140283049218e-15, -4.446418710044232e-17,  1.484611554293159e-18,
 -4.654306778936436e-20,  1.472797831278680e-07, -3.364431850943395e-08,  4.497530855313771e-09, -4.401393272037828e-10,  3.462630157273323e-11, -2.301290216311833e-12,
  1.332533760842027e-13, -6.864337041437542e-15,  3.193537418075548e-16, -1.357164875517441e-17,  5.315359639628002e-19, -1.930178635021756e-20,  3.326609889015424e-09,
 -1.165144484319611e-09,  2.220139863610267e-10, -2.942393689534731e-11,  3.010783946161406e-12, -2.519503720021246e-13,  1.788173627392685e-14, -1.103682374874023e-15,
  6.033432123763767e-17, -2.962305830251114e-18,  1.320733463273882e-19, -5.387806115422702e-21,  2.037813475750184e-01, -1.837816503238018e-03,  1.797814927194184e-05,
 -1.911851218065968e-07,  1.985439089372584e-09, -2.036801535402289e-11,  3.972558519890572e-13,  2.269387300085012e-15,  6.458188296740677e-17, -3.160487081626914e-18,
 -1.071462624816563e-19, -1.203915161141381e-21,  1.249662411687408e-01, -1.518817825515377e-03,  2.636832976512638e-05, -4.499903488110351e-07,  7.293207748662152e-09,
 -1.129881299575860e-10,  1.669144899938829e-12, -2.530730133682253e-14,  3.414767072506234e-16, -4.438083943721465e-18,  8.429840327681650e-20, -6.829649800898698e-22,
  4.651264737135411e-02, -8.755411505146137e-04,  2.343574716274281e-05, -5.332010392020833e-07,  1.127588597727875e-08, -2.243261870508610e-10,  4.140284716979527e-12,
 -7.949059461198475e-14,  1.325531897417324e-15, -2.125249395823284e-17,  4.379321285796496e-19, -5.410185697183540e-21,  1.028506908564458e-02, -3.081611827333061e-04,
  1.119492656340917e-05, -3.275767317717757e-07,  8.795031079733581e-09, -2.185660891348171e-10,  5.044419978636190e-12, -1.137130004033032e-13,  2.368778683958910e-15,
 -4.747033636469012e-17,  9.682989827582140e-19, -1.752269242145498e-20,  1.306221023133346e-03, -6.190787768242152e-05,  2.928084845769394e-06, -1.102584907486347e-07,
  3.726618916790728e-09, -1.146059130891523e-10,  3.253813432108623e-12, -8.732755251451229e-14,  2.198805941367494e-15, -5.272845683656473e-17,  1.218545377253969e-18,
 -2.671332249419703e-20,  9.091639818347610e-05, -6.790282874222839e-06,  4.204590493475319e-07, -2.058753157098772e-08,  8.795796478765500e-10, -3.360216489914452e-11,
  1.171427312034587e-12, -3.788660086862551e-14,  1.144529888743383e-15, -3.258874428869433e-17,  8.801753986098728e-19, -2.259726285233394e-20,  3.287447644628873e-06,
 -3.918584735165028e-07,  3.287987469831182e-08, -2.139473105123391e-09,  1.176960311956216e-10, -5.673921009124708e-12,  2.455923867155219e-13, -9.704809961475306e-15,
  3.540811685333941e-16, -1.203509974542655e-17,  3.836970641900822e-19, -1.152643741861829e-20,  6.100478844877368e-08, -1.199793089350622e-08,  1.445227206490485e-09,
 -1.297457418128206e-10,  9.491666135831976e-12, -5.924216724875526e-13,  3.246806400610883e-14, -1.593229084189191e-15,  7.098654941330223e-17, -2.902306056804481e-18,
  1.097893109849597e-19, -3.864168200990374e-21,  7.753736208997374e-10, -2.536369583065080e-10,  4.577420422972727e-11, -5.805421541627949e-12,  5.728618262613709e-13,
 -4.650128074665902e-14,  3.216071720049753e-15, -1.941382434162013e-16,  1.041041610947570e-17, -5.026060852358410e-19,  2.207938831137303e-20, -8.890155643297825e-22,
  1.967039278563267e-01, -1.702655630599967e-03,  1.586283067190398e-05, -1.621348037979856e-07,  1.679213951172602e-09, -9.974407778029794e-12,  4.663198059277395e-13,
  1.625189255112647e-15, -1.325848953092925e-16, -7.724029515480134e-18, -9.308750610460052e-20,  2.666889542262137e-21,  1.192812544951295e-01, -1.327645684390737e-03,
  2.160046332365843e-05, -3.494209445027843e-07,  5.382478191957322e-09, -8.032290394814757e-11,  1.093811366157942e-12, -1.634296789563788e-14,  2.352832696089904e-16,
 -1.668696513071233e-18,  5.218987515317325e-20, -9.545270446748538e-22,  4.334885182358354e-02, -7.108911162879342e-04,  1.798737538026894e-05, -3.839585905593161e-07,
  7.624923418050562e-09, -1.474717171501789e-10,  2.415021324908759e-12, -4.635165453226779e-14,  8.252604526370247e-16, -7.816275860889670e-18,  2.412126948510385e-19,
 -4.390271036871096e-21,  9.209634585636695e-03, -2.322275006470731e-04,  7.982756499194482e-06, -2.161951945555706e-07,  5.414901867524374e-09, -1.284868552183465e-10,
  2.710462753104053e-12, -5.905990924603137e-14,  1.204871137432673e-15, -2.062707742368844e-17,  4.411984793438571e-19, -8.149855080131238e-21,  1.098290878721926e-03,
 -4.291221633295978e-05,  1.898872246544267e-06, -6.543443362211563e-08,  2.052069479225332e-09, -5.937242465671667e-11,  1.564113305176826e-12, -3.982656819288611e-14,
  9.541312411940583e-16, -2.125431374670177e-17,  4.749083887282830e-19, -9.977147866737082e-21,  6.919900790538785e-05, -4.218247409662411e-06,  2.397866168446582e-07,
 -1.066111346856760e-08,  4.202923876132562e-10, -1.496104000967762e-11,  4.860999735228134e-13, -1.479728288370775e-14,  4.221448899578695e-16, -1.134838943405141e-17,
  2.918460083687372e-19, -7.139011285745255e-21,  2.119471872475160e-06, -2.064247903143269e-07,  1.559121455230757e-08, -9.175189733156026e-10,  4.638670701162706e-11,
 -2.074877703188006e-12,  8.384359464252034e-14, -3.114550321489588e-15,  1.073452815199845e-16, -3.460923156315788e-18,  1.051228678011191e-19, -3.018586620243686e-21,
  2.900647123905153e-08, -4.767669783766717e-09,  5.130976105246578e-10, -4.187071757925296e-11,  2.827669618520700e-12, -1.646779425151550e-13,  8.491831636104922e-15,
 -3.948134448825307e-16,  1.676325244562325e-17, -6.563532202562722e-19,  2.387993961660202e-20, -8.114392904921980e-22,  2.045015622332332e-10, -6.074050233209507e-11,
  1.020829823711011e-11, -1.223492773875625e-12,  1.153032861671896e-13, -9.008798980320036e-15,  6.033146825742327e-16, -3.543262154418091e-17,  1.855623465396324e-18,
 -8.776716024575947e-20,  3.786979619625595e-21, -1.500951144340418e-22,  1.901354182235196e-01, -1.583089890316756e-03,  1.407381812442022e-05, -1.362518408190868e-07,
  1.591691902425534e-09,  1.009285303325513e-12,  4.074538379053131e-13, -7.427492241328506e-15, -4.296210502747847e-16, -6.890532434733711e-18,  1.928353663803646e-19,
  1.039630860162354e-20,  1.142916398863557e-01, -1.170263685466281e-03,  1.787534747267863e-05, -2.748674939972442e-07,  4.005675474038175e-09, -5.875531508624432e-11,
  7.349018442599537e-13, -9.470599596343566e-15,  2.001504631166479e-16, -7.021654879971622e-19, -1.114647804491226e-20, -1.908693740842862e-21,  4.076656029884661e-02,
 -5.835538258665041e-04,  1.402365210592779e-05, -2.827964369548822e-07,  5.164498204940229e-09, -1.023046687715978e-10,  1.455495161840778e-12, -2.299959375388913e-14,
  6.648930959299443e-16, -2.739892937508095e-18, -8.903436883097536e-21, -7.194853723590649e-21,  8.393865556395885e-03, -1.774448019460171e-04,  5.833527831134013e-06,
 -1.470718048229889e-07,  3.381724261185417e-09, -7.950352058110055e-11,  1.505487344728250e-12, -2.961498227799576e-14,  7.030804274549602e-16, -9.173379572227823e-18,
  1.474798950901809e-19, -5.846269462052905e-21,  9.527346290884084e-04, -3.038258139327650e-05,  1.277174733611558e-06, -4.038630115883412e-08,  1.164928816376758e-09,
 -3.235983609399624e-11,  7.832509861218387e-13, -1.859100997950307e-14,  4.455165736770613e-16, -8.898077004832541e-18,  1.838105267230673e-19, -4.254064586731935e-21,
  5.548822033634546e-05, -2.716593442513086e-06,  1.440523732164511e-07, -5.813883348914454e-09,  2.107134405078453e-10, -7.049967131026790e-12,  2.125707514566588e-13,
 -6.069921124538217e-15,  1.652303864108765e-16, -4.158534518434522e-18,  1.014060063461688e-19, -2.402798067503021e-21,  1.487899066409825e-06, -1.156855068753347e-07,
  7.951916275040869e-09, -4.218802372682082e-10,  1.955349042397857e-11, -8.124202875472188e-13,  3.056045039260082e-14, -1.065112860779548e-15,  3.466524071881177e-17,
 -1.056868838775377e-18,  3.052610433503223e-20, -8.371856012684657e-22,  1.579118955927077e-08, -2.096961475637216e-09,  2.011412312256458e-10, -1.479754138645534e-11,
  9.167504960312936e-13, -4.955473742649651e-14,  2.391205759406742e-15, -1.048197365256977e-16,  4.221714118937320e-18, -1.575924178613040e-19,  5.491965969217084e-21,
 -1.794718928597887e-22,  6.296761648665559e-11, -1.631002623852383e-11,  2.502190648254422e-12, -2.791165238296249e-13,  2.483060227121852e-14, -1.849963608968625e-15,
  1.190490537496005e-16, -6.759207140427914e-18,  3.438671304454044e-19, -1.586170749705145e-20,  6.696349489810265e-22, -2.603930964242221e-23,  1.840185016204132e-01,
 -1.476601980075020e-03,  1.259372018396535e-05, -1.101928511536073e-07,  1.684089133847847e-09,  6.586629749867816e-12, -1.412617110482932e-14, -2.269586466385182e-14,
 -4.204323654263301e-16,  1.055345504028590e-17,  6.498168590497498e-19,  5.815131941433877e-21,  1.098771285668382e-01, -1.039448479615756e-03,  1.492559232747116e-05,
 -2.192967262056200e-07,  2.989082996273116e-09, -4.360663669788938e-11,  5.540082625222273e-13, -3.723191068242499e-15,  1.464981624919012e-16, -2.787073150955257e-18,
 -8.489071729501438e-20, -7.156310928698566e-22,  3.863702346005247e-02, -4.836781824720412e-04,  1.106401664972501e-05, -2.148122643144481e-07,  3.427539474927928e-09,
 -7.280582002481030e-11,  1.090354632587839e-12, -4.009556044178732e-15,  4.813547430857489e-16, -9.502453054035864e-18, -3.077058685637294e-19, -3.943925578609443e-21,
  7.767399159990707e-03, -1.370255143672312e-04,  4.346530415679906e-06, -1.039614240801079e-07,  2.097757471608856e-09, -5.105665051304493e-11,  9.469050524833852e-13,
 -1.174341810408620e-14,  4.205526093709217e-16, -7.981945935007717e-18, -6.953761899615412e-20, -3.164171653648335e-21,  8.489596376375998e-04, -2.183018938888457e-05,
  8.859020364584991e-07, -2.605501555791063e-08,  6.707760021952230e-10, -1.845079377437982e-11,  4.223784741404934e-13, -8.357892615334553e-15,  2.197187148103041e-16,
 -4.510843218567135e-18,  5.231043536952457e-20, -1.892245753798324e-21,  4.655357959947930e-05, -1.795090497284904e-06,  9.062378968597590e-08, -3.341839731167830e-09,
  1.095528444769235e-10, -3.505041683674591e-12,  9.869972697219031e-14, -2.564767021021845e-15,  6.852212294051805e-17, -1.643608500335756e-18,  3.532104310981306e-20,
 -8.629449358776472e-22,  1.126479336201962e-06, -6.802037658747827e-08,  4.336262734922034e-09, -2.074251901109194e-10,  8.748345094046566e-12, -3.397237686369679e-13,
  1.188585049520441e-14, -3.859827778684399e-16,  1.192108155965029e-17, -3.433258539959036e-19,  9.342055646611358e-21, -2.465000351671909e-22,  9.770292277651533e-09,
 -1.007855920117375e-09,  8.678635014350046e-11, -5.718193735038668e-12,  3.229630112034967e-13, -1.615707755242440e-14,  7.260948968914674e-16, -2.986722303453764e-17,
  1.137190688992973e-18, -4.029944191248280e-20,  1.339582866055165e-21, -4.197002654878602e-23,  2.334424025860498e-11, -4.987068711563671e-12,  6.846775626212072e-13,
 -6.986000755283357e-14,  5.789634095825695e-15, -4.069704038687773e-16,  2.494214629352135e-17, -1.358855328492073e-18,  6.673254317167421e-20, -2.985851128139124e-21,
  1.227663379386078e-22, -4.665183925371126e-24,  1.783058768899653e-01, -1.380674673836489e-03,  1.143672327883382e-05, -8.244910125182175e-08,  1.755258591767328e-09,
 -2.364195210648865e-12, -7.444921694664217e-13, -2.503614805544715e-14,  4.129683672883920e-16,  3.289014605071933e-17,  2.038914436847393e-19, -2.910934709003433e-20,
  1.059425437328240e-01, -9.298186839158426e-04,  1.255446636474529e-05, -1.777533677024194e-07,  2.243726246084667e-09, -3.114793587383641e-11,  4.956614272439083e-13,
 -1.277887079244825e-15, -1.011739364666462e-17, -5.401484379546882e-18, -6.423360848688447e-21,  4.484867804157194e-21,  3.686419107380619e-02, -4.046462536420237e-04,
  8.771827584523439e-06, -1.702105144425867e-07,  2.231346299935517e-09, -4.664851095910171e-11,  1.124721346559799e-12,  3.480293733516103e-15, -8.083075375547097e-17,
 -2.029998046164507e-17, -8.389568666644048e-20,  1.575016910080626e-20,  7.281653288528907e-03, -1.067428697210178e-04,  3.270432898946404e-06, -7.741966905779631e-08,
  1.283895390649718e-09, -3.104507384233525e-11,  7.585367843969244e-13, -3.558579551844716e-15,  7.061956850728442e-17, -1.113195744971097e-17, -1.638231134397883e-20,
  6.392883341896593e-21,  7.740578217413057e-04, -1.583597288009196e-05,  6.270559934453014e-07, -1.779102511781467e-08,  3.876863414060523e-10, -1.046637207900445e-11,
  2.645101618950611e-13, -3.644093011487230e-15,  8.108517795687653e-17, -3.396970198899298e-18,  2.151744049271249e-20,  5.659853270200379e-22,  4.060518713300422e-05,
 -1.205306884104680e-06,  5.908502320240660e-08, -2.041672523009562e-09,  5.840194052185717e-11, -1.796734484417532e-12,  5.027202733559566e-14, -1.106497092558515e-15,
  2.769956431684562e-17, -7.701243303363513e-19,  1.297308957135799e-20, -2.217388752429304e-22,  9.108001116774760e-07, -4.133835118130720e-08,  2.504541499694964e-09,
 -1.093318908799861e-10,  4.113322997817604e-12, -1.503323109054096e-13,  4.973645162251174e-15, -1.470942824108690e-16,  4.301452166380019e-18, -1.209901900371328e-19,
  3.001030083071883e-21, -7.414878716455713e-23,  6.790832924985608e-09, -5.197611428707279e-10,  4.094573057573386e-11, -2.413581891739797e-12,  1.230146728539706e-13,
 -5.698215241591698e-15,  2.381915592804291e-16, -9.126468470804958e-18,  3.278601352655831e-19, -1.102176705703910e-20,  3.468968867899693e-22, -1.038953747570933e-23,
  1.065375601987904e-11, -1.745607692287762e-12,  2.117936948842776e-13, -1.941544581765704e-14,  1.477600239533942e-15, -9.693294697178240e-17,  5.602832392908673e-18,
 -2.904216130940754e-19,  1.367126223458149e-20, -5.896848822322657e-22,  2.348413979971704e-23, -8.681111511259699e-25,  1.729605597157126e-01, -1.292671940375454e-03,
  1.061057786186618e-05, -5.591152444850040e-08,  1.484851517937591e-09, -2.607206318342548e-11, -1.088221721317160e-12,  5.722706336429103e-15,  1.370005572223251e-15,
  9.417064888838705e-18, -1.369654991276134e-18, -2.666348652042028e-20,  1.024114355772057e-01, -8.373480376204294e-04,  1.061831998333051e-05, -1.462061339504882e-07,
  1.735904014531588e-09, -1.988885325849573e-11,  4.282626246200646e-13, -4.326961154923205e-15, -1.551285016981495e-16, -1.178438761689393e-18,  2.065556116493518e-19,
  2.859338708021759e-21,  3.537379479809206e-02, -3.420960753490537e-04,  6.917532571089746e-06, -1.404867971977500e-07,  1.571866186628534e-09, -1.943762325830088e-11,
  1.080696686344253e-12, -9.827609365999728e-15, -6.684252332592487e-16, -6.410896237856246e-18,  7.750434339226241e-19,  1.454381729307526e-20,  6.901563535912120e-03,
 -8.398725908970533e-05,  2.447273432154666e-06, -6.088936568871530e-08,  8.367559538401441e-10, -1.413892824487929e-11,  6.332905019607115e-13, -7.147598899714347e-15,
 -2.544684617011047e-16, -4.283011683714739e-18,  3.662489998102231e-19,  7.014900307002938e-21,  7.195252378722697e-04, -1.158186703057052e-05,  4.449059607208732e-07,
 -1.294853315473538e-08,  2.346399151655912e-10, -5.154498520968991e-12,  1.820641756539062e-13, -2.755689472213328e-15, -1.459377048587895e-17, -1.528134187823717e-18,
  7.727861432368580e-20,  1.218469515235991e-21,  3.659345877486917e-05, -8.170928026057853e-07,  3.919294875959676e-08, -1.338191865471608e-09,  3.244385202380608e-11,
 -8.842039656847152e-13,  2.816986474247133e-14, -5.757159465274748e-16,  7.981683596380385e-18, -3.407947737115688e-19,  1.027786133858986e-20,  1.792729403612407e-23,
  7.785341677009046e-07, -2.562346740110920e-08,  1.505976467663869e-09, -6.225124798212875e-11,  2.032632785430496e-12, -6.816283774806740e-14,  2.262272125273999e-15,
 -6.099782893601939e-17,  1.519815654112674e-18, -4.533756242301562e-20,  1.170391647541084e-21, -1.998095738410574e-23,  5.221409130307193e-09, -2.815891440302798e-10,
  2.084276886672311e-11, -1.115918894850345e-12,  5.037757033828273e-14, -2.151719726176481e-15,  8.480805458613788e-17, -2.998965200388427e-18,  1.000769058425109e-19,
 -3.238278593566734e-21,  9.678997064082418e-23, -2.679544662571569e-24,  6.004116875653303e-12, -6.919891464468620e-13,  7.449228073502127e-14, -6.052084001447424e-15,
  4.159617487718101e-16, -2.521629765488011e-17,  1.362808956596253e-18, -6.655296677822233e-20,  2.979542356457413e-21, -1.231714390590057e-22,  4.720921591576677e-24,
 -1.687359087602486e-25,  1.679558990078500e-01, -1.210115405861880e-03,  1.006074518287351e-05, -3.760087203449550e-08,  7.406511392903123e-10, -4.541238371100103e-11,
 -3.460348856135987e-13,  4.334233513082249e-14,  6.308361214883723e-16, -4.726433352630630e-17, -8.795276421064493e-19,  4.957486171045269e-20,  9.922145588248185e-02,
 -7.589740545540021e-04,  9.019038738669993e-06, -1.211066322827517e-07,  1.428248699256442e-09, -1.160477007403132e-11,  2.431348249961311e-13, -8.312534280563437e-15,
 -4.674710214909333e-17,  6.463140264174145e-18,  9.735939681580251e-20, -7.310657003289385e-21,  3.410598941846283e-02, -2.930926666383247e-04,  5.373964476636915e-06,
 -1.171752371741589e-07,  1.407639608612916e-09,  7.995859375296237e-13,  5.180207387175222e-13, -2.835116520754513e-14, -2.923658332701876e-16,  2.546797493881077e-17,
  4.955932623519973e-19, -2.759201947318513e-20,  6.600442525501325e-03, -6.712069761501784e-05,  1.790045350446907e-06, -4.902303616605181e-08,  6.847972841896983e-10,
 -2.293466674752585e-12,  3.181881788474906e-13, -1.462692393310435e-14, -1.176575612852660e-16,  1.117288361409913e-17,  2.559831322684710e-19, -1.261189044253037e-20,
  6.794137264570188e-04, -8.586754947246990e-06,  3.093411291655726e-07, -9.809212777274953e-09,  1.685905611483400e-10, -1.791418719106049e-12,  9.471964396214799e-14,
 -3.451357153520763e-15, -8.955757853569665e-18,  1.719469502397580e-18,  5.776653240238081e-20, -2.340722960641311e-21,  3.386142812752134e-05, -5.600885497248007e-07,
  2.577068510894425e-08, -9.289081580249329e-10,  2.032623175139775e-11, -3.812017691648876e-13,  1.434603455865950e-14, -4.378866516141141e-16,  2.935497455878572e-18,
  3.997451324828046e-20,  6.995099120836563e-21, -2.086000353873123e-22,  6.960697968541624e-07, -1.609782063998308e-08,  9.172776308759395e-10, -3.818343871300767e-11,
  1.097038255177184e-12, -3.008951778701485e-14,  1.045863282365333e-15, -3.085896763339920e-17,  5.615537411318603e-19, -1.186739334150264e-20,  5.502809434810049e-22,
 -1.275774520676456e-23,  4.359518874174121e-09, -1.573799196203295e-10,  1.116119177617096e-11, -5.667586546589632e-13,  2.239035025123776e-14, -8.478444306502566e-16,
  3.239084775597919e-17, -1.094958841587524e-18,  3.211959206767996e-20, -9.643916296388154e-22,  3.025598622389450e-23, -7.888537827297214e-25,  4.088744211904151e-12,
 -3.027004306449655e-13,  2.955558977422138e-14, -2.135985806035686e-15,  1.298627182507128e-16, -7.178511796451020e-18,  3.620207978017384e-19, -1.653039920339014e-20,
  6.944618703150038e-22, -2.735035427024743e-23,  1.008296916372509e-24, -3.454052605409813e-26,  1.632737439606268e-01, -1.131302647114839e-03,  9.650382606164823e-06,
 -3.303560219925621e-08, -1.477348288748345e-10, -3.857059207537636e-11,  8.736144996853652e-13,  3.432095276660811e-14, -1.109345058089291e-15, -3.348324600304024e-17,
  1.420820175984663e-18,  3.039532354908126e-20,  9.632118748426780e-02, -6.922623539776949e-04,  7.696021627460990e-06, -9.987365838756069e-08,  1.235736262141307e-09,
 -8.506236115046963e-12,  2.591284952213959e-14, -6.000300150516390e-15,  1.746208934376858e-16,  3.790352065034576e-18, -1.985188488849913e-19, -3.112721024676138e-21,
  3.301124285122604e-02, -2.553382570177157e-04,  4.104953042390793e-06, -9.412681411328080e-08,  1.482075998924222e-09,  3.567546134198753e-12, -2.570549796534122e-13,
 -2.188283213021714e-14,  6.508587168146022e-16,  1.808761265702920e-17, -7.820360084774166e-19, -1.687134395170455e-20,  6.357135612760400e-03, -5.496867046323135e-05,
  1.266952232244447e-06, -3.816000376071638e-08,  6.816578289251755e-10,  4.149252748171167e-13, -7.667478496081047e-14, -1.122714648762608e-14,  3.139807614175862e-16,
  8.572368362701223e-18, -3.554786721795496e-19, -8.631328403288778e-21,  6.493326258580654e-04, -6.539094574430920e-06,  2.069436800356963e-07, -7.307471646563701e-09,
  1.477823284889987e-10, -6.427783960119700e-13,  5.199643318717436e-15, -2.538507583638154e-15,  6.495376301511186e-17,  1.556693786513983e-18, -6.213512652544647e-20,
 -1.841093555879215e-21,  3.196997812774246e-05, -3.934596267019335e-07,  1.637324729327545e-08, -6.499191994453179e-10,  1.521802557470297e-11, -1.706604815701131e-13,
  3.881292721539232e-15, -2.879979397768192e-16,  6.772790906191363e-18,  9.789789996068051e-20, -3.935294274398676e-21, -1.845791540747710e-22,  6.438235220492788e-07,
 -1.033220950429244e-08,  5.482274846489054e-10, -2.434237266184916e-11,  6.855498966961657e-13, -1.359747133463386e-14,  3.929494130154577e-16, -1.659931797639713e-17,
  3.924637728136315e-19, -1.206979856993223e-21,  5.491687493300283e-24, -9.356005948441348e-24,  3.872694677744508e-09, -9.026340854339729e-11,  6.062597638307809e-12,
 -3.106055921821355e-13,  1.121367048096347e-14, -3.474139798720879e-16,  1.223232234708345e-17, -4.454175190070612e-19,  1.251592775506371e-20, -2.710428224562573e-22,
  7.816126423533560e-24, -3.035887317541157e-25,  3.227068553785019e-12, -1.419359466498040e-13,  1.283986574461002e-14, -8.562651062996458e-16,  4.562235418881597e-17,
 -2.223940987934398e-18,  1.042507586088082e-19, -4.518088737750555e-21,  1.763403175695133e-22, -6.412516182816181e-24,  2.268416869662575e-25, -7.655057455853604e-27,
  1.589003056715674e-01, -1.055775412869642e-03,  9.218702691390339e-06, -4.018698406420058e-08, -6.555429557779797e-10, -1.076866498219992e-11,  1.242200039496885e-12,
 -8.412959391707890e-15, -1.201039189631382e-15,  2.509195400404303e-17,  9.698744791314702e-19, -4.023552579548957e-20,  9.366814148279760e-02, -6.351649398224509e-04,
  6.610537398933182e-06, -8.147379912870085e-08,  1.061810325421824e-09, -9.200592924816503e-12, -5.483681502349279e-14,  1.707414269898230e-16,  1.651586205618548e-16,
 -3.686784902714398e-18, -1.109778384393347e-19,  5.382240719387160e-21,  3.204898792394827e-02, -2.266111927281417e-04,  3.118524250137328e-06, -7.033856690812516e-08,
  1.455963834205091e-09, -7.235285604137670e-12, -5.275642844078313e-13,  2.723543557515310e-15,  6.883976046795626e-16, -1.418366526427280e-17, -5.334987248374763e-19,
  2.225310424143998e-20,  6.154893238987518e-03, -4.647977897997601e-05,  8.741842845253121e-07, -2.737093843214929e-08,  6.527739684290393e-10, -3.886163822929240e-12,
 -2.258672720474341e-13,  6.729954432587649e-16,  3.360336345574955e-16, -6.639124464530238e-18, -2.599678893476503e-19,  1.039066820354187e-20,  6.259873705280788e-04,
 -5.195141043634445e-06,  1.329840593097250e-07, -5.058486537040157e-09,  1.317799368491515e-10, -1.103932296699339e-12, -3.231542659881798e-14, -1.246899858346228e-16,
  6.840646588152944e-17, -1.276713703251586e-18, -5.075310462630197e-20,  1.924412570347666e-21,  3.061424651421697e-05, -2.897687054468355e-07,  9.932540269066886e-09,
 -4.309476930120302e-10,  1.221865357671760e-11, -1.478918692081112e-13, -8.957842167011669e-16, -5.471494141632493e-17,  6.488954212881404e-18, -1.140551070495201e-19,
 -4.125578664996466e-21,  1.468114281430669e-22,  6.096556631920212e-07, -6.946375990052683e-09,  3.142456319274360e-10, -1.516988554036133e-11,  4.773790446934871e-13,
 -8.379099806502245e-15,  9.427123946172458e-17, -5.258245785082623e-18,  2.905699643860791e-19, -5.158309986717850e-21, -1.046723342697940e-22,  3.548356654735054e-24,
  3.588754814251198e-09, -5.406410840889622e-11,  3.224375227778902e-12, -1.743469890036543e-13,  6.392664328689930e-15, -1.656397274477598e-16,  4.208045415684924e-18,
 -1.611012896021813e-19,  6.026127260908108e-21, -1.330150802303905e-22,  1.112418511847094e-24, -2.937647965516697e-26,  2.813647047693372e-12, -7.058050600880626e-14,
  5.822147886672382e-15, -3.799608295683369e-16,  1.849143131798928e-17, -7.663175748815784e-19,  3.150514155798710e-20, -1.318814537859080e-21,  5.071221540143015e-23,
 -1.686130955446755e-24,  5.171862740862776e-26, -1.669006585151424e-27,  1.548213881882611e-01, -9.841395904113331e-04,  8.671286866091322e-06, -5.092443955043556e-08,
 -6.100823100143714e-10,  1.288831894704882e-11,  6.371117215816611e-13, -2.844804312593998e-14, -2.976658098185004e-17,  2.941609525482631e-17, -5.757194067345809e-19,
 -1.809857063442272e-20,  9.122744707973075e-02, -5.859169744783095e-04,  5.728508023849607e-06, -6.601784585265328e-08,  8.675164835502934e-10, -1.000388818322814e-11,
  5.415712382120620e-16,  2.931036199887764e-15,  7.471402212357780e-18, -3.776534721816021e-18,  7.959689767755329e-20,  1.988950668258498e-21,  3.118763311535687e-02,
 -2.046584086790459e-04,  2.407393539328589e-06, -4.882512233955691e-08,  1.201303837858580e-09, -1.706260746030054e-11, -2.376144760330901e-13,  1.442277794673238e-14,
  3.164684223207795e-17, -1.646284809815436e-17,  3.209727760017425e-19,  9.991231549168344e-21,  5.981121478212505e-03, -4.063026663408046e-05,  6.049432765016375e-07,
 -1.781795390032998e-08,  5.275246428818557e-10, -8.135253798573463e-12, -1.013240597768633e-13,  6.522614255112767e-15,  2.282385848287397e-17, -7.953696851700802e-18,
  1.502850838752678e-19,  4.957089783274227e-21,  6.069981644063300e-04, -4.340173569426626e-06,  8.407406921424923e-08, -3.166159846073541e-09,  1.027239400575285e-10,
 -1.726166047083881e-12, -1.384527045831671e-14,  1.112641929164827e-15,  7.358065494388227e-18, -1.571877916566275e-18,  2.841588532703029e-20,  9.980608083952969e-22,
  2.958572499862965e-05, -2.279038507454181e-07,  5.832235746803359e-09, -2.604358461368277e-10,  9.023854167968142e-12, -1.689005644292836e-13, -2.845693527802550e-16,
  6.932720448695356e-17,  1.127505057140805e-18, -1.390730447561622e-19,  2.369935246046150e-21,  8.685039919348006e-23,  5.859124845719757e-07, -5.042835967960342e-09,
  1.728068840728953e-10, -8.783111903568948e-12,  3.251225592103872e-13, -7.023948931925717e-15,  4.571509847852999e-17,  6.423903759330243e-19,  7.724637120043131e-20,
 -5.355299605664130e-21,  8.731288714806144e-23,  2.822777780839242e-24,  3.412998152947742e-09, -3.512128954973674e-11,  1.650994876353135e-12, -9.427493055423423e-14,
  3.819304667913844e-15, -1.011244772932859e-16,  1.734421440525517e-18, -3.672480724848376e-20,  2.024306493128162e-21, -8.529543868538177e-23,  1.563491194305102e-24,
  1.431179174258108e-26,  2.601441046233847e-12, -3.816072963009307e-14,  2.637411074005009e-15, -1.754834776206861e-16,  8.487587120426496e-18, -3.145950395937885e-19,
  1.037307696358524e-20, -3.747825600732807e-22,  1.491855151405964e-23, -5.342568552634782e-25,  1.511213270381018e-26, -3.527173530556907e-28,  1.510194969107935e-01,
 -9.173559373855936e-04,  8.012102280091500e-06, -5.805483305709276e-08, -2.609947452812773e-10,  1.930801296691403e-11, -5.054247413419394e-14, -1.770966650056118e-14,
  5.342369849256972e-16,  2.234405301800593e-18, -5.567777857481870e-19,  1.245184961364690e-20,  8.897073120379627e-02, -5.430368680866102e-04,  5.013049556402031e-06,
 -5.371047971555948e-08,  6.739113928635787e-10, -9.080199854359248e-12,  7.043374967761523e-14,  1.688880407328264e-15, -6.366173985688789e-17, -2.692339444877286e-19,
  6.915105725472134e-20, -1.616950041767301e-21,  3.040423245545907e-02, -1.874433911585561e-04,  1.924919031227555e-06, -3.251079102752090e-08,  8.343709190831192e-10,
 -1.825044337421730e-11,  1.118835228222508e-13,  8.875955475626596e-15, -2.856459284932837e-16, -1.346616649461179e-18,  3.094893575929601e-19, -6.909760804487794e-21,
  5.827110895629054e-03, -3.651541555338128e-05,  4.361397159536969e-07, -1.075066932589364e-08,  3.547729362746371e-10, -8.509206467204508e-12,  5.823500329651495e-14,
  4.058420458802654e-15, -1.325245095096048e-16, -7.313584483474812e-19,  1.496308198598677e-19, -3.282754373245345e-21,  5.907779301136213e-04, -3.794304370937827e-06,
  5.477270875259338e-08, -1.806327250876357e-09,  6.735011949032513e-11, -1.701049324885115e-12,  1.396575105839854e-14,  7.090011747039277e-16, -2.399660084561737e-17,
 -1.729687639060102e-19,  2.941820023810359e-20, -6.293678497434600e-22,  2.875076002500748e-05, -1.915481453756598e-07,  3.462484816472562e-09, -1.427677701764392e-10,
  5.739018697924214e-12, -1.522076701314828e-13,  1.566521938952429e-15,  4.779826919066945e-17, -1.740984035275550e-18, -1.987528544424287e-20,  2.549404007255096e-21,
 -5.255746305600758e-23,  5.679498462760637e-07, -4.003782366942341e-09,  9.420297365434708e-11, -4.636239688474853e-12,  1.978611607894499e-13, -5.581622770000139e-15,
  7.501433853338657e-17,  8.408715141344131e-19, -3.860393436767437e-20, -1.073673121091713e-21,  9.199962971270994e-23, -1.810079500576234e-24,  3.293044875343076e-09,
 -2.554000528263381e-11,  8.262242669019398e-13, -4.733417018275964e-14,  2.157200953999008e-15, -6.690824541987338e-17,  1.240581955449831e-18, -8.590851764050091e-21,
  1.073797521757128e-22, -2.359504673716336e-23,  1.226973777663588e-24, -2.407436967156676e-26,  2.480381743711629e-12, -2.358077970241053e-14,  1.174764493625724e-15,
 -7.927998632263765e-17,  4.051717586304695e-18, -1.518579681401607e-19,  4.357570347640154e-21, -1.128426775649115e-22,  3.691176607057932e-24, -1.517265892998345e-25,
  5.470470744099882e-27, -1.396929213749831e-28,  1.474737917089136e-01, -8.560885183008039e-04,  7.302541036970035e-06, -5.934155111059711e-08,  8.269921109185519e-11,
  1.402492431802767e-11, -3.190902222677875e-13, -2.497816466191801e-15,  3.519545117435230e-16, -8.783975521910027e-18, -2.967446244780489e-20,  8.260978369501108e-21,
  8.687495194223781e-02, -5.053404128513947e-04,  4.427557909458067e-06, -4.427690276268172e-08,  5.118721967032300e-10, -7.045957969441899e-12,  9.071877556028295e-14,
 -1.127033668007834e-16, -4.104710625452860e-17,  1.080314252095750e-18,  3.372671304566964e-21, -1.006503162375739e-21,  2.968307221572397e-02, -1.734040565051827e-04,
  1.603502806337254e-06, -2.186897251933462e-08,  5.110777757289105e-10, -1.359067803279302e-11,  2.385610413886388e-13,  7.234369633817859e-16, -1.879235817408283e-16,
  4.791868513824989e-18,  1.716416333413010e-20, -4.581649510732749e-21,  5.687330412043776e-03, -3.345811554087085e-05,  3.359046353244424e-07, -6.329786850422820e-09,
  2.053164532587197e-10, -6.217575733007047e-12,  1.150439485525121e-13,  2.523147415875475e-16, -8.781843892875345e-17,  2.260190209037360e-18,  9.028255760198714e-21,
 -2.220799042361865e-21,  5.763624309458230e-04, -3.426947326485684e-06,  3.851335521689400e-08, -9.774985708169550e-10,  3.784104059198898e-11, -1.213481692422684e-12,
  2.341543880311588e-14,  1.071702734018295e-17, -1.615035515179137e-17,  4.227417613695078e-19,  2.034074238186357e-21, -4.369414245889361e-22,  2.803103452122042e-05,
 -1.693564025328502e-07,  2.207341643097918e-09, -7.291468288530808e-11,  3.146072040228880e-12, -1.049241355022154e-13,  2.129439580693346e-15, -4.562839012434571e-18,
 -1.221644171565913e-18,  3.287504356269350e-20,  2.193139663419068e-22, -3.766698877571905e-23,  5.531552390802151e-07, -3.426699764439136e-09,  5.421102845488168e-11,
 -2.260449226657241e-12,  1.053453838513130e-13, -3.652816446286968e-15,  7.954168836835148e-17, -4.714821646623965e-19, -3.180470590996785e-20,  9.003967318675092e-22,
  1.101662871989192e-23, -1.324423054903435e-24,  3.201214074391160e-09, -2.070708654366034e-11,  4.261636200433954e-13, -2.198850263658965e-14,  1.097029691805225e-15,
 -4.013197355108227e-17,  9.755291088466691e-19, -1.141853157251289e-20, -1.211678552729182e-22,  4.120385596147379e-24,  2.252773705407478e-25, -1.603654000521565e-26,
  2.400122058766536e-12, -1.708448593391690e-14,  5.280772442470983e-16, -3.395359356735432e-17,  1.856645104730781e-18, -7.564689837359818e-20,  2.270424633537248e-21,
 -5.019685935195911e-23,  9.441738608964380e-25, -2.801544204345329e-26,  1.342907144424014e-27, -5.358015373112048e-29,  1.441618247431405e-01, -8.004755137055034e-04,
  6.606272201414600e-06, -5.619505735847190e-08,  2.863054432163568e-10,  6.514013734442428e-12, -2.772996091121331e-13,  4.007196922880951e-15,  7.500014227994592e-17,
 -5.588925014050732e-18,  1.284377256340824e-19,  5.451857148158378e-24,  8.492124956220318e-02, -4.719159675423877e-04,  3.941099306714397e-06, -3.709929177383997e-08,
  3.918530299932803e-10, -5.019865744285281e-12,  7.481423503550827e-14, -8.424364227722339e-16, -7.090369130459784e-18,  6.834549474152013e-19, -1.579227293618127e-20,
 -6.093792070211196e-26,  2.901362154761493e-02, -1.615053767282710e-04,  1.382170249445178e-06, -1.555846847507053e-08,  2.953153634711922e-10, -8.145432080270646e-12,
  1.997161222001669e-13, -2.692166450375115e-15, -3.670224269204300e-17,  3.046437907266127e-18, -7.064538490596352e-20, -7.694252816824074e-24,  5.558458960315065e-03,
 -3.102734615998478e-05,  2.760348189206938e-07, -3.891873664968077e-09,  1.078220864212211e-10, -3.615451684318448e-12,  9.462656283337370e-14, -1.329351876076677e-15,
 -1.628853406170920e-17,  1.439683949717199e-18, -3.369843283926755e-20, -7.961261004219068e-24,  5.632089107344699e-04, -3.157116905089976e-06,  2.971226294664823e-08,
 -5.364345151727448e-10,  1.897283196796975e-11, -6.924416707757168e-13,  1.870874946743131e-14, -2.751024355472737e-16, -2.690878163533091e-18,  2.706950896894413e-19,
 -6.429281878090121e-21, -3.270457242061552e-24,  2.738440482076054e-05, -1.544837761004319e-07,  1.573853918620044e-09, -3.669745328156395e-11,  1.530122335744723e-12,
 -5.867937741641467e-14,  1.629562120793668e-15, -2.546806762059281e-17, -1.595626618151923e-19,  2.138275671445427e-20, -5.196076998527838e-22, -5.975703417872610e-25,
  5.401779680206282e-07, -3.077766875267503e-09,  3.510753593463209e-11, -1.061814460510063e-12,  4.984595341318601e-14, -1.986556113789916e-15,  5.704706783858734e-17,
 -9.720301593171313e-19, -1.371649749256541e-21,  6.188726584825662e-22, -1.563254644946110e-23, -4.647952925637772e-26,  3.123883778129391e-09, -1.810813392602850e-11,
  2.449385986350944e-13, -9.699505470404043e-15,  5.010711018805957e-16, -2.082298076125443e-17,  6.298196237312834e-19, -1.224343199995544e-20,  6.731993013648857e-23,
  4.160905405620570e-24, -1.145319427031031e-25, -1.315832346493685e-27,  2.338235829165785e-12, -1.408253675929833e-14,  2.573573427701242e-16, -1.381565850074395e-17,
  7.894930966461334e-19, -3.526429946825306e-20,  1.188710165042303e-21, -2.931975448993599e-23,  4.892463233757037e-25, -5.112556228871356e-27,  1.217547427526778e-28,
 -9.510957259133749e-30,  1.410614725012639e-01, -7.502370697627729e-04,  5.962656243915120e-06, -5.089253987034901e-08,  3.598604701842008e-10,  1.324814503104358e-12,
 -1.549787935718159e-13,  4.120202142667001e-15, -4.225436716475392e-17, -1.306900685533010e-18,  7.421491974653203e-20, -1.659268423779125e-21,  8.309396489519248e-02,
 -4.420683922466319e-04,  3.530506127192956e-06, -3.154349598143072e-08,  3.074490032061374e-10, -3.514503381358383e-12,  5.091610890897302e-14, -7.903438862145508e-16,
  7.182430117124717e-18,  1.559206988736734e-19, -9.190032799774037e-21,  2.025373030886026e-22,  2.838863136803320e-02, -1.511253175083015e-04,  1.219213195663648e-06,
 -1.190316839566352e-08,  1.739077633102388e-10, -4.307053399358765e-12,  1.206573203035404e-13, -2.624793707658210e-15,  2.678295421053132e-17,  6.907856595728277e-19,
 -4.078488685923985e-20,  9.158819820519895e-22,  5.438505438993456e-03, -2.898130902505283e-05,  2.376607875790862e-07, -2.634990581147120e-09,  5.507429054259083e-11,
 -1.811087073419795e-12,  5.612243397176613e-14, -1.266083566106335e-15,  1.350224583515246e-17,  3.161462983580098e-19, -1.939728012445474e-20,  4.400457863605473e-22,
  5.510211515801614e-04, -2.940914423922128e-06,  2.471109468601593e-08, -3.219594279721594e-10,  8.971789243682107e-12, -3.383110343712340e-13,  1.092603690360602e-14,
 -2.520412521825235e-16,  2.844870901900542e-18,  5.618856098220499e-20, -3.689200228454693e-21,  8.496351791419762e-23,  2.678934825102696e-05, -1.433148347147782e-07,
  1.247860726024767e-09, -1.972435609617920e-11,  6.893940235224865e-13, -2.813218656220763e-14,  9.331882288636555e-16, -2.204833250407075e-17,  2.688463747543982e-19,
  3.990421331541491e-21, -2.976209812475423e-22,  7.017424662117493e-24,  5.283636362635049e-07, -2.836897362134492e-09,  2.605580515473754e-11, -5.168599991606622e-13,
  2.164780663063702e-14, -9.326299809214782e-16,  3.172971904216399e-17, -7.746872760427142e-19,  1.051766598891976e-20,  8.897632985018706e-23, -9.018122513146811e-24,
  2.213013771151851e-25,  3.054789822740131e-09, -1.650478086028178e-11,  1.652598427806586e-13, -4.303483240379991e-15,  2.097276979242398e-16, -9.471539045498012e-18,
  3.332777883516298e-19, -8.580924192146626e-21,  1.364020064543426e-22,  3.918428269774132e-27, -7.109709993155164e-26,  1.899803990249321e-27,  2.285217047279274e-12,
 -1.251688188181067e-14,  1.484170884569292e-16, -5.525242594276042e-18,  3.114963668746205e-19, -1.496837224165480e-20,  5.627741763522131e-22, -1.618329723755713e-23,
  3.360954958886798e-25, -4.117190887448750e-27, -1.699370819118135e-30,  5.708408653539834e-31,  1.381521982990218e-01, -7.048798967596919e-04,  5.386811814878540e-06,
 -4.508880147106444e-08,  3.575960564073563e-10, -1.189427173765264e-12, -6.230937443523347e-14,  2.455822212747444e-15, -5.179291198791101e-17,  3.980816238371047e-19,
  1.725579211475306e-20, -8.441234209846457e-22,  8.137989363617962e-02, -4.152597508846510e-04,  3.179375444478176e-06, -2.712724987209977e-08,  2.477346295117101e-10,
 -2.529039938831081e-12,  3.243742598373318e-14, -5.254381122684977e-16,  8.129043661857303e-18, -5.674996905262305e-20, -2.188789404940053e-21,  1.049157715161512e-22,
  2.780279216324257e-02, -1.419013018833362e-04,  1.090673687118446e-06, -9.675482625993427e-09,  1.113344608082735e-10, -2.182786274255304e-12,  6.108512898348087e-14,
 -1.611616874560916e-15,  3.107678675893095e-17, -2.431014928227070e-19, -9.346757076354527e-21,  4.655873134980941e-22,  5.326200565924337e-03, -2.719385539431226e-05,
  2.103391587585963e-07, -1.981477679366715e-09,  2.973079945749287e-11, -8.346759746146822e-13,  2.757071463396514e-14, -7.665667589550040e-16,  1.513716957879921e-17,
 -1.250574649979511e-19, -4.325992116314834e-21,  2.222046749734370e-22,  5.396312727132408e-04, -2.756672164141064e-06,  2.152566372243251e-08, -2.204920550468182e-10,
  4.314132743259482e-12, -1.494623669498462e-13,  5.284222259049194e-15, -1.503511864509611e-16,  3.025320422249987e-18, -2.685851716522882e-20, -7.873293783136070e-22,
  4.251592655357216e-23,  2.623477276043488e-05, -1.341270250849465e-07,  1.062195703296154e-09, -1.216972713903052e-11,  3.060441423601760e-13, -1.210698584372880e-14,
  4.447787793521961e-16, -1.288559937144909e-17,  2.653685372365978e-19, -2.594333760684919e-21, -5.875795441570268e-23,  3.466844547029921e-24,  5.174003994659732e-07,
 -2.648554549919037e-09,  2.143170134220289e-11, -2.850140699776366e-13,  9.054848848810358e-15, -3.924615569232334e-16,  1.483925050274093e-17, -4.388607840340850e-19,
  9.345864891922616e-21, -1.040791538037121e-22, -1.507651885800654e-24,  1.074034167119876e-25,  2.991152451073516e-09, -1.534416661698175e-11,  1.287062808038133e-13,
 -2.101668711396821e-15,  8.331276645648836e-17, -3.878454462151628e-18,  1.511252760224735e-19, -4.610014857155352e-21,  1.037015830116857e-22, -1.387451452909176e-24,
 -6.178572742208320e-27,  9.052237173329743e-28,  2.237199064596181e-12, -1.152869606892508e-14,  1.041437224986373e-16, -2.336328886689955e-18,  1.161941571524470e-19,
 -5.819888111386910e-21,  2.382150741102263e-22, -7.746533328655626e-24,  1.949382683556103e-25, -3.496718869485082e-27,  3.088317558623792e-29,  4.498302216003901e-31,
  1.354155753464727e-01, -6.638546313131183e-04,  4.879083412354771e-06, -3.961861042858597e-08,  3.235237059765690e-10, -2.030499621980774e-12, -1.399392835291292e-14,
  1.102827430898427e-15, -3.182169857317386e-17,  5.763833140606902e-19, -3.545641381515347e-21, -1.866948604522753e-22,  7.976775334899779e-02, -3.910630636185986e-04,
  2.876086363372570e-06, -2.353034567277939e-08,  2.038894468123458e-10, -1.899995894220541e-12,  2.098287099069245e-14, -3.076328418357927e-16,  5.358516812687344e-18,
 -8.014427261198441e-20,  4.307360613942684e-22,  2.429017809104031e-23,  2.725194134446090e-02, -1.336129212797168e-04,  9.840360699139143e-07, -8.177164951963440e-09,
  7.922382454796210e-11, -1.155698274429310e-12,  2.824428722484629e-14, -7.972989088411583e-16,  1.933440056819220e-17, -3.349087167001763e-19,  2.105606289123299e-21,
  1.021552290383715e-22,  5.220649977090441e-03, -2.559923384718238e-05,  1.889634528759759e-07, -1.609755518054777e-09,  1.817787214010343e-11, -3.807625982426417e-13,
  1.206489720511891e-14, -3.723508247123692e-16,  9.299407847009098e-18, -1.640368593442154e-19,  1.102836698888601e-21,  4.748611378964649e-23,  5.289336430123277e-04,
 -2.594065795168005e-06,  1.921412596429229e-08, -1.697367643763944e-10,  2.304307167454701e-12, -6.325376205166352e-14,  2.258496688002370e-15, -7.218101616273791e-17,
  1.830396771925583e-18, -3.285888279665108e-20,  2.408986953939551e-22,  8.721638400794043e-24,  2.571443223328344e-05, -1.261455399032481e-07,  9.391310921063978e-10,
 -8.736767949335815e-12,  1.459810705033081e-13, -4.898592648337361e-15,  1.870091114801520e-16, -6.105948410434994e-18,  1.570978295448146e-19, -2.886596917374401e-21,
  2.370479978594352e-23,  6.629651979599000e-25,  5.071302538099858e-07, -2.488807954268074e-09,  1.867440031552557e-11, -1.871967697592440e-13,  3.930776052109945e-15,
 -1.536694951808070e-16,  6.135344737863397e-18, -2.041519043205791e-19,  5.352258764571683e-21, -1.017723074108757e-22,  9.701364290428684e-25,  1.782378863021587e-26,
  2.931700955283814e-09, -1.439754287022963e-11,  1.094578808820710e-13, -1.229885584458562e-15,  3.329934001213925e-17, -1.471704837867637e-18,  6.101358591619302e-20,
 -2.078956336441176e-21,  5.615929369302345e-23, -1.129259209267534e-24,  1.318624499143831e-26,  9.542714766056833e-29,  2.192608125752242e-12, -1.078323286571911e-14,
  8.425346420116688e-17, -1.160237373886170e-18,  4.258157938323712e-20, -2.107787578963506e-21,  9.156759121745455e-23, -3.260892638785222e-24,  9.376498724293616e-26,
 -2.109507737748172e-27,  3.356711439493444e-29, -2.179478475414009e-31,  1.328353312105686e-01, -6.266388192497226e-04,  4.433343337962940e-06, -3.477669689714191e-08,
  2.815385417201888e-10, -2.092963542988198e-12,  5.489396046275861e-15,  3.788667607415077e-16, -1.475713105260542e-17,  3.581725628118809e-19, -5.810590543781268e-21,
  3.134701937214349e-23,  7.824780486377413e-02, -3.691310948395501e-04,  2.612123002042913e-06, -2.054736492249789e-08,  1.703170924920522e-10, -1.482904420259434e-12,
  1.436819839267532e-14, -1.776312616943652e-16,  2.934781432951116e-18, -5.257831388795167e-20,  7.503879531323831e-22, -3.331857236677253e-24,  2.673264113885353e-02,
 -1.261131381831686e-04,  8.928541119014912e-07, -7.064133056535810e-09,  6.139689758966414e-11, -6.862176338607881e-13,  1.291993909167829e-14, -3.496495287550314e-16,
  9.408933885601094e-18, -2.093396778379641e-19,  3.314980756641268e-21, -1.819515389541473e-23,  5.121160442734184e-03, -2.416034202681327e-05,  1.711827466527853e-07,
 -1.367105039450767e-09,  1.276568445562224e-11, -1.877685498046560e-13,  4.994141556089267e-15, -1.581762570861240e-16,  4.468528224700874e-18, -1.012677990841310e-19,
  1.628672126705761e-21, -9.635556037925745e-24,  5.188526844107187e-04, -2.447953366594747e-06,  1.736467074767645e-08, -1.406246928280733e-10,  1.447418284095525e-12,
 -2.769750290929373e-14,  8.957528121220888e-16, -3.021574212407385e-17,  8.707610925348460e-19, -1.996490356912980e-20,  3.265966543376998e-22, -2.123957115807173e-24,
  2.522426010526955e-05, -1.190182618326959e-07,  8.457241512150771e-10, -6.990051605583906e-12,  8.159852495011610e-14, -1.982429181716214e-15,  7.231560053400168e-17,
 -2.525166319086272e-18,  7.380462456250103e-20, -1.714182423212641e-21,  2.870363128729101e-23, -2.108850132931705e-25,  4.974608421359575e-07, -2.347519001470045e-09,
  1.672532629885786e-11, -1.425268340573311e-13,  1.953565133108161e-15, -5.875633103169077e-17,  2.324676302414727e-18, -8.321282265616874e-20,  2.468432869948559e-21,
 -5.837146874165440e-23,  1.011780487440618e-24, -8.702405919918043e-27,  2.875779023405281e-09, -1.357366197615252e-11,  9.713612768053610e-14, -8.695899166851454e-16,
  1.469708451734459e-17, -5.366785099048530e-19,  2.259226429935506e-20, -8.285605771735908e-22,  2.510088953340992e-23, -6.112057492999980e-25,  1.120518102150548e-26,
 -1.189110001594044e-28,  2.150748014425567e-12, -1.015587463662658e-14,  7.334216546020681e-17, -7.225296113344131e-19,  1.649286779001573e-20, -7.282196330180504e-22,
  3.257141718633298e-23, -1.239012453548525e-24,  3.912744802363051e-26, -1.012596861221283e-27,  2.073494579148670e-29, -3.005035299059765e-31,  1.303971703908565e-01,
 -5.927678958207720e-04,  4.041700352937340e-06, -3.059701195001761e-08,  2.416252061970140e-10, -1.876883487908649e-12,  1.112581314162327e-14,  7.177529741202638e-17,
 -5.574049246396499e-18,  1.670583771156565e-19, -3.598746638564566e-21,  5.377192395938945e-23,  7.681157542667712e-02, -3.491761980696063e-04,  2.380982832352452e-06,
 -1.804234058325863e-08,  1.437526509200604e-10, -1.188691212936736e-12,  1.046370370149199e-14, -1.086309693118471e-16,  1.527863695521060e-18, -2.737617161344298e-20,
  4.877139007641782e-22, -6.639538593897314e-24,  2.624195969938608e-02, -1.192936316348034e-04,  8.135724887944055e-07, -6.177527050119219e-09,  5.012978461771975e-11,
 -4.656967970475218e-13,  6.382596135155909e-15, -1.456600948817805e-16,  3.989771442906980e-18, -1.002658522050778e-19,  2.059604647643396e-21, -3.034499174823328e-23,
  5.027158669751830e-03, -2.285327835942598e-05,  1.558966596117570e-07, -1.187638753074944e-09,  9.920933002777550e-12, -1.078427679125669e-13,  2.102596440360682e-15,
 -6.201879897407976e-17,  1.858172702795328e-18, -4.802729207138737e-20,  9.993014510259823e-22, -1.493078218193185e-23,  5.093285265628994e-04, -2.315428024483219e-06,
  1.580096343859266e-08, -1.209682069261728e-10,  1.053685210768200e-12, -1.378265693939836e-14,  3.484469296535962e-16, -1.155762757486853e-17,  3.583302165809349e-19,
 -9.381128160191657e-21,  1.971270321351780e-22, -2.994388779750431e-24,  2.476121540821452e-05, -1.125682990947763e-07,  7.686184776488162e-10, -5.927258974690909e-12,
  5.474310456710668e-14, -8.780481966778082e-16,  2.685572318146660e-17, -9.506581234079652e-19,  3.006282601715289e-20, -7.955644521942630e-22,  1.692034483315888e-23,
 -2.630165765679758e-25,  4.883281924306391e-07, -2.220099283565120e-09,  1.517175980643438e-11, -1.182933103353438e-13,  1.186476823544170e-15, -2.368043548185850e-17,
  8.355817486599951e-19, -3.086581226161801e-20,  9.919639017555145e-22, -2.659171811974851e-23,  5.755100315825821e-25, -9.256781156584690e-27,  2.822977233178181e-09,
 -1.283497335970550e-11,  8.783505832263257e-14, -6.973318189592661e-16,  7.899716682907245e-18, -1.995948484825639e-19,  7.885620609746084e-21, -3.014223488490811e-22,
  9.868782189872544e-24, -2.698031330961978e-25,  6.008892795480574e-27, -1.021202645536967e-28,  2.111248239118568e-12, -9.600213185716426e-15,  6.588514334551897e-17,
 -5.423157209557232e-19,  7.542680883894894e-21, -2.498992648499615e-22,  1.092758096936966e-23, -4.342896369954464e-25,  1.468052531906359e-26, -4.176083133172430e-28,
  9.866375782377194e-30, -1.866117037417069e-31,  1.280885297844926e-01, -5.618399839803643e-04,  3.696541613031617e-06, -2.701641898592403e-08,  2.068366672631178e-10,
 -1.601230417433470e-12,  1.136970278553144e-14, -3.383369607806474e-17, -1.629437215984970e-18,  6.489185227063564e-20, -1.666996808546865e-21,  3.277607956205616e-23,
  7.545164806655855e-02, -3.309569899672934e-04,  2.177532052902507e-06, -1.591978931209580e-08,  1.222688752609108e-10, -9.693271661666847e-13,  7.982053084017183e-15,
 -7.228092490959898e-17,  8.283364357869511e-19, -1.310306771554602e-20,  2.440147223123709e-22, -4.237542519928487e-24,  2.577735121801275e-02, -1.130685974701959e-04,
  7.439709767485102e-07, -5.442803828200197e-09,  4.207959334857811e-11, -3.498575852658453e-13,  3.647971890661502e-15, -6.227637374281545e-17,  1.568795430744673e-18,
 -4.146024030706817e-20,  9.691867046320509e-22, -1.853406510975162e-23,  4.938153255218871e-03, -2.166056186046727e-05,  1.425337474107824e-07, -1.043904409174261e-09,
  8.156894980781174e-12, -7.285158786511427e-14,  9.866018326552983e-16, -2.370118723140032e-17,  7.044164723923355e-19, -1.960176030464844e-20,  4.663079612937607e-22,
 -9.005586821551265e-24,  5.003108164416827e-04, -2.194558650090958e-06,  1.444262176702275e-08, -1.059503214600105e-10,  8.409974935514255e-13, -8.271254426436962e-15,
  1.440443401146536e-16, -4.211372204071985e-18,  1.337534742998939e-19, -3.797043268381115e-21,  9.117122692785981e-23, -1.776382372795885e-24,  2.432280913758325e-05,
 -1.066901147290619e-07,  7.022599591880085e-10, -5.164228935145381e-12,  4.193623406323785e-14, -4.665461273742664e-16,  1.020880676937678e-17, -3.370987306749995e-19,
  1.109479381751124e-20, -3.190320899904588e-22,  7.730125887560358e-24, -1.523559121470783e-25,  4.796819687227145e-07, -2.104110709265951e-09,  1.385337287952251e-11,
 -1.022481780041067e-13,  8.587069744336226e-16, -1.115459343290327e-17,  2.992285848676662e-19, -1.072342163092084e-20,  3.616218997014724e-22, -1.052555075137841e-23,
  2.580785244462154e-25, -5.173326438066516e-27,  2.772992406430845e-09, -1.216386466755098e-11,  8.012050944571301e-14, -5.949164649019264e-16,  5.268472960015903e-18,
 -8.344981510560664e-20,  2.691022698161513e-21, -1.025400657098574e-22,  3.534429257916200e-24, -1.045218704541998e-25,  2.611275267783819e-27, -5.382097167931749e-29,
  2.073862823836139e-12, -9.097416044448300e-15,  5.997333918553327e-17, -4.507005892556167e-19,  4.406494621158787e-21, -9.200194872947565e-23,  3.544256980436502e-24,
 -1.429322050675433e-25,  5.074485220969190e-27, -1.545424339153908e-28,  4.010810933380696e-30, -8.749073141948155e-32,  1.258983376019245e-01, -5.335105191060712e-04,
  3.391191035720832e-06, -2.394880755113820e-08,  1.774412910335904e-10, -1.343856263103018e-12,  9.966340078475913e-15, -5.901200834369001e-17, -2.009196262827706e-19,
  2.114863743852547e-20, -6.501611528656573e-22,  1.496451121946405e-23,  7.416149580552350e-02, -3.142690352652965e-04,  1.997624592024686e-06, -1.410881027013039e-08,
  1.046479405303450e-10, -7.994257296787982e-13,  6.269905979062109e-15, -5.175808876132655e-17,  4.940495261098196e-19, -6.352846912971200e-21,  1.094854499001410e-22,
 -2.048820626661612e-24,  2.533658220389041e-02, -1.073671420515279e-04,  6.824800667597688e-07, -4.821256727512751e-09,  3.584103558127949e-11, -2.787056439407565e-13,
  2.427792266426203e-15, -2.986404734052230e-17,  6.082853279072461e-19, -1.569186727945595e-20,  3.921213554323432e-22, -8.546569225209689e-24,  4.853715206608314e-03,
 -2.056828395293257e-05,  1.307455196401252e-07, -9.239508497480589e-10,  6.893703021486051e-12, -5.513020631278656e-14,  5.541378651712939e-16, -9.525021163009574e-18,
  2.541022403884865e-19, -7.250763757930428e-21,  1.868735530989944e-22, -4.121467202723220e-24,  4.917559192634220e-04, -2.083886060675557e-06,  1.324701140113337e-08,
 -9.366271721057751e-11,  7.026358161426137e-13, -5.850108307948946e-15,  6.973011783039637e-17, -1.547308003411214e-18,  4.688056702065731e-20, -1.389637862557526e-21,
  3.627505115522273e-23, -8.059720558457148e-25,  2.390690761769534e-05, -1.013091474656513e-07,  6.440430021090609e-10, -4.557188996618525e-12,  3.446001207718876e-14,
 -3.034516353759211e-16,  4.372128911532338e-18, -1.175106688713222e-19,  3.822530047020608e-21, -1.157045508684226e-22,  3.048789533153438e-24, -6.829055092940676e-26,
  4.714797190529713e-07, -1.997972915337487e-09,  1.270250169234882e-11, -8.998583280396467e-14,  6.886087553089229e-16, -6.557319121967456e-18,  1.159442425908587e-19,
 -3.606055779473259e-21,  1.228027304117593e-22, -3.775675089244952e-24,  1.004999306848447e-25, -2.276435924779753e-27,  2.725575541882854e-09, -1.155013165094840e-11,
  7.344137705701377e-14, -5.212482955034490e-16,  4.066350637092030e-18, -4.339654559483824e-20,  9.578398297233234e-22, -3.345427417546136e-23,  1.179937786973578e-24,
 -3.686857112411793e-26,  9.955929629924538e-28, -2.296016539272123e-29,  2.038400018512255e-12, -8.638179822653986e-15,  5.493915773153460e-17, -3.913821609133737e-19,
  3.169420077463294e-21, -4.081377035652310e-23,  1.162086670460222e-24, -4.496765870563664e-26,  1.644335072148716e-27, -5.267902701967185e-29,  1.462427322729239e-30,
 -3.497747514478168e-32,  1.238168000199936e-01, -5.074842305939764e-04,  3.119993311785024e-06, -2.131233518042887e-08,  1.528209164477964e-10, -1.124666609377378e-12,
  8.309101811074483e-15, -5.719584136228999e-17,  2.205339373736630e-19,  5.076694956297781e-21, -2.197475452216124e-22,  5.795911590116418e-24,  7.293534803518918e-02,
 -2.989379615150443e-04,  1.837862659848943e-06, -1.255463841805146e-08,  9.005524950717027e-11, -6.647371993678692e-13,  5.012765971137125e-15, -3.891294507651102e-17,
  3.263102376299264e-19, -3.365965407555618e-21,  4.835862466052004e-23, -8.745921248324958e-25,  2.491768013002856e-02, -1.021293774141208e-04,  6.278913404625358e-07,
 -4.289477705097214e-09,  3.079135569596030e-11, -2.287031707497734e-13,  1.797082098208723e-15, -1.703080802674256e-17,  2.521966825832435e-19, -5.710180043577669e-21,
  1.442841624070096e-22, -3.386702531121094e-24,  4.773466320981062e-03, -1.956487384504211e-05,  1.202856458669628e-07, -8.218266308870540e-10,  5.906377061769954e-12,
 -4.430980714118547e-14,  3.705435729152764e-16, -4.426396635747539e-18,  9.223030864794418e-20, -2.520492792357335e-21,  6.772226347661742e-23, -1.620971536061600e-24,
  4.836254675928018e-04, -1.982223026896652e-06,  1.218691127797666e-08, -8.327781981539572e-11,  5.995710734983334e-13, -4.564682849673011e-15,  4.153693314690218e-17,
 -6.258911498890872e-19,  1.606066870869137e-20, -4.743312105400407e-22,  1.304032430498778e-23, -3.149236322129013e-25,  2.351164203494533e-05, -9.636660429600996e-08,
  5.924805341886864e-10, -4.049591893952365e-12,  2.923152722735590e-14, -2.273168846661659e-16,  2.306583878864113e-18, -4.323667438071913e-20,  1.267895975945464e-21,
 -3.902604780425615e-23,  1.087434877410048e-24, -2.645946953484993e-26,  4.636844808427788e-07, -1.900494047877186e-09,  1.168486246212263e-11, -7.989378357860250e-14,
  5.789595950821016e-16, -4.644342056315750e-18,  5.411152135601511e-20, -1.239489230442130e-21,  3.981591565371926e-23, -1.259053869249887e-24,  3.548089519476466e-26,
 -8.710934914481900e-28,  2.680511945563278e-09, -1.098657366992449e-11,  6.755145645181687e-14, -4.621361862246890e-16,  3.370134809287222e-18, -2.837669852310599e-20,
  3.951847805890556e-22, -1.089577084214832e-23,  3.745771087332940e-25, -1.211116339854198e-26,  3.458427490750747e-28, -8.605583970032048e-30,  2.004697726216216e-12,
 -8.216644772177496e-15,  5.052385353484100e-17, -3.460264025690764e-19,  2.554611140479311e-21, -2.350023352490006e-23,  4.202109679239663e-25, -1.389282367095743e-26,
  5.069788453061906e-28, -1.682954267314333e-29,  4.914695918600792e-31, -1.255394825625273e-32,  1.218352197679875e-01, -4.835073506367215e-04,  2.878207465724614e-06,
 -1.903684060971704e-08,  1.321967003874891e-10, -9.435496434679049e-13,  6.824241038143069e-15, -4.850127966551409e-17,  2.933384445066061e-19, -4.634884609210991e-24,
 -6.178383660214763e-23,  1.978067705575465e-24,  7.176808113960023e-02, -2.848141575424241e-04,  1.695433786166051e-06, -1.121392626992265e-08,  7.788098101840718e-11,
 -5.564258850597871e-13,  4.053458661340865e-15, -3.009993786920470e-17,  2.324334433517831e-19, -2.015845619838169e-21,  2.286140678950332e-23, -3.590144073717721e-25,
  2.451889426534096e-02, -9.730409952116022e-05,  5.792298168046036e-07, -3.831212944886947e-09,  2.661399774115934e-11, -1.905399859432860e-13,  1.408805572834743e-15,
 -1.137675408699624e-17,  1.220761978805526e-19, -2.130541057433814e-21,  5.030659176976273e-23, -1.217484852530573e-24,  4.697071120087320e-03, -1.864049422156619e-05,
  1.109629564830225e-07, -7.339680318510721e-10,  5.100498432644314e-12, -3.663866700866571e-14,  2.773238408165075e-16, -2.519202587829783e-18,  3.666800321182298e-20,
 -8.578754562117789e-22,  2.292309311216917e-23, -5.764701570548511e-25,  4.758854584505768e-04, -1.888568601054556e-06,  1.124228488048139e-08, -7.436595281211095e-11,
  5.170711582777161e-13, -3.732780093452914e-15,  2.922460593990684e-17, -3.068470892745414e-19,  5.738132507605161e-21, -1.556295778334080e-22,  4.359675318542696e-24,
 -1.112620588851768e-25,  2.313535832915228e-05, -9.181351719666539e-08,  5.465504147432753e-10, -3.615593576996050e-12,  2.515982847824573e-14, -1.829484428949231e-16,
  1.501437910818788e-18, -1.862371619953020e-20,  4.248156099901513e-22, -1.254240512413860e-23,  3.602698794193362e-25, -9.281819559372708e-27,  4.562636040530226e-07,
 -1.810699223417614e-09,  1.077885347424843e-11, -7.131262624321095e-14,  4.968451460364825e-16, -3.651850041265030e-18,  3.201474169810845e-20, -4.783206904349925e-22,
  1.277349829730141e-23, -3.983423807585112e-25,  1.164086212565291e-26, -3.026067000536794e-28,  2.637612592790752e-09, -1.046746809457693e-11,  6.231206142672287e-14,
 -4.123226896704086e-16,  2.878320157212910e-18, -2.152197526457123e-20,  2.077823275288506e-22, -3.822533467367620e-24,  1.160921023581768e-25, -3.769576724618675e-27,
  1.119092522441704e-28, -2.942936861711328e-30,  1.972614168471952e-12, -7.828401061346204e-15,  4.660274889382726e-17, -3.084700080348376e-19,  2.161466089584402e-21,
 -1.669702204878422e-23,  1.890530972894632e-25, -4.449392603530442e-27,  1.514538179396682e-28, -5.106864930737205e-30,  1.548763004356605e-31, -4.157996633926768e-33,
  };
  int offset = -9;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 9;
    if (std::isnan(t)) {
      fill_n(rr+offset, 9, 0.5);
      fill_n(ww+offset, 9, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 9; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=9; ++j) {
        const int boxof = it*108+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
