#line 2 "beancount/parser/lexer.c"

#define PY_SSIZE_T_CLEAN
#include <Python.h>

#ifdef PYPY_VERSION_NUM
/* PyPy does not export this function. */
#define PyExceptionClass_Name(x) (((PyTypeObject*)(x))->tp_name)
#endif

typedef struct _yyextra_t yyextra_t;

struct _yyextra_t {
  /* The filename being tokenized. */
  PyObject* filename;

  /* The encoding to use for converting strings. */
  const char* encoding;

  /* A reference to the beancount.core.number.MISSING object */
  PyObject* missing_obj;
};

#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* Lexer interface required by Bison. */
#define YY_DECL int yylex(YYSTYPE* yylval_param, YYLTYPE* yylloc_param, \
                          yyscan_t yyscanner, PyObject* builder)

/**
 * Allocate a new scanner object including private data.
 *
 * This encapsulates the native yylex_init_extra() API.
 */
yyscan_t yylex_new(void);

/**
 * Free scanner object including private data.
 *
 * This encapsulated the native yylex_destroy() API. Python objects
 * references stored in the @scanner are decremented.
 */
yyscan_t yylex_free(yyscan_t scanner);

/**
 * Initialize scanner private data.
 *
 * Setup @scanner to read from the Python file-like object @file. Set
 * the reported file name to @filename, if not NULL and not None.
 * Otherwise try to obtain the file name from the @name attribute of
 * the @file object. If this fails, use the empty string. @encoding is
 * used to decode strings read from the input file, if not NULL,
 * otherwise the default UTF-8 encoding is used. Python objects
 * references are incremented. It is safe to call this multiple times.
 */
void yylex_initialize(PyObject* file, PyObject* filename, int lineno,
                      const char* encoding, PyObject* missing_obj, yyscan_t scanner);

#line 63 "beancount/parser/lexer.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

#ifdef yyget_lval
#define yyget_lval_ALREADY_DEFINED
#else
#define yyget_lval yyget_lval
#endif

#ifdef yyset_lval
#define yyset_lval_ALREADY_DEFINED
#else
#define yyset_lval yyset_lval
#endif

#ifdef yyget_lloc
#define yyget_lloc_ALREADY_DEFINED
#else
#define yyget_lloc yyget_lloc
#endif

#ifdef yyset_lloc
#define yyset_lloc_ALREADY_DEFINED
#else
#define yyset_lloc yyset_lloc
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin , yyscanner )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    /* Note: We specifically omit the test for yy_rule_can_match_eol because it requires
     *       access to the local variable yy_act. Since yyless() is a macro, it would break
     *       existing scanners that call yyless() from OUTSIDE yylex.
     *       One obvious solution it to make yy_act a global. I tried that, and saw
     *       a 5% performance hit in a non-yylineno scanner, because yy_act is
     *       normally declared as a register variable-- so it is not worth it.
     */
    #define  YY_LESS_LINENO(n) \
            do { \
                int yyl;\
                for ( yyl = n; yyl < yyleng; ++yyl )\
                    if ( yytext[yyl] == '\n' )\
                        --yylineno;\
            }while(0)
    #define YY_LINENO_REWIND_TO(dst) \
            do {\
                const char *p;\
                for ( p = yy_cp-1; p >= (dst); --p)\
                    if ( *p == '\n' )\
                        --yylineno;\
            }while(0)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = yyg->yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, yyg->yytext_ptr , yyscanner )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( yyg->yy_buffer_stack \
                          ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

void yyrestart ( FILE *input_file , yyscan_t yyscanner );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size , yyscan_t yyscanner );
void yy_delete_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yy_flush_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
void yypop_buffer_state ( yyscan_t yyscanner );

static void yyensure_buffer_stack ( yyscan_t yyscanner );
static void yy_load_buffer_state ( yyscan_t yyscanner );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file , yyscan_t yyscanner );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER , yyscanner)

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len , yyscan_t yyscanner );

void *yyalloc ( yy_size_t , yyscan_t yyscanner );
void *yyrealloc ( void *, yy_size_t , yyscan_t yyscanner );
void yyfree ( void * , yyscan_t yyscanner );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define yywrap(yyscanner) (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

typedef int yy_state_type;

#define yytext_ptr yytext_r

static yy_state_type yy_get_previous_state ( yyscan_t yyscanner );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  , yyscan_t yyscanner);
static int yy_get_next_buffer ( yyscan_t yyscanner );
static void yynoreturn yy_fatal_error ( const char* msg , yyscan_t yyscanner );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yyg->yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yyg->yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yyg->yy_c_buf_p = yy_cp;
#define YY_NUM_RULES 58
#define YY_END_OF_BUFFER 59
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const flex_int16_t yy_accept[369] =
    {   0,
        0,    0,    0,    0,   57,   57,   59,   55,    3,    1,
       22,   55,   19,   17,   18,   20,   14,   12,   15,   16,
       49,   21,    4,    7,   55,   22,   55,   55,   22,   55,
       55,   55,   55,   55,   55,   55,   55,   55,   55,   55,
       55,   10,    5,   11,   13,   55,   55,   55,   55,   55,
       55,   55,   55,    3,   22,   19,   20,   21,   22,   22,
       56,   58,   57,    3,    0,   48,    0,   50,    0,   49,
       49,    4,    6,    0,    0,   47,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,   47,   47,   47,   51,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    8,    9,    0,
        0,    0,    0,    0,    0,    0,    0,    2,    3,   54,
       53,   50,   53,   54,   54,   47,   54,   54,   54,   54,
       54,   54,   54,   54,   54,   54,   47,   56,   57,   49,
       49,   49,    0,   47,    0,   47,   46,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   47,   47,   47,   52,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,   28,    0,    0,    0,
        0,    0,   23,    0,    0,    0,   49,    0,   47,    0,
       47,   46,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
       47,   44,   42,    0,    0,    0,    0,    0,    0,    0,
       33,   25,    0,    0,    0,    0,    0,    0,    0,    0,
        0,   49,    0,   47,    0,   47,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   43,    0,   26,
        0,    0,    0,   29,    0,    0,    0,    0,    0,   32,
        0,    0,   30,    0,    0,   47,    0,   47,    0,    0,
        0,   46,    0,    0,   31,    0,    0,   39,   40,    0,
       36,    0,    0,    0,    0,   47,    0,   47,   46,   24,
        0,    0,   41,   38,    0,   35,   45,    0,   47,    0,

       47,    0,   34,   37,    0,   47,    0,   47,   27,    0,
       47,    0,   47,    0,   47,    0,   47,    0,   47,    0,
       47,    0,   47,    0,   47,    0,   47,    0,   47,    0,
       47,    0,   47,    0,   47,    0,   47,    0,   47,    0,
       47,    0,   47,    0,   47,    0,   47,    0,   47,    0,
       47,    0,   47,    0,   47,    0,   47,    0,   47,    0,
       47,    0,   47,    0,   47,   47,   47,    0
    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    5,    6,    7,    1,    5,    5,    8,    9,
       10,   11,   12,   13,   14,   15,   16,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   18,   19,    1,
        1,    1,    5,   20,   21,   22,   23,   22,   24,   25,
       22,   22,   22,   22,   22,   26,   23,   27,   22,   23,
       22,   28,   29,   30,   31,   22,   22,   22,   22,   22,
        1,   32,    1,   33,   34,    1,   35,   36,   37,   38,

       39,   40,   41,   42,   43,   40,   40,   44,   45,   46,
       47,   48,   49,   50,   51,   52,   53,   54,   40,   55,
       56,   40,   57,   58,   59,   60,    1,   61,   61,   61,
       61,   61,   61,   61,   61,   61,   61,   61,   61,   61,
       61,   61,   61,   62,   62,   62,   62,   62,   62,   62,
       62,   62,   62,   62,   62,   62,   62,   62,   62,   63,
       63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
       63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
       63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
       63,    1,    1,   64,   64,   64,   64,   64,   64,   64,

       64,   64,   64,   64,   64,   64,   64,   64,   64,   64,
       64,   64,   64,   64,   64,   64,   64,   64,   64,   64,
       64,   64,   64,   65,   66,   66,   66,   66,   66,   66,
       66,   66,   66,   66,   66,   66,   67,   68,   68,   69,
       70,   70,   70,   71,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static const YY_CHAR yy_meta[72] =
    {   0,
        1,    2,    3,    2,    1,    1,    1,    4,    1,    1,
        1,    1,    1,    5,    6,    7,    8,    9,    1,    1,
        8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    1,    1,   10,   11,   11,   11,   11,   11,   11,
       11,   11,   11,   11,   11,   11,   11,   11,   11,   11,
       11,   11,   11,   11,   11,   11,    1,    1,    1,    1,
        1,    1,    1,   12,   12,   12,   12,   12,   12,   12,
       12
    } ;

static const flex_int16_t yy_base[405] =
    {   0,
        0,   70,   76,   80,  985,  979,  977, 1737,   72, 1737,
     1737,   79,    0, 1737, 1737, 1737, 1737, 1737, 1737, 1737,
       74, 1737,    0,  956,  104,    0,  954,  943,  945,    0,
        0,  935,   50,  922,  914,  921,  919,  910,   60,  903,
      885,  882, 1737,  879, 1737,   53,  873,  100,   44,  103,
       46,  115,  870,   88,    0,  178,    0,    0,  249,  902,
        0, 1737,    0,  319,  316, 1737,  926,    0,  107,  908,
      311,    0, 1737,  317,  344,    0,  269,  371,  280,  861,
      283,   75,  292,  267,  301,  861,  895,  883,  874,    0,
      884,  332,   55,   78,  309,  366,  338,  369,  329,  365,

      371,  362,  364,  373,  339,  389,  390, 1737, 1737,    0,
      357,  360,  363,  368,  371,  376,  379, 1737,  409, 1737,
     1737,    0, 1737,  435,    0,    0,  387,    0,  383,  837,
      398,  386,  401,  403,  409,  838,  867,    0,    0,  460,
      864,  461,  471,  473,  500,    0,  471,  421,  815,  429,
      406,  432,  434,  437,  812,  440,  448,  457,  482,  485,
      488,  491,  843,  845,  842, 1737,  392,  462,  488,  514,
      537,  538,  539,  396,  540,  542,  847,  541,  543,  544,
      545,  546,  846,  506,  509,  512,  563,  583,  585,  612,
        0,  583,  541,  796,  544,  547,  549,  551,  560,  797,

      569,  594,  597,  600,  603,  606,  609,  612,  615,  618,
      829,    0,    0,  598,  576,  571,  664,  547,  665,  666,
      833,  828,  667,  669,  606,  668,  670,  671,  672,    0,
      828,  678,  690,  692,  721,    0,  659,  669,  678,  695,
      698,  701,  704,  707,  710,  713,    0,    0,  678,  826,
      695,  692,  679,  791,  716,  681,  707,  759,  760,  781,
      761,  762,  780,  767,  774,  778,  805,    0,  733,  741,
      744,    0,  798,  767,  690,  769,  799,  684,  683,  805,
      610,  772,  773,  608,  833,  835,  862,    0,    0,  498,
      800,  803,  494,  486,  807,  331,  235,  846,  848,  889,

        0,  839,  163,  149,  860,  893,  920,    0,   99,  918,
      945,  972,    0,  947,  949,  999,    0,  957,  970, 1026,
        0,  997, 1024, 1053,    0, 1051, 1078, 1105,    0, 1080,
     1082, 1132,    0, 1090, 1103, 1159,    0, 1130, 1157, 1186,
        0, 1184, 1211, 1238,    0, 1213, 1215, 1265,    0, 1223,
     1236, 1292,    0, 1263, 1290, 1319,    0, 1317, 1344, 1371,
        0,    0,    0, 1398,    0, 1737, 1416, 1737, 1447, 1459,
     1471, 1479, 1490, 1498, 1505, 1516, 1528, 1540, 1552, 1564,
     1573, 1576, 1585, 1591, 1600, 1607, 1614, 1621, 1628, 1635,
     1642, 1649, 1656, 1663, 1670, 1677, 1684, 1691, 1698, 1705,

     1712, 1719, 1726,   78
    } ;

static const flex_int16_t yy_def[405] =
    {   0,
      368,    1,  369,  369,  370,  370,  368,  368,  368,  368,
      368,  371,  372,  368,  368,  368,  368,  368,  368,  368,
      368,  368,  373,  368,  368,   25,   25,   25,   25,  374,
      375,  375,  375,  375,  375,  375,  375,  375,  375,  375,
      375,  368,  368,  368,  368,  368,  368,  368,  368,  368,
      368,  368,  368,  376,  377,  368,  378,  378,  368,   59,
      379,  368,  380,  368,  371,  368,  371,  372,  368,  368,
      368,  373,  368,  381,   25,   75,  382,   75,  368,  368,
      368,  368,  368,  368,  368,  368,   75,   75,   75,  374,
      375,  375,  375,  375,  375,  375,  375,  375,  375,  375,

      375,  375,  375,  375,  375,  375,  375,  368,  368,   78,
      368,  368,  368,  368,  368,  368,  368,  368,  376,  368,
      368,  372,  368,  381,   75,   75,  382,   78,  368,  368,
      368,  368,  368,  368,  368,  368,   75,  379,  380,  368,
      368,  368,  383,  383,   75,  145,  384,  368,  368,  368,
      368,  368,  368,  368,  368,  368,  368,  368,  368,  368,
      368,  368,  145,  145,  145,  368,  375,  375,  375,  375,
      375,  375,  375,  375,  375,  375,  375,  375,  375,  375,
      375,  375,  375,  368,  368,  368,  368,  385,  385,  145,
      190,  384,  368,  368,  368,  368,  368,  368,  368,  368,

      368,  368,  368,  368,  368,  368,  368,  368,  368,  368,
      190,  190,  190,  375,  375,  375,  375,  375,  375,  375,
      375,  375,  375,  375,  375,  375,  375,  375,  375,   78,
      368,  368,  386,  386,   78,  235,  368,  368,  368,  368,
      368,  368,  368,  368,  368,  368,   78,  235,  375,  375,
      375,  375,  375,  375,  375,  375,  375,  375,  375,  375,
      375,  375,  375,  368,  387,  387,  235,  267,  368,  368,
      368,  192,  375,  375,  375,  375,  375,  375,  375,  375,
      375,  375,  375,  368,  388,  388,  267,  287,  192,  375,
      375,  375,  375,  375,  375,  375,  368,  389,  389,  287,

      300,  375,  375,  375,  390,  390,  300,  307,  375,  391,
      391,  307,  312,  392,  392,  312,  316,  393,  393,  316,
      320,  394,  394,  320,  324,  395,  395,  324,  328,  396,
      396,  328,  332,  397,  397,  332,  336,  398,  398,  336,
      340,  399,  399,  340,  344,  400,  400,  344,  348,  401,
      401,  348,  352,  402,  402,  352,  356,  403,  403,  356,
      360,  404,  404,  360,  364,  368,  364,    0,  368,  368,
      368,  368,  368,  368,  368,  368,  368,  368,  368,  368,
      368,  368,  368,  368,  368,  368,  368,  368,  368,  368,
      368,  368,  368,  368,  368,  368,  368,  368,  368,  368,

      368,  368,  368,  368
    } ;

static const flex_int16_t yy_nxt[1809] =
    {   0,
        8,    9,   10,    9,   11,   12,   13,    8,   14,   15,
       16,   17,   18,   19,    8,   20,   21,   22,   23,   24,
       25,   25,   26,   25,   27,   25,   28,   26,   26,   29,
       26,    8,   30,    8,   31,   32,   33,   34,   35,   31,
       31,   31,   36,   31,   31,   37,   38,   39,   40,   31,
       31,   41,   31,   31,   31,   31,   42,   43,   44,   45,
        8,    8,    8,   46,   47,   48,   49,   50,   51,   52,
       53,   54,  166,   64,   55,   64,   56,   62,   62,   62,
       57,   62,   62,   62,   66,  366,   69,   58,   70,  119,
       71,   64,   59,   93,  101,  166,   94,   59,   59,   60,

       59,  168,   95,  102,  113,  113,  103,  115,  115,  104,
       67,   74,  105,  110,  110,  110,  166,   75,   74,   69,
       76,   77,  169,  140,   76,   76,   76,   76,   76,   76,
       76,   76,   76,   76,   76,  158,  158,   74,   78,   78,
       78,   78,   78,   78,   78,   78,   78,   78,   78,   78,
       78,   78,   78,   78,   78,   78,   78,   78,   78,   78,
      112,  112,  112,  114,  114,  114,  166,   79,   80,   81,
       82,   83,   84,   85,   86,  116,  116,  116,  121,  121,
      166,  121,  121,  121,  121,  121,  121,  121,  121,  121,
      121,  122,  122,  122,  122,  121,  121,  121,  122,  122,

      122,  122,  122,  122,  122,  122,  122,  122,  122,  121,
      121,  122,  122,  122,  122,  122,  122,  122,  122,  122,
      122,  122,  122,  122,  122,  122,  122,  122,  122,  122,
      122,  122,  122,  122,  121,  121,  121,  121,  121,  121,
      121,  121,  121,  121,  121,  121,  121,  121,  121,  120,
      120,  297,  120,  120,  120,  120,  124,  120,  120,  120,
      120,  120,  125,  124,  120,  126,  127,  120,  120,  126,
      126,  126,  126,  126,  126,  126,  126,  126,  126,  126,
      120,  120,  124,  128,  128,  128,  128,  128,  128,  128,
      128,  128,  128,  128,  128,  128,  128,  128,  128,  128,

      128,  128,  128,  128,  128,  120,  120,  120,  120,  120,
      120,  120,  129,  130,  131,  132,  133,  134,  135,  136,
       64,   66,   64,   69,  143,   70,  166,  142,  160,  160,
      143,  143,  148,  149,  150,  151,  152,  153,  154,  155,
       78,   78,   78,  157,  157,  157,  166,   67,  166,  166,
      143,  143,  159,  159,  159,  166,  166,  145,  143,  170,
      146,  161,  161,  161,  146,  146,  146,  146,  146,  146,
      146,  146,  146,  146,  146,  167,  172,  143,  368,  166,
      174,  166,  166,  166,   78,  368,  166,   78,  166,  181,
      166,   78,   78,   78,   78,   78,   78,   78,   78,   78,

       78,   78,  171,  175,  368,  173,  166,  166,  177,  166,
      119,  179,   64,  166,  178,  180,  176,  110,  110,  110,
      110,  110,  110,  110,  110,  110,  214,  182,  110,  110,
      110,  184,  184,  184,  221,  183,  185,  185,  185,  186,
      186,  186,  143,   78,   78,   78,  158,  158,  143,  143,
      148,  149,  150,  151,  152,  153,  154,  155,  157,  157,
      157,  159,  159,  159,  160,  160,  203,  203,  143,  161,
      161,  161,   69,   69,   70,   70,  140,  187,  188,  166,
      188,  147,  147,  147,  188,  188,  188,  188,   77,  202,
      202,  202,  204,  204,  204,  205,  205,  206,  206,  206,

       78,   78,   78,  166,  188,  166,  188,  188,   78,   78,
       78,  166,  215,  190,  188,  166,  191,   78,   78,   78,
      191,  191,  191,  191,  191,  191,  191,  191,  191,  191,
      191,  166,  216,  188,  193,  194,  195,  196,  197,  198,
      199,  200,   78,   78,   78,  208,  208,  208,  209,  209,
      209,  210,  210,  210,  166,  166,  166,  166,  166,  166,
      166,  166,  166,  166,  166,  217,  230,  230,  230,  230,
      230,  230,  230,  230,  230,   69,  231,   70,  231,  232,
      227,  224,  220,  219,  223,  222,  228,  225,  166,  218,
      233,  253,  233,  166,  226,  229,  233,  233,  233,  233,

       77,  192,  192,  192,  238,  238,  238,  239,  239,  240,
      240,  240,  241,  241,  250,  166,  233,  251,  233,  233,
      242,  242,  242,  166,  297,  235,  233,  166,  236,  147,
      147,  147,  236,  236,  236,  236,  236,  236,  236,  236,
      236,  236,  236,  249,  258,  233,  193,  194,  195,  196,
      197,  198,  199,  200,  147,  147,  147,  147,  147,  147,
      147,  147,  147,  244,  244,  244,  245,  245,  245,  246,
      246,  246,  247,  247,  247,  247,  247,  247,  247,  247,
      247,  166,  166,  166,  166,  166,  166,  166,  166,  166,
       69,  231,   70,  231,  232,  166,  166,  265,  166,  265,

      166,  166,  259,  265,  265,  265,  265,  166,  260,  166,
      252,  257,  166,  256,  273,  261,  254,  276,  255,  192,
      192,  192,  262,  265,  166,  265,  278,  263,  265,  192,
      192,  192,  274,  166,  267,  265,  275,  268,  192,  192,
      192,  268,  268,  268,  268,  268,  268,  268,  268,  268,
      268,  268,  279,  277,  265,  192,  192,  192,  269,  269,
      269,  270,  270,  270,  271,  271,  271,  272,  272,  272,
      272,  272,  272,  272,  272,  272,  166,  166,  166,  166,
      284,  285,  284,  264,  166,  285,  166,  285,  285,  166,
      166,  285,  285,  289,  289,  289,  283,  166,  166,  282,

      281,  289,  289,  289,  289,  289,  289,  285,  166,  291,
      280,  285,  285,  296,  292,  166,  166,  166,  287,  285,
      166,  288,  166,  295,  166,  288,  288,  288,  288,  288,
      288,  288,  288,  288,  288,  288,  290,  293,  285,  294,
      298,  304,  298,  166,  264,  166,  298,  298,  298,  298,
      166,  302,  248,  305,  303,  305,  166,  243,  237,  305,
      305,  305,  305,  166,  166,  213,  298,  310,  298,  298,
      212,  211,  207,  310,  310,  300,  298,  201,  301,  305,
      141,  305,  301,  301,  301,  301,  301,  301,  301,  301,
      301,  301,  301,  310,  309,  298,  305,  165,  162,  156,

      310,  166,  307,  305,  165,  308,  310,  310,  164,  308,
      308,  308,  308,  308,  308,  308,  308,  308,  308,  308,
      163,  162,  305,  156,  141,  314,  310,  310,  368,  137,
      117,  314,  314,  312,  310,  111,  313,  109,  108,  107,
      313,  313,  313,  313,  313,  313,  313,  313,  313,  313,
      313,  314,  314,  310,  318,  106,  318,  100,  314,  314,
      318,  318,  318,  318,  322,   99,   98,   97,   96,   92,
      322,  322,   89,   88,   87,   73,  368,  322,  314,  314,
      318,   62,  318,  322,  322,  316,  314,   62,  317,  368,
      322,  368,  317,  317,  317,  317,  317,  317,  317,  317,

      317,  317,  317,  322,  326,  314,  318,  368,  368,  368,
      326,  326,  320,  318,  368,  321,  368,  368,  368,  321,
      321,  321,  321,  321,  321,  321,  321,  321,  321,  321,
      326,  326,  318,  322,  368,  368,  368,  326,  326,  324,
      322,  368,  325,  368,  368,  368,  325,  325,  325,  325,
      325,  325,  325,  325,  325,  325,  325,  326,  330,  322,
      326,  368,  368,  368,  330,  330,  328,  326,  368,  329,
      368,  368,  368,  329,  329,  329,  329,  329,  329,  329,
      329,  329,  329,  329,  330,  330,  326,  334,  368,  334,
      368,  330,  330,  334,  334,  334,  334,  338,  368,  368,

      368,  368,  368,  338,  338,  368,  368,  368,  368,  368,
      338,  330,  330,  334,  368,  334,  338,  338,  332,  330,
      368,  333,  368,  338,  368,  333,  333,  333,  333,  333,
      333,  333,  333,  333,  333,  333,  338,  342,  330,  334,
      368,  368,  368,  342,  342,  336,  334,  368,  337,  368,
      368,  368,  337,  337,  337,  337,  337,  337,  337,  337,
      337,  337,  337,  342,  342,  334,  338,  368,  368,  368,
      342,  342,  340,  338,  368,  341,  368,  368,  368,  341,
      341,  341,  341,  341,  341,  341,  341,  341,  341,  341,
      342,  346,  338,  342,  368,  368,  368,  346,  346,  344,

      342,  368,  345,  368,  368,  368,  345,  345,  345,  345,
      345,  345,  345,  345,  345,  345,  345,  346,  346,  342,
      350,  368,  350,  368,  346,  346,  350,  350,  350,  350,
      354,  368,  368,  368,  368,  368,  354,  354,  368,  368,
      368,  368,  368,  354,  346,  346,  350,  368,  350,  354,
      354,  348,  346,  368,  349,  368,  354,  368,  349,  349,
      349,  349,  349,  349,  349,  349,  349,  349,  349,  354,
      358,  346,  350,  368,  368,  368,  358,  358,  352,  350,
      368,  353,  368,  368,  368,  353,  353,  353,  353,  353,
      353,  353,  353,  353,  353,  353,  358,  358,  350,  354,

      368,  368,  368,  358,  358,  356,  354,  368,  357,  368,
      368,  368,  357,  357,  357,  357,  357,  357,  357,  357,
      357,  357,  357,  358,  362,  354,  358,  368,  368,  368,
      362,  362,  360,  358,  368,  361,  368,  368,  368,  361,
      361,  361,  361,  361,  361,  361,  361,  361,  361,  361,
      362,  362,  358,  368,  368,  368,  368,  362,  362,  368,
      368,  368,  368,  368,  368,  368,  368,  368,  368,  368,
      368,  368,  368,  368,  368,  368,  368,  362,  362,  368,
      368,  368,  368,  368,  364,  362,  368,  365,  368,  368,
      368,  365,  365,  365,  365,  365,  365,  365,  365,  365,

      365,  365,  368,  368,  362,  368,  368,  368,  368,  368,
      368,   78,  368,  368,  367,  368,  368,  368,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  368,
      368,  368,   78,  368,  368,  368,   78,   78,   78,   78,
       78,   78,   78,   78,   78,   78,   78,   61,   61,   61,
       61,   61,   61,   61,   61,   61,   61,   61,   61,   63,
       63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
       63,   65,   65,   65,   65,   65,   65,   65,   65,   65,
       65,   65,   65,   68,   68,   68,   68,  368,   68,   68,
       72,   72,  368,   72,   72,   72,   72,   72,   72,   72,

       72,   72,   90,   90,   90,   90,  368,   90,   90,   91,
      368,  368,   91,  368,   91,   91,  118,  118,  368,  118,
      118,  118,  118,  118,  118,  118,  118,  118,  120,  120,
      368,  120,  120,  120,  120,  120,  120,  120,  120,  120,
      123,  123,  368,  123,  123,  123,  123,  123,  123,  123,
      123,  123,  138,  368,  368,  138,  138,  138,  138,  138,
      138,  138,  138,  138,  139,  139,  368,  139,  139,  139,
      139,  139,  139,  139,  139,  139,  144,  144,  144,  368,
      144,  368,  144,  147,  368,  368,  368,  147,  189,  189,
      189,  368,  189,  368,  189,  192,  368,  368,  192,  192,

      368,  192,  192,  234,  234,  234,  368,  234,  368,  234,
      266,  266,  266,  368,  266,  368,  266,  286,  286,  286,
      368,  286,  368,  286,  299,  299,  299,  368,  299,  368,
      299,  306,  306,  306,  368,  306,  368,  306,  311,  311,
      311,  368,  311,  368,  311,  315,  315,  315,  368,  315,
      368,  315,  319,  319,  319,  368,  319,  368,  319,  323,
      323,  323,  368,  323,  368,  323,  327,  327,  327,  368,
      327,  368,  327,  331,  331,  331,  368,  331,  368,  331,
      335,  335,  335,  368,  335,  368,  335,  339,  339,  339,
      368,  339,  368,  339,  343,  343,  343,  368,  343,  368,

      343,  347,  347,  347,  368,  347,  368,  347,  351,  351,
      351,  368,  351,  368,  351,  355,  355,  355,  368,  355,
      368,  355,  359,  359,  359,  368,  359,  368,  359,  363,
      363,  363,  368,  363,  368,  363,    7,  368,  368,  368,
      368,  368,  368,  368,  368,  368,  368,  368,  368,  368,
      368,  368,  368,  368,  368,  368,  368,  368,  368,  368,
      368,  368,  368,  368,  368,  368,  368,  368,  368,  368,
      368,  368,  368,  368,  368,  368,  368,  368,  368,  368,
      368,  368,  368,  368,  368,  368,  368,  368,  368,  368,
      368,  368,  368,  368,  368,  368,  368,  368,  368,  368,

      368,  368,  368,  368,  368,  368,  368,  368
    } ;

static const flex_int16_t yy_chk[1809] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,   93,    9,    2,    9,    2,    3,    3,    3,
        2,    4,    4,    4,   12,  404,   21,    2,   21,   54,
       21,   54,    2,   33,   39,   94,   33,    2,    2,    2,

        2,   93,   33,   39,   49,   49,   39,   51,   51,   39,
       12,   25,   39,   46,   46,   46,  309,   25,   25,   69,
       25,   25,   94,   69,   25,   25,   25,   25,   25,   25,
       25,   25,   25,   25,   25,   82,   82,   25,   25,   25,
       25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
       25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
       48,   48,   48,   50,   50,   50,  304,   25,   25,   25,
       25,   25,   25,   25,   25,   52,   52,   52,   56,   56,
      303,   56,   56,   56,   56,   56,   56,   56,   56,   56,
       56,   56,   56,   56,   56,   56,   56,   56,   56,   56,

       56,   56,   56,   56,   56,   56,   56,   56,   56,   56,
       56,   56,   56,   56,   56,   56,   56,   56,   56,   56,
       56,   56,   56,   56,   56,   56,   56,   56,   56,   56,
       56,   56,   56,   56,   56,   56,   56,   56,   56,   56,
       56,   56,   56,   56,   56,   56,   56,   56,   56,   59,
       59,  297,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,

       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       64,   65,   64,   71,   74,   71,   95,   71,   84,   84,
       74,   74,   77,   77,   77,   77,   77,   77,   77,   77,
       79,   79,   79,   81,   81,   81,   99,   65,  296,   92,
       74,   75,   83,   83,   83,   97,  105,   75,   75,   95,
       75,   85,   85,   85,   75,   75,   75,   75,   75,   75,
       75,   75,   75,   75,   75,   92,   97,   75,   78,  102,
       99,  103,  100,   96,   78,   78,   98,   78,  101,  105,
      104,   78,   78,   78,   78,   78,   78,   78,   78,   78,

       78,   78,   96,  100,   78,   98,  106,  107,  101,  167,
      119,  103,  119,  174,  102,  104,  100,  111,  111,  111,
      112,  112,  112,  113,  113,  113,  167,  106,  114,  114,
      114,  115,  115,  115,  174,  107,  116,  116,  116,  117,
      117,  117,  124,  129,  129,  129,  132,  132,  124,  124,
      127,  127,  127,  127,  127,  127,  127,  127,  131,  131,
      131,  133,  133,  133,  134,  134,  151,  151,  124,  135,
      135,  135,  140,  142,  140,  142,  140,  142,  143,  168,
      144,  148,  148,  148,  143,  143,  144,  144,  147,  150,
      150,  150,  152,  152,  152,  153,  153,  154,  154,  154,

      156,  156,  156,  294,  143,  169,  144,  145,  157,  157,
      157,  293,  168,  145,  145,  290,  145,  158,  158,  158,
      145,  145,  145,  145,  145,  145,  145,  145,  145,  145,
      145,  170,  169,  145,  147,  147,  147,  147,  147,  147,
      147,  147,  159,  159,  159,  160,  160,  160,  161,  161,
      161,  162,  162,  162,  171,  172,  173,  175,  178,  176,
      179,  180,  181,  182,  218,  170,  184,  184,  184,  185,
      185,  185,  186,  186,  186,  187,  187,  187,  187,  187,
      180,  178,  173,  172,  176,  175,  181,  179,  216,  171,
      188,  218,  189,  215,  179,  182,  188,  188,  189,  189,

      192,  193,  193,  193,  195,  195,  195,  196,  196,  197,
      197,  197,  198,  198,  215,  214,  188,  216,  189,  190,
      199,  199,  199,  225,  284,  190,  190,  281,  190,  201,
      201,  201,  190,  190,  190,  190,  190,  190,  190,  190,
      190,  190,  190,  214,  225,  190,  192,  192,  192,  192,
      192,  192,  192,  192,  202,  202,  202,  203,  203,  203,
      204,  204,  204,  205,  205,  205,  206,  206,  206,  207,
      207,  207,  208,  208,  208,  209,  209,  209,  210,  210,
      210,  217,  219,  220,  223,  226,  224,  227,  228,  229,
      232,  232,  232,  232,  232,  249,  253,  233,  256,  234,

      279,  278,  226,  233,  233,  234,  234,  275,  227,  252,
      217,  224,  251,  223,  249,  228,  219,  253,  220,  237,
      237,  237,  228,  233,  257,  234,  256,  229,  235,  238,
      238,  238,  251,  255,  235,  235,  252,  235,  239,  239,
      239,  235,  235,  235,  235,  235,  235,  235,  235,  235,
      235,  235,  257,  255,  235,  240,  240,  240,  241,  241,
      241,  242,  242,  242,  243,  243,  243,  244,  244,  244,
      245,  245,  245,  246,  246,  246,  258,  259,  261,  262,
      264,  265,  264,  264,  274,  266,  276,  265,  265,  282,
      283,  266,  266,  269,  269,  269,  262,  263,  260,  261,

      259,  270,  270,  270,  271,  271,  271,  265,  254,  274,
      258,  266,  267,  283,  276,  273,  277,  291,  267,  267,
      292,  267,  280,  282,  295,  267,  267,  267,  267,  267,
      267,  267,  267,  267,  267,  267,  273,  277,  267,  280,
      285,  295,  286,  250,  231,  222,  285,  285,  286,  286,
      221,  291,  211,  298,  292,  299,  302,  200,  194,  298,
      298,  299,  299,  183,  177,  165,  285,  305,  286,  287,
      164,  163,  155,  305,  305,  287,  287,  149,  287,  298,
      141,  299,  287,  287,  287,  287,  287,  287,  287,  287,
      287,  287,  287,  305,  302,  287,  300,  137,  136,  130,

      306,   91,  300,  300,   89,  300,  306,  306,   88,  300,
      300,  300,  300,  300,  300,  300,  300,  300,  300,  300,
       87,   86,  300,   80,   70,  310,  306,  307,   67,   60,
       53,  310,  310,  307,  307,   47,  307,   44,   42,   41,
      307,  307,  307,  307,  307,  307,  307,  307,  307,  307,
      307,  310,  311,  307,  314,   40,  315,   38,  311,  311,
      314,  314,  315,  315,  318,   37,   36,   35,   34,   32,
      318,  318,   29,   28,   27,   24,    7,  319,  311,  312,
      314,    6,  315,  319,  319,  312,  312,    5,  312,    0,
      318,    0,  312,  312,  312,  312,  312,  312,  312,  312,

      312,  312,  312,  319,  322,  312,  316,    0,    0,    0,
      322,  322,  316,  316,    0,  316,    0,    0,    0,  316,
      316,  316,  316,  316,  316,  316,  316,  316,  316,  316,
      322,  323,  316,  320,    0,    0,    0,  323,  323,  320,
      320,    0,  320,    0,    0,    0,  320,  320,  320,  320,
      320,  320,  320,  320,  320,  320,  320,  323,  326,  320,
      324,    0,    0,    0,  326,  326,  324,  324,    0,  324,
        0,    0,    0,  324,  324,  324,  324,  324,  324,  324,
      324,  324,  324,  324,  326,  327,  324,  330,    0,  331,
        0,  327,  327,  330,  330,  331,  331,  334,    0,    0,

        0,    0,    0,  334,  334,    0,    0,    0,    0,    0,
      335,  327,  328,  330,    0,  331,  335,  335,  328,  328,
        0,  328,    0,  334,    0,  328,  328,  328,  328,  328,
      328,  328,  328,  328,  328,  328,  335,  338,  328,  332,
        0,    0,    0,  338,  338,  332,  332,    0,  332,    0,
        0,    0,  332,  332,  332,  332,  332,  332,  332,  332,
      332,  332,  332,  338,  339,  332,  336,    0,    0,    0,
      339,  339,  336,  336,    0,  336,    0,    0,    0,  336,
      336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
      339,  342,  336,  340,    0,    0,    0,  342,  342,  340,

      340,    0,  340,    0,    0,    0,  340,  340,  340,  340,
      340,  340,  340,  340,  340,  340,  340,  342,  343,  340,
      346,    0,  347,    0,  343,  343,  346,  346,  347,  347,
      350,    0,    0,    0,    0,    0,  350,  350,    0,    0,
        0,    0,    0,  351,  343,  344,  346,    0,  347,  351,
      351,  344,  344,    0,  344,    0,  350,    0,  344,  344,
      344,  344,  344,  344,  344,  344,  344,  344,  344,  351,
      354,  344,  348,    0,    0,    0,  354,  354,  348,  348,
        0,  348,    0,    0,    0,  348,  348,  348,  348,  348,
      348,  348,  348,  348,  348,  348,  354,  355,  348,  352,

        0,    0,    0,  355,  355,  352,  352,    0,  352,    0,
        0,    0,  352,  352,  352,  352,  352,  352,  352,  352,
      352,  352,  352,  355,  358,  352,  356,    0,    0,    0,
      358,  358,  356,  356,    0,  356,    0,    0,    0,  356,
      356,  356,  356,  356,  356,  356,  356,  356,  356,  356,
      358,  359,  356,    0,    0,    0,    0,  359,  359,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  359,  360,    0,
        0,    0,    0,    0,  360,  360,    0,  360,    0,    0,
        0,  360,  360,  360,  360,  360,  360,  360,  360,  360,

      360,  360,    0,    0,  360,  364,    0,    0,    0,    0,
        0,  364,  364,    0,  364,    0,    0,    0,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,    0,
        0,  364,  367,    0,    0,    0,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  369,  369,  369,
      369,  369,  369,  369,  369,  369,  369,  369,  369,  370,
      370,  370,  370,  370,  370,  370,  370,  370,  370,  370,
      370,  371,  371,  371,  371,  371,  371,  371,  371,  371,
      371,  371,  371,  372,  372,  372,  372,    0,  372,  372,
      373,  373,    0,  373,  373,  373,  373,  373,  373,  373,

      373,  373,  374,  374,  374,  374,    0,  374,  374,  375,
        0,    0,  375,    0,  375,  375,  376,  376,    0,  376,
      376,  376,  376,  376,  376,  376,  376,  376,  377,  377,
        0,  377,  377,  377,  377,  377,  377,  377,  377,  377,
      378,  378,    0,  378,  378,  378,  378,  378,  378,  378,
      378,  378,  379,    0,    0,  379,  379,  379,  379,  379,
      379,  379,  379,  379,  380,  380,    0,  380,  380,  380,
      380,  380,  380,  380,  380,  380,  381,  381,  381,    0,
      381,    0,  381,  382,    0,    0,    0,  382,  383,  383,
      383,    0,  383,    0,  383,  384,    0,    0,  384,  384,

        0,  384,  384,  385,  385,  385,    0,  385,    0,  385,
      386,  386,  386,    0,  386,    0,  386,  387,  387,  387,
        0,  387,    0,  387,  388,  388,  388,    0,  388,    0,
      388,  389,  389,  389,    0,  389,    0,  389,  390,  390,
      390,    0,  390,    0,  390,  391,  391,  391,    0,  391,
        0,  391,  392,  392,  392,    0,  392,    0,  392,  393,
      393,  393,    0,  393,    0,  393,  394,  394,  394,    0,
      394,    0,  394,  395,  395,  395,    0,  395,    0,  395,
      396,  396,  396,    0,  396,    0,  396,  397,  397,  397,
        0,  397,    0,  397,  398,  398,  398,    0,  398,    0,

      398,  399,  399,  399,    0,  399,    0,  399,  400,  400,
      400,    0,  400,    0,  400,  401,  401,  401,    0,  401,
        0,  401,  402,  402,  402,    0,  402,    0,  402,  403,
      403,  403,    0,  403,    0,  403,  368,  368,  368,  368,
      368,  368,  368,  368,  368,  368,  368,  368,  368,  368,
      368,  368,  368,  368,  368,  368,  368,  368,  368,  368,
      368,  368,  368,  368,  368,  368,  368,  368,  368,  368,
      368,  368,  368,  368,  368,  368,  368,  368,  368,  368,
      368,  368,  368,  368,  368,  368,  368,  368,  368,  368,
      368,  368,  368,  368,  368,  368,  368,  368,  368,  368,

      368,  368,  368,  368,  368,  368,  368,  368
    } ;

/* Table of booleans, true if rule could match eol. */
static const flex_int32_t yy_rule_can_match_eol[59] =
    {   0,
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,     };

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "beancount/parser/lexer.l"
/* -*- mode: c -*- */
/* A flex lexer for Beancount. */
/* Options */
#define YY_NO_INPUT 1
/* %option nodefault */
/* %option debug */
/* %option stack */
/* %option 8bit */
/* Top code. This is included in the generated header file. */

/* Definitions. */
#line 85 "beancount/parser/lexer.l"

#include <math.h>
#include <stdlib.h>
#include <stdarg.h>

#include "beancount/parser/grammar.h"
#include "beancount/parser/tokens.h"

/**
 * Build and accumulate an error on the builder object.
 */
void build_lexer_error(YYLTYPE* loc, PyObject* builder, const char* format, ...);

/**
 * Build and accumulate an error using the current exception state.
 */
void build_lexer_error_from_exception(YYLTYPE* loc, PyObject* builder);

/**
 * Read from a io.BaseIO Python object into a buffer.
 */
int pyfile_read_into(PyObject *file, char *buf, size_t max_size);

#define YY_INPUT(buf, result, max_size)                         \
    result = pyfile_read_into((PyObject *)yyin, buf, max_size);

#define YY_USER_ACTION                                        \
    {                                                         \
        yylloc->first_line = yylineno;                        \
        yylloc->last_line = yylloc->first_line;               \
        yylloc->first_column = yycolumn;                      \
        yylloc->last_column = yycolumn + yyleng - 1;          \
        yylloc->file_name = yyget_extra(yyscanner)->filename; \
        yycolumn += yyleng;                                   \
    }

#line 1109 "beancount/parser/lexer.c"

#line 138 "beancount/parser/lexer.l"
 /* Characters that may be used as flags. Make sure to include all the
  * values from beancount.core.flags to allow round-trips between text
  * and entries. {5307d8fa1e7b} */
#line 1115 "beancount/parser/lexer.c"

#define INITIAL 0
#define INVALID 1
#define IGNORE 2

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#define YY_EXTRA_TYPE yyextra_t*

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
    {

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top; /**< index of top of stack. */
    size_t yy_buffer_stack_max; /**< capacity of stack. */
    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    int yy_n_chars;
    int yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char* yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    YYSTYPE * yylval_r;

    YYLTYPE * yylloc_r;

    }; /* end struct yyguts_t */

static int yy_init_globals ( yyscan_t yyscanner );

    /* This must go here because YYSTYPE and YYLTYPE are included
     * from bison output in section 1.*/
    #    define yylval yyg->yylval_r
    
    #    define yylloc yyg->yylloc_r
    
int yylex_init (yyscan_t* scanner);

int yylex_init_extra ( YY_EXTRA_TYPE user_defined, yyscan_t* scanner);

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( yyscan_t yyscanner );

int yyget_debug ( yyscan_t yyscanner );

void yyset_debug ( int debug_flag , yyscan_t yyscanner );

YY_EXTRA_TYPE yyget_extra ( yyscan_t yyscanner );

void yyset_extra ( YY_EXTRA_TYPE user_defined , yyscan_t yyscanner );

FILE *yyget_in ( yyscan_t yyscanner );

void yyset_in  ( FILE * _in_str , yyscan_t yyscanner );

FILE *yyget_out ( yyscan_t yyscanner );

void yyset_out  ( FILE * _out_str , yyscan_t yyscanner );

			int yyget_leng ( yyscan_t yyscanner );

char *yyget_text ( yyscan_t yyscanner );

int yyget_lineno ( yyscan_t yyscanner );

void yyset_lineno ( int _line_number , yyscan_t yyscanner );

int yyget_column  ( yyscan_t yyscanner );

void yyset_column ( int _column_no , yyscan_t yyscanner );

YYSTYPE * yyget_lval ( yyscan_t yyscanner );

void yyset_lval ( YYSTYPE * yylval_param , yyscan_t yyscanner );

       YYLTYPE *yyget_lloc ( yyscan_t yyscanner );
    
        void yyset_lloc ( YYLTYPE * yylloc_param , yyscan_t yyscanner );
    
/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( yyscan_t yyscanner );
#else
extern int yywrap ( yyscan_t yyscanner );
#endif
#endif

#ifndef YY_NO_UNPUT
    
    static void yyunput ( int c, char *buf_ptr  , yyscan_t yyscanner);
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int , yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * , yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( yyscan_t yyscanner );
#else
static int input ( yyscan_t yyscanner );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg , yyscanner)
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex \
               (YYSTYPE * yylval_param, YYLTYPE * yylloc_param , yyscan_t yyscanner);

#define YY_DECL int yylex \
               (YYSTYPE * yylval_param, YYLTYPE * yylloc_param , yyscan_t yyscanner)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    yylval = yylval_param;

    yylloc = yylloc_param;

	if ( !yyg->yy_init )
		{
		yyg->yy_init = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yyg->yy_start )
			yyg->yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack (yyscanner);
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
		}

		yy_load_buffer_state( yyscanner );
		}

	{
#line 143 "beancount/parser/lexer.l"


 /* Newlines matter. */
#line 1406 "beancount/parser/lexer.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yyg->yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yyg->yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yyg->yy_start;
		yy_current_state += YY_AT_BOL();
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				yyg->yy_last_accepting_state = yy_current_state;
				yyg->yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 369 )
					yy_c = yy_meta[yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 368 );
		yy_cp = yyg->yy_last_accepting_cpos;
		yy_current_state = yyg->yy_last_accepting_state;

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

		if ( yy_act != YY_END_OF_BUFFER && yy_rule_can_match_eol[yy_act] )
			{
			int yyl;
			for ( yyl = 0; yyl < yyleng; ++yyl )
				if ( yytext[yyl] == '\n' )
					
    do{ yylineno++;
        yycolumn=0;
    }while(0)
;
			}

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yyg->yy_hold_char;
			yy_cp = yyg->yy_last_accepting_cpos;
			yy_current_state = yyg->yy_last_accepting_state;
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 146 "beancount/parser/lexer.l"
{
    yycolumn = 1;
    return EOL;
}
	YY_BREAK
/* Whitespace: ignored, except when found at the beginning of a line
  * and followed by a regular character. This is how we detect an
  * initial indent and thus group syntax elements in the grammar. */
case 2:
*yy_cp = yyg->yy_hold_char; /* undo effects of setting up yytext */
yyg->yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 154 "beancount/parser/lexer.l"
{ return INDENT; }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 155 "beancount/parser/lexer.l"
{ }
	YY_BREAK
/* Comments. */
case 4:
YY_RULE_SETUP
#line 158 "beancount/parser/lexer.l"
{ }
	YY_BREAK
/* Characters with special meanings. */
case 5:
YY_RULE_SETUP
#line 161 "beancount/parser/lexer.l"
{ return PIPE; }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 162 "beancount/parser/lexer.l"
{ return ATAT; }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 163 "beancount/parser/lexer.l"
{ return AT; }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 164 "beancount/parser/lexer.l"
{ return LCURLCURL; }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 165 "beancount/parser/lexer.l"
{ return RCURLCURL; }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 166 "beancount/parser/lexer.l"
{ return LCURL; }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 167 "beancount/parser/lexer.l"
{ return RCURL; }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 168 "beancount/parser/lexer.l"
{ return COMMA; }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 169 "beancount/parser/lexer.l"
{ return TILDE; }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 170 "beancount/parser/lexer.l"
{ return PLUS; }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 171 "beancount/parser/lexer.l"
{ return MINUS; }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 172 "beancount/parser/lexer.l"
{ return SLASH; }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 173 "beancount/parser/lexer.l"
{ return LPAREN; }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 174 "beancount/parser/lexer.l"
{ return RPAREN; }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 175 "beancount/parser/lexer.l"
{ return HASH; }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 176 "beancount/parser/lexer.l"
{ return ASTERISK; }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 177 "beancount/parser/lexer.l"
{ return COLON; }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 179 "beancount/parser/lexer.l"
{
    yylval->character = yytext[0];
    return FLAG;
}
	YY_BREAK
/* Keywords. */
case 23:
YY_RULE_SETUP
#line 185 "beancount/parser/lexer.l"
{ return TXN; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 186 "beancount/parser/lexer.l"
{ return BALANCE; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 187 "beancount/parser/lexer.l"
{ return OPEN; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 188 "beancount/parser/lexer.l"
{ return CLOSE; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 189 "beancount/parser/lexer.l"
{ return COMMODITY; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 190 "beancount/parser/lexer.l"
{ return PAD; }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 191 "beancount/parser/lexer.l"
{ return EVENT; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 192 "beancount/parser/lexer.l"
{ return QUERY; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 193 "beancount/parser/lexer.l"
{ return CUSTOM; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 194 "beancount/parser/lexer.l"
{ return PRICE; }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 195 "beancount/parser/lexer.l"
{ return NOTE; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 196 "beancount/parser/lexer.l"
{ return DOCUMENT; }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 197 "beancount/parser/lexer.l"
{ return PUSHTAG; }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 198 "beancount/parser/lexer.l"
{ return POPTAG; }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 199 "beancount/parser/lexer.l"
{ return PUSHMETA; }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 200 "beancount/parser/lexer.l"
{ return POPMETA; }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 201 "beancount/parser/lexer.l"
{ return OPTION; }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 202 "beancount/parser/lexer.l"
{ return PLUGIN; }
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 203 "beancount/parser/lexer.l"
{ return INCLUDE; }
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 205 "beancount/parser/lexer.l"
{
    return TOKEN(BOOL, true);
}
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 209 "beancount/parser/lexer.l"
{
    return TOKEN(BOOL, false);
}
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 213 "beancount/parser/lexer.l"
{
    return TOKEN(NONE);
}
	YY_BREAK
/* Dates. */
case 45:
YY_RULE_SETUP
#line 218 "beancount/parser/lexer.l"
{
    return TOKEN(DATE, yytext);
}
	YY_BREAK
/* Account names. */
case 46:
YY_RULE_SETUP
#line 223 "beancount/parser/lexer.l"
{
    return TOKEN(ACCOUNT, yytext);
}
	YY_BREAK
/* Currencies. These are defined as uppercase only in order to
  * disambiguate the syntax. This is to be kept in sync with
  * beancount.core.amount.CURRENCY_RE. */
case 47:
YY_RULE_SETUP
#line 230 "beancount/parser/lexer.l"
{
    return TOKEN(CURRENCY, yytext, yyleng);
}
	YY_BREAK
/* String literals. */
case 48:
/* rule 48 can match eol */
YY_RULE_SETUP
#line 235 "beancount/parser/lexer.l"
{
    return TOKEN(STRING, yytext + 1, yyleng - 2, yyget_extra(yyscanner)->encoding);
}
	YY_BREAK
/* Numbers. */
case 49:
YY_RULE_SETUP
#line 240 "beancount/parser/lexer.l"
{
    return TOKEN(NUMBER, yytext);
}
	YY_BREAK
/* Tags. */
case 50:
YY_RULE_SETUP
#line 245 "beancount/parser/lexer.l"
{
    return TOKEN(TAG, yytext + 1, yyleng - 1);
}
	YY_BREAK
/* Links. */
case 51:
YY_RULE_SETUP
#line 250 "beancount/parser/lexer.l"
{
    return TOKEN(LINK, yytext + 1, yyleng - 1);
}
	YY_BREAK
/* Keys. */
case 52:
*yy_cp = yyg->yy_hold_char; /* undo effects of setting up yytext */
yyg->yy_c_buf_p = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 255 "beancount/parser/lexer.l"
{
    return TOKEN(KEY, yytext, yyleng);
}
	YY_BREAK
/* Lines starting with an asterisk, a colon, an hash, or a character
  * in the FLAGS characters set are ignored. This rule is inserted
  * here to give higher precedence to rules matching valid tokens. */
case 53:
*yy_cp = yyg->yy_hold_char; /* undo effects of setting up yytext */
yyg->yy_c_buf_p = yy_cp = yy_bp + 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 262 "beancount/parser/lexer.l"
{ BEGIN(IGNORE); }
	YY_BREAK
case 54:
*yy_cp = yyg->yy_hold_char; /* undo effects of setting up yytext */
yyg->yy_c_buf_p = yy_cp = yy_bp + 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 263 "beancount/parser/lexer.l"
{ BEGIN(IGNORE); }
	YY_BREAK
/* Default rule. {bf253a29a820} */
case 55:
YY_RULE_SETUP
#line 266 "beancount/parser/lexer.l"
{
    unput(*yytext);
    BEGIN(INVALID);
}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(INVALID):
case YY_STATE_EOF(IGNORE):
#line 271 "beancount/parser/lexer.l"
{
    /* Ensure location data is populated. */
    YY_USER_ACTION;
    return YYEOF;
}
	YY_BREAK
/* Ivalid input: skip over to to the next whitespace character. */
case 56:
YY_RULE_SETUP
#line 278 "beancount/parser/lexer.l"
{
    PyObject* input = PyUnicode_Decode(yytext, yyleng, "utf-8", "backslashreplace");
    build_lexer_error(yylloc, builder, "Invalid token: '%U'", input);
    BEGIN(INITIAL);
    return YYerror;
}
	YY_BREAK
/* Ignore input till the newline. */
case 57:
YY_RULE_SETUP
#line 285 "beancount/parser/lexer.l"
{
    BEGIN(INITIAL);
}
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 289 "beancount/parser/lexer.l"
ECHO;
	YY_BREAK
#line 1846 "beancount/parser/lexer.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yyg->yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yyg->yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( yyscanner );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state , yyscanner);

			yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yyg->yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yyg->yy_last_accepting_cpos;
				yy_current_state = yyg->yy_last_accepting_state;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( yyscanner ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yyg->yy_did_buffer_switch_on_eof = 0;

				if ( yywrap( yyscanner ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yyg->yy_c_buf_p =
					yyg->yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yyg->yy_c_buf_p =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = yyg->yytext_ptr;
	int number_to_move, i;
	int ret_val;

	if ( yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) (yyg->yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yyg->yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			yyg->yy_n_chars, num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	if ( yyg->yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  , yyscanner);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size , yyscanner );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	yyg->yy_n_chars += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (yyscan_t yyscanner)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_current_state = yyg->yy_start;
	yy_current_state += YY_AT_BOL();

	for ( yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yyg->yy_last_accepting_state = yy_current_state;
			yyg->yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 369 )
				yy_c = yy_meta[yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state , yyscan_t yyscanner)
{
	int yy_is_jam;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner; /* This var may be unused depending upon options. */
	char *yy_cp = yyg->yy_c_buf_p;

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yyg->yy_last_accepting_state = yy_current_state;
		yyg->yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 369 )
			yy_c = yy_meta[yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	yy_is_jam = (yy_current_state == 368);

	(void)yyg;
	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

    static void yyunput (int c, char * yy_bp , yyscan_t yyscanner)
{
	char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    yy_cp = yyg->yy_c_buf_p;

	/* undo effects of setting up yytext */
	*yy_cp = yyg->yy_hold_char;

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		int number_to_move = yyg->yy_n_chars + 2;
		char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			yyg->yy_n_chars = (int) YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

    if ( c == '\n' ){
        --yylineno;
    }

	yyg->yytext_ptr = yy_bp;
	yyg->yy_hold_char = *yy_cp;
	yyg->yy_c_buf_p = yy_cp;
}

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (yyscan_t yyscanner)
#else
    static int input  (yyscan_t yyscanner)
#endif

{
	int c;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	*yyg->yy_c_buf_p = yyg->yy_hold_char;

	if ( *yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			/* This was really a NUL. */
			*yyg->yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr);
			++yyg->yy_c_buf_p;

			switch ( yy_get_next_buffer( yyscanner ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin , yyscanner);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( yyscanner ) )
						return 0;

					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(yyscanner);
#else
					return input(yyscanner);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yyg->yy_c_buf_p;	/* cast for 8-bit char's */
	*yyg->yy_c_buf_p = '\0';	/* preserve yytext */
	yyg->yy_hold_char = *++yyg->yy_c_buf_p;

	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = (c == '\n');
	if ( YY_CURRENT_BUFFER_LVALUE->yy_at_bol )
		
    do{ yylineno++;
        yycolumn=0;
    }while(0)
;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack (yyscanner);
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file , yyscanner);
	yy_load_buffer_state( yyscanner );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack (yyscanner);
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( yyscanner );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yyg->yy_did_buffer_switch_on_eof = 1;
}

static void yy_load_buffer_state  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	yyg->yy_hold_char = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file , yyscanner);

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * @param yyscanner The scanner object.
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf , yyscanner );

	yyfree( (void *) b , yyscanner );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file , yyscan_t yyscanner)

{
	int oerrno = errno;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_flush_buffer( b , yyscanner);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( yyscanner );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack(yyscanner);

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		yyg->yy_buffer_stack_top++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( yyscanner );
	yyg->yy_did_buffer_switch_on_eof = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */
void yypop_buffer_state (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER , yyscanner);
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if (yyg->yy_buffer_stack_top > 0)
		--yyg->yy_buffer_stack_top;

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( yyscanner );
		yyg->yy_did_buffer_switch_on_eof = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (yyscan_t yyscanner)
{
	yy_size_t num_to_alloc;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if (!yyg->yy_buffer_stack) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		yyg->yy_buffer_stack_max = num_to_alloc;
		yyg->yy_buffer_stack_top = 0;
		return;
	}

	if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = yyg->yy_buffer_stack_max + grow_size;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyrealloc
								(yyg->yy_buffer_stack,
								num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0, grow_size * sizeof(struct yy_buffer_state*));
		yyg->yy_buffer_stack_max = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b , yyscanner );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr , yyscan_t yyscanner)
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) , yyscanner);
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n , yyscanner );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n , yyscanner);
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;
	fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = yyg->yy_hold_char; \
		yyg->yy_c_buf_p = yytext + yyless_macro_arg; \
		yyg->yy_hold_char = *yyg->yy_c_buf_p; \
		*yyg->yy_c_buf_p = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */
YY_EXTRA_TYPE yyget_extra  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyextra;
}

/** Get the current line number.
 * @param yyscanner The scanner object.
 */
int yyget_lineno  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yylineno;
}

/** Get the current column number.
 * @param yyscanner The scanner object.
 */
int yyget_column  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yycolumn;
}

/** Get the input stream.
 * @param yyscanner The scanner object.
 */
FILE *yyget_in  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyin;
}

/** Get the output stream.
 * @param yyscanner The scanner object.
 */
FILE *yyget_out  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyout;
}

/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */
int yyget_leng  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyleng;
}

/** Get the current token.
 * @param yyscanner The scanner object.
 */

char *yyget_text  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yytext;
}

/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
void yyset_extra (YY_EXTRA_TYPE  user_defined , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyextra = user_defined ;
}

/** Set the current line number.
 * @param _line_number line number
 * @param yyscanner The scanner object.
 */
void yyset_lineno (int  _line_number , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* lineno is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "yyset_lineno called with no buffer" );
    
    yylineno = _line_number;
}

/** Set the current column.
 * @param _column_no column number
 * @param yyscanner The scanner object.
 */
void yyset_column (int  _column_no , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* column is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "yyset_column called with no buffer" );
    
    yycolumn = _column_no;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyin = _in_str ;
}

void yyset_out (FILE *  _out_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyout = _out_str ;
}

int yyget_debug  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yy_flex_debug;
}

void yyset_debug (int  _bdebug , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yy_flex_debug = _bdebug ;
}

/* Accessor methods for yylval and yylloc */

YYSTYPE * yyget_lval  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yylval;
}

void yyset_lval (YYSTYPE *  yylval_param , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yylval = yylval_param;
}

YYLTYPE *yyget_lloc  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yylloc;
}
    
void yyset_lloc (YYLTYPE *  yylloc_param , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yylloc = yylloc_param;
}
    
/* User-visible API */

/* yylex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */
int yylex_init(yyscan_t* ptr_yy_globals)
{
    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), NULL );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    return yy_init_globals ( *ptr_yy_globals );
}

/* yylex_init_extra has the same functionality as yylex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to yyalloc in
 * the yyextra field.
 */
int yylex_init_extra( YY_EXTRA_TYPE yy_user_defined, yyscan_t* ptr_yy_globals )
{
    struct yyguts_t dummy_yyguts;

    yyset_extra (yy_user_defined, &dummy_yyguts);

    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), &dummy_yyguts );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in
    yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    yyset_extra (yy_user_defined, *ptr_yy_globals);

    return yy_init_globals ( *ptr_yy_globals );
}

static int yy_init_globals (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack = NULL;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p = NULL;
    yyg->yy_init = 0;
    yyg->yy_start = 0;

    yyg->yy_start_stack_ptr = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack =  NULL;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER , yyscanner );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state(yyscanner);
	}

	/* Destroy the stack itself. */
	yyfree(yyg->yy_buffer_stack , yyscanner);
	yyg->yy_buffer_stack = NULL;

    /* Destroy the start condition stack. */
        yyfree( yyg->yy_start_stack , yyscanner );
        yyg->yy_start_stack = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( yyscanner);

    /* Destroy the main struct (reentrant only). */
    yyfree ( yyscanner , yyscanner );
    yyscanner = NULL;
    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;

	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s , yyscan_t yyscanner)
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;
	return malloc(size);
}

void *yyrealloc  (void * ptr, yy_size_t  size , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;

	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void yyfree (void * ptr , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;
	free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 289 "beancount/parser/lexer.l"


yyscan_t yylex_new(void)
{
    yyscan_t scanner;
    yyextra_t* extra;

    extra = malloc(sizeof(*extra));
    if (!extra)
        return NULL;

    extra->filename = NULL;

    yylex_init_extra(extra, &scanner);
    if (!scanner) {
        free(extra);
        return NULL;
    }

    return scanner;
}

yyscan_t yylex_free(yyscan_t scanner)
{
    yyextra_t* extra = yyget_extra(scanner);

    Py_XDECREF(extra->filename);
    free(extra);

    Py_XDECREF(yyget_in(scanner));
    yylex_destroy(scanner);

    return NULL;
}

/* yyrestart() does not reset the scanner back to INITIAL state and
 * Flex does not provide a way of doing so outside a scanner
 * rule. This function does just that accessing Flex internals. */
static void yybegin(yyscan_t scanner)
{
    struct yyguts_t* yyg = (struct yyguts_t*)scanner;
    BEGIN(INITIAL);
}

void yylex_initialize(PyObject* file, PyObject* filename, int lineno,
                      const char* encoding, PyObject* missing_obj, yyscan_t scanner)
{
    yyextra_t* extra = yyget_extra(scanner);

    if (!filename || filename == Py_None) {
        /* If a filename has not been specified, get it from the 'name'
	 * attribute of the input file object. */
        filename = PyObject_GetAttrString(file, "name");
        if (!filename) {
	    /* No 'name' attribute. */
	    PyErr_Clear();
            /* Use the empty string. */
            filename = PyUnicode_FromString("");
        }
    } else {
        Py_INCREF(filename);
    }

    Py_XDECREF(extra->filename);
    extra->filename = filename;

    extra->encoding = encoding ? encoding : "utf-8";

    extra->missing_obj = missing_obj;

    Py_XDECREF(yyget_in(scanner));
    Py_INCREF(file);
    yyrestart((void *)file, scanner);
    yybegin(scanner);

    yyset_lineno(lineno, scanner);
}

void build_lexer_error(YYLTYPE* loc, PyObject* builder, const char* format, ...)
{
    PyObject* error;
    PyObject* rv;
    va_list va;

    va_start(va, format);
    error = PyUnicode_FromFormatV(format, va);
    va_end(va);

    if (!error) {
        return;
    }

    rv = PyObject_CallMethod(builder, "build_lexer_error", "OiO",
                             loc->file_name, loc->first_line, error);

    Py_XDECREF(rv);
    Py_XDECREF(error);
}

void build_lexer_error_from_exception(YYLTYPE* loc, PyObject* builder)
{
    PyObject* type;
    PyObject* value;
    PyObject* traceback;

    PyErr_Fetch(&type, &value, &traceback);
    PyErr_NormalizeException(&type, &value, &traceback);

    build_lexer_error(loc, builder, "%s: %S", PyExceptionClass_Name(type), value);

    Py_XDECREF(type);
    Py_XDECREF(value);
    Py_XDECREF(traceback);
}

int pyfile_read_into(PyObject *file, char *buf, size_t max_size)
{
    PyObject* dest = NULL;
    PyObject* read = NULL;
    int ret = 0;

#ifdef PYPY_VERSION_NUM
    Py_ssize_t length;
    char* buffer;

    /* PyPy does not support readinto() a memory view. Resort to
     * read() and copy the content of the returned bytes object into
     * the lexer buffer. */

    read = PyObject_CallMethod(file, "read", "n", (Py_ssize_t)max_size);
    if (!read) {
	goto error;
    }

    ret = PyBytes_AsStringAndSize(read, &buffer, &length);
    if (ret < 0) {
        goto error;
    }

    assert(length <= max_size);
    memcpy(buf, buffer, length);
    ret = length;

#else
    /* This function could be optimized in two ways: avoiding to
     * allocate a new memory view object for every block read and
     * caching the lookup of the readinto method of the file
     * object. */

    dest = PyMemoryView_FromMemory(buf, max_size, PyBUF_WRITE);
    if (!dest) {
	goto error;
    }

    read = PyObject_CallMethod(file, "readinto", "O", dest);
    if (!read) {
	goto error;
    }

    ret = PyLong_AsSize_t(read);
    if (PyErr_Occurred()) {
	ret = 0;
    }
#endif

error:
    Py_XDECREF(dest);
    Py_XDECREF(read);
    return ret;
}

