
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bseserver.proc"
// Licensed GNU LGPL v2.1 or later: http://www.gnu.org/licenses/lgpl.html
#include <bse/bseplugin.hh>
#include <bse/bseprocedure.hh>
#include <bse/bseserver.hh>
#include <bse/bseproject.hh>
#include <bse/bseloader.hh>
#include <bse/bsemidinotifier.hh>
#include <bse/bsemidievent.hh>
#include <bse/bsejanitor.hh>
#include <bse/bsescripthelper.hh>
#include <bse/bsegconfig.hh>
#include <bse/bseladspa.hh>
#include "topconfig.h"
#include <string.h>
/* --- use-new-project --- */
static void
use_new_project_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 17 "bseserver.proc"
 {
#line 19 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Project Name", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++) = bse_param_spec_object ("project", "Project", NULL,
				 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
}
#line 26 "bseserver.proc"
 }
static BseErrorType
#line 26 "bseserver.proc"
use_new_project_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 29 "bseserver.proc"
{
#line 30 "bseserver.proc"
  
  BseServer *server = (BseServer*) bse_value_get_object (in_values++);
  const char *name = sfi_value_get_string (in_values++);
  gchar *uname;
  guint num = 1;
  BseProject *project;
#line 36 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server) || !name)
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 39 "bseserver.proc"
  
  uname = g_strdup (name);
  while (bse_server_find_project (server, uname))
    {
      g_free (uname);
      uname = g_strdup_printf ("%s-%u", name, num++);
    }
#line 46 "bseserver.proc"
  
  project = bse_server_create_project (server, uname);
  g_free (uname);
  bse_item_use (BSE_ITEM (project));
  g_object_unref (project);
#line 51 "bseserver.proc"
  
  bse_value_set_object (out_values++, G_OBJECT (project));
  return BSE_ERROR_NONE;
}
/* --- can-load --- */
static void
can_load_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 55 "bseserver.proc"
 {
#line 57 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("file_name", "File Name", "The file to find a loader for",
			    NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("can-load", NULL, NULL,
			  FALSE, SFI_PARAM_STANDARD);
}
#line 64 "bseserver.proc"
 }
static BseErrorType
#line 64 "bseserver.proc"
can_load_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 67 "bseserver.proc"
{
#line 68 "bseserver.proc"
  
  BseServer *server = (BseServer*) bse_value_get_object (in_values++);
  const char *file_name = sfi_value_get_string (in_values++);
  BseWaveFileInfo *finfo;
#line 72 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server) || !file_name)
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 75 "bseserver.proc"
  
  finfo = bse_wave_file_info_load (file_name, NULL);
  sfi_value_set_bool (out_values++, finfo != NULL);
  if (finfo)
    bse_wave_file_info_unref (finfo);
  return BSE_ERROR_NONE;
}
/* --- n-scripts --- */
static void
n_scripts_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 82 "bseserver.proc"
 {
#line 84 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("n_connections", NULL, "Number of Connections",
			 0, 0, G_MAXINT, 1,
			 SFI_PARAM_STANDARD);
}
#line 90 "bseserver.proc"
 }
static BseErrorType
#line 90 "bseserver.proc"
n_scripts_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 93 "bseserver.proc"
{
#line 94 "bseserver.proc"
  
  BseServer *server = (BseServer*) bse_value_get_object (in_values++);
  GSList *slist;
  guint n_scripts = 0;
#line 98 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 101 "bseserver.proc"
  
  for (slist = server->children; slist; slist = slist->next)
    if (BSE_IS_JANITOR (slist->data))
      n_scripts++;
#line 105 "bseserver.proc"
  
  sfi_value_set_int (out_values++, n_scripts);
  return BSE_ERROR_NONE;
}
/* --- preferences-locked --- */
static void
preferences_locked_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 109 "bseserver.proc"
 {
#line 111 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("locked", NULL, NULL,
			  FALSE, SFI_PARAM_STANDARD);
}
#line 116 "bseserver.proc"
 }
static BseErrorType
#line 116 "bseserver.proc"
preferences_locked_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 119 "bseserver.proc"
{
#line 120 "bseserver.proc"
  
  BseServer *server = (BseServer*) bse_value_get_object (in_values++);
#line 122 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 125 "bseserver.proc"
  
  sfi_value_set_int (out_values++, bse_gconfig_locked ());
  return BSE_ERROR_NONE;
}
typedef struct _ScriptRegistration ScriptRegistration;
struct _ScriptRegistration
{
  gchar         *script;
  BseErrorType (*register_func) (const gchar *script,
				 BseJanitor **janitor_p);
  ScriptRegistration *next;
};
static gboolean	register_scripts (gpointer data);
static void
script_janitor_closed (BseJanitor *janitor,
		       BseServer  *server)
{
  bse_server_registration (server, BSE_REGISTER_SCRIPT, janitor->script_name, NULL);
  bse_idle_normal (register_scripts, server);
}
static gboolean
register_scripts (gpointer data)
{
  BseServer *server = (BseServer*) data;
  ScriptRegistration *scr = (ScriptRegistration*) g_object_get_data ((GObject*) server, "script-registration-queue");
  BseJanitor *janitor = NULL;
  BseErrorType error;
  if (!scr)
    {
      bse_server_registration (server, BSE_REGISTER_DONE, NULL, NULL);
      return FALSE;
    }
  g_object_set_data ((GObject*) server, "script-registration-queue", scr->next);
  error = scr->register_func (scr->script, &janitor);
  if (!janitor)
    bse_server_registration (server, BSE_REGISTER_SCRIPT, scr->script, bse_error_blurb (error));
  else
    g_object_connect (janitor, "signal::shutdown", script_janitor_closed, server, NULL);
  g_free (scr->script);
  g_free (scr);
  return !janitor;
}
/* --- register-scripts --- */
static void
register_scripts_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 167 "bseserver.proc"
 {
#line 169 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
}
#line 172 "bseserver.proc"
 }
static BseErrorType
#line 172 "bseserver.proc"
register_scripts_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 175 "bseserver.proc"
{
  static gboolean registration_done = FALSE;
#line 177 "bseserver.proc"
  
  BseServer *server = (BseServer*) bse_value_get_object (in_values++);
  ScriptRegistration *scr_list = NULL;
  SfiRing *ring;
#line 181 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;
  if (registration_done)
    {
      bse_server_registration (server, BSE_REGISTER_DONE, NULL, NULL);
      return BSE_ERROR_NONE;
    }
  registration_done = TRUE;
  ring = bse_script_path_list_files ();
  while (ring)
    {
      ScriptRegistration *scr = g_new0 (ScriptRegistration, 1);
      scr->script = (char*) sfi_ring_pop_head (&ring);
      scr->register_func = bse_script_file_register;
      scr->next = scr_list;
      scr_list = scr;
    }
  g_object_set_data ((GObject*) server, "script-registration-queue", scr_list);
  bse_idle_normal (register_scripts, server);
  return BSE_ERROR_NONE;
}
static gboolean
register_core_plugins (gpointer data)
{
  BseServer *server = (BseServer*) data;
  SfiRing *plugins = (SfiRing*) g_object_get_data ((GObject*) server, "plugin-registration-queue");
  const gchar *error;
  if (plugins)
    {
      char *name = (char*) sfi_ring_pop_head (&plugins);
      g_object_set_data ((GObject*) server, "plugin-registration-queue", plugins);
      error = bse_plugin_check_load (name);
      bse_server_registration (server, BSE_REGISTER_PLUGIN, name, error);
      g_free (name);
    }
  else
    {
      bse_server_registration (server, BSE_REGISTER_DONE, NULL, NULL);
      return FALSE;
    }
  return TRUE;
}
/* --- register-core-plugins --- */
static void
register_core_plugins_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 224 "bseserver.proc"
 {
#line 226 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
}
#line 229 "bseserver.proc"
 }
static BseErrorType
#line 229 "bseserver.proc"
register_core_plugins_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 232 "bseserver.proc"
{
  static gboolean registration_done = FALSE;
#line 234 "bseserver.proc"
  
  BseServer *server = (BseServer*) bse_value_get_object (in_values++);
  SfiRing *ring;
#line 237 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;
  if (registration_done)
    {
      bse_server_registration (server, BSE_REGISTER_DONE, NULL, NULL);
      return BSE_ERROR_NONE;
    }
  registration_done = TRUE;
  ring = bse_plugin_path_list_files (!bse_main_args->load_drivers_early, TRUE);
  g_object_set_data ((GObject*) server, "plugin-registration-queue", ring);
  bse_idle_normal (register_core_plugins, server);
  return BSE_ERROR_NONE;
}
static gboolean
register_ladspa_plugins (gpointer data)
{
  BseServer *server = (BseServer*) data;
  SfiRing *lplugins = (SfiRing*) g_object_get_data ((GObject*) server, "ladspa-registration-queue");
  const gchar *error;
  if (g_object_get_data ((GObject*) server, "plugin-registration-queue"))
    {
#line 259 "bseserver.proc"
      
      return TRUE;
    }
  if (lplugins)
    {
      char *name = (char*) sfi_ring_pop_head (&lplugins);
      g_object_set_data ((GObject*) server, "ladspa-registration-queue", lplugins);
      error = bse_ladspa_plugin_check_load (name);
      bse_server_registration (server, BSE_REGISTER_PLUGIN, name, error);
      g_free (name);
    }
  else
    {
      bse_server_registration (server, BSE_REGISTER_DONE, NULL, NULL);
      return FALSE;
    }
  return TRUE;
}
/* --- register-ladspa-plugins --- */
static void
register_ladspa_plugins_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 277 "bseserver.proc"
 {
#line 279 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
}
#line 282 "bseserver.proc"
 }
static BseErrorType
#line 282 "bseserver.proc"
register_ladspa_plugins_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 285 "bseserver.proc"
{
  static gboolean registration_done = FALSE;
#line 287 "bseserver.proc"
  
  BseServer *server = (BseServer*) bse_value_get_object (in_values++);
  SfiRing *ring;
#line 290 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;
  if (registration_done)
    {
      bse_server_registration (server, BSE_REGISTER_DONE, NULL, NULL);
      return BSE_ERROR_NONE;
    }
  registration_done = TRUE;
  ring = bse_ladspa_plugin_path_list_files ();
  g_object_set_data ((GObject*) server, "ladspa-registration-queue", ring);
  bse_idle_normal (register_ladspa_plugins, server);
  return BSE_ERROR_NONE;
}
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
/* --- save-preferences --- */
static void
save_preferences_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 308 "bseserver.proc"
 {
#line 310 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
}
#line 313 "bseserver.proc"
 }
static BseErrorType
#line 313 "bseserver.proc"
save_preferences_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 316 "bseserver.proc"
{
#line 317 "bseserver.proc"
  
  BseServer *server = (BseServer*) bse_value_get_object (in_values++);
  SfiWStore *wstore;
  gchar *file_name;
  GValue *value;
  SfiRec *rec;
  gint fd;
#line 324 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;
  file_name = g_strconcat (g_get_home_dir (), "/.bserc", NULL);
  fd = open (file_name,
#line 329 "bseserver.proc"
	     O_WRONLY | O_CREAT | O_TRUNC, 
	     0666);
  g_free (file_name);
  if (fd < 0)
    return BSE_ERROR_NONE;
  wstore = sfi_wstore_new ();
  sfi_wstore_printf (wstore, "; rc-file for BSE v%s\n", BSE_VERSION);
#line 336 "bseserver.proc"
  
  sfi_wstore_puts (wstore, "\n; BseGConfig Dump\n");
  rec = bse_gconfig_to_rec (bse_global_config);
  value = sfi_value_rec (rec);
  sfi_wstore_put_param (wstore, value, bse_gconfig_pspec ());
  sfi_value_free (value);
  sfi_rec_unref (rec);
  sfi_wstore_puts (wstore, "\n");
#line 344 "bseserver.proc"
  
  sfi_wstore_flush_fd (wstore, fd);
  sfi_wstore_destroy (wstore);
  close (fd);
  return BSE_ERROR_NONE;
}
/* --- start-recording --- */
static void
start_recording_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 350 "bseserver.proc"
 {
#line 352 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("wave-file", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_real ("n_seconds", NULL, "Maximum number of recorded seconds",
			  0, 0, SFI_MAXNUM, 60, SFI_PARAM_STANDARD);
}
#line 358 "bseserver.proc"
 }
static BseErrorType
#line 358 "bseserver.proc"
start_recording_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 361 "bseserver.proc"
{
#line 362 "bseserver.proc"
  
  BseServer *server = (BseServer*) bse_value_get_object (in_values++);
  const char *wave_file = g_value_get_string (in_values++);
  double n_seconds      = g_value_get_double (in_values++);
#line 366 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;
  bse_server_start_recording (server, wave_file, n_seconds);
  return BSE_ERROR_NONE;
}
/* --- get-version --- */
static void
get_version_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 372 "bseserver.proc"
 {
#line 374 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("version", NULL, NULL, NULL, SFI_PARAM_STANDARD);
}
#line 378 "bseserver.proc"
 }
static BseErrorType
#line 378 "bseserver.proc"
get_version_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 381 "bseserver.proc"
{
  sfi_value_set_string (out_values++, BSE_VERSION);
  return BSE_ERROR_NONE;
}
/* --- get-demo-path --- */
static void
get_demo_path_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 385 "bseserver.proc"
 {
#line 387 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("path", NULL, NULL, NULL, SFI_PARAM_STANDARD);
}
#line 391 "bseserver.proc"
 }
static BseErrorType
#line 391 "bseserver.proc"
get_demo_path_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 394 "bseserver.proc"
{
  sfi_value_set_string (out_values++, BSE_PATH_DEMOS);
  return BSE_ERROR_NONE;
}
/* --- get-sample-path --- */
static void
get_sample_path_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 398 "bseserver.proc"
 {
#line 400 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("path", NULL, NULL, NULL, SFI_PARAM_STANDARD);
}
#line 404 "bseserver.proc"
 }
static BseErrorType
#line 404 "bseserver.proc"
get_sample_path_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 407 "bseserver.proc"
{
  sfi_value_take_string (out_values++, g_path_concat (BSE_PATH_SAMPLES, BSE_GCONFIG (sample_path), NULL));
  return BSE_ERROR_NONE;
}
/* --- get-custom-effect-dir --- */
static void
get_custom_effect_dir_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 411 "bseserver.proc"
 {
#line 413 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("directory", NULL, NULL, NULL, SFI_PARAM_STANDARD);
}
#line 417 "bseserver.proc"
 }
static BseErrorType
#line 417 "bseserver.proc"
get_custom_effect_dir_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 420 "bseserver.proc"
{
  gchar **dirs = g_strsplit (BSE_GCONFIG (effect_path), G_SEARCHPATH_SEPARATOR_S, 2);
  sfi_value_set_string (out_values++, dirs[0]);
  g_strfreev (dirs);
  return BSE_ERROR_NONE;
}
/* --- get-effect-path --- */
static void
get_effect_path_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 426 "bseserver.proc"
 {
#line 428 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("path", NULL, NULL, NULL, SFI_PARAM_STANDARD);
}
#line 432 "bseserver.proc"
 }
static BseErrorType
#line 432 "bseserver.proc"
get_effect_path_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 435 "bseserver.proc"
{
  sfi_value_take_string (out_values++, g_path_concat (BSE_PATH_EFFECTS, BSE_GCONFIG (effect_path), NULL));
  return BSE_ERROR_NONE;
}
/* --- get-custom-instrument-dir --- */
static void
get_custom_instrument_dir_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 439 "bseserver.proc"
 {
#line 441 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("directory", NULL, NULL, NULL, SFI_PARAM_STANDARD);
}
#line 445 "bseserver.proc"
 }
static BseErrorType
#line 445 "bseserver.proc"
get_custom_instrument_dir_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 448 "bseserver.proc"
{
  gchar **dirs = g_strsplit (BSE_GCONFIG (instrument_path), G_SEARCHPATH_SEPARATOR_S, 2);
  sfi_value_set_string (out_values++, dirs[0]);
  g_strfreev (dirs);
  return BSE_ERROR_NONE;
}
/* --- get-instrument-path --- */
static void
get_instrument_path_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 454 "bseserver.proc"
 {
#line 456 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("path", NULL, NULL, NULL, SFI_PARAM_STANDARD);
}
#line 460 "bseserver.proc"
 }
static BseErrorType
#line 460 "bseserver.proc"
get_instrument_path_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 463 "bseserver.proc"
{
  sfi_value_take_string (out_values++, g_path_concat (BSE_PATH_INSTRUMENTS, BSE_GCONFIG (instrument_path), NULL));
  return BSE_ERROR_NONE;
}
/* --- get-script-path --- */
static void
get_script_path_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 467 "bseserver.proc"
 {
#line 469 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("path", NULL, NULL, NULL, SFI_PARAM_STANDARD);
}
#line 473 "bseserver.proc"
 }
static BseErrorType
#line 473 "bseserver.proc"
get_script_path_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 476 "bseserver.proc"
{
  sfi_value_take_string (out_values++, g_path_concat (BSE_PATH_SCRIPTS, BSE_GCONFIG (script_path), NULL));
  return BSE_ERROR_NONE;
}
/* --- get-plugin-path --- */
static void
get_plugin_path_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 480 "bseserver.proc"
 {
#line 482 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("path", NULL, NULL, NULL, SFI_PARAM_STANDARD);
}
#line 486 "bseserver.proc"
 }
static BseErrorType
#line 486 "bseserver.proc"
get_plugin_path_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 489 "bseserver.proc"
{
  sfi_value_take_string (out_values++, g_path_concat (BSE_PATH_PLUGINS, BSE_GCONFIG (plugin_path), NULL));
  return BSE_ERROR_NONE;
}
/* --- get-ladspa-path --- */
static void
get_ladspa_path_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 493 "bseserver.proc"
 {
#line 495 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("path", NULL, NULL, NULL, SFI_PARAM_STANDARD);
}
#line 499 "bseserver.proc"
 }
static BseErrorType
#line 499 "bseserver.proc"
get_ladspa_path_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 502 "bseserver.proc"
{
  sfi_value_take_string (out_values++, g_path_concat (BSE_PATH_LADSPA, BSE_GCONFIG (ladspa_path), NULL));
  return BSE_ERROR_NONE;
}
#include "gslvorbis-enc.hh"
/* --- get-vorbis-version --- */
static void
get_vorbis_version_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 507 "bseserver.proc"
 {
#line 509 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("version", NULL, NULL, NULL, SFI_PARAM_STANDARD);
}
#line 513 "bseserver.proc"
 }
static BseErrorType
#line 513 "bseserver.proc"
get_vorbis_version_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 516 "bseserver.proc"
{
  gchar *v = gsl_vorbis_encoder_version();
  if (v && strncmp (v, "Xiphophorus libVorbis", 21) == 0)
    sfi_value_take_string (out_values++, g_strconcat ("Ogg/Vorbis", v + 21, NULL));
  else if (v && strncmp (v, "Xiph.Org libVorbis", 18) == 0)
    sfi_value_take_string (out_values++, g_strconcat ("Ogg/Vorbis", v + 18, NULL));
  else if (v)
    sfi_value_take_string (out_values++, g_strconcat ("Ogg/Vorbis ", v, NULL));
  g_free (v);
  return BSE_ERROR_NONE;
}
#include "gsldatahandle-mad.hh"
/* --- get-mp3-version --- */
static void
get_mp3_version_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 528 "bseserver.proc"
 {
#line 530 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("version", NULL, NULL, NULL, SFI_PARAM_STANDARD);
}
#line 534 "bseserver.proc"
 }
static BseErrorType
#line 534 "bseserver.proc"
get_mp3_version_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 537 "bseserver.proc"
{
  const gchar *c = gsl_data_handle_mad_version ();
  if (c)
    sfi_value_take_string (out_values++, g_strconcat ("MAD ", c, NULL));
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_use_new_project__fill_strings (BseExportStrings *es)
{
  es->blurb = "Create a new project, owned by the caller (name is modified to be unique if necessary)";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 18;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_use_new_project = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseServer+use-new-project", 
    NULL,
    "/Methods/BseServer/General/Use New Project",
    NULL,
    __enode_use_new_project__fill_strings,
  },
  0, use_new_project_setup, use_new_project_exec, 
};
static void
__enode_can_load__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether a loader can be found for a wave file";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 56;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_can_load = {
  { (BseExportNode*) &__enode_use_new_project, BSE_EXPORT_NODE_PROC,
    "BseServer+can-load", 
    NULL,
    "/Methods/BseServer/General/Can Load",
    NULL,
    __enode_can_load__fill_strings,
  },
  0, can_load_setup, can_load_exec, 
};
static void
__enode_n_scripts__fill_strings (BseExportStrings *es)
{
  es->blurb = "Return the number of scripts currently running on this server.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 83;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_n_scripts = {
  { (BseExportNode*) &__enode_can_load, BSE_EXPORT_NODE_PROC,
    "BseServer+n-scripts", 
    NULL,
    "/Methods/BseServer/General/N Scripts",
    NULL,
    __enode_n_scripts__fill_strings,
  },
  0, n_scripts_setup, n_scripts_exec, 
};
static void
__enode_preferences_locked__fill_strings (BseExportStrings *es)
{
  es->blurb = "Returns whether the bse-preferences property is currently locked against modifications or not.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 110;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_preferences_locked = {
  { (BseExportNode*) &__enode_n_scripts, BSE_EXPORT_NODE_PROC,
    "BseServer+preferences-locked", 
    NULL,
    "/Methods/BseServer/General/Preferences Locked",
    NULL,
    __enode_preferences_locked__fill_strings,
  },
  0, preferences_locked_setup, preferences_locked_exec, 
};
static void
__enode_register_scripts__fill_strings (BseExportStrings *es)
{
  es->blurb = "Register external scripts.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 168;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_register_scripts = {
  { (BseExportNode*) &__enode_preferences_locked, BSE_EXPORT_NODE_PROC,
    "BseServer+register-scripts", 
    NULL,
    "/Methods/BseServer/General/Register Scripts",
    NULL,
    __enode_register_scripts__fill_strings,
  },
  0, register_scripts_setup, register_scripts_exec, 
};
static void
__enode_register_core_plugins__fill_strings (BseExportStrings *es)
{
  es->blurb = "Register core plugins.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 225;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_register_core_plugins = {
  { (BseExportNode*) &__enode_register_scripts, BSE_EXPORT_NODE_PROC,
    "BseServer+register-core-plugins", 
    NULL,
    "/Methods/BseServer/General/Register Core Plugins",
    NULL,
    __enode_register_core_plugins__fill_strings,
  },
  0, register_core_plugins_setup, register_core_plugins_exec, 
};
static void
__enode_register_ladspa_plugins__fill_strings (BseExportStrings *es)
{
  es->blurb = "Register LADSPA (Linux Audio Developer's Simple Plugin API) plugins.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 278;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_register_ladspa_plugins = {
  { (BseExportNode*) &__enode_register_core_plugins, BSE_EXPORT_NODE_PROC,
    "BseServer+register-ladspa-plugins", 
    NULL,
    "/Methods/BseServer/General/Register Ladspa Plugins",
    NULL,
    __enode_register_ladspa_plugins__fill_strings,
  },
  0, register_ladspa_plugins_setup, register_ladspa_plugins_exec, 
};
static void
__enode_save_preferences__fill_strings (BseExportStrings *es)
{
  es->blurb = "Request the bse-preferences property to be saved into BSE's configuration file.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 309;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_save_preferences = {
  { (BseExportNode*) &__enode_register_ladspa_plugins, BSE_EXPORT_NODE_PROC,
    "BseServer+save-preferences", 
    NULL,
    "/Methods/BseServer/General/Save Preferences",
    NULL,
    __enode_save_preferences__fill_strings,
  },
  0, save_preferences_setup, save_preferences_exec, 
};
static void
__enode_start_recording__fill_strings (BseExportStrings *es)
{
  es->blurb = "Start recording to a WAV file.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 351;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_start_recording = {
  { (BseExportNode*) &__enode_save_preferences, BSE_EXPORT_NODE_PROC,
    "BseServer+start-recording", 
    NULL,
    "/Methods/BseServer/General/Start Recording",
    NULL,
    __enode_start_recording__fill_strings,
  },
  0, start_recording_setup, start_recording_exec, 
};
static void
__enode_get_version__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve BSE version.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 373;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_version = {
  { (BseExportNode*) &__enode_start_recording, BSE_EXPORT_NODE_PROC,
    "BseServer+get-version", 
    NULL,
    "/Methods/BseServer/General/Get Version",
    NULL,
    __enode_get_version__fill_strings,
  },
  0, get_version_setup, get_version_exec, 
};
static void
__enode_get_demo_path__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve demo search path.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 386;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_demo_path = {
  { (BseExportNode*) &__enode_get_version, BSE_EXPORT_NODE_PROC,
    "BseServer+get-demo-path", 
    NULL,
    "/Methods/BseServer/General/Get Demo Path",
    NULL,
    __enode_get_demo_path__fill_strings,
  },
  0, get_demo_path_setup, get_demo_path_exec, 
};
static void
__enode_get_sample_path__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve sample search path.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 399;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_sample_path = {
  { (BseExportNode*) &__enode_get_demo_path, BSE_EXPORT_NODE_PROC,
    "BseServer+get-sample-path", 
    NULL,
    "/Methods/BseServer/General/Get Sample Path",
    NULL,
    __enode_get_sample_path__fill_strings,
  },
  0, get_sample_path_setup, get_sample_path_exec, 
};
static void
__enode_get_custom_effect_dir__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve user specific effects directory.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 412;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_custom_effect_dir = {
  { (BseExportNode*) &__enode_get_sample_path, BSE_EXPORT_NODE_PROC,
    "BseServer+get-custom-effect-dir", 
    NULL,
    "/Methods/BseServer/General/Get Custom Effect Dir",
    NULL,
    __enode_get_custom_effect_dir__fill_strings,
  },
  0, get_custom_effect_dir_setup, get_custom_effect_dir_exec, 
};
static void
__enode_get_effect_path__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve effect search path.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 427;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_effect_path = {
  { (BseExportNode*) &__enode_get_custom_effect_dir, BSE_EXPORT_NODE_PROC,
    "BseServer+get-effect-path", 
    NULL,
    "/Methods/BseServer/General/Get Effect Path",
    NULL,
    __enode_get_effect_path__fill_strings,
  },
  0, get_effect_path_setup, get_effect_path_exec, 
};
static void
__enode_get_custom_instrument_dir__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve user specific instruments directory.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 440;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_custom_instrument_dir = {
  { (BseExportNode*) &__enode_get_effect_path, BSE_EXPORT_NODE_PROC,
    "BseServer+get-custom-instrument-dir", 
    NULL,
    "/Methods/BseServer/General/Get Custom Instrument Dir",
    NULL,
    __enode_get_custom_instrument_dir__fill_strings,
  },
  0, get_custom_instrument_dir_setup, get_custom_instrument_dir_exec, 
};
static void
__enode_get_instrument_path__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve instrument search path.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 455;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_instrument_path = {
  { (BseExportNode*) &__enode_get_custom_instrument_dir, BSE_EXPORT_NODE_PROC,
    "BseServer+get-instrument-path", 
    NULL,
    "/Methods/BseServer/General/Get Instrument Path",
    NULL,
    __enode_get_instrument_path__fill_strings,
  },
  0, get_instrument_path_setup, get_instrument_path_exec, 
};
static void
__enode_get_script_path__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve script search path.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 468;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_script_path = {
  { (BseExportNode*) &__enode_get_instrument_path, BSE_EXPORT_NODE_PROC,
    "BseServer+get-script-path", 
    NULL,
    "/Methods/BseServer/General/Get Script Path",
    NULL,
    __enode_get_script_path__fill_strings,
  },
  0, get_script_path_setup, get_script_path_exec, 
};
static void
__enode_get_plugin_path__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve plugin search path.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 481;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_plugin_path = {
  { (BseExportNode*) &__enode_get_script_path, BSE_EXPORT_NODE_PROC,
    "BseServer+get-plugin-path", 
    NULL,
    "/Methods/BseServer/General/Get Plugin Path",
    NULL,
    __enode_get_plugin_path__fill_strings,
  },
  0, get_plugin_path_setup, get_plugin_path_exec, 
};
static void
__enode_get_ladspa_path__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve ladspa search path.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 494;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_ladspa_path = {
  { (BseExportNode*) &__enode_get_plugin_path, BSE_EXPORT_NODE_PROC,
    "BseServer+get-ladspa-path", 
    NULL,
    "/Methods/BseServer/General/Get Ladspa Path",
    NULL,
    __enode_get_ladspa_path__fill_strings,
  },
  0, get_ladspa_path_setup, get_ladspa_path_exec, 
};
static void
__enode_get_vorbis_version__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve BSE Vorbis handler version.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 508;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_vorbis_version = {
  { (BseExportNode*) &__enode_get_ladspa_path, BSE_EXPORT_NODE_PROC,
    "BseServer+get-vorbis-version", 
    NULL,
    "/Methods/BseServer/General/Get Vorbis Version",
    NULL,
    __enode_get_vorbis_version__fill_strings,
  },
  0, get_vorbis_version_setup, get_vorbis_version_exec, 
};
static void
__enode_get_mp3_version__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve BSE MP3 handler version.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 529;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_mp3_version = {
  { (BseExportNode*) &__enode_get_vorbis_version, BSE_EXPORT_NODE_PROC,
    "BseServer+get-mp3-version", 
    NULL,
    "/Methods/BseServer/General/Get Mp3 Version",
    NULL,
    __enode_get_mp3_version__fill_strings,
  },
  0, get_mp3_version_setup, get_mp3_version_exec, 
};
extern "C" BseExportNode* bse__builtin_init_bseserver_genprc_cc (void)
{
  return (BseExportNode*) &__enode_get_mp3_version;
}

/*
 * Generated data ends here
 */
