//
//  BCStringDefinitions.h
//  BioCocoa
//
//  Created by Koen van der Drift on Thu Mar 17 2005.
//  Copyright (c) 2003-2009 The BioCocoa Project.
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//  1. Redistributions of source code must retain the above copyright
//  notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//  notice, this list of conditions and the following disclaimer in the
//  documentation and/or other materials provided with the distribution.
//  3. The name of the author may not be used to endorse or promote products
//  derived from this software without specific prior written permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
//  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
//  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
//  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
//  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
//  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
//  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
//  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
//  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
//  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

/*!
@header
@abstract Global property strings used by the BioCocoa Foundation framework. 
*/

#import "BCInternal.h"

// BCSymbol Strings

/*!
 @constant BCSymbolNameProperty
 @abstract Symbol Name Property
*/
extern NSString * const BCSymbolNameProperty;
/*!
 @constant BCSymbolMonoisotopicMassProperty
 @abstract Monoisotopic Mass Symbol Property
 */
extern NSString * const BCSymbolMonoisotopicMassProperty;
/*!
 @constant BCSymbolAverageMassProperty
 @abstract Average Mass Symbol Property
 */
extern NSString * const BCSymbolAverageMassProperty;
/*!
 @constant BCSymbolThreeLetterCodeProperty
 @abstract Three Letter Code Symbol Property
 */
extern NSString * const BCSymbolThreeLetterCodeProperty;
/*!
 @constant BCSymbolpKaProperty
 @abstract Ka Symbol Property
 */
extern NSString * const BCSymbolpKaProperty;
/*!
 @constant BCSymbolKyteDoolittleProperty
 @abstract Kyte Doolittle Symbol Property
 */
extern NSString * const BCSymbolKyteDoolittleProperty;
/*!
 @constant BCSymbolHoppWoodsProperty
 @abstract Hopp Woods Symbol Property
 */
extern NSString * const BCSymbolHoppWoodsProperty;
/*!
 @constant BCSymbolRepresentsProperty
 @abstract Represents Symbol Property
 */
extern NSString * const BCSymbolRepresentsProperty;
/*!
 @constant BCSymbolRepresentedByProperty
 @abstract Represented By Symbol Property
 */
extern NSString * const BCSymbolRepresentedByProperty;
/*!
 @constant BCSymbolAllComplementsProperty
 @abstract All Complements Symbol Property
 */
extern NSString * const BCSymbolAllComplementsProperty;
/*!
 @constant BCSymbolComplementProperty
 @abstract Complement Symbol Property
 */
extern NSString * const BCSymbolComplementProperty;
/*!
 @constant BCSymbolSymbolProperty
 @abstract Symbol Property
 */
extern NSString * const BCSymbolSymbolProperty;


// BCAlignment Strings

// Properties
/*!
 @constant BCGapPenaltyProperty
 @abstract Gap Penalty Property
 */
extern NSString * const BCGapPenaltyProperty;

// possible values
/*!
 @constant BCDefaultGapPenalty
 @abstract Default Gap Property
 */
extern NSString * const BCDefaultGapPenalty;
/*!
 @constant BCAffineGapPenalty
 @abstract Affine Gap Property
 */
extern NSString * const BCAffineGapPenalty;

// substitution matrix
/*!
 @constant BCSubstitutionMatrixProperty
 @abstract Substitution Matrix Property
 */
extern NSString * const BCSubstitutionMatrixProperty;

// NSNumbers
/*!
 @constant BCDefaultGapPenaltyProperty
 @abstract Default Gap Penalty Property
 */
extern NSString * const BCDefaultGapPenaltyProperty;
/*!
 @constant BCGapOpenPenaltyProperty
 @abstract Gap Open Penalty Property
 */
extern NSString * const BCGapOpenPenaltyProperty;
/*!
 @constant BCGapExtensionPenaltyProperty
 @abstract Gap Extension Penalty Property
 */
extern NSString * const BCGapExtensionPenaltyProperty;



