+++
title = "Cosine ripple"
weight = 20
+++

## Cosine ripple

A ripple with a symmetric cosine profile that is uniform in $x$-direction.

<img src="/img/draw/ff/3d/CosineRipple.png" width="30%" >
<img src="/img/draw/ff/2d/CosineRipple_xy.svg" width="30%">
<img src="/img/draw/ff/2d/CosineRipple_yz.svg" width="30%">

#### Constructor

```python
CosineRippleBox(L, W, H)
CosineRippleGauss(L, W, H)
CosineRippleLorentz(L, W, H)
```

Parameters:
- L, length
- W, width
- H, height

#### Usage

As for any other [Form factor](/ref/sample/particle/ff).

#### Implementation

Class {{% ref-class "Sample/HardParticle" "CosineRipple" %}} inherits from the interface class
{{% ref-class "Sample/Particle" "IFormfactor" %}}.

Form factor is computed as

$$  F(\mathbf{q}) = f_\parallel(q_x) f_\bot(q_y,q_z), $$

where $ f_\bot(q_y,q_z) $ is calculated numerically
and $ f_\parallel(q_x) $ is chosen according to [longitudinal profile](/ref/sample/particle/ff/ripples/).

Volume [has been validated]({{% url-src %}}/Tests/Unit/Sample/FormfactorBasicTest.cpp)
against
$$ V=\dfrac{LWH}{2}. $$

#### Scattering

Scattering by uncorrelated, oriented cosine ripples for horizontal incidence. Rotation around $z$ axis:

<img src="/img/auto/ff/CosineRippleBox.png">

Generated by {{% ref-ex "ff/CosineRippleBox.py" %}}.

#### History

"CosineRippleBox" replicates "Ripple1" from FitGISAXS [[Babonneau 2013](/lit/babonneau2013)].
