.\" Copyright 1994 NEC Corporation, Tokyo, Japan.
.\"
.\" Permission to use, copy, modify, distribute and sell this software
.\" and its documentation for any purpose is hereby granted without
.\" fee, provided that the above copyright notice appear in all copies
.\" and that both that copyright notice and this permission notice
.\" appear in supporting documentation, and that the name of NEC
.\" Corporation not be used in advertising or publicity pertaining to
.\" distribution of the software without specific, written prior
.\" permission.  NEC Corporation makes no representations about the
.\" suitability of this software for any purpose.  It is provided "as
.\" is" without express or implied warranty.
.\"
.\" NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN 
.\" NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
.\" USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR 
.\" OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR 
.\" PERFORMANCE OF THIS SOFTWARE. 
.\"
.\" $Id: RkGetLex.man,v 1.1.1.1 2002/10/19 08:27:44 aida_s Exp $ NEC;
.TH "RKGETLEX" "3"
.SH "NAME"
\f4RkGetLex\f1 \- get morphemic information on each word that makes up the current candidate
.SH "SYNOPSIS"
.nf
.ft 4
#include <canna/RK.h>
int RkGetLex(cxnum, lex, maxlex)
int cxnum;
RkLex *lex;
int maxlex;
.ft 1
.fi
.SH "DESCRIPTION"
\f2RkGetLex\f1 gets morphemic information on each word that makes up the current candidate, and stores it in the array \f2lex\f1 in sequence from the left.  Right-side word information is truncated when the number of words exceeds \f2maxlex\f1.
.P
The fields of the structure \f2lex\f1 are loaded with the following:
.P
.RS
.IP "\f4ylen\f1" 12n
Byte length of the reading of a word
.IP "\f4klen\f1"
Byte length of the kanji of the word
.IP "\f4rownum\f1"
Row number of the word
.IP "\f4coldnum\f1"
Column number of the word
.IP "\f4dicnum\f1"
Not used
.RE
.SH "RETURN VALUE"
This function returns \f4-1\f1, without doing anything, if it has been run in a nonconversion mode context.
