/*

 Author: Tom Wickham-Jones WRI (twj@wri.com).
	
 A MathLink application to build images of the
 mandelbrot set. 

 The application is described in the book
 Mathematica Graphics: Techniques and Applications.
 Tom Wickham-Jones, TELOS/Springer-Verlag 1994.



 To build on Unix systems enter
 
 	mcc -o mandelbrot mandelbrot.tm

 to the shell.
 
  This presupposes an ANSI compiler called cc.

 If you have an ANSI compiler that is not called cc you
 must edit the mcc script and make the necessary change.
 (Future versions of mcc will do this with a variable).
 
 If you do not have an ANSI compiler then you must compile
 it without prototypes:
 
	mcc -o mandelbrot -DNOPROTO mandelbrot.tm


  To build this on the Macintosh or Windows consult your MathLink
  documentation.   There are Macintosh and Windows binaries
  available.
  
*/


:Begin:
:Function:       sendimage
:Pattern:        ExtendGraphics`Mandelbrot`GetMandelbrot[
									{x0_Real, y0_Real},
									{x1_Real, y1_Real},
									n_Integer, fact_Real]
:Arguments:      {{x0,x1},{y0,y1},n,fact}
:ArgumentTypes:  {Manual}
:ReturnType:     Manual
:End:


#include <math.h>
#include "mathlink.h"
#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <stddef.h>


void sendimage()
{
	char * tmp, * res, str[16];
	int n, len, cnt;
	double *xlim, *ylim, x, y, xinc,
	       yinc, vx, vy, vox, fact;
	long ix, iy;
		   
    MLGetRealList( stdlink, &xlim, &ix);
    MLGetRealList( stdlink, &ylim, &iy);
    MLGetInteger( stdlink, &n);
    MLGetDouble( stdlink, &fact);

	len = (2*n+1)*(2*n+1) + 10;
	tmp = res = (char *) malloc( sizeof( char)*len);
	xinc = (xlim[1]-xlim[0])/(n-1);
	yinc = (ylim[1]-ylim[0])/(n-1);
	for ( y = ylim[0]; y < ylim[1] + yinc/2; y += yinc) {
		for ( x = xlim[0]; x < xlim[1] + xinc/2; x += xinc) {
			vx = vy = 0.;
			cnt = 0;
			while ( cnt++ < 255 && vx*vx + vy*vy < 10000.) {
				vox = vx;
				vx = vx*vx-vy*vy+x;
				vy = 2*vox*vy+y;
			}
			cnt = (int) ((double) (cnt-1) * fact);
			sprintf( str, "%2X", (cnt > 255? 255: cnt));
			if (str[0] == ' ')
				str[0] = '0';
			*tmp++ = str[0];
			*tmp++ = str[1];
		}
		*tmp++ = '\n';
	}	
	*tmp = '\0';
	MLPutString( stdlink, res);
	MLDisownRealList( stdlink, xlim, ix);
	MLDisownRealList( stdlink, ylim, iy);
	free( res);	
        return;
}

#if !WINDOWS_MATHLINK

int main(argc, argv)
        int argc; char* argv[];
{
        return MLMain(argc, argv);
}

#else

int PASCAL WinMain( HANDLE hinstCurrent, HANDLE hinstPrevious, LPSTR lpszCmdLine, int nCmdShow)
{
	char  buff[512];
	char FAR * argv[32];
	int argc;

	if( !MLInitializeIcon( hinstCurrent, nCmdShow)) return 1;
	argc = MLStringToArgv( lpszCmdLine, buff, argv, 32);
	return MLMain( argc, argv);
}
#endif
