/*
 * Copyright (c) 2002 Robert Collins.
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     A copy of the GNU General Public License can be found at
 *     http://www.gnu.org/
 *
 * Written by Robert Collins <robertc@hotmail.com>
 *
 */

#ifndef _PATH_H_
#define _PATH_H_

#include <string>

using namespace std;

class Path
{
public:
  Path ();
  Path (string const &aPath);
  Path (Path const &);
  Path& operator= (string const &);
  Path& operator= (Path const &);
  ~Path();
  Path operator + (Path const &rhs) const;

  string const &fullName() const {return _name;}
  string const &baseName() const {return _basename;}
  string const &dirName() const {return _dirname;}
  
private:
  void setToString (string const &);
  static void StripSlash (string &aString);
  string _name;
  string _basename;
  string _dirname;
};

#endif // _PATH_H_
