#include "dispatcher"

void Dispatcher::start_dispatcher() {
    // Instantiate dispatchmode algorithm
    switch (config.dispatchmode()) {
    case Dispatchmode::m_roundrobin:
	algo = new Roundrobin;
	break;
    case Dispatchmode::m_firstactive:
	algo = new Firstactive;
	break;
    case Dispatchmode::m_external:
	algo = new External;
	break;
    case Dispatchmode::m_strict_hashed_ip:
    case Dispatchmode::m_lax_hashed_ip:
	algo = new HashedIp;
	break;
    case Dispatchmode::m_strict_stored_ip:
    case Dispatchmode::m_lax_stored_ip:
	algo = new StoredIp;
	break;
    case Dispatchmode::m_weighted_load:
	algo = new Weightedload;
	break;
    case Dispatchmode::m_leastconn:
    default:
	algo = new Leastconn;
	break;
    }

    // NOTE: Memory errors for algorithm pointer are not handled here,
    // but in dispatch() (don't want to throw up in the constructor)

    debugmsg("Dispatcher instantiated.\n");
}
    
