using System;
using System.Configuration;
using System.Web;
using System.Reflection;
using Db4objects.Db4o;
using Db4objects.Db4o.Config;

namespace Db4objects.Db4odoc.Web.Data
{

    public class Db4oHttpModule : IHttpModule
    {
        internal static readonly string KEY_DB4O_FILE_NAME = "db4oFileName";
        internal static readonly string KEY_DB4O_CLIENT = "db4oClient";
        private static IObjectServer objectServer = null;

        public void Init(HttpApplication application)
        {
            ConfigureAlias();
            application.EndRequest += new EventHandler(Application_EndRequest);
        }
        // end Init

        public void ConfigureAlias()
        {
            Assembly assembly = Assembly.GetExecutingAssembly();
            String assemblyName = "Db4objects.Db4odoc.Web.Data.*, " + assembly.GetName().ToString().Substring(0, assembly.GetName().ToString().LastIndexOf("Version") - 2);
            Db4oFactory.Configure().AddAlias(new WildcardAlias("Db4objects.Db4odoc.Web.Data.*, WebSite", assemblyName));
        }
        // end ConfigureAlias

        public static IObjectContainer Client
        {
            get
            {
                HttpContext context = HttpContext.Current;

                IObjectContainer objectClient = context.Items[KEY_DB4O_CLIENT] as IObjectContainer;

                if (objectClient == null)
                {
                    objectClient = Server.OpenClient();
                    context.Items[KEY_DB4O_CLIENT] = objectClient;
                }

                return objectClient;
            }
        }
        // end Client

        private static IObjectServer Server
        {
            get
            {
                HttpContext context = HttpContext.Current;

                if (objectServer == null)
                {
                    string yapFilePath = context.Server.MapPath(ConfigurationSettings.AppSettings[KEY_DB4O_FILE_NAME]);

                    objectServer = Db4oFactory.OpenServer(yapFilePath, 0);
                }

                return objectServer;
            }
        }
        // end Server

        public static string HashCodes
        {
            get { return "Server: " + Server.GetHashCode().ToString() + " Client: " + Client.GetHashCode(); }
        }
        // end HashCodes


        private void Application_EndRequest(object sender, EventArgs e)
        {
            HttpApplication application = (HttpApplication)sender;
            HttpContext context = application.Context;


            IObjectContainer objectClient = context.Items[KEY_DB4O_CLIENT] as IObjectContainer;

            if (objectClient != null)
            {
                objectClient.Close();
            }

            objectClient = null;
            context.Items[KEY_DB4O_CLIENT] = null;
        }
        // end Application_EndRequest

        public void Dispose()
        {
            if (objectServer != null)
            {
                objectServer.Close();
            }

            objectServer = null;
        }
        // end Dispose
    }
}

