/*!

\if MANPAGES
\page dcod2lum Convert hardcopy characteristic curve file to softcopy format
\else
\page dcod2lum dcod2lum: Convert hardcopy characteristic curve file to softcopy format
\endif

\section synopsis SYNOPSIS

\verbatim
dcod2lum in-file out-file
\endverbatim

\section description DESCRIPTION

Command line program that converts a hardcopy characteristic curve file to
softcopy format.  In other words, the measured optical density (OD) values
from the input file are transformed to the luminance space according to the
formula:

\verbatim
  L = La + L0 * 10^(-D)
\endverbatim

where \e L is the resulting luminance, \e La is the reflected ambient light
and \e L0 the illumination (both measured in cd/m^2), 'D' the optical density
(OD).  Please note that if no illumination value is specified in the input
file (keyword \e lum) all optical density values are mapped to a constant
luminance.

\section parameters PARAMETERS

\verbatim
in-file   hardcopy characteristic curve file to be converted

out-file  softcopy characteristic curve file to be written
\endverbatim

\section notes NOTES

The format of both input and output file is described the documentation of the
\b dcmdspfn command line tool.  In addition, the \e data folder contains
sample characteristics file monitors, cameras, printers and scanners.

\section files FILES

<em>\<datadir\>/camera.lut</em> - sample characteristics file of a camera
\n<em>\<datadir\>/monitor.lut</em> - sample characteristics file of a monitor
\n<em>\<datadir\>/printer.lut</em> - sample characteristics file of a printer
\n<em>\<datadir\>/scanner.lut</em> - sample characteristics file of a scanner

\section see_also SEE ALSO

<b>dcmdspfn</b>(1)

\section copyright COPYRIGHT

Copyright (C) 2002-2014 by OFFIS e.V., Escherweg 2, 26121 Oldenburg, Germany.

*/
