/*
* Copyright (C) 2019 ~ 2020 Uniontech Software Technology Co.,Ltd.
*
* Author:     leilong  <leilong@uniontech.com>
*
* Maintainer: leilong  <leilong@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "test_colorseletorwidget.h"
#include "../third-party_stub/stub.h"

static int colorseletorwidget_stub_true()
{
    return 1;
}

test_colorseletorwidget::test_colorseletorwidget(QObject *parent) : QObject(parent)
{

}

TEST_F(test_colorseletorwidget, reset_001)
{
    mWidget->reset();
    EXPECT_TRUE(mWidget->m_colorEntityMap.isEmpty());
}

TEST_F(test_colorseletorwidget, getSelectedColorInfo_001)
{
    JobTypeColorInfo info(0, "#123456", 1);
    mWidget->m_colorInfo = info;
    EXPECT_TRUE(mWidget->getSelectedColorInfo() == info);
}

TEST_F(test_colorseletorwidget, setUserColor_001)
{
    JobTypeColorInfo info(0, "#123456", ColorSeletorWidget::TypeSystem);
    mWidget->setUserColor(info);
    EXPECT_TRUE(mWidget->m_userColorBtn == nullptr);
}

TEST_F(test_colorseletorwidget, setUserColor_002)
{
    JobTypeColorInfo info(0, "#123456", ColorSeletorWidget::TypeUser);
    mWidget->setUserColor(info);
    EXPECT_TRUE(mWidget->m_userColorBtn != nullptr);
}

TEST_F(test_colorseletorwidget, setSelectedColorByIndex_001)
{
    mWidget->reset();
    JobTypeColorInfo info(0, "#123456", ColorSeletorWidget::TypeUser);
    mWidget->setUserColor(info);
    mWidget->setSelectedColorByIndex(0);
    EXPECT_TRUE(mWidget->m_userColorBtn->isChecked());
}

TEST_F(test_colorseletorwidget, setSelectedColorById_001)
{
    mWidget->reset();
    mWidget->addColor(JobTypeColorInfo(1, "#123456", ColorSeletorWidget::TypeSystem));
    mWidget->addColor(JobTypeColorInfo(2, "#111111", ColorSeletorWidget::TypeSystem));
    mWidget->addColor(JobTypeColorInfo(3, "#222222", ColorSeletorWidget::TypeSystem));
    mWidget->addColor(JobTypeColorInfo(4, "#333333", ColorSeletorWidget::TypeSystem));
    mWidget->addColor(JobTypeColorInfo(0, "#444444", ColorSeletorWidget::TypeUser));
    mWidget->setSelectedColorById(0);
    EXPECT_TRUE(mWidget->m_userColorBtn->isChecked()) << "0";
    mWidget->setSelectedColorById(3);
    EXPECT_FALSE(mWidget->m_userColorBtn->isChecked()) << "3";
}

TEST_F(test_colorseletorwidget, setSelectedColor_001)
{
    mWidget->reset();
    mWidget->addColor(JobTypeColorInfo(1, "#123456", ColorSeletorWidget::TypeSystem));
    mWidget->addColor(JobTypeColorInfo(2, "#111111", ColorSeletorWidget::TypeSystem));
    mWidget->addColor(JobTypeColorInfo(3, "#222222", ColorSeletorWidget::TypeSystem));
    mWidget->addColor(JobTypeColorInfo(4, "#333333", ColorSeletorWidget::TypeSystem));
    mWidget->addColor(JobTypeColorInfo(0, "#444444", ColorSeletorWidget::TypeUser));
    mWidget->setSelectedColor(JobTypeColorInfo(0, "#444444", ColorSeletorWidget::TypeUser));
    EXPECT_TRUE(mWidget->m_userColorBtn->isChecked()) << "1";
    mWidget->setSelectedColor((JobTypeColorInfo(4, "#333333", ColorSeletorWidget::TypeSystem)));
    EXPECT_FALSE(mWidget->m_userColorBtn->isChecked()) << "2";
    mWidget->setSelectedColor((JobTypeColorInfo(4, "#555555", ColorSeletorWidget::TypeSystem)));
    EXPECT_TRUE(mWidget->m_userColorBtn->isChecked()) << "3";
}

TEST_F(test_colorseletorwidget, initColorButton_001)
{
    mWidget->initColorButton();
}

TEST_F(test_colorseletorwidget, slotButtonClicked_001)
{
    mWidget->reset();
    mWidget->addColor(JobTypeColorInfo(1, "#123456", ColorSeletorWidget::TypeSystem));
    mWidget->addColor(JobTypeColorInfo(2, "#111111", ColorSeletorWidget::TypeSystem));
    mWidget->addColor(JobTypeColorInfo(3, "#222222", ColorSeletorWidget::TypeSystem));
    mWidget->addColor(JobTypeColorInfo(4, "#333333", ColorSeletorWidget::TypeSystem));
    mWidget->addColor(JobTypeColorInfo(0, "#444444", ColorSeletorWidget::TypeUser));
    mWidget->slotButtonClicked(1);
    mWidget->slotButtonClicked(6);
}

TEST_F(test_colorseletorwidget, slotAddColorButClicked_001)
{
    typedef int (*fptr)();
    fptr A_foo = (fptr)(&QDialog::exec);
    Stub stub;
    stub.set(A_foo, colorseletorwidget_stub_true);

    mWidget->slotAddColorButClicked();
    EXPECT_TRUE(mWidget->m_userColorBtn->isChecked());
}

TEST_F(test_colorseletorwidget, init_001)
{
    mWidget->init();
}

TEST_F(test_colorseletorwidget, initView_001)
{
    mWidget->initView();
}

TEST_F(test_colorseletorwidget, addColor_001)
{
    mWidget->reset();
    mWidget->addColor(JobTypeColorInfo(0, "", 1));
    EXPECT_EQ(mWidget->m_colorEntityMap.size(), 1);
}

TEST_F(test_colorseletorwidget, addColor_002)
{
    mWidget->reset();
    mWidget->addColor(JobTypeColorInfo(0, "", ColorSeletorWidget::TypeUser));
    EXPECT_EQ(mWidget->m_colorEntityMap.size(), 1) << "eq";
    EXPECT_NE(mWidget->m_userColorBtn, nullptr) << "ne";
}
