!     FORTRAN BLAS INTERFACE ..
!     COPYRIGHT 2013 HENRIK HOLST <HOLST@MATMECH.COM>
!
!     YOU ARE FREE TO USE THIS IN ANY FSF APPROVED FREE LICENCED PROJECT.
!
      MODULE BLAS95_m
      INTERFACE
      SUBROUTINE CAXPY(N,CA,CX,INCX,CY,INCY)
      IMPLICIT NONE
      INTEGER INCX,INCY,N
      COMPLEX CA,CX(*),CY(*)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CCOPY(N,CX,INCX,CY,INCY)
      IMPLICIT NONE
      INTEGER INCX,INCY,N
      COMPLEX CX(*),CY(*)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      COMPLEX FUNCTION CDOTC(N,CX,INCX,CY,INCY)
      IMPLICIT NONE
      INTEGER INCX,INCY,N
      COMPLEX CX(*),CY(*)
      END FUNCTION
      END INTERFACE
      INTERFACE
      COMPLEX FUNCTION CDOTU(N,CX,INCX,CY,INCY)
      IMPLICIT NONE
      INTEGER INCX,INCY,N
      COMPLEX CX(*),CY(*)
      END FUNCTION
      END INTERFACE
      INTERFACE
      SUBROUTINE CGBMV(TRANS,M,N,KL,KU,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
      IMPLICIT NONE
      INTEGER INCX,INCY,KL,KU,LDA,M,N
      COMPLEX ALPHA,BETA,A(LDA,*),X(*),Y(*)
      CHARACTER TRANS
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CGEMM(TRANSA,TRANSB,M,N,K,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
      IMPLICIT NONE
      INTEGER K,LDA,LDB,LDC,M,N
      COMPLEX ALPHA,BETA,A(LDA,*),B(LDB,*),C(LDC,*)
      CHARACTER TRANSA,TRANSB
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CGEMV(TRANS,M,N,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
      IMPLICIT NONE
      INTEGER INCX,INCY,LDA,M,N
      COMPLEX ALPHA,BETA,A(LDA,*),X(*),Y(*)
      CHARACTER TRANS
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CGERC(M,N,ALPHA,X,INCX,Y,INCY,A,LDA)
      IMPLICIT NONE
      INTEGER INCX,INCY,LDA,M,N
      COMPLEX ALPHA,A(LDA,*),X(*),Y(*)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CGERU(M,N,ALPHA,X,INCX,Y,INCY,A,LDA)
      IMPLICIT NONE
      INTEGER INCX,INCY,LDA,M,N
      COMPLEX ALPHA,A(LDA,*),X(*),Y(*)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CHBMV(UPLO,N,K,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
      IMPLICIT NONE
      INTEGER INCX,INCY,K,LDA,N
      COMPLEX ALPHA,BETA,A(LDA,*),X(*),Y(*)
      CHARACTER UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CHEMM(SIDE,UPLO,M,N,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
      IMPLICIT NONE
      INTEGER LDA,LDB,LDC,M,N
      COMPLEX ALPHA,BETA,A(LDA,*),B(LDB,*),C(LDC,*)
      CHARACTER SIDE,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CHEMV(UPLO,N,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
      IMPLICIT NONE
      INTEGER INCX,INCY,LDA,N
      COMPLEX ALPHA,BETA,A(LDA,*),X(*),Y(*)
      CHARACTER UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CHER(UPLO,N,ALPHA,X,INCX,A,LDA)
      IMPLICIT NONE
      REAL ALPHA
      INTEGER INCX,LDA,N
      COMPLEX A(LDA,*),X(*)
      CHARACTER UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CHER2(UPLO,N,ALPHA,X,INCX,Y,INCY,A,LDA)
      IMPLICIT NONE
      INTEGER INCX,INCY,LDA,N
      COMPLEX ALPHA,A(LDA,*),X(*),Y(*)
      CHARACTER UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CHER2K(UPLO,TRANS,N,K,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
      IMPLICIT NONE
      REAL BETA
      INTEGER K,LDA,LDB,LDC,N
      COMPLEX ALPHA,A(LDA,*),B(LDB,*),C(LDC,*)
      CHARACTER TRANS,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CHERK(UPLO,TRANS,N,K,ALPHA,A,LDA,BETA,C,LDC)
      IMPLICIT NONE
      REAL ALPHA,BETA
      INTEGER K,LDA,LDC,N
      COMPLEX A(LDA,*),C(LDC,*)
      CHARACTER TRANS,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CHPMV(UPLO,N,ALPHA,AP,X,INCX,BETA,Y,INCY)
      IMPLICIT NONE
      INTEGER INCX,INCY,N
      COMPLEX ALPHA,BETA,AP(*),X(*),Y(*)
      CHARACTER UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CHPR(UPLO,N,ALPHA,X,INCX,AP)
      IMPLICIT NONE
      REAL ALPHA
      INTEGER INCX,N
      COMPLEX AP(*),X(*)
      CHARACTER UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CHPR2(UPLO,N,ALPHA,X,INCX,Y,INCY,AP)
      IMPLICIT NONE
      INTEGER INCX,INCY,N
      COMPLEX ALPHA,AP(*),X(*),Y(*)
      CHARACTER UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CROTG(CA,CB,C,S)
      IMPLICIT NONE
      REAL C
      COMPLEX CA,CB,S
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CSCAL(N,CA,CX,INCX)
      IMPLICIT NONE
      INTEGER INCX,N
      COMPLEX CA,CX(*)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CSROT(N,CX,INCX,CY,INCY,C,S)
      IMPLICIT NONE
      REAL C,S
      INTEGER INCX,INCY,N
      COMPLEX CX(*),CY(*)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CSSCAL(N,SA,CX,INCX)
      IMPLICIT NONE
      REAL SA
      INTEGER INCX,N
      COMPLEX CX(*)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CSWAP(N,CX,INCX,CY,INCY)
      IMPLICIT NONE
      INTEGER INCX,INCY,N
      COMPLEX CX(*),CY(*)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CSYMM(SIDE,UPLO,M,N,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
      IMPLICIT NONE
      INTEGER LDA,LDB,LDC,M,N
      COMPLEX ALPHA,BETA,A(LDA,*),B(LDB,*),C(LDC,*)
      CHARACTER SIDE,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CSYR2K(UPLO,TRANS,N,K,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
      IMPLICIT NONE
      INTEGER K,LDA,LDB,LDC,N
      COMPLEX ALPHA,BETA,A(LDA,*),B(LDB,*),C(LDC,*)
      CHARACTER TRANS,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CSYRK(UPLO,TRANS,N,K,ALPHA,A,LDA,BETA,C,LDC)
      IMPLICIT NONE
      INTEGER K,LDA,LDC,N
      COMPLEX ALPHA,BETA,A(LDA,*),C(LDC,*)
      CHARACTER TRANS,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CTBMV(UPLO,TRANS,DIAG,N,K,A,LDA,X,INCX)
      IMPLICIT NONE
      INTEGER INCX,K,LDA,N
      COMPLEX A(LDA,*),X(*)
      CHARACTER DIAG,TRANS,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CTBSV(UPLO,TRANS,DIAG,N,K,A,LDA,X,INCX)
      IMPLICIT NONE
      INTEGER INCX,K,LDA,N
      COMPLEX A(LDA,*),X(*)
      CHARACTER DIAG,TRANS,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CTPMV(UPLO,TRANS,DIAG,N,AP,X,INCX)
      IMPLICIT NONE
      INTEGER INCX,N
      COMPLEX AP(*),X(*)
      CHARACTER DIAG,TRANS,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CTPSV(UPLO,TRANS,DIAG,N,AP,X,INCX)
      IMPLICIT NONE
      INTEGER INCX,N
      COMPLEX AP(*),X(*)
      CHARACTER DIAG,TRANS,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CTRMM(SIDE,UPLO,TRANSA,DIAG,M,N,ALPHA,A,LDA,B,LDB)
      IMPLICIT NONE
      INTEGER LDA,LDB,M,N
      COMPLEX ALPHA,A(LDA,*),B(LDB,*)
      CHARACTER DIAG,SIDE,TRANSA,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CTRMV(UPLO,TRANS,DIAG,N,A,LDA,X,INCX)
      IMPLICIT NONE
      INTEGER INCX,LDA,N
      COMPLEX A(LDA,*),X(*)
      CHARACTER DIAG,TRANS,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CTRSM(SIDE,UPLO,TRANSA,DIAG,M,N,ALPHA,A,LDA,B,LDB)
      IMPLICIT NONE
      INTEGER LDA,LDB,M,N
      COMPLEX ALPHA,A(LDA,*),B(LDB,*)
      CHARACTER DIAG,SIDE,TRANSA,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE CTRSV(UPLO,TRANS,DIAG,N,A,LDA,X,INCX)
      IMPLICIT NONE
      INTEGER INCX,LDA,N
      COMPLEX A(LDA,*),X(*)
      CHARACTER DIAG,TRANS,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      DOUBLE PRECISION FUNCTION DASUM(N,DX,INCX)
      IMPLICIT NONE
      INTEGER INCX,N
      DOUBLE PRECISION DX(*)
      END FUNCTION
      END INTERFACE
      INTERFACE
      SUBROUTINE DAXPY(N,DA,DX,INCX,DY,INCY)
      IMPLICIT NONE
      INTEGER INCX,INCY,N
      DOUBLE PRECISION DA,DX(*),DY(*)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      DOUBLE PRECISION FUNCTION DCABS1(Z)
      IMPLICIT NONE
      DOUBLE COMPLEX Z
      END FUNCTION
      END INTERFACE
      INTERFACE
      SUBROUTINE DCOPY(N,DX,INCX,DY,INCY)
      IMPLICIT NONE
      INTEGER INCX,INCY,N
      DOUBLE PRECISION DX(*),DY(*)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      DOUBLE PRECISION FUNCTION DDOT(N,DX,INCX,DY,INCY)
      IMPLICIT NONE
      INTEGER INCX,INCY,N
      DOUBLE PRECISION DX(*),DY(*)
      END FUNCTION
      END INTERFACE
      INTERFACE
      SUBROUTINE DGBMV(TRANS,M,N,KL,KU,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
      IMPLICIT NONE
      INTEGER INCX,INCY,KL,KU,LDA,M,N
      DOUBLE PRECISION ALPHA,BETA,A(LDA,*),X(*),Y(*)
      CHARACTER TRANS
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE DGEMM(TRANSA,TRANSB,M,N,K,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
      IMPLICIT NONE
      INTEGER K,LDA,LDB,LDC,M,N
      DOUBLE PRECISION ALPHA,BETA,A(LDA,*),B(LDB,*),C(LDC,*)
      CHARACTER TRANSA,TRANSB
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE DGEMV(TRANS,M,N,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
      IMPLICIT NONE
      INTEGER INCX,INCY,LDA,M,N
      DOUBLE PRECISION ALPHA,BETA,A(LDA,*),X(*),Y(*)
      CHARACTER TRANS
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE DGER(M,N,ALPHA,X,INCX,Y,INCY,A,LDA)
      IMPLICIT NONE
      INTEGER INCX,INCY,LDA,M,N
      DOUBLE PRECISION ALPHA,A(LDA,*),X(*),Y(*)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      DOUBLE PRECISION FUNCTION DNRM2(N,X,INCX)
      IMPLICIT NONE
      INTEGER INCX,N
      DOUBLE PRECISION X(*)
      END FUNCTION
      END INTERFACE
      INTERFACE
      SUBROUTINE DROT(N,DX,INCX,DY,INCY,C,S)
      IMPLICIT NONE
      INTEGER INCX,INCY,N
      DOUBLE PRECISION C,S,DX(*),DY(*)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE DROTG(DA,DB,C,S)
      IMPLICIT NONE
      DOUBLE PRECISION C,DA,DB,S
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE DROTM(N,DX,INCX,DY,INCY,DPARAM)
      IMPLICIT NONE
      INTEGER INCX,INCY,N
      DOUBLE PRECISION DPARAM(5),DX(*),DY(*)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE DROTMG(DD1,DD2,DX1,DY1,DPARAM)
      IMPLICIT NONE
      DOUBLE PRECISION DD1,DD2,DX1,DY1,DPARAM(5)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE DSBMV(UPLO,N,K,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
      IMPLICIT NONE
      INTEGER INCX,INCY,K,LDA,N
      DOUBLE PRECISION ALPHA,BETA,A(LDA,*),X(*),Y(*)
      CHARACTER UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE DSCAL(N,DA,DX,INCX)
      IMPLICIT NONE
      INTEGER INCX,N
      DOUBLE PRECISION DA,DX(*)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      DOUBLE PRECISION FUNCTION DSDOT(N,SX,INCX,SY,INCY)
      IMPLICIT NONE
      REAL SX(*),SY(*)
      INTEGER INCX,INCY,N
      END FUNCTION
      END INTERFACE
      INTERFACE
      SUBROUTINE DSPMV(UPLO,N,ALPHA,AP,X,INCX,BETA,Y,INCY)
      IMPLICIT NONE
      INTEGER INCX,INCY,N
      DOUBLE PRECISION ALPHA,BETA,AP(*),X(*),Y(*)
      CHARACTER UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE DSPR(UPLO,N,ALPHA,X,INCX,AP)
      IMPLICIT NONE
      INTEGER INCX,N
      DOUBLE PRECISION ALPHA,AP(*),X(*)
      CHARACTER UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE DSPR2(UPLO,N,ALPHA,X,INCX,Y,INCY,AP)
      IMPLICIT NONE
      INTEGER INCX,INCY,N
      DOUBLE PRECISION ALPHA,AP(*),X(*),Y(*)
      CHARACTER UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE DSWAP(N,DX,INCX,DY,INCY)
      IMPLICIT NONE
      INTEGER INCX,INCY,N
      DOUBLE PRECISION DX(*),DY(*)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE DSYMM(SIDE,UPLO,M,N,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
      IMPLICIT NONE
      INTEGER LDA,LDB,LDC,M,N
      DOUBLE PRECISION ALPHA,BETA,A(LDA,*),B(LDB,*),C(LDC,*)
      CHARACTER SIDE,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE DSYMV(UPLO,N,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
      IMPLICIT NONE
      INTEGER INCX,INCY,LDA,N
      DOUBLE PRECISION ALPHA,BETA,A(LDA,*),X(*),Y(*)
      CHARACTER UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE DSYR(UPLO,N,ALPHA,X,INCX,A,LDA)
      IMPLICIT NONE
      INTEGER INCX,LDA,N
      DOUBLE PRECISION ALPHA,A(LDA,*),X(*)
      CHARACTER UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE DSYR2(UPLO,N,ALPHA,X,INCX,Y,INCY,A,LDA)
      IMPLICIT NONE
      INTEGER INCX,INCY,LDA,N
      DOUBLE PRECISION ALPHA,A(LDA,*),X(*),Y(*)
      CHARACTER UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE DSYR2K(UPLO,TRANS,N,K,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
      IMPLICIT NONE
      INTEGER K,LDA,LDB,LDC,N
      DOUBLE PRECISION ALPHA,BETA,A(LDA,*),B(LDB,*),C(LDC,*)
      CHARACTER TRANS,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE DSYRK(UPLO,TRANS,N,K,ALPHA,A,LDA,BETA,C,LDC)
      IMPLICIT NONE
      INTEGER K,LDA,LDC,N
      DOUBLE PRECISION ALPHA,BETA,A(LDA,*),C(LDC,*)
      CHARACTER TRANS,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE DTBMV(UPLO,TRANS,DIAG,N,K,A,LDA,X,INCX)
      IMPLICIT NONE
      INTEGER INCX,K,LDA,N
      DOUBLE PRECISION A(LDA,*),X(*)
      CHARACTER DIAG,TRANS,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE DTBSV(UPLO,TRANS,DIAG,N,K,A,LDA,X,INCX)
      IMPLICIT NONE
      INTEGER INCX,K,LDA,N
      DOUBLE PRECISION A(LDA,*),X(*)
      CHARACTER DIAG,TRANS,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE DTPMV(UPLO,TRANS,DIAG,N,AP,X,INCX)
      IMPLICIT NONE
      INTEGER INCX,N
      DOUBLE PRECISION AP(*),X(*)
      CHARACTER DIAG,TRANS,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE DTPSV(UPLO,TRANS,DIAG,N,AP,X,INCX)
      IMPLICIT NONE
      INTEGER INCX,N
      DOUBLE PRECISION AP(*),X(*)
      CHARACTER DIAG,TRANS,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE DTRMM(SIDE,UPLO,TRANSA,DIAG,M,N,ALPHA,A,LDA,B,LDB)
      IMPLICIT NONE
      INTEGER LDA,LDB,M,N
      DOUBLE PRECISION ALPHA,A(LDA,*),B(LDB,*)
      CHARACTER DIAG,SIDE,TRANSA,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE DTRMV(UPLO,TRANS,DIAG,N,A,LDA,X,INCX)
      IMPLICIT NONE
      INTEGER INCX,LDA,N
      DOUBLE PRECISION A(LDA,*),X(*)
      CHARACTER DIAG,TRANS,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE DTRSM(SIDE,UPLO,TRANSA,DIAG,M,N,ALPHA,A,LDA,B,LDB)
      IMPLICIT NONE
      INTEGER LDA,LDB,M,N
      DOUBLE PRECISION ALPHA,A(LDA,*),B(LDB,*)
      CHARACTER DIAG,SIDE,TRANSA,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE DTRSV(UPLO,TRANS,DIAG,N,A,LDA,X,INCX)
      IMPLICIT NONE
      INTEGER INCX,LDA,N
      DOUBLE PRECISION A(LDA,*),X(*)
      CHARACTER DIAG,TRANS,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      DOUBLE PRECISION FUNCTION DZASUM(N,ZX,INCX)
      IMPLICIT NONE
      INTEGER INCX,N
      DOUBLE COMPLEX ZX(*)
      END FUNCTION
      END INTERFACE
      INTERFACE
      DOUBLE PRECISION FUNCTION DZNRM2(N,X,INCX)
      IMPLICIT NONE
      INTEGER INCX,N
      DOUBLE COMPLEX X(*)
      END FUNCTION
      END INTERFACE
      INTERFACE
      INTEGER FUNCTION ICAMAX(N,CX,INCX)
      IMPLICIT NONE
      INTEGER INCX,N
      COMPLEX CX(*)
      END FUNCTION
      END INTERFACE
      INTERFACE
      INTEGER FUNCTION IDAMAX(N,DX,INCX)
      IMPLICIT NONE
      INTEGER INCX,N
      DOUBLE PRECISION DX(*)
      END FUNCTION
      END INTERFACE
      INTERFACE
      INTEGER FUNCTION ISAMAX(N,SX,INCX)
      IMPLICIT NONE
      REAL SX(*)
      INTEGER INCX,N
      END FUNCTION
      END INTERFACE
      INTERFACE
      INTEGER FUNCTION IZAMAX(N,ZX,INCX)
      IMPLICIT NONE
      INTEGER INCX,N
      DOUBLE COMPLEX ZX(*)
      END FUNCTION
      END INTERFACE
      INTERFACE
      LOGICAL FUNCTION LSAME(CA,CB)
      IMPLICIT NONE
      CHARACTER CA,CB
      END FUNCTION
      END INTERFACE
      INTERFACE
      REAL FUNCTION SASUM(N,SX,INCX)
      IMPLICIT NONE
      REAL SX(*)
      INTEGER INCX,N
      END FUNCTION
      END INTERFACE
      INTERFACE
      SUBROUTINE SAXPY(N,SA,SX,INCX,SY,INCY)
      IMPLICIT NONE
      REAL SA,SX(*),SY(*)
      INTEGER INCX,INCY,N
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      REAL FUNCTION SCABS1(Z)
      IMPLICIT NONE
      COMPLEX Z
      END FUNCTION
      END INTERFACE
      INTERFACE
      REAL FUNCTION SCASUM(N,CX,INCX)
      IMPLICIT NONE
      INTEGER INCX,N
      COMPLEX CX(*)
      END FUNCTION
      END INTERFACE
      INTERFACE
      REAL FUNCTION SCNRM2(N,X,INCX)
      IMPLICIT NONE
      INTEGER INCX,N
      COMPLEX X(*)
      END FUNCTION
      END INTERFACE
      INTERFACE
      SUBROUTINE SCOPY(N,SX,INCX,SY,INCY)
      IMPLICIT NONE
      REAL SX(*),SY(*)
      INTEGER INCX,INCY,N
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      REAL FUNCTION SDOT(N,SX,INCX,SY,INCY)
      IMPLICIT NONE
      REAL SX(*),SY(*)
      INTEGER INCX,INCY,N
      END FUNCTION
      END INTERFACE
      INTERFACE
      REAL FUNCTION SDSDOT(N,SB,SX,INCX,SY,INCY)
      IMPLICIT NONE
      REAL SB,SX(*),SY(*)
      INTEGER INCX,INCY,N
      END FUNCTION
      END INTERFACE
      INTERFACE
      SUBROUTINE SGBMV(TRANS,M,N,KL,KU,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
      IMPLICIT NONE
      REAL ALPHA,BETA,A(LDA,*),X(*),Y(*)
      INTEGER INCX,INCY,KL,KU,LDA,M,N
      CHARACTER TRANS
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE SGEMM(TRANSA,TRANSB,M,N,K,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
      IMPLICIT NONE
      REAL ALPHA,BETA,A(LDA,*),B(LDB,*),C(LDC,*)
      INTEGER K,LDA,LDB,LDC,M,N
      CHARACTER TRANSA,TRANSB
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE SGEMV(TRANS,M,N,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
      IMPLICIT NONE
      REAL ALPHA,BETA,A(LDA,*),X(*),Y(*)
      INTEGER INCX,INCY,LDA,M,N
      CHARACTER TRANS
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE SGER(M,N,ALPHA,X,INCX,Y,INCY,A,LDA)
      IMPLICIT NONE
      REAL ALPHA,A(LDA,*),X(*),Y(*)
      INTEGER INCX,INCY,LDA,M,N
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      REAL FUNCTION SNRM2(N,X,INCX)
      IMPLICIT NONE
      REAL X(*)
      INTEGER INCX,N
      END FUNCTION
      END INTERFACE
      INTERFACE
      SUBROUTINE SROT(N,SX,INCX,SY,INCY,C,S)
      IMPLICIT NONE
      REAL C,S,SX(*),SY(*)
      INTEGER INCX,INCY,N
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE SROTG(SA,SB,C,S)
      IMPLICIT NONE
      REAL C,S,SA,SB
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE SROTM(N,SX,INCX,SY,INCY,SPARAM)
      IMPLICIT NONE
      REAL SPARAM(5),SX(*),SY(*)
      INTEGER INCX,INCY,N
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE SROTMG(SD1,SD2,SX1,SY1,SPARAM)
      IMPLICIT NONE
      REAL SD1,SD2,SX1,SY1,SPARAM(5)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE SSBMV(UPLO,N,K,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
      IMPLICIT NONE
      REAL ALPHA,BETA,A(LDA,*),X(*),Y(*)
      INTEGER INCX,INCY,K,LDA,N
      CHARACTER UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE SSCAL(N,SA,SX,INCX)
      IMPLICIT NONE
      REAL SA,SX(*)
      INTEGER INCX,N
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE SSPMV(UPLO,N,ALPHA,AP,X,INCX,BETA,Y,INCY)
      IMPLICIT NONE
      REAL ALPHA,BETA,AP(*),X(*),Y(*)
      INTEGER INCX,INCY,N
      CHARACTER UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE SSPR(UPLO,N,ALPHA,X,INCX,AP)
      IMPLICIT NONE
      REAL ALPHA,AP(*),X(*)
      INTEGER INCX,N
      CHARACTER UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE SSPR2(UPLO,N,ALPHA,X,INCX,Y,INCY,AP)
      IMPLICIT NONE
      REAL ALPHA,AP(*),X(*),Y(*)
      INTEGER INCX,INCY,N
      CHARACTER UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE SSWAP(N,SX,INCX,SY,INCY)
      IMPLICIT NONE
      REAL SX(*),SY(*)
      INTEGER INCX,INCY,N
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE SSYMM(SIDE,UPLO,M,N,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
      IMPLICIT NONE
      REAL ALPHA,BETA,A(LDA,*),B(LDB,*),C(LDC,*)
      INTEGER LDA,LDB,LDC,M,N
      CHARACTER SIDE,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE SSYMV(UPLO,N,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
      IMPLICIT NONE
      REAL ALPHA,BETA,A(LDA,*),X(*),Y(*)
      INTEGER INCX,INCY,LDA,N
      CHARACTER UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE SSYR(UPLO,N,ALPHA,X,INCX,A,LDA)
      IMPLICIT NONE
      REAL ALPHA,A(LDA,*),X(*)
      INTEGER INCX,LDA,N
      CHARACTER UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE SSYR2(UPLO,N,ALPHA,X,INCX,Y,INCY,A,LDA)
      IMPLICIT NONE
      REAL ALPHA,A(LDA,*),X(*),Y(*)
      INTEGER INCX,INCY,LDA,N
      CHARACTER UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE SSYR2K(UPLO,TRANS,N,K,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
      IMPLICIT NONE
      REAL ALPHA,BETA,A(LDA,*),B(LDB,*),C(LDC,*)
      INTEGER K,LDA,LDB,LDC,N
      CHARACTER TRANS,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE SSYRK(UPLO,TRANS,N,K,ALPHA,A,LDA,BETA,C,LDC)
      IMPLICIT NONE
      REAL ALPHA,BETA,A(LDA,*),C(LDC,*)
      INTEGER K,LDA,LDC,N
      CHARACTER TRANS,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE STBMV(UPLO,TRANS,DIAG,N,K,A,LDA,X,INCX)
      IMPLICIT NONE
      REAL A(LDA,*),X(*)
      INTEGER INCX,K,LDA,N
      CHARACTER DIAG,TRANS,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE STBSV(UPLO,TRANS,DIAG,N,K,A,LDA,X,INCX)
      IMPLICIT NONE
      REAL A(LDA,*),X(*)
      INTEGER INCX,K,LDA,N
      CHARACTER DIAG,TRANS,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE STPMV(UPLO,TRANS,DIAG,N,AP,X,INCX)
      IMPLICIT NONE
      REAL AP(*),X(*)
      INTEGER INCX,N
      CHARACTER DIAG,TRANS,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE STPSV(UPLO,TRANS,DIAG,N,AP,X,INCX)
      IMPLICIT NONE
      REAL AP(*),X(*)
      INTEGER INCX,N
      CHARACTER DIAG,TRANS,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE STRMM(SIDE,UPLO,TRANSA,DIAG,M,N,ALPHA,A,LDA,B,LDB)
      IMPLICIT NONE
      REAL ALPHA,A(LDA,*),B(LDB,*)
      INTEGER LDA,LDB,M,N
      CHARACTER DIAG,SIDE,TRANSA,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE STRMV(UPLO,TRANS,DIAG,N,A,LDA,X,INCX)
      IMPLICIT NONE
      REAL A(LDA,*),X(*)
      INTEGER INCX,LDA,N
      CHARACTER DIAG,TRANS,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE STRSM(SIDE,UPLO,TRANSA,DIAG,M,N,ALPHA,A,LDA,B,LDB)
      IMPLICIT NONE
      REAL ALPHA,A(LDA,*),B(LDB,*)
      INTEGER LDA,LDB,M,N
      CHARACTER DIAG,SIDE,TRANSA,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE STRSV(UPLO,TRANS,DIAG,N,A,LDA,X,INCX)
      IMPLICIT NONE
      REAL A(LDA,*),X(*)
      INTEGER INCX,LDA,N
      CHARACTER DIAG,TRANS,UPLO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE XERBLA(SRNAME,INFO)
      IMPLICIT NONE
      CHARACTER*(*) SRNAME
      INTEGER INFO
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZAXPY(N,ZA,ZX,INCX,ZY,INCY)
      IMPLICIT NONE
      DOUBLE COMPLEX ZA,ZX(*),ZY(*)
      INTEGER INCX,INCY,N
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZCOPY(N,ZX,INCX,ZY,INCY)
      IMPLICIT NONE
      INTEGER INCX,INCY,N
      DOUBLE COMPLEX ZX(*),ZY(*)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      DOUBLE COMPLEX FUNCTION ZDOTC(N,ZX,INCX,ZY,INCY)
      IMPLICIT NONE
      INTEGER INCX,INCY,N
      DOUBLE COMPLEX ZX(*),ZY(*)
      END FUNCTION
      END INTERFACE
      INTERFACE
      DOUBLE COMPLEX FUNCTION ZDOTU(N,ZX,INCX,ZY,INCY)
      IMPLICIT NONE
      INTEGER INCX,INCY,N
      DOUBLE COMPLEX ZX(*),ZY(*)
      END FUNCTION
      END INTERFACE
      INTERFACE
      SUBROUTINE ZDROT(N,CX,INCX,CY,INCY,C,S)
      IMPLICIT NONE
      INTEGER INCX,INCY,N
      DOUBLE PRECISION C,S
      COMPLEX*16 CX(*),CY(*)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZDSCAL(N,DA,ZX,INCX)
      IMPLICIT NONE
      INTEGER INCX,N
      DOUBLE PRECISION DA
      DOUBLE COMPLEX ZX(*)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZGBMV(TRANS,M,N,KL,KU,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
      IMPLICIT NONE
      DOUBLE COMPLEX ALPHA,BETA,A(LDA,*),X(*),Y(*)
      CHARACTER TRANS
      INTEGER INCX,INCY,KL,KU,LDA,M,N
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZGEMM(TRANSA,TRANSB,M,N,K,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
      IMPLICIT NONE
      DOUBLE COMPLEX ALPHA,BETA,A(LDA,*),B(LDB,*),C(LDC,*)
      CHARACTER TRANSA,TRANSB
      INTEGER K,LDA,LDB,LDC,M,N
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZGEMV(TRANS,M,N,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
      IMPLICIT NONE
      DOUBLE COMPLEX ALPHA,BETA,A(LDA,*),X(*),Y(*)
      CHARACTER TRANS
      INTEGER INCX,INCY,LDA,M,N
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZGERC(M,N,ALPHA,X,INCX,Y,INCY,A,LDA)
      IMPLICIT NONE
      DOUBLE COMPLEX ALPHA,A(LDA,*),X(*),Y(*)
      INTEGER INCX,INCY,LDA,M,N
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZGERU(M,N,ALPHA,X,INCX,Y,INCY,A,LDA)
      IMPLICIT NONE
      DOUBLE COMPLEX ALPHA,A(LDA,*),X(*),Y(*)
      INTEGER INCX,INCY,LDA,M,N
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZHBMV(UPLO,N,K,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
      IMPLICIT NONE
      DOUBLE COMPLEX ALPHA,BETA,A(LDA,*),X(*),Y(*)
      CHARACTER UPLO
      INTEGER INCX,INCY,K,LDA,N
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZHEMM(SIDE,UPLO,M,N,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
      IMPLICIT NONE
      DOUBLE COMPLEX ALPHA,BETA,A(LDA,*),B(LDB,*),C(LDC,*)
      CHARACTER SIDE,UPLO
      INTEGER LDA,LDB,LDC,M,N
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZHEMV(UPLO,N,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
      IMPLICIT NONE
      DOUBLE COMPLEX ALPHA,BETA,A(LDA,*),X(*),Y(*)
      CHARACTER UPLO
      INTEGER INCX,INCY,LDA,N
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZHER(UPLO,N,ALPHA,X,INCX,A,LDA)
      IMPLICIT NONE
      INTEGER INCX,LDA,N
      DOUBLE PRECISION ALPHA
      CHARACTER UPLO
      DOUBLE COMPLEX A(LDA,*),X(*)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZHER2(UPLO,N,ALPHA,X,INCX,Y,INCY,A,LDA)
      IMPLICIT NONE
      DOUBLE COMPLEX ALPHA,A(LDA,*),X(*),Y(*)
      CHARACTER UPLO
      INTEGER INCX,INCY,LDA,N
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZHER2K(UPLO,TRANS,N,K,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
      IMPLICIT NONE
      DOUBLE COMPLEX ALPHA,A(LDA,*),B(LDB,*),C(LDC,*)
      DOUBLE PRECISION BETA
      CHARACTER TRANS,UPLO
      INTEGER K,LDA,LDB,LDC,N
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZHERK(UPLO,TRANS,N,K,ALPHA,A,LDA,BETA,C,LDC)
      IMPLICIT NONE
      INTEGER K,LDA,LDC,N
      DOUBLE PRECISION ALPHA,BETA
      CHARACTER TRANS,UPLO
      DOUBLE COMPLEX A(LDA,*),C(LDC,*)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZHPMV(UPLO,N,ALPHA,AP,X,INCX,BETA,Y,INCY)
      IMPLICIT NONE
      DOUBLE COMPLEX ALPHA,BETA,AP(*),X(*),Y(*)
      CHARACTER UPLO
      INTEGER INCX,INCY,N
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZHPR(UPLO,N,ALPHA,X,INCX,AP)
      IMPLICIT NONE
      INTEGER INCX,N
      DOUBLE PRECISION ALPHA
      CHARACTER UPLO
      DOUBLE COMPLEX AP(*),X(*)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZHPR2(UPLO,N,ALPHA,X,INCX,Y,INCY,AP)
      IMPLICIT NONE
      DOUBLE COMPLEX ALPHA,AP(*),X(*),Y(*)
      CHARACTER UPLO
      INTEGER INCX,INCY,N
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZROTG(CA,CB,C,S)
      IMPLICIT NONE
      DOUBLE COMPLEX CA,CB,S
      DOUBLE PRECISION C
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZSCAL(N,ZA,ZX,INCX)
      IMPLICIT NONE
      DOUBLE COMPLEX ZA,ZX(*)
      INTEGER INCX,N
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZSWAP(N,ZX,INCX,ZY,INCY)
      IMPLICIT NONE
      INTEGER INCX,INCY,N
      DOUBLE COMPLEX ZX(*),ZY(*)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZSYMM(SIDE,UPLO,M,N,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
      IMPLICIT NONE
      DOUBLE COMPLEX ALPHA,BETA,A(LDA,*),B(LDB,*),C(LDC,*)
      CHARACTER SIDE,UPLO
      INTEGER LDA,LDB,LDC,M,N
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZSYR2K(UPLO,TRANS,N,K,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
      IMPLICIT NONE
      DOUBLE COMPLEX ALPHA,BETA,A(LDA,*),B(LDB,*),C(LDC,*)
      CHARACTER TRANS,UPLO
      INTEGER K,LDA,LDB,LDC,N
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZSYRK(UPLO,TRANS,N,K,ALPHA,A,LDA,BETA,C,LDC)
      IMPLICIT NONE
      DOUBLE COMPLEX ALPHA,BETA,A(LDA,*),C(LDC,*)
      CHARACTER TRANS,UPLO
      INTEGER K,LDA,LDC,N
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZTBMV(UPLO,TRANS,DIAG,N,K,A,LDA,X,INCX)
      IMPLICIT NONE
      INTEGER INCX,K,LDA,N
      CHARACTER DIAG,TRANS,UPLO
      DOUBLE COMPLEX A(LDA,*),X(*)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZTBSV(UPLO,TRANS,DIAG,N,K,A,LDA,X,INCX)
      IMPLICIT NONE
      INTEGER INCX,K,LDA,N
      CHARACTER DIAG,TRANS,UPLO
      DOUBLE COMPLEX A(LDA,*),X(*)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZTPMV(UPLO,TRANS,DIAG,N,AP,X,INCX)
      IMPLICIT NONE
      INTEGER INCX,N
      CHARACTER DIAG,TRANS,UPLO
      DOUBLE COMPLEX AP(*),X(*)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZTPSV(UPLO,TRANS,DIAG,N,AP,X,INCX)
      IMPLICIT NONE
      INTEGER INCX,N
      CHARACTER DIAG,TRANS,UPLO
      DOUBLE COMPLEX AP(*),X(*)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZTRMM(SIDE,UPLO,TRANSA,DIAG,M,N,ALPHA,A,LDA,B,LDB)
      IMPLICIT NONE
      DOUBLE COMPLEX ALPHA,A(LDA,*),B(LDB,*)
      CHARACTER DIAG,SIDE,TRANSA,UPLO
      INTEGER LDA,LDB,M,N
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZTRMV(UPLO,TRANS,DIAG,N,A,LDA,X,INCX)
      IMPLICIT NONE
      INTEGER INCX,LDA,N
      CHARACTER DIAG,TRANS,UPLO
      DOUBLE COMPLEX A(LDA,*),X(*)
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZTRSM(SIDE,UPLO,TRANSA,DIAG,M,N,ALPHA,A,LDA,B,LDB)
      IMPLICIT NONE
      DOUBLE COMPLEX ALPHA,A(LDA,*),B(LDB,*)
      CHARACTER DIAG,SIDE,TRANSA,UPLO
      INTEGER LDA,LDB,M,N
      END SUBROUTINE
      END INTERFACE
      INTERFACE
      SUBROUTINE ZTRSV(UPLO,TRANS,DIAG,N,A,LDA,X,INCX)
      IMPLICIT NONE
      INTEGER INCX,LDA,N
      CHARACTER DIAG,TRANS,UPLO
      DOUBLE COMPLEX A(LDA,*),X(*)
      END SUBROUTINE
      END INTERFACE
      END
