/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JPanel;

public class ColorCalculator {
    private static final double[][] XYZtoRGBMatrix = new double[][]{{3.240479, -1.53715, -0.498535}, {-0.969256, 1.875992, 0.041556}, {0.055648, -0.204043, 1.057311}};
    private double[][] light = null;
    private double[][] color = null;
    double[][] CIEx = ColorCalculator.parseColor("CIEx");
    double[][] CIEy = ColorCalculator.parseColor("CIEy");
    double[][] CIEz = ColorCalculator.parseColor("CIEz");
    double[][] result = null;

    public ColorCalculator() {
        this.loadLight();
    }

    public void loadLight() {
        this.light = ColorCalculator.parseColor("D65.light");
    }

    public void loadAbsorbSpectrum(String filename) {
        this.color = ColorCalculator.parseColor(filename);
    }

    public static double[][] parseColor(String filename) {
        byte[] buffer;
        block20: {
            buffer = new byte[(int)new File(filename).length()];
            BufferedInputStream f = null;
            try {
                f = new BufferedInputStream(new FileInputStream(filename));
                f.read(buffer);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (f != null) {
                    try {
                        f.close();
                    }
                    catch (IOException iOException) {}
                }
                break block20;
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    break block20;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (f != null) {
                        try {
                            f.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (f == null) break block20;
            try {
                f.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String data = new String(buffer);
        data = data.replace("\t", " ");
        String[] lambda_val = data.split("\n");
        double[][] colorData = new double[lambda_val.length][2];
        try {
            int i = 0;
            while (i < lambda_val.length) {
                String[] lambda_color = lambda_val[i].split(" ");
                colorData[i][0] = Double.parseDouble(lambda_color[0]);
                colorData[i][1] = Double.parseDouble(lambda_color[1]);
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("ERROR READING " + filename);
            e.printStackTrace();
        }
        return colorData;
    }

    private static double findMax(double[][] data) {
        double max = 0.0;
        int i = 0;
        while (i < data.length) {
            if (data[i][1] > max) {
                max = data[i][1];
            }
            ++i;
        }
        return max;
    }

    static double[] XYZtoRGB(double X, double Y, double Z, double[][] m) {
        double[] rgb = new double[]{m[0][0] * X + m[0][1] * Y + m[0][2] * Z, m[1][0] * X + m[1][1] * Y + m[1][2] * Z, m[2][0] * X + m[2][1] * Y + m[2][2] * Z};
        return rgb;
    }

    public static double[][] calcIntensitySpec(double[][] Io, double[][] c, double x) {
        double[][] I = new double[Io.length][2];
        double cmax = ColorCalculator.findMax(c);
        int i = 0;
        while (i < Io.length) {
            I[i][0] = Io[i][0];
            I[i][1] = Io[i][1] * Math.exp(c[i][1] * x / cmax);
            ++i;
        }
        return I;
    }

    public static double calcXYZ(double[][] I, double[][] CIE) {
        double W = 0.0;
        int i = 0;
        while (i < I.length) {
            W += I[i][1] * CIE[i][1];
            ++i;
        }
        return 5.0 * W;
    }

    public double[] calculateIlluminatedColor(double amount, double brightnessOffset) {
        if (this.color == null) {
            double[] white = new double[]{1.0, 1.0, 1.0};
            return white;
        }
        double[][] Io = this.light;
        if (amount == 0.0) {
            amount = 1.0E-5;
        }
        double d = Math.log(amount);
        double[][] I = ColorCalculator.calcIntensitySpec(Io, this.color, d);
        this.result = I;
        double X = ColorCalculator.calcXYZ(I, this.CIEx);
        double Y = ColorCalculator.calcXYZ(I, this.CIEy);
        double Z = ColorCalculator.calcXYZ(I, this.CIEz);
        double Ylum = ColorCalculator.calcXYZ(Io, this.CIEy);
        double[] rgb = ColorCalculator.XYZtoRGB(X /= Ylum, Y /= Ylum, Z /= Ylum, XYZtoRGBMatrix);
        System.out.println("R= " + rgb[0] + ", G= " + rgb[1] + ", B= " + rgb[2]);
        return rgb;
    }

    public static double[][] createGaussian(double lambda1, double width1, double lambda2, double width2) {
        double[][] Io = ColorCalculator.parseColor("D65.light");
        double[][] out = new double[Io.length][2];
        int i = 0;
        while (i < Io.length) {
            out[i][0] = Io[i][0];
            out[i][1] = Math.exp(-Math.pow((Io[i][0] - lambda1) / width1, 2.0)) + Math.exp(-Math.pow((Io[i][0] - lambda2) / width2, 2.0));
            ++i;
        }
        return out;
    }

    public JPanel createAbsorbptionGraph() {
        JPanel graph = null;
        if (this.color != null) {
            GraphFactory gf = new GraphFactory("Absorbption Spectrum");
            gf.addDataSet("Absorbption spectrum", this.color);
            graph = gf.getGraph();
        } else {
            graph = new JPanel();
        }
        return graph;
    }

    public JPanel createResultLightGraph() {
        JPanel graph = null;
        if (this.result != null) {
            GraphFactory gf = new GraphFactory("Result light Spectrum");
            gf.addDataSet("visible spectrum", this.result);
            graph = gf.getGraph();
        } else {
            graph = new JPanel();
        }
        return graph;
    }

    public JPanel createGraph() {
        JPanel graph = null;
        if (this.result != null && this.color != null) {
            GraphFactory gf = new GraphFactory("");
            gf.addDataSet("Absorbption spectrum", this.color);
            gf.addDataSet("Visible spectrum", this.result);
            graph = gf.getGraph();
        } else {
            graph = new JPanel();
        }
        return graph;
    }

    private static Double[][] toDouble(double[][] data) {
        Double[][] out = new Double[data.length][];
        int i = 0;
        while (i < data.length) {
            out[i] = new Double[data[i].length];
            int k = 0;
            while (k < data[i].length) {
                out[i][k] = new Double(data[i][k]);
                ++k;
            }
            ++i;
        }
        return out;
    }
}

