/*****************************************************************************/
/*									     */
/*				     EVENT.CC				     */
/*									     */
/* (C) 1996-97	Ullrich von Bassewitz					     */
/*		Wacholderweg 14						     */
/*		D-70597 Stuttgart					     */
/* EMail:	uz@ibb.schwaben.com					     */
/*									     */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



#include "event.h"



/*****************************************************************************/
/*			Explicit template instantiation			     */
/*****************************************************************************/



#ifdef EXPLICIT_TEMPLATES
template class CircularBuffer<Event*, 32>;
template class ListNode<EventHandler>;
#endif



/*****************************************************************************/
/*				     Data				     */
/*****************************************************************************/



// The root of the event handler list. Don't try to replace this by a
// listnode item, it simplifies the code but unfortunately does not work!
ListNode<EventHandler>* EventHandler::EventHandlerList;



/*****************************************************************************/
/*				  class Event				     */
/*****************************************************************************/



Event::Event (unsigned aWhat):
    What (aWhat),
    Handled (0)
{
    // Clear the object pointer since the destructor will try to delete it
    Info.O = 0;
}



Event::Event (unsigned aWhat, unsigned long InfoData):
    What (aWhat),
    Handled (0)
{
    Info.O = 0;
    Info.U = InfoData;
}



Event::Event (unsigned aWhat, void* InfoData):
    What (aWhat),
    Handled (0)
{
    Info.O = 0;
    Info.P = InfoData;
}



Event::Event (unsigned aWhat, Object* InfoData):
    What (aWhat),
    Handled (0)
{
    Info.O = InfoData;
}



Event::~Event ()
{
    delete Info.O;
}



/*****************************************************************************/
/*			      class EventHandler			     */
/*****************************************************************************/



EventHandler::EventHandler ():
    EventHandlerNode (this)
// Establish the event handler
{
    // Insert this handler into the list of handlers
    if (EventHandlerList) {
	EventHandlerNode.InsertAfter (EventHandlerList);
    } else {
	EventHandlerList = &EventHandlerNode;
    }
}



EventHandler::~EventHandler ()
// Delete the event handler
{
    // Unlink the node, but be shure to correct the list pointer
    if (EventHandlerList == &EventHandlerNode) {
	// The list pointer points to this node
	if (EventHandlerNode.IsEmpty ()) {
	    // The list is empty
	    EventHandlerList = NULL;
	} else {
	    EventHandlerList = EventHandlerNode.Next ();
	    // Unlink is done by the destructor
	}
    }
}



void EventHandler::HandleEvent (Event& /*E*/)
// Handle an incoming event. Default is to do nothing.
{
}



/*****************************************************************************/
/*			    class EventFuncHandler			     */
/*****************************************************************************/



// This is an EventHandler object that reroutes events to a user supplied
// function, enabling temporary rerouting of events.



void EventFuncHandler::HandleEvent (Event& E)
// Handle an incoming event. Default is to do nothing.
{
    // Call one of the user supplied functions
    if (HandlerFunc1 != 0) {
	HandlerFunc1 (E);
    } else if (HandlerFunc2 != 0) {
	HandlerFunc2 (E, UserData);
    }
}



EventFuncHandler::EventFuncHandler (void (*HandlerFunc) (Event&)):
    HandlerFunc1 (HandlerFunc),
    HandlerFunc2 (0),
    UserData (0)
// Establish the event handler
{
}



EventFuncHandler::EventFuncHandler (void (*HandlerFunc) (Event&, void*), void* Data):
    HandlerFunc1 (0),
    HandlerFunc2 (HandlerFunc),
    UserData (Data)
// Establish the event handler
{
}



