#!/bin/sh -e

REPOURL=https://github.com/google/fonts/trunk/ofl

MAIN=karla

svn co $REPOURL/$MAIN debian/orig-source/$MAIN.svn

cd debian/orig-source/$MAIN.svn

DATE=$(date -d "$(svn info --xml | grep -o '<date>.*</date>' | grep -o '[0-9TZ:.+-]*')" +%Y%m%d)

svn export . ../$MAIN-${DATE}

cd -

EXTRAS="karlatamilinclined karlatamilupright"

for d in $EXTRAS
do
    svn co $REPOURL/$d debian/orig-source/$d.svn
    cd debian/orig-source/$d.svn
    svn export . ../$MAIN-${DATE}/${d#$MAIN}
    cd -
done

PACKAGE=$(dpkg-parsechangelog -S Source)

tar --owner=root --group=root --mode=a+rX -cJf ${PACKAGE}_${DATE}.orig.tar.xz -C debian/orig-source karla-${DATE}

rm -rf debian/orig-source
