;; Pipeline model for Loongson gs464 cores.

;; Copyright (C) 2011-2023 Free Software Foundation, Inc.
;;
;; This file is part of GCC.
;;
;; GCC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 3, or (at your
;; option) any later version.
;;
;; GCC is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.

;; Uncomment the following line to output automata for debugging.
;; (automata_option "v")

;; Automaton for integer instructions.
(define_automaton "gs464_a_alu")

;; Automaton for floating-point instructions.
(define_automaton "gs464_a_falu")

;; Automaton for memory operations.
(define_automaton "gs464_a_mem")

;; Describe the resources.

(define_cpu_unit "gs464_alu1" "gs464_a_alu")
(define_cpu_unit "gs464_alu2" "gs464_a_alu")
(define_cpu_unit "gs464_mem" "gs464_a_mem")
(define_cpu_unit "gs464_falu1" "gs464_a_falu")
(define_cpu_unit "gs464_falu2" "gs464_a_falu")

;; Describe instruction reservations.

(define_insn_reservation "gs464_arith" 1
  (and (eq_attr "cpu" "gs464")
       (eq_attr "type" "arith,clz,const,logical,
			move,nop,shift,signext,slt"))
  "gs464_alu1 | gs464_alu2")

(define_insn_reservation "gs464_branch" 1
  (and (eq_attr "cpu" "gs464")
       (eq_attr "type" "branch,jump,call,condmove,trap"))
  "gs464_alu1")

(define_insn_reservation "gs464_mfhilo" 1
  (and (eq_attr "cpu" "gs464")
       (eq_attr "type" "mfhi,mflo,mthi,mtlo"))
  "gs464_alu2")

;; Operation imul3nc is fully pipelined.
(define_insn_reservation "gs464_imul3nc" 5
  (and (eq_attr "cpu" "gs464")
       (eq_attr "type" "imul3nc"))
  "gs464_alu2")

(define_insn_reservation "gs464_imul" 7
  (and (eq_attr "cpu" "gs464")
       (eq_attr "type" "imul,imadd"))
  "gs464_alu2 * 7")

(define_insn_reservation "gs464_idiv_si" 12
  (and (eq_attr "cpu" "gs464")
       (and (eq_attr "type" "idiv")
	    (eq_attr "mode" "SI")))
  "gs464_alu2 * 12")

(define_insn_reservation "gs464_idiv_di" 25
  (and (eq_attr "cpu" "gs464")
       (and (eq_attr "type" "idiv")
	    (eq_attr "mode" "DI")))
  "gs464_alu2 * 25")

(define_insn_reservation "gs464_load" 3
  (and (eq_attr "cpu" "gs464")
       (eq_attr "type" "load"))
  "gs464_mem")

(define_insn_reservation "gs464_fpload" 4
  (and (eq_attr "cpu" "gs464")
       (eq_attr "type" "load,mfc,mtc"))
  "gs464_mem")

(define_insn_reservation "gs464_prefetch" 0
  (and (eq_attr "cpu" "gs464")
       (eq_attr "type" "prefetch,prefetchx"))
  "gs464_mem")

(define_insn_reservation "gs464_store" 0
  (and (eq_attr "cpu" "gs464")
       (eq_attr "type" "store,fpstore,fpidxstore"))
  "gs464_mem")

;; All the fp operations can be executed in FALU1.  Only fp add,
;; sub, mul, madd can be executed in FALU2.  Try FALU2 firstly.
(define_insn_reservation "gs464_fadd" 6
  (and (eq_attr "cpu" "gs464")
       (eq_attr "type" "fadd,fmul,fmadd"))
  "gs464_falu2 | gs464_falu1")

(define_insn_reservation "gs464_fcmp" 2
  (and (eq_attr "cpu" "gs464")
       (eq_attr "type" "fabs,fcmp,fmove,fneg"))
  "gs464_falu1")

(define_insn_reservation "gs464_fcvt" 4
  (and (eq_attr "cpu" "gs464")
       (eq_attr "type" "fcvt"))
  "gs464_falu1")

(define_insn_reservation "gs464_fdiv_sf" 12
  (and (eq_attr "cpu" "gs464")
       (and (eq_attr "type" "fdiv,frdiv,fsqrt,frsqrt")
	    (eq_attr "mode" "SF")))
  "gs464_falu1 * 12")

(define_insn_reservation "gs464_fdiv_df" 19
  (and (eq_attr "cpu" "gs464")
       (and (eq_attr "type" "fdiv,frdiv,fsqrt,frsqrt")
	    (eq_attr "mode" "DF")))
  "gs464_falu1 * 19")

;; Force single-dispatch for unknown or multi.
(define_insn_reservation "gs464_unknown" 1
  (and (eq_attr "cpu" "gs464")
       (eq_attr "type" "unknown,multi,atomic,syncloop"))
  "gs464_alu1 + gs464_alu2 + gs464_falu1 + gs464_falu2 + gs464_mem")

;; End of DFA-based pipeline description for gs464
