/**
 * Copyright(c) 2011 Trusted Logic.   All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *  * Neither the name Trusted Logic nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __SCHANNEL6_LOGINS_H__
#define __SCHANNEL6_LOGINS_H__

#define SCX_LOGIN_PUBLIC              0x00000000
#define SCX_LOGIN_USER                0x00000001
#define SCX_LOGIN_GROUP               0x00000002
#define SCX_LOGIN_APPLICATION         0x00000004
#define SCX_LOGIN_APPLICATION_USER    0x00000005
#define SCX_LOGIN_APPLICATION_GROUP   0x00000006
#define SCX_LOGIN_AUTHENTICATION      0x80000000
#define SCX_LOGIN_PRIVILEGED          0x80000002

/* Login variants */

#define SCX_LOGIN_VARIANT(mainType, os, variant) \
   ((mainType) | (1 << 27) | ((os) << 16) | ((variant) << 8))

#define SCX_LOGIN_GET_MAIN_TYPE(type) ((type) & ~SCX_LOGIN_VARIANT(0, 0xFF, 0xFF))

#define SCX_LOGIN_OS_ANY       0x00
#define SCX_LOGIN_OS_LINUX     0x01
#define SCX_LOGIN_OS_WINMOBILE 0x02
#define SCX_LOGIN_OS_SYMBIAN   0x03
#define SCX_LOGIN_OS_ANDROID   0x04

/* OS-independent variants */
#define SCX_LOGIN_USER_NONE        SCX_LOGIN_VARIANT(SCX_LOGIN_USER, SCX_LOGIN_OS_ANY, 0xFF)
#define SCX_LOGIN_GROUP_NONE       SCX_LOGIN_VARIANT(SCX_LOGIN_GROUP, SCX_LOGIN_OS_ANY, 0xFF)
#define SCX_LOGIN_APPLICATION_USER_NONE \
               SCX_LOGIN_VARIANT(SCX_LOGIN_APPLICATION_USER, SCX_LOGIN_OS_ANY, 0xFF)
#define SCX_LOGIN_AUTHENTICATION_BINARY_SHA1_HASH \
               SCX_LOGIN_VARIANT(SCX_LOGIN_AUTHENTICATION, SCX_LOGIN_OS_ANY, 0x01)
#define SCX_LOGIN_PRIVILEGED_KERNEL \
               SCX_LOGIN_VARIANT(SCX_LOGIN_PRIVILEGED, SCX_LOGIN_OS_ANY, 0x01)

/* Linux variants */
#define SCX_LOGIN_USER_LINUX_EUID     SCX_LOGIN_VARIANT(SCX_LOGIN_USER, SCX_LOGIN_OS_LINUX, 0x01)
#define SCX_LOGIN_GROUP_LINUX_GID     SCX_LOGIN_VARIANT(SCX_LOGIN_GROUP, SCX_LOGIN_OS_LINUX, 0x01)
#define SCX_LOGIN_APPLICATION_LINUX_PATH_SHA1_HASH \
               SCX_LOGIN_VARIANT(SCX_LOGIN_APPLICATION, SCX_LOGIN_OS_LINUX, 0x01)
#define SCX_LOGIN_APPLICATION_USER_LINUX_PATH_EUID_SHA1_HASH \
               SCX_LOGIN_VARIANT(SCX_LOGIN_APPLICATION_USER, SCX_LOGIN_OS_LINUX, 0x01)
#define SCX_LOGIN_APPLICATION_GROUP_LINUX_PATH_GID_SHA1_HASH \
               SCX_LOGIN_VARIANT(SCX_LOGIN_APPLICATION_GROUP, SCX_LOGIN_OS_LINUX, 0x01)

/* Android variants */
#define SCX_LOGIN_USER_ANDROID_EUID   SCX_LOGIN_VARIANT(SCX_LOGIN_USER, SCX_LOGIN_OS_ANDROID, 0x01)
#define SCX_LOGIN_GROUP_ANDROID_GID   SCX_LOGIN_VARIANT(SCX_LOGIN_GROUP, SCX_LOGIN_OS_ANDROID, 0x01)
#define SCX_LOGIN_APPLICATION_ANDROID_UID \
               SCX_LOGIN_VARIANT(SCX_LOGIN_APPLICATION, SCX_LOGIN_OS_ANDROID, 0x01)
#define SCX_LOGIN_APPLICATION_USER_ANDROID_UID_EUID \
               SCX_LOGIN_VARIANT(SCX_LOGIN_APPLICATION_USER, SCX_LOGIN_OS_ANDROID, 0x01)
#define SCX_LOGIN_APPLICATION_GROUP_ANDROID_UID_GID \
               SCX_LOGIN_VARIANT(SCX_LOGIN_APPLICATION_GROUP, SCX_LOGIN_OS_ANDROID, 0x01)

/* Symbian variants */
#define SCX_LOGIN_APPLICATION_SYMBIAN_UIDS \
               SCX_LOGIN_VARIANT(SCX_LOGIN_APPLICATION, SCX_LOGIN_OS_SYMBIAN, 0x01)
#define SCX_LOGIN_APPLICATION_USER_SYMBIAN_UIDS \
               SCX_LOGIN_VARIANT(SCX_LOGIN_APPLICATION_USER, SCX_LOGIN_OS_SYMBIAN, 0x01)
#define SCX_LOGIN_APPLICATION_GROUP_SYMBIAN_UIDS \
               SCX_LOGIN_VARIANT(SCX_LOGIN_APPLICATION_GROUP, SCX_LOGIN_OS_SYMBIAN, 0x01)
#define SCX_LOGIN_AUTHENTICATION_SYMBIAN_UIDS \
               SCX_LOGIN_VARIANT(SCX_LOGIN_AUTHENTICATION, SCX_LOGIN_OS_SYMBIAN, 0x01)


#endif /* __SCHANNEL6_LOGINS_H__ */
