/* gitg-lanes.c generated by valac 0.28.0, the Vala compiler
 * generated from gitg-lanes.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgit2-glib/ggit.h>
#include <gee.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define GITG_TYPE_LANES (gitg_lanes_get_type ())
#define GITG_LANES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_LANES, GitgLanes))
#define GITG_LANES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_LANES, GitgLanesClass))
#define GITG_IS_LANES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_LANES))
#define GITG_IS_LANES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_LANES))
#define GITG_LANES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_LANES, GitgLanesClass))

typedef struct _GitgLanes GitgLanes;
typedef struct _GitgLanesClass GitgLanesClass;
typedef struct _GitgLanesPrivate GitgLanesPrivate;

#define GITG_TYPE_COMMIT (gitg_commit_get_type ())
#define GITG_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_COMMIT, GitgCommit))
#define GITG_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_COMMIT, GitgCommitClass))
#define GITG_IS_COMMIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_COMMIT))
#define GITG_IS_COMMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_COMMIT))
#define GITG_COMMIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_COMMIT, GitgCommitClass))

typedef struct _GitgCommit GitgCommit;
typedef struct _GitgCommitClass GitgCommitClass;

#define GITG_LANES_TYPE_LANE_CONTAINER (gitg_lanes_lane_container_get_type ())
#define GITG_LANES_LANE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_LANES_TYPE_LANE_CONTAINER, GitgLanesLaneContainer))
#define GITG_LANES_LANE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_LANES_TYPE_LANE_CONTAINER, GitgLanesLaneContainerClass))
#define GITG_LANES_IS_LANE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_LANES_TYPE_LANE_CONTAINER))
#define GITG_LANES_IS_LANE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_LANES_TYPE_LANE_CONTAINER))
#define GITG_LANES_LANE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_LANES_TYPE_LANE_CONTAINER, GitgLanesLaneContainerClass))

typedef struct _GitgLanesLaneContainer GitgLanesLaneContainer;
typedef struct _GitgLanesLaneContainerClass GitgLanesLaneContainerClass;
typedef struct _GitgLanesCollapsedLane GitgLanesCollapsedLane;
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _GitgLanesLaneContainerPrivate GitgLanesLaneContainerPrivate;

#define GITG_TYPE_LANE (gitg_lane_get_type ())
#define GITG_LANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_LANE, GitgLane))
#define GITG_LANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_LANE, GitgLaneClass))
#define GITG_IS_LANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_LANE))
#define GITG_IS_LANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_LANE))
#define GITG_LANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_LANE, GitgLaneClass))

typedef struct _GitgLane GitgLane;
typedef struct _GitgLaneClass GitgLaneClass;
#define _gitg_lanes_lane_container_unref0(var) ((var == NULL) ? NULL : (var = (gitg_lanes_lane_container_unref (var), NULL)))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))
typedef struct _GitgLanePrivate GitgLanePrivate;

#define GITG_TYPE_COLOR (gitg_color_get_type ())
#define GITG_COLOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_COLOR, GitgColor))
#define GITG_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_COLOR, GitgColorClass))
#define GITG_IS_COLOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_COLOR))
#define GITG_IS_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_COLOR))
#define GITG_COLOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_COLOR, GitgColorClass))

typedef struct _GitgColor GitgColor;
typedef struct _GitgColorClass GitgColorClass;

#define GITG_TYPE_LANE_TAG (gitg_lane_tag_get_type ())
#define _gitg_lanes_collapsed_lane_free0(var) ((var == NULL) ? NULL : (var = (gitg_lanes_collapsed_lane_free (var), NULL)))
typedef struct _GitgLanesParamSpecLaneContainer GitgLanesParamSpecLaneContainer;

struct _GitgLanes {
	GObject parent_instance;
	GitgLanesPrivate * priv;
};

struct _GitgLanesClass {
	GObjectClass parent_class;
};

struct _GitgLanesPrivate {
	gint _inactive_max;
	gint _inactive_collapse;
	gint _inactive_gap;
	gboolean _inactive_enabled;
	GSList* d_previous;
	GeeLinkedList* d_lanes;
	GHashTable* d_collapsed;
	GeeHashSet* d_roots;
};

struct _GitgLanesLaneContainer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GitgLanesLaneContainerPrivate * priv;
	GitgLane* lane;
	gint inactive;
	GgitOId* from;
	GgitOId* to;
};

struct _GitgLanesLaneContainerClass {
	GTypeClass parent_class;
	void (*finalize) (GitgLanesLaneContainer *self);
};

typedef enum  {
	GITG_LANE_TAG_NONE = 0,
	GITG_LANE_TAG_START = 1 << 0,
	GITG_LANE_TAG_END = 1 << 1,
	GITG_LANE_TAG_SIGN_STASH = 1 << 2,
	GITG_LANE_TAG_SIGN_STAGED = 1 << 3,
	GITG_LANE_TAG_SIGN_UNSTAGED = 1 << 4,
	GITG_LANE_TAG_HIDDEN = 1 << 5
} GitgLaneTag;

struct _GitgLane {
	GObject parent_instance;
	GitgLanePrivate * priv;
	GitgColor* color;
	GSList* from;
	GitgLaneTag tag;
	GgitOId* boundary_id;
};

struct _GitgLaneClass {
	GObjectClass parent_class;
};

struct _GitgLanesCollapsedLane {
	GitgColor* color;
	guint index;
	GgitOId* from;
	GgitOId* to;
};

struct _GitgLanesParamSpecLaneContainer {
	GParamSpec parent_instance;
};


static gpointer gitg_lanes_parent_class = NULL;
static gpointer gitg_lanes_lane_container_parent_class = NULL;

GType gitg_lanes_get_type (void) G_GNUC_CONST;
GType gitg_commit_get_type (void) G_GNUC_CONST;
static gpointer gitg_lanes_lane_container_ref (gpointer instance);
static void gitg_lanes_lane_container_unref (gpointer instance);
static GParamSpec* gitg_lanes_param_spec_lane_container (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void gitg_lanes_value_set_lane_container (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void gitg_lanes_value_take_lane_container (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer gitg_lanes_value_get_lane_container (const GValue* value) G_GNUC_UNUSED;
static GType gitg_lanes_lane_container_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void gitg_lanes_collapsed_lane_free (GitgLanesCollapsedLane* self);
#define GITG_LANES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_LANES, GitgLanesPrivate))
enum  {
	GITG_LANES_DUMMY_PROPERTY,
	GITG_LANES_INACTIVE_MAX,
	GITG_LANES_INACTIVE_COLLAPSE,
	GITG_LANES_INACTIVE_GAP,
	GITG_LANES_INACTIVE_ENABLED
};
GitgLanes* gitg_lanes_new (void);
GitgLanes* gitg_lanes_construct (GType object_type);
static guint _ggit_oid_hash_ghash_func (gconstpointer key);
static gboolean _ggit_oid_equal_gequal_func (gconstpointer a, gconstpointer b);
static void _vala_GgitOId_free (GgitOId* self);
static void __vala_GgitOId_free0_ (gpointer var);
static void _gitg_lanes_collapsed_lane_free0_ (gpointer var);
void gitg_lanes_reset (GitgLanes* self, GgitOId** reserved, int reserved_length1, GeeHashSet* roots);
void gitg_color_reset (void);
static GgitOId* _vala_GgitOId_copy (GgitOId* self);
static GitgLanesLaneContainer* gitg_lanes_lane_container_new (GgitOId* from, GgitOId* to);
static GitgLanesLaneContainer* gitg_lanes_lane_container_construct (GType object_type, GgitOId* from, GgitOId* to);
GType gitg_lane_get_type (void) G_GNUC_CONST;
static void gitg_lanes_lane_container_set_is_hidden (GitgLanesLaneContainer* self, gboolean value);
gboolean gitg_lanes_next (GitgLanes* self, GitgCommit* next, GSList** lanes, gint* nextpos);
gboolean gitg_lanes_get_inactive_enabled (GitgLanes* self);
static void gitg_lanes_collapse_lanes (GitgLanes* self);
static void gitg_lanes_expand_lanes (GitgLanes* self, GitgCommit* commit);
static GitgLanesLaneContainer* gitg_lanes_find_lane_by_oid (GitgLanes* self, GgitOId* id, gint* pos);
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
GType gitg_color_get_type (void) G_GNUC_CONST;
GType gitg_lane_tag_get_type (void) G_GNUC_CONST;
GitgColor* gitg_color_copy (GitgColor* self);
static gboolean gitg_lanes_lane_container_get_is_hidden (GitgLanesLaneContainer* self);
static GSList* gitg_lanes_lanes_list (GitgLanes* self);
static void gitg_lanes_prepare_lanes (GitgLanes* self, GitgCommit* next, gint pos, gboolean hidden);
static void gitg_lanes_init_next_layer (GitgLanes* self);
gint gitg_lanes_get_inactive_collapse (GitgLanes* self);
gint gitg_lanes_get_inactive_gap (GitgLanes* self);
static void gitg_lanes_add_collapsed (GitgLanes* self, GitgLanesLaneContainer* container, gint index);
static GitgLanesCollapsedLane* gitg_lanes_collapsed_lane_new (GitgLanesLaneContainer* container);
static GitgLanesCollapsedLane* gitg_lanes_collapsed_lane_new (GitgLanesLaneContainer* container);
static void gitg_lanes_collapse_lane (GitgLanes* self, GitgLanesLaneContainer* container, gint index);
GSList* gitg_commit_get_lanes (GitgCommit* self);
GSList* gitg_commit_remove_lane (GitgCommit* self, GitgLane* lane);
static void gitg_lanes_update_merge_indices (GitgLanes* self, GSList* lanes, gint index, gint direction);
guint gitg_commit_get_mylane (GitgCommit* self);
void gitg_commit_set_mylane (GitgCommit* self, guint value);
gint gitg_lanes_get_inactive_max (GitgLanes* self);
static void gitg_lanes_update_current_lane_merge_indices (GitgLanes* self, gint index, gint direction);
static gint gitg_lanes_ensure_correct_index (GitgLanes* self, GitgCommit* commit, gint index);
static void gitg_lanes_update_lane_merge_indices (GitgLanes* self, GSList* from, gint index, gint direction);
static void gitg_lanes_expand_lane (GitgLanes* self, GitgLanesCollapsedLane* lane);
GitgLane* gitg_lane_new_with_color (GitgColor* color);
GitgLane* gitg_lane_construct_with_color (GType object_type, GitgColor* color);
static GitgLanesLaneContainer* gitg_lanes_lane_container_new_with_color (GgitOId* from, GgitOId* to, GitgColor* color);
static GitgLanesLaneContainer* gitg_lanes_lane_container_construct_with_color (GType object_type, GgitOId* from, GgitOId* to, GitgColor* color);
GitgLane* gitg_lane_copy (GitgLane* self);
GSList* gitg_commit_insert_lane (GitgCommit* self, GitgLane* lane, gint idx);
static void gitg_lanes_expand_lane_from_oid (GitgLanes* self, GgitOId* id);
static void gitg_lanes_lane_container_next (GitgLanesLaneContainer* self, gint index);
void gitg_lanes_set_inactive_max (GitgLanes* self, gint value);
void gitg_lanes_set_inactive_collapse (GitgLanes* self, gint value);
void gitg_lanes_set_inactive_gap (GitgLanes* self, gint value);
void gitg_lanes_set_inactive_enabled (GitgLanes* self, gboolean value);
enum  {
	GITG_LANES_LANE_CONTAINER_DUMMY_PROPERTY
};
static void gitg_lanes_lane_container_finalize (GitgLanesLaneContainer* obj);
static void gitg_lanes_collapsed_lane_instance_init (GitgLanesCollapsedLane * self);
static void gitg_lanes_finalize (GObject* obj);
static void _vala_gitg_lanes_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_lanes_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static guint _ggit_oid_hash_ghash_func (gconstpointer key) {
	guint result;
	result = ggit_oid_hash (key);
#line 114 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 258 "gitg-lanes.c"
}


static gboolean _ggit_oid_equal_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = ggit_oid_equal (a, (GgitOId*) b);
#line 114 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 267 "gitg-lanes.c"
}


static void _vala_GgitOId_free (GgitOId* self) {
#line 114 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_boxed_free (ggit_oid_get_type (), self);
#line 274 "gitg-lanes.c"
}


static void __vala_GgitOId_free0_ (gpointer var) {
#line 114 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	(var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL));
#line 281 "gitg-lanes.c"
}


static void _gitg_lanes_collapsed_lane_free0_ (gpointer var) {
#line 114 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	(var == NULL) ? NULL : (var = (gitg_lanes_collapsed_lane_free (var), NULL));
#line 288 "gitg-lanes.c"
}


GitgLanes* gitg_lanes_construct (GType object_type) {
	GitgLanes * self = NULL;
	GHashTable* _tmp0_ = NULL;
	GSettings* settings = NULL;
	GSettings* _tmp1_ = NULL;
#line 112 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self = (GitgLanes*) g_object_new (object_type, NULL);
#line 114 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = g_hash_table_new_full (_ggit_oid_hash_ghash_func, _ggit_oid_equal_gequal_func, __vala_GgitOId_free0_, _gitg_lanes_collapsed_lane_free0_);
#line 114 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_g_hash_table_unref0 (self->priv->d_collapsed);
#line 114 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self->priv->d_collapsed = _tmp0_;
#line 117 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = g_settings_new ("org.gnome.gitg.preferences.history");
#line 117 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	settings = _tmp1_;
#line 119 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_settings_bind (settings, "collapse-inactive-lanes-enabled", (GObject*) self, "inactive-enabled", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_SET);
#line 124 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_settings_bind (settings, "collapse-inactive-lanes", (GObject*) self, "inactive-collapse", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_SET);
#line 129 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_reset (self, NULL, 0, NULL);
#line 112 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (settings);
#line 112 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	return self;
#line 319 "gitg-lanes.c"
}


GitgLanes* gitg_lanes_new (void) {
#line 112 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	return gitg_lanes_construct (GITG_TYPE_LANES);
#line 326 "gitg-lanes.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 138 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	return self ? g_object_ref (self) : NULL;
#line 333 "gitg-lanes.c"
}


static GgitOId* _vala_GgitOId_copy (GgitOId* self) {
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	return g_boxed_copy (ggit_oid_get_type (), self);
#line 340 "gitg-lanes.c"
}


static gpointer __vala_GgitOId_copy0 (gpointer self) {
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	return self ? _vala_GgitOId_copy (self) : NULL;
#line 347 "gitg-lanes.c"
}


void gitg_lanes_reset (GitgLanes* self, GgitOId** reserved, int reserved_length1, GeeHashSet* roots) {
	GeeLinkedList* _tmp0_ = NULL;
	GeeHashSet* _tmp1_ = NULL;
	GeeHashSet* _tmp2_ = NULL;
	GgitOId** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	GHashTable* _tmp12_ = NULL;
#line 132 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 135 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_g_slist_free0 (self->priv->d_previous);
#line 135 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self->priv->d_previous = NULL;
#line 137 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = gee_linked_list_new (GITG_LANES_TYPE_LANE_CONTAINER, (GBoxedCopyFunc) gitg_lanes_lane_container_ref, gitg_lanes_lane_container_unref, NULL, NULL, NULL);
#line 137 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->priv->d_lanes);
#line 137 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self->priv->d_lanes = _tmp0_;
#line 138 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = roots;
#line 138 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 138 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->priv->d_roots);
#line 138 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self->priv->d_roots = _tmp2_;
#line 140 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	gitg_color_reset ();
#line 142 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = reserved;
#line 142 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp3__length1 = reserved_length1;
#line 142 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (_tmp3_ != NULL) {
#line 386 "gitg-lanes.c"
		GgitOId** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = reserved;
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp4__length1 = reserved_length1;
#line 393 "gitg-lanes.c"
		{
			GgitOId** r_collection = NULL;
			gint r_collection_length1 = 0;
			gint _r_collection_size_ = 0;
			gint r_it = 0;
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			r_collection = _tmp4_;
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			r_collection_length1 = _tmp4__length1;
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			for (r_it = 0; r_it < _tmp4__length1; r_it = r_it + 1) {
#line 405 "gitg-lanes.c"
				GgitOId* _tmp5_ = NULL;
				GgitOId* r = NULL;
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp5_ = __vala_GgitOId_copy0 (r_collection[r_it]);
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				r = _tmp5_;
#line 412 "gitg-lanes.c"
				{
					GitgLanesLaneContainer* ct = NULL;
					GgitOId* _tmp6_ = NULL;
					GitgLanesLaneContainer* _tmp7_ = NULL;
					GitgLanesLaneContainer* _tmp8_ = NULL;
					GitgLanesLaneContainer* _tmp9_ = NULL;
					GeeLinkedList* _tmp10_ = NULL;
					GitgLanesLaneContainer* _tmp11_ = NULL;
#line 146 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					_tmp6_ = r;
#line 146 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					_tmp7_ = gitg_lanes_lane_container_new (NULL, _tmp6_);
#line 146 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					ct = _tmp7_;
#line 147 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					_tmp8_ = ct;
#line 147 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					_tmp8_->inactive = -1;
#line 148 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					_tmp9_ = ct;
#line 148 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					gitg_lanes_lane_container_set_is_hidden (_tmp9_, TRUE);
#line 150 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					_tmp10_ = self->priv->d_lanes;
#line 150 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					_tmp11_ = ct;
#line 150 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					_gitg_lanes_lane_container_unref0 (ct);
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					__vala_GgitOId_free0 (r);
#line 445 "gitg-lanes.c"
				}
			}
		}
	}
#line 154 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp12_ = self->priv->d_collapsed;
#line 154 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_hash_table_remove_all (_tmp12_);
#line 155 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_g_slist_free0 (self->priv->d_previous);
#line 155 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self->priv->d_previous = NULL;
#line 458 "gitg-lanes.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 174 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 465 "gitg-lanes.c"
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
#line 174 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 174 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_slist_free (self);
#line 474 "gitg-lanes.c"
}


gboolean gitg_lanes_next (GitgLanes* self, GitgCommit* next, GSList** lanes, gint* nextpos) {
	GSList* _vala_lanes = NULL;
	gint _vala_nextpos = 0;
	gboolean result = FALSE;
	GgitOId* myoid = NULL;
	GitgCommit* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GitgLanesLaneContainer* mylane = NULL;
	GgitOId* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GitgLanesLaneContainer* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	GitgLanesLaneContainer* _tmp9_ = NULL;
	GitgLanesLaneContainer* _tmp14_ = NULL;
	gboolean hidden = FALSE;
	GitgLanesLaneContainer* _tmp47_ = NULL;
	gboolean _tmp48_ = FALSE;
	gboolean _tmp49_ = FALSE;
	GSList* _tmp50_ = NULL;
	GitgCommit* _tmp51_ = NULL;
	gint _tmp52_ = 0;
	gboolean _tmp53_ = FALSE;
	gboolean _tmp54_ = FALSE;
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (next != NULL, FALSE);
#line 162 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = next;
#line 162 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = ggit_object_get_id ((GgitObject*) _tmp0_);
#line 162 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	myoid = _tmp1_;
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = self->priv->_inactive_enabled;
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (_tmp2_) {
#line 517 "gitg-lanes.c"
		GitgCommit* _tmp3_ = NULL;
#line 166 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_collapse_lanes (self);
#line 167 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp3_ = next;
#line 167 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_expand_lanes (self, _tmp3_);
#line 525 "gitg-lanes.c"
	}
#line 170 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = myoid;
#line 170 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp6_ = gitg_lanes_find_lane_by_oid (self, _tmp4_, &_tmp5_);
#line 170 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_vala_nextpos = _tmp5_;
#line 170 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	mylane = _tmp6_;
#line 172 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp9_ = mylane;
#line 172 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (_tmp9_ == NULL) {
#line 539 "gitg-lanes.c"
		GeeHashSet* _tmp10_ = NULL;
#line 172 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp10_ = self->priv->d_roots;
#line 172 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp8_ = _tmp10_ != NULL;
#line 545 "gitg-lanes.c"
	} else {
#line 172 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp8_ = FALSE;
#line 549 "gitg-lanes.c"
	}
#line 172 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (_tmp8_) {
#line 553 "gitg-lanes.c"
		GeeHashSet* _tmp11_ = NULL;
		GgitOId* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
#line 172 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp11_ = self->priv->d_roots;
#line 172 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp12_ = myoid;
#line 172 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp13_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp11_, _tmp12_);
#line 172 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp7_ = !_tmp13_;
#line 565 "gitg-lanes.c"
	} else {
#line 172 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp7_ = FALSE;
#line 569 "gitg-lanes.c"
	}
#line 172 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (_tmp7_) {
#line 174 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		__g_slist_free__g_object_unref0_0 (_vala_lanes);
#line 174 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_vala_lanes = NULL;
#line 175 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		result = FALSE;
#line 175 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_gitg_lanes_lane_container_unref0 (mylane);
#line 175 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		__vala_GgitOId_free0 (myoid);
#line 175 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		if (lanes) {
#line 175 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			*lanes = _vala_lanes;
#line 587 "gitg-lanes.c"
		} else {
#line 175 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			__g_slist_free__g_object_unref0_0 (_vala_lanes);
#line 591 "gitg-lanes.c"
		}
#line 175 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		if (nextpos) {
#line 175 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			*nextpos = _vala_nextpos;
#line 597 "gitg-lanes.c"
		}
#line 175 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		return result;
#line 601 "gitg-lanes.c"
	}
#line 178 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp14_ = mylane;
#line 178 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (_tmp14_ == NULL) {
#line 607 "gitg-lanes.c"
		GgitOId* _tmp15_ = NULL;
		GitgLanesLaneContainer* _tmp16_ = NULL;
		GeeLinkedList* _tmp17_ = NULL;
		GitgLanesLaneContainer* _tmp18_ = NULL;
		GeeLinkedList* _tmp19_ = NULL;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
#line 181 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp15_ = myoid;
#line 181 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp16_ = gitg_lanes_lane_container_new (_tmp15_, NULL);
#line 181 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_gitg_lanes_lane_container_unref0 (mylane);
#line 181 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		mylane = _tmp16_;
#line 183 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp17_ = self->priv->d_lanes;
#line 183 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp18_ = mylane;
#line 183 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
#line 184 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp19_ = self->priv->d_lanes;
#line 184 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp20_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp19_);
#line 184 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp21_ = _tmp20_;
#line 184 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_vala_nextpos = ((gint) _tmp21_) - 1;
#line 637 "gitg-lanes.c"
	} else {
		GitgLanesLaneContainer* _tmp22_ = NULL;
		GitgLane* _tmp23_ = NULL;
		GitgLanesLaneContainer* _tmp24_ = NULL;
		GitgLane* _tmp25_ = NULL;
		GitgColor* _tmp26_ = NULL;
		GitgColor* _tmp27_ = NULL;
		GitgLanesLaneContainer* _tmp28_ = NULL;
		GitgLanesLaneContainer* _tmp29_ = NULL;
		GitgCommit* _tmp30_ = NULL;
		GgitOId* _tmp31_ = NULL;
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
		GitgLanesLaneContainer* _tmp34_ = NULL;
		gboolean _tmp35_ = FALSE;
		gboolean _tmp36_ = FALSE;
		GitgLanesLaneContainer* _tmp44_ = NULL;
		gint _tmp45_ = 0;
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp22_ = mylane;
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp23_ = _tmp22_->lane;
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp24_ = mylane;
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp25_ = _tmp24_->lane;
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp26_ = _tmp25_->color;
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp27_ = gitg_color_copy (_tmp26_);
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (_tmp23_->color);
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp23_->color = _tmp27_;
#line 191 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp28_ = mylane;
#line 191 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		__vala_GgitOId_free0 (_tmp28_->to);
#line 191 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp28_->to = NULL;
#line 192 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp29_ = mylane;
#line 192 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp30_ = next;
#line 192 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp31_ = ggit_object_get_id ((GgitObject*) _tmp30_);
#line 192 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		__vala_GgitOId_free0 (_tmp29_->from);
#line 192 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp29_->from = _tmp31_;
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp34_ = mylane;
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp35_ = gitg_lanes_lane_container_get_is_hidden (_tmp34_);
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp36_ = _tmp35_;
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		if (_tmp36_) {
#line 696 "gitg-lanes.c"
			GeeHashSet* _tmp37_ = NULL;
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp37_ = self->priv->d_roots;
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp33_ = _tmp37_ != NULL;
#line 702 "gitg-lanes.c"
		} else {
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp33_ = FALSE;
#line 706 "gitg-lanes.c"
		}
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		if (_tmp33_) {
#line 710 "gitg-lanes.c"
			GeeHashSet* _tmp38_ = NULL;
			GgitOId* _tmp39_ = NULL;
			gboolean _tmp40_ = FALSE;
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp38_ = self->priv->d_roots;
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp39_ = myoid;
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp40_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp38_, _tmp39_);
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp32_ = _tmp40_;
#line 722 "gitg-lanes.c"
		} else {
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp32_ = FALSE;
#line 726 "gitg-lanes.c"
		}
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		if (_tmp32_) {
#line 730 "gitg-lanes.c"
			GitgLanesLaneContainer* _tmp41_ = NULL;
			GitgLanesLaneContainer* _tmp42_ = NULL;
			GitgLane* _tmp43_ = NULL;
#line 196 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp41_ = mylane;
#line 196 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			gitg_lanes_lane_container_set_is_hidden (_tmp41_, FALSE);
#line 197 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp42_ = mylane;
#line 197 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp43_ = _tmp42_->lane;
#line 197 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_g_slist_free0 (_tmp43_->from);
#line 197 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp43_->from = NULL;
#line 746 "gitg-lanes.c"
		}
#line 200 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp44_ = mylane;
#line 200 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp45_ = _tmp44_->inactive;
#line 200 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		if (_tmp45_ >= 0) {
#line 754 "gitg-lanes.c"
			GitgLanesLaneContainer* _tmp46_ = NULL;
#line 202 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp46_ = mylane;
#line 202 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp46_->inactive = 0;
#line 760 "gitg-lanes.c"
		}
	}
#line 206 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp47_ = mylane;
#line 206 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp48_ = gitg_lanes_lane_container_get_is_hidden (_tmp47_);
#line 206 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp49_ = _tmp48_;
#line 206 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	hidden = _tmp49_;
#line 208 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp50_ = gitg_lanes_lanes_list (self);
#line 208 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	__g_slist_free__g_object_unref0_0 (_vala_lanes);
#line 208 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_vala_lanes = _tmp50_;
#line 209 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp51_ = next;
#line 209 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp52_ = _vala_nextpos;
#line 209 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp53_ = hidden;
#line 209 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_prepare_lanes (self, _tmp51_, _tmp52_, _tmp53_);
#line 211 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp54_ = hidden;
#line 211 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	result = !_tmp54_;
#line 211 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_gitg_lanes_lane_container_unref0 (mylane);
#line 211 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (myoid);
#line 211 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (lanes) {
#line 211 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		*lanes = _vala_lanes;
#line 797 "gitg-lanes.c"
	} else {
#line 211 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		__g_slist_free__g_object_unref0_0 (_vala_lanes);
#line 801 "gitg-lanes.c"
	}
#line 211 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (nextpos) {
#line 211 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		*nextpos = _vala_nextpos;
#line 807 "gitg-lanes.c"
	}
#line 211 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 811 "gitg-lanes.c"
}


static void gitg_lanes_prepare_lanes (GitgLanes* self, GitgCommit* next, gint pos, gboolean hidden) {
	GgitCommitParents* parents = NULL;
	GitgCommit* _tmp0_ = NULL;
	GgitCommitParents* _tmp1_ = NULL;
	GgitOId* myoid = NULL;
	GitgCommit* _tmp2_ = NULL;
	GgitOId* _tmp3_ = NULL;
	GitgLanesLaneContainer* mylane = NULL;
	GeeLinkedList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gpointer _tmp6_ = NULL;
	gboolean _tmp88_ = FALSE;
	GitgLanesLaneContainer* _tmp89_ = NULL;
	GSList* _tmp94_ = NULL;
	guint _tmp95_ = 0U;
	gint _tmp96_ = 0;
	gint _tmp97_ = 0;
	GitgCommit* _tmp100_ = NULL;
#line 214 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 214 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (next != NULL);
#line 216 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = next;
#line 216 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = ggit_commit_get_parents ((GgitCommit*) _tmp0_);
#line 216 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	parents = _tmp1_;
#line 217 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = next;
#line 217 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = ggit_object_get_id ((GgitObject*) _tmp2_);
#line 217 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	myoid = _tmp3_;
#line 219 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_init_next_layer (self);
#line 220 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = self->priv->d_lanes;
#line 220 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp5_ = pos;
#line 220 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, _tmp5_);
#line 220 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	mylane = (GitgLanesLaneContainer*) _tmp6_;
#line 859 "gitg-lanes.c"
	{
		guint i = 0U;
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		i = (guint) 0;
#line 864 "gitg-lanes.c"
		{
			gboolean _tmp7_ = FALSE;
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp7_ = TRUE;
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			while (TRUE) {
#line 871 "gitg-lanes.c"
				guint _tmp9_ = 0U;
				GgitCommitParents* _tmp10_ = NULL;
				guint _tmp11_ = 0U;
				guint _tmp12_ = 0U;
				gint lnpos = 0;
				GgitOId* poid = NULL;
				GgitCommitParents* _tmp13_ = NULL;
				guint _tmp14_ = 0U;
				GgitOId* _tmp15_ = NULL;
				GitgLanesLaneContainer* container = NULL;
				GgitOId* _tmp16_ = NULL;
				gint _tmp17_ = 0;
				GitgLanesLaneContainer* _tmp18_ = NULL;
				GitgLanesLaneContainer* _tmp19_ = NULL;
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				if (!_tmp7_) {
#line 888 "gitg-lanes.c"
					guint _tmp8_ = 0U;
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					_tmp8_ = i;
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					i = _tmp8_ + 1;
#line 894 "gitg-lanes.c"
				}
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp7_ = FALSE;
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp9_ = i;
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp10_ = parents;
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp11_ = ggit_commit_parents_get_size (_tmp10_);
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp12_ = _tmp11_;
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				if (!(_tmp9_ < _tmp12_)) {
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					break;
#line 910 "gitg-lanes.c"
				}
#line 225 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp13_ = parents;
#line 225 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp14_ = i;
#line 225 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp15_ = ggit_commit_parents_get_id (_tmp13_, _tmp14_);
#line 225 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				poid = _tmp15_;
#line 227 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp16_ = poid;
#line 227 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp18_ = gitg_lanes_find_lane_by_oid (self, _tmp16_, &_tmp17_);
#line 227 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				lnpos = _tmp17_;
#line 227 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				container = _tmp18_;
#line 229 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp19_ = container;
#line 229 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				if (_tmp19_ != NULL) {
#line 932 "gitg-lanes.c"
					gboolean _tmp20_ = FALSE;
					guint _tmp21_ = 0U;
#line 233 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					_tmp21_ = i;
#line 233 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					if (_tmp21_ == ((guint) 0)) {
#line 939 "gitg-lanes.c"
						gint _tmp22_ = 0;
						gint _tmp23_ = 0;
#line 233 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp22_ = pos;
#line 233 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp23_ = lnpos;
#line 233 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp20_ = _tmp22_ < _tmp23_;
#line 948 "gitg-lanes.c"
					} else {
#line 233 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp20_ = FALSE;
#line 952 "gitg-lanes.c"
					}
#line 233 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					if (_tmp20_) {
#line 956 "gitg-lanes.c"
						GitgLanesLaneContainer* _tmp24_ = NULL;
						GgitOId* _tmp25_ = NULL;
						GgitOId* _tmp26_ = NULL;
						GitgLanesLaneContainer* _tmp27_ = NULL;
						GgitOId* _tmp28_ = NULL;
						GgitOId* _tmp29_ = NULL;
						GitgLanesLaneContainer* _tmp30_ = NULL;
						gboolean _tmp31_ = FALSE;
						gboolean _tmp32_ = FALSE;
						GitgLanesLaneContainer* _tmp37_ = NULL;
						GitgLane* _tmp38_ = NULL;
						GitgLanesLaneContainer* _tmp39_ = NULL;
						GitgLane* _tmp40_ = NULL;
						GitgColor* _tmp41_ = NULL;
						GitgColor* _tmp42_ = NULL;
						GitgLanesLaneContainer* _tmp43_ = NULL;
						gint _tmp44_ = 0;
						GeeLinkedList* _tmp46_ = NULL;
						GitgLanesLaneContainer* _tmp47_ = NULL;
#line 239 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp24_ = mylane;
#line 239 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp25_ = poid;
#line 239 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp26_ = __vala_GgitOId_copy0 (_tmp25_);
#line 239 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						__vala_GgitOId_free0 (_tmp24_->to);
#line 239 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp24_->to = _tmp26_;
#line 240 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp27_ = mylane;
#line 240 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp28_ = myoid;
#line 240 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp29_ = __vala_GgitOId_copy0 (_tmp28_);
#line 240 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						__vala_GgitOId_free0 (_tmp27_->from);
#line 240 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp27_->from = _tmp29_;
#line 242 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp30_ = container;
#line 242 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp31_ = gitg_lanes_lane_container_get_is_hidden (_tmp30_);
#line 242 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp32_ = _tmp31_;
#line 242 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						if (!_tmp32_) {
#line 1004 "gitg-lanes.c"
							GitgLanesLaneContainer* _tmp33_ = NULL;
							GitgLane* _tmp34_ = NULL;
							gint _tmp35_ = 0;
							GitgLanesLaneContainer* _tmp36_ = NULL;
#line 244 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							_tmp33_ = mylane;
#line 244 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							_tmp34_ = _tmp33_->lane;
#line 244 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							_tmp35_ = lnpos;
#line 244 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							_tmp34_->from = g_slist_append (_tmp34_->from, (gpointer) ((gintptr) _tmp35_));
#line 245 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							_tmp36_ = mylane;
#line 245 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							gitg_lanes_lane_container_set_is_hidden (_tmp36_, FALSE);
#line 1021 "gitg-lanes.c"
						}
#line 248 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp37_ = mylane;
#line 248 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp38_ = _tmp37_->lane;
#line 248 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp39_ = mylane;
#line 248 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp40_ = _tmp39_->lane;
#line 248 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp41_ = _tmp40_->color;
#line 248 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp42_ = gitg_color_copy (_tmp41_);
#line 248 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_g_object_unref0 (_tmp38_->color);
#line 248 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp38_->color = _tmp42_;
#line 250 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp43_ = mylane;
#line 250 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp44_ = _tmp43_->inactive;
#line 250 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						if (_tmp44_ >= 0) {
#line 1045 "gitg-lanes.c"
							GitgLanesLaneContainer* _tmp45_ = NULL;
#line 252 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							_tmp45_ = mylane;
#line 252 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							_tmp45_->inactive = 0;
#line 1051 "gitg-lanes.c"
						}
#line 255 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp46_ = self->priv->d_lanes;
#line 255 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp47_ = container;
#line 255 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp46_, _tmp47_);
#line 1059 "gitg-lanes.c"
					} else {
						GitgLanesLaneContainer* _tmp48_ = NULL;
						GgitOId* _tmp49_ = NULL;
						GgitOId* _tmp50_ = NULL;
						gboolean _tmp51_ = FALSE;
						GitgLanesLaneContainer* _tmp55_ = NULL;
						GitgLane* _tmp56_ = NULL;
						GitgLanesLaneContainer* _tmp57_ = NULL;
						GitgLane* _tmp58_ = NULL;
						GitgColor* _tmp59_ = NULL;
						GitgColor* _tmp60_ = NULL;
						gboolean _tmp61_ = FALSE;
						GitgLanesLaneContainer* _tmp63_ = NULL;
						gint _tmp64_ = 0;
#line 259 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp48_ = container;
#line 259 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp49_ = myoid;
#line 259 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp50_ = __vala_GgitOId_copy0 (_tmp49_);
#line 259 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						__vala_GgitOId_free0 (_tmp48_->from);
#line 259 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp48_->from = _tmp50_;
#line 261 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp51_ = hidden;
#line 261 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						if (!_tmp51_) {
#line 1088 "gitg-lanes.c"
							GitgLanesLaneContainer* _tmp52_ = NULL;
							GitgLane* _tmp53_ = NULL;
							gint _tmp54_ = 0;
#line 263 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							_tmp52_ = container;
#line 263 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							_tmp53_ = _tmp52_->lane;
#line 263 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							_tmp54_ = pos;
#line 263 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							_tmp53_->from = g_slist_append (_tmp53_->from, (gpointer) ((gintptr) _tmp54_));
#line 1100 "gitg-lanes.c"
						}
#line 266 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp55_ = container;
#line 266 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp56_ = _tmp55_->lane;
#line 266 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp57_ = container;
#line 266 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp58_ = _tmp57_->lane;
#line 266 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp59_ = _tmp58_->color;
#line 266 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp60_ = gitg_color_copy (_tmp59_);
#line 266 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_g_object_unref0 (_tmp56_->color);
#line 266 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp56_->color = _tmp60_;
#line 268 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp61_ = hidden;
#line 268 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						if (!_tmp61_) {
#line 1122 "gitg-lanes.c"
							GitgLanesLaneContainer* _tmp62_ = NULL;
#line 270 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							_tmp62_ = container;
#line 270 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							gitg_lanes_lane_container_set_is_hidden (_tmp62_, FALSE);
#line 1128 "gitg-lanes.c"
						}
#line 273 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp63_ = container;
#line 273 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp64_ = _tmp63_->inactive;
#line 273 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						if (_tmp64_ >= 0) {
#line 1136 "gitg-lanes.c"
							GitgLanesLaneContainer* _tmp65_ = NULL;
#line 275 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							_tmp65_ = container;
#line 275 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							_tmp65_->inactive = 0;
#line 1142 "gitg-lanes.c"
						}
					}
#line 279 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					_gitg_lanes_lane_container_unref0 (container);
#line 279 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					__vala_GgitOId_free0 (poid);
#line 279 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					continue;
#line 1151 "gitg-lanes.c"
				} else {
					gboolean _tmp66_ = FALSE;
					GitgLanesLaneContainer* _tmp67_ = NULL;
#line 281 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					_tmp67_ = mylane;
#line 281 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					if (_tmp67_ != NULL) {
#line 1159 "gitg-lanes.c"
						GitgLanesLaneContainer* _tmp68_ = NULL;
						GgitOId* _tmp69_ = NULL;
#line 281 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp68_ = mylane;
#line 281 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp69_ = _tmp68_->to;
#line 281 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp66_ = _tmp69_ == NULL;
#line 1168 "gitg-lanes.c"
					} else {
#line 281 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp66_ = FALSE;
#line 1172 "gitg-lanes.c"
					}
#line 281 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					if (_tmp66_) {
#line 1176 "gitg-lanes.c"
						GitgLanesLaneContainer* _tmp70_ = NULL;
						GgitOId* _tmp71_ = NULL;
						GgitOId* _tmp72_ = NULL;
						GitgLanesLaneContainer* _tmp73_ = NULL;
						GitgLane* _tmp74_ = NULL;
						GitgLanesLaneContainer* _tmp75_ = NULL;
						GitgLane* _tmp76_ = NULL;
						GitgColor* _tmp77_ = NULL;
						GitgColor* _tmp78_ = NULL;
#line 285 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp70_ = mylane;
#line 285 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp71_ = poid;
#line 285 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp72_ = __vala_GgitOId_copy0 (_tmp71_);
#line 285 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						__vala_GgitOId_free0 (_tmp70_->to);
#line 285 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp70_->to = _tmp72_;
#line 287 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp73_ = mylane;
#line 287 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp74_ = _tmp73_->lane;
#line 287 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp75_ = mylane;
#line 287 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp76_ = _tmp75_->lane;
#line 287 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp77_ = _tmp76_->color;
#line 287 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp78_ = gitg_color_copy (_tmp77_);
#line 287 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_g_object_unref0 (_tmp74_->color);
#line 287 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp74_->color = _tmp78_;
#line 1212 "gitg-lanes.c"
					} else {
						gboolean _tmp79_ = FALSE;
#line 289 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						_tmp79_ = hidden;
#line 289 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
						if (!_tmp79_) {
#line 1219 "gitg-lanes.c"
							GitgLanesLaneContainer* newlane = NULL;
							GgitOId* _tmp80_ = NULL;
							GgitOId* _tmp81_ = NULL;
							GitgLanesLaneContainer* _tmp82_ = NULL;
							GitgLanesLaneContainer* _tmp83_ = NULL;
							GitgLane* _tmp84_ = NULL;
							gint _tmp85_ = 0;
							GeeLinkedList* _tmp86_ = NULL;
							GitgLanesLaneContainer* _tmp87_ = NULL;
#line 292 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							_tmp80_ = myoid;
#line 292 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							_tmp81_ = poid;
#line 292 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							_tmp82_ = gitg_lanes_lane_container_new (_tmp80_, _tmp81_);
#line 292 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							newlane = _tmp82_;
#line 294 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							_tmp83_ = newlane;
#line 294 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							_tmp84_ = _tmp83_->lane;
#line 294 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							_tmp85_ = pos;
#line 294 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							_tmp84_->from = g_slist_prepend (_tmp84_->from, (gpointer) ((gintptr) _tmp85_));
#line 295 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							_tmp86_ = self->priv->d_lanes;
#line 295 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							_tmp87_ = newlane;
#line 295 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp86_, _tmp87_);
#line 289 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
							_gitg_lanes_lane_container_unref0 (newlane);
#line 1253 "gitg-lanes.c"
						}
					}
				}
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_gitg_lanes_lane_container_unref0 (container);
#line 222 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				__vala_GgitOId_free0 (poid);
#line 1261 "gitg-lanes.c"
			}
		}
	}
#line 299 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp89_ = mylane;
#line 299 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (_tmp89_ != NULL) {
#line 1269 "gitg-lanes.c"
		GitgLanesLaneContainer* _tmp90_ = NULL;
		GgitOId* _tmp91_ = NULL;
#line 299 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp90_ = mylane;
#line 299 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp91_ = _tmp90_->to;
#line 299 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp88_ = _tmp91_ == NULL;
#line 1278 "gitg-lanes.c"
	} else {
#line 299 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp88_ = FALSE;
#line 1282 "gitg-lanes.c"
	}
#line 299 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (_tmp88_) {
#line 1286 "gitg-lanes.c"
		GeeLinkedList* _tmp92_ = NULL;
		GitgLanesLaneContainer* _tmp93_ = NULL;
#line 302 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp92_ = self->priv->d_lanes;
#line 302 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp93_ = mylane;
#line 302 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp92_, _tmp93_);
#line 1295 "gitg-lanes.c"
	}
#line 306 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp94_ = self->priv->d_previous;
#line 306 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp95_ = g_slist_length (_tmp94_);
#line 306 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp96_ = self->priv->_inactive_collapse;
#line 306 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp97_ = self->priv->_inactive_gap;
#line 306 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (_tmp95_ == ((guint) ((_tmp96_ + _tmp97_) + 1))) {
#line 1307 "gitg-lanes.c"
		GSList* _tmp98_ = NULL;
		GSList* _tmp99_ = NULL;
#line 308 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp98_ = self->priv->d_previous;
#line 308 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp99_ = g_slist_last (_tmp98_);
#line 308 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		self->priv->d_previous = g_slist_delete_link (self->priv->d_previous, _tmp99_);
#line 1316 "gitg-lanes.c"
	}
#line 311 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp100_ = next;
#line 311 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self->priv->d_previous = g_slist_prepend (self->priv->d_previous, _tmp100_);
#line 214 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_gitg_lanes_lane_container_unref0 (mylane);
#line 214 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (myoid);
#line 214 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (parents);
#line 1328 "gitg-lanes.c"
}


static void gitg_lanes_add_collapsed (GitgLanes* self, GitgLanesLaneContainer* container, gint index) {
	GitgLanesCollapsedLane* collapsed = NULL;
	GitgLanesLaneContainer* _tmp0_ = NULL;
	GitgLanesCollapsedLane* _tmp1_ = NULL;
	GitgLanesCollapsedLane* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GHashTable* _tmp4_ = NULL;
	GitgLanesLaneContainer* _tmp5_ = NULL;
	GgitOId* _tmp6_ = NULL;
	GgitOId* _tmp7_ = NULL;
	GitgLanesCollapsedLane* _tmp8_ = NULL;
#line 314 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 314 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (container != NULL);
#line 317 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = container;
#line 317 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = gitg_lanes_collapsed_lane_new (_tmp0_);
#line 317 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	collapsed = _tmp1_;
#line 318 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = collapsed;
#line 318 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = index;
#line 318 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp2_->index = (guint) _tmp3_;
#line 320 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = self->priv->d_collapsed;
#line 320 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp5_ = container;
#line 320 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp6_ = _tmp5_->to;
#line 320 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp7_ = __vala_GgitOId_copy0 (_tmp6_);
#line 320 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp8_ = collapsed;
#line 320 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	collapsed = NULL;
#line 320 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_hash_table_insert (_tmp4_, _tmp7_, _tmp8_);
#line 314 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_gitg_lanes_collapsed_lane_free0 (collapsed);
#line 1375 "gitg-lanes.c"
}


static void gitg_lanes_collapse_lane (GitgLanes* self, GitgLanesLaneContainer* container, gint index) {
	GitgLanesLaneContainer* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSList* item = NULL;
	GSList* _tmp2_ = NULL;
#line 323 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 323 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (container != NULL);
#line 326 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = container;
#line 326 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = index;
#line 326 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_add_collapsed (self, _tmp0_, _tmp1_);
#line 328 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = self->priv->d_previous;
#line 328 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	item = _tmp2_;
#line 330 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	while (TRUE) {
#line 1400 "gitg-lanes.c"
		GSList* _tmp3_ = NULL;
		GitgCommit* commit = NULL;
		GSList* _tmp4_ = NULL;
		gconstpointer _tmp5_ = NULL;
		GitgCommit* _tmp6_ = NULL;
		GSList* lns = NULL;
		GitgCommit* _tmp7_ = NULL;
		GSList* _tmp8_ = NULL;
		GitgLane* lane = NULL;
		GSList* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gconstpointer _tmp11_ = NULL;
		GSList* _tmp12_ = NULL;
		GSList* _tmp13_ = NULL;
		GSList* _tmp42_ = NULL;
		GSList* _tmp43_ = NULL;
#line 330 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp3_ = item;
#line 330 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		if (!(_tmp3_ != NULL)) {
#line 330 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			break;
#line 1423 "gitg-lanes.c"
		}
#line 332 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = item;
#line 332 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp5_ = _tmp4_->data;
#line 332 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp6_ = _g_object_ref0 ((GitgCommit*) _tmp5_);
#line 332 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		commit = _tmp6_;
#line 333 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp7_ = commit;
#line 333 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp8_ = gitg_commit_get_lanes (_tmp7_);
#line 333 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		lns = _tmp8_;
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp9_ = lns;
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp10_ = index;
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp11_ = g_slist_nth_data (_tmp9_, (guint) _tmp10_);
#line 334 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		lane = (GitgLane*) _tmp11_;
#line 336 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp12_ = item;
#line 336 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp13_ = _tmp12_->next;
#line 336 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		if (_tmp13_ != NULL) {
#line 1453 "gitg-lanes.c"
			gint newindex = 0;
			GitgLane* _tmp14_ = NULL;
			GSList* _tmp15_ = NULL;
			gconstpointer _tmp16_ = NULL;
			GitgCommit* _tmp17_ = NULL;
			GitgLane* _tmp18_ = NULL;
			GSList* _tmp19_ = NULL;
			GSList* _tmp20_ = NULL;
			GSList* _tmp21_ = NULL;
			GSList* _tmp22_ = NULL;
			guint mylane = 0U;
			GitgCommit* _tmp25_ = NULL;
			guint _tmp26_ = 0U;
			guint _tmp27_ = 0U;
			guint _tmp28_ = 0U;
			gint _tmp29_ = 0;
			gint _tmp34_ = 0;
#line 338 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp14_ = lane;
#line 338 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp15_ = _tmp14_->from;
#line 338 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp16_ = _tmp15_->data;
#line 338 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			newindex = (gint) ((gintptr) _tmp16_);
#line 340 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp17_ = commit;
#line 340 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp18_ = lane;
#line 340 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp19_ = gitg_commit_remove_lane (_tmp17_, _tmp18_);
#line 340 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			lns = _tmp19_;
#line 342 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp20_ = item;
#line 342 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp21_ = _tmp20_->next;
#line 342 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp22_ = _tmp21_->next;
#line 342 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			if (_tmp22_ != NULL) {
#line 1495 "gitg-lanes.c"
				GSList* _tmp23_ = NULL;
				gint _tmp24_ = 0;
#line 344 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp23_ = lns;
#line 344 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp24_ = newindex;
#line 344 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				gitg_lanes_update_merge_indices (self, _tmp23_, _tmp24_, -1);
#line 1504 "gitg-lanes.c"
			}
#line 347 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp25_ = commit;
#line 347 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp26_ = gitg_commit_get_mylane (_tmp25_);
#line 347 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp27_ = _tmp26_;
#line 347 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			mylane = _tmp27_;
#line 349 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp28_ = mylane;
#line 349 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp29_ = index;
#line 349 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			if (_tmp28_ > ((guint) _tmp29_)) {
#line 1520 "gitg-lanes.c"
				GitgCommit* _tmp30_ = NULL;
				GitgCommit* _tmp31_ = NULL;
				guint _tmp32_ = 0U;
				guint _tmp33_ = 0U;
#line 351 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp30_ = commit;
#line 351 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp31_ = commit;
#line 351 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp32_ = gitg_commit_get_mylane (_tmp31_);
#line 351 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp33_ = _tmp32_;
#line 351 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				gitg_commit_set_mylane (_tmp31_, _tmp33_ - 1);
#line 1535 "gitg-lanes.c"
			}
#line 354 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp34_ = newindex;
#line 354 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			index = _tmp34_;
#line 1541 "gitg-lanes.c"
		} else {
			GitgLane* _tmp35_ = NULL;
			GitgLane* _tmp36_ = NULL;
			GitgLaneTag _tmp37_ = 0;
			GitgLane* _tmp38_ = NULL;
			GitgLanesLaneContainer* _tmp39_ = NULL;
			GgitOId* _tmp40_ = NULL;
			GgitOId* _tmp41_ = NULL;
#line 358 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp35_ = lane;
#line 358 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp36_ = lane;
#line 358 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp37_ = _tmp36_->tag;
#line 358 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp36_->tag = _tmp37_ | GITG_LANE_TAG_END;
#line 359 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp38_ = lane;
#line 359 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp39_ = container;
#line 359 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp40_ = _tmp39_->to;
#line 359 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp41_ = __vala_GgitOId_copy0 (_tmp40_);
#line 359 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			__vala_GgitOId_free0 (_tmp38_->boundary_id);
#line 359 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp38_->boundary_id = _tmp41_;
#line 1570 "gitg-lanes.c"
		}
#line 362 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp42_ = item;
#line 362 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp43_ = _tmp42_->next;
#line 362 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		item = _tmp43_;
#line 330 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (commit);
#line 1580 "gitg-lanes.c"
	}
}


static void gitg_lanes_collapse_lanes (GitgLanes* self) {
	gint index = 0;
	GeeIterator* iter = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	GeeIterator* _tmp1_ = NULL;
#line 366 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 368 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	index = 0;
#line 370 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->d_lanes;
#line 370 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
#line 370 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	iter = _tmp1_;
#line 372 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	while (TRUE) {
#line 1602 "gitg-lanes.c"
		GeeIterator* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		GitgLanesLaneContainer* container = NULL;
		GeeIterator* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		GitgLanesLaneContainer* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		GitgLanesLaneContainer* _tmp11_ = NULL;
		GitgLanesLaneContainer* _tmp12_ = NULL;
		GitgLane* _tmp13_ = NULL;
		GSList* _tmp14_ = NULL;
		gconstpointer _tmp15_ = NULL;
		gint _tmp16_ = 0;
		GeeIterator* _tmp17_ = NULL;
#line 372 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp2_ = iter;
#line 372 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp3_ = gee_iterator_next (_tmp2_);
#line 372 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		if (!_tmp3_) {
#line 372 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			break;
#line 1627 "gitg-lanes.c"
		}
#line 374 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = iter;
#line 374 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp5_ = gee_iterator_get (_tmp4_);
#line 374 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		container = (GitgLanesLaneContainer*) _tmp5_;
#line 376 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp6_ = container;
#line 376 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp7_ = _tmp6_->inactive;
#line 376 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp8_ = self->priv->_inactive_max;
#line 376 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp9_ = self->priv->_inactive_gap;
#line 376 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		if (_tmp7_ != (_tmp8_ + _tmp9_)) {
#line 1645 "gitg-lanes.c"
			gint _tmp10_ = 0;
#line 378 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp10_ = index;
#line 378 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			index = _tmp10_ + 1;
#line 379 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_gitg_lanes_lane_container_unref0 (container);
#line 379 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			continue;
#line 1655 "gitg-lanes.c"
		}
#line 382 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp11_ = container;
#line 382 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp12_ = container;
#line 382 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp13_ = _tmp12_->lane;
#line 382 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp14_ = _tmp13_->from;
#line 382 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp15_ = _tmp14_->data;
#line 382 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_collapse_lane (self, _tmp11_, (gint) ((gintptr) _tmp15_));
#line 383 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp16_ = index;
#line 383 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_update_current_lane_merge_indices (self, _tmp16_, -1);
#line 385 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp17_ = iter;
#line 385 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		gee_iterator_remove (_tmp17_);
#line 372 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_gitg_lanes_lane_container_unref0 (container);
#line 1679 "gitg-lanes.c"
	}
#line 366 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (iter);
#line 1683 "gitg-lanes.c"
}


static gint gitg_lanes_ensure_correct_index (GitgLanes* self, GitgCommit* commit, gint index) {
	gint result = 0;
	guint len = 0U;
	GitgCommit* _tmp0_ = NULL;
	GSList* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	gint _tmp3_ = 0;
	guint _tmp4_ = 0U;
#line 389 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 389 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (commit != NULL, 0);
#line 392 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = commit;
#line 392 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = gitg_commit_get_lanes (_tmp0_);
#line 392 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = g_slist_length (_tmp1_);
#line 392 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	len = _tmp2_;
#line 394 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = index;
#line 394 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = len;
#line 394 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (((guint) _tmp3_) > _tmp4_) {
#line 1713 "gitg-lanes.c"
		guint _tmp5_ = 0U;
#line 396 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp5_ = len;
#line 396 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		result = (gint) _tmp5_;
#line 396 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		return result;
#line 1721 "gitg-lanes.c"
	} else {
		gint _tmp6_ = 0;
#line 400 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp6_ = index;
#line 400 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		result = _tmp6_;
#line 400 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		return result;
#line 1730 "gitg-lanes.c"
	}
}


static void gitg_lanes_update_lane_merge_indices (GitgLanes* self, GSList* from, gint index, gint direction) {
#line 404 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 408 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	while (TRUE) {
#line 1740 "gitg-lanes.c"
		GSList* _tmp0_ = NULL;
		gint idx = 0;
		GSList* _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		GSList* _tmp13_ = NULL;
		GSList* _tmp14_ = NULL;
#line 408 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp0_ = from;
#line 408 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		if (!(_tmp0_ != NULL)) {
#line 408 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			break;
#line 1756 "gitg-lanes.c"
		}
#line 410 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp1_ = from;
#line 410 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp2_ = _tmp1_->data;
#line 410 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		idx = (gint) ((gintptr) _tmp2_);
#line 412 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = idx;
#line 412 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp5_ = index;
#line 412 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		if (_tmp4_ > _tmp5_) {
#line 412 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp3_ = TRUE;
#line 1772 "gitg-lanes.c"
		} else {
			gboolean _tmp6_ = FALSE;
			gint _tmp7_ = 0;
#line 412 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp7_ = direction;
#line 412 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			if (_tmp7_ > 0) {
#line 1780 "gitg-lanes.c"
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
#line 412 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp8_ = idx;
#line 412 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp9_ = index;
#line 412 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp6_ = _tmp8_ == _tmp9_;
#line 1789 "gitg-lanes.c"
			} else {
#line 412 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp6_ = FALSE;
#line 1793 "gitg-lanes.c"
			}
#line 412 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp3_ = _tmp6_;
#line 1797 "gitg-lanes.c"
		}
#line 412 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		if (_tmp3_) {
#line 1801 "gitg-lanes.c"
			GSList* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
#line 414 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp10_ = from;
#line 414 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp11_ = idx;
#line 414 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp12_ = direction;
#line 414 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp10_->data = (gpointer) ((gintptr) (_tmp11_ + _tmp12_));
#line 1813 "gitg-lanes.c"
		}
#line 417 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp13_ = from;
#line 417 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp14_ = _tmp13_->next;
#line 417 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		from = _tmp14_;
#line 1821 "gitg-lanes.c"
	}
}


static void gitg_lanes_update_merge_indices (GitgLanes* self, GSList* lanes, gint index, gint direction) {
	GSList* _tmp0_ = NULL;
#line 421 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 425 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = lanes;
#line 1832 "gitg-lanes.c"
	{
		GSList* lane_collection = NULL;
		GSList* lane_it = NULL;
#line 425 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		lane_collection = _tmp0_;
#line 425 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		for (lane_it = lane_collection; lane_it != NULL; lane_it = lane_it->next) {
#line 1840 "gitg-lanes.c"
			GitgLane* lane = NULL;
#line 425 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			lane = (GitgLane*) lane_it->data;
#line 1844 "gitg-lanes.c"
			{
				GitgLane* _tmp1_ = NULL;
				GSList* _tmp2_ = NULL;
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
#line 427 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp1_ = lane;
#line 427 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp2_ = _tmp1_->from;
#line 427 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp3_ = index;
#line 427 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp4_ = direction;
#line 427 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				gitg_lanes_update_lane_merge_indices (self, _tmp2_, _tmp3_, _tmp4_);
#line 1860 "gitg-lanes.c"
			}
		}
	}
}


static void gitg_lanes_update_current_lane_merge_indices (GitgLanes* self, gint index, gint direction) {
#line 430 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 1870 "gitg-lanes.c"
	{
		GeeLinkedList* _container_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _container_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _container_index = 0;
#line 433 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp0_ = self->priv->d_lanes;
#line 433 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 433 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_container_list = _tmp1_;
#line 433 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp2_ = _container_list;
#line 433 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 433 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = _tmp3_;
#line 433 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_container_size = _tmp4_;
#line 433 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_container_index = -1;
#line 433 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		while (TRUE) {
#line 1898 "gitg-lanes.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			GitgLanesLaneContainer* container = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			GitgLanesLaneContainer* _tmp11_ = NULL;
			GitgLane* _tmp12_ = NULL;
			GSList* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
#line 433 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp5_ = _container_index;
#line 433 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_container_index = _tmp5_ + 1;
#line 433 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp6_ = _container_index;
#line 433 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp7_ = _container_size;
#line 433 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 433 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				break;
#line 1923 "gitg-lanes.c"
			}
#line 433 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp8_ = _container_list;
#line 433 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp9_ = _container_index;
#line 433 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 433 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			container = (GitgLanesLaneContainer*) _tmp10_;
#line 435 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp11_ = container;
#line 435 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp12_ = _tmp11_->lane;
#line 435 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp13_ = _tmp12_->from;
#line 435 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp14_ = index;
#line 435 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp15_ = direction;
#line 435 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			gitg_lanes_update_lane_merge_indices (self, _tmp13_, _tmp14_, _tmp15_);
#line 433 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_gitg_lanes_lane_container_unref0 (container);
#line 1947 "gitg-lanes.c"
		}
#line 433 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (_container_list);
#line 1951 "gitg-lanes.c"
	}
}


static void gitg_lanes_expand_lane (GitgLanes* self, GitgLanesCollapsedLane* lane) {
	guint index = 0U;
	GitgLanesCollapsedLane* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GitgLane* ln = NULL;
	GitgLanesCollapsedLane* _tmp2_ = NULL;
	GitgColor* _tmp3_ = NULL;
	GitgLane* _tmp4_ = NULL;
	gint len = 0;
	GeeLinkedList* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	guint _tmp8_ = 0U;
	gint _tmp9_ = 0;
	gint next = 0;
	GSList* _tmp11_ = NULL;
	gconstpointer _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	gint _tmp14_ = 0;
	GitgLanesLaneContainer* container = NULL;
	GitgLanesCollapsedLane* _tmp15_ = NULL;
	GgitOId* _tmp16_ = NULL;
	GitgLanesCollapsedLane* _tmp17_ = NULL;
	GgitOId* _tmp18_ = NULL;
	GitgLanesCollapsedLane* _tmp19_ = NULL;
	GitgColor* _tmp20_ = NULL;
	GitgLanesLaneContainer* _tmp21_ = NULL;
	guint _tmp22_ = 0U;
	GitgLanesLaneContainer* _tmp23_ = NULL;
	GitgLane* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	GeeLinkedList* _tmp26_ = NULL;
	guint _tmp27_ = 0U;
	GitgLanesLaneContainer* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	guint cnt = 0U;
	GSList* ptr = NULL;
	GSList* _tmp30_ = NULL;
#line 441 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 441 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (lane != NULL);
#line 443 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = lane;
#line 443 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = _tmp0_->index;
#line 443 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	index = _tmp1_;
#line 444 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = lane;
#line 444 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = _tmp2_->color;
#line 444 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = gitg_lane_new_with_color (_tmp3_);
#line 444 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	ln = _tmp4_;
#line 445 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp5_ = self->priv->d_lanes;
#line 445 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp6_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp5_);
#line 445 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp7_ = _tmp6_;
#line 445 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	len = _tmp7_;
#line 447 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp8_ = index;
#line 447 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp9_ = len;
#line 447 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (_tmp8_ > ((guint) _tmp9_)) {
#line 2026 "gitg-lanes.c"
		gint _tmp10_ = 0;
#line 449 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp10_ = len;
#line 449 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		index = (guint) _tmp10_;
#line 2032 "gitg-lanes.c"
	}
#line 452 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp11_ = self->priv->d_previous;
#line 452 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp12_ = _tmp11_->data;
#line 452 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp13_ = index;
#line 452 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp14_ = gitg_lanes_ensure_correct_index (self, (GitgCommit*) _tmp12_, (gint) _tmp13_);
#line 452 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	next = _tmp14_;
#line 454 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp15_ = lane;
#line 454 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp16_ = _tmp15_->from;
#line 454 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp17_ = lane;
#line 454 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp18_ = _tmp17_->to;
#line 454 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp19_ = lane;
#line 454 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp20_ = _tmp19_->color;
#line 454 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp21_ = gitg_lanes_lane_container_new_with_color (_tmp16_, _tmp18_, _tmp20_);
#line 454 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	container = _tmp21_;
#line 458 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp22_ = index;
#line 458 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_update_current_lane_merge_indices (self, (gint) _tmp22_, 1);
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp23_ = container;
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp24_ = _tmp23_->lane;
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp25_ = next;
#line 460 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp24_->from = g_slist_prepend (_tmp24_->from, (gpointer) ((gintptr) _tmp25_));
#line 461 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp26_ = self->priv->d_lanes;
#line 461 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp27_ = index;
#line 461 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp28_ = container;
#line 461 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	gee_abstract_list_insert ((GeeAbstractList*) _tmp26_, (gint) _tmp27_, _tmp28_);
#line 463 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp29_ = next;
#line 463 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	index = (guint) _tmp29_;
#line 464 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	cnt = (guint) 0;
#line 466 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp30_ = self->priv->d_previous;
#line 466 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	ptr = _tmp30_;
#line 468 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	while (TRUE) {
#line 2092 "gitg-lanes.c"
		GSList* _tmp31_ = NULL;
		GitgCommit* commit = NULL;
		GSList* _tmp32_ = NULL;
		gconstpointer _tmp33_ = NULL;
		GitgCommit* _tmp34_ = NULL;
		guint _tmp35_ = 0U;
		gint _tmp36_ = 0;
		GitgLane* copy = NULL;
		GitgLane* _tmp37_ = NULL;
		GitgLane* _tmp38_ = NULL;
		GSList* lns = NULL;
		GitgCommit* _tmp39_ = NULL;
		GSList* _tmp40_ = NULL;
		gboolean _tmp41_ = FALSE;
		GSList* _tmp42_ = NULL;
		GSList* _tmp43_ = NULL;
		GitgCommit* _tmp62_ = NULL;
		GitgLane* _tmp63_ = NULL;
		guint _tmp64_ = 0U;
		guint mylane = 0U;
		GitgCommit* _tmp65_ = NULL;
		guint _tmp66_ = 0U;
		guint _tmp67_ = 0U;
		guint _tmp68_ = 0U;
		guint _tmp69_ = 0U;
		gint _tmp74_ = 0;
		guint _tmp75_ = 0U;
		GSList* _tmp76_ = NULL;
		GSList* _tmp77_ = NULL;
#line 468 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp31_ = ptr;
#line 468 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		if (!(_tmp31_ != NULL)) {
#line 468 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			break;
#line 2128 "gitg-lanes.c"
		}
#line 470 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp32_ = ptr;
#line 470 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp33_ = _tmp32_->data;
#line 470 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp34_ = _g_object_ref0 ((GitgCommit*) _tmp33_);
#line 470 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		commit = _tmp34_;
#line 472 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp35_ = cnt;
#line 472 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp36_ = self->priv->_inactive_collapse;
#line 472 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		if (_tmp35_ == ((guint) _tmp36_)) {
#line 474 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_g_object_unref0 (commit);
#line 474 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			break;
#line 2148 "gitg-lanes.c"
		}
#line 478 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp37_ = ln;
#line 478 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp38_ = gitg_lane_copy (_tmp37_);
#line 478 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		copy = _tmp38_;
#line 479 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp39_ = commit;
#line 479 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp40_ = gitg_commit_get_lanes (_tmp39_);
#line 479 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		lns = _tmp40_;
#line 481 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp42_ = ptr;
#line 481 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp43_ = _tmp42_->next;
#line 481 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		if (_tmp43_ == NULL) {
#line 481 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp41_ = TRUE;
#line 2170 "gitg-lanes.c"
		} else {
			guint _tmp44_ = 0U;
			gint _tmp45_ = 0;
#line 481 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp44_ = cnt;
#line 481 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp45_ = self->priv->_inactive_collapse;
#line 481 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp41_ = (_tmp44_ + 1) == ((guint) _tmp45_);
#line 2180 "gitg-lanes.c"
		}
#line 481 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		if (_tmp41_) {
#line 2184 "gitg-lanes.c"
			GitgLane* _tmp46_ = NULL;
			GitgLanesCollapsedLane* _tmp47_ = NULL;
			GgitOId* _tmp48_ = NULL;
			GgitOId* _tmp49_ = NULL;
			GitgLane* _tmp50_ = NULL;
			GitgLane* _tmp51_ = NULL;
			GitgLaneTag _tmp52_ = 0;
#line 483 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp46_ = copy;
#line 483 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp47_ = lane;
#line 483 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp48_ = _tmp47_->from;
#line 483 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp49_ = __vala_GgitOId_copy0 (_tmp48_);
#line 483 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			__vala_GgitOId_free0 (_tmp46_->boundary_id);
#line 483 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp46_->boundary_id = _tmp49_;
#line 484 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp50_ = copy;
#line 484 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp51_ = copy;
#line 484 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp52_ = _tmp51_->tag;
#line 484 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp51_->tag = _tmp52_ | GITG_LANE_TAG_START;
#line 2212 "gitg-lanes.c"
		} else {
			GSList* _tmp53_ = NULL;
			GSList* _tmp54_ = NULL;
			gconstpointer _tmp55_ = NULL;
			guint _tmp56_ = 0U;
			gint _tmp57_ = 0;
			GitgLane* _tmp58_ = NULL;
			gint _tmp59_ = 0;
			GSList* _tmp60_ = NULL;
			guint _tmp61_ = 0U;
#line 488 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp53_ = ptr;
#line 488 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp54_ = _tmp53_->next;
#line 488 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp55_ = _tmp54_->data;
#line 488 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp56_ = index;
#line 488 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp57_ = gitg_lanes_ensure_correct_index (self, (GitgCommit*) _tmp55_, (gint) _tmp56_);
#line 488 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			next = _tmp57_;
#line 489 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp58_ = copy;
#line 489 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp59_ = next;
#line 489 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp58_->from = g_slist_prepend (_tmp58_->from, (gpointer) ((gintptr) _tmp59_));
#line 491 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp60_ = lns;
#line 491 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp61_ = index;
#line 491 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			gitg_lanes_update_merge_indices (self, _tmp60_, (gint) _tmp61_, 1);
#line 2247 "gitg-lanes.c"
		}
#line 494 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp62_ = commit;
#line 494 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp63_ = copy;
#line 494 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp64_ = index;
#line 494 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		gitg_commit_insert_lane (_tmp62_, _tmp63_, (gint) _tmp64_);
#line 496 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp65_ = commit;
#line 496 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp66_ = gitg_commit_get_mylane (_tmp65_);
#line 496 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp67_ = _tmp66_;
#line 496 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		mylane = _tmp67_;
#line 498 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp68_ = mylane;
#line 498 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp69_ = index;
#line 498 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		if (_tmp68_ >= _tmp69_) {
#line 2271 "gitg-lanes.c"
			GitgCommit* _tmp70_ = NULL;
			GitgCommit* _tmp71_ = NULL;
			guint _tmp72_ = 0U;
			guint _tmp73_ = 0U;
#line 500 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp70_ = commit;
#line 500 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp71_ = commit;
#line 500 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp72_ = gitg_commit_get_mylane (_tmp71_);
#line 500 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp73_ = _tmp72_;
#line 500 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			gitg_commit_set_mylane (_tmp71_, _tmp73_ + 1);
#line 2286 "gitg-lanes.c"
		}
#line 503 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp74_ = next;
#line 503 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		index = (guint) _tmp74_;
#line 504 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp75_ = cnt;
#line 504 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		cnt = _tmp75_ + 1;
#line 506 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp76_ = ptr;
#line 506 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp77_ = _tmp76_->next;
#line 506 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		ptr = _tmp77_;
#line 468 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (copy);
#line 468 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (commit);
#line 2306 "gitg-lanes.c"
	}
#line 441 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_gitg_lanes_lane_container_unref0 (container);
#line 441 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (ln);
#line 2312 "gitg-lanes.c"
}


static void gitg_lanes_expand_lane_from_oid (GitgLanes* self, GgitOId* id) {
	GitgLanesCollapsedLane* collapsed = NULL;
	GHashTable* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	GitgLanesCollapsedLane* _tmp3_ = NULL;
#line 510 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 510 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (id != NULL);
#line 512 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->d_collapsed;
#line 512 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = id;
#line 512 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
#line 512 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	collapsed = (GitgLanesCollapsedLane*) _tmp2_;
#line 514 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = collapsed;
#line 514 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (_tmp3_ != NULL) {
#line 2338 "gitg-lanes.c"
		GitgLanesCollapsedLane* _tmp4_ = NULL;
		GHashTable* _tmp5_ = NULL;
		GgitOId* _tmp6_ = NULL;
#line 516 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = collapsed;
#line 516 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_expand_lane (self, _tmp4_);
#line 517 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp5_ = self->priv->d_collapsed;
#line 517 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp6_ = id;
#line 517 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		g_hash_table_remove (_tmp5_, _tmp6_);
#line 2352 "gitg-lanes.c"
	}
}


static void gitg_lanes_expand_lanes (GitgLanes* self, GitgCommit* commit) {
	GitgCommit* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
	GgitCommitParents* parents = NULL;
	GitgCommit* _tmp3_ = NULL;
	GgitCommitParents* _tmp4_ = NULL;
#line 521 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 521 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (commit != NULL);
#line 523 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = commit;
#line 523 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = ggit_object_get_id ((GgitObject*) _tmp0_);
#line 523 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = _tmp1_;
#line 523 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_expand_lane_from_oid (self, _tmp2_);
#line 523 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (_tmp2_);
#line 525 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = commit;
#line 525 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = ggit_commit_get_parents ((GgitCommit*) _tmp3_);
#line 525 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	parents = _tmp4_;
#line 2384 "gitg-lanes.c"
	{
		guint i = 0U;
#line 527 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		i = (guint) 0;
#line 2389 "gitg-lanes.c"
		{
			gboolean _tmp5_ = FALSE;
#line 527 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp5_ = TRUE;
#line 527 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			while (TRUE) {
#line 2396 "gitg-lanes.c"
				guint _tmp7_ = 0U;
				GgitCommitParents* _tmp8_ = NULL;
				guint _tmp9_ = 0U;
				guint _tmp10_ = 0U;
				GgitCommitParents* _tmp11_ = NULL;
				guint _tmp12_ = 0U;
				GgitOId* _tmp13_ = NULL;
				GgitOId* _tmp14_ = NULL;
#line 527 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				if (!_tmp5_) {
#line 2407 "gitg-lanes.c"
					guint _tmp6_ = 0U;
#line 527 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					_tmp6_ = i;
#line 527 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					i = _tmp6_ + 1;
#line 2413 "gitg-lanes.c"
				}
#line 527 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp5_ = FALSE;
#line 527 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp7_ = i;
#line 527 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp8_ = parents;
#line 527 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp9_ = ggit_commit_parents_get_size (_tmp8_);
#line 527 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp10_ = _tmp9_;
#line 527 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				if (!(_tmp7_ < _tmp10_)) {
#line 527 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					break;
#line 2429 "gitg-lanes.c"
				}
#line 529 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp11_ = parents;
#line 529 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp12_ = i;
#line 529 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp13_ = ggit_commit_parents_get_id (_tmp11_, _tmp12_);
#line 529 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp14_ = _tmp13_;
#line 529 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				gitg_lanes_expand_lane_from_oid (self, _tmp14_);
#line 529 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				__vala_GgitOId_free0 (_tmp14_);
#line 2443 "gitg-lanes.c"
			}
		}
	}
#line 521 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (parents);
#line 2449 "gitg-lanes.c"
}


static void gitg_lanes_init_next_layer (GitgLanes* self) {
	gint index = 0;
#line 533 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 535 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	index = 0;
#line 2459 "gitg-lanes.c"
	{
		GeeLinkedList* _container_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _container_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _container_index = 0;
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp0_ = self->priv->d_lanes;
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_container_list = _tmp1_;
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp2_ = _container_list;
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = _tmp3_;
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_container_size = _tmp4_;
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_container_index = -1;
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		while (TRUE) {
#line 2487 "gitg-lanes.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			GitgLanesLaneContainer* container = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			GitgLanesLaneContainer* _tmp11_ = NULL;
			gint _tmp12_ = 0;
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp5_ = _container_index;
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_container_index = _tmp5_ + 1;
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp6_ = _container_index;
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp7_ = _container_size;
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				break;
#line 2509 "gitg-lanes.c"
			}
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp8_ = _container_list;
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp9_ = _container_index;
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			container = (GitgLanesLaneContainer*) _tmp10_;
#line 539 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp11_ = container;
#line 539 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp12_ = index;
#line 539 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			index = _tmp12_ + 1;
#line 539 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			gitg_lanes_lane_container_next (_tmp11_, _tmp12_);
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_gitg_lanes_lane_container_unref0 (container);
#line 2529 "gitg-lanes.c"
		}
#line 537 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (_container_list);
#line 2533 "gitg-lanes.c"
	}
}


static GitgLanesLaneContainer* gitg_lanes_find_lane_by_oid (GitgLanes* self, GgitOId* id, gint* pos) {
	gint _vala_pos = 0;
	GitgLanesLaneContainer* result = NULL;
	gint p = 0;
#line 543 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 543 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 546 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	p = 0;
#line 2548 "gitg-lanes.c"
	{
		GeeLinkedList* _container_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _container_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _container_index = 0;
#line 548 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp0_ = self->priv->d_lanes;
#line 548 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 548 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_container_list = _tmp1_;
#line 548 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp2_ = _container_list;
#line 548 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 548 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = _tmp3_;
#line 548 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_container_size = _tmp4_;
#line 548 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_container_index = -1;
#line 548 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		while (TRUE) {
#line 2576 "gitg-lanes.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			GitgLanesLaneContainer* container = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			GitgLanesLaneContainer* _tmp12_ = NULL;
			gint _tmp18_ = 0;
#line 548 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp5_ = _container_index;
#line 548 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_container_index = _tmp5_ + 1;
#line 548 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp6_ = _container_index;
#line 548 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp7_ = _container_size;
#line 548 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 548 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				break;
#line 2599 "gitg-lanes.c"
			}
#line 548 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp8_ = _container_list;
#line 548 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp9_ = _container_index;
#line 548 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 548 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			container = (GitgLanesLaneContainer*) _tmp10_;
#line 550 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp12_ = container;
#line 550 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			if (_tmp12_ != NULL) {
#line 2613 "gitg-lanes.c"
				GgitOId* _tmp13_ = NULL;
				GitgLanesLaneContainer* _tmp14_ = NULL;
				GgitOId* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
#line 551 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp13_ = id;
#line 551 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp14_ = container;
#line 551 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp15_ = _tmp14_->to;
#line 551 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp16_ = ggit_oid_equal (_tmp13_, _tmp15_);
#line 551 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp11_ = _tmp16_;
#line 2628 "gitg-lanes.c"
			} else {
#line 550 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp11_ = FALSE;
#line 2632 "gitg-lanes.c"
			}
#line 550 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			if (_tmp11_) {
#line 2636 "gitg-lanes.c"
				gint _tmp17_ = 0;
#line 553 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_tmp17_ = p;
#line 553 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_vala_pos = _tmp17_;
#line 554 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				result = container;
#line 554 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				_g_object_unref0 (_container_list);
#line 554 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				if (pos) {
#line 554 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
					*pos = _vala_pos;
#line 2650 "gitg-lanes.c"
				}
#line 554 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				return result;
#line 2654 "gitg-lanes.c"
			}
#line 557 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp18_ = p;
#line 557 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			p = _tmp18_ + 1;
#line 548 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_gitg_lanes_lane_container_unref0 (container);
#line 2662 "gitg-lanes.c"
		}
#line 548 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (_container_list);
#line 2666 "gitg-lanes.c"
	}
#line 560 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_vala_pos = -1;
#line 561 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	result = NULL;
#line 561 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (pos) {
#line 561 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		*pos = _vala_pos;
#line 2676 "gitg-lanes.c"
	}
#line 561 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 2680 "gitg-lanes.c"
}


static GSList* gitg_lanes_lanes_list (GitgLanes* self) {
	GSList* result = NULL;
	GSList* ret = NULL;
#line 564 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 566 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	ret = NULL;
#line 2691 "gitg-lanes.c"
	{
		GeeLinkedList* _container_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _container_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _container_index = 0;
#line 568 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp0_ = self->priv->d_lanes;
#line 568 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 568 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_container_list = _tmp1_;
#line 568 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp2_ = _container_list;
#line 568 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 568 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = _tmp3_;
#line 568 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_container_size = _tmp4_;
#line 568 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_container_index = -1;
#line 568 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		while (TRUE) {
#line 2719 "gitg-lanes.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			GitgLanesLaneContainer* container = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			GitgLanesLaneContainer* _tmp11_ = NULL;
			GitgLane* _tmp12_ = NULL;
			GitgLane* _tmp13_ = NULL;
#line 568 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp5_ = _container_index;
#line 568 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_container_index = _tmp5_ + 1;
#line 568 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp6_ = _container_index;
#line 568 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp7_ = _container_size;
#line 568 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 568 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
				break;
#line 2742 "gitg-lanes.c"
			}
#line 568 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp8_ = _container_list;
#line 568 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp9_ = _container_index;
#line 568 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 568 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			container = (GitgLanesLaneContainer*) _tmp10_;
#line 570 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp11_ = container;
#line 570 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp12_ = _tmp11_->lane;
#line 570 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_tmp13_ = gitg_lane_copy (_tmp12_);
#line 570 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			ret = g_slist_prepend (ret, _tmp13_);
#line 568 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			_gitg_lanes_lane_container_unref0 (container);
#line 2762 "gitg-lanes.c"
		}
#line 568 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_g_object_unref0 (_container_list);
#line 2766 "gitg-lanes.c"
	}
#line 573 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	ret = g_slist_reverse (ret);
#line 574 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	result = ret;
#line 574 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 2774 "gitg-lanes.c"
}


gint gitg_lanes_get_inactive_max (GitgLanes* self) {
	gint result;
	gint _tmp0_ = 0;
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->_inactive_max;
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	result = _tmp0_;
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 2789 "gitg-lanes.c"
}


void gitg_lanes_set_inactive_max (GitgLanes* self, gint value) {
	gint _tmp0_ = 0;
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = value;
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self->priv->_inactive_max = _tmp0_;
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_object_notify ((GObject *) self, "inactive-max");
#line 2803 "gitg-lanes.c"
}


gint gitg_lanes_get_inactive_collapse (GitgLanes* self) {
	gint result;
	gint _tmp0_ = 0;
#line 26 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 26 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->_inactive_collapse;
#line 26 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	result = _tmp0_;
#line 26 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 2818 "gitg-lanes.c"
}


void gitg_lanes_set_inactive_collapse (GitgLanes* self, gint value) {
	gint _tmp0_ = 0;
#line 26 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 26 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = value;
#line 26 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self->priv->_inactive_collapse = _tmp0_;
#line 26 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_object_notify ((GObject *) self, "inactive-collapse");
#line 2832 "gitg-lanes.c"
}


gint gitg_lanes_get_inactive_gap (GitgLanes* self) {
	gint result;
	gint _tmp0_ = 0;
#line 27 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 27 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->_inactive_gap;
#line 27 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	result = _tmp0_;
#line 27 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 2847 "gitg-lanes.c"
}


void gitg_lanes_set_inactive_gap (GitgLanes* self, gint value) {
	gint _tmp0_ = 0;
#line 27 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 27 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = value;
#line 27 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self->priv->_inactive_gap = _tmp0_;
#line 27 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_object_notify ((GObject *) self, "inactive-gap");
#line 2861 "gitg-lanes.c"
}


gboolean gitg_lanes_get_inactive_enabled (GitgLanes* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->priv->_inactive_enabled;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	result = _tmp0_;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 2876 "gitg-lanes.c"
}


void gitg_lanes_set_inactive_enabled (GitgLanes* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = value;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self->priv->_inactive_enabled = _tmp0_;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_object_notify ((GObject *) self, "inactive-enabled");
#line 2890 "gitg-lanes.c"
}


static GitgLanesLaneContainer* gitg_lanes_lane_container_construct_with_color (GType object_type, GgitOId* from, GgitOId* to, GitgColor* color) {
	GitgLanesLaneContainer* self = NULL;
	GgitOId* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
	GgitOId* _tmp3_ = NULL;
	GitgColor* _tmp4_ = NULL;
	GitgLane* _tmp5_ = NULL;
#line 42 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self = (GitgLanesLaneContainer*) g_type_create_instance (object_type);
#line 46 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = from;
#line 46 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = __vala_GgitOId_copy0 (_tmp0_);
#line 46 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->from);
#line 46 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self->from = _tmp1_;
#line 47 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = to;
#line 47 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = __vala_GgitOId_copy0 (_tmp2_);
#line 47 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->to);
#line 47 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self->to = _tmp3_;
#line 48 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = color;
#line 48 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp5_ = gitg_lane_new_with_color (_tmp4_);
#line 48 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->lane);
#line 48 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self->lane = _tmp5_;
#line 49 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self->inactive = 0;
#line 42 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	return self;
#line 2932 "gitg-lanes.c"
}


static GitgLanesLaneContainer* gitg_lanes_lane_container_new_with_color (GgitOId* from, GgitOId* to, GitgColor* color) {
#line 42 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	return gitg_lanes_lane_container_construct_with_color (GITG_LANES_TYPE_LANE_CONTAINER, from, to, color);
#line 2939 "gitg-lanes.c"
}


static GitgLanesLaneContainer* gitg_lanes_lane_container_construct (GType object_type, GgitOId* from, GgitOId* to) {
	GitgLanesLaneContainer* self = NULL;
	GgitOId* _tmp0_ = NULL;
	GgitOId* _tmp1_ = NULL;
#line 55 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = from;
#line 55 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = to;
#line 55 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self = (GitgLanesLaneContainer*) gitg_lanes_lane_container_construct_with_color (object_type, _tmp0_, _tmp1_, NULL);
#line 52 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	return self;
#line 2955 "gitg-lanes.c"
}


static GitgLanesLaneContainer* gitg_lanes_lane_container_new (GgitOId* from, GgitOId* to) {
#line 52 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	return gitg_lanes_lane_container_construct (GITG_LANES_TYPE_LANE_CONTAINER, from, to);
#line 2962 "gitg-lanes.c"
}


static void gitg_lanes_lane_container_next (GitgLanesLaneContainer* self, gint index) {
	gboolean hidden = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GitgLane* _tmp2_ = NULL;
	GitgLane* _tmp3_ = NULL;
	GitgLane* _tmp4_ = NULL;
	GitgLane* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	GgitOId* _tmp11_ = NULL;
#line 58 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 60 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = gitg_lanes_lane_container_get_is_hidden (self);
#line 60 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = _tmp0_;
#line 60 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	hidden = _tmp1_;
#line 61 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = self->lane;
#line 61 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = gitg_lane_copy (_tmp2_);
#line 61 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->lane);
#line 61 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self->lane = _tmp3_;
#line 63 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = self->lane;
#line 63 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp4_->tag = GITG_LANE_TAG_NONE;
#line 64 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp5_ = self->lane;
#line 64 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_g_slist_free0 (_tmp5_->from);
#line 64 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp5_->from = NULL;
#line 66 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp6_ = hidden;
#line 66 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (!_tmp6_) {
#line 3008 "gitg-lanes.c"
		GitgLane* _tmp7_ = NULL;
		gint _tmp8_ = 0;
#line 68 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp7_ = self->lane;
#line 68 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp8_ = index;
#line 68 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp7_->from = g_slist_prepend (_tmp7_->from, (gpointer) ((gintptr) _tmp8_));
#line 3017 "gitg-lanes.c"
	}
#line 71 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp9_ = hidden;
#line 71 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_lane_container_set_is_hidden (self, _tmp9_);
#line 73 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp11_ = self->to;
#line 73 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (_tmp11_ != NULL) {
#line 3027 "gitg-lanes.c"
		gint _tmp12_ = 0;
#line 73 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp12_ = self->inactive;
#line 73 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp10_ = _tmp12_ >= 0;
#line 3033 "gitg-lanes.c"
	} else {
#line 73 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp10_ = FALSE;
#line 3037 "gitg-lanes.c"
	}
#line 73 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (_tmp10_) {
#line 3041 "gitg-lanes.c"
		gint _tmp13_ = 0;
#line 75 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp13_ = self->inactive;
#line 75 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		self->inactive = _tmp13_ + 1;
#line 3047 "gitg-lanes.c"
	}
}


static gboolean gitg_lanes_lane_container_get_is_hidden (GitgLanesLaneContainer* self) {
	gboolean result;
	GitgLane* _tmp0_ = NULL;
	GitgLaneTag _tmp1_ = 0;
#line 81 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 81 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = self->lane;
#line 81 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = _tmp0_->tag;
#line 81 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	result = (_tmp1_ & GITG_LANE_TAG_HIDDEN) != 0;
#line 81 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	return result;
#line 3066 "gitg-lanes.c"
}


static void gitg_lanes_lane_container_set_is_hidden (GitgLanesLaneContainer* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 82 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (self != NULL);
#line 84 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = value;
#line 84 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (_tmp0_) {
#line 3078 "gitg-lanes.c"
		GitgLane* _tmp1_ = NULL;
		GitgLane* _tmp2_ = NULL;
		GitgLaneTag _tmp3_ = 0;
#line 86 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp1_ = self->lane;
#line 86 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp2_ = self->lane;
#line 86 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp3_ = _tmp2_->tag;
#line 86 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp2_->tag = _tmp3_ | GITG_LANE_TAG_HIDDEN;
#line 3090 "gitg-lanes.c"
	} else {
		GitgLane* _tmp4_ = NULL;
		GitgLane* _tmp5_ = NULL;
		GitgLaneTag _tmp6_ = 0;
#line 90 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp4_ = self->lane;
#line 90 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp5_ = self->lane;
#line 90 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp6_ = _tmp5_->tag;
#line 90 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		_tmp5_->tag = _tmp6_ & (~GITG_LANE_TAG_HIDDEN);
#line 3103 "gitg-lanes.c"
	}
}


static void gitg_lanes_value_lane_container_init (GValue* value) {
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	value->data[0].v_pointer = NULL;
#line 3111 "gitg-lanes.c"
}


static void gitg_lanes_value_lane_container_free_value (GValue* value) {
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (value->data[0].v_pointer) {
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_lane_container_unref (value->data[0].v_pointer);
#line 3120 "gitg-lanes.c"
	}
}


static void gitg_lanes_value_lane_container_copy_value (const GValue* src_value, GValue* dest_value) {
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (src_value->data[0].v_pointer) {
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		dest_value->data[0].v_pointer = gitg_lanes_lane_container_ref (src_value->data[0].v_pointer);
#line 3130 "gitg-lanes.c"
	} else {
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3134 "gitg-lanes.c"
	}
}


static gpointer gitg_lanes_value_lane_container_peek_pointer (const GValue* value) {
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	return value->data[0].v_pointer;
#line 3142 "gitg-lanes.c"
}


static gchar* gitg_lanes_value_lane_container_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (collect_values[0].v_pointer) {
#line 3149 "gitg-lanes.c"
		GitgLanesLaneContainer* object;
		object = collect_values[0].v_pointer;
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		if (object->parent_instance.g_class == NULL) {
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3156 "gitg-lanes.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3160 "gitg-lanes.c"
		}
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		value->data[0].v_pointer = gitg_lanes_lane_container_ref (object);
#line 3164 "gitg-lanes.c"
	} else {
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		value->data[0].v_pointer = NULL;
#line 3168 "gitg-lanes.c"
	}
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	return NULL;
#line 3172 "gitg-lanes.c"
}


static gchar* gitg_lanes_value_lane_container_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GitgLanesLaneContainer** object_p;
	object_p = collect_values[0].v_pointer;
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (!object_p) {
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3183 "gitg-lanes.c"
	}
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (!value->data[0].v_pointer) {
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		*object_p = NULL;
#line 3189 "gitg-lanes.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		*object_p = value->data[0].v_pointer;
#line 3193 "gitg-lanes.c"
	} else {
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		*object_p = gitg_lanes_lane_container_ref (value->data[0].v_pointer);
#line 3197 "gitg-lanes.c"
	}
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	return NULL;
#line 3201 "gitg-lanes.c"
}


static GParamSpec* gitg_lanes_param_spec_lane_container (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GitgLanesParamSpecLaneContainer* spec;
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (g_type_is_a (object_type, GITG_LANES_TYPE_LANE_CONTAINER), NULL);
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	return G_PARAM_SPEC (spec);
#line 3215 "gitg-lanes.c"
}


static gpointer gitg_lanes_value_get_lane_container (const GValue* value) {
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_LANES_TYPE_LANE_CONTAINER), NULL);
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	return value->data[0].v_pointer;
#line 3224 "gitg-lanes.c"
}


static void gitg_lanes_value_set_lane_container (GValue* value, gpointer v_object) {
	GitgLanesLaneContainer* old;
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_LANES_TYPE_LANE_CONTAINER));
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	old = value->data[0].v_pointer;
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (v_object) {
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_LANES_TYPE_LANE_CONTAINER));
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		value->data[0].v_pointer = v_object;
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_lane_container_ref (value->data[0].v_pointer);
#line 3244 "gitg-lanes.c"
	} else {
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		value->data[0].v_pointer = NULL;
#line 3248 "gitg-lanes.c"
	}
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (old) {
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_lane_container_unref (old);
#line 3254 "gitg-lanes.c"
	}
}


static void gitg_lanes_value_take_lane_container (GValue* value, gpointer v_object) {
	GitgLanesLaneContainer* old;
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_LANES_TYPE_LANE_CONTAINER));
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	old = value->data[0].v_pointer;
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (v_object) {
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_LANES_TYPE_LANE_CONTAINER));
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		value->data[0].v_pointer = v_object;
#line 3273 "gitg-lanes.c"
	} else {
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		value->data[0].v_pointer = NULL;
#line 3277 "gitg-lanes.c"
	}
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (old) {
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_lane_container_unref (old);
#line 3283 "gitg-lanes.c"
	}
}


static void gitg_lanes_lane_container_class_init (GitgLanesLaneContainerClass * klass) {
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_lane_container_parent_class = g_type_class_peek_parent (klass);
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	((GitgLanesLaneContainerClass *) klass)->finalize = gitg_lanes_lane_container_finalize;
#line 3293 "gitg-lanes.c"
}


static void gitg_lanes_lane_container_instance_init (GitgLanesLaneContainer * self) {
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self->ref_count = 1;
#line 3300 "gitg-lanes.c"
}


static void gitg_lanes_lane_container_finalize (GitgLanesLaneContainer* obj) {
	GitgLanesLaneContainer * self;
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_LANES_TYPE_LANE_CONTAINER, GitgLanesLaneContainer);
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_signal_handlers_destroy (self);
#line 37 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->lane);
#line 39 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->from);
#line 40 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->to);
#line 3316 "gitg-lanes.c"
}


static GType gitg_lanes_lane_container_get_type (void) {
	static volatile gsize gitg_lanes_lane_container_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_lanes_lane_container_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gitg_lanes_value_lane_container_init, gitg_lanes_value_lane_container_free_value, gitg_lanes_value_lane_container_copy_value, gitg_lanes_value_lane_container_peek_pointer, "p", gitg_lanes_value_lane_container_collect_value, "p", gitg_lanes_value_lane_container_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GitgLanesLaneContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_lanes_lane_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgLanesLaneContainer), 0, (GInstanceInitFunc) gitg_lanes_lane_container_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gitg_lanes_lane_container_type_id;
		gitg_lanes_lane_container_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GitgLanesLaneContainer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gitg_lanes_lane_container_type_id__volatile, gitg_lanes_lane_container_type_id);
	}
	return gitg_lanes_lane_container_type_id__volatile;
}


static gpointer gitg_lanes_lane_container_ref (gpointer instance) {
	GitgLanesLaneContainer* self;
	self = instance;
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_atomic_int_inc (&self->ref_count);
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	return instance;
#line 3341 "gitg-lanes.c"
}


static void gitg_lanes_lane_container_unref (gpointer instance) {
	GitgLanesLaneContainer* self;
	self = instance;
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		GITG_LANES_LANE_CONTAINER_GET_CLASS (self)->finalize (self);
#line 35 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3354 "gitg-lanes.c"
	}
}


static GitgLanesCollapsedLane* gitg_lanes_collapsed_lane_new (GitgLanesLaneContainer* container) {
	GitgLanesCollapsedLane* self;
	GitgLanesLaneContainer* _tmp0_ = NULL;
	GitgLane* _tmp1_ = NULL;
	GitgColor* _tmp2_ = NULL;
	GitgColor* _tmp3_ = NULL;
	GitgLanesLaneContainer* _tmp4_ = NULL;
	GgitOId* _tmp5_ = NULL;
	GgitOId* _tmp6_ = NULL;
	GitgLanesLaneContainer* _tmp7_ = NULL;
	GgitOId* _tmp8_ = NULL;
	GgitOId* _tmp9_ = NULL;
#line 104 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_return_val_if_fail (container != NULL, NULL);
#line 104 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self = g_slice_new0 (GitgLanesCollapsedLane);
#line 104 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_collapsed_lane_instance_init (self);
#line 106 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp0_ = container;
#line 106 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp1_ = _tmp0_->lane;
#line 106 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp2_ = _tmp1_->color;
#line 106 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 106 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->color);
#line 106 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self->color = _tmp3_;
#line 107 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp4_ = container;
#line 107 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp5_ = _tmp4_->from;
#line 107 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp6_ = __vala_GgitOId_copy0 (_tmp5_);
#line 107 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->from);
#line 107 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self->from = _tmp6_;
#line 108 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp7_ = container;
#line 108 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp8_ = _tmp7_->to;
#line 108 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_tmp9_ = __vala_GgitOId_copy0 (_tmp8_);
#line 108 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->to);
#line 108 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self->to = _tmp9_;
#line 104 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	return self;
#line 3411 "gitg-lanes.c"
}


static void gitg_lanes_collapsed_lane_instance_init (GitgLanesCollapsedLane * self) {
}


static void gitg_lanes_collapsed_lane_free (GitgLanesCollapsedLane* self) {
#line 99 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->color);
#line 101 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->from);
#line 102 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	__vala_GgitOId_free0 (self->to);
#line 97 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_slice_free (GitgLanesCollapsedLane, self);
#line 3428 "gitg-lanes.c"
}


static void gitg_lanes_class_init (GitgLanesClass * klass) {
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	gitg_lanes_parent_class = g_type_class_peek_parent (klass);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_type_class_add_private (klass, sizeof (GitgLanesPrivate));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_lanes_get_property;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_lanes_set_property;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_lanes_finalize;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_LANES_INACTIVE_MAX, g_param_spec_int ("inactive-max", "inactive-max", "inactive-max", G_MININT, G_MAXINT, 30, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_LANES_INACTIVE_COLLAPSE, g_param_spec_int ("inactive-collapse", "inactive-collapse", "inactive-collapse", G_MININT, G_MAXINT, 10, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_LANES_INACTIVE_GAP, g_param_spec_int ("inactive-gap", "inactive-gap", "inactive-gap", G_MININT, G_MAXINT, 10, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_LANES_INACTIVE_ENABLED, g_param_spec_boolean ("inactive-enabled", "inactive-enabled", "inactive-enabled", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3451 "gitg-lanes.c"
}


static void gitg_lanes_instance_init (GitgLanes * self) {
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self->priv = GITG_LANES_GET_PRIVATE (self);
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self->priv->_inactive_max = 30;
#line 26 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self->priv->_inactive_collapse = 10;
#line 27 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self->priv->_inactive_gap = 10;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self->priv->_inactive_enabled = TRUE;
#line 3466 "gitg-lanes.c"
}


static void gitg_lanes_finalize (GObject* obj) {
	GitgLanes * self;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_LANES, GitgLanes);
#line 30 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_g_slist_free0 (self->priv->d_previous);
#line 31 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->priv->d_lanes);
#line 32 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_g_hash_table_unref0 (self->priv->d_collapsed);
#line 33 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	_g_object_unref0 (self->priv->d_roots);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	G_OBJECT_CLASS (gitg_lanes_parent_class)->finalize (obj);
#line 3484 "gitg-lanes.c"
}


GType gitg_lanes_get_type (void) {
	static volatile gsize gitg_lanes_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_lanes_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgLanesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_lanes_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgLanes), 0, (GInstanceInitFunc) gitg_lanes_instance_init, NULL };
		GType gitg_lanes_type_id;
		gitg_lanes_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgLanes", &g_define_type_info, 0);
		g_once_init_leave (&gitg_lanes_type_id__volatile, gitg_lanes_type_id);
	}
	return gitg_lanes_type_id__volatile;
}


static void _vala_gitg_lanes_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgLanes * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_LANES, GitgLanes);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	switch (property_id) {
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_MAX:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		g_value_set_int (value, gitg_lanes_get_inactive_max (self));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		break;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_COLLAPSE:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		g_value_set_int (value, gitg_lanes_get_inactive_collapse (self));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		break;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_GAP:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		g_value_set_int (value, gitg_lanes_get_inactive_gap (self));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		break;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_ENABLED:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		g_value_set_boolean (value, gitg_lanes_get_inactive_enabled (self));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		break;
#line 3529 "gitg-lanes.c"
		default:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		break;
#line 3535 "gitg-lanes.c"
	}
}


static void _vala_gitg_lanes_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgLanes * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_LANES, GitgLanes);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
	switch (property_id) {
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_MAX:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_set_inactive_max (self, g_value_get_int (value));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		break;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_COLLAPSE:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_set_inactive_collapse (self, g_value_get_int (value));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		break;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_GAP:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_set_inactive_gap (self, g_value_get_int (value));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		break;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		case GITG_LANES_INACTIVE_ENABLED:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		gitg_lanes_set_inactive_enabled (self, g_value_get_boolean (value));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		break;
#line 3569 "gitg-lanes.c"
		default:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-lanes.vala"
		break;
#line 3575 "gitg-lanes.c"
	}
}



