/* gmpc-test-plugin.c generated by valac 0.12.0, the Vala compiler
 * generated from gmpc-test-plugin.vala, do not modify */

/* Gnome Music Player Client (GMPC)
 * Copyright (C) 2004-2011 Qball Cow <qball@gmpclient.org>
 * Project homepage: http://gmpclient.org/
 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtktransition.h>
#include "gmpc-extras.h"
#include <libmpd/libmpdclient.h>
#include <libmpd/libmpd.h>
#include <misc.h>
#include <metadata.h>
#include <gmpc_easy_download.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <glib/gstdio.h>
#include <metadata-cache.h>
#include <main.h>
#include <plugin.h>
#include <config1.h>
#include <gdk/gdk.h>

#define _mpd_freeSong0(var) ((var == NULL) ? NULL : (var = (mpd_freeSong (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _meta_data_free0(var) ((var == NULL) ? NULL : (var = (meta_data_free (var), NULL)))
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))

struct _GmpcMetaDataEditWindowPrivate {
	mpd_Song* song;
	MetaDataType query_type;
	GList* downloads;
	void* handle;
	void* handle2;
	GtkHBox* pbox;
	GtkLabel* warning_label;
	GtkEntry* artist_entry;
	GtkEntry* album_entry;
	GtkEntry* title_entry;
	GtkButton* cancel;
	GtkButton* refresh;
	GtkComboBox* combo;
	GtkProgressBar* bar;
	GtkScrolledWindow* sw;
	GtkEventBox* ilevent;
	GtkVBox* itemslist;
};


static gpointer gmpc_meta_data_edit_window_parent_class = NULL;
static gpointer gmpc_test_plugin_parent_class = NULL;
static GmpcPluginToolMenuIfaceIface* gmpc_test_plugin_gmpc_plugin_tool_menu_iface_parent_iface = NULL;
static GmpcPluginSongListIfaceIface* gmpc_test_plugin_gmpc_plugin_song_list_iface_parent_iface = NULL;

#define use_transition_tp TRUE
#define GMPC_META_DATA_EDIT_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GMPC_META_DATA_TYPE_EDIT_WINDOW, GmpcMetaDataEditWindowPrivate))
enum  {
	GMPC_META_DATA_EDIT_WINDOW_DUMMY_PROPERTY
};
#define GMPC_META_DATA_EDIT_WINDOW_some_unique_name VERSION
static void gmpc_meta_data_edit_window_add_entry_image (GmpcMetaDataEditWindow* self, const gchar* provider, const gchar* uri, GdkPixbufFormat* format, GdkPixbuf* pb, gboolean is_raw, gboolean is_thumbnail);
static void gmpc_meta_data_edit_window_set_metadata (GmpcMetaDataEditWindow* self, GtkButton* button);
static void _gmpc_meta_data_edit_window_set_metadata_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void gmpc_meta_data_edit_window_add_entry_text (GmpcMetaDataEditWindow* self, const gchar* provider, const gchar* uri, const gchar* text);
static void _gmpc_meta_data_edit_window_image_downloaded_gmpc_async_download_callback_vala (const GEADAsyncHandler* handle, GEADStatus status, void* p, gpointer self);
static guchar* _vala_array_dup3 (guchar* self, int length);
static void _gmpc_meta_data_edit_window_store_image_gmpc_async_download_callback (const GEADAsyncHandler* handle, GEADStatus status, gpointer self);
static void gmpc_meta_data_edit_window_clear_itemslist (GmpcMetaDataEditWindow* self);
static void _gmpc_meta_data_edit_window_callback_gmpc_meta_data_callback (void* handle, const gchar* plugin_name, GList* list, gpointer self);
static void gmpc_meta_data_edit_window_combo_box_changed (GmpcMetaDataEditWindow* self, GtkComboBox* comb);
static void _gmpc_meta_data_edit_window_b_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _gmpc_meta_data_edit_window_destroy_popup_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _gmpc_meta_data_edit_window_combo_box_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _gmpc_meta_data_edit_window_refresh_query_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda29_ (GtkWidget* source, GtkStyle* old, GmpcMetaDataEditWindow* self);
static void __lambda29__gtk_widget_style_set (GtkWidget* _sender, GtkStyle* previous_style, gpointer self);
static GObject * gmpc_meta_data_edit_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _lambda30_ (GtkWidget* source, GdkRectangle* alloc, GmpcMetaDataEditWindow* self);
static void __lambda30__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self);
static void gmpc_meta_data_edit_window_finalize (GObject* obj);
enum  {
	GMPC_TEST_PLUGIN_DUMMY_PROPERTY
};
static gint* gmpc_test_plugin_real_get_version (GmpcPluginBase* base, int* result_length1);
static const gchar* gmpc_test_plugin_real_get_name (GmpcPluginBase* base);
static void gmpc_test_plugin_real_save_yourself (GmpcPluginBase* base);
static gboolean gmpc_test_plugin_real_get_enabled (GmpcPluginBase* base);
static void gmpc_test_plugin_real_set_enabled (GmpcPluginBase* base, gboolean state);
static void gmpc_test_plugin_menu_activate_tree (GmpcTestPlugin* self, GtkMenuItem* item);
static void _gtk_tree_path_free0_ (gpointer var);
static void _g_list_free__gtk_tree_path_free0_ (GList* self);
static gint gmpc_test_plugin_real_song_list (GmpcPluginSongListIface* base, GtkWidget* tree, GtkMenu* menu);
static void _gmpc_test_plugin_menu_activate_tree_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static gint gmpc_test_plugin_real_tool_menu_integration (GmpcPluginToolMenuIface* base, GtkMenu* menu);
static void _gmpc_test_plugin_menu_activated_album_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static GObject * gmpc_test_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);

static const gint GMPC_TEST_PLUGIN_version[3] = {0, 0, 2};

static void _gmpc_meta_data_edit_window_set_metadata_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	gmpc_meta_data_edit_window_set_metadata (self, _sender);
}


static void gmpc_meta_data_edit_window_add_entry_image (GmpcMetaDataEditWindow* self, const gchar* provider, const gchar* uri, GdkPixbufFormat* format, GdkPixbuf* pb, gboolean is_raw, gboolean is_thumbnail) {
	gchar* a = NULL;
	gchar* _tmp0_;
	gint new_h = 0;
	gint new_w = 0;
	gint _tmp25_;
	gint _tmp26_;
	GtkHBox* _tmp31_ = NULL;
	GtkHBox* hbox;
	GtkLabel* _tmp32_ = NULL;
	GtkLabel* label;
	GdkPixbuf* _tmp33_ = NULL;
	GdkPixbuf* _tmp34_;
	GtkImage* _tmp35_ = NULL;
	GtkImage* _tmp36_;
	GtkImage* image;
	GtkAlignment* _tmp37_ = NULL;
	GtkAlignment* ali;
	const gchar* _tmp38_ = NULL;
	GtkButton* _tmp39_ = NULL;
	GtkButton* button;
	GtkHSeparator* _tmp42_ = NULL;
	GtkHSeparator* sep;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (pb != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (a);
	a = _tmp0_;
	if (provider != NULL) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = _ ("Provider");
		_tmp2_ = g_markup_printf_escaped ("\n<b>%s</b>:  %s", _tmp1_, provider);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat (a, _tmp3_, NULL);
		_g_free0 (a);
		a = _tmp4_;
		_g_free0 (_tmp3_);
	}
	if (format != NULL) {
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = _ ("Filetype");
		_tmp6_ = gdk_pixbuf_format_get_name (format);
		_tmp7_ = g_markup_printf_escaped ("\n<b>%s</b>: %s", _tmp5_, _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (a, _tmp8_, NULL);
		_g_free0 (a);
		a = _tmp9_;
		_g_free0 (_tmp8_);
	}
	if (pb != NULL) {
		if (is_thumbnail) {
			const gchar* _tmp10_ = NULL;
			gint _tmp11_;
			gint _tmp12_;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = _ ("Size");
			_tmp11_ = gdk_pixbuf_get_width (pb);
			_tmp12_ = gdk_pixbuf_get_height (pb);
			_tmp13_ = _ ("width x height");
			_tmp14_ = _ ("high-res image will be downloaded");
			_tmp15_ = g_strdup_printf ("\n<b>%s</b>: %ix%i (%s) (%s)", _tmp10_, _tmp11_, _tmp12_, _tmp13_, _tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strconcat (a, _tmp16_, NULL);
			_g_free0 (a);
			a = _tmp17_;
			_g_free0 (_tmp16_);
		} else {
			const gchar* _tmp18_ = NULL;
			gint _tmp19_;
			gint _tmp20_;
			const gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp18_ = _ ("Size");
			_tmp19_ = gdk_pixbuf_get_width (pb);
			_tmp20_ = gdk_pixbuf_get_height (pb);
			_tmp21_ = _ ("width x height");
			_tmp22_ = g_strdup_printf ("\n<b>%s</b>: %ix%i (%s)", _tmp18_, _tmp19_, _tmp20_, _tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = g_strconcat (a, _tmp23_, NULL);
			_g_free0 (a);
			a = _tmp24_;
			_g_free0 (_tmp23_);
		}
	}
	_tmp25_ = gdk_pixbuf_get_width (pb);
	_tmp26_ = gdk_pixbuf_get_height (pb);
	if (_tmp25_ < _tmp26_) {
		gint _tmp27_;
		gint _tmp28_;
		new_h = 150;
		_tmp27_ = gdk_pixbuf_get_height (pb);
		_tmp28_ = gdk_pixbuf_get_width (pb);
		new_w = (gint) ((150.0 / ((gdouble) _tmp27_)) * _tmp28_);
	} else {
		gint _tmp29_;
		gint _tmp30_;
		new_w = 150;
		_tmp29_ = gdk_pixbuf_get_width (pb);
		_tmp30_ = gdk_pixbuf_get_height (pb);
		new_h = (gint) ((150.0 / ((gdouble) _tmp29_)) * _tmp30_);
	}
	_tmp31_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	hbox = g_object_ref_sink (_tmp31_);
	_tmp32_ = (GtkLabel*) gtk_label_new ("");
	label = g_object_ref_sink (_tmp32_);
	gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_MIDDLE);
	gtk_label_set_markup (label, a);
	gtk_label_set_line_wrap (label, TRUE);
	gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
	_tmp33_ = gdk_pixbuf_scale_simple (pb, new_w, new_h, GDK_INTERP_BILINEAR);
	_tmp34_ = _tmp33_;
	_tmp35_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp34_);
	_tmp36_ = g_object_ref_sink (_tmp35_);
	_g_object_unref0 (_tmp34_);
	image = _tmp36_;
	gtk_widget_set_size_request ((GtkWidget*) image, 180, -1);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) image, FALSE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
	_tmp37_ = (GtkAlignment*) gtk_alignment_new (0.f, 0.f, 0.f, 0.f);
	ali = g_object_ref_sink (_tmp37_);
	_tmp38_ = _ ("Set");
	_tmp39_ = (GtkButton*) gtk_button_new_with_label (_tmp38_);
	button = g_object_ref_sink (_tmp39_);
	if (!is_raw) {
		gchar* _tmp40_ = NULL;
		_tmp40_ = g_strdup (uri);
		g_object_set_data_full ((GObject*) button, "path", (void*) _tmp40_, (GDestroyNotify) g_free);
	} else {
		gchar* _tmp41_ = NULL;
		_tmp41_ = g_strdup (uri);
		g_object_set_data_full ((GObject*) button, "data", (void*) _tmp41_, (GDestroyNotify) g_free);
	}
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) button);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) ali, FALSE, TRUE, (guint) 0);
	g_signal_connect_object (button, "clicked", (GCallback) _gmpc_meta_data_edit_window_set_metadata_gtk_button_clicked, self, 0);
	gtk_widget_show_all ((GtkWidget*) hbox);
	gtk_box_pack_start ((GtkBox*) self->priv->itemslist, (GtkWidget*) hbox, FALSE, TRUE, (guint) 0);
	_tmp42_ = (GtkHSeparator*) gtk_hseparator_new ();
	sep = g_object_ref_sink (_tmp42_);
	gtk_widget_set_size_request ((GtkWidget*) sep, -1, 4);
	gtk_widget_show ((GtkWidget*) sep);
	gtk_box_pack_start ((GtkBox*) self->priv->itemslist, (GtkWidget*) sep, FALSE, TRUE, (guint) 0);
	_g_object_unref0 (sep);
	_g_object_unref0 (button);
	_g_object_unref0 (ali);
	_g_object_unref0 (image);
	_g_object_unref0 (label);
	_g_object_unref0 (hbox);
	_g_free0 (a);
}


static void gmpc_meta_data_edit_window_add_entry_text (GmpcMetaDataEditWindow* self, const gchar* provider, const gchar* uri, const gchar* text) {
	gchar* a = NULL;
	gchar* _tmp0_;
	GtkHBox* _tmp5_ = NULL;
	GtkHBox* hbox;
	GtkLabel* _tmp6_ = NULL;
	GtkLabel* label;
	GtkLabel* _tmp7_ = NULL;
	GtkLabel* text_label;
	GtkAlignment* _tmp8_ = NULL;
	GtkAlignment* ali;
	const gchar* _tmp9_ = NULL;
	GtkButton* _tmp10_ = NULL;
	GtkButton* button;
	gchar* _tmp11_ = NULL;
	GtkHSeparator* _tmp12_ = NULL;
	GtkHSeparator* sep;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (a);
	a = _tmp0_;
	if (provider != NULL) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = _ ("Provider");
		_tmp2_ = g_strdup_printf ("\n<b>%s</b>:  %s", _tmp1_, provider);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat (a, _tmp3_, NULL);
		_g_free0 (a);
		a = _tmp4_;
		_g_free0 (_tmp3_);
	}
	_tmp5_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	hbox = g_object_ref_sink (_tmp5_);
	_tmp6_ = (GtkLabel*) gtk_label_new ("");
	label = g_object_ref_sink (_tmp6_);
	gtk_label_set_markup (label, a);
	gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_MIDDLE);
	gtk_label_set_line_wrap (label, TRUE);
	gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.0f);
	gtk_widget_set_size_request ((GtkWidget*) label, 280, -1);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) label, FALSE, TRUE, (guint) 0);
	_tmp7_ = (GtkLabel*) gtk_label_new (text);
	text_label = g_object_ref_sink (_tmp7_);
	gtk_label_set_ellipsize (text_label, PANGO_ELLIPSIZE_END);
	gtk_misc_set_alignment ((GtkMisc*) text_label, 0.0f, 0.0f);
	gtk_widget_set_size_request ((GtkWidget*) text_label, 180, -1);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) text_label, TRUE, TRUE, (guint) 0);
	_tmp8_ = (GtkAlignment*) gtk_alignment_new (0.f, 0.f, 0.f, 0.f);
	ali = g_object_ref_sink (_tmp8_);
	_tmp9_ = _ ("Set");
	_tmp10_ = (GtkButton*) gtk_button_new_with_label (_tmp9_);
	button = g_object_ref_sink (_tmp10_);
	_tmp11_ = g_strdup (text);
	g_object_set_data_full ((GObject*) button, "lyrics", (void*) _tmp11_, (GDestroyNotify) g_free);
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) button);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) ali, FALSE, TRUE, (guint) 0);
	g_signal_connect_object (button, "clicked", (GCallback) _gmpc_meta_data_edit_window_set_metadata_gtk_button_clicked, self, 0);
	gtk_widget_show_all ((GtkWidget*) hbox);
	gtk_box_pack_start ((GtkBox*) self->priv->itemslist, (GtkWidget*) hbox, FALSE, TRUE, (guint) 0);
	_tmp12_ = (GtkHSeparator*) gtk_hseparator_new ();
	sep = g_object_ref_sink (_tmp12_);
	gtk_widget_set_size_request ((GtkWidget*) sep, -1, 4);
	gtk_widget_show ((GtkWidget*) sep);
	gtk_box_pack_start ((GtkBox*) self->priv->itemslist, (GtkWidget*) sep, FALSE, TRUE, (guint) 0);
	_g_object_unref0 (sep);
	_g_object_unref0 (button);
	_g_object_unref0 (ali);
	_g_object_unref0 (text_label);
	_g_object_unref0 (label);
	_g_object_unref0 (hbox);
	_g_free0 (a);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void gmpc_meta_data_edit_window_image_downloaded (GmpcMetaDataEditWindow* self, const GEADAsyncHandler* handle, GEADStatus status, void* p) {
	const MetaData* item;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (handle != NULL);
	item = (const MetaData*) p;
	g_assert (item != NULL);
	if (status == GEAD_PROGRESS) {
		return;
	}
	self->priv->downloads = g_list_remove (self->priv->downloads, handle);
	gtk_progress_bar_pulse (self->priv->bar);
	if (status == GEAD_DONE) {
		gint _tmp0_;
		guchar* _tmp1_ = NULL;
		guchar* data;
		gint data_length1;
		gint _data_size_;
		gboolean _tmp2_ = FALSE;
		_tmp1_ = gmpc_easy_handler_get_data_vala_wrap (handle, &_tmp0_);
		data = _tmp1_;
		data_length1 = _tmp0_;
		_data_size_ = _tmp0_;
		if (self->priv->query_type == META_ALBUM_ART) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = self->priv->query_type == META_ARTIST_ART;
		}
		if (_tmp2_) {
			GdkPixbufLoader* _tmp3_ = NULL;
			GdkPixbufLoader* load;
			GdkPixbuf* _tmp5_ = NULL;
			GdkPixbuf* _tmp6_;
			GdkPixbuf* pb;
			_tmp3_ = gdk_pixbuf_loader_new ();
			load = _tmp3_;
			gdk_pixbuf_loader_write (load, data, (gsize) data_length1, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch30_g_error;
			}
			goto __finally30;
			__catch30_g_error:
			{
				GError * e;
				const gchar* _tmp4_ = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp4_ = gmpc_easy_handler_get_uri (handle);
				g_debug ("gmpc-test-plugin.vala:190: Failed to load file: %s::%s\n", e->message, _tmp4_);
				_g_error_free0 (e);
			}
			__finally30:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (load);
				goto __catch29_g_error;
			}
			gdk_pixbuf_loader_close (load, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (load);
				goto __catch29_g_error;
			}
			_tmp5_ = gdk_pixbuf_loader_get_pixbuf (load);
			_tmp6_ = _g_object_ref0 (_tmp5_);
			pb = _tmp6_;
			if (pb != NULL) {
				void* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				GdkPixbufFormat* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				_tmp7_ = gmpc_easy_handler_get_user_data (handle);
				_tmp8_ = meta_data_get_uri (item);
				_tmp9_ = gdk_pixbuf_loader_get_format (load);
				_tmp10_ = meta_data_get_thumbnail_uri (item);
				gmpc_meta_data_edit_window_add_entry_image (self, (const gchar*) _tmp7_, _tmp8_, _tmp9_, pb, FALSE, _tmp10_ != NULL);
			}
			_g_object_unref0 (pb);
			_g_object_unref0 (load);
			goto __finally29;
			__catch29_g_error:
			{
				GError * e;
				const gchar* _tmp11_ = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp11_ = gmpc_easy_handler_get_uri (handle);
				g_debug ("gmpc-test-plugin.vala:203: Failed to load file: %s::%s\n", e->message, _tmp11_);
				_g_error_free0 (e);
			}
			__finally29:
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		} else {
			void* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			_tmp12_ = gmpc_easy_handler_get_user_data (handle);
			_tmp13_ = gmpc_easy_handler_get_uri (handle);
			gmpc_meta_data_edit_window_add_entry_text (self, (const gchar*) _tmp12_, _tmp13_, (const gchar*) data);
		}
	}
	if (self->priv->handle == NULL) {
		_tmp15_ = self->priv->handle2 == NULL;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		_tmp14_ = self->priv->downloads == NULL;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		gtk_widget_hide ((GtkWidget*) self->priv->pbox);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->refresh, TRUE);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->ilevent, TRUE);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->combo, TRUE);
	}
	meta_data_free (item);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static void _gmpc_meta_data_edit_window_image_downloaded_gmpc_async_download_callback_vala (const GEADAsyncHandler* handle, GEADStatus status, void* p, gpointer self) {
	gmpc_meta_data_edit_window_image_downloaded (self, handle, status, p);
}


static guchar* _vala_array_dup3 (guchar* self, int length) {
	return g_memdup (self, length * sizeof (guchar));
}


void gmpc_meta_data_edit_window_callback (GmpcMetaDataEditWindow* self, void* handle, const gchar* plugin_name, GList* list) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	gtk_progress_bar_pulse (self->priv->bar);
	if (list == NULL) {
		if (self->priv->handle == handle) {
			gboolean _tmp0_ = FALSE;
			self->priv->handle = NULL;
			if (self->priv->handle == NULL) {
				_tmp0_ = self->priv->downloads == NULL;
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				gtk_widget_hide ((GtkWidget*) self->priv->pbox);
				gtk_widget_set_sensitive ((GtkWidget*) self->priv->refresh, TRUE);
				gtk_widget_set_sensitive ((GtkWidget*) self->priv->ilevent, TRUE);
				gtk_widget_set_sensitive ((GtkWidget*) self->priv->combo, TRUE);
			}
		}
		if (self->priv->handle2 == handle) {
			gboolean _tmp1_ = FALSE;
			self->priv->handle2 = NULL;
			if (self->priv->handle == NULL) {
				_tmp1_ = self->priv->downloads == NULL;
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				gtk_widget_hide ((GtkWidget*) self->priv->pbox);
				gtk_widget_set_sensitive ((GtkWidget*) self->priv->combo, TRUE);
				gtk_widget_set_sensitive ((GtkWidget*) self->priv->ilevent, TRUE);
				gtk_widget_set_sensitive ((GtkWidget*) self->priv->refresh, TRUE);
			}
		}
	}
	{
		GList* md_collection;
		GList* md_it;
		md_collection = list;
		for (md_it = md_collection; md_it != NULL; md_it = md_it->next) {
			const MetaData* md;
			md = (const MetaData*) md_it->data;
			{
				gboolean _tmp2_ = FALSE;
				if (self->priv->query_type == META_ALBUM_ART) {
					_tmp2_ = TRUE;
				} else {
					_tmp2_ = self->priv->query_type == META_ARTIST_ART;
				}
				if (_tmp2_) {
					if (md->content_type == META_DATA_CONTENT_URI) {
						if (md->content_type == META_DATA_CONTENT_URI) {
							const gchar* uri;
							const gchar* _tmp3_ = NULL;
							gchar _tmp6_;
							uri = NULL;
							_tmp3_ = meta_data_get_thumbnail_uri (md);
							if (_tmp3_ != NULL) {
								const gchar* _tmp4_ = NULL;
								_tmp4_ = meta_data_get_thumbnail_uri (md);
								uri = _tmp4_;
							} else {
								const gchar* _tmp5_ = NULL;
								_tmp5_ = meta_data_get_uri (md);
								uri = _tmp5_;
							}
							_tmp6_ = string_get (uri, (glong) 0);
							if (_tmp6_ == '/') {
								GdkPixbuf* _tmp7_ = NULL;
								GdkPixbuf* pb;
								_tmp7_ = gdk_pixbuf_new_from_file (uri, &_inner_error_);
								pb = _tmp7_;
								if (_inner_error_ != NULL) {
									goto __catch31_g_error;
								}
								if (pb != NULL) {
									gint w = 0;
									gint h = 0;
									gint _tmp8_;
									gint _tmp9_;
									GdkPixbufFormat* _tmp10_ = NULL;
									_tmp10_ = gdk_pixbuf_get_file_info (uri, &_tmp8_, &_tmp9_);
									w = _tmp8_;
									h = _tmp9_;
									gmpc_meta_data_edit_window_add_entry_image (self, plugin_name, uri, _tmp10_, pb, FALSE, FALSE);
								}
								_g_object_unref0 (pb);
								goto __finally31;
								__catch31_g_error:
								{
									GError * e;
									e = _inner_error_;
									_inner_error_ = NULL;
									_g_error_free0 (e);
								}
								__finally31:
								if (_inner_error_ != NULL) {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							} else {
								MetaData* _tmp11_ = NULL;
								const MetaData* item;
								const GEADAsyncHandler* _tmp12_ = NULL;
								GEADAsyncHandler* h;
								_tmp11_ = meta_data_dup (md);
								item = _tmp11_;
								_tmp12_ = gmpc_easy_async_downloader_vala (uri, (void*) item, _gmpc_meta_data_edit_window_image_downloaded_gmpc_async_download_callback_vala, self);
								h = _tmp12_;
								if (h != NULL) {
									gmpc_easy_handler_set_user_data (h, md->plugin_name);
									self->priv->downloads = g_list_append (self->priv->downloads, h);
								}
							}
						}
					} else {
						if (md->content_type == META_DATA_CONTENT_RAW) {
							gint _tmp13_;
							guchar* _tmp14_ = NULL;
							guchar* _tmp15_;
							guchar* _tmp16_;
							guchar* data;
							gint data_length1;
							gint _data_size_;
							GdkPixbufLoader* _tmp17_ = NULL;
							GdkPixbufLoader* load;
							GdkPixbuf* _tmp18_ = NULL;
							GdkPixbuf* _tmp19_;
							GdkPixbuf* pb;
							_tmp14_ = meta_data_get_raw (md, &_tmp13_);
							_tmp15_ = (_tmp16_ = _tmp14_, (_tmp16_ == NULL) ? ((gpointer) _tmp16_) : _vala_array_dup3 (_tmp16_, _tmp13_));
							data = _tmp15_;
							data_length1 = _tmp13_;
							_data_size_ = _tmp13_;
							_tmp17_ = gdk_pixbuf_loader_new ();
							load = _tmp17_;
							gdk_pixbuf_loader_write (load, data, (gsize) data_length1, &_inner_error_);
							if (_inner_error_ != NULL) {
								goto __catch32_g_error;
							}
							goto __finally32;
							__catch32_g_error:
							{
								GError * e;
								e = _inner_error_;
								_inner_error_ = NULL;
								g_debug ("gmpc-test-plugin.vala:293: Failed to load raw data: %s\n", e->message);
								_g_error_free0 (e);
							}
							__finally32:
							if (_inner_error_ != NULL) {
								_g_object_unref0 (load);
								data = (g_free (data), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							gdk_pixbuf_loader_close (load, &_inner_error_);
							if (_inner_error_ != NULL) {
								goto __catch33_g_error;
							}
							goto __finally33;
							__catch33_g_error:
							{
								GError * e;
								e = _inner_error_;
								_inner_error_ = NULL;
								g_debug ("gmpc-test-plugin.vala:298: Failed to close loader: %s\n", e->message);
								_g_error_free0 (e);
							}
							__finally33:
							if (_inner_error_ != NULL) {
								_g_object_unref0 (load);
								data = (g_free (data), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							_tmp18_ = gdk_pixbuf_loader_get_pixbuf (load);
							_tmp19_ = _g_object_ref0 (_tmp18_);
							pb = _tmp19_;
							if (pb != NULL) {
								gchar* _tmp20_ = NULL;
								gchar* base16;
								GdkPixbufFormat* _tmp21_ = NULL;
								_tmp20_ = g_base64_encode (data, data_length1);
								base16 = _tmp20_;
								_tmp21_ = gdk_pixbuf_loader_get_format (load);
								gmpc_meta_data_edit_window_add_entry_image (self, plugin_name, base16, _tmp21_, pb, TRUE, FALSE);
								_g_free0 (base16);
							}
							_g_object_unref0 (pb);
							_g_object_unref0 (load);
							data = (g_free (data), NULL);
						}
					}
				} else {
					if (md->content_type == META_DATA_CONTENT_TEXT) {
						const gchar* _tmp22_ = NULL;
						const gchar* uri;
						_tmp22_ = meta_data_get_text (md);
						uri = _tmp22_;
						gmpc_meta_data_edit_window_add_entry_text (self, plugin_name, "n/a", uri);
					} else {
						if (md->content_type == META_DATA_CONTENT_HTML) {
							gchar* _tmp23_ = NULL;
							gchar* uri;
							_tmp23_ = meta_data_get_text_from_html (md);
							uri = _tmp23_;
							gmpc_meta_data_edit_window_add_entry_text (self, plugin_name, "n/a", uri);
							_g_free0 (uri);
						} else {
							if (md->content_type == META_DATA_CONTENT_URI) {
								const gchar* _tmp24_ = NULL;
								const gchar* uri;
								gchar _tmp25_;
								_tmp24_ = meta_data_get_uri (md);
								uri = _tmp24_;
								_tmp25_ = string_get (uri, (glong) 0);
								if (_tmp25_ == '/') {
									gchar* content = NULL;
									gchar* _tmp26_ = NULL;
									gboolean _tmp27_;
									gboolean _tmp28_;
									_tmp27_ = g_file_get_contents (uri, &_tmp26_, NULL, &_inner_error_);
									_g_free0 (content);
									content = _tmp26_;
									_tmp28_ = _tmp27_;
									if (_inner_error_ != NULL) {
										_g_free0 (content);
										goto __catch34_g_error;
									}
									if (_tmp28_) {
										gmpc_meta_data_edit_window_add_entry_text (self, plugin_name, uri, content);
									}
									_g_free0 (content);
									goto __finally34;
									__catch34_g_error:
									{
										GError * e;
										e = _inner_error_;
										_inner_error_ = NULL;
										_g_error_free0 (e);
									}
									__finally34:
									if (_inner_error_ != NULL) {
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


void gmpc_meta_data_edit_window_store_image (GmpcMetaDataEditWindow* self, const GEADAsyncHandler* handle, GEADStatus status) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (handle != NULL);
	if (status == GEAD_PROGRESS) {
		gint _tmp0_;
		guchar* _tmp1_ = NULL;
		guchar* data;
		gint data_length1;
		gint _data_size_;
		gint64 _tmp2_;
		gint64 total_size;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = gmpc_easy_handler_get_data_vala_wrap (handle, &_tmp0_);
		data = _tmp1_;
		data_length1 = _tmp0_;
		_data_size_ = _tmp0_;
		gtk_widget_set_sensitive ((GtkWidget*) self, FALSE);
		gtk_widget_show ((GtkWidget*) self->priv->pbox);
		_tmp2_ = gmpc_easy_handler_get_content_size (handle);
		total_size = _tmp2_;
		if (data_length1 > 0) {
			_tmp3_ = total_size > 0;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			gdouble progress;
			progress = data_length1 / ((gdouble) total_size);
			gtk_progress_bar_set_fraction (self->priv->bar, progress);
		} else {
			gtk_progress_bar_pulse (self->priv->bar);
		}
		return;
	}
	self->priv->downloads = g_list_remove (self->priv->downloads, handle);
	if (status == GEAD_DONE) {
		gint _tmp4_;
		guchar* _tmp5_ = NULL;
		guchar* data;
		gint data_length1;
		gint _data_size_;
		gchar* _tmp6_ = NULL;
		gchar* file;
		MetaData* _tmp7_ = NULL;
		MetaData* met;
		MetaData* _tmp8_ = NULL;
		MetaData* met_false;
		_tmp5_ = gmpc_easy_handler_get_data_vala_wrap (handle, &_tmp4_);
		data = _tmp5_;
		data_length1 = _tmp4_;
		_data_size_ = _tmp4_;
		_tmp6_ = gmpc_get_metadata_filename (self->priv->query_type, self->priv->song, NULL);
		file = _tmp6_;
		g_file_set_contents (file, (const gchar*) data, (gssize) ((glong) data_length1), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch35_g_error;
		}
		_tmp7_ = meta_data_new ();
		met = _tmp7_;
		met->type = self->priv->query_type;
		met->plugin_name = "User set";
		met->content_type = META_DATA_CONTENT_URI;
		meta_data_set_uri (met, file);
		meta_data_set_cache (self->priv->song, META_DATA_AVAILABLE, met);
		_tmp8_ = meta_data_new ();
		met_false = _tmp8_;
		met_false->type = self->priv->query_type;
		met_false->plugin_name = "User set";
		met_false->content_type = META_DATA_CONTENT_EMPTY;
		g_signal_emit_by_name (gmw, "data-changed", self->priv->song, self->priv->query_type, META_DATA_UNAVAILABLE, met_false);
		g_signal_emit_by_name (gmw, "data-changed", self->priv->song, self->priv->query_type, META_DATA_AVAILABLE, met);
		_meta_data_free0 (met_false);
		_meta_data_free0 (met);
		goto __finally35;
		__catch35_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally35:
		if (_inner_error_ != NULL) {
			_g_free0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (file);
	}
	gtk_widget_hide ((GtkWidget*) self->priv->pbox);
	gtk_widget_set_sensitive ((GtkWidget*) self, TRUE);
}


static void _gmpc_meta_data_edit_window_store_image_gmpc_async_download_callback (const GEADAsyncHandler* handle, GEADStatus status, gpointer self) {
	gmpc_meta_data_edit_window_store_image (self, handle, status);
}


static void gmpc_meta_data_edit_window_set_metadata (GmpcMetaDataEditWindow* self, GtkButton* button) {
	gchar* path;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	path = NULL;
	if (self->priv->query_type == META_ALBUM_ART) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->query_type == META_ARTIST_ART;
	}
	if (_tmp0_) {
		gconstpointer _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp1_ = g_object_get_data ((GObject*) button, "path");
		_tmp2_ = g_strdup ((const gchar*) ((const gchar*) _tmp1_));
		_g_free0 (path);
		path = _tmp2_;
		if (path != NULL) {
			gchar _tmp3_;
			_tmp3_ = string_get (path, (glong) 0);
			if (_tmp3_ == '/') {
				MetaData* _tmp4_ = NULL;
				MetaData* met;
				MetaData* _tmp5_ = NULL;
				MetaData* met_false;
				_tmp4_ = meta_data_new ();
				met = _tmp4_;
				met->type = self->priv->query_type;
				met->plugin_name = "User set";
				met->content_type = META_DATA_CONTENT_URI;
				meta_data_set_uri (met, path);
				meta_data_set_cache (self->priv->song, META_DATA_AVAILABLE, met);
				_tmp5_ = meta_data_new ();
				met_false = _tmp5_;
				met_false->type = self->priv->query_type;
				met_false->plugin_name = "User set";
				met_false->content_type = META_DATA_CONTENT_EMPTY;
				g_signal_emit_by_name (gmw, "data-changed", self->priv->song, self->priv->query_type, META_DATA_UNAVAILABLE, met_false);
				g_signal_emit_by_name (gmw, "data-changed", self->priv->song, self->priv->query_type, META_DATA_AVAILABLE, met);
				_meta_data_free0 (met_false);
				_meta_data_free0 (met);
			} else {
				const GEADAsyncHandler* _tmp6_ = NULL;
				GEADAsyncHandler* h;
				_tmp6_ = gmpc_easy_async_downloader (path, _gmpc_meta_data_edit_window_store_image_gmpc_async_download_callback, self);
				h = _tmp6_;
				if (h != NULL) {
					self->priv->downloads = g_list_append (self->priv->downloads, h);
				}
			}
		} else {
			gconstpointer _tmp7_ = NULL;
			gchar* _tmp8_;
			gchar* base64;
			_tmp7_ = g_object_get_data ((GObject*) button, "data");
			_tmp8_ = g_strdup ((const gchar*) ((const gchar*) _tmp7_));
			base64 = _tmp8_;
			if (base64 != NULL) {
				gchar* _tmp9_ = NULL;
				gchar* filename;
				size_t _tmp10_;
				guchar* _tmp11_ = NULL;
				guchar* data;
				gint data_length1;
				gint _data_size_;
				MetaData* _tmp12_ = NULL;
				MetaData* met;
				MetaData* _tmp13_ = NULL;
				MetaData* met_false;
				_tmp9_ = gmpc_get_metadata_filename (self->priv->query_type, self->priv->song, NULL);
				filename = _tmp9_;
				_tmp11_ = g_base64_decode (base64, &_tmp10_);
				data = _tmp11_;
				data_length1 = _tmp10_;
				_data_size_ = _tmp10_;
				g_file_set_contents (filename, (const gchar*) data, (gssize) data_length1, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch36_g_error;
				}
				_tmp12_ = meta_data_new ();
				met = _tmp12_;
				met->type = self->priv->query_type;
				met->plugin_name = "User set";
				met->content_type = META_DATA_CONTENT_URI;
				meta_data_set_uri (met, filename);
				meta_data_set_cache (self->priv->song, META_DATA_AVAILABLE, met);
				_tmp13_ = meta_data_new ();
				met_false = _tmp13_;
				met_false->type = self->priv->query_type;
				met_false->plugin_name = "User set";
				met_false->content_type = META_DATA_CONTENT_EMPTY;
				g_signal_emit_by_name (gmw, "data-changed", self->priv->song, self->priv->query_type, META_DATA_UNAVAILABLE, met_false);
				g_signal_emit_by_name (gmw, "data-changed", self->priv->song, self->priv->query_type, META_DATA_AVAILABLE, met);
				_meta_data_free0 (met_false);
				_meta_data_free0 (met);
				goto __finally36;
				__catch36_g_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (e);
				}
				__finally36:
				if (_inner_error_ != NULL) {
					data = (g_free (data), NULL);
					_g_free0 (filename);
					_g_free0 (base64);
					_g_free0 (path);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				data = (g_free (data), NULL);
				_g_free0 (filename);
			}
			_g_free0 (base64);
		}
	} else {
		gchar* lyric = NULL;
		gconstpointer _tmp14_ = NULL;
		gchar* _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* file;
		MetaData* _tmp17_ = NULL;
		MetaData* met;
		MetaData* _tmp18_ = NULL;
		MetaData* met_false;
		_tmp14_ = g_object_get_data ((GObject*) button, "lyrics");
		_tmp15_ = g_strdup ((const gchar*) ((const gchar*) _tmp14_));
		_g_free0 (lyric);
		lyric = _tmp15_;
		_tmp16_ = gmpc_get_metadata_filename (self->priv->query_type, self->priv->song, NULL);
		file = _tmp16_;
		g_file_set_contents (file, lyric, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch37_g_error;
		}
		_tmp17_ = meta_data_new ();
		met = _tmp17_;
		met->type = self->priv->query_type;
		met->plugin_name = "User set";
		met->content_type = META_DATA_CONTENT_URI;
		meta_data_set_uri (met, file);
		meta_data_set_cache (self->priv->song, META_DATA_AVAILABLE, met);
		_tmp18_ = meta_data_new ();
		met_false = _tmp18_;
		met_false->type = self->priv->query_type;
		met_false->plugin_name = "User set";
		met_false->content_type = META_DATA_CONTENT_EMPTY;
		g_signal_emit_by_name (gmw, "data-changed", self->priv->song, self->priv->query_type, META_DATA_UNAVAILABLE, met_false);
		g_signal_emit_by_name (gmw, "data-changed", self->priv->song, self->priv->query_type, META_DATA_AVAILABLE, met);
		_meta_data_free0 (met_false);
		_meta_data_free0 (met);
		goto __finally37;
		__catch37_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally37:
		if (_inner_error_ != NULL) {
			_g_free0 (file);
			_g_free0 (lyric);
			_g_free0 (path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (file);
		_g_free0 (lyric);
	}
	_g_free0 (path);
}


void gmpc_meta_data_edit_window_destroy_popup (GmpcMetaDataEditWindow* self, GtkButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	gtk_object_destroy ((GtkObject*) self);
}


static void gmpc_meta_data_edit_window_clear_itemslist (GmpcMetaDataEditWindow* self) {
	GList* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self->priv->itemslist);
	{
		GList* client_collection;
		GList* client_it;
		client_collection = _tmp0_;
		for (client_it = client_collection; client_it != NULL; client_it = client_it->next) {
			GtkWidget* _tmp1_;
			GtkWidget* client;
			_tmp1_ = _g_object_ref0 ((GtkWidget*) client_it->data);
			client = _tmp1_;
			{
				gtk_object_destroy ((GtkObject*) client);
				_g_object_unref0 (client);
			}
		}
		_g_list_free0 (client_collection);
	}
}


static gpointer _mpd_songDup0 (gpointer self) {
	return self ? mpd_songDup (self) : NULL;
}


static void _gmpc_meta_data_edit_window_callback_gmpc_meta_data_callback (void* handle, const gchar* plugin_name, GList* list, gpointer self) {
	gmpc_meta_data_edit_window_callback (self, handle, plugin_name, list);
}


void gmpc_meta_data_edit_window_refresh_query (GmpcMetaDataEditWindow* self, GtkButton* button) {
	mpd_Song* _tmp0_;
	mpd_Song* ss;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	gmpc_meta_data_edit_window_clear_itemslist (self);
	g_log ("MetadataSelector", G_LOG_LEVEL_DEBUG, "gmpc-test-plugin.vala:483: Query metadata");
	_tmp0_ = _mpd_songDup0 (self->priv->song);
	ss = _tmp0_;
	_tmp1_ = gtk_entry_get_text (self->priv->artist_entry);
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (ss->artist);
	ss->artist = _tmp2_;
	_tmp3_ = gtk_entry_get_text (self->priv->album_entry);
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (ss->album);
	ss->album = _tmp4_;
	_tmp5_ = gtk_entry_get_text (self->priv->title_entry);
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (ss->title);
	ss->title = _tmp6_;
	if (self->priv->handle == NULL) {
		_tmp7_ = self->priv->handle2 == NULL;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		void* _tmp8_ = NULL;
		gtk_widget_show ((GtkWidget*) self->priv->pbox);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->refresh, FALSE);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->combo, FALSE);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->ilevent, FALSE);
		g_log ("MetadataSelector", G_LOG_LEVEL_DEBUG, "gmpc-test-plugin.vala:494: Start metdata get_list query");
		_tmp8_ = metadata_get_list (ss, self->priv->query_type, _gmpc_meta_data_edit_window_callback_gmpc_meta_data_callback, self);
		self->priv->handle = _tmp8_;
		g_log ("MetadataSelector", G_LOG_LEVEL_DEBUG, "gmpc-test-plugin.vala:496: Wait");
	}
	_mpd_freeSong0 (ss);
}


static void gmpc_meta_data_edit_window_combo_box_changed (GmpcMetaDataEditWindow* self, GtkComboBox* comb) {
	gint _tmp0_;
	gint active;
	g_return_if_fail (self != NULL);
	g_return_if_fail (comb != NULL);
	gmpc_meta_data_edit_window_clear_itemslist (self);
	_tmp0_ = gtk_combo_box_get_active (comb);
	active = _tmp0_;
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->title_entry, FALSE);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->album_entry, FALSE);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->artist_entry, FALSE);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->refresh, FALSE);
	gtk_widget_hide ((GtkWidget*) self->priv->warning_label);
	if (active == 0) {
		self->priv->query_type = META_ARTIST_ART;
		if (self->priv->song->artist != NULL) {
			gtk_widget_set_sensitive ((GtkWidget*) self->priv->artist_entry, TRUE);
			gtk_widget_set_sensitive ((GtkWidget*) self->priv->refresh, TRUE);
		} else {
			gtk_widget_show ((GtkWidget*) self->priv->warning_label);
		}
	} else {
		if (active == 1) {
			gboolean _tmp1_ = FALSE;
			self->priv->query_type = META_ALBUM_ART;
			if (self->priv->song->artist != NULL) {
				_tmp1_ = self->priv->song->album != NULL;
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				gtk_widget_set_sensitive ((GtkWidget*) self->priv->artist_entry, TRUE);
				gtk_widget_set_sensitive ((GtkWidget*) self->priv->album_entry, TRUE);
				gtk_widget_set_sensitive ((GtkWidget*) self->priv->refresh, TRUE);
			} else {
				gtk_widget_show ((GtkWidget*) self->priv->warning_label);
			}
		} else {
			if (active == 2) {
				gboolean _tmp2_ = FALSE;
				self->priv->query_type = META_SONG_TXT;
				if (self->priv->song->artist != NULL) {
					_tmp2_ = self->priv->song->title != NULL;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					gtk_widget_set_sensitive ((GtkWidget*) self->priv->artist_entry, TRUE);
					gtk_widget_set_sensitive ((GtkWidget*) self->priv->title_entry, TRUE);
					gtk_widget_set_sensitive ((GtkWidget*) self->priv->refresh, TRUE);
				} else {
					gtk_widget_show ((GtkWidget*) self->priv->warning_label);
				}
			} else {
				if (active == 3) {
					gboolean _tmp3_ = FALSE;
					self->priv->query_type = META_ALBUM_TXT;
					if (self->priv->song->artist != NULL) {
						_tmp3_ = self->priv->song->album != NULL;
					} else {
						_tmp3_ = FALSE;
					}
					if (_tmp3_) {
						gtk_widget_set_sensitive ((GtkWidget*) self->priv->artist_entry, TRUE);
						gtk_widget_set_sensitive ((GtkWidget*) self->priv->album_entry, TRUE);
						gtk_widget_set_sensitive ((GtkWidget*) self->priv->refresh, TRUE);
					} else {
						gtk_widget_show ((GtkWidget*) self->priv->warning_label);
					}
				} else {
					if (active == 4) {
						self->priv->query_type = META_ARTIST_TXT;
						if (self->priv->song->artist != NULL) {
							gtk_widget_set_sensitive ((GtkWidget*) self->priv->artist_entry, TRUE);
							gtk_widget_set_sensitive ((GtkWidget*) self->priv->refresh, TRUE);
						} else {
							gtk_widget_show ((GtkWidget*) self->priv->warning_label);
						}
					} else {
						if (active == 5) {
							gboolean _tmp4_ = FALSE;
							self->priv->query_type = META_SONG_GUITAR_TAB;
							if (self->priv->song->artist != NULL) {
								_tmp4_ = self->priv->song->title != NULL;
							} else {
								_tmp4_ = FALSE;
							}
							if (_tmp4_) {
								gtk_widget_set_sensitive ((GtkWidget*) self->priv->artist_entry, TRUE);
								gtk_widget_set_sensitive ((GtkWidget*) self->priv->title_entry, TRUE);
								gtk_widget_set_sensitive ((GtkWidget*) self->priv->refresh, TRUE);
							} else {
								gtk_widget_show ((GtkWidget*) self->priv->warning_label);
							}
						}
					}
				}
			}
		}
	}
}


static void _gmpc_meta_data_edit_window_b_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	gmpc_meta_data_edit_window_b_cancel (self);
}


static void _gmpc_meta_data_edit_window_destroy_popup_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	gmpc_meta_data_edit_window_destroy_popup (self, _sender);
}


static void _gmpc_meta_data_edit_window_combo_box_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	gmpc_meta_data_edit_window_combo_box_changed (self, _sender);
}


static void _gmpc_meta_data_edit_window_refresh_query_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	gmpc_meta_data_edit_window_refresh_query (self, _sender);
}


static void _lambda29_ (GtkWidget* source, GtkStyle* old, GmpcMetaDataEditWindow* self) {
	GtkWidget* _tmp0_ = NULL;
	GtkStyle* _tmp1_ = NULL;
	GdkColor _tmp2_;
	g_return_if_fail (source != NULL);
	_tmp0_ = gtk_widget_get_parent ((GtkWidget*) self->priv->itemslist);
	_tmp1_ = gtk_widget_get_style ((GtkWidget*) self);
	_tmp2_ = _tmp1_->base[GTK_STATE_NORMAL];
	gtk_widget_modify_bg (_tmp0_, GTK_STATE_NORMAL, &_tmp2_);
}


static void __lambda29__gtk_widget_style_set (GtkWidget* _sender, GtkStyle* previous_style, gpointer self) {
	_lambda29_ (_sender, previous_style, self);
}


GmpcMetaDataEditWindow* gmpc_meta_data_edit_window_construct (GType object_type, const mpd_Song* song, MetaDataType type) {
	GmpcMetaDataEditWindow * self = NULL;
	GtkVBox* _tmp0_ = NULL;
	GtkVBox* vbox;
	mpd_Song* _tmp1_;
	GtkHBox* _tmp2_ = NULL;
	GtkProgressBar* _tmp3_ = NULL;
	GtkButton* _tmp4_ = NULL;
	GtkScrolledWindow* _tmp5_ = NULL;
	GtkHBox* _tmp6_ = NULL;
	GtkHBox* hbox;
	GtkButton* _tmp7_ = NULL;
	GtkButton* button;
	GtkLabel* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	GtkSizeGroup* _tmp12_ = NULL;
	GtkSizeGroup* group;
	GtkHBox* _tmp13_ = NULL;
	GtkHBox* qhbox;
	GtkLabel* label;
	GtkListStore* _tmp14_ = NULL;
	GtkListStore* list;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	GtkComboBox* _tmp21_ = NULL;
	GtkCellRendererPixbuf* _tmp22_ = NULL;
	GtkCellRenderer* renderer;
	GtkCellRendererText* _tmp23_ = NULL;
	GtkHBox* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	GtkLabel* _tmp26_ = NULL;
	GtkImage* _tmp27_ = NULL;
	GtkImage* image;
	GtkEntry* _tmp28_ = NULL;
	GtkHBox* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	GtkLabel* _tmp31_ = NULL;
	GtkImage* _tmp32_ = NULL;
	GtkEntry* _tmp33_ = NULL;
	GtkHBox* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	GtkLabel* _tmp36_ = NULL;
	GtkImage* _tmp37_ = NULL;
	GtkEntry* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	GtkButton* _tmp40_ = NULL;
	GtkButton* _tmp41_;
	GtkAlignment* _tmp42_ = NULL;
	GtkAlignment* ali;
	GtkEventBox* _tmp43_ = NULL;
	GtkStyle* _tmp44_ = NULL;
	GdkColor _tmp45_;
	g_return_val_if_fail (song != NULL, NULL);
	self = (GmpcMetaDataEditWindow*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	vbox = g_object_ref_sink (_tmp0_);
	_tmp1_ = _mpd_songDup0 (song);
	_mpd_freeSong0 (self->priv->song);
	self->priv->song = _tmp1_;
	self->priv->query_type = type;
	_tmp2_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	_g_object_unref0 (self->priv->pbox);
	self->priv->pbox = g_object_ref_sink (_tmp2_);
	_tmp3_ = (GtkProgressBar*) gtk_progress_bar_new ();
	_g_object_unref0 (self->priv->bar);
	self->priv->bar = g_object_ref_sink (_tmp3_);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) self->priv->pbox, FALSE, FALSE, (guint) 0);
	_tmp4_ = (GtkButton*) gtk_button_new_from_stock ("gtk-cancel");
	_g_object_unref0 (self->priv->cancel);
	self->priv->cancel = g_object_ref_sink (_tmp4_);
	g_signal_connect_object (self->priv->cancel, "clicked", (GCallback) _gmpc_meta_data_edit_window_b_cancel_gtk_button_clicked, self, 0);
	gtk_box_pack_start ((GtkBox*) self->priv->pbox, (GtkWidget*) self->priv->bar, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self->priv->pbox, (GtkWidget*) self->priv->cancel, FALSE, FALSE, (guint) 0);
	gtk_widget_show ((GtkWidget*) self->priv->bar);
	gtk_widget_show ((GtkWidget*) self->priv->cancel);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->pbox, TRUE);
	gtk_widget_hide ((GtkWidget*) self->priv->pbox);
	_tmp5_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	_g_object_unref0 (self->priv->sw);
	self->priv->sw = g_object_ref_sink (_tmp5_);
	gtk_scrolled_window_set_policy (self->priv->sw, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_scrolled_window_set_shadow_type (self->priv->sw, GTK_SHADOW_ETCHED_IN);
	_tmp6_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	hbox = g_object_ref_sink (_tmp6_);
	_tmp7_ = (GtkButton*) gtk_button_new_from_stock ("gtk-quit");
	button = g_object_ref_sink (_tmp7_);
	g_signal_connect_object (button, "clicked", (GCallback) _gmpc_meta_data_edit_window_destroy_popup_gtk_button_clicked, self, 0);
	gtk_box_pack_end ((GtkBox*) hbox, (GtkWidget*) button, FALSE, FALSE, (guint) 0);
	gtk_box_pack_end ((GtkBox*) vbox, (GtkWidget*) hbox, FALSE, FALSE, (guint) 0);
	_tmp8_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->warning_label);
	self->priv->warning_label = g_object_ref_sink (_tmp8_);
	_tmp9_ = _ ("Insufficient information to store/fetch this metadata");
	_tmp10_ = g_strdup_printf ("<span size='x-large'>%s</span>", _tmp9_);
	_tmp11_ = _tmp10_;
	gtk_label_set_markup (self->priv->warning_label, _tmp11_);
	_g_free0 (_tmp11_);
	gtk_misc_set_alignment ((GtkMisc*) self->priv->warning_label, 0.0f, 0.5f);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) self->priv->warning_label, FALSE, FALSE, (guint) 0);
	gtk_widget_hide ((GtkWidget*) self->priv->warning_label);
	_tmp12_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	group = _tmp12_;
	_tmp13_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	qhbox = g_object_ref_sink (_tmp13_);
	label = NULL;
	_tmp14_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, -1);
	list = _tmp14_;
	_tmp15_ = _ ("Artist art");
	gtk_list_store_insert_with_values (list, NULL, -1, 0, "media-artist", 1, _tmp15_, -1);
	_tmp16_ = _ ("Album art");
	gtk_list_store_insert_with_values (list, NULL, -1, 0, "media-album", 1, _tmp16_, -1);
	_tmp17_ = _ ("Song lyrics");
	gtk_list_store_insert_with_values (list, NULL, -1, 0, "gtk-dnd", 1, _tmp17_, -1);
	_tmp18_ = _ ("Album Info");
	gtk_list_store_insert_with_values (list, NULL, -1, 0, "media-album", 1, _tmp18_, -1);
	_tmp19_ = _ ("Artist Biography");
	gtk_list_store_insert_with_values (list, NULL, -1, 0, "media-artist", 1, _tmp19_, -1);
	_tmp20_ = _ ("Guitar Tab");
	gtk_list_store_insert_with_values (list, NULL, -1, 0, "media-album", 1, _tmp20_, -1);
	_tmp21_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) list);
	_g_object_unref0 (self->priv->combo);
	self->priv->combo = g_object_ref_sink (_tmp21_);
	_tmp22_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	renderer = (GtkCellRenderer*) g_object_ref_sink (_tmp22_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->combo, renderer, FALSE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->combo, renderer, "icon-name", 0);
	_tmp23_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_g_object_unref0 (renderer);
	renderer = (GtkCellRenderer*) g_object_ref_sink (_tmp23_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->combo, renderer, TRUE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->combo, renderer, "text", 1);
	gtk_box_pack_start ((GtkBox*) qhbox, (GtkWidget*) self->priv->combo, TRUE, TRUE, (guint) 0);
	g_signal_connect_object (self->priv->combo, "changed", (GCallback) _gmpc_meta_data_edit_window_combo_box_changed_gtk_combo_box_changed, self, 0);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) qhbox, FALSE, FALSE, (guint) 0);
	_tmp24_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	_g_object_unref0 (qhbox);
	qhbox = g_object_ref_sink (_tmp24_);
	_tmp25_ = _ ("Artist");
	_tmp26_ = (GtkLabel*) gtk_label_new (_tmp25_);
	_g_object_unref0 (label);
	label = g_object_ref_sink (_tmp26_);
	gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
	gtk_size_group_add_widget (group, (GtkWidget*) label);
	gtk_box_pack_start ((GtkBox*) qhbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	_tmp27_ = (GtkImage*) gtk_image_new_from_icon_name ("media-artist", GTK_ICON_SIZE_BUTTON);
	image = g_object_ref_sink (_tmp27_);
	gtk_box_pack_start ((GtkBox*) qhbox, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
	_tmp28_ = (GtkEntry*) gtk_entry_new ();
	_g_object_unref0 (self->priv->artist_entry);
	self->priv->artist_entry = g_object_ref_sink (_tmp28_);
	gtk_entry_set_text (self->priv->artist_entry, song->artist);
	gtk_box_pack_start ((GtkBox*) qhbox, (GtkWidget*) self->priv->artist_entry, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) qhbox, FALSE, FALSE, (guint) 0);
	_tmp29_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	_g_object_unref0 (qhbox);
	qhbox = g_object_ref_sink (_tmp29_);
	_tmp30_ = _ ("Album");
	_tmp31_ = (GtkLabel*) gtk_label_new (_tmp30_);
	_g_object_unref0 (label);
	label = g_object_ref_sink (_tmp31_);
	gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
	gtk_size_group_add_widget (group, (GtkWidget*) label);
	gtk_box_pack_start ((GtkBox*) qhbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	_tmp32_ = (GtkImage*) gtk_image_new_from_icon_name ("media-album", GTK_ICON_SIZE_BUTTON);
	_g_object_unref0 (image);
	image = g_object_ref_sink (_tmp32_);
	gtk_box_pack_start ((GtkBox*) qhbox, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
	_tmp33_ = (GtkEntry*) gtk_entry_new ();
	_g_object_unref0 (self->priv->album_entry);
	self->priv->album_entry = g_object_ref_sink (_tmp33_);
	if (song->album != NULL) {
		gtk_entry_set_text (self->priv->album_entry, song->album);
	}
	gtk_box_pack_start ((GtkBox*) qhbox, (GtkWidget*) self->priv->album_entry, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) qhbox, FALSE, FALSE, (guint) 0);
	_tmp34_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
	_g_object_unref0 (qhbox);
	qhbox = g_object_ref_sink (_tmp34_);
	_tmp35_ = _ ("Title");
	_tmp36_ = (GtkLabel*) gtk_label_new (_tmp35_);
	_g_object_unref0 (label);
	label = g_object_ref_sink (_tmp36_);
	gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
	gtk_size_group_add_widget (group, (GtkWidget*) label);
	gtk_box_pack_start ((GtkBox*) qhbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	_tmp37_ = (GtkImage*) gtk_image_new_from_icon_name ("media-audiofile", GTK_ICON_SIZE_BUTTON);
	_g_object_unref0 (image);
	image = g_object_ref_sink (_tmp37_);
	gtk_box_pack_start ((GtkBox*) qhbox, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
	_tmp38_ = (GtkEntry*) gtk_entry_new ();
	_g_object_unref0 (self->priv->title_entry);
	self->priv->title_entry = g_object_ref_sink (_tmp38_);
	if (song->title != NULL) {
		gtk_entry_set_text (self->priv->title_entry, song->title);
	}
	gtk_box_pack_start ((GtkBox*) qhbox, (GtkWidget*) self->priv->title_entry, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) qhbox, FALSE, FALSE, (guint) 0);
	if (type != META_ALBUM_ART) {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->album_entry, FALSE);
	}
	_tmp39_ = _ ("Query");
	_tmp40_ = (GtkButton*) gtk_button_new_with_label (_tmp39_);
	_g_object_unref0 (button);
	button = g_object_ref_sink (_tmp40_);
	_tmp41_ = _g_object_ref0 (button);
	_g_object_unref0 (self->priv->refresh);
	self->priv->refresh = _tmp41_;
	_tmp42_ = (GtkAlignment*) gtk_alignment_new (1.0f, 0.5f, 0.0f, 0.0f);
	ali = g_object_ref_sink (_tmp42_);
	gtk_container_add ((GtkContainer*) ali, (GtkWidget*) button);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) ali, FALSE, FALSE, (guint) 0);
	g_signal_connect_object (button, "clicked", (GCallback) _gmpc_meta_data_edit_window_refresh_query_gtk_button_clicked, self, 0);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) self->priv->sw, TRUE, TRUE, (guint) 0);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) vbox);
	gtk_widget_hide_on_delete ((GtkWidget*) self);
	_tmp43_ = (GtkEventBox*) gtk_event_box_new ();
	_g_object_unref0 (self->priv->ilevent);
	self->priv->ilevent = g_object_ref_sink (_tmp43_);
	gtk_container_set_border_width ((GtkContainer*) self->priv->itemslist, (guint) 8);
	gtk_event_box_set_visible_window (self->priv->ilevent, TRUE);
	_tmp44_ = gtk_widget_get_style ((GtkWidget*) self);
	_tmp45_ = _tmp44_->base[GTK_STATE_NORMAL];
	gtk_widget_modify_bg ((GtkWidget*) self->priv->ilevent, GTK_STATE_NORMAL, &_tmp45_);
	g_signal_connect_object ((GtkWidget*) self, "style-set", (GCallback) __lambda29__gtk_widget_style_set, self, 0);
	gtk_container_add ((GtkContainer*) self->priv->ilevent, (GtkWidget*) self->priv->itemslist);
	gtk_scrolled_window_add_with_viewport (self->priv->sw, (GtkWidget*) self->priv->ilevent);
	gtk_widget_show_all ((GtkWidget*) self);
	if (type == META_ARTIST_ART) {
		gtk_combo_box_set_active (self->priv->combo, 0);
	} else {
		if (type == META_ALBUM_ART) {
			gtk_combo_box_set_active (self->priv->combo, 1);
		} else {
			if (type == META_SONG_TXT) {
				gtk_combo_box_set_active (self->priv->combo, 2);
			} else {
				if (type == META_ALBUM_TXT) {
					gtk_combo_box_set_active (self->priv->combo, 3);
				} else {
					if (type == META_ARTIST_TXT) {
						gtk_combo_box_set_active (self->priv->combo, 4);
					} else {
						if (type == META_SONG_GUITAR_TAB) {
							gtk_combo_box_set_active (self->priv->combo, 5);
						}
					}
				}
			}
		}
	}
	gmpc_meta_data_edit_window_refresh_query (self, button);
	_g_object_unref0 (ali);
	_g_object_unref0 (image);
	_g_object_unref0 (renderer);
	_g_object_unref0 (list);
	_g_object_unref0 (label);
	_g_object_unref0 (qhbox);
	_g_object_unref0 (group);
	_g_object_unref0 (button);
	_g_object_unref0 (hbox);
	_g_object_unref0 (vbox);
	return self;
}


GmpcMetaDataEditWindow* gmpc_meta_data_edit_window_new (const mpd_Song* song, MetaDataType type) {
	return gmpc_meta_data_edit_window_construct (GMPC_META_DATA_TYPE_EDIT_WINDOW, song, type);
}


void gmpc_meta_data_edit_window_b_cancel (GmpcMetaDataEditWindow* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->handle != NULL) {
		metadata_get_list_cancel (self->priv->handle);
		self->priv->handle = NULL;
	}
	if (self->priv->handle2 != NULL) {
		metadata_get_list_cancel (self->priv->handle2);
		self->priv->handle2 = NULL;
	}
	g_list_first (self->priv->downloads);
	while (TRUE) {
		GEADAsyncHandler* handle;
		if (!(self->priv->downloads != NULL)) {
			break;
		}
		handle = (const GEADAsyncHandler*) self->priv->downloads->data;
		gmpc_easy_async_cancel (handle);
		g_list_first (self->priv->downloads);
	}
	gtk_widget_hide ((GtkWidget*) self->priv->pbox);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->refresh, TRUE);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->combo, TRUE);
}


static void _lambda30_ (GtkWidget* source, GdkRectangle* alloc, GmpcMetaDataEditWindow* self) {
	g_return_if_fail (source != NULL);
	cfg_set_single_value_as_int (config, "Metadata Selector", "window_width", (*alloc).width);
	cfg_set_single_value_as_int (config, "Metadata Selector", "window_height", (*alloc).height);
}


static void __lambda30__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self) {
	_lambda30_ (_sender, allocation, self);
}


static GObject * gmpc_meta_data_edit_window_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GmpcMetaDataEditWindow * self;
	gint _tmp0_;
	gint height;
	gint _tmp1_;
	gint width;
	parent_class = G_OBJECT_CLASS (gmpc_meta_data_edit_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GMPC_META_DATA_EDIT_WINDOW (obj);
	g_object_set ((GtkWindow*) self, "type", GTK_WINDOW_TOPLEVEL, NULL);
	_tmp0_ = cfg_get_single_value_as_int_with_default (config, "Metadata Selector", "window_height", 600);
	height = _tmp0_;
	_tmp1_ = cfg_get_single_value_as_int_with_default (config, "Metadata Selector", "window_width", 480);
	width = _tmp1_;
	gtk_window_resize ((GtkWindow*) self, width, height);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 8);
	g_signal_connect_object ((GtkWidget*) self, "size-allocate", (GCallback) __lambda30__gtk_widget_size_allocate, self, 0);
	return obj;
}


static void gmpc_meta_data_edit_window_class_init (GmpcMetaDataEditWindowClass * klass) {
	gmpc_meta_data_edit_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GmpcMetaDataEditWindowPrivate));
	G_OBJECT_CLASS (klass)->constructor = gmpc_meta_data_edit_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = gmpc_meta_data_edit_window_finalize;
}


static void gmpc_meta_data_edit_window_instance_init (GmpcMetaDataEditWindow * self) {
	GtkVBox* _tmp0_ = NULL;
	self->priv = GMPC_META_DATA_EDIT_WINDOW_GET_PRIVATE (self);
	self->priv->song = NULL;
	self->priv->query_type = META_ALBUM_ART;
	self->priv->downloads = NULL;
	self->priv->handle = NULL;
	self->priv->handle2 = NULL;
	self->priv->pbox = NULL;
	self->priv->warning_label = NULL;
	self->priv->cancel = NULL;
	self->priv->refresh = NULL;
	self->priv->combo = NULL;
	self->priv->bar = NULL;
	self->priv->sw = NULL;
	self->priv->ilevent = NULL;
	_tmp0_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	self->priv->itemslist = g_object_ref_sink (_tmp0_);
}


static void gmpc_meta_data_edit_window_finalize (GObject* obj) {
	GmpcMetaDataEditWindow * self;
	self = GMPC_META_DATA_EDIT_WINDOW (obj);
	gmpc_meta_data_edit_window_b_cancel (self);
	_mpd_freeSong0 (self->priv->song);
	_g_list_free0 (self->priv->downloads);
	_g_object_unref0 (self->priv->pbox);
	_g_object_unref0 (self->priv->warning_label);
	_g_object_unref0 (self->priv->artist_entry);
	_g_object_unref0 (self->priv->album_entry);
	_g_object_unref0 (self->priv->title_entry);
	_g_object_unref0 (self->priv->cancel);
	_g_object_unref0 (self->priv->refresh);
	_g_object_unref0 (self->priv->combo);
	_g_object_unref0 (self->priv->bar);
	_g_object_unref0 (self->priv->sw);
	_g_object_unref0 (self->priv->ilevent);
	_g_object_unref0 (self->priv->itemslist);
	G_OBJECT_CLASS (gmpc_meta_data_edit_window_parent_class)->finalize (obj);
}


GType gmpc_meta_data_edit_window_get_type (void) {
	static volatile gsize gmpc_meta_data_edit_window_type_id__volatile = 0;
	if (g_once_init_enter (&gmpc_meta_data_edit_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcMetaDataEditWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_meta_data_edit_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcMetaDataEditWindow), 0, (GInstanceInitFunc) gmpc_meta_data_edit_window_instance_init, NULL };
		GType gmpc_meta_data_edit_window_type_id;
		gmpc_meta_data_edit_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "GmpcMetaDataEditWindow", &g_define_type_info, 0);
		g_once_init_leave (&gmpc_meta_data_edit_window_type_id__volatile, gmpc_meta_data_edit_window_type_id);
	}
	return gmpc_meta_data_edit_window_type_id__volatile;
}


static gint* gmpc_test_plugin_real_get_version (GmpcPluginBase* base, int* result_length1) {
	GmpcTestPlugin * self;
	gint* result = NULL;
	gint* _tmp0_;
	self = (GmpcTestPlugin*) base;
	_tmp0_ = GMPC_TEST_PLUGIN_version;
	*result_length1 = G_N_ELEMENTS (GMPC_TEST_PLUGIN_version);
	result = _tmp0_;
	return result;
}


/**
     * The name of the plugin
     */
static const gchar* gmpc_test_plugin_real_get_name (GmpcPluginBase* base) {
	GmpcTestPlugin * self;
	const gchar* result = NULL;
	self = (GmpcTestPlugin*) base;
	result = "Vala test plugin";
	return result;
}


/**
     * Tells the plugin to save itself
     */
static void gmpc_test_plugin_real_save_yourself (GmpcPluginBase* base) {
	GmpcTestPlugin * self;
	self = (GmpcTestPlugin*) base;
}


/**
     * Get set enabled
     */
static gboolean gmpc_test_plugin_real_get_enabled (GmpcPluginBase* base) {
	GmpcTestPlugin * self;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	self = (GmpcTestPlugin*) base;
	_tmp0_ = gmpc_plugin_base_get_name ((GmpcPluginBase*) self);
	_tmp1_ = cfg_get_single_value_as_int_with_default (config, _tmp0_, "enabled", 1);
	result = (gboolean) _tmp1_;
	return result;
}


static void gmpc_test_plugin_real_set_enabled (GmpcPluginBase* base, gboolean state) {
	GmpcTestPlugin * self;
	const gchar* _tmp0_ = NULL;
	self = (GmpcTestPlugin*) base;
	_tmp0_ = gmpc_plugin_base_get_name ((GmpcPluginBase*) self);
	cfg_set_single_value_as_int (config, _tmp0_, "enabled", (gint) state);
}


/*********************************************************************************
     * Private  
     ********************************************************************************/
static void _gtk_tree_path_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
}


static void _g_list_free__gtk_tree_path_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_tree_path_free0_, NULL);
	g_list_free (self);
}


static void gmpc_test_plugin_menu_activate_tree (GmpcTestPlugin* self, GtkMenuItem* item) {
	GtkTreeIter iter = {0};
	gconstpointer _tmp0_ = NULL;
	GtkTreeView* _tmp1_;
	GtkTreeView* tv;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* model;
	GtkTreeSelection* _tmp4_ = NULL;
	GtkTreeSelection* _tmp5_;
	GtkTreeSelection* selection;
	GtkTreeModel* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	GtkTreeModel* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = g_object_get_data ((GObject*) item, "treeview");
	_tmp1_ = _g_object_ref0 (GTK_TREE_VIEW ((const gchar*) _tmp0_));
	tv = _tmp1_;
	_tmp2_ = gtk_tree_view_get_model (tv);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	model = _tmp3_;
	_tmp4_ = gtk_tree_view_get_selection (tv);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	selection = _tmp5_;
	_tmp7_ = gtk_tree_selection_get_selected_rows (selection, &_tmp6_);
	_g_object_unref0 (model);
	_tmp8_ = _g_object_ref0 (_tmp6_);
	model = _tmp8_;
	{
		GList* path_collection;
		GList* path_it;
		path_collection = _tmp7_;
		for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
			GtkTreePath* path;
			path = (GtkTreePath*) path_it->data;
			{
				GtkTreeIter _tmp9_ = {0};
				gboolean _tmp10_;
				_tmp10_ = gtk_tree_model_get_iter (model, &_tmp9_, path);
				iter = _tmp9_;
				if (_tmp10_) {
					const mpd_Song* song;
					song = NULL;
					gtk_tree_model_get (model, &iter, 0, &song, -1);
					if (song != NULL) {
						GmpcMetaDataEditWindow* _tmp11_ = NULL;
						GmpcMetaDataEditWindow* _tmp12_;
						_tmp11_ = gmpc_meta_data_edit_window_new (song, META_ALBUM_ART);
						_tmp12_ = g_object_ref_sink (_tmp11_);
						_g_object_unref0 (_tmp12_);
					}
				}
			}
		}
		__g_list_free__gtk_tree_path_free0_0 (path_collection);
	}
	_g_object_unref0 (selection);
	_g_object_unref0 (model);
	_g_object_unref0 (tv);
}


static void _gmpc_test_plugin_menu_activate_tree_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	gmpc_test_plugin_menu_activate_tree (self, _sender);
}


static gint gmpc_test_plugin_real_song_list (GmpcPluginSongListIface* base, GtkWidget* tree, GtkMenu* menu) {
	GmpcTestPlugin * self;
	gint result = 0;
	GtkTreeView* _tmp0_;
	GtkTreeView* tv;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* selection;
	gint _tmp3_;
	self = (GmpcTestPlugin*) base;
	g_return_val_if_fail (tree != NULL, 0);
	g_return_val_if_fail (menu != NULL, 0);
	_tmp0_ = _g_object_ref0 (GTK_TREE_VIEW (tree));
	tv = _tmp0_;
	_tmp1_ = gtk_tree_view_get_selection (tv);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = gtk_tree_selection_count_selected_rows (selection);
	if (_tmp3_ > 0) {
		const gchar* _tmp4_ = NULL;
		GtkImageMenuItem* _tmp5_ = NULL;
		GtkImageMenuItem* item;
		GtkImage* _tmp6_ = NULL;
		GtkImage* _tmp7_;
		GtkTreeView* _tmp8_;
		_tmp4_ = _ ("Metadata selector");
		_tmp5_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_label (_tmp4_);
		item = g_object_ref_sink (_tmp5_);
		_tmp6_ = (GtkImage*) gtk_image_new_from_stock ("gtk-edit", GTK_ICON_SIZE_MENU);
		_tmp7_ = g_object_ref_sink (_tmp6_);
		gtk_image_menu_item_set_image (item, (GtkWidget*) _tmp7_);
		_g_object_unref0 (_tmp7_);
		_tmp8_ = _g_object_ref0 (tv);
		g_object_set_data_full ((GObject*) item, "treeview", _tmp8_, g_object_unref);
		gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) ((GtkMenuItem*) item));
		g_signal_connect_object ((GtkMenuItem*) item, "activate", (GCallback) _gmpc_test_plugin_menu_activate_tree_gtk_menu_item_activate, self, 0);
		result = 1;
		_g_object_unref0 (item);
		_g_object_unref0 (selection);
		_g_object_unref0 (tv);
		return result;
	}
	result = 0;
	_g_object_unref0 (selection);
	_g_object_unref0 (tv);
	return result;
}


void gmpc_test_plugin_menu_activated_album (GmpcTestPlugin* self, GtkMenuItem* item) {
	const mpd_Song* _tmp0_ = NULL;
	const mpd_Song* song;
	GmpcMetaDataEditWindow* _tmp1_ = NULL;
	GmpcMetaDataEditWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = mpd_playlist_get_current_song (connection);
	song = _tmp0_;
	_tmp1_ = gmpc_meta_data_edit_window_new (song, META_ALBUM_ART);
	_tmp2_ = g_object_ref_sink (_tmp1_);
	_g_object_unref0 (_tmp2_);
}


static void _gmpc_test_plugin_menu_activated_album_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	gmpc_test_plugin_menu_activated_album (self, _sender);
}


static gint gmpc_test_plugin_real_tool_menu_integration (GmpcPluginToolMenuIface* base, GtkMenu* menu) {
	GmpcTestPlugin * self;
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	GtkMenuItem* _tmp1_ = NULL;
	GtkMenuItem* item;
	self = (GmpcTestPlugin*) base;
	g_return_val_if_fail (menu != NULL, 0);
	_tmp0_ = _ ("Edit metadata current song");
	_tmp1_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp0_);
	item = g_object_ref_sink (_tmp1_);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) item);
	g_signal_connect_object (item, "activate", (GCallback) _gmpc_test_plugin_menu_activated_album_gtk_menu_item_activate, self, 0);
	result = 2;
	_g_object_unref0 (item);
	return result;
}


GmpcTestPlugin* gmpc_test_plugin_construct (GType object_type) {
	GmpcTestPlugin * self = NULL;
	self = (GmpcTestPlugin*) gmpc_plugin_base_construct (object_type);
	return self;
}


GmpcTestPlugin* gmpc_test_plugin_new (void) {
	return gmpc_test_plugin_construct (GMPC_TYPE_TEST_PLUGIN);
}


static GObject * gmpc_test_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GmpcTestPlugin * self;
	parent_class = G_OBJECT_CLASS (gmpc_test_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GMPC_TEST_PLUGIN (obj);
	((GmpcPluginBase*) self)->plugin_type = 8 + 4;
	return obj;
}


static void gmpc_test_plugin_class_init (GmpcTestPluginClass * klass) {
	gmpc_test_plugin_parent_class = g_type_class_peek_parent (klass);
	GMPC_PLUGIN_BASE_CLASS (klass)->get_version = gmpc_test_plugin_real_get_version;
	GMPC_PLUGIN_BASE_CLASS (klass)->get_name = gmpc_test_plugin_real_get_name;
	GMPC_PLUGIN_BASE_CLASS (klass)->save_yourself = gmpc_test_plugin_real_save_yourself;
	GMPC_PLUGIN_BASE_CLASS (klass)->get_enabled = gmpc_test_plugin_real_get_enabled;
	GMPC_PLUGIN_BASE_CLASS (klass)->set_enabled = gmpc_test_plugin_real_set_enabled;
	G_OBJECT_CLASS (klass)->constructor = gmpc_test_plugin_constructor;
}


static void gmpc_test_plugin_gmpc_plugin_tool_menu_iface_interface_init (GmpcPluginToolMenuIfaceIface * iface) {
	gmpc_test_plugin_gmpc_plugin_tool_menu_iface_parent_iface = g_type_interface_peek_parent (iface);
	iface->tool_menu_integration = (gint (*)(GmpcPluginToolMenuIface* ,GtkMenu*)) gmpc_test_plugin_real_tool_menu_integration;
}


static void gmpc_test_plugin_gmpc_plugin_song_list_iface_interface_init (GmpcPluginSongListIfaceIface * iface) {
	gmpc_test_plugin_gmpc_plugin_song_list_iface_parent_iface = g_type_interface_peek_parent (iface);
	iface->song_list = (gint (*)(GmpcPluginSongListIface* ,GtkWidget* ,GtkMenu*)) gmpc_test_plugin_real_song_list;
}


static void gmpc_test_plugin_instance_init (GmpcTestPlugin * self) {
}


GType gmpc_test_plugin_get_type (void) {
	static volatile gsize gmpc_test_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&gmpc_test_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcTestPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_test_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcTestPlugin), 0, (GInstanceInitFunc) gmpc_test_plugin_instance_init, NULL };
		static const GInterfaceInfo gmpc_plugin_tool_menu_iface_info = { (GInterfaceInitFunc) gmpc_test_plugin_gmpc_plugin_tool_menu_iface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gmpc_plugin_song_list_iface_info = { (GInterfaceInitFunc) gmpc_test_plugin_gmpc_plugin_song_list_iface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gmpc_test_plugin_type_id;
		gmpc_test_plugin_type_id = g_type_register_static (GMPC_PLUGIN_TYPE_BASE, "GmpcTestPlugin", &g_define_type_info, 0);
		g_type_add_interface_static (gmpc_test_plugin_type_id, GMPC_PLUGIN_TYPE_TOOL_MENU_IFACE, &gmpc_plugin_tool_menu_iface_info);
		g_type_add_interface_static (gmpc_test_plugin_type_id, GMPC_PLUGIN_TYPE_SONG_LIST_IFACE, &gmpc_plugin_song_list_iface_info);
		g_once_init_leave (&gmpc_test_plugin_type_id__volatile, gmpc_test_plugin_type_id);
	}
	return gmpc_test_plugin_type_id__volatile;
}



