-------------------------------------------------------------------------------
--
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/gui_common.adb,v $
--  Description     : Commonly used GTK functions for the GUI
--  Author          : Michael Erdmann
--  Created         : 8.8.2001
--  Last Modified By: $Author: me $
--  Last Modified On: $Date: 2001/11/25 18:22:17 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------

with Ada.Strings.Unbounded;    use Ada.Strings.Unbounded;
with Ada.Text_Io;              use Ada.Text_IO;
with Ada.Exceptions;           use Ada.Exceptions;
with Ada.Strings;              use Ada.Strings;
with Ada.Strings.Fixed;        use Ada.Strings.Fixed;
with Unchecked_Deallocation;
with Interfaces.C.Strings;

with Glib;                     use Glib;
-- Gdk
with Gdk;
with Gdk.Drawable;             use Gdk.Drawable;
with Gdk.Bitmap;               use Gdk.Bitmap;
with Gdk.Event;                use Gdk.Event;
with Gdk.Font;                 use Gdk.Font;
with Gdk.Color;                use Gdk.Color;
with Gdk.GC;                   use Gdk.GC;
with Gdk.Pixmap;               use Gdk.Pixmap;
with Gdk.Rectangle;            use Gdk.Rectangle;
with Gdk.Types;                use Gdk.Types;
with Gdk.Window;               use Gdk.Window;
-- Gtk
with Gtk.Rc;
with Gtk;                      use Gtk;
with Gtk.Arguments;            use Gtk.Arguments;
with Gtk.Box;                  use Gtk.Box;
with Gtk.Button;               use Gtk.Button;
with Gtk.Clist;                use Gtk.Clist;
with Gtk.Editable;             use Gtk.Editable;
with Gtk.Enums;                use Gtk.Enums;
with Gtk.Frame;                use Gtk.Frame;
with Gtk.Handlers;             use Gtk.Handlers;
with Gtk.Label;                use Gtk.Label;

with Gtkada.Handlers;          use Gtkada.Handlers;
with Gtk.Scrolled_Window;      use Gtk.Scrolled_Window;
with Gtk.Style;                use Gtk.Style;
with Gtk.Text;                 use Gtk.Text;
with Gtk.Window;               use Gtk.Window;
with Gtk.Widget;               use Gtk.Widget;
with Gtk.GEntry;               use Gtk.GEntry;
with Gtk.Combo;                use Gtk.Combo;

with GSQL_Types;               use GSQL_Types;
with GUI_Preferences;          use GUI_Preferences;
with GUI_Logging;              use GUI_Logging;

with Project_File;             use Project_File;
with Files;                    use Files;
with Contents_Handler;         use Contents_Handler;

package body GUI_Common is

   Version : constant String := "$Id: gui_common.adb,v 1.10 2001/11/25 18:22:17 me Exp $";

   package ICS renames Interfaces.C.Strings;
   use type Interfaces.C.size_t;

   -----------------
   -- Entry_Field --
   -----------------
   procedure Entry_Field(
      Vbox        : in out Gtk_Box;
      Field       : out Gtk_Entry;
      Description : in String;
      Default     : in String  := "";
      Maxlength   : in Natural := 60 ) is
      ---
      Descr       : Gtk_Label;
      Hbox        : Gtk_Box;
   begin
      Gtk_New_Hbox (Hbox);
      Set_Border_Width( Hbox, 4 );

      Gtk_New( Descr, Description & " : " );
      Pack_Start(Hbox, Descr, Expand => False );

      Gtk_New( Field );
      if Default /= "" then
         Set_Text( Field, Default );
      end if;

      Set_Visibility (Field, True);
      Set_Max_Length (Field, Guint16(Maxlength) );
      Show_All( Field );

      Pack_End( Hbox, Field );
      Show_All( Hbox );

      Pack_Start( Vbox, Hbox );
   end Entry_Field;

   ------------------
   -- Display_Name --
   ------------------
   function Display_Name(
      S : in Unbounded_String ) return String is
      -- create a name part suitable for the notebook names
      R : constant String  := To_String(S);
      L : constant Natural := R'Length;
   begin
      if L < 16 then
         return R;
      end if;

      return R(1..8) & ".." & R(L-5..L);
   end Display_Name;

   --------------
   -- Add_Text --
   --------------
   procedure Add_Text(
      A    : in Gtk_Box;
      Text : in String ) is
      L    : Gtk_Label;
   begin
      Gtk_New( L, Text );
      Pack_Start( A, L, Expand => False );
      Show_All(L);
   end Add_Text;

   ----------------
   -- Add_Editor --
   ----------------
   procedure Add_Editor(
      A        : in out Gtk_Box;
      T        : out Gtk_Text;
      Text     : in String := "" ) is
      Scrolled : Gtk_Scrolled_Window;
      EdBox    : Gtk_Box;
      L        : Gtk_Label;
   begin
      Gtk_New_Vbox( Edbox );

      if Text /= "" then
         Gtk_New( L, Text );
         Pack_Start( Edbox, L, Expand => False );
         Show_All(L);
      end if;

      Gtk_New (Scrolled);
      Pack_Start (Edbox, Scrolled, Expand => True );
      Set_Policy (Scrolled, Policy_Never, Policy_Always);
      Show (Scrolled);

      Gtk_New( T );
      Set_Editable (T, True);
      Add( Scrolled,T );

      Pack_Start( A, Edbox, Expand => True );
      Show_All (Edbox);

   end Add_Editor;

   ---------------
   -- Add_Table --
   ---------------
   procedure Add_Table(
      A        : in out Gtk_Box;
      Clist    : out Gtk_Clist;
      Cols     : in Integer ) is
      use ICS;

      Vbox     : Gtk_Box;
      Scrolled : Gtk_Scrolled_Window;
      Titles   : Chars_Ptr_Array (1 .. C.Size_T(Cols) ) := (others=>ICS.Null_Ptr);
   begin
      Gtk_New_Vbox( Vbox );
      Show_All (Vbox);

      Gtk_New (Scrolled);
      Pack_Start (Vbox, Scrolled, True, True, 0);
      Set_Policy (Scrolled, Policy_Automatic, Policy_Automatic);
      Gtk_New (Clist, Gint (Cols), Titles);
      Add (Scrolled, Clist);

      Pack_Start( A, Vbox, Expand => True );
   end Add_Table;

   ----------------
   -- Insert_Row --
   ----------------
   procedure Insert_Row(
      Clist   : in out Gtk_Clist;
      Text    : in Text_Buffer;
      Row     : in Natural := 0 ) is
      -- insert a row into a table.
      use ICS;

      Len     : constant C.Size_T := C.Size_T( Text'Last - Text'First );
      Texts   : Chars_Ptr_Array (0 .. Len ):=(others=>ICS.Null_Ptr);
      New_Row : Gint;
      J       : C.Size_T := Texts'First;
   begin
      for I in Text'Range loop
         Texts(J) := ICS.New_String(To_String( Text(I) ) );
         J := J + 1;
      end loop;

      Freeze( Clist );
      if Row = 0 then
         New_Row := Append (Clist, Texts);
      else
         Insert( Clist, Gint( Row - 1 ), Texts );
      end if;

      Thaw( Clist );

      -- Free( Texts );
   end Insert_Row;

   ----------------------
   -- Remove_Selection --
   ----------------------
   procedure Remove_Selection (
      CList : in out Gtk_Clist ) is

      use Gint_List;
      I    : Gint;
   begin
      Freeze (Clist);
      loop
         exit when Length (Get_Selection (CList)) = 0;
         I := Get_Data (First (Get_Selection (CList)));
         Remove (CList, I);
         exit when Get_Selection_Mode (CList) = Selection_Browse;
      end loop;

      Thaw (CList);
   end Remove_Selection;

   -----------------
   -- Combo_field --
   -----------------
   procedure Combo_Field(
      Vbox        : in out Gtk_Box;
      Field       : out Gtk_Combo;
      Description : in  String;
      Values      : in  Text_Buffer;
      Maxlength   : in  Natural := 60 ) is
      ---
      use String_List;

      Descr       : Gtk_Label;
      List        : String_List.Glist;
      Hbox        : Gtk_Box;
   begin
      Gtk_New_Hbox (Hbox);
      Set_Border_Width( Hbox, 4 );

      Gtk_New( Descr, Description & " : " );
      Pack_Start(Hbox, Descr, Expand => False );

      for I in Values'Range loop
         Append( List, To_String( Values(I) ) );
      end loop;

      Gtk_New( Field );
      Set_Popdown_Strings (Field, List);
      Gtk.GEntry.Select_Region (Get_Entry (Field), 0, -1);

      Show_All( Field );

      Pack_Start( Hbox, Field, True, True, 0 );
      Show_All( Hbox );

      Pack_Start( Vbox, Hbox );
   end Combo_Field;


end GUI_Common;
