/* 
 * gpsk31  - PSK31 for Linux with a GTK+ Interface
 * 
 * Copyright (C) 2000 Luc Langehegermann, LX2GT
 * Copyright (C) 2005,2006,2007,2008 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * The main author can be reached at pg4i@amsat.org or by smail-mail:
 * Joop Stakenborg, Bramengaarde 24, 3992KG Houten, The Netherlands.
 * 
 */

/*
 * These are the functions needed for the file send/receive functions
 */


#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <time.h>
#include "file.h"
#include "misc.h"
#include "server.h"
#include "globals.h"
#include "main.h"
#include "text.h"
#include "menu.h"

FILE *log_fp = NULL;

/*
 *  First the send file handling
 */

/*
 * This function creates an File dialog for the file to be send
 */

void
file_send_dialog ()
{
  static GtkWidget *window;

    window = gtk_file_chooser_dialog_new
	("GPSK31 - Send file", GTK_WINDOW(main_screen.window),
	GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
	GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);

      g_signal_connect (G_OBJECT (window), "destroy",
			  G_CALLBACK (gtk_widget_destroyed), &window);

      gint response = gtk_dialog_run (GTK_DIALOG(window));
      switch (response)
	{
	  case GTK_RESPONSE_ACCEPT:
		file_send (GTK_FILE_CHOOSER(window));
	  break;
	  default:
		gtk_widget_destroy (window);
	  break;
	}
}

/*
 * Here we read the file, and put it into the TX Buffer/Screen
 * We use a GTimer here, so that the main loop will still be processed
 * While we read the file
 */


void
file_send (GtkFileChooser *fs)
{
  char buffer[256];
  FILE *fp;

  /*
   * Read the Filename from the Dialog and put it into the
   * filename array
   */
   
  gchar *filename = gtk_file_chooser_get_filename ((fs));
  gtk_widget_destroy (GTK_WIDGET (fs));
  /*
   * Try to open the file for reading - if it fails
   * Display an error dialog and return
   */

  fp = fopen (filename, "r");
  if (!fp)
    warning_dialog ("Unable to find File!", FALSE);
  else
    {
      while (fgets (buffer, 255, fp) != NULL)
	{
	  commPutData (buffer, 0);
	  put_tx_window (buffer);
	}

    }
  fclose (fp);
  g_free (filename);
}


void
save_log_dialog ()
{
  static GtkWidget *window;

  if (log_fp)
    warning_dialog ("Logfile already open!", FALSE);
  else
    {
     window = gtk_file_chooser_dialog_new
	("GPSK31 - Log to file", GTK_WINDOW (main_screen.window),
	GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
	GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);

    g_signal_connect (G_OBJECT (window), "destroy",
			  G_CALLBACK (gtk_widget_destroyed), &window);

      gint response = gtk_dialog_run (GTK_DIALOG(window));
      switch (response)
	  {
	  case GTK_RESPONSE_ACCEPT:
		open_logfile (GTK_FILE_CHOOSER (window));
	  break;
	  default:
		gtk_widget_destroy (window);
	  break;
	  }
    }
}

void
logfile(char *filename)
{
  char *time_string;
  
  log_fp = fopen (filename, "a");
  if (!log_fp)
    warning_dialog ("Unable to Open File!", FALSE);
  else
    {
      time_string = get_time_string (NULL);

      /* Write a string, so that the uses sees when the log was started */

      put_logfile ("\n\n<<<<<< Log Opened at: ");
      put_logfile (time_string);
      put_logfile (" >>>>>>\n\n");
      g_free (time_string);
    }
}

/*
 * Opens the file for writing - but does actually no writing
 */


void
open_logfile (GtkFileChooser *fs)
{
  gchar *filename = gtk_file_chooser_get_filename ((fs));
  gtk_widget_destroy (GTK_WIDGET (fs));
  logfile (filename);
  g_free (filename);
}

/*
 * Writes characters to the log file it open
 * Called by the main loop
 */

void
put_logfile (const gchar * text)
{
  if (log_fp)
    fputs (text, log_fp);
}

void
close_logfile ()
{
  if (log_fp)
    {
      char *time_string = get_time_string (NULL);
      put_logfile ("\n\n<<<<<< Log Closed at: ");
      put_logfile (get_time_string (NULL));
      put_logfile (" >>>>>>\n\n");
      g_free (time_string);
      fclose (log_fp);
      log_fp = (FILE *) 0;
    }
  else
    warning_dialog ("No Logfile Open!", FALSE);
}
