Gradle Script Kotlin 0.2.0 Release Notes
========================================

Updates since v0.1.1
--------------------

 * **Build script dependencies and external plugins** ([#29](https://github.com/gradle/gradle-script-kotlin/issues/29)). Dependencies can now be added to the build script classpath using the `buildscript` block, and any plugins resolved there can be applied using the `apply` block. See [`samples/hello-kotlin/build.gradle.kts`](https://github.com/gradle/gradle-script-kotlin/blob/v0.2.0/samples/hello-kotlin/build.gradle.kts) for an example.

 * **Seamless project import into IDEA** ([#26](https://github.com/gradle/gradle-script-kotlin/issues/26), [#43](https://github.com/gradle/gradle-script-kotlin/issues/43)). Importing projects with Kotlin-based builds into IDEA no longer requires running the `generateKtsConfig` and `patchIdeaConfig` tasks, as configuring the Kotlin IDEA plugin and creating an appropriate IDEA library is now handled automatically. Installing the latest dev build (`1159`) of the Kotlin IDEA plugin remains a pre-requisite. See [`samples/README`](https://github.com/gradle/gradle-script-kotlin/tree/v0.2.0/samples) for complete instructions.

 * **Implicit imports** ([#33](https://github.com/gradle/gradle-script-kotlin/issues/33), [#57](https://github.com/gradle/gradle-script-kotlin/issues/57)). Members of the commonly-used packages `org.gradle.script.lang.kotlin` and `org.gradle.api.plugins` are now imported by default into all Kotlin-based Gradle build scripts, resulting in less boilerplate. See commit [`a866610`](https://github.com/gradle/gradle-script-kotlin/commit/a866610f87a68793bef24d98c3eda0cb71e5a3e7) for an example of the difference this creates.

 * **Externally-defined properties** ([#60](https://github.com/gradle/gradle-script-kotlin/issues/60)). It is now possible to reference project properties by declaring a `val` delegated to the build script's enclosing `project` object. This approach provides a strong contract for _which_ properties should be available to the build script, while remaining agnostic as to _how_ those projects are actually declared—be it via `gradle.properties`, `-P` flags or otherwise. See [`samples/project-properties/build.gradle.kts`](https://github.com/gradle/gradle-script-kotlin/blob/v0.2.0/samples/project-properties/build.gradle.kts) for an example.

 * **Convenient alternatives to string-based dependency configurations** ([#36](https://github.com/gradle/gradle-script-kotlin/issues/36)). Prior to this release, dependency configurations were expressed as strings, e.g. `"compile"("org.foo:mylib:1.0")`. This approach is still supported, but extension functions such as `compile` and `testCompile` are now available as a a more convenient and tooling-friendly alternative.
