// -*- c++ -*-
// generated by glade--
//------------------------------------------------------------------------------
// $Id: AppearancePrefs.cpp,v 1.14 2008/08/16 03:13:08 vlg Exp $
//------------------------------------------------------------------------------
//                            AppearancePrefs.cpp
//------------------------------------------------------------------------------
//  Copyright (c) 2006 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Sun Sep 3 2006
//
//------------------------------------------------------------------------------

#include <gtkmm/label.h>
#include <gtkmm/frame.h>
#include <gtkmm/box.h>
#include <gtkmm/scrolledwindow.h>

#include "Granule-main.h"
#include "GrappConf.h"
#include "PrefWindow.h"
#include "AppearancePrefs.h"
#include "TextAlignment.h"
#include "FontsSelectorUI.h"
#include "ColorsSelectorUI.h"

#include "Intern.h"             // i18n macros

using sigc::mem_fun;
using sigc::bind;

/**-----------------------------------------------------------------------------
 *   Class AppearancePrefs methods
 **-----------------------------------------------------------------------------
 */
AppearancePrefs::
AppearancePrefs (PrefWindow& pwin_) 
	: 
	Gtk::VBox (false, 0),
	m_pref_window (pwin_)
{  
	trace_with_mask("AppearancePrefs::AppearancePrefs",GUITRACE);

#if defined(IS_HILDON) || defined(IS_PDA)
	set_border_width(0);
#else
	set_border_width(14);
#endif

	Gtk::ScrolledWindow* scrollw = Gtk::manage (new Gtk::ScrolledWindow);

	scrollw->set_flags       (Gtk::CAN_FOCUS);
	scrollw->set_shadow_type (Gtk::SHADOW_NONE);
	scrollw->set_policy      (Gtk::POLICY_AUTOMATIC, Gtk::POLICY_ALWAYS);

#ifdef GLIBMM_PROPERTIES_ENABLED
	scrollw->property_window_placement ().set_value (Gtk::CORNER_TOP_LEFT);
#else
	scrollw->set_property ("window_placement", Gtk::CORNER_TOP_LEFT);
#endif

	/** Holds Fonts and Text Alignment
	 */
	Gtk::VBox* vbox = Gtk::manage (new Gtk::VBox (false, 0));

	/** Fonts View Widget
	 */
	m_fonts_selector = Gtk::manage (new FontsSelectorUI ());

	/** Colors View Widget
	 */
	m_colors_selector = Gtk::manage (new ColorsSelectorUI ());
	m_colors_selector->set_active (FRMCLR, false);

	/** Text Alignment (View) Widget
	 */
	m_text_alignment = Gtk::manage (new TextAlignment (pwin_));

	/** Warning label
	 */
	Gtk::HBox* warning_hbox = Gtk::manage (new Gtk::HBox (false, 0));
	Gtk::Label* warning_label = Gtk::manage (new Gtk::Label);
	warning_label->set_use_markup ();
	warning_label->set_markup (
			   "<span size=\"large\" weight=\"heavy\">NOTE:</span>\n"
			   "      Any changes in Appearance settings\n"
			   "      require immediate application restart.");
	warning_hbox->pack_start (*warning_label, Gtk::PACK_SHRINK, 4);

	/** Pack everything
	 */
	vbox->pack_start (*warning_hbox,      Gtk::PACK_SHRINK, 2);
	vbox->pack_start (*m_fonts_selector,  Gtk::PACK_SHRINK, 4);
	vbox->pack_start (*m_colors_selector, Gtk::PACK_SHRINK, 4);
	vbox->pack_start (*m_text_alignment,  Gtk::PACK_SHRINK, 4);

	scrollw->add (*vbox);
	pack_start (*scrollw);

	/** Set callbacks
	 */
	for (int t = 0; t < FONT_ENTRY_SZ; t++) 
	{
	    m_fonts_selector->
			font_entry (TextFontType (t)).m_entry->signal_changed().connect (
				mem_fun (m_pref_window, &PrefWindow::changed_cb));
	}

	for (int t = 0; t < COLOR_ENTRY_SZ; t++) 
	{
	    m_colors_selector->
			color_entry (TextColorType (t)).m_entry->signal_changed().connect (
				mem_fun (m_pref_window, &PrefWindow::changed_cb));
	}
	
	show_all ();
}

void
AppearancePrefs::
changed_cb ()
{ 
	m_pref_window.changed (); 
}

void
AppearancePrefs::
load_from_config ()
{
	trace_with_mask("AppearancePrefs::load_from_config",GUITRACE);

	CONFIG->fonts_db ().update_view (m_fonts_selector);
	CONFIG->text_colors_db ().update_view (m_colors_selector);

	m_text_alignment->load_appearance (CONFIG->app_db ());
}

void
AppearancePrefs::
save_to_config ()
{
	trace_with_mask("AppearancePrefs::save_to_config",GUITRACE);

	CONFIG->fonts_db ().fetch_from_view (m_fonts_selector);
	CONFIG->text_colors_db ().fetch_from_view (m_colors_selector);

	m_text_alignment->save_appearance (CONFIG->app_db ());
}

