//*****************************************************************************
//                                NetList.hpp                                 *
//                               -------------                                *
// Description : This class provides an interface to the circuit description  *
//               (netlist) file. The raw netlist data is loaded from file     *
//               into memory and stored as a string array. The individual     *
//               netlist types (component definitions, models, etc.) are      *
//               extracted and stored as object attributes.                   *
// Started     : 01/09/2003                                                   *
// Last Update : 23/06/2011                                                   *
// Copyright   : (C) 2003 by MSWaters                                         *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef NETLIST_HPP
#define NETLIST_HPP

// System Includes

using  namespace  std;

#include <iostream>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/filename.h>
#include <wx/textfile.h>
#include <wx/tokenzr.h>

// Application Includes

#include "Version.hpp"
#include "TypeDefs.hpp"
#include "utility/StrUtils.hpp"
#include "netlist/Component.hpp"

// Local Constant Declarations


//*****************************************************************************

struct NetList
{
  protected :

    // File names
    static  wxFileName      m_ofnLoadFile;
    static  wxFileName      m_ofnSaveFile;
    static  ArrayFileName   m_oaSchemFiles;

  public :

    // String array containing the netlist data
    static  wxArrayString   m_osaNetLst;

    // String arrays containing data extracted from the netlist
    static  wxArrayString   m_osaTitle;
    static  wxArrayString   m_osaIncludes;
    static  ArrayComponent  m_oaCpnts;
    static  wxArrayString   m_osaModels;
    static  wxArrayString   m_osaSubCcts;

    // String arrays containing node labels only
    static  wxArrayString   m_osaNodeLbls;

  private :

    static  bool  m_bIsValid;

    // Functions to extract information from the circuit description
    bool  bLoadTitle     ( void );
    bool  bLoadIncludes  ( void );
    bool  bLoadCpnts     ( void );
    bool  bLoadModels    ( void );
    bool  bLoadSubCcts   ( void );
    bool  bLoadNodeLbls  ( void );
    bool  bLoadSchemFiles( void );
    bool  bIsSubCkt( wxString & roLine );

  public :

    NetList( void );
   ~NetList( );

    virtual  bool  bClear   ( void );
             bool  bIsEmpty ( void ) { return( m_osaNetLst.IsEmpty( ) ); }

    virtual  bool  bValidate( void );
    virtual  bool  bIsValid ( void ) { return( m_bIsValid ); }

    virtual  bool  bLoadFile( const wxString & rosFName=wxT("") );
    virtual  bool  bSaveFile( const wxString & rosFName=wxT("") );

             bool  bSetLoadFile  ( const wxString      &  rosFName  );
             bool  bSetSaveFile  ( const wxString      &  rosFName  );
             bool  bSetSchemFiles( const wxArrayString & rosaFNames );
             bool  bSetSchemFiles( const wxString      &  rosFNames );

    static  const  wxFileName    & roGetLoadFile( void )
                                                  { return( m_ofnLoadFile  ); }
    static  const  wxFileName    & roGetSaveFile( void )
                                                  { return( m_ofnSaveFile  ); }
    static  const  ArrayFileName & roGetSchemFiles( void )
                                                  { return( m_oaSchemFiles ); }
            const  wxString      & rosGetSchemFiles( void );
            const  Component     &  roGetCpnt( const wxString & rosName );

    virtual  void  Print( const wxString & rosPrefix=wxT("  ") );

    friend  class  PrcGnuCap;
    friend  class  PrcNgSpice;
};

//*****************************************************************************

#endif // NETLIST_HPP
