/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.math;
public class IntMathTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.math.testModule";
}
public void testCheckedAdd() throws Exception {
  com.google.common.math.IntMathTest testCase = new com.google.common.math.IntMathTest();
  testCase.testCheckedAdd();
}

public void testCheckedMultiply() throws Exception {
  com.google.common.math.IntMathTest testCase = new com.google.common.math.IntMathTest();
  testCase.testCheckedMultiply();
}

public void testCheckedPow() throws Exception {
  com.google.common.math.IntMathTest testCase = new com.google.common.math.IntMathTest();
  testCase.testCheckedPow();
}

public void testCheckedSubtract() throws Exception {
  com.google.common.math.IntMathTest testCase = new com.google.common.math.IntMathTest();
  testCase.testCheckedSubtract();
}

public void testDivByZeroAlwaysFails() throws Exception {
  com.google.common.math.IntMathTest testCase = new com.google.common.math.IntMathTest();
  testCase.testDivByZeroAlwaysFails();
}

public void testDivNonZero() throws Exception {
  com.google.common.math.IntMathTest testCase = new com.google.common.math.IntMathTest();
  testCase.testDivNonZero();
}

public void testDivNonZeroExact() throws Exception {
  com.google.common.math.IntMathTest testCase = new com.google.common.math.IntMathTest();
  testCase.testDivNonZeroExact();
}

public void testFactorial() throws Exception {
  com.google.common.math.IntMathTest testCase = new com.google.common.math.IntMathTest();
  testCase.testFactorial();
}

public void testFactorialNegative() throws Exception {
  com.google.common.math.IntMathTest testCase = new com.google.common.math.IntMathTest();
  testCase.testFactorialNegative();
}

public void testGCD() throws Exception {
  com.google.common.math.IntMathTest testCase = new com.google.common.math.IntMathTest();
  testCase.testGCD();
}

public void testGCDNegativePositiveThrows() throws Exception {
  com.google.common.math.IntMathTest testCase = new com.google.common.math.IntMathTest();
  testCase.testGCDNegativePositiveThrows();
}

public void testGCDNegativeZeroThrows() throws Exception {
  com.google.common.math.IntMathTest testCase = new com.google.common.math.IntMathTest();
  testCase.testGCDNegativeZeroThrows();
}

public void testGCDZero() throws Exception {
  com.google.common.math.IntMathTest testCase = new com.google.common.math.IntMathTest();
  testCase.testGCDZero();
}

public void testLessThanBranchFree() throws Exception {
  com.google.common.math.IntMathTest testCase = new com.google.common.math.IntMathTest();
  testCase.testLessThanBranchFree();
}

public void testLog2Exact() throws Exception {
  com.google.common.math.IntMathTest testCase = new com.google.common.math.IntMathTest();
  testCase.testLog2Exact();
}

public void testLog2MatchesBigInteger() throws Exception {
  com.google.common.math.IntMathTest testCase = new com.google.common.math.IntMathTest();
  testCase.testLog2MatchesBigInteger();
}

public void testLog2NegativeAlwaysThrows() throws Exception {
  com.google.common.math.IntMathTest testCase = new com.google.common.math.IntMathTest();
  testCase.testLog2NegativeAlwaysThrows();
}

public void testLog2ZeroAlwaysThrows() throws Exception {
  com.google.common.math.IntMathTest testCase = new com.google.common.math.IntMathTest();
  testCase.testLog2ZeroAlwaysThrows();
}

public void testMod() throws Exception {
  com.google.common.math.IntMathTest testCase = new com.google.common.math.IntMathTest();
  testCase.testMod();
}

public void testModNegativeModulusFails() throws Exception {
  com.google.common.math.IntMathTest testCase = new com.google.common.math.IntMathTest();
  testCase.testModNegativeModulusFails();
}

public void testModZeroModulusFails() throws Exception {
  com.google.common.math.IntMathTest testCase = new com.google.common.math.IntMathTest();
  testCase.testModZeroModulusFails();
}

public void testZeroDivIsAlwaysZero() throws Exception {
  com.google.common.math.IntMathTest testCase = new com.google.common.math.IntMathTest();
  testCase.testZeroDivIsAlwaysZero();
}
}
