/*
 * Copyright 2000-2017 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.util.Producer;

import java.awt.datatransfer.Transferable;

/**
 * {@link EditorActionHandler Handlers} for {@link com.intellij.openapi.actionSystem.IdeActions#ACTION_EDITOR_PASTE EditorPaste} action
 * should implement this interface (it's required for text drag-n-drop functionality in editor).
 *
 * @author pegov
 */
public interface EditorTextInsertHandler {
  
  void execute(final Editor editor, final DataContext dataContext, final Producer<Transferable> producer);  
}
