/*
 * $Id$
 *
 * Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.sun.javatest.report;

import com.sun.javatest.cof.COFData;
import com.sun.javatest.cof.Main;
import com.sun.javatest.cof.Main.Fault;
import com.sun.javatest.report.Report.Settings;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class COFReport implements ReportFormat {

    public void write(Settings s, File dir) throws IOException {
        COFData data = new COFData();
        data.setInterviewParameters(s.ip);
        
        File outputFile = new File(dir.getAbsolutePath() + File.separator + "cof.xml");
        
        if (!s.isCOFTestCasesEnabled()) {
            Main.setGenerateTestCases(s.isCOFTestCasesEnabled());
        }
        
        Main cofMain = new Main();
        cofMain.setInterviewParameters(s.ip);
        try {
            com.sun.javatest.cof.Report report = cofMain.fillReport(data);
            cofMain.writeReport(report, outputFile);
        } catch (Fault ex) {
            Logger.getLogger(COFReport.class.getName()).log(Level.SEVERE, null, ex);
        }
        
        String warning = data.get("warning");
        if (warning != null) {
//            System.out.println(warning);
        }
    }
    
}
