/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.resources;

import org.apache.hadoop.hdfs.web.resources.Param;

abstract class IntegerParam
extends Param<Integer, Domain> {
    IntegerParam(Domain domain, Integer value) {
        super(domain, value);
    }

    @Override
    public String toString() {
        return this.getName() + "=" + ((Domain)this.domain).toString((Integer)this.getValue());
    }

    static final class Domain
    extends Param.Domain<Integer> {
        final int radix;

        Domain(String paramName) {
            this(paramName, 10);
        }

        Domain(String paramName, int radix) {
            super(paramName);
            this.radix = radix;
        }

        @Override
        public String getDomain() {
            return "<null | int in radix " + this.radix + ">";
        }

        @Override
        Integer parse(String str) {
            return "null".equals(str) ? null : Integer.valueOf(Integer.parseInt(str, this.radix));
        }

        String toString(Integer n) {
            return n == null ? "null" : Integer.toString(n, this.radix);
        }
    }
}

