.\" @(#)$RCSfile: Cns_chown.man,v $ $Revision: 1.1.1.1 $ $Date: 2003/09/02 07:15:00 $ CERN IT-PDP/DM Jean-Philippe Baud
.\" Copyright (C) 1999-2003 by CERN/IT/PDP/DM
.\" All rights reserved
.\"
.TH CNS_CHOWN 3 "$Date: 2003/09/02 07:15:00 $" CASTOR "Cns Library Functions"
.SH NAME
Cns_chown \- change owner and group of a CASTOR directory/file in the name server
.SH SYNOPSIS
.B #include <sys/types.h>
.br
\fB#include "Cns_api.h"\fR
.sp
.BI "int Cns_chown (const char *" path ,
.BI "uid_t " new_uid ,
.BI "gid_t " new_gid )
.sp
.BI "int Cns_lchown (const char *" path ,
.BI "uid_t " new_uid ,
.BI "gid_t " new_gid )
.SH DESCRIPTION
.B Cns_chown
sets the owner and the group of a CASTOR directory/file in the name server to
the numeric values in
.I owner
and
.I group
respectively.
If
.I owner
or
.I group
is specified as -1,
.B Cns_chown()
does not change the corresponding ID of the file.
.LP
.B Cns_lchown
is identical to
.B Cns_chown
except for symbolic links: it does not follow the link but changes the ownership
of the link itself.
.TP
.I path
specifies the logical pathname relative to the current CASTOR directory or
the full CASTOR pathname.
.LP
To change the owner ID, if the group ID does not change and if the caller and
the new owner ID belong to that group, GRP_ADMIN privilege is needed, otherwise
the caller must have ADMIN privilege in the Cupv database.
To change the group ID, the effective user ID of the process must match the
owner ID of the file and the new group must be in the list of groups the caller
belong to or the caller must have ADMIN privilege in the Cupv database.
.SH RETURN VALUE
This routine returns 0 if the operation was successful or -1 if the operation
failed. In the latter case,
.B serrno
is set appropriately.
.SH ERRORS
.TP 1.3i
.B EPERM
The effective user ID does not match the owner of the file and 
the caller does not have ADMIN privilege in the Cupv database.
.TP
.B ENOENT
The named file/directory does not exist or is a null pathname.
.TP
.B EACCES
Search permission is denied on a component of the
.I path
prefix.
.TP
.B EFAULT
.I path
is a NULL pointer.
.TP
.B ENOTDIR
A component of
.I path
prefix is not a directory.
.TP
.B EINVAL
.I new_uid
or
.I new_gid
is invalid.
.TP
.B ENAMETOOLONG
The length of
.I path
exceeds
.B CA_MAXPATHLEN
or the length of a
.I path
component exceeds
.BR CA_MAXNAMELEN .
.TP
.B SENOSHOST
Host unknown.
.TP
.B SENOSSERV
Service unknown.
.TP
.B SECOMERR
Communication error.
.TP
.B ENSNACT
Name server is not running or is being shutdown.
.SH SEE ALSO
.BR Castor_limits(4) ,
.BR Cns_chdir(3) ,
.BR Cupvlist(1)
.SH AUTHOR
\fBCASTOR\fP Team <castor.support@cern.ch>
