/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import java.io.ByteArrayOutputStream;

public class BitArray {
    public byte[] a;
    public int b;
    public static final int c = 8;
    public static final byte[][] d = new byte[][]{{48, 48, 48, 48}, {48, 48, 48, 49}, {48, 48, 49, 48}, {48, 48, 49, 49}, {48, 49, 48, 48}, {48, 49, 48, 49}, {48, 49, 49, 48}, {48, 49, 49, 49}, {49, 48, 48, 48}, {49, 48, 48, 49}, {49, 48, 49, 48}, {49, 48, 49, 49}, {49, 49, 48, 48}, {49, 49, 48, 49}, {49, 49, 49, 48}, {49, 49, 49, 49}};
    public static final int e = 8;

    public BitArray(int n2) throws IllegalArgumentException {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative length for BitArray");
        }
        this.b = n2;
        this.a = new byte[(n2 + 8 - 1) / 8];
    }

    public BitArray(int n2, byte[] byArray) throws IllegalArgumentException {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative length for BitArray");
        }
        if (byArray.length * 8 < n2) {
            throw new IllegalArgumentException("Byte array too short to represent bit array of given length");
        }
        this.b = n2;
        int n3 = (n2 + 8 - 1) / 8;
        int n4 = n3 * 8 - n2;
        byte by2 = (byte)(255 << n4);
        this.a = new byte[n3];
        System.arraycopy(byArray, 0, this.a, 0, n3);
        this.a[this.a.length - 1] = (byte)(this.a[this.a.length - 1] & by2);
    }

    private BitArray(BitArray bitArray) {
        this.b = bitArray.b;
        this.a = (byte[])bitArray.a.clone();
    }

    public BitArray(boolean[] blArray) {
        this.b = blArray.length;
        this.a = new byte[(this.b + 7) / 8];
        int n2 = 0;
        while (n2 < this.b) {
            this.set(n2, blArray[n2]);
            ++n2;
        }
    }

    public Object clone() {
        return new BitArray(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof BitArray)) {
            return false;
        }
        BitArray bitArray = (BitArray)object;
        if (bitArray.b != this.b) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.a.length) {
            if (this.a[n2] != bitArray.a[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean get(int n2) throws ArrayIndexOutOfBoundsException {
        if (n2 < 0 || n2 >= this.b) {
            throw new ArrayIndexOutOfBoundsException(Integer.toString(n2));
        }
        return (this.a[BitArray.b(n2)] & BitArray.a(n2)) != 0;
    }

    public int hashCode() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.a.length) {
            n2 = 31 * n2 + this.a[n3];
            ++n3;
        }
        return n2 ^ this.b;
    }

    public int length() {
        return this.b;
    }

    private static int a(int n2) {
        return 1 << 7 - n2 % 8;
    }

    public void set(int n2, boolean bl2) throws ArrayIndexOutOfBoundsException {
        if (n2 < 0 || n2 >= this.b) {
            throw new ArrayIndexOutOfBoundsException(Integer.toString(n2));
        }
        int n3 = BitArray.b(n2);
        int n4 = BitArray.a(n2);
        if (bl2) {
            int n5 = n3;
            this.a[n5] = (byte)(this.a[n5] | n4);
        } else {
            int n6 = n3;
            this.a[n6] = (byte)(this.a[n6] & ~n4);
        }
    }

    private static int b(int n2) {
        return n2 / 8;
    }

    public boolean[] toBooleanArray() {
        boolean[] blArray = new boolean[this.b];
        int n2 = 0;
        while (n2 < this.b) {
            blArray[n2] = this.get(n2);
            ++n2;
        }
        return blArray;
    }

    public byte[] toByteArray() {
        return (byte[])this.a.clone();
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        while (n2 < this.a.length - 1) {
            byteArrayOutputStream.write(d[this.a[n2] >> 4 & 0xF], 0, 4);
            byteArrayOutputStream.write(d[this.a[n2] & 0xF], 0, 4);
            if (n2 % 8 == 7) {
                byteArrayOutputStream.write(10);
            } else {
                byteArrayOutputStream.write(32);
            }
            ++n2;
        }
        int n3 = 8 * (this.a.length - 1);
        while (n3 < this.b) {
            byteArrayOutputStream.write(this.get(n3) ? 49 : 48);
            ++n3;
        }
        return new String(byteArrayOutputStream.toByteArray());
    }
}

