; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-linux-gnu | FileCheck %s --check-prefix=X86
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu | FileCheck %s --check-prefix=X64

%destTy = type { i2, i2 }

define void @crash(i64 %x0, i64 %y0, %destTy* nocapture %dest) nounwind {
; X86-LABEL: crash:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movb {{[0-9]+}}(%esp), %dl
; X86-NEXT:    andb $3, %dl
; X86-NEXT:    movb %dl, (%ecx)
; X86-NEXT:    andb $3, %al
; X86-NEXT:    movb %al, (%ecx)
; X86-NEXT:    retl
;
; X64-LABEL: crash:
; X64:       # %bb.0:
; X64-NEXT:    andl $3, %esi
; X64-NEXT:    movb %sil, (%rdx)
; X64-NEXT:    andl $3, %edi
; X64-NEXT:    movb %dil, (%rdx)
; X64-NEXT:    retq
  %x1 = trunc i64 %x0 to i2
  %y1 = trunc i64 %y0 to i2
  %1 = bitcast %destTy* %dest to <2 x i2>*
  %2 = insertelement <2 x i2> undef, i2 %x1, i32 0
  %3 = insertelement <2 x i2> %2, i2 %y1, i32 1
  store <2 x i2> %3, <2 x i2>* %1, align 1
  ret void
}
