/*
* JBoss, Home of Professional Open Source
* Copyright 2009, Red Hat, Inc. and/or its affiliates, and individual contributors
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
* http://www.apache.org/licenses/LICENSE-2.0
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
package org.hibernate.validator.test.constraints.impl;

import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import org.hibernate.validator.constraints.impl.CreditCardNumberValidator;

import static org.testng.Assert.assertFalse;
import static org.testng.Assert.assertTrue;

/**
 * @author Hardy Ferentschik
 */
public class CreditCardNumberValidatorTest {

	private static CreditCardNumberValidator validator;

	@BeforeClass
	public static void init() {
		validator = new CreditCardNumberValidator();
	}

	@Test
	public void testInvalidCreditCardNumber() throws Exception {
		assertFalse( validator.isValid( "1234567890123456", null ) );
	}

	@Test
	public void testValidCreditCardNumber() throws Exception {
		assertTrue( validator.isValid( "541234567890125", null ) );
	}

	@Test
	public void testNullValue() throws Exception {
		assertTrue( validator.isValid( null, null ) );
	}
}
