/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.file;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import sun.net.www.MessageHeader;
import sun.net.www.MimeEntry;
import sun.net.www.MimeTable;
import sun.net.www.ParseUtil;
import sun.net.www.URLConnection;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;

public class FileURLConnection
extends URLConnection {
    static String CONTENT_LENGTH = "content-length";
    static String CONTENT_TYPE = "content-type";
    static String TEXT_PLAIN = "text/plain";
    static String LAST_MODIFIED = "last-modified";
    String contentType;
    InputStream is;
    File file;
    String filename;
    boolean isDirectory = false;
    boolean exists = false;
    List files;
    long length = 0L;
    long lastModified = 0L;
    private boolean initializedHeaders = false;
    Permission permission;

    protected FileURLConnection(URL uRL, File file) {
        super(uRL);
        this.file = file;
    }

    public void connect() throws IOException {
        if (!this.connected) {
            this.filename = this.file.toString();
            this.isDirectory = this.file.isDirectory();
            if (this.isDirectory) {
                this.files = Arrays.asList(this.file.list());
            } else {
                this.is = new BufferedInputStream(this.chainDecorator(new FileInputStream(this.filename)));
            }
            this.connected = true;
        }
    }

    protected InputStream chainDecorator(InputStream inputStream) {
        return inputStream;
    }

    private void initializeHeaders() {
        try {
            this.connect();
            this.exists = this.file.exists();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.initializedHeaders || !this.exists) {
            this.length = this.file.length();
            this.lastModified = this.file.lastModified();
            if (!this.isDirectory) {
                FileNameMap fileNameMap = java.net.URLConnection.getFileNameMap();
                this.contentType = fileNameMap.getContentTypeFor(this.filename);
                if (this.contentType != null) {
                    this.properties.add(CONTENT_TYPE, this.contentType);
                }
                this.properties.add(CONTENT_LENGTH, String.valueOf(this.length));
                if (this.lastModified != 0L) {
                    Date date = new Date(this.lastModified);
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                    this.properties.add(LAST_MODIFIED, simpleDateFormat.format(date));
                }
            } else {
                this.properties.add(CONTENT_TYPE, TEXT_PLAIN);
            }
            this.initializedHeaders = true;
        }
    }

    public String getHeaderField(String string) {
        this.initializeHeaders();
        return super.getHeaderField(string);
    }

    public String getHeaderField(int n) {
        this.initializeHeaders();
        return super.getHeaderField(n);
    }

    public int getContentLength() {
        this.initializeHeaders();
        return super.getContentLength();
    }

    public String getHeaderFieldKey(int n) {
        this.initializeHeaders();
        return super.getHeaderFieldKey(n);
    }

    public MessageHeader getProperties() {
        this.initializeHeaders();
        return super.getProperties();
    }

    public synchronized InputStream getInputStream() throws IOException {
        this.connect();
        if (this.is == null) {
            int n = (Integer)AccessController.doPrivileged(new GetIntegerAction("hotjava.file.iconheight", 32));
            int n2 = (Integer)AccessController.doPrivileged(new GetIntegerAction("hotjava.file.iconwidth", 32));
            if (this.isDirectory) {
                FileNameMap fileNameMap = java.net.URLConnection.getFileNameMap();
                StringBuffer stringBuffer = new StringBuffer();
                if (this.files == null) {
                    throw new FileNotFoundException(this.filename);
                }
                Collections.sort(this.files, Collator.getInstance());
                stringBuffer.append("<title>");
                stringBuffer.append((String)AccessController.doPrivileged(new GetPropertyAction("file.dir.title", "Directory Listing")));
                stringBuffer.append("</title>\n");
                stringBuffer.append("<base href=\"file://localhost/");
                stringBuffer.append(this.filename.substring(this.filename.charAt(0) == '/' ? 1 : 0));
                if (this.filename.endsWith("/")) {
                    stringBuffer.append("\">");
                } else {
                    stringBuffer.append("/\">");
                }
                stringBuffer.append("<h1>");
                stringBuffer.append(this.filename);
                stringBuffer.append("</h1>\n");
                stringBuffer.append("<hr>\n");
                Boolean bl = (Boolean)AccessController.doPrivileged(new GetBooleanAction("file.hidedotfiles"));
                boolean bl2 = bl;
                for (int i = 0; i < this.files.size(); ++i) {
                    String string = (String)this.files.get(i);
                    if (bl2 && string.indexOf(46) == 0) continue;
                    stringBuffer.append("<img align=middle src=\"");
                    if (new File(this.filename + "/" + string).isDirectory()) {
                        stringBuffer.append("doc:/lib/images/ftp/directory.gif\" width=" + n2 + " height=" + n + ">\n");
                    } else {
                        String string2;
                        MimeEntry mimeEntry;
                        String string3 = "doc:/lib/images/ftp/file.gif";
                        if (fileNameMap instanceof MimeTable && (mimeEntry = ((MimeTable)fileNameMap).findByFileName(string)) != null && (string2 = mimeEntry.getImageFileName()) != null) {
                            string3 = string2;
                        }
                        stringBuffer.append(string3);
                        stringBuffer.append("\" width=" + n2 + " height=" + n + ">\n");
                    }
                    stringBuffer.append("<a href=\"");
                    stringBuffer.append("\">");
                    stringBuffer.append(string);
                    stringBuffer.append("</a><br>");
                }
                this.is = new ByteArrayInputStream(stringBuffer.toString().getBytes());
            } else {
                throw new FileNotFoundException(this.filename);
            }
        }
        return this.is;
    }

    public Permission getPermission() throws IOException {
        if (this.permission == null) {
            String string = ParseUtil.decode(this.url.getPath());
            this.permission = File.separatorChar == '/' ? new FilePermission(string, "read") : new FilePermission(string.replace('/', File.separatorChar), "read");
        }
        return this.permission;
    }
}

