/* Copyright (C) 2013-2017 Laurent Montel <montel@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef SIEVEEDITORABSTRACTWIDGET_H
#define SIEVEEDITORABSTRACTWIDGET_H

#include <QWidget>
#include "../util/sieveimapaccountsettings.h"
#include "ksieveui_private_export.h"
namespace KSieveUi {
class SieveImapAccountSettings;
class KSIEVEUI_TESTS_EXPORT SieveEditorAbstractWidget : public QWidget
{
    Q_OBJECT
public:
    explicit SieveEditorAbstractWidget(QWidget *parent = nullptr);
    ~SieveEditorAbstractWidget();

    virtual QString currentscript();
    virtual void setImportScript(const QString &);
    void saveAs(const QString &defaultName);

    KSieveUi::SieveImapAccountSettings sieveImapAccountSettings() const;

    void setSieveImapAccountSettings(const KSieveUi::SieveImapAccountSettings &sieveImapAccountSettings);

public Q_SLOTS:
    void slotImport();

protected:
    KSieveUi::SieveImapAccountSettings mSieveImapAccountSettings;

private:
    bool loadFromFile(const QString &filename);
};
}

#endif // SIEVEEDITORABSTRACTWIDGET_H
