
/*
 * Copyright (C) Nginx, Inc.
 *
 * Do not edit, generated by: utils/lexer_keyword.py.
 */


#ifndef _NJS_LEXER_TABLES_H_INCLUDED_
#define _NJS_LEXER_TABLES_H_INCLUDED_


static const njs_keyword_t njs_lexer_kws[54] =
{
    {
        .entry = { njs_str("arguments") },
        .type = NJS_TOKEN_ARGUMENTS,
        .reserved = 0
    },

    {
        .entry = { njs_str("async") },
        .type = NJS_TOKEN_ASYNC,
        .reserved = 0
    },

    {
        .entry = { njs_str("await") },
        .type = NJS_TOKEN_AWAIT,
        .reserved = 1
    },

    {
        .entry = { njs_str("break") },
        .type = NJS_TOKEN_BREAK,
        .reserved = 1
    },

    {
        .entry = { njs_str("case") },
        .type = NJS_TOKEN_CASE,
        .reserved = 1
    },

    {
        .entry = { njs_str("catch") },
        .type = NJS_TOKEN_CATCH,
        .reserved = 1
    },

    {
        .entry = { njs_str("class") },
        .type = NJS_TOKEN_CLASS,
        .reserved = 1
    },

    {
        .entry = { njs_str("const") },
        .type = NJS_TOKEN_CONST,
        .reserved = 1
    },

    {
        .entry = { njs_str("continue") },
        .type = NJS_TOKEN_CONTINUE,
        .reserved = 1
    },

    {
        .entry = { njs_str("debugger") },
        .type = NJS_TOKEN_DEBUGGER,
        .reserved = 1
    },

    {
        .entry = { njs_str("default") },
        .type = NJS_TOKEN_DEFAULT,
        .reserved = 1
    },

    {
        .entry = { njs_str("delete") },
        .type = NJS_TOKEN_DELETE,
        .reserved = 1
    },

    {
        .entry = { njs_str("do") },
        .type = NJS_TOKEN_DO,
        .reserved = 1
    },

    {
        .entry = { njs_str("else") },
        .type = NJS_TOKEN_ELSE,
        .reserved = 1
    },

    {
        .entry = { njs_str("enum") },
        .type = NJS_TOKEN_ENUM,
        .reserved = 1
    },

    {
        .entry = { njs_str("eval") },
        .type = NJS_TOKEN_EVAL,
        .reserved = 0
    },

    {
        .entry = { njs_str("export") },
        .type = NJS_TOKEN_EXPORT,
        .reserved = 1
    },

    {
        .entry = { njs_str("extends") },
        .type = NJS_TOKEN_EXTENDS,
        .reserved = 1
    },

    {
        .entry = { njs_str("false") },
        .type = NJS_TOKEN_FALSE,
        .reserved = 1
    },

    {
        .entry = { njs_str("finally") },
        .type = NJS_TOKEN_FINALLY,
        .reserved = 1
    },

    {
        .entry = { njs_str("for") },
        .type = NJS_TOKEN_FOR,
        .reserved = 1
    },

    {
        .entry = { njs_str("from") },
        .type = NJS_TOKEN_FROM,
        .reserved = 0
    },

    {
        .entry = { njs_str("function") },
        .type = NJS_TOKEN_FUNCTION,
        .reserved = 1
    },

    {
        .entry = { njs_str("if") },
        .type = NJS_TOKEN_IF,
        .reserved = 1
    },

    {
        .entry = { njs_str("implements") },
        .type = NJS_TOKEN_IMPLEMENTS,
        .reserved = 1
    },

    {
        .entry = { njs_str("import") },
        .type = NJS_TOKEN_IMPORT,
        .reserved = 1
    },

    {
        .entry = { njs_str("in") },
        .type = NJS_TOKEN_IN,
        .reserved = 1
    },

    {
        .entry = { njs_str("instanceof") },
        .type = NJS_TOKEN_INSTANCEOF,
        .reserved = 1
    },

    {
        .entry = { njs_str("interface") },
        .type = NJS_TOKEN_INTERFACE,
        .reserved = 1
    },

    {
        .entry = { njs_str("let") },
        .type = NJS_TOKEN_LET,
        .reserved = 1
    },

    {
        .entry = { njs_str("meta") },
        .type = NJS_TOKEN_META,
        .reserved = 0
    },

    {
        .entry = { njs_str("new") },
        .type = NJS_TOKEN_NEW,
        .reserved = 1
    },

    {
        .entry = { njs_str("null") },
        .type = NJS_TOKEN_NULL,
        .reserved = 1
    },

    {
        .entry = { njs_str("of") },
        .type = NJS_TOKEN_OF,
        .reserved = 0
    },

    {
        .entry = { njs_str("package") },
        .type = NJS_TOKEN_PACKAGE,
        .reserved = 1
    },

    {
        .entry = { njs_str("private") },
        .type = NJS_TOKEN_PRIVATE,
        .reserved = 1
    },

    {
        .entry = { njs_str("protected") },
        .type = NJS_TOKEN_PROTECTED,
        .reserved = 1
    },

    {
        .entry = { njs_str("public") },
        .type = NJS_TOKEN_PUBLIC,
        .reserved = 1
    },

    {
        .entry = { njs_str("return") },
        .type = NJS_TOKEN_RETURN,
        .reserved = 1
    },

    {
        .entry = { njs_str("static") },
        .type = NJS_TOKEN_STATIC,
        .reserved = 1
    },

    {
        .entry = { njs_str("super") },
        .type = NJS_TOKEN_SUPER,
        .reserved = 1
    },

    {
        .entry = { njs_str("switch") },
        .type = NJS_TOKEN_SWITCH,
        .reserved = 1
    },

    {
        .entry = { njs_str("target") },
        .type = NJS_TOKEN_TARGET,
        .reserved = 0
    },

    {
        .entry = { njs_str("this") },
        .type = NJS_TOKEN_THIS,
        .reserved = 1
    },

    {
        .entry = { njs_str("throw") },
        .type = NJS_TOKEN_THROW,
        .reserved = 1
    },

    {
        .entry = { njs_str("true") },
        .type = NJS_TOKEN_TRUE,
        .reserved = 1
    },

    {
        .entry = { njs_str("try") },
        .type = NJS_TOKEN_TRY,
        .reserved = 1
    },

    {
        .entry = { njs_str("typeof") },
        .type = NJS_TOKEN_TYPEOF,
        .reserved = 1
    },

    {
        .entry = { njs_str("undefined") },
        .type = NJS_TOKEN_UNDEFINED,
        .reserved = 0
    },

    {
        .entry = { njs_str("var") },
        .type = NJS_TOKEN_VAR,
        .reserved = 1
    },

    {
        .entry = { njs_str("void") },
        .type = NJS_TOKEN_VOID,
        .reserved = 1
    },

    {
        .entry = { njs_str("while") },
        .type = NJS_TOKEN_WHILE,
        .reserved = 1
    },

    {
        .entry = { njs_str("with") },
        .type = NJS_TOKEN_WITH,
        .reserved = 1
    },

    {
        .entry = { njs_str("yield") },
        .type = NJS_TOKEN_YIELD,
        .reserved = 1
    },
};


static const njs_lexer_keyword_entry_t njs_lexer_keyword_entries[99] =
{
    { NULL, NULL, 98, 0 },
    { "continue", &njs_lexer_kws[8], 8, 0 },
    { "finally", &njs_lexer_kws[19], 7, 0 },
    { "return", &njs_lexer_kws[38], 6, 0 },
    { "static", &njs_lexer_kws[39], 6, 0 },
    { "async", &njs_lexer_kws[1], 5, 0 },
    { "break", &njs_lexer_kws[3], 5, 0 },
    { "interface", &njs_lexer_kws[28], 9, 0 },
    { "case", &njs_lexer_kws[4], 4, 0 },
    { "import", &njs_lexer_kws[25], 6, 0 },
    { "protected", &njs_lexer_kws[36], 9, 0 },
    { "switch", &njs_lexer_kws[41], 6, 0 },
    { "catch", &njs_lexer_kws[5], 5, 1 },
    { "delete", &njs_lexer_kws[11], 6, 0 },
    { "else", &njs_lexer_kws[13], 4, 0 },
    { "private", &njs_lexer_kws[35], 7, 0 },
    { "extends", &njs_lexer_kws[17], 7, 0 },
    { "this", &njs_lexer_kws[43], 4, 0 },
    { "false", &njs_lexer_kws[18], 5, 0 },
    { "await", &njs_lexer_kws[2], 5, 0 },
    { NULL, NULL, 0, 0 },
    { "public", &njs_lexer_kws[37], 6, 0 },
    { NULL, NULL, 0, 0 },
    { "class", &njs_lexer_kws[6], 5, 0 },
    { "const", &njs_lexer_kws[7], 5, 4 },
    { NULL, NULL, 0, 0 },
    { "try", &njs_lexer_kws[46], 3, 0 },
    { "null", &njs_lexer_kws[32], 4, 0 },
    { NULL, NULL, 0, 0 },
    { "do", &njs_lexer_kws[12], 2, 0 },
    { "var", &njs_lexer_kws[49], 3, 0 },
    { "if", &njs_lexer_kws[23], 2, 7 },
    { "implements", &njs_lexer_kws[24], 10, 0 },
    { "with", &njs_lexer_kws[52], 4, 0 },
    { NULL, NULL, 0, 0 },
    { "eval", &njs_lexer_kws[15], 4, 9 },
    { NULL, NULL, 0, 0 },
    { "target", &njs_lexer_kws[42], 6, 0 },
    { "enum", &njs_lexer_kws[14], 4, 10 },
    { "instanceof", &njs_lexer_kws[27], 10, 0 },
    { NULL, NULL, 0, 0 },
    { "debugger", &njs_lexer_kws[9], 8, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { "default", &njs_lexer_kws[10], 7, 0 },
    { "void", &njs_lexer_kws[50], 4, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { "undefined", &njs_lexer_kws[48], 9, 0 },
    { "from", &njs_lexer_kws[21], 4, 0 },
    { "package", &njs_lexer_kws[34], 7, 15 },
    { NULL, NULL, 0, 0 },
    { "yield", &njs_lexer_kws[53], 5, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { "of", &njs_lexer_kws[33], 2, 0 },
    { NULL, NULL, 0, 0 },
    { "function", &njs_lexer_kws[22], 8, 0 },
    { NULL, NULL, 0, 0 },
    { "true", &njs_lexer_kws[45], 4, 16 },
    { "new", &njs_lexer_kws[31], 3, 0 },
    { "export", &njs_lexer_kws[16], 6, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { "for", &njs_lexer_kws[20], 3, 0 },
    { "while", &njs_lexer_kws[51], 5, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { "typeof", &njs_lexer_kws[47], 6, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { "super", &njs_lexer_kws[40], 5, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { "let", &njs_lexer_kws[29], 3, 19 },
    { "in", &njs_lexer_kws[26], 2, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { "throw", &njs_lexer_kws[44], 5, 0 },
    { "arguments", &njs_lexer_kws[0], 9, 0 },
    { "meta", &njs_lexer_kws[30], 4, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
    { NULL, NULL, 0, 0 },
};


#endif /* _NJS_LEXER_TABLES_H_INCLUDED_ */
