//******************************************************************************
//  Copyright (c) 2005-2011 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#ifndef QVARIANT_C_H
#define QVARIANT_C_H

#include <QtCore>
#include "pascalbind.h"

C_EXPORT QVariantH QVariant_create();
C_EXPORT void QVariant_destroy(QVariantH handle);
C_EXPORT QVariantH QVariant_create3(int typeOrUserType, const void* copy);
C_EXPORT QVariantH QVariant_create4(const QVariantH other);
C_EXPORT QVariantH QVariant_create5(QDataStreamH s);
C_EXPORT QVariantH QVariant_create6(int i);
C_EXPORT QVariantH QVariant_create8(qlonglong ll);
C_EXPORT QVariantH QVariant_create9(qulonglong ull);
C_EXPORT QVariantH QVariant_create10(bool b);
C_EXPORT QVariantH QVariant_create11(double d);
C_EXPORT QVariantH QVariant_create12(const char* str);
C_EXPORT QVariantH QVariant_create13(const QByteArrayH bytearray);
C_EXPORT QVariantH QVariant_create14(const QBitArrayH bitarray);
C_EXPORT QVariantH QVariant_create15(PWideString string);
C_EXPORT QVariantH QVariant_create16(const QLatin1StringH string);
C_EXPORT QVariantH QVariant_create17(const QStringListH stringlist);
C_EXPORT QVariantH QVariant_create18(const QCharH qchar);
C_EXPORT QVariantH QVariant_create19(const QDateH date);
C_EXPORT QVariantH QVariant_create20(const QTimeH time);
C_EXPORT QVariantH QVariant_create21(const QDateTimeH datetime);
C_EXPORT QVariantH QVariant_create25(const QPointFH pt);
C_EXPORT QVariantH QVariant_create26(const QLineH line);
C_EXPORT QVariantH QVariant_create27(const QLineFH line);
C_EXPORT QVariantH QVariant_create28(PRect rect);
C_EXPORT QVariantH QVariant_create29(const QRectFH rect);
C_EXPORT QVariantH QVariant_create30(const QUrlH url);
C_EXPORT QVariantH QVariant_create31(const QLocaleH locale);
C_EXPORT QVariantH QVariant_create32(const QRegExpH regExp);
C_EXPORT QVariantH QVariant_create33(Qt::GlobalColor color);
C_EXPORT QVariant::Type QVariant_type(QVariantH handle);
C_EXPORT int QVariant_userType(QVariantH handle);
C_EXPORT const char* QVariant_typeName(QVariantH handle);
C_EXPORT bool QVariant_canConvert(QVariantH handle, QVariant::Type t);
C_EXPORT bool QVariant_convert(QVariantH handle, QVariant::Type t);
C_EXPORT bool QVariant_isValid(QVariantH handle);
C_EXPORT bool QVariant_isNull(QVariantH handle);
C_EXPORT void QVariant_clear(QVariantH handle);
C_EXPORT void QVariant_detach(QVariantH handle);
C_EXPORT bool QVariant_isDetached(QVariantH handle);
C_EXPORT int QVariant_toInt(QVariantH handle, bool* ok);
C_EXPORT uint QVariant_toUInt(QVariantH handle, bool* ok);
C_EXPORT qlonglong QVariant_toLongLong(QVariantH handle, bool* ok);
C_EXPORT qulonglong QVariant_toULongLong(QVariantH handle, bool* ok);
C_EXPORT bool QVariant_toBool(QVariantH handle);
C_EXPORT double QVariant_toDouble(QVariantH handle, bool* ok);
C_EXPORT void QVariant_toByteArray(QVariantH handle, QByteArrayH retval);
C_EXPORT void QVariant_toBitArray(QVariantH handle, QBitArrayH retval);
C_EXPORT void QVariant_toString(QVariantH handle, PWideString retval);
C_EXPORT void QVariant_toStringList(QVariantH handle, QStringListH retval);
C_EXPORT void QVariant_toChar(QVariantH handle, PWideChar retval);
C_EXPORT void QVariant_toDate(QVariantH handle, QDateH retval);
C_EXPORT void QVariant_toTime(QVariantH handle, QTimeH retval);
C_EXPORT void QVariant_toDateTime(QVariantH handle, QDateTimeH retval);
C_EXPORT void QVariant_toPoint(QVariantH handle, PQtPoint retval);
C_EXPORT void QVariant_toPointF(QVariantH handle, PQtPointF retval);
C_EXPORT void QVariant_toRect(QVariantH handle, PRect retval);
C_EXPORT void QVariant_toSize(QVariantH handle, PSize retval);
C_EXPORT void QVariant_toSizeF(QVariantH handle, QSizeFH retval);
C_EXPORT void QVariant_toLine(QVariantH handle, QLineH retval);
C_EXPORT void QVariant_toLineF(QVariantH handle, QLineFH retval);
C_EXPORT void QVariant_toRectF(QVariantH handle, QRectFH retval);
C_EXPORT void QVariant_toUrl(QVariantH handle, QUrlH retval);
C_EXPORT void QVariant_toLocale(QVariantH handle, QLocaleH retval);
C_EXPORT void QVariant_toRegExp(QVariantH handle, QRegExpH retval);
C_EXPORT void QVariant_load(QVariantH handle, QDataStreamH ds);
C_EXPORT void QVariant_save(QVariantH handle, QDataStreamH ds);
C_EXPORT const char* QVariant_typeToName(QVariant::Type type);
C_EXPORT QVariant::Type QVariant_nameToType(const char* name);
C_EXPORT const void* QVariant_constData(QVariantH handle);

#endif
