#
# Copyright (c) 2010 Canonical
#
# Written by Gustavo Niemeyer <gustavo@niemeyer.net>
#
# This file is part of the Xpresser GUI automation library.
#
# Xpresser is free software; you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3,
# as published by the Free Software Foundation.
#
# Xpresser is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
from xpresser.imagematch import ImageMatch, ImageMatchError
from xpresser.image import Image

from xpresser.lib.testing import TestCase


class ImageMatchTest(TestCase):

    def test_constructor(self):
        image = Image(width=40, height=50, focus_delta=(4, 5))
        match = ImageMatch(image, 100, 200, 0.5)
        self.assertEquals(match.image, image)
        self.assertEquals(match.x, 100)
        self.assertEquals(match.y, 200)
        self.assertEquals(match.similarity, 0.5)
        self.assertEquals(match.focus_point, (100+40//2+4, 200+50//2+5))

    def test_error_on_lack_of_height(self):
        image = Image(width=1)
        self.assertRaises(ImageMatchError, ImageMatch, image, 0, 0, 0)

    def test_error_on_lack_of_width(self):
        image = Image(height=1)
        self.assertRaises(ImageMatchError, ImageMatch, image, 0, 0, 0)
