# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.light import Light


class ExternalLight(Light):
    r"""
    ExternalLight - a virtual light object for tweaking existing
    lights in an external 3D rendering context
    
    Superclass: Light
    
    ExternalLight is a virtual light object for tweaking existing
    lights in an external 3D rendering context. It provides a mechanism
    to adjust and control parameters of existing lights in an external
    open_gl context.
    
    It provides methods to locate and point the light, and set its
    brightness and color. In addition to the basic infinite distance
    point light source attributes, you can also specify the light
    attenuation values and cone angle. These attributes are only used if
    the light is a positional light.
    
    By default, ExternalLight overrides specific light parameters as
    set by the user. Setting the #replace_mode to ALL_PARAMS, will set all
    the light parameter values to the ones set in ExternalLight.
    
    @warning
    Use the ExternalLight object to tweak parameters of lights created
    in the external context. This class does NOT create new lights in the
    scene.
    
    @par Example: Usage example for ExternalLight in conjunction with
    ExternalOpenGLRenderer and \ref external_vtk_widget{.cpp}
       NewexLight;
       exLight->set_light_index(GL_LIGHT0); // GL_LIGHT0 identifies the
    external light
       exLight->set_diffuse_color(1.0, 0.0, 0.0); // Changing diffuse color
       NewexWidget;
       ExternalOpenGLRenderer* ren =
    ExternalOpenGLRenderer::SafeDownCast(exWidget->AddRenderer());
       ren->add_external_light(exLight.get_pointer());
    
    @sa
    ExternalOpenGLRenderer \ref external_vtk_widget
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkExternalLight, obj, update, **traits)
    
    ambient_color = tvtk_base.vtk_color_trait((0.0, 0.0, 0.0), desc=\
        r"""
        Override Set method to keep a record of changed value
        """
    )

    def _ambient_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAmbientColor,
                        self.ambient_color, False)

    attenuation_values = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(1.0, 0.0, 0.0), cols=3, desc=\
        r"""
        Override Set method to keep a record of changed value
        """
    )

    def _attenuation_values_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAttenuationValues,
                        self.attenuation_values)

    cone_angle = traits.Float(30.0, enter_set=True, auto_set=False, desc=\
        r"""
        Override Set method to keep a record of changed value
        """
    )

    def _cone_angle_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetConeAngle,
                        self.cone_angle)

    diffuse_color = tvtk_base.vtk_color_trait((1.0, 1.0, 1.0), desc=\
        r"""
        Override Set method to keep a record of changed value
        """
    )

    def _diffuse_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDiffuseColor,
                        self.diffuse_color, False)

    exponent = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        r"""
        Override Set method to keep a record of changed value
        """
    )

    def _exponent_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExponent,
                        self.exponent)

    focal_point = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        r"""
        Override Set method to keep a record of changed value
        """
    )

    def _focal_point_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFocalPoint,
                        self.focal_point)

    intensity = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        r"""
        Override Set method to keep a record of changed value
        """
    )

    def _intensity_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetIntensity,
                        self.intensity)

    light_index = traits.Int(16384, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get light index This should be the open_gl light identifier.
        (e.g.: GL_LIGHT0) (Default: GL_LIGHT0)
        """
    )

    def _light_index_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLightIndex,
                        self.light_index)

    position = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 1.0), cols=3, desc=\
        r"""
        Override Set method to keep a record of changed value
        """
    )

    def _position_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPosition,
                        self.position)

    replace_mode = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get replace mode This determines how this external_light will
        be used to tweak parameters on an existing light in the rendering
        context. (Default: INDIVIDUAL_PARAMS)
        
        * \li ExternalLight::INDIVIDUAL_PARAMS : Replace parameters
        * specifically set by the user by calling the parameter
        * Set method. (e.g. set_diffuse_color())
        
        * \li ExternalLight::ALL_PARAMS : Replace all
        * parameters of the light with the parameters in ExternalLight
        object.
        """
    )

    def _replace_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetReplaceMode,
                        self.replace_mode)

    specular_color = tvtk_base.vtk_color_trait((1.0, 1.0, 1.0), desc=\
        r"""
        Override Set method to keep a record of changed value
        """
    )

    def _specular_color_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSpecularColor,
                        self.specular_color, False)

    def _get_ambient_color_set(self):
        return self._vtk_obj.GetAmbientColorSet()
    ambient_color_set = traits.Property(_get_ambient_color_set, desc=\
        r"""
        Check whether value set by user
        """
    )

    def _get_attenuation_values_set(self):
        return self._vtk_obj.GetAttenuationValuesSet()
    attenuation_values_set = traits.Property(_get_attenuation_values_set, desc=\
        r"""
        Check whether value set by user
        """
    )

    def _get_cone_angle_set(self):
        return self._vtk_obj.GetConeAngleSet()
    cone_angle_set = traits.Property(_get_cone_angle_set, desc=\
        r"""
        Check whether value set by user
        """
    )

    def _get_diffuse_color_set(self):
        return self._vtk_obj.GetDiffuseColorSet()
    diffuse_color_set = traits.Property(_get_diffuse_color_set, desc=\
        r"""
        Check whether value set by user
        """
    )

    def _get_exponent_set(self):
        return self._vtk_obj.GetExponentSet()
    exponent_set = traits.Property(_get_exponent_set, desc=\
        r"""
        Check whether value set by user
        """
    )

    def _get_focal_point_set(self):
        return self._vtk_obj.GetFocalPointSet()
    focal_point_set = traits.Property(_get_focal_point_set, desc=\
        r"""
        Check whether value set by user
        """
    )

    def _get_intensity_set(self):
        return self._vtk_obj.GetIntensitySet()
    intensity_set = traits.Property(_get_intensity_set, desc=\
        r"""
        Check whether value set by user
        """
    )

    def _get_position_set(self):
        return self._vtk_obj.GetPositionSet()
    position_set = traits.Property(_get_position_set, desc=\
        r"""
        Check whether value set by user
        """
    )

    def _get_positional_set(self):
        return self._vtk_obj.GetPositionalSet()
    positional_set = traits.Property(_get_positional_set, desc=\
        r"""
        Check whether value set by user
        """
    )

    def _get_specular_color_set(self):
        return self._vtk_obj.GetSpecularColorSet()
    specular_color_set = traits.Property(_get_specular_color_set, desc=\
        r"""
        Check whether value set by user
        """
    )

    _updateable_traits_ = \
    (('positional', 'GetPositional'), ('switch', 'GetSwitch'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('light_type', 'GetLightType'), ('ambient_color', 'GetAmbientColor'),
    ('attenuation_values', 'GetAttenuationValues'), ('cone_angle',
    'GetConeAngle'), ('diffuse_color', 'GetDiffuseColor'), ('exponent',
    'GetExponent'), ('focal_point', 'GetFocalPoint'), ('intensity',
    'GetIntensity'), ('light_index', 'GetLightIndex'), ('position',
    'GetPosition'), ('replace_mode', 'GetReplaceMode'), ('specular_color',
    'GetSpecularColor'), ('shadow_attenuation', 'GetShadowAttenuation'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'positional', 'switch',
    'light_type', 'ambient_color', 'attenuation_values', 'cone_angle',
    'diffuse_color', 'exponent', 'focal_point', 'intensity',
    'light_index', 'object_name', 'position', 'replace_mode',
    'shadow_attenuation', 'specular_color'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ExternalLight, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ExternalLight properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['positional', 'switch'], ['light_type'], ['ambient_color',
            'attenuation_values', 'cone_angle', 'diffuse_color', 'exponent',
            'focal_point', 'intensity', 'light_index', 'object_name', 'position',
            'replace_mode', 'shadow_attenuation', 'specular_color']),
            title='Edit ExternalLight properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ExternalLight properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

