# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.abstract_cell_locator import AbstractCellLocator


class StaticCellLocator(AbstractCellLocator):
    r"""
    StaticCellLocator - perform fast cell location operations
    
    Superclass: AbstractCellLocator
    
    StaticCellLocator is a type of AbstractCellLocator that
    accelerates certain operations when performing spatial operations on
    cells. These operations include finding a point that contains a cell,
    and intersecting cells with a line.
    
    StaticCellLocator is an accelerated version of CellLocator. It
    is threaded (via SMPTools), and supports one-time static
    construction (i.e., incremental cell insertion is not supported).
    
    @warning
    StaticCellLocator utilizes the following parent class parameters:
    - Automatic                   (default true)
    - number_of_cells_per_node        (default 10)
    - use_existing_search_structure  (default false)
    
    StaticCellLocator does NOT utilize the following parameters:
    - cache_cell_bounds             (always cached)
    - Tolerance
    - Level
    - max_level
    - retain_cell_lists
    
    @warning
    This class is templated. It may run slower than serial execution if
    the code is not optimized during compilation. Build in Release or
    release_with_debug_info.
    
    @sa
    AbstractCellLocator CellLocator CellTreeLocator
    ModifiedBSPTree OBBTree
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkStaticCellLocator, obj, update, **traits)
    
    use_diagonal_length_tolerance = tvtk_base.false_bool_trait(desc=\
        r"""
        These methods are deprecated. This flag was used in internally in
        conjunction with Tolerance, which has been removed because nobody
        was using it, and it would lead to really slow performance if the
        dataset was small bounds-wise. Tolerance was originally
        introduced to solve intersection_with_line issues the existed
        before. These issues have been resolved by using double tolerance
        internally.
        
        When set to true, the cell_binner will multiply the locator
        tolerance by the diagonal length of the dataset to compute its
        own tolerance. When not, it uses the locator tolerance directly.
        Default is false.
        """
    )

    def _use_diagonal_length_tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseDiagonalLengthTolerance,
                        self.use_diagonal_length_tolerance_)

    divisions = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="int", value=(100, 100, 100), cols=3, desc=\
        r"""
        Set the number of divisions in x-y-z directions. If the Automatic
        data member is enabled, the Divisions are set according to the
        number_of_cells_per_node and max_number_of_buckets data members. The
        number of divisions must be >= 1 in each direction.
        """
    )

    def _divisions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDivisions,
                        self.divisions)

    max_number_of_buckets = traits.Trait(2147483647, traits.Range(1000, 9223372036854775807, enter_set=True, auto_set=False), desc=\
        r"""
        Set the maximum number of buckets in the locator. By default the
        value is set to VTK_INT_MAX. Note that there are significant
        performance implications at work here. If the number of buckets
        is set very large (meaning > VTK_INT_MAX) then internal sorting
        may be performed using 64-bit integers (which is much slower than
        using a 32-bit int). Of course, memory requirements may
        dramatically increase as well.  It is recommended that the
        default value be used; but for extremely large data it may be
        desired to create a locator with an exceptionally large number of
        buckets. Note also that during initialization of the locator if
        the max_number_of_buckets threshold is exceeded, the Divisions are
        scaled down in such a way as not to exceed the max_number_of_buckets
        proportionally to the size of the bounding box in the x-y-z
        directions.
        """
    )

    def _max_number_of_buckets_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaxNumberOfBuckets,
                        self.max_number_of_buckets)

    def _get_large_ids(self):
        return self._vtk_obj.GetLargeIds()
    large_ids = traits.Property(_get_large_ids, desc=\
        r"""
        Inform the user as to whether large ids are being used. This flag
        only has meaning after the locator has been built. Large ids are
        used when the number of binned points, or the number of bins, is
        >= the maximum number of buckets (specified by the user). Note
        that large_ids are only available on 64-bit architectures.
        """
    )

    _updateable_traits_ = \
    (('use_diagonal_length_tolerance', 'GetUseDiagonalLengthTolerance'),
    ('cache_cell_bounds', 'GetCacheCellBounds'), ('lazy_evaluation',
    'GetLazyEvaluation'), ('retain_cell_lists', 'GetRetainCellLists'),
    ('automatic', 'GetAutomatic'), ('use_existing_search_structure',
    'GetUseExistingSearchStructure'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('divisions',
    'GetDivisions'), ('max_number_of_buckets', 'GetMaxNumberOfBuckets'),
    ('number_of_cells_per_node', 'GetNumberOfCellsPerNode'), ('max_level',
    'GetMaxLevel'), ('tolerance', 'GetTolerance'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['automatic', 'cache_cell_bounds', 'debug', 'global_warning_display',
    'lazy_evaluation', 'retain_cell_lists',
    'use_diagonal_length_tolerance', 'use_existing_search_structure',
    'divisions', 'max_level', 'max_number_of_buckets',
    'number_of_cells_per_node', 'object_name', 'tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(StaticCellLocator, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit StaticCellLocator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['automatic', 'cache_cell_bounds', 'lazy_evaluation',
            'retain_cell_lists', 'use_diagonal_length_tolerance',
            'use_existing_search_structure'], [], ['divisions', 'max_level',
            'max_number_of_buckets', 'number_of_cells_per_node', 'object_name',
            'tolerance']),
            title='Edit StaticCellLocator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit StaticCellLocator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

