/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef XMList_H
#include "XMList.h"
#endif

#ifndef XMString_H
#include "XMString.h"
#endif

#include <Xm/List.h>
#include <Xm/ListP.h>


XMList::XMList(Widget list):
	list_(list)
{
}

XMList::~XMList()
{
}

void XMList::clear()
{
	XmListDeleteAllItems(list_);
}

void XMList::add(const string& s)
{
	XMString xm(s);
	XmListAddItemUnselected(list_,xm,0);
}

void XMList::add(const string& s,bool bold)
{
	XMString xm(s,bold ? "bold" : "normal");
	XmListAddItemUnselected(list_,xm,0);
}

void XMList::add(const vector<string>& v)
{
	for(vector<string>::const_iterator j = v.begin(); j != v.end(); ++j)
		add(*j);
}

void XMList::deselect()
{
	XmListDeselectAllItems(list_);
}

void XMList::showSelection()
{
	int* pos;
	int count;
	XmListWidget lw = XmListWidget(list_);


	if(XmListGetSelectedPos(list_,&pos,&count))
	{
		int best = 0;
		for(int i = 0; i < count; i++)
		{
			if(pos[i] >= lw->list.top_position && 
			   pos[i] <= lw->list.top_position + lw->list.visibleItemCount)
					return;
		}
		XmListSetPos(list_,pos[best]);
	}
}

void XMList::select(const string& s)
{
	XMString xm(s);
	XmListSelectItem(list_,xm,false);
}

void XMList::select(const vector<string>& v)
{
	for(vector<string>::const_iterator j = v.begin(); j != v.end(); ++j)
		select(*j);
}

vector<string> XMList::selection()
{
	XmString *items;
	int count;

	XtVaGetValues(list_,
		XmNselectedItems,&items,
		XmNselectedItemCount,&count,
		0);

	vector<string> result(count);
	for(int i = 0; i < count; i++)
	{
		XMString xm(items[i]);
		result[i] = xm;
	}

	return result;
}

vector<string> XMList::values()
{
	XmString *items;
	int count;

	XtVaGetValues(list_,
		XmNitems,&items,
		XmNitemCount,&count,
		0);

	vector<string> result(count);
	for(int i = 0; i < count; i++)
	{
		XMString xm(items[i]);
		result[i] = xm;
	}

	return result;
}

void XMList::multiple()
{
	XtVaSetValues(list_, XmNselectionPolicy, XmMULTIPLE_SELECT,0);
}

void XMList::addMissing(const vector<string>& v)
{
	for(vector<string>::const_iterator j = v.begin(); j != v.end(); ++j)
	{
		XMString xm(*j);
		if(!XmListItemExists(list_,xm))
			XmListAddItemUnselected(list_,xm,0);
	}
}

bool XMList::exists(const string& s)
{
	XMString xm(s);
	return XmListItemExists(list_,xm);
}

void XMList::remove(const string& s)
{
	XMString xm(s);
	XmListDeleteItem(list_,xm);
}

void XMList::remove(const vector<string>& v)
{
	for(vector<string>::const_iterator j = v.begin(); j != v.end(); ++j)
		remove(*j);
}

void XMList::sort()
{
	vector<string> v = values();
	clear();

#ifdef NOUSING
	::sort(v.begin(),v.end());
#else
	std::sort(v.begin(),v.end());
#endif

	add(v);
}
