/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQKeyProfileTree_H
#define MvQKeyProfileTree_H

class MvKeyProfile;

class MvQKeyManager;
class MvQKeyProfileModel;
class MvQKeyProfileSortFilterModel;

#include "MvQTreeView.h"

class MvQKeyProfileTree : public MvQTreeView
{
    Q_OBJECT

public:
    	MvQKeyProfileTree(MvQKeyProfileModel*,MvQKeyProfileSortFilterModel*);
    	~MvQKeyProfileTree() {};
	void setEditable(bool);
	bool editable() {return editable_;}  
	void setPredefinedKeysOnly(bool b) {predefinedKeysOnly_=b;}


public slots:
	void slotMessageTreeContextMenu(const QPoint &);
	void slotMessageTreeColumnMoved(int,int,int);

signals:
	void profileChanged(bool reaload=false);

protected:
	void insertMessageTreeColumn(int);
	void renameMessageTreeHeader(int);
	void deleteMessageTreeColumn(int);
	void editMessageTreeHeader(int);
	MvQKeyProfileModel* messageModel_;
	MvQKeyProfileSortFilterModel* messageSortModel_;

	bool editable_;
	bool predefinedKeysOnly_;

	//MvQKeyManager *keyManager_;	
};

#endif
