/* 
  Copyright (C) 2008 Kai Hertel

	This file is part of mmpong.

	mmpong is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	mmpong is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with mmpong.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __ADDRTABLE_HEADER__
#define __ADDRTABLE_HEADER__

#include <netinet/in.h>
#include <pthread.h>

#define LOOKUP_TABLE_SIZE 1031

// Quick drive-by instructions on how to use this address table:
// * create and initialize the global instance
// * acquire thread-safe access to the value associated with an element key by using addrtable_atomic
// * functions to provide:
//   -- int operation(unsigned *value); // this one is supposed to perform the operations requested on `value`; return codes are handed back to the caller; note though: negative return values are reserved for exclusive use by `addrtable_atomic` itself
//   -- unsigned preset(const struct sockaddr_in key); // this one is supposed to initialize a newly created key with a default value by returning the desired value

int addrtable_init(const int, const pthread_mutexattr_t *);
void addrtable_destroy(const short);
int addrtable_is_active(void);
int addrtable_remove(const struct sockaddr_in);
int addrtable_atomic(const struct sockaddr_in, int (*)(unsigned *), unsigned (*)(const struct sockaddr_in));

#endif
