// Copyright (c) 2012 Ecma International.  All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
es5id: 15.2.3.7-6-a-190
description: >
    Object.defineProperties - 'O' is an Array, 'P' is an array index
    named property, 'P' is own accessor property  (15.4.5.1 step 4.c)
---*/

var arr = [];

Object.defineProperty(arr, "0", {
  get: function() {
    return 11;
  },
  configurable: false
});
assert.throws(TypeError, function() {
  Object.defineProperties(arr, {
    "0": {
      get: function() {
        return 12;
      },
      configurable: true
    }
  });
});
assert.sameValue(arr[0], 11, 'arr[0]');

reportCompare(0, 0);
