/* wire.c -- Handling of packet injection

   Copyright (C) 2007, 2008, 2009, 2010 Eloy Paris

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "includes.h"
#include "nexp_speakers.h"

size_t
wire_dump(pcb_t *pcb, unsigned char *packet, size_t packet_size)
{
    struct nexp_speaker *s;
    size_t bytes_sent;
#if __FreeBSD__ || __APPLE__
    struct ip_hdr *ip;
#endif

    s = pcb->speaker;

    switch (s->type) {
#if 0
    case SPEAKER_IPV4USR:   /* L3 injection, Userspace-routed, via libusr */
	bytes_sent = usr_send(s->_ip4usr, packet, packet_size);
	break;
#endif
    case SPEAKER_IPV4:	    /* L3 injection, kernel-routed via libdnet */
#if __FreeBSD__ || __APPLE__
	/* The IP total len and IP fragment offset fields need to be in host
	 * byte order on certain BSD variants. We must deal with this here rather
	 * than when building the packet because they should be in network byte
	 * order when we are injecting packets at layer 2.
	 */
	if (packet_size >= IP_HDR_LEN) {
	    ip = (struct ip_hdr *) packet;
	    ip->ip_len = ntohs(ip->ip_len);
	    ip->ip_off = ntohs(ip->ip_off);
	}
#endif

	bytes_sent = ip_send(s->_ip, packet, packet_size);

#if __FreeBSD__ || __APPLE__
	/* Undo the byte order switching. */
	if (packet_size >= IP_HDR_LEN) {
	    ip->ip_len = htons(ip->ip_len);
	    ip->ip_off = htons(ip->ip_off);
	}
#endif
	break;
#ifdef __linux__
    case SPEAKER_IPV6: {    /* L3 injection, kernel-routed */
	struct sockaddr_in6 sin6;
	struct ip6_hdr *ip6;

	memset(&sin6, 0, sizeof(sin6) );
	ip6 = (struct ip6_hdr *) packet;
	sin6.sin6_family = AF_INET6;
	memcpy(sin6.sin6_addr.s6_addr, ip6->ip6_dst.data, sizeof(ip6_addr_t) );
	bytes_sent = sendto(s->_ip6, packet, packet_size, 0,
			    (struct sockaddr *) &sin6, sizeof(sin6) );
	break;
    }
#endif
    case SPEAKER_ETHER:	    /* L2 injection via libdnet */
	bytes_sent= eth_send(s->_iface.ether, packet, packet_size);
	break;
    default:
	/* Shouldn't happen */
	bytes_sent = 0;
    }

    return bytes_sent;
}
