/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.math.BigDecimal;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.om.AttributeCollectionImpl;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.AbsentExtensionElement;
import net.sf.saxon.style.DataElement;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLAnalyzeString;
import net.sf.saxon.style.XSLApplyImports;
import net.sf.saxon.style.XSLApplyTemplates;
import net.sf.saxon.style.XSLAttribute;
import net.sf.saxon.style.XSLAttributeSet;
import net.sf.saxon.style.XSLCallTemplate;
import net.sf.saxon.style.XSLCharacterMap;
import net.sf.saxon.style.XSLChoose;
import net.sf.saxon.style.XSLComment;
import net.sf.saxon.style.XSLCopy;
import net.sf.saxon.style.XSLCopyOf;
import net.sf.saxon.style.XSLDecimalFormat;
import net.sf.saxon.style.XSLDocument;
import net.sf.saxon.style.XSLElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLForEach;
import net.sf.saxon.style.XSLForEachGroup;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLIf;
import net.sf.saxon.style.XSLImport;
import net.sf.saxon.style.XSLImportSchema;
import net.sf.saxon.style.XSLInclude;
import net.sf.saxon.style.XSLKey;
import net.sf.saxon.style.XSLMatchingSubstring;
import net.sf.saxon.style.XSLMessage;
import net.sf.saxon.style.XSLNamespace;
import net.sf.saxon.style.XSLNamespaceAlias;
import net.sf.saxon.style.XSLNextMatch;
import net.sf.saxon.style.XSLNumber;
import net.sf.saxon.style.XSLOtherwise;
import net.sf.saxon.style.XSLOutput;
import net.sf.saxon.style.XSLOutputCharacter;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.style.XSLPerformSort;
import net.sf.saxon.style.XSLPreserveSpace;
import net.sf.saxon.style.XSLProcessingInstruction;
import net.sf.saxon.style.XSLResultDocument;
import net.sf.saxon.style.XSLSequence;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.style.XSLText;
import net.sf.saxon.style.XSLValueOf;
import net.sf.saxon.style.XSLVariable;
import net.sf.saxon.style.XSLWhen;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.ElementImpl;
import net.sf.saxon.tree.NodeFactory;

public class StyleNodeFactory
implements NodeFactory {
    protected Configuration config;
    protected NamePool namePool;

    public StyleNodeFactory(Configuration config) {
        this.config = config;
        this.namePool = config.getNamePool();
    }

    public ElementImpl makeElementNode(NodeInfo parent, int nameCode, int typeCode, AttributeCollectionImpl attlist, int[] namespaces, int namespacesUsed, PipelineConfiguration pipe, int locationId, int sequence) {
        StyleElement node;
        Class actualClass;
        boolean toplevel = parent instanceof XSLStylesheet;
        String baseURI = null;
        int lineNumber = -1;
        int columnNumber = -1;
        LocationProvider locator = pipe.getLocationProvider();
        if (locator != null) {
            baseURI = locator.getSystemId(locationId);
            lineNumber = locator.getLineNumber(locationId);
            columnNumber = locator.getColumnNumber(locationId);
        }
        if (parent instanceof DataElement) {
            DataElement d = new DataElement();
            d.setNamespaceDeclarations(namespaces, namespacesUsed);
            d.initialise(nameCode, typeCode, attlist, parent, sequence);
            d.setLocation(baseURI, lineNumber, columnNumber);
            return d;
        }
        int f = nameCode & 0xFFFFF;
        StyleElement e = this.makeXSLElement(f);
        if (e != null) {
            e.setNamespaceDeclarations(namespaces, namespacesUsed);
            e.initialise(nameCode, typeCode, attlist, parent, sequence);
            e.setLocation(baseURI, lineNumber, columnNumber);
            try {
                e.processExtensionElementAttribute("");
            }
            catch (TransformerException err) {
                e.setValidationError(err, 1);
            }
            try {
                e.processExcludedNamespaces("");
            }
            catch (TransformerException err) {
                e.setValidationError(err, 1);
            }
            try {
                e.processVersionAttribute("");
            }
            catch (TransformerException err) {
                e.setValidationError(err, 1);
            }
            e.processDefaultXPathNamespaceAttribute("");
            return e;
        }
        if (parent instanceof XSLStylesheet && this.namePool.getURICode(nameCode) != 0) {
            DataElement d = new DataElement();
            d.setNamespaceDeclarations(namespaces, namespacesUsed);
            d.initialise(nameCode, typeCode, attlist, parent, sequence);
            d.setLocation(baseURI, lineNumber, columnNumber);
            return d;
        }
        short uriCode = this.namePool.getURICode(nameCode);
        String localname = this.namePool.getLocalName(nameCode);
        StyleElement temp = null;
        if (uriCode == 2 && parent instanceof XSLStylesheet && ((XSLStylesheet)parent).getVersion().compareTo(BigDecimal.valueOf(50L)) <= 0) {
            temp = new AbsentExtensionElement();
            temp.setValidationError(new XPathException("Unknown top-level XSLT declaration"), 2);
        }
        if (uriCode == 3) {
            try {
                XPathException te = new XPathException(this.namePool.getDisplayName(nameCode) + " is not recognized as a Saxon instruction");
                te.setLocator(pipe.getSourceLocation(locationId));
                te.setErrorCode("SXWN9008");
                pipe.getErrorListener().warning(te);
            }
            catch (TransformerException e1) {
                // empty catch block
            }
        }
        Class<LiteralResultElement> assumedClass = LiteralResultElement.class;
        if (temp == null) {
            temp = new LiteralResultElement();
        }
        temp.setNamespaceDeclarations(namespaces, namespacesUsed);
        try {
            temp.initialise(nameCode, typeCode, attlist, parent, sequence);
            temp.setLocation(baseURI, lineNumber, columnNumber);
            temp.processStandardAttributes("http://www.w3.org/1999/XSL/Transform");
        }
        catch (XPathException err) {
            temp.setValidationError(err, 1);
        }
        if (uriCode == 2) {
            XPathException reason = new XPathException("Unknown XSLT element: " + localname);
            reason.setErrorCode("XTSE0010");
            reason.setIsStaticError(true);
            actualClass = AbsentExtensionElement.class;
            temp.setValidationError(reason, 4);
        } else if (temp.isExtensionNamespace(uriCode) && !toplevel) {
            actualClass = AbsentExtensionElement.class;
            XPathException se = new XPathException("Unknown extension instruction", temp);
            se.setErrorCode("XTDE1450");
            XPathException reason = se;
            temp.setValidationError(reason, 3);
        } else {
            actualClass = LiteralResultElement.class;
        }
        if (actualClass.equals(assumedClass)) {
            node = temp;
        } else {
            try {
                node = (StyleElement)actualClass.newInstance();
            }
            catch (InstantiationException err1) {
                throw new TransformerFactoryConfigurationError(err1, "Failed to create instance of " + actualClass.getName());
            }
            catch (IllegalAccessException err2) {
                throw new TransformerFactoryConfigurationError(err2, "Failed to access class " + actualClass.getName());
            }
            node.substituteFor(temp);
        }
        return node;
    }

    protected StyleElement makeXSLElement(int f) {
        switch (f) {
            case 128: {
                return new XSLAnalyzeString();
            }
            case 129: {
                return new XSLApplyImports();
            }
            case 130: {
                return new XSLApplyTemplates();
            }
            case 131: {
                return new XSLAttribute();
            }
            case 132: {
                return new XSLAttributeSet();
            }
            case 133: {
                return new XSLCallTemplate();
            }
            case 134: {
                return new XSLCharacterMap();
            }
            case 135: {
                return new XSLChoose();
            }
            case 138: {
                return new XSLComment();
            }
            case 139: {
                return new XSLCopy();
            }
            case 140: {
                return new XSLCopyOf();
            }
            case 141: {
                return new XSLDecimalFormat();
            }
            case 142: {
                return new XSLDocument();
            }
            case 143: {
                return new XSLElement();
            }
            case 144: {
                return new XSLFallback();
            }
            case 145: {
                return new XSLForEach();
            }
            case 148: {
                return new XSLForEachGroup();
            }
            case 149: {
                return new XSLFunction();
            }
            case 150: {
                return new XSLIf();
            }
            case 151: {
                return new XSLImport();
            }
            case 152: {
                return new XSLImportSchema();
            }
            case 153: {
                return new XSLInclude();
            }
            case 154: {
                return new XSLKey();
            }
            case 155: {
                return new XSLMatchingSubstring();
            }
            case 158: {
                return new XSLMessage();
            }
            case 159: {
                return new XSLNextMatch();
            }
            case 163: {
                return new XSLMatchingSubstring();
            }
            case 160: {
                return new XSLNumber();
            }
            case 161: {
                return new XSLNamespace();
            }
            case 162: {
                return new XSLNamespaceAlias();
            }
            case 164: {
                return new XSLOtherwise();
            }
            case 165: {
                return new XSLOutput();
            }
            case 169: {
                return new XSLOutputCharacter();
            }
            case 170: {
                return new XSLParam();
            }
            case 171: {
                return new XSLPerformSort();
            }
            case 172: {
                return new XSLPreserveSpace();
            }
            case 173: {
                return new XSLProcessingInstruction();
            }
            case 174: {
                return new XSLResultDocument();
            }
            case 175: {
                return new XSLSequence();
            }
            case 178: {
                return new XSLSort();
            }
            case 179: {
                return new XSLPreserveSpace();
            }
            case 180: {
                return new XSLStylesheet();
            }
            case 181: {
                return new XSLTemplate();
            }
            case 182: {
                return new XSLText();
            }
            case 183: {
                return new XSLStylesheet();
            }
            case 184: {
                return new XSLValueOf();
            }
            case 185: {
                return new XSLVariable();
            }
            case 188: {
                return new XSLWithParam();
            }
            case 189: {
                return new XSLWhen();
            }
        }
        return null;
    }

    public boolean isElementAvailable(String uri, String localName) {
        int fingerprint = this.namePool.getFingerprint(uri, localName);
        if (uri.equals("http://www.w3.org/1999/XSL/Transform")) {
            if (fingerprint == -1) {
                return false;
            }
            StyleElement e = this.makeXSLElement(fingerprint);
            if (e != null) {
                return e.isInstruction();
            }
        }
        return false;
    }
}

