// created by jay 0.7 (c) 1998 Axel.Schreiner@informatik.uni-osnabrueck.de

#line 2 "cs-parser.jay"
//
// cs-parser.jay: The Parser for the C# compiler
//
// Authors: Miguel de Icaza (miguel@gnome.org)
//          Ravi Pratap     (ravi@ximian.com)
//          Marek Safar	    (marek.safar@gmail.com)
//
// Dual Licensed under the terms of the GNU GPL and the MIT X11 license
//
// (C) 2001 Ximian, Inc (http://www.ximian.com)
// (C) 2004-2011 Novell, Inc
// Copyright 2011-2012 Xamarin Inc.
//

using System.Text;
using System.IO;
using System;
using System.Collections.Generic;

namespace Mono.CSharp
{
	/// <summary>
	///    The C# Parser
	/// </summary>
	public class CSharpParser
	{
		[Flags]
		enum ParameterModifierType
		{
			Ref		= 1 << 1,
			Out		= 1 << 2,
			This	= 1 << 3,
			Params	= 1 << 4,
			Arglist	= 1 << 5,
			DefaultValue = 1 << 6,
			
			All = Ref | Out | This | Params | Arglist | DefaultValue
		}
		
		static readonly object ModifierNone = 0;
	
		NamespaceContainer current_namespace;
		TypeContainer current_container;
		TypeDefinition current_type;
		PropertyBase current_property;
		EventProperty current_event;
		EventField current_event_field;
		FieldBase current_field;
	
		/// <summary>
		///   Current block is used to add statements as we find
		///   them.  
		/// </summary>
		Block      current_block;
		
		BlockVariable current_variable;

		Delegate   current_delegate;
		
		AnonymousMethodExpression current_anonymous_method;

		/// <summary>
		///   This is used by the unary_expression code to resolve
		///   a name against a parameter.  
		/// </summary>
		
		// FIXME: This is very ugly and it's very hard to reset it correctly
		// on all places, especially when some parameters are autogenerated.
		ParametersCompiled current_local_parameters;

		bool parsing_anonymous_method;
		
		bool async_block;

		///
		/// An out-of-band stack.
		///
		Stack<object> oob_stack;

		///
		/// Controls the verbosity of the errors produced by the parser
		///
		int yacc_verbose_flag;

		/// 
		/// Used by the interactive shell, flags whether EOF was reached
		/// and an error was produced
		///
		public bool UnexpectedEOF;

		///
		/// The current file.
		///
		readonly CompilationSourceFile file;

		///
		/// Temporary Xml documentation cache.
		/// For enum types, we need one more temporary store.
		///
		string tmpComment;
		string enumTypeComment;
	       		
		/// Current attribute target
		string current_attr_target;
		
		ParameterModifierType valid_param_mod;
		
		bool default_parameter_used;

		/// When using the interactive parser, this holds the
		/// resulting expression
		public Class InteractiveResult;

		//
		// Keeps track of global data changes to undo on parser error
		//
		public Undo undo;

		bool? interactive_async;
		
		Stack<Linq.QueryBlock> linq_clause_blocks;

		ModuleContainer module;
		
		readonly CompilerContext compiler;
		readonly LanguageVersion lang_version;
		readonly bool doc_support;
		readonly CompilerSettings settings;
		readonly Report report;
		
		//
		// Instead of allocating carrier array everytime we
		// share the bucket for very common constructs which can never
		// be recursive
		//
		List<Parameter> parameters_bucket;
		
		//
		// Full AST support members
		//
		LocationsBag lbag;
		List<Tuple<Modifiers, Location>> mod_locations;
		Location parameterModifierLocation, savedLocation, savedOpenLocation, savedCloseLocation, savedEventAssignLocation;
		Location savedAttrParenOpenLocation, savedAttrParenCloseLocation, savedOperatorLocation;
		Stack<List<Location>> locationListStack = new Stack<List<Location>> (); // used for type parameters
		Stack<Location> opt_intoStack = new Stack<Location> ();

		bool HadAttributeParens;
		List<Location> attributeCommas = new List<Location> ();
		List<Location> attributeArgumentCommas = new List<Location> ();
		List<Location> parameterListCommas = new List<Location> ();
		Stack<Location> location_stack;
#line default

  /** error output stream.
      It should be changeable.
    */
  public System.IO.TextWriter ErrorOutput = System.Console.Out;

  /** simplified error message.
      @see <a href="#yyerror(java.lang.String, java.lang.String[])">yyerror</a>
    */
  public void yyerror (string message) {
    yyerror(message, null);
  }
#pragma warning disable 649
  /* An EOF token */
  public int eof_token;
#pragma warning restore 649
  /** (syntax) error message.
      Can be overwritten to control message format.
      @param message text to be displayed.
      @param expected vector of acceptable tokens, if available.
    */
  public void yyerror (string message, string[] expected) {
    if ((yacc_verbose_flag > 0) && (expected != null) && (expected.Length  > 0)) {
      ErrorOutput.Write (message+", expecting");
      for (int n = 0; n < expected.Length; ++ n)
        ErrorOutput.Write (" "+expected[n]);
        ErrorOutput.WriteLine ();
    } else
      ErrorOutput.WriteLine (message);
  }

  /** debugging support, requires the package jay.yydebug.
      Set to null to suppress debugging messages.
    */
//t  internal yydebug.yyDebug debug;

  protected const int yyFinal = 7;
//t // Put this array into a separate class so it is only initialized if debugging is actually used
//t // Use MarshalByRefObject to disable inlining
//t class YYRules : MarshalByRefObject {
//t  public static readonly string [] yyRule = {
//t    "$accept : compilation_unit",
//t    "compilation_unit : outer_declaration opt_EOF",
//t    "$$1 :",
//t    "compilation_unit : interactive_parsing $$1 opt_EOF",
//t    "compilation_unit : documentation_parsing",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives namespace_or_type_declarations opt_attributes",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives attribute_sections",
//t    "outer_declaration : error",
//t    "opt_EOF :",
//t    "opt_EOF : EOF",
//t    "extern_alias_directives : extern_alias_directive",
//t    "extern_alias_directives : extern_alias_directives extern_alias_directive",
//t    "extern_alias_directive : EXTERN_ALIAS IDENTIFIER IDENTIFIER SEMICOLON",
//t    "extern_alias_directive : EXTERN_ALIAS error",
//t    "using_directives : using_directive",
//t    "using_directives : using_directives using_directive",
//t    "using_directive : using_namespace",
//t    "using_namespace : USING namespace_or_type_expr SEMICOLON",
//t    "using_namespace : USING IDENTIFIER ASSIGN namespace_or_type_expr SEMICOLON",
//t    "using_namespace : USING error",
//t    "$$2 :",
//t    "$$3 :",
//t    "namespace_declaration : opt_attributes NAMESPACE namespace_name $$2 OPEN_BRACE $$3 opt_extern_alias_directives opt_using_directives opt_namespace_or_type_declarations CLOSE_BRACE opt_semicolon_error",
//t    "namespace_declaration : opt_attributes NAMESPACE namespace_name",
//t    "opt_semicolon_error :",
//t    "opt_semicolon_error : SEMICOLON",
//t    "opt_semicolon_error : error",
//t    "namespace_name : IDENTIFIER",
//t    "namespace_name : namespace_name DOT IDENTIFIER",
//t    "namespace_name : error",
//t    "opt_semicolon :",
//t    "opt_semicolon : SEMICOLON",
//t    "opt_comma :",
//t    "opt_comma : COMMA",
//t    "opt_using_directives :",
//t    "opt_using_directives : using_directives",
//t    "opt_extern_alias_directives :",
//t    "opt_extern_alias_directives : extern_alias_directives",
//t    "opt_namespace_or_type_declarations :",
//t    "opt_namespace_or_type_declarations : namespace_or_type_declarations",
//t    "namespace_or_type_declarations : namespace_or_type_declaration",
//t    "namespace_or_type_declarations : namespace_or_type_declarations namespace_or_type_declaration",
//t    "namespace_or_type_declaration : type_declaration",
//t    "namespace_or_type_declaration : namespace_declaration",
//t    "namespace_or_type_declaration : attribute_sections CLOSE_BRACE",
//t    "type_declaration : class_declaration",
//t    "type_declaration : struct_declaration",
//t    "type_declaration : interface_declaration",
//t    "type_declaration : enum_declaration",
//t    "type_declaration : delegate_declaration",
//t    "opt_attributes :",
//t    "opt_attributes : attribute_sections",
//t    "attribute_sections : attribute_section",
//t    "attribute_sections : attribute_sections attribute_section",
//t    "$$4 :",
//t    "attribute_section : OPEN_BRACKET $$4 attribute_section_cont",
//t    "$$5 :",
//t    "attribute_section_cont : attribute_target COLON $$5 attribute_list opt_comma CLOSE_BRACKET",
//t    "attribute_section_cont : attribute_list opt_comma CLOSE_BRACKET",
//t    "attribute_section_cont : IDENTIFIER error",
//t    "attribute_section_cont : error",
//t    "attribute_target : IDENTIFIER",
//t    "attribute_target : EVENT",
//t    "attribute_target : RETURN",
//t    "attribute_list : attribute",
//t    "attribute_list : attribute_list COMMA attribute",
//t    "$$6 :",
//t    "attribute : attribute_name $$6 opt_attribute_arguments",
//t    "attribute_name : namespace_or_type_expr",
//t    "opt_attribute_arguments :",
//t    "opt_attribute_arguments : OPEN_PARENS attribute_arguments CLOSE_PARENS",
//t    "attribute_arguments :",
//t    "attribute_arguments : positional_or_named_argument",
//t    "attribute_arguments : named_attribute_argument",
//t    "attribute_arguments : attribute_arguments COMMA positional_or_named_argument",
//t    "attribute_arguments : attribute_arguments COMMA named_attribute_argument",
//t    "positional_or_named_argument : expression",
//t    "positional_or_named_argument : named_argument",
//t    "positional_or_named_argument : error",
//t    "$$7 :",
//t    "named_attribute_argument : IDENTIFIER ASSIGN $$7 expression",
//t    "named_argument : identifier_inside_body COLON opt_named_modifier expression_or_error",
//t    "opt_named_modifier :",
//t    "opt_named_modifier : REF",
//t    "opt_named_modifier : OUT",
//t    "opt_class_member_declarations :",
//t    "opt_class_member_declarations : class_member_declarations",
//t    "class_member_declarations : class_member_declaration",
//t    "class_member_declarations : class_member_declarations class_member_declaration",
//t    "class_member_declaration : constant_declaration",
//t    "class_member_declaration : field_declaration",
//t    "class_member_declaration : method_declaration",
//t    "class_member_declaration : property_declaration",
//t    "class_member_declaration : event_declaration",
//t    "class_member_declaration : indexer_declaration",
//t    "class_member_declaration : operator_declaration",
//t    "class_member_declaration : constructor_declaration",
//t    "class_member_declaration : destructor_declaration",
//t    "class_member_declaration : type_declaration",
//t    "class_member_declaration : attributes_without_members",
//t    "class_member_declaration : incomplete_member",
//t    "class_member_declaration : error",
//t    "$$8 :",
//t    "$$9 :",
//t    "$$10 :",
//t    "$$11 :",
//t    "$$12 :",
//t    "struct_declaration : opt_attributes opt_modifiers opt_partial STRUCT $$8 type_declaration_name $$9 opt_class_base opt_type_parameter_constraints_clauses $$10 OPEN_BRACE $$11 opt_class_member_declarations CLOSE_BRACE $$12 opt_semicolon",
//t    "struct_declaration : opt_attributes opt_modifiers opt_partial STRUCT error",
//t    "$$13 :",
//t    "constant_declaration : opt_attributes opt_modifiers CONST type IDENTIFIER $$13 constant_initializer opt_constant_declarators SEMICOLON",
//t    "constant_declaration : opt_attributes opt_modifiers CONST type error",
//t    "opt_constant_declarators :",
//t    "opt_constant_declarators : constant_declarators",
//t    "constant_declarators : constant_declarator",
//t    "constant_declarators : constant_declarators constant_declarator",
//t    "constant_declarator : COMMA IDENTIFIER constant_initializer",
//t    "$$14 :",
//t    "constant_initializer : ASSIGN $$14 constant_initializer_expr",
//t    "constant_initializer : error",
//t    "constant_initializer_expr : constant_expression",
//t    "constant_initializer_expr : array_initializer",
//t    "$$15 :",
//t    "field_declaration : opt_attributes opt_modifiers member_type IDENTIFIER $$15 opt_field_initializer opt_field_declarators SEMICOLON",
//t    "$$16 :",
//t    "field_declaration : opt_attributes opt_modifiers FIXED simple_type IDENTIFIER $$16 fixed_field_size opt_fixed_field_declarators SEMICOLON",
//t    "field_declaration : opt_attributes opt_modifiers FIXED simple_type error SEMICOLON",
//t    "opt_field_initializer :",
//t    "$$17 :",
//t    "opt_field_initializer : ASSIGN $$17 variable_initializer",
//t    "opt_field_declarators :",
//t    "opt_field_declarators : field_declarators",
//t    "field_declarators : field_declarator",
//t    "field_declarators : field_declarators field_declarator",
//t    "field_declarator : COMMA IDENTIFIER",
//t    "$$18 :",
//t    "field_declarator : COMMA IDENTIFIER ASSIGN $$18 variable_initializer",
//t    "opt_fixed_field_declarators :",
//t    "opt_fixed_field_declarators : fixed_field_declarators",
//t    "fixed_field_declarators : fixed_field_declarator",
//t    "fixed_field_declarators : fixed_field_declarators fixed_field_declarator",
//t    "fixed_field_declarator : COMMA IDENTIFIER fixed_field_size",
//t    "$$19 :",
//t    "fixed_field_size : OPEN_BRACKET $$19 expression CLOSE_BRACKET",
//t    "fixed_field_size : OPEN_BRACKET error",
//t    "variable_initializer : expression",
//t    "variable_initializer : array_initializer",
//t    "variable_initializer : error",
//t    "$$20 :",
//t    "method_declaration : method_header $$20 method_body",
//t    "$$21 :",
//t    "$$22 :",
//t    "method_header : opt_attributes opt_modifiers member_type method_declaration_name OPEN_PARENS $$21 opt_formal_parameter_list CLOSE_PARENS $$22 opt_type_parameter_constraints_clauses",
//t    "$$23 :",
//t    "$$24 :",
//t    "$$25 :",
//t    "method_header : opt_attributes opt_modifiers PARTIAL VOID $$23 method_declaration_name OPEN_PARENS $$24 opt_formal_parameter_list CLOSE_PARENS $$25 opt_type_parameter_constraints_clauses",
//t    "method_header : opt_attributes opt_modifiers member_type modifiers method_declaration_name OPEN_PARENS opt_formal_parameter_list CLOSE_PARENS",
//t    "method_header : opt_attributes opt_modifiers member_type method_declaration_name error",
//t    "method_body : block",
//t    "method_body : SEMICOLON",
//t    "opt_formal_parameter_list :",
//t    "opt_formal_parameter_list : formal_parameter_list",
//t    "formal_parameter_list : fixed_parameters",
//t    "formal_parameter_list : fixed_parameters COMMA parameter_array",
//t    "formal_parameter_list : fixed_parameters COMMA arglist_modifier",
//t    "formal_parameter_list : parameter_array COMMA error",
//t    "formal_parameter_list : fixed_parameters COMMA parameter_array COMMA error",
//t    "formal_parameter_list : arglist_modifier COMMA error",
//t    "formal_parameter_list : fixed_parameters COMMA ARGLIST COMMA error",
//t    "formal_parameter_list : parameter_array",
//t    "formal_parameter_list : arglist_modifier",
//t    "formal_parameter_list : error",
//t    "fixed_parameters : fixed_parameter",
//t    "fixed_parameters : fixed_parameters COMMA fixed_parameter",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type identifier_inside_body",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type identifier_inside_body OPEN_BRACKET CLOSE_BRACKET",
//t    "fixed_parameter : attribute_sections error",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type error",
//t    "$$26 :",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type identifier_inside_body ASSIGN $$26 constant_expression",
//t    "opt_parameter_modifier :",
//t    "opt_parameter_modifier : parameter_modifiers",
//t    "parameter_modifiers : parameter_modifier",
//t    "parameter_modifiers : parameter_modifiers parameter_modifier",
//t    "parameter_modifier : REF",
//t    "parameter_modifier : OUT",
//t    "parameter_modifier : THIS",
//t    "parameter_array : opt_attributes params_modifier type IDENTIFIER",
//t    "parameter_array : opt_attributes params_modifier type IDENTIFIER ASSIGN constant_expression",
//t    "parameter_array : opt_attributes params_modifier type error",
//t    "params_modifier : PARAMS",
//t    "params_modifier : PARAMS parameter_modifier",
//t    "params_modifier : PARAMS params_modifier",
//t    "arglist_modifier : ARGLIST",
//t    "$$27 :",
//t    "$$28 :",
//t    "$$29 :",
//t    "property_declaration : opt_attributes opt_modifiers member_type member_declaration_name $$27 OPEN_BRACE $$28 accessor_declarations $$29 CLOSE_BRACE",
//t    "$$30 :",
//t    "$$31 :",
//t    "$$32 :",
//t    "indexer_declaration : opt_attributes opt_modifiers member_type indexer_declaration_name OPEN_BRACKET $$30 opt_formal_parameter_list CLOSE_BRACKET $$31 OPEN_BRACE accessor_declarations $$32 CLOSE_BRACE",
//t    "accessor_declarations : get_accessor_declaration",
//t    "accessor_declarations : get_accessor_declaration accessor_declarations",
//t    "accessor_declarations : set_accessor_declaration",
//t    "accessor_declarations : set_accessor_declaration accessor_declarations",
//t    "accessor_declarations : error",
//t    "$$33 :",
//t    "get_accessor_declaration : opt_attributes opt_modifiers GET $$33 accessor_body",
//t    "$$34 :",
//t    "set_accessor_declaration : opt_attributes opt_modifiers SET $$34 accessor_body",
//t    "accessor_body : block",
//t    "accessor_body : SEMICOLON",
//t    "accessor_body : error",
//t    "$$35 :",
//t    "$$36 :",
//t    "$$37 :",
//t    "$$38 :",
//t    "interface_declaration : opt_attributes opt_modifiers opt_partial INTERFACE $$35 type_declaration_name $$36 opt_class_base opt_type_parameter_constraints_clauses $$37 OPEN_BRACE opt_interface_member_declarations CLOSE_BRACE $$38 opt_semicolon",
//t    "interface_declaration : opt_attributes opt_modifiers opt_partial INTERFACE error",
//t    "opt_interface_member_declarations :",
//t    "opt_interface_member_declarations : interface_member_declarations",
//t    "interface_member_declarations : interface_member_declaration",
//t    "interface_member_declarations : interface_member_declarations interface_member_declaration",
//t    "interface_member_declaration : constant_declaration",
//t    "interface_member_declaration : field_declaration",
//t    "interface_member_declaration : method_declaration",
//t    "interface_member_declaration : property_declaration",
//t    "interface_member_declaration : event_declaration",
//t    "interface_member_declaration : indexer_declaration",
//t    "interface_member_declaration : operator_declaration",
//t    "interface_member_declaration : constructor_declaration",
//t    "interface_member_declaration : type_declaration",
//t    "$$39 :",
//t    "operator_declaration : opt_attributes opt_modifiers operator_declarator $$39 operator_body",
//t    "operator_body : block",
//t    "operator_body : SEMICOLON",
//t    "operator_type : type_expression_or_array",
//t    "operator_type : VOID",
//t    "$$40 :",
//t    "operator_declarator : operator_type OPERATOR overloadable_operator OPEN_PARENS $$40 opt_formal_parameter_list CLOSE_PARENS",
//t    "operator_declarator : conversion_operator_declarator",
//t    "overloadable_operator : BANG",
//t    "overloadable_operator : TILDE",
//t    "overloadable_operator : OP_INC",
//t    "overloadable_operator : OP_DEC",
//t    "overloadable_operator : TRUE",
//t    "overloadable_operator : FALSE",
//t    "overloadable_operator : PLUS",
//t    "overloadable_operator : MINUS",
//t    "overloadable_operator : STAR",
//t    "overloadable_operator : DIV",
//t    "overloadable_operator : PERCENT",
//t    "overloadable_operator : BITWISE_AND",
//t    "overloadable_operator : BITWISE_OR",
//t    "overloadable_operator : CARRET",
//t    "overloadable_operator : OP_SHIFT_LEFT",
//t    "overloadable_operator : OP_SHIFT_RIGHT",
//t    "overloadable_operator : OP_EQ",
//t    "overloadable_operator : OP_NE",
//t    "overloadable_operator : OP_GT",
//t    "overloadable_operator : OP_LT",
//t    "overloadable_operator : OP_GE",
//t    "overloadable_operator : OP_LE",
//t    "$$41 :",
//t    "conversion_operator_declarator : IMPLICIT OPERATOR type OPEN_PARENS $$41 opt_formal_parameter_list CLOSE_PARENS",
//t    "$$42 :",
//t    "conversion_operator_declarator : EXPLICIT OPERATOR type OPEN_PARENS $$42 opt_formal_parameter_list CLOSE_PARENS",
//t    "conversion_operator_declarator : IMPLICIT error",
//t    "conversion_operator_declarator : EXPLICIT error",
//t    "constructor_declaration : constructor_declarator constructor_body",
//t    "$$43 :",
//t    "$$44 :",
//t    "constructor_declarator : opt_attributes opt_modifiers IDENTIFIER $$43 OPEN_PARENS opt_formal_parameter_list CLOSE_PARENS $$44 opt_constructor_initializer",
//t    "constructor_body : block_prepared",
//t    "constructor_body : SEMICOLON",
//t    "opt_constructor_initializer :",
//t    "opt_constructor_initializer : constructor_initializer",
//t    "$$45 :",
//t    "constructor_initializer : COLON BASE OPEN_PARENS $$45 opt_argument_list CLOSE_PARENS",
//t    "$$46 :",
//t    "constructor_initializer : COLON THIS OPEN_PARENS $$46 opt_argument_list CLOSE_PARENS",
//t    "constructor_initializer : COLON error",
//t    "constructor_initializer : error",
//t    "$$47 :",
//t    "destructor_declaration : opt_attributes opt_modifiers TILDE $$47 IDENTIFIER OPEN_PARENS CLOSE_PARENS method_body",
//t    "$$48 :",
//t    "event_declaration : opt_attributes opt_modifiers EVENT type member_declaration_name $$48 opt_event_initializer opt_event_declarators SEMICOLON",
//t    "$$49 :",
//t    "$$50 :",
//t    "event_declaration : opt_attributes opt_modifiers EVENT type member_declaration_name OPEN_BRACE $$49 event_accessor_declarations $$50 CLOSE_BRACE",
//t    "event_declaration : opt_attributes opt_modifiers EVENT type error",
//t    "opt_event_initializer :",
//t    "$$51 :",
//t    "opt_event_initializer : ASSIGN $$51 event_variable_initializer",
//t    "opt_event_declarators :",
//t    "opt_event_declarators : event_declarators",
//t    "event_declarators : event_declarator",
//t    "event_declarators : event_declarators event_declarator",
//t    "event_declarator : COMMA IDENTIFIER",
//t    "$$52 :",
//t    "event_declarator : COMMA IDENTIFIER ASSIGN $$52 event_variable_initializer",
//t    "$$53 :",
//t    "event_variable_initializer : $$53 variable_initializer",
//t    "event_accessor_declarations : add_accessor_declaration remove_accessor_declaration",
//t    "event_accessor_declarations : remove_accessor_declaration add_accessor_declaration",
//t    "event_accessor_declarations : add_accessor_declaration",
//t    "event_accessor_declarations : remove_accessor_declaration",
//t    "event_accessor_declarations : error",
//t    "$$54 :",
//t    "add_accessor_declaration : opt_attributes opt_modifiers ADD $$54 event_accessor_block",
//t    "$$55 :",
//t    "remove_accessor_declaration : opt_attributes opt_modifiers REMOVE $$55 event_accessor_block",
//t    "event_accessor_block : opt_semicolon",
//t    "event_accessor_block : block",
//t    "attributes_without_members : attribute_sections CLOSE_BRACE",
//t    "incomplete_member : opt_attributes opt_modifiers member_type CLOSE_BRACE",
//t    "$$56 :",
//t    "$$57 :",
//t    "$$58 :",
//t    "enum_declaration : opt_attributes opt_modifiers ENUM type_declaration_name opt_enum_base $$56 OPEN_BRACE $$57 opt_enum_member_declarations $$58 CLOSE_BRACE opt_semicolon",
//t    "opt_enum_base :",
//t    "opt_enum_base : COLON type",
//t    "opt_enum_base : COLON error",
//t    "opt_enum_member_declarations :",
//t    "opt_enum_member_declarations : enum_member_declarations",
//t    "opt_enum_member_declarations : enum_member_declarations COMMA",
//t    "enum_member_declarations : enum_member_declaration",
//t    "enum_member_declarations : enum_member_declarations COMMA enum_member_declaration",
//t    "enum_member_declaration : opt_attributes IDENTIFIER",
//t    "$$59 :",
//t    "enum_member_declaration : opt_attributes IDENTIFIER $$59 ASSIGN constant_expression",
//t    "enum_member_declaration : opt_attributes IDENTIFIER error",
//t    "enum_member_declaration : attributes_without_members",
//t    "$$60 :",
//t    "$$61 :",
//t    "$$62 :",
//t    "delegate_declaration : opt_attributes opt_modifiers DELEGATE member_type type_declaration_name OPEN_PARENS $$60 opt_formal_parameter_list CLOSE_PARENS $$61 opt_type_parameter_constraints_clauses $$62 SEMICOLON",
//t    "opt_nullable :",
//t    "opt_nullable : INTERR_NULLABLE",
//t    "namespace_or_type_expr : member_name",
//t    "namespace_or_type_expr : qualified_alias_member IDENTIFIER opt_type_argument_list",
//t    "member_name : simple_name_expr",
//t    "member_name : namespace_or_type_expr DOT IDENTIFIER opt_type_argument_list",
//t    "simple_name_expr : IDENTIFIER opt_type_argument_list",
//t    "opt_type_argument_list :",
//t    "opt_type_argument_list : OP_GENERICS_LT type_arguments OP_GENERICS_GT",
//t    "opt_type_argument_list : OP_GENERICS_LT error",
//t    "type_arguments : type",
//t    "type_arguments : type_arguments COMMA type",
//t    "$$63 :",
//t    "type_declaration_name : IDENTIFIER $$63 opt_type_parameter_list",
//t    "member_declaration_name : method_declaration_name",
//t    "method_declaration_name : type_declaration_name",
//t    "method_declaration_name : explicit_interface IDENTIFIER opt_type_parameter_list",
//t    "indexer_declaration_name : THIS",
//t    "indexer_declaration_name : explicit_interface THIS",
//t    "explicit_interface : IDENTIFIER opt_type_argument_list DOT",
//t    "explicit_interface : qualified_alias_member IDENTIFIER opt_type_argument_list DOT",
//t    "explicit_interface : explicit_interface IDENTIFIER opt_type_argument_list DOT",
//t    "opt_type_parameter_list :",
//t    "opt_type_parameter_list : OP_GENERICS_LT_DECL type_parameters OP_GENERICS_GT",
//t    "type_parameters : type_parameter",
//t    "type_parameters : type_parameters COMMA type_parameter",
//t    "type_parameter : opt_attributes opt_type_parameter_variance IDENTIFIER",
//t    "type_parameter : error",
//t    "type_and_void : type_expression_or_array",
//t    "type_and_void : VOID",
//t    "member_type : type_and_void",
//t    "type : type_expression_or_array",
//t    "type : VOID",
//t    "simple_type : type_expression",
//t    "simple_type : VOID",
//t    "parameter_type : type_expression_or_array",
//t    "parameter_type : VOID",
//t    "type_expression_or_array : type_expression",
//t    "type_expression_or_array : type_expression rank_specifiers",
//t    "type_expression : namespace_or_type_expr opt_nullable",
//t    "type_expression : namespace_or_type_expr pointer_stars",
//t    "type_expression : builtin_types opt_nullable",
//t    "type_expression : builtin_types pointer_stars",
//t    "type_expression : VOID pointer_stars",
//t    "type_list : base_type_name",
//t    "type_list : type_list COMMA base_type_name",
//t    "base_type_name : type",
//t    "builtin_types : OBJECT",
//t    "builtin_types : STRING",
//t    "builtin_types : BOOL",
//t    "builtin_types : DECIMAL",
//t    "builtin_types : FLOAT",
//t    "builtin_types : DOUBLE",
//t    "builtin_types : integral_type",
//t    "integral_type : SBYTE",
//t    "integral_type : BYTE",
//t    "integral_type : SHORT",
//t    "integral_type : USHORT",
//t    "integral_type : INT",
//t    "integral_type : UINT",
//t    "integral_type : LONG",
//t    "integral_type : ULONG",
//t    "integral_type : CHAR",
//t    "primary_expression : primary_expression_or_type",
//t    "primary_expression : literal",
//t    "primary_expression : array_creation_expression",
//t    "primary_expression : parenthesized_expression",
//t    "primary_expression : default_value_expression",
//t    "primary_expression : invocation_expression",
//t    "primary_expression : element_access",
//t    "primary_expression : this_access",
//t    "primary_expression : base_access",
//t    "primary_expression : post_increment_expression",
//t    "primary_expression : post_decrement_expression",
//t    "primary_expression : object_or_delegate_creation_expression",
//t    "primary_expression : anonymous_type_expression",
//t    "primary_expression : typeof_expression",
//t    "primary_expression : sizeof_expression",
//t    "primary_expression : checked_expression",
//t    "primary_expression : unchecked_expression",
//t    "primary_expression : pointer_member_access",
//t    "primary_expression : anonymous_method_expression",
//t    "primary_expression : undocumented_expressions",
//t    "primary_expression_or_type : IDENTIFIER opt_type_argument_list",
//t    "primary_expression_or_type : IDENTIFIER GENERATE_COMPLETION",
//t    "primary_expression_or_type : member_access",
//t    "literal : boolean_literal",
//t    "literal : LITERAL",
//t    "literal : NULL",
//t    "boolean_literal : TRUE",
//t    "boolean_literal : FALSE",
//t    "open_parens_any : OPEN_PARENS",
//t    "open_parens_any : OPEN_PARENS_CAST",
//t    "close_parens : CLOSE_PARENS",
//t    "close_parens : COMPLETE_COMPLETION",
//t    "parenthesized_expression : OPEN_PARENS expression CLOSE_PARENS",
//t    "parenthesized_expression : OPEN_PARENS expression COMPLETE_COMPLETION",
//t    "member_access : primary_expression DOT identifier_inside_body opt_type_argument_list",
//t    "member_access : builtin_types DOT identifier_inside_body opt_type_argument_list",
//t    "member_access : BASE DOT identifier_inside_body opt_type_argument_list",
//t    "member_access : qualified_alias_member identifier_inside_body opt_type_argument_list",
//t    "member_access : primary_expression DOT GENERATE_COMPLETION",
//t    "member_access : primary_expression DOT IDENTIFIER GENERATE_COMPLETION",
//t    "member_access : builtin_types DOT GENERATE_COMPLETION",
//t    "member_access : builtin_types DOT IDENTIFIER GENERATE_COMPLETION",
//t    "invocation_expression : primary_expression open_parens_any opt_argument_list close_parens",
//t    "invocation_expression : primary_expression open_parens_any argument_list error",
//t    "invocation_expression : primary_expression open_parens_any error",
//t    "opt_object_or_collection_initializer :",
//t    "opt_object_or_collection_initializer : object_or_collection_initializer",
//t    "object_or_collection_initializer : OPEN_BRACE opt_member_initializer_list close_brace_or_complete_completion",
//t    "object_or_collection_initializer : OPEN_BRACE member_initializer_list COMMA CLOSE_BRACE",
//t    "opt_member_initializer_list :",
//t    "opt_member_initializer_list : member_initializer_list",
//t    "member_initializer_list : member_initializer",
//t    "member_initializer_list : member_initializer_list COMMA member_initializer",
//t    "member_initializer_list : member_initializer_list error",
//t    "member_initializer : IDENTIFIER ASSIGN initializer_value",
//t    "member_initializer : AWAIT ASSIGN initializer_value",
//t    "member_initializer : GENERATE_COMPLETION",
//t    "member_initializer : non_assignment_expression opt_COMPLETE_COMPLETION",
//t    "member_initializer : OPEN_BRACE expression_list CLOSE_BRACE",
//t    "member_initializer : OPEN_BRACE CLOSE_BRACE",
//t    "initializer_value : expression",
//t    "initializer_value : object_or_collection_initializer",
//t    "opt_argument_list :",
//t    "opt_argument_list : argument_list",
//t    "argument_list : argument_or_named_argument",
//t    "argument_list : argument_list COMMA argument",
//t    "argument_list : argument_list COMMA named_argument",
//t    "argument_list : argument_list COMMA error",
//t    "argument_list : COMMA error",
//t    "argument : expression",
//t    "argument : non_simple_argument",
//t    "argument_or_named_argument : argument",
//t    "argument_or_named_argument : named_argument",
//t    "non_simple_argument : REF variable_reference",
//t    "non_simple_argument : OUT variable_reference",
//t    "non_simple_argument : ARGLIST OPEN_PARENS argument_list CLOSE_PARENS",
//t    "non_simple_argument : ARGLIST OPEN_PARENS CLOSE_PARENS",
//t    "variable_reference : expression",
//t    "element_access : primary_expression OPEN_BRACKET_EXPR expression_list_arguments CLOSE_BRACKET",
//t    "element_access : primary_expression OPEN_BRACKET_EXPR expression_list_arguments error",
//t    "element_access : primary_expression OPEN_BRACKET_EXPR error",
//t    "expression_list : expression_or_error",
//t    "expression_list : expression_list COMMA expression_or_error",
//t    "expression_list_arguments : expression_list_argument",
//t    "expression_list_arguments : expression_list_arguments COMMA expression_list_argument",
//t    "expression_list_argument : expression",
//t    "expression_list_argument : named_argument",
//t    "this_access : THIS",
//t    "base_access : BASE OPEN_BRACKET_EXPR expression_list_arguments CLOSE_BRACKET",
//t    "base_access : BASE OPEN_BRACKET error",
//t    "post_increment_expression : primary_expression OP_INC",
//t    "post_decrement_expression : primary_expression OP_DEC",
//t    "object_or_delegate_creation_expression : NEW new_expr_type open_parens_any opt_argument_list CLOSE_PARENS opt_object_or_collection_initializer",
//t    "object_or_delegate_creation_expression : NEW new_expr_type object_or_collection_initializer",
//t    "array_creation_expression : NEW new_expr_type OPEN_BRACKET_EXPR expression_list CLOSE_BRACKET opt_rank_specifier opt_array_initializer",
//t    "array_creation_expression : NEW new_expr_type rank_specifiers opt_array_initializer",
//t    "array_creation_expression : NEW rank_specifier array_initializer",
//t    "array_creation_expression : NEW new_expr_type OPEN_BRACKET CLOSE_BRACKET OPEN_BRACKET_EXPR error CLOSE_BRACKET",
//t    "array_creation_expression : NEW new_expr_type error",
//t    "$$64 :",
//t    "new_expr_type : $$64 simple_type",
//t    "anonymous_type_expression : NEW OPEN_BRACE anonymous_type_parameters_opt_comma CLOSE_BRACE",
//t    "anonymous_type_parameters_opt_comma : anonymous_type_parameters_opt",
//t    "anonymous_type_parameters_opt_comma : anonymous_type_parameters COMMA",
//t    "anonymous_type_parameters_opt :",
//t    "anonymous_type_parameters_opt : anonymous_type_parameters",
//t    "anonymous_type_parameters : anonymous_type_parameter",
//t    "anonymous_type_parameters : anonymous_type_parameters COMMA anonymous_type_parameter",
//t    "anonymous_type_parameter : identifier_inside_body ASSIGN variable_initializer",
//t    "anonymous_type_parameter : identifier_inside_body",
//t    "anonymous_type_parameter : member_access",
//t    "anonymous_type_parameter : error",
//t    "opt_rank_specifier :",
//t    "opt_rank_specifier : rank_specifiers",
//t    "rank_specifiers : rank_specifier",
//t    "rank_specifiers : rank_specifier rank_specifiers",
//t    "rank_specifier : OPEN_BRACKET CLOSE_BRACKET",
//t    "rank_specifier : OPEN_BRACKET dim_separators CLOSE_BRACKET",
//t    "dim_separators : COMMA",
//t    "dim_separators : dim_separators COMMA",
//t    "opt_array_initializer :",
//t    "opt_array_initializer : array_initializer",
//t    "array_initializer : OPEN_BRACE CLOSE_BRACE",
//t    "array_initializer : OPEN_BRACE variable_initializer_list opt_comma CLOSE_BRACE",
//t    "variable_initializer_list : variable_initializer",
//t    "variable_initializer_list : variable_initializer_list COMMA variable_initializer",
//t    "$$65 :",
//t    "typeof_expression : TYPEOF $$65 open_parens_any typeof_type_expression CLOSE_PARENS",
//t    "typeof_type_expression : type_and_void",
//t    "typeof_type_expression : unbound_type_name",
//t    "typeof_type_expression : error",
//t    "unbound_type_name : identifier_inside_body generic_dimension",
//t    "unbound_type_name : qualified_alias_member identifier_inside_body generic_dimension",
//t    "unbound_type_name : unbound_type_name DOT identifier_inside_body",
//t    "unbound_type_name : unbound_type_name DOT identifier_inside_body generic_dimension",
//t    "unbound_type_name : namespace_or_type_expr DOT identifier_inside_body generic_dimension",
//t    "generic_dimension : GENERIC_DIMENSION",
//t    "qualified_alias_member : IDENTIFIER DOUBLE_COLON",
//t    "sizeof_expression : SIZEOF open_parens_any type CLOSE_PARENS",
//t    "sizeof_expression : SIZEOF open_parens_any type error",
//t    "checked_expression : CHECKED open_parens_any expression CLOSE_PARENS",
//t    "checked_expression : CHECKED error",
//t    "unchecked_expression : UNCHECKED open_parens_any expression CLOSE_PARENS",
//t    "unchecked_expression : UNCHECKED error",
//t    "pointer_member_access : primary_expression OP_PTR IDENTIFIER opt_type_argument_list",
//t    "$$66 :",
//t    "anonymous_method_expression : DELEGATE opt_anonymous_method_signature $$66 block",
//t    "$$67 :",
//t    "anonymous_method_expression : ASYNC DELEGATE opt_anonymous_method_signature $$67 block",
//t    "opt_anonymous_method_signature :",
//t    "opt_anonymous_method_signature : anonymous_method_signature",
//t    "$$68 :",
//t    "anonymous_method_signature : OPEN_PARENS $$68 opt_formal_parameter_list CLOSE_PARENS",
//t    "default_value_expression : DEFAULT open_parens_any type CLOSE_PARENS",
//t    "unary_expression : primary_expression",
//t    "unary_expression : BANG prefixed_unary_expression",
//t    "unary_expression : TILDE prefixed_unary_expression",
//t    "unary_expression : OPEN_PARENS_CAST type CLOSE_PARENS prefixed_unary_expression",
//t    "unary_expression : AWAIT prefixed_unary_expression",
//t    "unary_expression : BANG error",
//t    "unary_expression : TILDE error",
//t    "unary_expression : OPEN_PARENS_CAST type CLOSE_PARENS error",
//t    "unary_expression : AWAIT error",
//t    "prefixed_unary_expression : unary_expression",
//t    "prefixed_unary_expression : PLUS prefixed_unary_expression",
//t    "prefixed_unary_expression : MINUS prefixed_unary_expression",
//t    "prefixed_unary_expression : OP_INC prefixed_unary_expression",
//t    "prefixed_unary_expression : OP_DEC prefixed_unary_expression",
//t    "prefixed_unary_expression : STAR prefixed_unary_expression",
//t    "prefixed_unary_expression : BITWISE_AND prefixed_unary_expression",
//t    "prefixed_unary_expression : PLUS error",
//t    "prefixed_unary_expression : MINUS error",
//t    "prefixed_unary_expression : OP_INC error",
//t    "prefixed_unary_expression : OP_DEC error",
//t    "prefixed_unary_expression : STAR error",
//t    "prefixed_unary_expression : BITWISE_AND error",
//t    "multiplicative_expression : prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression STAR prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression DIV prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression PERCENT prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression STAR error",
//t    "multiplicative_expression : multiplicative_expression DIV error",
//t    "multiplicative_expression : multiplicative_expression PERCENT error",
//t    "additive_expression : multiplicative_expression",
//t    "additive_expression : additive_expression PLUS multiplicative_expression",
//t    "additive_expression : additive_expression MINUS multiplicative_expression",
//t    "additive_expression : additive_expression AS type",
//t    "additive_expression : additive_expression IS type",
//t    "additive_expression : additive_expression PLUS error",
//t    "additive_expression : additive_expression MINUS error",
//t    "additive_expression : additive_expression AS error",
//t    "additive_expression : additive_expression IS error",
//t    "shift_expression : additive_expression",
//t    "shift_expression : shift_expression OP_SHIFT_LEFT additive_expression",
//t    "shift_expression : shift_expression OP_SHIFT_RIGHT additive_expression",
//t    "shift_expression : shift_expression OP_SHIFT_LEFT error",
//t    "shift_expression : shift_expression OP_SHIFT_RIGHT error",
//t    "relational_expression : shift_expression",
//t    "relational_expression : relational_expression OP_LT shift_expression",
//t    "relational_expression : relational_expression OP_GT shift_expression",
//t    "relational_expression : relational_expression OP_LE shift_expression",
//t    "relational_expression : relational_expression OP_GE shift_expression",
//t    "relational_expression : relational_expression OP_LT error",
//t    "relational_expression : relational_expression OP_GT error",
//t    "relational_expression : relational_expression OP_LE error",
//t    "relational_expression : relational_expression OP_GE error",
//t    "equality_expression : relational_expression",
//t    "equality_expression : equality_expression OP_EQ relational_expression",
//t    "equality_expression : equality_expression OP_NE relational_expression",
//t    "equality_expression : equality_expression OP_EQ error",
//t    "equality_expression : equality_expression OP_NE error",
//t    "and_expression : equality_expression",
//t    "and_expression : and_expression BITWISE_AND equality_expression",
//t    "and_expression : and_expression BITWISE_AND error",
//t    "exclusive_or_expression : and_expression",
//t    "exclusive_or_expression : exclusive_or_expression CARRET and_expression",
//t    "exclusive_or_expression : exclusive_or_expression CARRET error",
//t    "inclusive_or_expression : exclusive_or_expression",
//t    "inclusive_or_expression : inclusive_or_expression BITWISE_OR exclusive_or_expression",
//t    "inclusive_or_expression : inclusive_or_expression BITWISE_OR error",
//t    "conditional_and_expression : inclusive_or_expression",
//t    "conditional_and_expression : conditional_and_expression OP_AND inclusive_or_expression",
//t    "conditional_and_expression : conditional_and_expression OP_AND error",
//t    "conditional_or_expression : conditional_and_expression",
//t    "conditional_or_expression : conditional_or_expression OP_OR conditional_and_expression",
//t    "conditional_or_expression : conditional_or_expression OP_OR error",
//t    "null_coalescing_expression : conditional_or_expression",
//t    "null_coalescing_expression : conditional_or_expression OP_COALESCING null_coalescing_expression",
//t    "conditional_expression : null_coalescing_expression",
//t    "conditional_expression : null_coalescing_expression INTERR expression COLON expression",
//t    "conditional_expression : null_coalescing_expression INTERR expression error",
//t    "conditional_expression : null_coalescing_expression INTERR expression COLON error",
//t    "conditional_expression : null_coalescing_expression INTERR expression COLON CLOSE_BRACE",
//t    "assignment_expression : prefixed_unary_expression ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_MULT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_DIV_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_MOD_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_ADD_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SUB_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SHIFT_LEFT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SHIFT_RIGHT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_AND_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_OR_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_XOR_ASSIGN expression",
//t    "lambda_parameter_list : lambda_parameter",
//t    "lambda_parameter_list : lambda_parameter_list COMMA lambda_parameter",
//t    "lambda_parameter : parameter_modifier parameter_type identifier_inside_body",
//t    "lambda_parameter : parameter_type identifier_inside_body",
//t    "lambda_parameter : IDENTIFIER",
//t    "lambda_parameter : AWAIT",
//t    "opt_lambda_parameter_list :",
//t    "opt_lambda_parameter_list : lambda_parameter_list",
//t    "$$69 :",
//t    "lambda_expression_body : $$69 expression",
//t    "lambda_expression_body : block",
//t    "lambda_expression_body : error",
//t    "expression_or_error : expression",
//t    "expression_or_error : error",
//t    "$$70 :",
//t    "lambda_expression : IDENTIFIER ARROW $$70 lambda_expression_body",
//t    "$$71 :",
//t    "lambda_expression : AWAIT ARROW $$71 lambda_expression_body",
//t    "$$72 :",
//t    "lambda_expression : ASYNC identifier_inside_body ARROW $$72 lambda_expression_body",
//t    "$$73 :",
//t    "$$74 :",
//t    "lambda_expression : OPEN_PARENS_LAMBDA $$73 opt_lambda_parameter_list CLOSE_PARENS ARROW $$74 lambda_expression_body",
//t    "$$75 :",
//t    "$$76 :",
//t    "lambda_expression : ASYNC OPEN_PARENS_LAMBDA $$75 opt_lambda_parameter_list CLOSE_PARENS ARROW $$76 lambda_expression_body",
//t    "expression : assignment_expression",
//t    "expression : non_assignment_expression",
//t    "non_assignment_expression : conditional_expression",
//t    "non_assignment_expression : lambda_expression",
//t    "non_assignment_expression : query_expression",
//t    "non_assignment_expression : ARGLIST",
//t    "undocumented_expressions : REFVALUE OPEN_PARENS non_assignment_expression COMMA type CLOSE_PARENS",
//t    "undocumented_expressions : REFTYPE open_parens_any expression CLOSE_PARENS",
//t    "undocumented_expressions : MAKEREF open_parens_any expression CLOSE_PARENS",
//t    "constant_expression : expression",
//t    "boolean_expression : expression",
//t    "$$77 :",
//t    "$$78 :",
//t    "$$79 :",
//t    "$$80 :",
//t    "class_declaration : opt_attributes opt_modifiers opt_partial CLASS $$77 type_declaration_name $$78 opt_class_base opt_type_parameter_constraints_clauses $$79 OPEN_BRACE opt_class_member_declarations CLOSE_BRACE $$80 opt_semicolon",
//t    "opt_partial :",
//t    "opt_partial : PARTIAL",
//t    "opt_modifiers :",
//t    "opt_modifiers : modifiers",
//t    "modifiers : modifier",
//t    "modifiers : modifiers modifier",
//t    "modifier : NEW",
//t    "modifier : PUBLIC",
//t    "modifier : PROTECTED",
//t    "modifier : INTERNAL",
//t    "modifier : PRIVATE",
//t    "modifier : ABSTRACT",
//t    "modifier : SEALED",
//t    "modifier : STATIC",
//t    "modifier : READONLY",
//t    "modifier : VIRTUAL",
//t    "modifier : OVERRIDE",
//t    "modifier : EXTERN",
//t    "modifier : VOLATILE",
//t    "modifier : UNSAFE",
//t    "modifier : ASYNC",
//t    "opt_class_base :",
//t    "opt_class_base : COLON type_list",
//t    "opt_class_base : COLON type_list error",
//t    "opt_type_parameter_constraints_clauses :",
//t    "opt_type_parameter_constraints_clauses : type_parameter_constraints_clauses",
//t    "type_parameter_constraints_clauses : type_parameter_constraints_clause",
//t    "type_parameter_constraints_clauses : type_parameter_constraints_clauses type_parameter_constraints_clause",
//t    "type_parameter_constraints_clause : WHERE IDENTIFIER COLON type_parameter_constraints",
//t    "type_parameter_constraints_clause : WHERE IDENTIFIER error",
//t    "type_parameter_constraints : type_parameter_constraint",
//t    "type_parameter_constraints : type_parameter_constraints COMMA type_parameter_constraint",
//t    "type_parameter_constraint : type",
//t    "type_parameter_constraint : NEW OPEN_PARENS CLOSE_PARENS",
//t    "type_parameter_constraint : CLASS",
//t    "type_parameter_constraint : STRUCT",
//t    "opt_type_parameter_variance :",
//t    "opt_type_parameter_variance : type_parameter_variance",
//t    "type_parameter_variance : OUT",
//t    "type_parameter_variance : IN",
//t    "$$81 :",
//t    "block : OPEN_BRACE $$81 opt_statement_list block_end",
//t    "block_end : CLOSE_BRACE",
//t    "block_end : COMPLETE_COMPLETION",
//t    "$$82 :",
//t    "block_prepared : OPEN_BRACE $$82 opt_statement_list CLOSE_BRACE",
//t    "block_prepared : CLOSE_BRACE",
//t    "$$83 :",
//t    "block_prepared_strict : OPEN_BRACE $$83 opt_statement_list CLOSE_BRACE",
//t    "opt_statement_list :",
//t    "opt_statement_list : statement_list",
//t    "statement_list : statement",
//t    "statement_list : statement_list statement",
//t    "statement : block_variable_declaration",
//t    "statement : valid_declaration_statement",
//t    "statement : labeled_statement",
//t    "statement : IDENTIFIER error",
//t    "statement : error",
//t    "interactive_statement_list : interactive_statement",
//t    "interactive_statement_list : interactive_statement_list interactive_statement",
//t    "interactive_statement : block_variable_declaration",
//t    "interactive_statement : interactive_valid_declaration_statement",
//t    "interactive_statement : labeled_statement",
//t    "valid_declaration_statement : block",
//t    "valid_declaration_statement : empty_statement",
//t    "valid_declaration_statement : expression_statement",
//t    "valid_declaration_statement : selection_statement",
//t    "valid_declaration_statement : iteration_statement",
//t    "valid_declaration_statement : jump_statement",
//t    "valid_declaration_statement : try_statement",
//t    "valid_declaration_statement : checked_statement",
//t    "valid_declaration_statement : unchecked_statement",
//t    "valid_declaration_statement : lock_statement",
//t    "valid_declaration_statement : using_statement",
//t    "valid_declaration_statement : unsafe_statement",
//t    "valid_declaration_statement : fixed_statement",
//t    "interactive_valid_declaration_statement : block",
//t    "interactive_valid_declaration_statement : empty_statement",
//t    "interactive_valid_declaration_statement : interactive_expression_statement",
//t    "interactive_valid_declaration_statement : selection_statement",
//t    "interactive_valid_declaration_statement : iteration_statement",
//t    "interactive_valid_declaration_statement : jump_statement",
//t    "interactive_valid_declaration_statement : try_statement",
//t    "interactive_valid_declaration_statement : checked_statement",
//t    "interactive_valid_declaration_statement : unchecked_statement",
//t    "interactive_valid_declaration_statement : lock_statement",
//t    "interactive_valid_declaration_statement : using_statement",
//t    "interactive_valid_declaration_statement : unsafe_statement",
//t    "interactive_valid_declaration_statement : fixed_statement",
//t    "embedded_statement : valid_declaration_statement",
//t    "embedded_statement : block_variable_declaration",
//t    "embedded_statement : labeled_statement",
//t    "embedded_statement : error",
//t    "empty_statement : SEMICOLON",
//t    "$$84 :",
//t    "labeled_statement : identifier_inside_body COLON $$84 statement",
//t    "variable_type : variable_type_simple",
//t    "variable_type : variable_type_simple rank_specifiers",
//t    "variable_type_simple : primary_expression_or_type opt_nullable",
//t    "variable_type_simple : primary_expression_or_type pointer_stars",
//t    "variable_type_simple : builtin_types opt_nullable",
//t    "variable_type_simple : builtin_types pointer_stars",
//t    "variable_type_simple : VOID pointer_stars",
//t    "variable_type_simple : VOID",
//t    "pointer_stars : pointer_star",
//t    "pointer_stars : pointer_star pointer_stars",
//t    "pointer_star : STAR",
//t    "identifier_inside_body : IDENTIFIER",
//t    "identifier_inside_body : AWAIT",
//t    "$$85 :",
//t    "block_variable_declaration : variable_type identifier_inside_body $$85 opt_local_variable_initializer opt_variable_declarators semicolon_or_handle_error_close_brace",
//t    "$$86 :",
//t    "block_variable_declaration : CONST variable_type identifier_inside_body $$86 const_variable_initializer opt_const_declarators SEMICOLON",
//t    "semicolon_or_handle_error_close_brace : SEMICOLON",
//t    "semicolon_or_handle_error_close_brace : CLOSE_BRACE",
//t    "opt_local_variable_initializer :",
//t    "opt_local_variable_initializer : ASSIGN block_variable_initializer",
//t    "opt_local_variable_initializer : error",
//t    "opt_variable_declarators :",
//t    "opt_variable_declarators : variable_declarators",
//t    "opt_using_or_fixed_variable_declarators :",
//t    "opt_using_or_fixed_variable_declarators : variable_declarators",
//t    "variable_declarators : variable_declarator",
//t    "variable_declarators : variable_declarators variable_declarator",
//t    "variable_declarator : COMMA identifier_inside_body",
//t    "variable_declarator : COMMA identifier_inside_body ASSIGN block_variable_initializer",
//t    "const_variable_initializer :",
//t    "const_variable_initializer : ASSIGN constant_initializer_expr",
//t    "opt_const_declarators :",
//t    "opt_const_declarators : const_declarators",
//t    "const_declarators : const_declarator",
//t    "const_declarators : const_declarators const_declarator",
//t    "const_declarator : COMMA identifier_inside_body ASSIGN constant_initializer_expr",
//t    "block_variable_initializer : variable_initializer",
//t    "block_variable_initializer : STACKALLOC simple_type OPEN_BRACKET_EXPR expression CLOSE_BRACKET",
//t    "block_variable_initializer : STACKALLOC simple_type",
//t    "expression_statement : statement_expression SEMICOLON",
//t    "expression_statement : statement_expression COMPLETE_COMPLETION",
//t    "expression_statement : statement_expression CLOSE_BRACE",
//t    "interactive_expression_statement : interactive_statement_expression SEMICOLON",
//t    "interactive_expression_statement : interactive_statement_expression COMPLETE_COMPLETION",
//t    "statement_expression : expression",
//t    "interactive_statement_expression : expression",
//t    "interactive_statement_expression : error",
//t    "selection_statement : if_statement",
//t    "selection_statement : switch_statement",
//t    "if_statement : IF open_parens_any boolean_expression CLOSE_PARENS embedded_statement",
//t    "if_statement : IF open_parens_any boolean_expression CLOSE_PARENS embedded_statement ELSE embedded_statement",
//t    "if_statement : IF open_parens_any boolean_expression error",
//t    "$$87 :",
//t    "switch_statement : SWITCH open_parens_any expression CLOSE_PARENS OPEN_BRACE $$87 opt_switch_sections CLOSE_BRACE",
//t    "switch_statement : SWITCH open_parens_any expression error",
//t    "opt_switch_sections :",
//t    "opt_switch_sections : switch_sections",
//t    "switch_sections : switch_section",
//t    "switch_sections : switch_sections switch_section",
//t    "switch_sections : error",
//t    "switch_section : switch_labels statement_list",
//t    "switch_labels : switch_label",
//t    "switch_labels : switch_labels switch_label",
//t    "switch_label : CASE constant_expression COLON",
//t    "switch_label : CASE constant_expression error",
//t    "switch_label : DEFAULT_COLON",
//t    "iteration_statement : while_statement",
//t    "iteration_statement : do_statement",
//t    "iteration_statement : for_statement",
//t    "iteration_statement : foreach_statement",
//t    "while_statement : WHILE open_parens_any boolean_expression CLOSE_PARENS embedded_statement",
//t    "while_statement : WHILE open_parens_any boolean_expression error",
//t    "do_statement : DO embedded_statement WHILE open_parens_any boolean_expression CLOSE_PARENS SEMICOLON",
//t    "do_statement : DO embedded_statement error",
//t    "do_statement : DO embedded_statement WHILE open_parens_any boolean_expression error",
//t    "$$88 :",
//t    "for_statement : FOR open_parens_any $$88 for_statement_cont",
//t    "$$89 :",
//t    "for_statement_cont : opt_for_initializer SEMICOLON $$89 for_statement_condition",
//t    "for_statement_cont : opt_for_initializer CLOSE_PARENS",
//t    "$$90 :",
//t    "for_statement_condition : opt_for_condition SEMICOLON $$90 for_statement_end",
//t    "for_statement_condition : boolean_expression CLOSE_PARENS",
//t    "for_statement_end : opt_for_iterator CLOSE_PARENS embedded_statement",
//t    "for_statement_end : error",
//t    "opt_for_initializer :",
//t    "opt_for_initializer : for_initializer",
//t    "$$91 :",
//t    "for_initializer : variable_type identifier_inside_body $$91 opt_local_variable_initializer opt_variable_declarators",
//t    "for_initializer : statement_expression_list",
//t    "opt_for_condition :",
//t    "opt_for_condition : boolean_expression",
//t    "opt_for_iterator :",
//t    "opt_for_iterator : for_iterator",
//t    "for_iterator : statement_expression_list",
//t    "statement_expression_list : statement_expression",
//t    "statement_expression_list : statement_expression_list COMMA statement_expression",
//t    "foreach_statement : FOREACH open_parens_any type error",
//t    "foreach_statement : FOREACH open_parens_any type identifier_inside_body error",
//t    "$$92 :",
//t    "foreach_statement : FOREACH open_parens_any type identifier_inside_body IN expression CLOSE_PARENS $$92 embedded_statement",
//t    "foreach_statement : FOREACH open_parens_any type identifier_inside_body error",
//t    "foreach_statement : FOREACH open_parens_any type error",
//t    "jump_statement : break_statement",
//t    "jump_statement : continue_statement",
//t    "jump_statement : goto_statement",
//t    "jump_statement : return_statement",
//t    "jump_statement : throw_statement",
//t    "jump_statement : yield_statement",
//t    "break_statement : BREAK SEMICOLON",
//t    "continue_statement : CONTINUE SEMICOLON",
//t    "continue_statement : CONTINUE error",
//t    "goto_statement : GOTO identifier_inside_body SEMICOLON",
//t    "goto_statement : GOTO CASE constant_expression SEMICOLON",
//t    "goto_statement : GOTO DEFAULT SEMICOLON",
//t    "return_statement : RETURN opt_expression SEMICOLON",
//t    "return_statement : RETURN expression error",
//t    "return_statement : RETURN error",
//t    "throw_statement : THROW opt_expression SEMICOLON",
//t    "throw_statement : THROW expression error",
//t    "throw_statement : THROW error",
//t    "yield_statement : identifier_inside_body RETURN opt_expression SEMICOLON",
//t    "yield_statement : identifier_inside_body RETURN expression error",
//t    "yield_statement : identifier_inside_body BREAK SEMICOLON",
//t    "opt_expression :",
//t    "opt_expression : expression",
//t    "try_statement : TRY block catch_clauses",
//t    "try_statement : TRY block FINALLY block",
//t    "try_statement : TRY block catch_clauses FINALLY block",
//t    "try_statement : TRY block error",
//t    "catch_clauses : catch_clause",
//t    "catch_clauses : catch_clauses catch_clause",
//t    "opt_identifier :",
//t    "opt_identifier : identifier_inside_body",
//t    "catch_clause : CATCH block",
//t    "$$93 :",
//t    "catch_clause : CATCH open_parens_any type opt_identifier CLOSE_PARENS $$93 block_prepared_strict",
//t    "catch_clause : CATCH open_parens_any error",
//t    "catch_clause : CATCH open_parens_any type opt_identifier CLOSE_PARENS error",
//t    "checked_statement : CHECKED block",
//t    "unchecked_statement : UNCHECKED block",
//t    "$$94 :",
//t    "unsafe_statement : UNSAFE $$94 block",
//t    "lock_statement : LOCK open_parens_any expression CLOSE_PARENS embedded_statement",
//t    "lock_statement : LOCK open_parens_any expression error",
//t    "$$95 :",
//t    "$$96 :",
//t    "fixed_statement : FIXED open_parens_any variable_type identifier_inside_body $$95 using_or_fixed_variable_initializer opt_using_or_fixed_variable_declarators CLOSE_PARENS $$96 embedded_statement",
//t    "$$97 :",
//t    "$$98 :",
//t    "using_statement : USING open_parens_any variable_type identifier_inside_body $$97 using_initialization CLOSE_PARENS $$98 embedded_statement",
//t    "using_statement : USING open_parens_any expression CLOSE_PARENS embedded_statement",
//t    "using_statement : USING open_parens_any expression error",
//t    "using_initialization : using_or_fixed_variable_initializer opt_using_or_fixed_variable_declarators",
//t    "using_initialization : error",
//t    "using_or_fixed_variable_initializer :",
//t    "using_or_fixed_variable_initializer : ASSIGN variable_initializer",
//t    "query_expression : first_from_clause query_body",
//t    "query_expression : nested_from_clause query_body",
//t    "query_expression : first_from_clause COMPLETE_COMPLETION",
//t    "query_expression : nested_from_clause COMPLETE_COMPLETION",
//t    "first_from_clause : FROM_FIRST identifier_inside_body IN expression",
//t    "first_from_clause : FROM_FIRST type identifier_inside_body IN expression",
//t    "nested_from_clause : FROM identifier_inside_body IN expression",
//t    "nested_from_clause : FROM type identifier_inside_body IN expression",
//t    "$$99 :",
//t    "from_clause : FROM identifier_inside_body IN $$99 expression_or_error",
//t    "$$100 :",
//t    "from_clause : FROM type identifier_inside_body IN $$100 expression_or_error",
//t    "query_body : query_body_clauses select_or_group_clause opt_query_continuation",
//t    "query_body : select_or_group_clause opt_query_continuation",
//t    "query_body : query_body_clauses COMPLETE_COMPLETION",
//t    "query_body : query_body_clauses error",
//t    "query_body : error",
//t    "$$101 :",
//t    "select_or_group_clause : SELECT $$101 expression_or_error",
//t    "$$102 :",
//t    "$$103 :",
//t    "select_or_group_clause : GROUP $$102 expression_or_error $$103 by_expression",
//t    "by_expression : BY expression_or_error",
//t    "by_expression : error",
//t    "query_body_clauses : query_body_clause",
//t    "query_body_clauses : query_body_clauses query_body_clause",
//t    "query_body_clause : from_clause",
//t    "query_body_clause : let_clause",
//t    "query_body_clause : where_clause",
//t    "query_body_clause : join_clause",
//t    "query_body_clause : orderby_clause",
//t    "$$104 :",
//t    "let_clause : LET identifier_inside_body ASSIGN $$104 expression_or_error",
//t    "$$105 :",
//t    "where_clause : WHERE $$105 expression_or_error",
//t    "$$106 :",
//t    "$$107 :",
//t    "$$108 :",
//t    "join_clause : JOIN identifier_inside_body IN $$106 expression_or_error ON $$107 expression_or_error EQUALS $$108 expression_or_error opt_join_into",
//t    "$$109 :",
//t    "$$110 :",
//t    "$$111 :",
//t    "join_clause : JOIN type identifier_inside_body IN $$109 expression_or_error ON $$110 expression_or_error EQUALS $$111 expression_or_error opt_join_into",
//t    "opt_join_into :",
//t    "opt_join_into : INTO identifier_inside_body",
//t    "$$112 :",
//t    "orderby_clause : ORDERBY $$112 orderings",
//t    "orderings : order_by",
//t    "$$113 :",
//t    "orderings : order_by COMMA $$113 orderings_then_by",
//t    "orderings_then_by : then_by",
//t    "$$114 :",
//t    "orderings_then_by : orderings_then_by COMMA $$114 then_by",
//t    "order_by : expression",
//t    "order_by : expression ASCENDING",
//t    "order_by : expression DESCENDING",
//t    "then_by : expression",
//t    "then_by : expression ASCENDING",
//t    "then_by : expression DESCENDING",
//t    "opt_query_continuation :",
//t    "$$115 :",
//t    "opt_query_continuation : INTO identifier_inside_body $$115 query_body",
//t    "interactive_parsing : EVAL_STATEMENT_PARSER EOF",
//t    "interactive_parsing : EVAL_USING_DECLARATIONS_UNIT_PARSER using_directives opt_COMPLETE_COMPLETION",
//t    "$$116 :",
//t    "interactive_parsing : EVAL_STATEMENT_PARSER $$116 interactive_statement_list opt_COMPLETE_COMPLETION",
//t    "interactive_parsing : EVAL_COMPILATION_UNIT_PARSER interactive_compilation_unit",
//t    "interactive_compilation_unit : opt_extern_alias_directives opt_using_directives",
//t    "interactive_compilation_unit : opt_extern_alias_directives opt_using_directives namespace_or_type_declarations",
//t    "opt_COMPLETE_COMPLETION :",
//t    "opt_COMPLETE_COMPLETION : COMPLETE_COMPLETION",
//t    "close_brace_or_complete_completion : CLOSE_BRACE",
//t    "close_brace_or_complete_completion : COMPLETE_COMPLETION",
//t    "documentation_parsing : DOC_SEE doc_cref",
//t    "doc_cref : doc_type_declaration_name opt_doc_method_sig",
//t    "doc_cref : builtin_types opt_doc_method_sig",
//t    "doc_cref : builtin_types DOT IDENTIFIER opt_doc_method_sig",
//t    "doc_cref : doc_type_declaration_name DOT THIS",
//t    "$$117 :",
//t    "doc_cref : doc_type_declaration_name DOT THIS OPEN_BRACKET $$117 opt_doc_parameters CLOSE_BRACKET",
//t    "doc_cref : EXPLICIT OPERATOR type opt_doc_method_sig",
//t    "doc_cref : IMPLICIT OPERATOR type opt_doc_method_sig",
//t    "doc_cref : OPERATOR overloadable_operator opt_doc_method_sig",
//t    "doc_type_declaration_name : type_declaration_name",
//t    "doc_type_declaration_name : doc_type_declaration_name DOT type_declaration_name",
//t    "opt_doc_method_sig :",
//t    "$$118 :",
//t    "opt_doc_method_sig : OPEN_PARENS $$118 opt_doc_parameters CLOSE_PARENS",
//t    "opt_doc_parameters :",
//t    "opt_doc_parameters : doc_parameters",
//t    "doc_parameters : doc_parameter",
//t    "doc_parameters : doc_parameters COMMA doc_parameter",
//t    "doc_parameter : opt_parameter_modifier parameter_type",
//t  };
//t public static string getRule (int index) {
//t    return yyRule [index];
//t }
//t}
  protected static readonly string [] yyNames = {    
    "end-of-file",null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,"EOF","NONE","ERROR",
    "FIRST_KEYWORD","ABSTRACT","AS","ADD","BASE","BOOL","BREAK","BYTE",
    "CASE","CATCH","CHAR","CHECKED","CLASS","CONST","CONTINUE","DECIMAL",
    "DEFAULT","DELEGATE","DO","DOUBLE","ELSE","ENUM","EVENT","EXPLICIT",
    "EXTERN","FALSE","FINALLY","FIXED","FLOAT","FOR","FOREACH","GOTO",
    "IF","IMPLICIT","IN","INT","INTERFACE","INTERNAL","IS","LOCK","LONG",
    "NAMESPACE","NEW","NULL","OBJECT","OPERATOR","OUT","OVERRIDE",
    "PARAMS","PRIVATE","PROTECTED","PUBLIC","READONLY","REF","RETURN",
    "REMOVE","SBYTE","SEALED","SHORT","SIZEOF","STACKALLOC","STATIC",
    "STRING","STRUCT","SWITCH","THIS","THROW","TRUE","TRY","TYPEOF",
    "UINT","ULONG","UNCHECKED","UNSAFE","USHORT","USING","VIRTUAL","VOID",
    "VOLATILE","WHERE","WHILE","ARGLIST","PARTIAL","ARROW","FROM",
    "FROM_FIRST","JOIN","ON","EQUALS","SELECT","GROUP","BY","LET",
    "ORDERBY","ASCENDING","DESCENDING","INTO","INTERR_NULLABLE",
    "EXTERN_ALIAS","REFVALUE","REFTYPE","MAKEREF","ASYNC","AWAIT","GET",
    "SET","LAST_KEYWORD","OPEN_BRACE","CLOSE_BRACE","OPEN_BRACKET",
    "CLOSE_BRACKET","OPEN_PARENS","CLOSE_PARENS","DOT","COMMA","COLON",
    "SEMICOLON","TILDE","PLUS","MINUS","BANG","ASSIGN","OP_LT","OP_GT",
    "BITWISE_AND","BITWISE_OR","STAR","PERCENT","DIV","CARRET","INTERR",
    "DOUBLE_COLON","OP_INC","OP_DEC","OP_SHIFT_LEFT","OP_SHIFT_RIGHT",
    "OP_LE","OP_GE","OP_EQ","OP_NE","OP_AND","OP_OR","OP_MULT_ASSIGN",
    "OP_DIV_ASSIGN","OP_MOD_ASSIGN","OP_ADD_ASSIGN","OP_SUB_ASSIGN",
    "OP_SHIFT_LEFT_ASSIGN","OP_SHIFT_RIGHT_ASSIGN","OP_AND_ASSIGN",
    "OP_XOR_ASSIGN","OP_OR_ASSIGN","OP_PTR","OP_COALESCING",
    "OP_GENERICS_LT","OP_GENERICS_LT_DECL","OP_GENERICS_GT","LITERAL",
    "IDENTIFIER","OPEN_PARENS_LAMBDA","OPEN_PARENS_CAST",
    "GENERIC_DIMENSION","DEFAULT_COLON","OPEN_BRACKET_EXPR",
    "EVAL_STATEMENT_PARSER","EVAL_COMPILATION_UNIT_PARSER",
    "EVAL_USING_DECLARATIONS_UNIT_PARSER","DOC_SEE","GENERATE_COMPLETION",
    "COMPLETE_COMPLETION","UMINUS",
  };

  /** index-checked interface to yyNames[].
      @param token single character or %token value.
      @return token name or [illegal] or [unknown].
    */
//t  public static string yyname (int token) {
//t    if ((token < 0) || (token > yyNames.Length)) return "[illegal]";
//t    string name;
//t    if ((name = yyNames[token]) != null) return name;
//t    return "[unknown]";
//t  }

#pragma warning disable 414
  int yyExpectingState;
#pragma warning restore 414
  /** computes list of expected tokens on error by tracing the tables.
      @param state for which to compute the list.
      @return list of token names.
    */
  protected int [] yyExpectingTokens (int state){
    int token, n, len = 0;
    bool[] ok = new bool[yyNames.Length];
    if ((n = yySindex[state]) != 0)
      for (token = n < 0 ? -n : 0;
           (token < yyNames.Length) && (n+token < yyTable.Length); ++ token)
        if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
          ++ len;
          ok[token] = true;
        }
    if ((n = yyRindex[state]) != 0)
      for (token = n < 0 ? -n : 0;
           (token < yyNames.Length) && (n+token < yyTable.Length); ++ token)
        if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
          ++ len;
          ok[token] = true;
        }
    int [] result = new int [len];
    for (n = token = 0; n < len;  ++ token)
      if (ok[token]) result[n++] = token;
    return result;
  }
  protected string[] yyExpecting (int state) {
    int [] tokens = yyExpectingTokens (state);
    string [] result = new string[tokens.Length];
    for (int n = 0; n < tokens.Length;  n++)
      result[n++] = yyNames[tokens [n]];
    return result;
  }

  /** the generated parser, with debugging messages.
      Maintains a state and a value stack, currently with fixed maximum size.
      @param yyLex scanner.
      @param yydebug debug message writer implementing yyDebug, or null.
      @return result of the last reduction, if any.
      @throws yyException on irrecoverable parse error.
    */
  internal Object yyparse (yyParser.yyInput yyLex, Object yyd)
				 {
//t    this.debug = (yydebug.yyDebug)yyd;
    return yyparse(yyLex);
  }

  /** initial size and increment of the state/value stack [default 256].
      This is not final so that it can be overwritten outside of invocations
      of yyparse().
    */
  protected int yyMax;

  /** executed at the beginning of a reduce action.
      Used as $$ = yyDefault($1), prior to the user-specified action, if any.
      Can be overwritten to provide deep copy, etc.
      @param first value for $1, or null.
      @return first.
    */
  protected Object yyDefault (Object first) {
    return first;
  }

	static int[] global_yyStates;
	static object[] global_yyVals;
#pragma warning disable 649
	protected bool use_global_stacks;
#pragma warning restore 649
	object[] yyVals;					// value stack
	object yyVal;						// value stack ptr
	int yyToken;						// current input
	int yyTop;

  /** the generated parser.
      Maintains a state and a value stack, currently with fixed maximum size.
      @param yyLex scanner.
      @return result of the last reduction, if any.
      @throws yyException on irrecoverable parse error.
    */
  internal Object yyparse (yyParser.yyInput yyLex)
  {
    if (yyMax <= 0) yyMax = 256;		// initial size
    int yyState = 0;                   // state stack ptr
    int [] yyStates;               	// state stack 
    yyVal = null;
    yyToken = -1;
    int yyErrorFlag = 0;				// #tks to shift
	if (use_global_stacks && global_yyStates != null) {
		yyVals = global_yyVals;
		yyStates = global_yyStates;
   } else {
		yyVals = new object [yyMax];
		yyStates = new int [yyMax];
		if (use_global_stacks) {
			global_yyVals = yyVals;
			global_yyStates = yyStates;
		}
	}

    /*yyLoop:*/ for (yyTop = 0;; ++ yyTop) {
      if (yyTop >= yyStates.Length) {			// dynamically increase
        global::System.Array.Resize (ref yyStates, yyStates.Length+yyMax);
        global::System.Array.Resize (ref yyVals, yyVals.Length+yyMax);
      }
      yyStates[yyTop] = yyState;
      yyVals[yyTop] = yyVal;
//t      if (debug != null) debug.push(yyState, yyVal);

      /*yyDiscarded:*/ while (true) {	// discarding a token does not change stack
        int yyN;
        if ((yyN = yyDefRed[yyState]) == 0) {	// else [default] reduce (yyN)
          if (yyToken < 0) {
            yyToken = yyLex.advance() ? yyLex.token() : 0;
//t            if (debug != null)
//t              debug.lex(yyState, yyToken, yyname(yyToken), yyLex.value());
          }
          if ((yyN = yySindex[yyState]) != 0 && ((yyN += yyToken) >= 0)
              && (yyN < yyTable.Length) && (yyCheck[yyN] == yyToken)) {
//t            if (debug != null)
//t              debug.shift(yyState, yyTable[yyN], yyErrorFlag-1);
            yyState = yyTable[yyN];		// shift to yyN
            yyVal = yyLex.value();
            yyToken = -1;
            if (yyErrorFlag > 0) -- yyErrorFlag;
            goto continue_yyLoop;
          }
          if ((yyN = yyRindex[yyState]) != 0 && (yyN += yyToken) >= 0
              && yyN < yyTable.Length && yyCheck[yyN] == yyToken)
            yyN = yyTable[yyN];			// reduce (yyN)
          else
            switch (yyErrorFlag) {
  
            case 0:
              yyExpectingState = yyState;
              // yyerror(String.Format ("syntax error, got token `{0}'", yyname (yyToken)), yyExpecting(yyState));
//t              if (debug != null) debug.error("syntax error");
              if (yyToken == 0 /*eof*/ || yyToken == eof_token) throw new yyParser.yyUnexpectedEof ();
              goto case 1;
            case 1: case 2:
              yyErrorFlag = 3;
              do {
                if ((yyN = yySindex[yyStates[yyTop]]) != 0
                    && (yyN += Token.yyErrorCode) >= 0 && yyN < yyTable.Length
                    && yyCheck[yyN] == Token.yyErrorCode) {
//t                  if (debug != null)
//t                    debug.shift(yyStates[yyTop], yyTable[yyN], 3);
                  yyState = yyTable[yyN];
                  yyVal = yyLex.value();
                  goto continue_yyLoop;
                }
//t                if (debug != null) debug.pop(yyStates[yyTop]);
              } while (-- yyTop >= 0);
//t              if (debug != null) debug.reject();
              throw new yyParser.yyException("irrecoverable syntax error");
  
            case 3:
              if (yyToken == 0) {
//t                if (debug != null) debug.reject();
                throw new yyParser.yyException("irrecoverable syntax error at end-of-file");
              }
//t              if (debug != null)
//t                debug.discard(yyState, yyToken, yyname(yyToken),
//t  							yyLex.value());
              yyToken = -1;
              goto continue_yyDiscarded;		// leave stack alone
            }
        }
        int yyV = yyTop + 1-yyLen[yyN];
//t        if (debug != null)
//t          debug.reduce(yyState, yyStates[yyV-1], yyN, YYRules.getRule (yyN), yyLen[yyN]);
        yyVal = yyV > yyTop ? null : yyVals[yyV]; // yyVal = yyDefault(yyV > yyTop ? null : yyVals[yyV]);
        switch (yyN) {
case 1:
#line 388 "cs-parser.jay"
  {
		Lexer.check_incorrect_doc_comment ();
	  }
  break;
case 2:
#line 389 "cs-parser.jay"
  { Lexer.CompleteOnEOF = false; }
  break;
case 6:
  case_6();
  break;
case 7:
#line 408 "cs-parser.jay"
  {
		module.AddAttributes ((Attributes) yyVals[0+yyTop], current_namespace);
	  }
  break;
case 8:
  case_8();
  break;
case 13:
  case_13();
  break;
case 14:
#line 453 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);
	  }
  break;
case 17:
  case_17();
  break;
case 18:
  case_18();
  break;
case 19:
  case_19();
  break;
case 20:
  case_20();
  break;
case 21:
  case_21();
  break;
case 22:
  case_22();
  break;
case 23:
  case_23();
  break;
case 24:
  case_24();
  break;
case 27:
  case_27();
  break;
case 28:
  case_28();
  break;
case 29:
  case_29();
  break;
case 30:
  case_30();
  break;
case 43:
  case_43();
  break;
case 44:
#line 637 "cs-parser.jay"
  {
		current_namespace.DeclarationFound = true;
	  }
  break;
case 45:
  case_45();
  break;
case 53:
  case_53();
  break;
case 54:
  case_54();
  break;
case 55:
  case_55();
  break;
case 56:
  case_56();
  break;
case 57:
  case_57();
  break;
case 58:
  case_58();
  break;
case 59:
  case_59();
  break;
case 60:
  case_60();
  break;
case 61:
  case_61();
  break;
case 62:
  case_62();
  break;
case 63:
#line 772 "cs-parser.jay"
  { yyVal = "event"; savedCloseLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 64:
#line 773 "cs-parser.jay"
  { yyVal = "return"; savedCloseLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 65:
#line 780 "cs-parser.jay"
  {
		yyVal = new List<Attribute> (4) { (Attribute) yyVals[0+yyTop] };
	  }
  break;
case 66:
  case_66();
  break;
case 67:
#line 797 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 68:
  case_68();
  break;
case 70:
#line 825 "cs-parser.jay"
  { yyVal = null; HadAttributeParens = false;  }
  break;
case 71:
  case_71();
  break;
case 72:
#line 837 "cs-parser.jay"
  { yyVal = null; }
  break;
case 73:
  case_73();
  break;
case 74:
  case_74();
  break;
case 75:
  case_75();
  break;
case 76:
  case_76();
  break;
case 77:
#line 881 "cs-parser.jay"
  {
	  	yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 79:
  case_79();
  break;
case 80:
#line 894 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 81:
  case_81();
  break;
case 82:
  case_82();
  break;
case 83:
#line 920 "cs-parser.jay"
  { yyVal = null; }
  break;
case 84:
#line 924 "cs-parser.jay"
  { 
		yyVal = Argument.AType.Ref;
	  }
  break;
case 85:
#line 928 "cs-parser.jay"
  { 
		yyVal = Argument.AType.Out;
	  }
  break;
case 88:
#line 940 "cs-parser.jay"
  {
		lexer.parsing_modifiers = true;
	  }
  break;
case 89:
#line 944 "cs-parser.jay"
  {
		lexer.parsing_modifiers = true;
	  }
  break;
case 102:
  case_102();
  break;
case 103:
#line 975 "cs-parser.jay"
  {
	  }
  break;
case 104:
  case_104();
  break;
case 105:
  case_105();
  break;
case 106:
  case_106();
  break;
case 107:
  case_107();
  break;
case 108:
  case_108();
  break;
case 109:
#line 1019 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);
	  }
  break;
case 110:
  case_110();
  break;
case 111:
  case_111();
  break;
case 112:
  case_112();
  break;
case 115:
#line 1068 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 116:
#line 1072 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 117:
  case_117();
  break;
case 118:
#line 1088 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 119:
  case_119();
  break;
case 120:
  case_120();
  break;
case 123:
  case_123();
  break;
case 124:
  case_124();
  break;
case 125:
  case_125();
  break;
case 126:
  case_126();
  break;
case 127:
#line 1167 "cs-parser.jay"
  {
		report.Error (1641, GetLocation (yyVals[-1+yyTop]), "A fixed size buffer field must have the array size specifier after the field name");
	  }
  break;
case 129:
  case_129();
  break;
case 130:
  case_130();
  break;
case 133:
#line 1197 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 134:
#line 1201 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 135:
  case_135();
  break;
case 136:
#line 1214 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 137:
  case_137();
  break;
case 140:
#line 1233 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 141:
#line 1237 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 142:
  case_142();
  break;
case 143:
#line 1253 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 144:
  case_144();
  break;
case 145:
  case_145();
  break;
case 148:
  case_148();
  break;
case 149:
  case_149();
  break;
case 150:
  case_150();
  break;
case 151:
#line 1321 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.All;
	  }
  break;
case 152:
  case_152();
  break;
case 153:
  case_153();
  break;
case 154:
#line 1360 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 155:
  case_155();
  break;
case 156:
#line 1370 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 157:
  case_157();
  break;
case 158:
  case_158();
  break;
case 159:
  case_159();
  break;
case 161:
#line 1443 "cs-parser.jay"
  { savedLocation = GetLocation (yyVals[0+yyTop]); yyVal = null; }
  break;
case 162:
#line 1447 "cs-parser.jay"
  { yyVal = ParametersCompiled.EmptyReadOnlyParameters; }
  break;
case 164:
  case_164();
  break;
case 165:
  case_165();
  break;
case 166:
  case_166();
  break;
case 167:
  case_167();
  break;
case 168:
  case_168();
  break;
case 169:
  case_169();
  break;
case 170:
  case_170();
  break;
case 171:
#line 1519 "cs-parser.jay"
  {
		yyVal = new ParametersCompiled (new Parameter[] { (Parameter) yyVals[0+yyTop] } );
	  }
  break;
case 172:
#line 1523 "cs-parser.jay"
  {
		yyVal = new ParametersCompiled (new Parameter [] { new ArglistParameter (GetLocation (yyVals[0+yyTop])) }, true);
	  }
  break;
case 173:
  case_173();
  break;
case 174:
  case_174();
  break;
case 175:
  case_175();
  break;
case 176:
  case_176();
  break;
case 177:
  case_177();
  break;
case 178:
  case_178();
  break;
case 179:
  case_179();
  break;
case 180:
#line 1604 "cs-parser.jay"
  {
	  	++lexer.parsing_block;
	  }
  break;
case 181:
  case_181();
  break;
case 182:
#line 1645 "cs-parser.jay"
  { yyVal = Parameter.Modifier.NONE; }
  break;
case 184:
#line 1653 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 185:
  case_185();
  break;
case 186:
  case_186();
  break;
case 187:
  case_187();
  break;
case 188:
  case_188();
  break;
case 189:
  case_189();
  break;
case 190:
  case_190();
  break;
case 191:
  case_191();
  break;
case 192:
  case_192();
  break;
case 193:
  case_193();
  break;
case 194:
#line 1747 "cs-parser.jay"
  {
		Error_DuplicateParameterModifier (GetLocation (yyVals[-1+yyTop]), Parameter.Modifier.PARAMS);
	  }
  break;
case 195:
  case_195();
  break;
case 196:
  case_196();
  break;
case 197:
  case_197();
  break;
case 198:
  case_198();
  break;
case 199:
  case_199();
  break;
case 200:
#line 1801 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Params | ParameterModifierType.DefaultValue;
	  }
  break;
case 201:
  case_201();
  break;
case 202:
#line 1830 "cs-parser.jay"
  {
		lexer.PropertyParsing = false;
	  }
  break;
case 203:
  case_203();
  break;
case 208:
  case_208();
  break;
case 209:
  case_209();
  break;
case 210:
  case_210();
  break;
case 211:
  case_211();
  break;
case 212:
  case_212();
  break;
case 214:
  case_214();
  break;
case 215:
  case_215();
  break;
case 216:
#line 1978 "cs-parser.jay"
  {
	  }
  break;
case 217:
  case_217();
  break;
case 218:
  case_218();
  break;
case 219:
  case_219();
  break;
case 220:
  case_220();
  break;
case 221:
#line 2018 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);	  
	  }
  break;
case 224:
#line 2030 "cs-parser.jay"
  {
		lexer.parsing_modifiers = true;
	  }
  break;
case 225:
#line 2034 "cs-parser.jay"
  {
		lexer.parsing_modifiers = true;
	  }
  break;
case 226:
#line 2041 "cs-parser.jay"
  {
		report.Error (525, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain fields or constants");
	  }
  break;
case 227:
#line 2045 "cs-parser.jay"
  {
		report.Error (525, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain fields or constants");
	  }
  break;
case 232:
#line 2053 "cs-parser.jay"
  {
	  	report.Error (567, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain operators");
	  }
  break;
case 233:
#line 2057 "cs-parser.jay"
  {
	  	report.Error (526, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain contructors");
	  }
  break;
case 234:
#line 2061 "cs-parser.jay"
  {
	  	report.Error (524, GetLocation (yyVals[0+yyTop]), "Interfaces cannot declare classes, structs, interfaces, delegates, or enumerations");
	  }
  break;
case 235:
#line 2067 "cs-parser.jay"
  {
	  }
  break;
case 236:
  case_236();
  break;
case 238:
#line 2100 "cs-parser.jay"
  { savedLocation = GetLocation (yyVals[0+yyTop]); yyVal = null; }
  break;
case 240:
  case_240();
  break;
case 241:
#line 2116 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 242:
  case_242();
  break;
case 244:
#line 2162 "cs-parser.jay"
  { yyVal = Operator.OpType.LogicalNot; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 245:
#line 2163 "cs-parser.jay"
  { yyVal = Operator.OpType.OnesComplement; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 246:
#line 2164 "cs-parser.jay"
  { yyVal = Operator.OpType.Increment; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 247:
#line 2165 "cs-parser.jay"
  { yyVal = Operator.OpType.Decrement; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 248:
#line 2166 "cs-parser.jay"
  { yyVal = Operator.OpType.True; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 249:
#line 2167 "cs-parser.jay"
  { yyVal = Operator.OpType.False; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 250:
#line 2169 "cs-parser.jay"
  { yyVal = Operator.OpType.Addition; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 251:
#line 2170 "cs-parser.jay"
  { yyVal = Operator.OpType.Subtraction; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 252:
#line 2172 "cs-parser.jay"
  { yyVal = Operator.OpType.Multiply; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 253:
#line 2173 "cs-parser.jay"
  {  yyVal = Operator.OpType.Division; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 254:
#line 2174 "cs-parser.jay"
  { yyVal = Operator.OpType.Modulus; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 255:
#line 2175 "cs-parser.jay"
  { yyVal = Operator.OpType.BitwiseAnd; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 256:
#line 2176 "cs-parser.jay"
  { yyVal = Operator.OpType.BitwiseOr; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 257:
#line 2177 "cs-parser.jay"
  { yyVal = Operator.OpType.ExclusiveOr; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 258:
#line 2178 "cs-parser.jay"
  { yyVal = Operator.OpType.LeftShift; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 259:
#line 2179 "cs-parser.jay"
  { yyVal = Operator.OpType.RightShift; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 260:
#line 2180 "cs-parser.jay"
  { yyVal = Operator.OpType.Equality; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 261:
#line 2181 "cs-parser.jay"
  { yyVal = Operator.OpType.Inequality; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 262:
#line 2182 "cs-parser.jay"
  { yyVal = Operator.OpType.GreaterThan; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 263:
#line 2183 "cs-parser.jay"
  { yyVal = Operator.OpType.LessThan; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 264:
#line 2184 "cs-parser.jay"
  { yyVal = Operator.OpType.GreaterThanOrEqual; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 265:
#line 2185 "cs-parser.jay"
  { yyVal = Operator.OpType.LessThanOrEqual; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 266:
#line 2192 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 267:
  case_267();
  break;
case 268:
#line 2215 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 269:
  case_269();
  break;
case 270:
  case_270();
  break;
case 271:
  case_271();
  break;
case 272:
  case_272();
  break;
case 273:
  case_273();
  break;
case 274:
  case_274();
  break;
case 275:
  case_275();
  break;
case 277:
#line 2325 "cs-parser.jay"
  { current_block = null; yyVal = null; }
  break;
case 280:
#line 2337 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 281:
  case_281();
  break;
case 282:
#line 2347 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 283:
  case_283();
  break;
case 284:
  case_284();
  break;
case 285:
  case_285();
  break;
case 286:
  case_286();
  break;
case 287:
  case_287();
  break;
case 288:
  case_288();
  break;
case 289:
  case_289();
  break;
case 290:
  case_290();
  break;
case 291:
  case_291();
  break;
case 292:
  case_292();
  break;
case 293:
  case_293();
  break;
case 295:
#line 2474 "cs-parser.jay"
  {
	  	++lexer.parsing_block;
	  }
  break;
case 296:
  case_296();
  break;
case 299:
#line 2492 "cs-parser.jay"
  {
		current_event_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 300:
#line 2496 "cs-parser.jay"
  {
		current_event_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 301:
  case_301();
  break;
case 302:
#line 2509 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 303:
  case_303();
  break;
case 304:
  case_304();
  break;
case 305:
#line 2534 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 308:
  case_308();
  break;
case 309:
  case_309();
  break;
case 310:
  case_310();
  break;
case 311:
  case_311();
  break;
case 312:
  case_312();
  break;
case 313:
  case_313();
  break;
case 314:
  case_314();
  break;
case 315:
  case_315();
  break;
case 317:
  case_317();
  break;
case 318:
  case_318();
  break;
case 319:
  case_319();
  break;
case 320:
  case_320();
  break;
case 321:
  case_321();
  break;
case 322:
  case_322();
  break;
case 324:
  case_324();
  break;
case 325:
  case_325();
  break;
case 328:
#line 2720 "cs-parser.jay"
  {
		lbag.AppendToMember (current_container, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 330:
  case_330();
  break;
case 331:
  case_331();
  break;
case 332:
  case_332();
  break;
case 333:
  case_333();
  break;
case 334:
  case_334();
  break;
case 336:
#line 2794 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out | ParameterModifierType.Params | ParameterModifierType.DefaultValue;
	  }
  break;
case 337:
  case_337();
  break;
case 338:
#line 2813 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = false;
	  }
  break;
case 339:
  case_339();
  break;
case 341:
  case_341();
  break;
case 343:
  case_343();
  break;
case 345:
  case_345();
  break;
case 346:
  case_346();
  break;
case 348:
  case_348();
  break;
case 349:
  case_349();
  break;
case 350:
  case_350();
  break;
case 351:
  case_351();
  break;
case 352:
#line 2919 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 353:
  case_353();
  break;
case 354:
  case_354();
  break;
case 356:
  case_356();
  break;
case 357:
  case_357();
  break;
case 358:
  case_358();
  break;
case 359:
  case_359();
  break;
case 360:
  case_360();
  break;
case 361:
  case_361();
  break;
case 363:
  case_363();
  break;
case 364:
  case_364();
  break;
case 365:
  case_365();
  break;
case 366:
  case_366();
  break;
case 367:
  case_367();
  break;
case 369:
#line 3044 "cs-parser.jay"
  {
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 370:
#line 3051 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 372:
  case_372();
  break;
case 374:
  case_374();
  break;
case 376:
  case_376();
  break;
case 378:
#line 3089 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 379:
  case_379();
  break;
case 380:
#line 3108 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((ATypeNameExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 381:
  case_381();
  break;
case 382:
#line 3117 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 383:
#line 3121 "cs-parser.jay"
  {
		yyVal = new ComposedCast (new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-1+yyTop])), (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 384:
  case_384();
  break;
case 385:
  case_385();
  break;
case 386:
  case_386();
  break;
case 387:
#line 3155 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Object, GetLocation (yyVals[0+yyTop])); }
  break;
case 388:
#line 3156 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.String, GetLocation (yyVals[0+yyTop])); }
  break;
case 389:
#line 3157 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Bool, GetLocation (yyVals[0+yyTop])); }
  break;
case 390:
#line 3158 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Decimal, GetLocation (yyVals[0+yyTop])); }
  break;
case 391:
#line 3159 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Float, GetLocation (yyVals[0+yyTop])); }
  break;
case 392:
#line 3160 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Double, GetLocation (yyVals[0+yyTop])); }
  break;
case 394:
#line 3165 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.SByte, GetLocation (yyVals[0+yyTop])); }
  break;
case 395:
#line 3166 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Byte, GetLocation (yyVals[0+yyTop])); }
  break;
case 396:
#line 3167 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Short, GetLocation (yyVals[0+yyTop])); }
  break;
case 397:
#line 3168 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.UShort, GetLocation (yyVals[0+yyTop])); }
  break;
case 398:
#line 3169 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Int, GetLocation (yyVals[0+yyTop])); }
  break;
case 399:
#line 3170 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.UInt, GetLocation (yyVals[0+yyTop])); }
  break;
case 400:
#line 3171 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Long, GetLocation (yyVals[0+yyTop])); }
  break;
case 401:
#line 3172 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.ULong, GetLocation (yyVals[0+yyTop])); }
  break;
case 402:
#line 3173 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Char, GetLocation (yyVals[0+yyTop])); }
  break;
case 423:
  case_423();
  break;
case 424:
  case_424();
  break;
case 428:
#line 3220 "cs-parser.jay"
  { yyVal = new NullLiteral (GetLocation (yyVals[0+yyTop])); }
  break;
case 429:
#line 3224 "cs-parser.jay"
  { yyVal = new BoolLiteral (compiler.BuiltinTypes, true, GetLocation (yyVals[0+yyTop])); }
  break;
case 430:
#line 3225 "cs-parser.jay"
  { yyVal = new BoolLiteral (compiler.BuiltinTypes, false, GetLocation (yyVals[0+yyTop])); }
  break;
case 435:
  case_435();
  break;
case 436:
#line 3258 "cs-parser.jay"
  {
		yyVal = new ParenthesizedExpression ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }
  break;
case 437:
  case_437();
  break;
case 438:
  case_438();
  break;
case 439:
  case_439();
  break;
case 440:
  case_440();
  break;
case 441:
#line 3290 "cs-parser.jay"
  {
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-2+yyTop], null,GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 442:
  case_442();
  break;
case 443:
#line 3298 "cs-parser.jay"
  {
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-2+yyTop], null, lexer.Location);
	  }
  break;
case 444:
  case_444();
  break;
case 445:
  case_445();
  break;
case 446:
  case_446();
  break;
case 447:
  case_447();
  break;
case 448:
#line 3328 "cs-parser.jay"
  { yyVal = null; }
  break;
case 450:
  case_450();
  break;
case 451:
  case_451();
  break;
case 452:
#line 3350 "cs-parser.jay"
  { yyVal = null; }
  break;
case 453:
#line 3354 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	}
  break;
case 454:
  case_454();
  break;
case 455:
  case_455();
  break;
case 456:
  case_456();
  break;
case 457:
  case_457();
  break;
case 458:
  case_458();
  break;
case 459:
#line 3393 "cs-parser.jay"
  {
		yyVal = new CompletionElementInitializer (null, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 460:
  case_460();
  break;
case 461:
  case_461();
  break;
case 462:
  case_462();
  break;
case 465:
#line 3424 "cs-parser.jay"
  { yyVal = null; }
  break;
case 467:
  case_467();
  break;
case 468:
  case_468();
  break;
case 469:
  case_469();
  break;
case 470:
  case_470();
  break;
case 471:
  case_471();
  break;
case 472:
#line 3478 "cs-parser.jay"
  {
		yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 476:
  case_476();
  break;
case 477:
  case_477();
  break;
case 478:
  case_478();
  break;
case 479:
  case_479();
  break;
case 481:
  case_481();
  break;
case 482:
  case_482();
  break;
case 483:
  case_483();
  break;
case 484:
  case_484();
  break;
case 485:
  case_485();
  break;
case 486:
  case_486();
  break;
case 487:
  case_487();
  break;
case 488:
#line 3571 "cs-parser.jay"
  {
	  	yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 490:
#line 3579 "cs-parser.jay"
  {
		yyVal = new This (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 491:
  case_491();
  break;
case 492:
  case_492();
  break;
case 493:
#line 3599 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PostIncrement, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 494:
#line 3606 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PostDecrement, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 495:
  case_495();
  break;
case 496:
  case_496();
  break;
case 497:
  case_497();
  break;
case 498:
  case_498();
  break;
case 499:
  case_499();
  break;
case 500:
  case_500();
  break;
case 501:
  case_501();
  break;
case 502:
#line 3673 "cs-parser.jay"
  {
		++lexer.parsing_type;
	  }
  break;
case 503:
  case_503();
  break;
case 504:
  case_504();
  break;
case 507:
#line 3700 "cs-parser.jay"
  { yyVal = null; }
  break;
case 509:
  case_509();
  break;
case 510:
  case_510();
  break;
case 511:
  case_511();
  break;
case 512:
  case_512();
  break;
case 513:
  case_513();
  break;
case 514:
  case_514();
  break;
case 518:
  case_518();
  break;
case 519:
  case_519();
  break;
case 520:
  case_520();
  break;
case 521:
#line 3778 "cs-parser.jay"
  {
		yyVal = 2;
	  }
  break;
case 522:
#line 3782 "cs-parser.jay"
  {
		yyVal = ((int) yyVals[-1+yyTop]) + 1;
	  }
  break;
case 523:
#line 3789 "cs-parser.jay"
  {
		yyVal = null;
	  }
  break;
case 524:
#line 3793 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 525:
  case_525();
  break;
case 526:
  case_526();
  break;
case 527:
  case_527();
  break;
case 528:
  case_528();
  break;
case 529:
#line 3837 "cs-parser.jay"
  {
	  	lexer.TypeOfParsing = true;
	  }
  break;
case 530:
  case_530();
  break;
case 533:
  case_533();
  break;
case 534:
  case_534();
  break;
case 535:
  case_535();
  break;
case 536:
  case_536();
  break;
case 537:
  case_537();
  break;
case 538:
  case_538();
  break;
case 539:
  case_539();
  break;
case 540:
  case_540();
  break;
case 541:
  case_541();
  break;
case 542:
  case_542();
  break;
case 543:
  case_543();
  break;
case 544:
  case_544();
  break;
case 545:
  case_545();
  break;
case 546:
  case_546();
  break;
case 547:
  case_547();
  break;
case 548:
#line 3980 "cs-parser.jay"
  {
		start_anonymous (false, (ParametersCompiled) yyVals[0+yyTop], false, GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 549:
  case_549();
  break;
case 550:
#line 3993 "cs-parser.jay"
  {
		start_anonymous (false, (ParametersCompiled) yyVals[0+yyTop], true, GetLocation (yyVals[-2+yyTop]));
	  }
  break;
case 551:
  case_551();
  break;
case 552:
#line 4010 "cs-parser.jay"
  {
		yyVal = ParametersCompiled.Undefined;
	  }
  break;
case 554:
#line 4018 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 555:
  case_555();
  break;
case 556:
  case_556();
  break;
case 558:
#line 4044 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.LogicalNot, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 559:
#line 4048 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.OnesComplement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 560:
  case_560();
  break;
case 561:
  case_561();
  break;
case 562:
  case_562();
  break;
case 563:
  case_563();
  break;
case 564:
  case_564();
  break;
case 565:
  case_565();
  break;
case 567:
#line 4112 "cs-parser.jay"
  { 
	  	yyVal = new Unary (Unary.Operator.UnaryPlus, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 568:
#line 4116 "cs-parser.jay"
  { 
		yyVal = new Unary (Unary.Operator.UnaryNegation, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 569:
#line 4120 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PreIncrement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 570:
#line 4124 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PreDecrement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 571:
#line 4128 "cs-parser.jay"
  {
		yyVal = new Indirection ((Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 572:
#line 4132 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.AddressOf, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 573:
  case_573();
  break;
case 574:
  case_574();
  break;
case 575:
  case_575();
  break;
case 576:
  case_576();
  break;
case 577:
  case_577();
  break;
case 578:
  case_578();
  break;
case 580:
  case_580();
  break;
case 581:
  case_581();
  break;
case 582:
  case_582();
  break;
case 583:
  case_583();
  break;
case 584:
  case_584();
  break;
case 585:
  case_585();
  break;
case 587:
  case_587();
  break;
case 588:
  case_588();
  break;
case 589:
#line 4226 "cs-parser.jay"
  {
		yyVal = new As ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 590:
#line 4230 "cs-parser.jay"
  {
		yyVal = new Is ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 591:
  case_591();
  break;
case 592:
  case_592();
  break;
case 593:
  case_593();
  break;
case 594:
  case_594();
  break;
case 596:
  case_596();
  break;
case 597:
  case_597();
  break;
case 598:
  case_598();
  break;
case 599:
  case_599();
  break;
case 601:
  case_601();
  break;
case 602:
  case_602();
  break;
case 603:
  case_603();
  break;
case 604:
  case_604();
  break;
case 605:
  case_605();
  break;
case 606:
  case_606();
  break;
case 607:
  case_607();
  break;
case 608:
  case_608();
  break;
case 610:
  case_610();
  break;
case 611:
  case_611();
  break;
case 612:
  case_612();
  break;
case 613:
  case_613();
  break;
case 615:
  case_615();
  break;
case 616:
  case_616();
  break;
case 618:
  case_618();
  break;
case 619:
  case_619();
  break;
case 621:
  case_621();
  break;
case 622:
  case_622();
  break;
case 624:
  case_624();
  break;
case 625:
  case_625();
  break;
case 627:
  case_627();
  break;
case 628:
  case_628();
  break;
case 630:
  case_630();
  break;
case 632:
  case_632();
  break;
case 633:
  case_633();
  break;
case 634:
  case_634();
  break;
case 635:
  case_635();
  break;
case 636:
  case_636();
  break;
case 637:
  case_637();
  break;
case 638:
  case_638();
  break;
case 639:
  case_639();
  break;
case 640:
  case_640();
  break;
case 641:
  case_641();
  break;
case 642:
  case_642();
  break;
case 643:
  case_643();
  break;
case 644:
  case_644();
  break;
case 645:
  case_645();
  break;
case 646:
  case_646();
  break;
case 647:
  case_647();
  break;
case 648:
  case_648();
  break;
case 649:
  case_649();
  break;
case 650:
  case_650();
  break;
case 651:
  case_651();
  break;
case 652:
  case_652();
  break;
case 653:
#line 4596 "cs-parser.jay"
  { yyVal = ParametersCompiled.EmptyReadOnlyParameters; }
  break;
case 654:
  case_654();
  break;
case 655:
#line 4607 "cs-parser.jay"
  {
		start_block (Location.Null);
	  }
  break;
case 656:
  case_656();
  break;
case 658:
  case_658();
  break;
case 660:
  case_660();
  break;
case 661:
  case_661();
  break;
case 662:
  case_662();
  break;
case 663:
  case_663();
  break;
case 664:
  case_664();
  break;
case 665:
  case_665();
  break;
case 666:
  case_666();
  break;
case 667:
#line 4674 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 668:
  case_668();
  break;
case 669:
  case_669();
  break;
case 670:
#line 4688 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;	  
	  }
  break;
case 671:
  case_671();
  break;
case 672:
  case_672();
  break;
case 678:
#line 4713 "cs-parser.jay"
  {
		yyVal = new ArglistAccess (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 679:
  case_679();
  break;
case 680:
  case_680();
  break;
case 681:
  case_681();
  break;
case 683:
#line 4742 "cs-parser.jay"
  {
		yyVal = new BooleanExpression ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 684:
#line 4754 "cs-parser.jay"
  {
	  }
  break;
case 685:
  case_685();
  break;
case 686:
  case_686();
  break;
case 687:
  case_687();
  break;
case 688:
  case_688();
  break;
case 689:
#line 4801 "cs-parser.jay"
  { yyVal = null; }
  break;
case 690:
#line 4803 "cs-parser.jay"
  { yyVal = yyVals[0+yyTop]; StoreModifierLocation (Modifiers.PARTIAL, GetLocation (yyVals[0+yyTop])); }
  break;
case 691:
  case_691();
  break;
case 692:
#line 4816 "cs-parser.jay"
  {
		lexer.parsing_modifiers = false;		
	  }
  break;
case 694:
  case_694();
  break;
case 695:
  case_695();
  break;
case 696:
  case_696();
  break;
case 697:
  case_697();
  break;
case 698:
  case_698();
  break;
case 699:
  case_699();
  break;
case 700:
  case_700();
  break;
case 701:
  case_701();
  break;
case 702:
  case_702();
  break;
case 703:
  case_703();
  break;
case 704:
  case_704();
  break;
case 705:
  case_705();
  break;
case 706:
  case_706();
  break;
case 707:
  case_707();
  break;
case 708:
  case_708();
  break;
case 709:
  case_709();
  break;
case 711:
  case_711();
  break;
case 712:
  case_712();
  break;
case 714:
#line 4942 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 715:
  case_715();
  break;
case 716:
  case_716();
  break;
case 717:
  case_717();
  break;
case 718:
  case_718();
  break;
case 719:
  case_719();
  break;
case 720:
  case_720();
  break;
case 721:
  case_721();
  break;
case 722:
  case_722();
  break;
case 723:
#line 5035 "cs-parser.jay"
  {
		yyVal = new SpecialContraintExpr (SpecialConstraint.Class, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 724:
#line 5039 "cs-parser.jay"
  {
		yyVal = new SpecialContraintExpr (SpecialConstraint.Struct, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 725:
#line 5046 "cs-parser.jay"
  {
		yyVal = Variance.None;
	  }
  break;
case 726:
  case_726();
  break;
case 727:
  case_727();
  break;
case 728:
  case_728();
  break;
case 729:
  case_729();
  break;
case 730:
#line 5091 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 731:
  case_731();
  break;
case 732:
  case_732();
  break;
case 733:
  case_733();
  break;
case 734:
  case_734();
  break;
case 735:
  case_735();
  break;
case 736:
  case_736();
  break;
case 737:
  case_737();
  break;
case 742:
#line 5153 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 743:
#line 5157 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 745:
  case_745();
  break;
case 746:
  case_746();
  break;
case 749:
#line 5191 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 750:
#line 5195 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 779:
  case_779();
  break;
case 780:
  case_780();
  break;
case 781:
  case_781();
  break;
case 782:
  case_782();
  break;
case 783:
  case_783();
  break;
case 786:
  case_786();
  break;
case 787:
  case_787();
  break;
case 788:
  case_788();
  break;
case 789:
  case_789();
  break;
case 790:
#line 5339 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 791:
#line 5343 "cs-parser.jay"
  {
		yyVal = new ComposedCast (new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-1+yyTop])), (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 792:
  case_792();
  break;
case 794:
  case_794();
  break;
case 795:
#line 5364 "cs-parser.jay"
  {
		yyVal = ComposedTypeSpecifier.CreatePointer (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 797:
#line 5372 "cs-parser.jay"
  {
	  	yyVal = Error_AwaitAsIdentifier (yyVals[0+yyTop]);
	  }
  break;
case 798:
  case_798();
  break;
case 799:
  case_799();
  break;
case 800:
  case_800();
  break;
case 801:
  case_801();
  break;
case 803:
  case_803();
  break;
case 805:
  case_805();
  break;
case 806:
  case_806();
  break;
case 810:
  case_810();
  break;
case 813:
  case_813();
  break;
case 814:
  case_814();
  break;
case 815:
#line 5486 "cs-parser.jay"
  {
		report.Error (145, lexer.Location, "A const field requires a value to be provided");
	  }
  break;
case 816:
  case_816();
  break;
case 821:
  case_821();
  break;
case 823:
  case_823();
  break;
case 824:
  case_824();
  break;
case 825:
  case_825();
  break;
case 826:
#line 5536 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 827:
  case_827();
  break;
case 828:
#line 5546 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 829:
#line 5547 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 830:
  case_830();
  break;
case 831:
  case_831();
  break;
case 832:
  case_832();
  break;
case 835:
  case_835();
  break;
case 836:
  case_836();
  break;
case 837:
  case_837();
  break;
case 838:
#line 5619 "cs-parser.jay"
  {
		start_block (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 839:
  case_839();
  break;
case 840:
  case_840();
  break;
case 841:
#line 5639 "cs-parser.jay"
  {
		report.Warning (1522, 1, current_block.StartLocation, "Empty switch block"); 
	  }
  break;
case 845:
#line 5649 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);
	  }
  break;
case 847:
  case_847();
  break;
case 848:
#line 5666 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 849:
  case_849();
  break;
case 850:
  case_850();
  break;
case 851:
#line 5683 "cs-parser.jay"
  {
		yyVal = new SwitchLabel (null, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 856:
  case_856();
  break;
case 857:
  case_857();
  break;
case 858:
  case_858();
  break;
case 859:
  case_859();
  break;
case 860:
  case_860();
  break;
case 861:
  case_861();
  break;
case 862:
#line 5744 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 863:
  case_863();
  break;
case 864:
#line 5759 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 865:
  case_865();
  break;
case 866:
  case_866();
  break;
case 867:
#line 5780 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 868:
  case_868();
  break;
case 869:
  case_869();
  break;
case 870:
  case_870();
  break;
case 871:
#line 5814 "cs-parser.jay"
  { yyVal = new EmptyStatement (lexer.Location); }
  break;
case 873:
  case_873();
  break;
case 874:
  case_874();
  break;
case 876:
#line 5838 "cs-parser.jay"
  { yyVal = null; }
  break;
case 878:
#line 5843 "cs-parser.jay"
  { yyVal = new EmptyStatement (lexer.Location); }
  break;
case 882:
  case_882();
  break;
case 883:
  case_883();
  break;
case 884:
  case_884();
  break;
case 885:
  case_885();
  break;
case 886:
  case_886();
  break;
case 887:
  case_887();
  break;
case 888:
  case_888();
  break;
case 895:
  case_895();
  break;
case 896:
  case_896();
  break;
case 897:
  case_897();
  break;
case 898:
  case_898();
  break;
case 899:
  case_899();
  break;
case 900:
  case_900();
  break;
case 901:
  case_901();
  break;
case 902:
  case_902();
  break;
case 903:
  case_903();
  break;
case 904:
  case_904();
  break;
case 905:
  case_905();
  break;
case 906:
  case_906();
  break;
case 907:
  case_907();
  break;
case 908:
  case_908();
  break;
case 909:
  case_909();
  break;
case 912:
#line 6089 "cs-parser.jay"
  {
		yyVal = new TryCatch ((Block) yyVals[-1+yyTop], (List<Catch>) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]), false);
	  }
  break;
case 913:
  case_913();
  break;
case 914:
  case_914();
  break;
case 915:
  case_915();
  break;
case 916:
  case_916();
  break;
case 917:
  case_917();
  break;
case 920:
#line 6138 "cs-parser.jay"
  {
		yyVal = new Catch ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 921:
  case_921();
  break;
case 922:
#line 6157 "cs-parser.jay"
  {
		yyVal = yyVals[-1+yyTop];
	  }
  break;
case 923:
  case_923();
  break;
case 924:
  case_924();
  break;
case 925:
#line 6198 "cs-parser.jay"
  {
		yyVal = new Checked ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 926:
#line 6205 "cs-parser.jay"
  {
		yyVal = new Unchecked ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 927:
  case_927();
  break;
case 928:
#line 6215 "cs-parser.jay"
  {
		yyVal = new Unsafe ((Block) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }
  break;
case 929:
  case_929();
  break;
case 930:
  case_930();
  break;
case 931:
  case_931();
  break;
case 932:
  case_932();
  break;
case 933:
  case_933();
  break;
case 934:
  case_934();
  break;
case 935:
  case_935();
  break;
case 936:
  case_936();
  break;
case 937:
  case_937();
  break;
case 938:
  case_938();
  break;
case 940:
  case_940();
  break;
case 941:
#line 6320 "cs-parser.jay"
  {
		Error_MissingInitializer (lexer.Location);
	  }
  break;
case 942:
  case_942();
  break;
case 943:
  case_943();
  break;
case 944:
  case_944();
  break;
case 945:
  case_945();
  break;
case 946:
  case_946();
  break;
case 947:
  case_947();
  break;
case 948:
  case_948();
  break;
case 949:
  case_949();
  break;
case 950:
  case_950();
  break;
case 951:
#line 6425 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 952:
  case_952();
  break;
case 953:
#line 6441 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 954:
  case_954();
  break;
case 955:
  case_955();
  break;
case 956:
  case_956();
  break;
case 958:
  case_958();
  break;
case 959:
  case_959();
  break;
case 960:
#line 6505 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 961:
  case_961();
  break;
case 962:
  case_962();
  break;
case 963:
  case_963();
  break;
case 964:
  case_964();
  break;
case 965:
#line 6544 "cs-parser.jay"
  {
	  	yyVal = new object[] { yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]) };
	  }
  break;
case 966:
  case_966();
  break;
case 968:
  case_968();
  break;
case 974:
#line 6573 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 975:
  case_975();
  break;
case 976:
#line 6592 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 977:
  case_977();
  break;
case 978:
  case_978();
  break;
case 979:
  case_979();
  break;
case 980:
  case_980();
  break;
case 981:
  case_981();
  break;
case 982:
  case_982();
  break;
case 983:
  case_983();
  break;
case 984:
  case_984();
  break;
case 985:
  case_985();
  break;
case 987:
  case_987();
  break;
case 988:
  case_988();
  break;
case 989:
  case_989();
  break;
case 991:
  case_991();
  break;
case 992:
  case_992();
  break;
case 994:
  case_994();
  break;
case 995:
  case_995();
  break;
case 996:
#line 6793 "cs-parser.jay"
  {
		yyVal = new Linq.OrderByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[0+yyTop]);	
	  }
  break;
case 997:
  case_997();
  break;
case 998:
  case_998();
  break;
case 999:
#line 6810 "cs-parser.jay"
  {
		yyVal = new Linq.ThenByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[0+yyTop]);	
	  }
  break;
case 1000:
  case_1000();
  break;
case 1001:
  case_1001();
  break;
case 1003:
  case_1003();
  break;
case 1004:
  case_1004();
  break;
case 1007:
  case_1007();
  break;
case 1008:
  case_1008();
  break;
case 1016:
#line 6935 "cs-parser.jay"
  {
		module.DocumentationBuilder.ParsedName = (MemberName) yyVals[0+yyTop];
	  }
  break;
case 1017:
#line 6942 "cs-parser.jay"
  {
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
	  }
  break;
case 1018:
  case_1018();
  break;
case 1019:
  case_1019();
  break;
case 1020:
#line 6959 "cs-parser.jay"
  {
		yyVal = new MemberName ((MemberName) yyVals[-2+yyTop], MemberCache.IndexerNameAlias, Location.Null);
	  }
  break;
case 1021:
#line 6963 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 1022:
  case_1022();
  break;
case 1023:
  case_1023();
  break;
case 1024:
  case_1024();
  break;
case 1025:
  case_1025();
  break;
case 1027:
#line 6999 "cs-parser.jay"
  {
		yyVal = new MemberName (((MemberName) yyVals[-2+yyTop]), (MemberName) yyVals[0+yyTop]);
	  }
  break;
case 1029:
#line 7007 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 1030:
#line 7011 "cs-parser.jay"
  {
		yyVal = yyVals[-1+yyTop];
	  }
  break;
case 1031:
#line 7018 "cs-parser.jay"
  {
		yyVal = new List<DocumentationParameter> (0);
	  }
  break;
case 1033:
  case_1033();
  break;
case 1034:
  case_1034();
  break;
case 1035:
  case_1035();
  break;
#line default
        }
        yyTop -= yyLen[yyN];
        yyState = yyStates[yyTop];
        int yyM = yyLhs[yyN];
        if (yyState == 0 && yyM == 0) {
//t          if (debug != null) debug.shift(0, yyFinal);
          yyState = yyFinal;
          if (yyToken < 0) {
            yyToken = yyLex.advance() ? yyLex.token() : 0;
//t            if (debug != null)
//t               debug.lex(yyState, yyToken,yyname(yyToken), yyLex.value());
          }
          if (yyToken == 0) {
//t            if (debug != null) debug.accept(yyVal);
            return yyVal;
          }
          goto continue_yyLoop;
        }
        if (((yyN = yyGindex[yyM]) != 0) && ((yyN += yyState) >= 0)
            && (yyN < yyTable.Length) && (yyCheck[yyN] == yyState))
          yyState = yyTable[yyN];
        else
          yyState = yyDgoto[yyM];
//t        if (debug != null) debug.shift(yyStates[yyTop], yyState);
	 goto continue_yyLoop;
      continue_yyDiscarded: ;	// implements the named-loop continue: 'continue yyDiscarded'
      }
    continue_yyLoop: ;		// implements the named-loop continue: 'continue yyLoop'
    }
  }

/*
 All more than 3 lines long rules are wrapped into a method
*/
void case_6()
#line 396 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			Attributes attrs = (Attributes) yyVals[0+yyTop];
			report.Error (1730, attrs.Attrs [0].Location,
				"Assembly and module attributes must precede all other elements except using clauses and extern alias declarations");

			current_namespace.UnattachedAttributes = attrs;
		}
	  }

void case_8()
#line 410 "cs-parser.jay"
{
		if (yyToken == Token.EXTERN_ALIAS)
			report.Error (439, lexer.Location, "An extern alias declaration must precede all other elements");
		else
			Error_SyntaxError (yyToken);
	  }

void case_13()
#line 430 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		string s = lt.Value;
		if (s != "alias") {
			syntax_error (lt.Location, "`alias' expected");
		} else {
			if (lang_version == LanguageVersion.ISO_1)
				FeatureIsNotAvailable (lt.Location, "external alias");

			lt = (LocatedToken) yyVals[-1+yyTop];
			if (lt.Value == QualifiedAliasMember.GlobalAlias) {
				RootNamespace.Error_GlobalNamespaceRedefined (report, lt.Location);
			}
			
			var na = new UsingExternAlias (new SimpleMemberName (lt.Value, lt.Location), GetLocation (yyVals[-3+yyTop]));
			current_namespace.AddUsing (na);
			
			lbag.AddLocation (na, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_17()
#line 463 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_18()
#line 471 "cs-parser.jay"
{
		var un = new UsingNamespace ((ATypeNameExpression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		current_namespace.AddUsing (un);
		
		lbag.AddLocation (un, GetLocation (yyVals[0+yyTop]));
	  }

void case_19()
#line 478 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-3+yyTop];
		if (lang_version != LanguageVersion.ISO_1 && lt.Value == "global") {
			report.Warning (440, 2, lt.Location,
			 "An alias named `global' will not be used when resolving `global::'. The global namespace will be used instead");
		}

		var un = new UsingAliasNamespace (new SimpleMemberName (lt.Value, lt.Location), (ATypeNameExpression) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		current_namespace.AddUsing (un);
		lbag.AddLocation (un, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_20()
#line 490 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	 }

void case_21()
#line 503 "cs-parser.jay"
{
		Attributes attrs = (Attributes) yyVals[-2+yyTop];
		var name = (MemberName) yyVals[0+yyTop];
		if (attrs != null) {
			bool valid_global_attrs = true;
			if ((current_namespace.DeclarationFound || current_namespace != file)) {
				valid_global_attrs = false;
			} else {
				foreach (var a in attrs.Attrs) {
					if (a.ExplicitTarget == "assembly" || a.ExplicitTarget == "module")
						continue;
						
					valid_global_attrs = false;
					break;
				}
			}
			
			if (!valid_global_attrs)
				report.Error (1671, name.Location, "A namespace declaration cannot have modifiers or attributes");
		}
	
		module.AddAttributes (attrs, current_namespace);
		
		var ns = new NamespaceContainer (name, current_namespace);
		current_namespace.AddTypeContainer (ns);
		current_container = current_namespace = ns;
	  }

void case_22()
#line 531 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_23()
#line 536 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null)
			lbag.AddLocation (current_container, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		else
			lbag.AddLocation (current_container, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  
		current_container = current_namespace = current_namespace.Parent;
	  }

void case_24()
#line 545 "cs-parser.jay"
{
		report.Error (1514, lexer.Location, "Unexpected symbol `{0}', expecting `.' or `{{'", GetSymbolName (yyToken));

		var name = (MemberName) yyVals[0+yyTop];		
		var ns = new NamespaceContainer (name, current_namespace);
		lbag.AddLocation (ns, GetLocation (yyVals[-1+yyTop]));
		current_namespace.AddTypeContainer (ns);
	  }

void case_27()
#line 559 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  	yyVal = null;
	  }

void case_28()
#line 567 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		yyVal = new MemberName (lt.Value, lt.Location);
	  }

void case_29()
#line 572 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-2+yyTop], lt.Value, lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_30()
#line 578 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new MemberName ("<invalid>", lexer.Location);
	  }

void case_43()
#line 616 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			TypeContainer ds = (TypeContainer)yyVals[0+yyTop];

			if ((ds.ModFlags & (Modifiers.PRIVATE | Modifiers.PROTECTED)) != 0){
				report.Error (1527, ds.Location, 
				"Namespace elements cannot be explicitly declared as private, protected or protected internal");
			}

			/* Here is a trick, for explicit attributes we don't know where they belong to until*/
			/* we parse succeeding declaration hence we parse them as normal and re-attach them*/
			/* when we know whether they are global (assembly:, module:) or local (type:).*/
			if (ds.OptAttributes != null) {
				ds.OptAttributes.ConvertGlobalAttributes (ds, current_namespace, !current_namespace.DeclarationFound && current_namespace == file);
			}
		}
		current_namespace.DeclarationFound = true;
	  }

void case_45()
#line 638 "cs-parser.jay"
{
		current_namespace.UnattachedAttributes = (Attributes) yyVals[-1+yyTop];
		report.Error (1518, lexer.Location, "Attributes must be attached to class, delegate, enum, interface or struct");
		lexer.putback ('}');
	  }

void case_53()
#line 671 "cs-parser.jay"
{
		var sect = (List<Attribute>) yyVals[0+yyTop];
		yyVal = new Attributes (sect);
		if (locationListStack.Count > 0)
			lbag.AddLocation (sect, locationListStack.Pop ());
		if (attributeCommas.Count > 0) {
			lbag.AddLocation (sect, attributeCommas);
			attributeCommas.Clear ();
		}
	  }

void case_54()
#line 682 "cs-parser.jay"
{
		Attributes attrs = yyVals[-1+yyTop] as Attributes;
		var sect = (List<Attribute>) yyVals[0+yyTop];
		
		if (locationListStack.Count > 0)
			lbag.AddLocation (sect, locationListStack.Pop ());
		if (attrs == null)
			attrs = new Attributes (sect);
		else if (sect != null)
			attrs.AddAttributes (sect);
		yyVal = attrs;
	  }

void case_55()
#line 698 "cs-parser.jay"
{
	  	PushLocation (GetLocation (yyVals[0+yyTop]));
		lexer.parsing_attribute_section = true;
		savedOpenLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_56()
#line 704 "cs-parser.jay"
{
		lexer.parsing_attribute_section = false;
		yyVal = yyVals[0+yyTop];
	  }

void case_57()
#line 712 "cs-parser.jay"
{
		current_attr_target = (string) yyVals[-1+yyTop];
		if (current_attr_target == "assembly" || current_attr_target == "module") {
			Lexer.check_incorrect_doc_comment ();
		}
	  }

void case_58()
#line 719 "cs-parser.jay"
{
		/* when attribute target is invalid*/
		if (current_attr_target == string.Empty)
			yyVal = new List<Attribute> (0);
		else
			yyVal = yyVals[-2+yyTop];

		lbag.InsertLocation (yyVal, 0, PopLocation ());
		if (yyVals[-1+yyTop] != null) {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[0+yyTop]));
		}

		current_attr_target = null;
		lexer.parsing_attribute_section = false;
 	  }

void case_59()
#line 737 "cs-parser.jay"
{
		yyVal = yyVals[-2+yyTop];

		lbag.InsertLocation (yyVal, 0, PopLocation ());
		if (yyVals[-1+yyTop] != null) {
			lbag.AddLocation (yyVal, GetLocation(yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (yyVal, GetLocation(yyVals[0+yyTop]));
		}
	  }

void case_60()
#line 748 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		var lt = (LocatedToken) yyVals[-1+yyTop];
		var tne = new SimpleName (lt.Value, null, lt.Location);

		yyVal = new List<Attribute> () {
			new Attribute (null, tne, null, GetLocation (yyVals[-1+yyTop]), false)
		};
	  }

void case_61()
#line 759 "cs-parser.jay"
{
 		CheckAttributeTarget (GetTokenName (yyToken), GetLocation (yyVals[0+yyTop])); 
 		yyVal = null;
	  }

void case_62()
#line 767 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		yyVal = CheckAttributeTarget (lt.Value, lt.Location);
		savedCloseLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_66()
#line 782 "cs-parser.jay"
{
		var attrs = (List<Attribute>) yyVals[-2+yyTop];
		if (attrs != null) {
			attrs.Add ((Attribute) yyVals[0+yyTop]);
	  		lbag.AddLocation (attrs, GetLocation (yyVals[-1+yyTop]));
	  	}

		yyVal = attrs;
	  }

void case_68()
#line 799 "cs-parser.jay"
{
		--lexer.parsing_block;
		
		var tne = (ATypeNameExpression) yyVals[-2+yyTop];
		if (tne.HasTypeArguments) {
			report.Error (404, tne.Location, "Attributes cannot be generic");
		}
		Arguments [] arguments = (Arguments []) yyVals[0+yyTop];

		yyVal = new Attribute (current_attr_target, tne, (Arguments[]) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]), lexer.IsEscapedIdentifier (tne));
		if (arguments != null) {
			attributeArgumentCommas.Insert (0, savedAttrParenOpenLocation);
			attributeArgumentCommas.Add (savedAttrParenCloseLocation);
			lbag.AddLocation (yyVal, attributeArgumentCommas);
			attributeArgumentCommas.Clear ();
		} else if (HadAttributeParens) {
			lbag.AddLocation (yyVal, savedAttrParenOpenLocation, savedAttrParenCloseLocation);
		}
	  }

void case_71()
#line 827 "cs-parser.jay"
{
		savedAttrParenOpenLocation = GetLocation (yyVals[-2+yyTop]);
		savedAttrParenCloseLocation = GetLocation (yyVals[0+yyTop]);
		yyVal = yyVals[-1+yyTop];
		HadAttributeParens = true;
	  }

void case_73()
#line 839 "cs-parser.jay"
{
	  	Arguments a = new Arguments (4);
		a.Add ((Argument) yyVals[0+yyTop]);
		yyVal = new Arguments [] { a, null };
	  }

void case_74()
#line 845 "cs-parser.jay"
{
	  	Arguments a = new Arguments (4);
		a.Add ((Argument) yyVals[0+yyTop]);  
		yyVal = new Arguments [] { null, a };
	  }

void case_75()
#line 851 "cs-parser.jay"
{
		Arguments[] o = (Arguments[]) yyVals[-2+yyTop];
		if (o [1] != null) {
			report.Error (1016, ((Argument) yyVals[0+yyTop]).Expr.Location, "Named attribute arguments must appear after the positional arguments");
			o [0] = new Arguments (4);
		}
		
		Arguments args = ((Arguments) o [0]);
		if (args.Count > 0 && !(yyVals[0+yyTop] is NamedArgument) && args [args.Count - 1] is NamedArgument)
			Error_NamedArgumentExpected ((NamedArgument) args [args.Count - 1]);
		
		args.Add ((Argument) yyVals[0+yyTop]);
		attributeArgumentCommas.Add (GetLocation (yyVals[-1+yyTop]));
	  }

void case_76()
#line 866 "cs-parser.jay"
{
		Arguments[] o = (Arguments[]) yyVals[-2+yyTop];
		if (o [1] == null) {
			o [1] = new Arguments (4);
		}

		((Arguments) o [1]).Add ((Argument) yyVals[0+yyTop]);
		attributeArgumentCommas.Add (GetLocation (yyVals[-1+yyTop]));
	  }

void case_79()
#line 884 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_81()
#line 896 "cs-parser.jay"
{
	  	--lexer.parsing_block;
	  	var lt = (LocatedToken) yyVals[-3+yyTop];
		yyVal = new NamedArgument (lt.Value, lt.Location, (Expression) yyVals[0+yyTop]);	  
		lbag.AddLocation (yyVal, GetLocation(yyVals[-2+yyTop]));
	  }

void case_82()
#line 906 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.V_3)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "named argument");
			
		/* Avoid boxing in common case (no modifier)*/
		var arg_mod = yyVals[-1+yyTop] == null ? Argument.AType.None : (Argument.AType) yyVals[-1+yyTop];
			
		var lt = (LocatedToken) yyVals[-3+yyTop];
		yyVal = new NamedArgument (lt.Value, lt.Location, (Expression) yyVals[0+yyTop], arg_mod);
		lbag.AddLocation (yyVal, GetLocation(yyVals[-2+yyTop]));
	  }

void case_102()
#line 961 "cs-parser.jay"
{
		report.Error (1519, lexer.Location, "Unexpected symbol `{0}' in class, struct, or interface member declaration",
			GetSymbolName (yyToken));
		yyVal = null;
		lexer.parsing_generic_declaration = false;
	  }

void case_104()
#line 977 "cs-parser.jay"
{ 
		lexer.ConstraintsParsing = true;
		push_current_container (new Struct (current_container, (MemberName) yyVals[0+yyTop], (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]), yyVals[-3+yyTop]);
		lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]));
	  }

void case_105()
#line 984 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		if (yyVals[0+yyTop] != null)
			current_container.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support)
			current_container.PartialContainer.DocComment = Lexer.consume_doc_comment ();

		
		lexer.parsing_modifiers = true;
	  }

void case_106()
#line 997 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_107()
#line 1002 "cs-parser.jay"
{
		--lexer.parsing_declaration;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_108()
#line 1008 "cs-parser.jay"
{
		if (yyVals[0+yyTop] == null) {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]));
		} else {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = pop_current_class ();
	  }

void case_110()
#line 1026 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		var mod = (Modifiers) yyVals[-3+yyTop];
		current_field = new Const (current_type, (FullNamedExpression) yyVals[-1+yyTop], mod, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
		current_type.AddMember (current_field);
		
		if ((mod & Modifiers.STATIC) != 0) {
			report.Error (504, current_field.Location, "The constant `{0}' cannot be marked static", current_field.GetSignatureForError ());
		}
		
		yyVal = current_field;
	  }

void case_111()
#line 1039 "cs-parser.jay"
{
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		current_field.Initializer = (ConstInitializer) yyVals[-2+yyTop];
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		current_field = null;
	  }

void case_112()
#line 1052 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		current_type.AddMember (new Const (current_type, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop], MemberName.Null, (Attributes) yyVals[-4+yyTop]));
	  }

void case_117()
#line 1077 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (ConstInitializer) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_119()
#line 1090 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = new ConstInitializer (current_field, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_120()
#line 1096 "cs-parser.jay"
{
		report.Error (145, lexer.Location, "A const field requires a value to be provided");
		yyVal = null;
	  }

void case_123()
#line 1111 "cs-parser.jay"
{
	  	lexer.parsing_generic_declaration = false;

		FullNamedExpression type = (FullNamedExpression) yyVals[-1+yyTop];
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (670, GetLocation (yyVals[-1+yyTop]), "Fields cannot have void type");
			
		var lt = (LocatedToken) yyVals[0+yyTop];
		current_field = new Field (current_type, type, (Modifiers) yyVals[-2+yyTop], new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-3+yyTop]);
		current_type.AddField (current_field);
		yyVal = current_field;
	  }

void case_124()
#line 1126 "cs-parser.jay"
{ 
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
			
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[0+yyTop]));
		yyVal = current_field;
		current_field = null;
	  }

void case_125()
#line 1139 "cs-parser.jay"
{ 
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "fixed size buffers");

		var lt = (LocatedToken) yyVals[0+yyTop];
		current_field = new FixedField (current_type, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop],
			new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
			
		current_type.AddField (current_field);
	  }

void case_126()
#line 1150 "cs-parser.jay"
{
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
	    }

		current_field.Initializer = (ConstInitializer) yyVals[-2+yyTop];	    
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = current_field;
	    current_field = null;
	  }

void case_129()
#line 1173 "cs-parser.jay"
{
	  	++lexer.parsing_block;
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  	start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_130()
#line 1179 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		current_field.Initializer = (Expression) yyVals[0+yyTop];
		lbag.AppendToMember (current_field, GetLocation (yyVals[-2+yyTop]));
		end_block (lexer.Location);
		current_local_parameters = null;
	  }

void case_135()
#line 1206 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), null);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_137()
#line 1216 "cs-parser.jay"
{
		--lexer.parsing_block;
		var lt = (LocatedToken) yyVals[-3+yyTop];	  
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_142()
#line 1242 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];	  
		yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (ConstInitializer) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_144()
#line 1255 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = new ConstInitializer (current_field, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_145()
#line 1261 "cs-parser.jay"
{
		report.Error (443, lexer.Location, "Value or constant expected");
		yyVal = null;
	  }

void case_148()
#line 1271 "cs-parser.jay"
{
		/* It has to be here for the parent to safely restore artificial block*/
	  	Error_SyntaxError (yyToken);
	  	yyVal = null;
	  }

void case_149()
#line 1280 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.NotAllowed;

		/* Was added earlier in the case of body being eof for full ast*/
	  }

void case_150()
#line 1287 "cs-parser.jay"
{
		Method method = (Method) yyVals[-2+yyTop];
		method.Block = (ToplevelBlock) yyVals[0+yyTop];
		async_block = false;
		
		if (method.Block == null) {
			lbag.AppendToMember (method, savedLocation); /* semicolon*/
			method.ParameterInfo.CheckParameters (method);

			if ((method.ModFlags & Modifiers.ASYNC) != 0) {
				report.Error (1994, method.Location, "`{0}': The async modifier can only be used with methods that have a body",
					method.GetSignatureForError ());
			}
		} else {
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, method.Location, "`{0}': interface members cannot have a definition",
					method.GetSignatureForError ());
			}
		}

		current_local_parameters = null;

		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_152()
#line 1323 "cs-parser.jay"
{
		valid_param_mod = 0;
		MemberName name = (MemberName) yyVals[-4+yyTop];
		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];

		var method = Method.Create (current_type, (FullNamedExpression) yyVals[-5+yyTop], (Modifiers) yyVals[-6+yyTop],
				     name, current_local_parameters, (Attributes) yyVals[-7+yyTop]);

		current_type.AddMember (method);

		async_block = (method.ModFlags & Modifiers.ASYNC) != 0;

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		lbag.AddMember (method, GetModifierLocations (), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = method;

		lexer.ConstraintsParsing = true;
	  }

void case_153()
#line 1344 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		if (yyVals[0+yyTop] != null) {
			var method = (Method) yyVals[-1+yyTop];
			method.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);
		}

		yyVal = yyVals[-1+yyTop];
	  }

void case_155()
#line 1363 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
	  	valid_param_mod = ParameterModifierType.All;
	  }

void case_157()
#line 1372 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;
		valid_param_mod = 0;

		MemberName name = (MemberName) yyVals[-6+yyTop];
		current_local_parameters = (ParametersCompiled) yyVals[-3+yyTop];

		var modifiers = (Modifiers) yyVals[-10+yyTop];
		modifiers |= Modifiers.PARTIAL;

		var method = Method.Create (current_type, new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-8+yyTop])),
				     modifiers, name, current_local_parameters, (Attributes) yyVals[-11+yyTop]);

		current_type.AddMember (method);

		async_block = (method.ModFlags & Modifiers.ASYNC) != 0;

		if (yyVals[0+yyTop] != null)
			method.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		StoreModifierLocation (Modifiers.PARTIAL, GetLocation (yyVals[-9+yyTop]));
		lbag.AddMember (method, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = method;
	  }

void case_158()
#line 1403 "cs-parser.jay"
{
		MemberName name = (MemberName) yyVals[-3+yyTop];
		report.Error (1585, name.Location, 
			"Member modifier `{0}' must precede the member type and name", ModifiersExtensions.Name ((Modifiers) yyVals[-4+yyTop]));

		var method = Method.Create (current_type, (FullNamedExpression) yyVals[-5+yyTop],
					    0, name, (ParametersCompiled) yyVals[-1+yyTop], (Attributes) yyVals[-7+yyTop]);

		current_type.AddMember (method);

		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		yyVal = method;
	  }

void case_159()
#line 1424 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.Undefined;

		MemberName name = (MemberName) yyVals[-1+yyTop];
		var method = Method.Create (current_type, (FullNamedExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-3+yyTop],
									name, current_local_parameters, (Attributes) yyVals[-4+yyTop]);

		current_type.AddMember (method);

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		yyVal = method;
	  }

void case_164()
#line 1453 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[0+yyTop];
	  	yyVal = new ParametersCompiled (pars_list.ToArray ());
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_165()
#line 1459 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[-2+yyTop];
		pars_list.Add ((Parameter) yyVals[0+yyTop]);
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		
		yyVal = new ParametersCompiled (pars_list.ToArray ()); 
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_166()
#line 1468 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[-2+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[0+yyTop])));
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		
		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_167()
#line 1477 "cs-parser.jay"
{
		if (yyVals[-2+yyTop] != null)
			report.Error (231, ((Parameter) yyVals[-2+yyTop]).Location, "A params parameter must be the last parameter in a formal parameter list");

		yyVal = new ParametersCompiled (new Parameter[] { (Parameter) yyVals[-2+yyTop] } );			
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_168()
#line 1485 "cs-parser.jay"
{
		if (yyVals[-2+yyTop] != null)
			report.Error (231, ((Parameter) yyVals[-2+yyTop]).Location, "A params parameter must be the last parameter in a formal parameter list");

		var pars_list = (List<Parameter>) yyVals[-4+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[-2+yyTop])));
		parameterListCommas.Add (GetLocation (yyVals[-3+yyTop]));
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		
		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_169()
#line 1498 "cs-parser.jay"
{
		report.Error (257, GetLocation (yyVals[-2+yyTop]), "An __arglist parameter must be the last parameter in a formal parameter list");

		yyVal = new ParametersCompiled (new Parameter [] { new ArglistParameter (GetLocation (yyVals[-2+yyTop])) }, true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_170()
#line 1505 "cs-parser.jay"
{
		report.Error (257, GetLocation (yyVals[-2+yyTop]), "An __arglist parameter must be the last parameter in a formal parameter list");

		var pars_list = (List<Parameter>) yyVals[-4+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[-2+yyTop])));
		parameterListCommas.Add (GetLocation (yyVals[-3+yyTop]));
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));

		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_173()
#line 1525 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = ParametersCompiled.EmptyReadOnlyParameters;
	  }

void case_174()
#line 1533 "cs-parser.jay"
{
		parameters_bucket.Clear ();
		Parameter p = (Parameter) yyVals[0+yyTop];
		parameters_bucket.Add (p);
		parameterListCommas.Clear ();
		default_parameter_used = p.HasDefaultValue;
		yyVal = parameters_bucket;
	  }

void case_175()
#line 1542 "cs-parser.jay"
{
		var pars = (List<Parameter>) yyVals[-2+yyTop];
		Parameter p = (Parameter) yyVals[0+yyTop];
		if (p != null) {
			if (p.HasExtensionMethodModifier)
				report.Error (1100, p.Location, "The parameter modifier `this' can only be used on the first parameter");
			else if (!p.HasDefaultValue && default_parameter_used)
				report.Error (1737, p.Location, "Optional parameter cannot precede required parameters");

			default_parameter_used |= p.HasDefaultValue;
			pars.Add (p);
			
			parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		}
		
		yyVal = yyVals[-2+yyTop];
	  }

void case_176()
#line 1566 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Parameter.Modifier) yyVals[-2+yyTop], (Attributes) yyVals[-3+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_177()
#line 1575 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		report.Error (1552, lt.Location, "Array type specifier, [], must appear before parameter name");
		yyVal = new Parameter ((FullNamedExpression) yyVals[-3+yyTop], lt.Value, (Parameter.Modifier) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_178()
#line 1582 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  	Location l = GetLocation (yyVals[0+yyTop]);
		yyVal = new Parameter (null, null, Parameter.Modifier.NONE, (Attributes) yyVals[-1+yyTop], l);
	  }

void case_179()
#line 1591 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  	Location l = GetLocation (yyVals[0+yyTop]);
		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], null, (Parameter.Modifier) yyVals[-2+yyTop], (Attributes) yyVals[-3+yyTop], l);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_181()
#line 1606 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		if (lang_version <= LanguageVersion.V_3) {
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "optional parameter");
		}
		
		Parameter.Modifier mod = (Parameter.Modifier) yyVals[-5+yyTop];
		if (mod != Parameter.Modifier.NONE) {
			switch (mod) {
			case Parameter.Modifier.REF:
			case Parameter.Modifier.OUT:
				report.Error (1741, GetLocation (yyVals[-5+yyTop]), "Cannot specify a default value for the `{0}' parameter",
					Parameter.GetModifierSignature (mod));
				break;
				
			case Parameter.Modifier.This:
				report.Error (1743, GetLocation (yyVals[-5+yyTop]), "Cannot specify a default value for the `{0}' parameter",
					Parameter.GetModifierSignature (mod));
				break;
			default:
				throw new NotImplementedException (mod.ToString ());
			}
				
			mod = Parameter.Modifier.NONE;
		}
		
		if ((valid_param_mod & ParameterModifierType.DefaultValue) == 0)
			report.Error (1065, GetLocation (yyVals[-2+yyTop]), "Optional parameter is not valid in this context");
		
		var lt = (LocatedToken) yyVals[-3+yyTop];
		yyVal = new Parameter ((FullNamedExpression) yyVals[-4+yyTop], lt.Value, mod, (Attributes) yyVals[-6+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation, GetLocation (yyVals[-2+yyTop])); /* parameterModifierLocation should be ignored when mod == NONE*/
		
		if (yyVals[0+yyTop] != null)
			((Parameter) yyVal).DefaultValue = new DefaultParameterValueExpression ((Expression) yyVals[0+yyTop]);
	  }

void case_185()
#line 1655 "cs-parser.jay"
{
		Parameter.Modifier p2 = (Parameter.Modifier)yyVals[0+yyTop];
  		Parameter.Modifier mod = (Parameter.Modifier)yyVals[-1+yyTop] | p2;
  		if (((Parameter.Modifier)yyVals[-1+yyTop] & p2) == p2) {
  			Error_DuplicateParameterModifier (lexer.Location, p2);
  		} else {
	  		switch (mod & ~Parameter.Modifier.This) {
  				case Parameter.Modifier.REF:
					report.Error (1101, lexer.Location, "The parameter modifiers `this' and `ref' cannot be used altogether");
  					break;
   				case Parameter.Modifier.OUT:
					report.Error (1102, lexer.Location, "The parameter modifiers `this' and `out' cannot be used altogether");
  					break;
  				default:
 					report.Error (1108, lexer.Location, "A parameter cannot have specified more than one modifier");
 					break;
 			}
  		}
  		yyVal = mod;
	  }

void case_186()
#line 1679 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Ref) == 0)
	  		Error_ParameterModifierNotValid ("ref", GetLocation (yyVals[0+yyTop]));
		parameterModifierLocation = GetLocation (yyVals[0+yyTop]);
	  	yyVal = Parameter.Modifier.REF;
	  }

void case_187()
#line 1686 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Out) == 0)
	  		Error_ParameterModifierNotValid ("out", GetLocation (yyVals[0+yyTop]));
		parameterModifierLocation = GetLocation (yyVals[0+yyTop]);
	  	yyVal = Parameter.Modifier.OUT;
	  }

void case_188()
#line 1693 "cs-parser.jay"
{
		if ((valid_param_mod & ParameterModifierType.This) == 0)
	  		Error_ParameterModifierNotValid ("this", GetLocation (yyVals[0+yyTop]));

	  	if (lang_version <= LanguageVersion.ISO_2)
	  		FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "extension methods");
		parameterModifierLocation = GetLocation (yyVals[0+yyTop]);
		yyVal = Parameter.Modifier.This;
	  }

void case_189()
#line 1706 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		yyVal = new ParamsParameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Attributes) yyVals[-3+yyTop], lt.Location);
		lbag.AddLocation (yyVal, savedLocation);
	  }

void case_190()
#line 1712 "cs-parser.jay"
{
		report.Error (1751, GetLocation (yyVals[-4+yyTop]), "Cannot specify a default value for a parameter array");
		
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new ParamsParameter ((FullNamedExpression) yyVals[-3+yyTop], lt.Value, (Attributes) yyVals[-5+yyTop], lt.Location);		
		lbag.AddLocation (yyVal, savedLocation);
	  }

void case_191()
#line 1720 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new ParamsParameter ((FullNamedExpression) yyVals[-1+yyTop], null, (Attributes) yyVals[-3+yyTop], Location.Null);
	  }

void case_192()
#line 1729 "cs-parser.jay"
{
		if ((valid_param_mod & ParameterModifierType.Params) == 0)
			report.Error (1670, (GetLocation (yyVals[0+yyTop])), "The `params' modifier is not allowed in current context");
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_193()
#line 1735 "cs-parser.jay"
{
		Parameter.Modifier mod = (Parameter.Modifier)yyVals[0+yyTop];
		if ((mod & Parameter.Modifier.This) != 0) {
			report.Error (1104, GetLocation (yyVals[-1+yyTop]), "The parameter modifiers `this' and `params' cannot be used altogether");
		} else {
			report.Error (1611, GetLocation (yyVals[-1+yyTop]), "The params parameter cannot be declared as ref or out");
		}	  
		savedLocation = GetLocation (yyVals[-1+yyTop]);
	  }

void case_195()
#line 1752 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Arglist) == 0)
	  		report.Error (1669, GetLocation (yyVals[0+yyTop]), "__arglist is not valid in this context");
	  }

void case_196()
#line 1763 "cs-parser.jay"
{
		if (doc_support)
			tmpComment = Lexer.consume_doc_comment ();
	  }

void case_197()
#line 1768 "cs-parser.jay"
{
		var type = (FullNamedExpression) yyVals[-3+yyTop];
		current_property = new Property (current_type, type, (Modifiers) yyVals[-4+yyTop],
			(MemberName) yyVals[-2+yyTop], (Attributes) yyVals[-5+yyTop]);
			
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (547, GetLocation (yyVals[-3+yyTop]), "`{0}': property or indexer cannot have void type", current_property.GetSignatureForError ());					
			
		current_type.AddMember (current_property);
		lbag.AddMember (current_property, GetModifierLocations (), GetLocation (yyVals[0+yyTop]));
		
		lexer.PropertyParsing = true;
	  }

void case_198()
#line 1782 "cs-parser.jay"
{
		lexer.PropertyParsing = false;
		
		if (doc_support)
			current_property.DocComment = ConsumeStoredComment ();				
	  }

void case_199()
#line 1789 "cs-parser.jay"
{
		lbag.AppendToMember (current_property, GetLocation (yyVals[0+yyTop]));
		current_property = null;
	  }

void case_201()
#line 1803 "cs-parser.jay"
{
		valid_param_mod = 0;
		var type = (FullNamedExpression) yyVals[-5+yyTop];
		Indexer indexer = new Indexer (current_type, type, (MemberName) yyVals[-4+yyTop], (Modifiers) yyVals[-6+yyTop], (ParametersCompiled) yyVals[-1+yyTop], (Attributes) yyVals[-7+yyTop]);
			
		current_property = indexer;

  		current_type.AddIndexer (indexer);
		lbag.AddMember (current_property, GetModifierLocations (), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
  		
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (620, GetLocation (yyVals[-5+yyTop]), "`{0}': indexer return type cannot be `void'", indexer.GetSignatureForError ());  		

		if (indexer.ParameterInfo.IsEmpty) {
			report.Error (1551, GetLocation (yyVals[-3+yyTop]), "Indexers must have at least one parameter");
		}

		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		lexer.PropertyParsing = true;
	  }

void case_203()
#line 1832 "cs-parser.jay"
{
		if (current_property.AccessorFirst != null && current_property.AccessorFirst.Block == null)
			((Indexer) current_property).ParameterInfo.CheckParameters (current_property);
	  
		if (doc_support)
			current_property.DocComment = ConsumeStoredComment ();
			
		lbag.AppendToMember (current_property, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		current_property = null;		
	  }

void case_208()
#line 1851 "cs-parser.jay"
{
	  	if (yyToken == Token.CLOSE_BRACE) {
	  		report.Error (548, lexer.Location, "`{0}': property or indexer must have at least one accessor", current_property.GetSignatureForError ());
		} else {
			if (yyToken == Token.SEMICOLON)
				report.Error (1597, lexer.Location, "Semicolon after method or accessor block is not valid");
			else
				report.Error (1014, GetLocation (yyVals[0+yyTop]), "A get or set accessor expected");
		}
	  }

void case_209()
#line 1865 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != ModifierNone && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "access modifiers on properties");
		}
	  
		if (current_property.Get != null) {
			report.Error (1007, GetLocation (yyVals[0+yyTop]), "Property accessor already defined");
		}
		
		if (current_property is Indexer) {
			current_property.Get = new Indexer.GetIndexerMethod (current_property, (Modifiers) yyVals[-1+yyTop], ((Indexer)current_property).ParameterInfo.Clone (),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		} else {
			current_property.Get = new Property.GetMethod (current_property,
				(Modifiers) yyVals[-1+yyTop], (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		}	
	  
		current_local_parameters = current_property.Get.ParameterInfo;	  
		lexer.PropertyParsing = false;
	  }

void case_210()
#line 1886 "cs-parser.jay"
{
	  	if (yyVals[0+yyTop] != null) {
	  		current_property.Get.Block = (ToplevelBlock) yyVals[0+yyTop];			
	  	
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, current_property.Get.Block.StartLocation,
					"`{0}': interface members cannot have a definition", current_property.Get.GetSignatureForError ());
			}
			lbag.AddMember (current_property.Get, GetModifierLocations ());
		} else {
			lbag.AddMember (current_property.Get, GetModifierLocations (), savedLocation);
		}
	  
		current_local_parameters = null;
		lexer.PropertyParsing = true;

		if (doc_support)
			if (Lexer.doc_state == XmlCommentState.Error)
				Lexer.doc_state = XmlCommentState.NotAllowed;
	  }

void case_211()
#line 1910 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != ModifierNone && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "access modifiers on properties");
		}
		
		if (current_property.Set != null) {
			report.Error (1007, GetLocation (yyVals[0+yyTop]), "Property accessor already defined");
		}
	  
		if (current_property is Indexer) {
			current_property.Set = new Indexer.SetIndexerMethod (current_property, (Modifiers) yyVals[-1+yyTop],
				ParametersCompiled.MergeGenerated (compiler,
				((Indexer)current_property).ParameterInfo, true, new Parameter (
					current_property.TypeExpression, "value", Parameter.Modifier.NONE, null, GetLocation (yyVals[0+yyTop])),
					null),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		} else {
			current_property.Set = new Property.SetMethod (current_property, (Modifiers) yyVals[-1+yyTop], 
				ParametersCompiled.CreateImplicitParameter (current_property.TypeExpression, GetLocation (yyVals[0+yyTop])),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		}
		
		current_local_parameters = current_property.Set.ParameterInfo;	
		lexer.PropertyParsing = false;
	  }

void case_212()
#line 1936 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {		
			current_property.Set.Block = (ToplevelBlock) yyVals[0+yyTop];
		
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, current_property.Set.Block.StartLocation,
					"`{0}': interface members cannot have a definition", current_property.Set.GetSignatureForError ());
			}
			lbag.AddMember (current_property.Set, GetModifierLocations ());
		} else {
			lbag.AddMember (current_property.Set, GetModifierLocations (), savedLocation);
		}
		
		current_local_parameters = null;
		lexer.PropertyParsing = true;

		if (doc_support
			&& Lexer.doc_state == XmlCommentState.Error)
			Lexer.doc_state = XmlCommentState.NotAllowed;
	  }

void case_214()
#line 1961 "cs-parser.jay"
{
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  	yyVal = null;
	  }

void case_215()
#line 1966 "cs-parser.jay"
{
	  	Error_SyntaxError (1043, yyToken, "Invalid accessor body");
	  	yyVal = null;
	  }

void case_217()
#line 1980 "cs-parser.jay"
{
		lexer.ConstraintsParsing = true;
		push_current_container (new Interface (current_container, (MemberName) yyVals[0+yyTop], (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]), yyVals[-3+yyTop]);
		lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]));		
	  }

void case_218()
#line 1987 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		if (yyVals[0+yyTop] != null)
			current_container.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support) {
			current_container.PartialContainer.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lexer.parsing_modifiers = true;
	  }

void case_219()
#line 2001 "cs-parser.jay"
{
		--lexer.parsing_declaration;	  
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_220()
#line 2007 "cs-parser.jay"
{
		if (yyVals[0+yyTop] == null) {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		} else {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = pop_current_class ();
	  }

void case_236()
#line 2069 "cs-parser.jay"
{
		OperatorDeclaration decl = (OperatorDeclaration) yyVals[-2+yyTop];
		if (decl != null) {
			Operator op = new Operator (
				current_type, decl.optype, decl.ret_type, (Modifiers) yyVals[-3+yyTop], 
				current_local_parameters,
				(ToplevelBlock) yyVals[0+yyTop], (Attributes) yyVals[-4+yyTop], decl.location);
				
			if (op.Block == null)
				op.ParameterInfo.CheckParameters (op);

			if (doc_support) {
				op.DocComment = tmpComment;
				Lexer.doc_state = XmlCommentState.Allowed;
			}

			/* Note again, checking is done in semantic analysis*/
			current_type.AddOperator (op);

			lbag.AddMember (op, GetModifierLocations (), lbag.GetLocations (decl));
			if (yyVals[0+yyTop] == null) { /* Semicolon*/
				lbag.AddLocation (op, savedLocation); 
			}
		}
		
		current_local_parameters = null;
	  }

void case_240()
#line 2106 "cs-parser.jay"
{
		report.Error (590, GetLocation (yyVals[0+yyTop]), "User-defined operators cannot return void");
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_242()
#line 2118 "cs-parser.jay"
{
		valid_param_mod = 0;

		Location loc = GetLocation (yyVals[-5+yyTop]);
		Operator.OpType op = (Operator.OpType) yyVals[-4+yyTop];
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];
		
		int p_count = current_local_parameters.Count;
		if (p_count == 1) {
			if (op == Operator.OpType.Addition)
				op = Operator.OpType.UnaryPlus;
			else if (op == Operator.OpType.Subtraction)
				op = Operator.OpType.UnaryNegation;
		}
		
		if (IsUnaryOperator (op)) {
			if (p_count == 2) {
				report.Error (1020, loc, "Overloadable binary operator expected");
			} else if (p_count != 1) {
				report.Error (1535, loc, "Overloaded unary operator `{0}' takes one parameter",
					Operator.GetName (op));
			}
		} else {
			if (p_count == 1) {
				report.Error (1019, loc, "Overloadable unary operator expected");
			} else if (p_count != 2) {
				report.Error (1534, loc, "Overloaded binary operator `{0}' takes two parameters",
					Operator.GetName (op));
			}
		}
		
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (op, (FullNamedExpression) yyVals[-6+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), savedOperatorLocation, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_267()
#line 2194 "cs-parser.jay"
{
		valid_param_mod = 0;

		Location loc = GetLocation (yyVals[-5+yyTop]);
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];  

		if (current_local_parameters.Count != 1) {
			report.Error (1535, loc, "Overloaded unary operator `implicit' takes one parameter");
		}

		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (Operator.OpType.Implicit, (FullNamedExpression) yyVals[-4+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_269()
#line 2217 "cs-parser.jay"
{
		valid_param_mod = 0;
		
		Location loc = GetLocation (yyVals[-5+yyTop]);
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];  

		if (current_local_parameters.Count != 1) {
			report.Error (1535, loc, "Overloaded unary operator `explicit' takes one parameter");
		}

		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (Operator.OpType.Explicit, (FullNamedExpression) yyVals[-4+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_270()
#line 2236 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
		yyVal = new OperatorDeclaration (Operator.OpType.Implicit, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_271()
#line 2242 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  	yyVal = new OperatorDeclaration (Operator.OpType.Explicit, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_272()
#line 2252 "cs-parser.jay"
{ 
		Constructor c = (Constructor) yyVals[-1+yyTop];
		c.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (doc_support)
			c.DocComment = ConsumeStoredComment ();

		current_local_parameters = null;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_273()
#line 2269 "cs-parser.jay"
{
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		valid_param_mod = ParameterModifierType.All;
	  }

void case_274()
#line 2278 "cs-parser.jay"
{
		valid_param_mod = 0;
		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];
		
		var lt = (LocatedToken) yyVals[-4+yyTop];
		var mods = (Modifiers) yyVals[-5+yyTop];
		var c = new Constructor (current_type, lt.Value, mods, (Attributes) yyVals[-6+yyTop], current_local_parameters, lt.Location);

		if (lt.Value != current_container.MemberName.Name) {
			report.Error (1520, c.Location, "Class, struct, or interface method must have a return type");
		} else if ((mods & Modifiers.STATIC) != 0) {
			if ((mods & Modifiers.AccessibilityMask) != 0){
				report.Error (515, c.Location,
					"`{0}': static constructor cannot have an access modifier",
					c.GetSignatureForError ());
			}
		}

		current_type.AddConstructor (c);
		lbag.AddMember (c, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = c;

		/**/
		/* start block here, so possible anonymous methods inside*/
		/* constructor initializer can get correct parent block*/
		/**/
	  	start_block (lexer.Location);
	  }

void case_275()
#line 2307 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			var c = (Constructor) yyVals[-1+yyTop];
			c.Initializer = (ConstructorInitializer) yyVals[0+yyTop];
			
			if (c.IsStatic) {
				report.Error (514, c.Location,
					"`{0}': static constructor cannot have an explicit `this' or `base' constructor call",
					c.GetSignatureForError ());
			}
		}

		yyVal = yyVals[-1+yyTop];
	  }

void case_281()
#line 2339 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		yyVal = new ConstructorBaseInitializer ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_283()
#line 2349 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		yyVal = new ConstructorThisInitializer ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_284()
#line 2355 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);	  
		yyVal = new ConstructorThisInitializer (null, GetLocation (yyVals[0+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_285()
#line 2361 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_286()
#line 2369 "cs-parser.jay"
{
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}
		
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  }

void case_287()
#line 2378 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-3+yyTop];
		if (lt.Value != current_container.MemberName.Name){
			report.Error (574, lt.Location, "Name of destructor must match name of class");
		} else if (current_container.Kind != MemberKind.Class){
			report.Error (575, lt.Location, "Only class types can contain destructor");
		}
		
		Destructor d = new Destructor (current_type, (Modifiers) yyVals[-6+yyTop],
			ParametersCompiled.EmptyReadOnlyParameters, (Attributes) yyVals[-7+yyTop], lt.Location);
		d.Identifier = lt.Value;
		if (doc_support)
			d.DocComment = ConsumeStoredComment ();
		  
		d.Block = (ToplevelBlock) yyVals[0+yyTop];
		current_type.AddMember (d);
		lbag.AddMember (d, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[-1+yyTop]));

		current_local_parameters = null;
	  }

void case_288()
#line 2404 "cs-parser.jay"
{
		current_event_field = new EventField (current_type, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop], (MemberName) yyVals[0+yyTop], (Attributes) yyVals[-4+yyTop]);
		current_type.AddMember (current_event_field);
		
		if (current_event_field.MemberName.ExplicitInterface != null) {
			report.Error (71, current_event_field.Location, "`{0}': An explicit interface implementation of an event must use property syntax",
			current_event_field.GetSignatureForError ());
		}
		
		yyVal = current_event_field;
	  }

void case_289()
#line 2418 "cs-parser.jay"
{
		if (doc_support) {
			current_event_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		if (current_event_field.Initializer != null) {
			lbag.AddMember (current_event_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), savedEventAssignLocation, GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddMember (current_event_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		current_event_field = null;
	  }

void case_290()
#line 2434 "cs-parser.jay"
{
		current_event = new EventProperty (current_type, (FullNamedExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-4+yyTop], (MemberName) yyVals[-1+yyTop], (Attributes) yyVals[-5+yyTop]);
		current_type.AddMember (current_event);
		lbag.AddMember (current_event, GetModifierLocations (), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		
		lexer.EventParsing = true;
	  }

void case_291()
#line 2442 "cs-parser.jay"
{
		if (current_container.Kind == MemberKind.Interface)
			report.Error (69, GetLocation (yyVals[-2+yyTop]), "Event in interface cannot have add or remove accessors");
	  
		lexer.EventParsing = false;
	  }

void case_292()
#line 2449 "cs-parser.jay"
{
		if (doc_support) {
			current_event.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lbag.AppendToMember (current_event, GetLocation (yyVals[-1+yyTop]));
	  	current_event = null;	
		current_local_parameters = null;
	  }

void case_293()
#line 2462 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		current_type.AddMember (new EventField (current_type, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop], MemberName.Null, (Attributes) yyVals[-4+yyTop]));
	  }

void case_296()
#line 2476 "cs-parser.jay"
{
	  	--lexer.parsing_block;
	  	savedEventAssignLocation = GetLocation (yyVals[-2+yyTop]);
		current_event_field.Initializer = (Expression) yyVals[0+yyTop];
	  }

void case_301()
#line 2501 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), null);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_303()
#line 2511 "cs-parser.jay"
{
		--lexer.parsing_block;
		var lt = (LocatedToken) yyVals[-3+yyTop];	  
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_304()
#line 2520 "cs-parser.jay"
{
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (68, lexer.Location, "`{0}': event in interface cannot have an initializer",
				current_event_field.GetSignatureForError ());
		}
		
	  	if ((current_event_field.ModFlags & Modifiers.ABSTRACT) != 0) {
			report.Error (74, lexer.Location, "`{0}': abstract event cannot have an initializer",
				current_event_field.GetSignatureForError ());
	  	}		
	  }

void case_308()
#line 2541 "cs-parser.jay"
{
		report.Error (65, lexer.Location, "`{0}': event property must have both add and remove accessors",
			current_event.GetSignatureForError ());
	  }

void case_309()
#line 2546 "cs-parser.jay"
{
		report.Error (65, lexer.Location, "`{0}': event property must have both add and remove accessors",
			current_event.GetSignatureForError ());
	  }

void case_310()
#line 2551 "cs-parser.jay"
{ 
		report.Error (1055, GetLocation (yyVals[0+yyTop]), "An add or remove accessor expected");
		yyVal = null;
	  }

void case_311()
#line 2559 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] != ModifierNone) {
			report.Error (1609, GetLocation (yyVals[-1+yyTop]), "Modifiers cannot be placed on event accessor declarations");
	  	}
	  	
	  	current_event.Add = new EventProperty.AddDelegateMethod (current_event, (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		current_local_parameters = current_event.Add.ParameterInfo;
		
		lbag.AddMember (current_event.Add, GetModifierLocations ());
		lexer.EventParsing = false;		
	  }

void case_312()
#line 2571 "cs-parser.jay"
{
		lexer.EventParsing = true;
	  
	  	current_event.Add.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (531, current_event.Add.Block.StartLocation,
				"`{0}': interface members cannot have a definition", current_event.Add.GetSignatureForError ());
		}
		
		current_local_parameters = null;
	  }

void case_313()
#line 2587 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] != ModifierNone) {
			report.Error (1609, GetLocation (yyVals[-1+yyTop]), "Modifiers cannot be placed on event accessor declarations");
	  	}
	  	
	  	current_event.Remove = new EventProperty.RemoveDelegateMethod (current_event, (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		current_local_parameters = current_event.Remove.ParameterInfo;

		lbag.AddMember (current_event.Remove, GetModifierLocations ());
		lexer.EventParsing = false;		
	  }

void case_314()
#line 2599 "cs-parser.jay"
{
		lexer.EventParsing = true;
	  
	  	current_event.Remove.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (531, current_event.Remove.Block.StartLocation,
				"`{0}': interface members cannot have a definition", current_event.Remove.GetSignatureForError ());
		}
		
		current_local_parameters = null;
	  }

void case_315()
#line 2615 "cs-parser.jay"
{
		report.Error (73, lexer.Location, "An add or remove accessor must have a body");
		yyVal = null;
	  }

void case_317()
#line 2624 "cs-parser.jay"
{
		current_type.UnattachedAttributes = (Attributes) yyVals[-1+yyTop];
		report.Error (1519, GetLocation (yyVals[-1+yyTop]), "An attribute is missing member declaration");
		lexer.putback ('}');
	  }

void case_318()
#line 2635 "cs-parser.jay"
{
		report.Error (1519, lexer.Location, "Unexpected symbol `}' in class, struct, or interface member declaration");
 
		lexer.putback ('}');

	  	lexer.parsing_generic_declaration = false;
		FullNamedExpression type = (FullNamedExpression) yyVals[-1+yyTop];
		current_field = new Field (current_type, type, (Modifiers) yyVals[-2+yyTop], MemberName.Null, (Attributes) yyVals[-3+yyTop]);
		current_type.AddField (current_field);
		lbag.AddMember (current_field, GetModifierLocations ());
		yyVal = current_field;
	  }

void case_319()
#line 2655 "cs-parser.jay"
{
		if (doc_support)
			enumTypeComment = Lexer.consume_doc_comment ();
	  }

void case_320()
#line 2660 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;

		MemberName name = (MemberName) yyVals[-3+yyTop];
		if (name.IsGeneric) {
			report.Error (1675, name.Location, "Enums cannot have type parameters");
		}
		
		push_current_container (new Enum (current_container, (FullNamedExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-5+yyTop], name, (Attributes) yyVals[-6+yyTop]), null);
		if (yyVals[-2+yyTop] != null) {
			lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-4+yyTop]), savedLocation, GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_321()
#line 2677 "cs-parser.jay"
{
	  	/* here will be evaluated after CLOSE_BLACE is consumed.*/
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_322()
#line 2683 "cs-parser.jay"
{
		lbag.AppendToMember (current_container, GetLocation (yyVals[-1+yyTop]));
		if (yyVals[0+yyTop] != null) {
			lbag.AppendToMember (current_container, GetLocation (yyVals[0+yyTop]));
		}
		if (doc_support)
			current_container.DocComment = enumTypeComment;
			
		--lexer.parsing_declaration;

/*			if (doc_support)*/
/*				em.DocComment = ev.DocComment;*/

		yyVal = pop_current_class ();
	  }

void case_324()
#line 2703 "cs-parser.jay"
{
		savedLocation = GetLocation (yyVals[-1+yyTop]);
		yyVal = yyVals[0+yyTop];
	 }

void case_325()
#line 2708 "cs-parser.jay"
{
	 	Error_TypeExpected (GetLocation (yyVals[-1+yyTop]));
		yyVal = null;
	 }

void case_330()
#line 2726 "cs-parser.jay"
{
		lbag.AppendToMember (current_container, GetLocation (yyVals[-1+yyTop]));
	  	yyVal = yyVals[0+yyTop];
	  }

void case_331()
#line 2734 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
	  	var em = new EnumMember ((Enum) current_type, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-1+yyTop]);
	  	((Enum) current_type).AddEnumMember (em);

		if (doc_support) {
			em.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		yyVal = em;
	  }

void case_332()
#line 2747 "cs-parser.jay"
{
	  	++lexer.parsing_block;
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}
	  }

void case_333()
#line 2755 "cs-parser.jay"
{ 
		--lexer.parsing_block;
		
		var lt = (LocatedToken) yyVals[-3+yyTop];
	  	var em = new EnumMember ((Enum) current_type, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
	  	em.Initializer = new ConstInitializer (em, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  	((Enum) current_type).AddEnumMember (em);
		
		if (doc_support)
			em.DocComment = ConsumeStoredComment ();

		yyVal = em;
	  }

void case_334()
#line 2769 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  
		var lt = (LocatedToken) yyVals[-1+yyTop];
	  	var em = new EnumMember ((Enum) current_type, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-2+yyTop]);
	  	((Enum) current_type).AddEnumMember (em);

		if (doc_support) {
			em.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		yyVal = em;
	  }

void case_337()
#line 2796 "cs-parser.jay"
{
		valid_param_mod = 0;

		ParametersCompiled p = (ParametersCompiled) yyVals[-1+yyTop];

		Delegate del = new Delegate (current_container, (FullNamedExpression) yyVals[-5+yyTop], (Modifiers) yyVals[-7+yyTop], (MemberName) yyVals[-4+yyTop], p, (Attributes) yyVals[-8+yyTop]);

		p.CheckParameters (del);

		current_container.AddTypeContainer (del);

		current_delegate = del;
		lexer.ConstraintsParsing = true;
	  }

void case_339()
#line 2815 "cs-parser.jay"
{
		if (doc_support) {
			current_delegate.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
	  
		if (yyVals[-2+yyTop] != null)
			current_delegate.SetConstraints ((List<Constraints>) yyVals[-2+yyTop]);
		lbag.AddMember (current_delegate, GetModifierLocations (), GetLocation (yyVals[-10+yyTop]), GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[0+yyTop]));

		yyVal = current_delegate;

		current_delegate = null;
	  }

void case_341()
#line 2834 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "nullable types");
	  
	  	yyVal = ComposedTypeSpecifier.CreateNullable (GetLocation (yyVals[0+yyTop]));
	  }

void case_343()
#line 2845 "cs-parser.jay"
{
		var lt1 = (LocatedToken) yyVals[-2+yyTop];
		var lt2 = (LocatedToken) yyVals[-1+yyTop];
		
		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (TypeArguments) yyVals[0+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, savedLocation, GetLocation (yyVals[-1+yyTop]));
	  }

void case_345()
#line 2857 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_346()
#line 2866 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new SimpleName (lt.Value, (TypeArguments)yyVals[0+yyTop], lt.Location);
	  }

void case_348()
#line 2878 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "generics");
		var list = locationListStack.Pop ();
		list.Add (GetLocation (yyVals[-2+yyTop]));
		list.Add (GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVals[-1+yyTop], list);
	
		yyVal = yyVals[-1+yyTop];;
	  }

void case_349()
#line 2889 "cs-parser.jay"
{
		Error_TypeExpected (lexer.Location);
		yyVal = new TypeArguments ();
	  }

void case_350()
#line 2897 "cs-parser.jay"
{
		TypeArguments type_args = new TypeArguments ();
		type_args.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = type_args;
		locationListStack.Push (new List<Location> ());
	  }

void case_351()
#line 2904 "cs-parser.jay"
{
		TypeArguments type_args = (TypeArguments) yyVals[-2+yyTop];
		type_args.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = type_args;
		locationListStack.Peek ().Add (GetLocation (yyVals[-1+yyTop]));
	  }

void case_353()
#line 2921 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new MemberName (lt.Value, (TypeParameters)yyVals[0+yyTop], lt.Location);
	  }

void case_354()
#line 2930 "cs-parser.jay"
{
	  	MemberName mn = (MemberName)yyVals[0+yyTop];
	  	if (mn.TypeParameters != null)
	  		syntax_error (mn.Location, string.Format ("Member `{0}' cannot declare type arguments",
	  			mn.GetSignatureForError ()));
	  }

void case_356()
#line 2941 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;	  
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName (lt.Value, (TypeParameters) yyVals[0+yyTop], (ATypeNameExpression) yyVals[-2+yyTop], lt.Location);
	  }

void case_357()
#line 2950 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;	  
		yyVal = new MemberName (TypeDefinition.DefaultIndexerName, GetLocation (yyVals[0+yyTop]));
	  }

void case_358()
#line 2955 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		yyVal = new MemberName (TypeDefinition.DefaultIndexerName, null, (ATypeNameExpression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }

void case_359()
#line 2963 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new SimpleName (lt.Value, (TypeArguments) yyVals[-1+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_360()
#line 2969 "cs-parser.jay"
{
		var lt1 = (LocatedToken) yyVals[-3+yyTop];
		var lt2 = (LocatedToken) yyVals[-2+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (TypeArguments) yyVals[-1+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, savedLocation, GetLocation (yyVals[0+yyTop]));
	  }

void case_361()
#line 2977 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new MemberAccess ((ATypeNameExpression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[-1+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_363()
#line 2987 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "generics");
	  
		yyVal = yyVals[-1+yyTop];
		var list = locationListStack.Pop ();
		list.Add (GetLocation (yyVals[-2+yyTop]));
		list.Add (GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVals[-1+yyTop], list);
	  }

void case_364()
#line 3001 "cs-parser.jay"
{
		var tparams = new TypeParameters ();
		tparams.Add ((TypeParameter)yyVals[0+yyTop]);
		yyVal = tparams;
		locationListStack.Push (new List<Location> ());
	  }

void case_365()
#line 3008 "cs-parser.jay"
{
		var tparams = (TypeParameters) yyVals[-2+yyTop];
		tparams.Add ((TypeParameter)yyVals[0+yyTop]);
		yyVal = tparams;
		locationListStack.Peek ().Add (GetLocation (yyVals[-1+yyTop]));
	  }

void case_366()
#line 3018 "cs-parser.jay"
{
		var lt = (LocatedToken)yyVals[0+yyTop];
		var variance = (Variance) yyVals[-1+yyTop];
		yyVal = new TypeParameter (new MemberName (lt.Value, lt.Location), (Attributes)yyVals[-2+yyTop], variance);
		if (variance != Variance.None)
			lbag.AddLocation (yyVal, savedLocation);
  	  }

void case_367()
#line 3026 "cs-parser.jay"
{
  	  	if (GetTokenName (yyToken) == "type")
			report.Error (81, GetLocation (yyVals[0+yyTop]), "Type parameter declaration must be an identifier not a type");
		else
			Error_SyntaxError (yyToken);
			
  	  	yyVal = new TypeParameter (MemberName.Null, null, Variance.None);
  	  }

void case_372()
#line 3060 "cs-parser.jay"
{
	  	Expression.Error_VoidInvalidInTheContext (GetLocation (yyVals[0+yyTop]), report);
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_374()
#line 3069 "cs-parser.jay"
{
	  	Expression.Error_VoidInvalidInTheContext (GetLocation (yyVals[0+yyTop]), report);
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_376()
#line 3078 "cs-parser.jay"
{
	  	report.Error (1536, GetLocation (yyVals[0+yyTop]), "Invalid parameter type `void'");
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_379()
#line 3094 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			yyVal = new ComposedCast ((ATypeNameExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			var sn = yyVals[-1+yyTop] as SimpleName;
			if (sn != null && sn.Name == "var")
				yyVal = new VarExpr (sn.Location);
			else
				yyVal = yyVals[-1+yyTop];
		}
	  }

void case_381()
#line 3110 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null)
			yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_384()
#line 3126 "cs-parser.jay"
{
		var types = new List<FullNamedExpression> (2);
		types.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = types;
	  }

void case_385()
#line 3132 "cs-parser.jay"
{
		var types = (List<FullNamedExpression>) yyVals[-2+yyTop];
		types.Add ((FullNamedExpression) yyVals[0+yyTop]);
		lbag.AddLocation (types, GetLocation (yyVals[-1+yyTop]));
		yyVal = types;
	  }

void case_386()
#line 3142 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is ComposedCast) {
			report.Error (1521, GetLocation (yyVals[0+yyTop]), "Invalid base type `{0}'", ((ComposedCast)yyVals[0+yyTop]).GetSignatureForError ());
		}
		yyVal = yyVals[0+yyTop];
	  }

void case_423()
#line 3206 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new SimpleName (lt.Value, (TypeArguments)yyVals[0+yyTop], lt.Location);	  
	  }

void case_424()
#line 3210 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
	       yyVal = new CompletionSimpleName (MemberName.MakeName (lt.Value, null), lt.Location);
	  }

void case_435()
#line 3251 "cs-parser.jay"
{
		yyVal = new ParenthesizedExpression ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_437()
#line 3263 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_438()
#line 3269 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_439()
#line 3275 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (new BaseThis (GetLocation (yyVals[-3+yyTop])), lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_440()
#line 3281 "cs-parser.jay"
{
		var lt1 = (LocatedToken) yyVals[-2+yyTop];
		var lt2 = (LocatedToken) yyVals[-1+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (TypeArguments) yyVals[0+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, savedLocation, GetLocation (yyVals[-1+yyTop]));
	  }

void case_442()
#line 3291 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, lt.Location);
	  }

void case_444()
#line 3299 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, lt.Location);
 	  }

void case_445()
#line 3307 "cs-parser.jay"
{
		yyVal = new Invocation ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_446()
#line 3312 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Invocation ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_447()
#line 3319 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Invocation ((Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_450()
#line 3334 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] == null) {
	  		yyVal = new CollectionOrObjectInitializers (GetLocation (yyVals[-2+yyTop]));
	  	} else {
	  		yyVal = new CollectionOrObjectInitializers ((List<Expression>) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  	}
 		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_451()
#line 3343 "cs-parser.jay"
{
	  	yyVal = new CollectionOrObjectInitializers ((List<Expression>) yyVals[-2+yyTop], GetLocation (yyVals[-3+yyTop]));
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_454()
#line 3359 "cs-parser.jay"
{
	  	var a = new List<Expression> ();
	  	a.Add ((Expression) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_455()
#line 3365 "cs-parser.jay"
{
	  	var a = (List<Expression>)yyVals[-2+yyTop];
	  	a.Add ((Expression) yyVals[0+yyTop]);
		lbag.AddLocation (a, GetLocation (yyVals[-1+yyTop]));
	  	yyVal = a;
	  }

void case_456()
#line 3371 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = yyVals[-1+yyTop];
	  }

void case_457()
#line 3379 "cs-parser.jay"
{
	  	var lt = (LocatedToken) yyVals[-2+yyTop];
	  	yyVal = new ElementInitializer (lt.Value, (Expression)yyVals[0+yyTop], lt.Location);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_458()
#line 3385 "cs-parser.jay"
{
	  	var lt = (LocatedToken) Error_AwaitAsIdentifier (yyVals[-2+yyTop]);
	  	yyVal = new ElementInitializer (lt.Value, (Expression)yyVals[0+yyTop], lt.Location);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_460()
#line 3394 "cs-parser.jay"
{
		CompletionSimpleName csn = yyVals[-1+yyTop] as CompletionSimpleName;
		if (csn == null)
			yyVal = new CollectionElementInitializer ((Expression)yyVals[-1+yyTop]);
		else
			yyVal = new CompletionElementInitializer (csn.Prefix, csn.Location);
	  }

void case_461()
#line 3402 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] == null)
			yyVal = null;
		else {
	  		yyVal = new CollectionElementInitializer ((List<Expression>)yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
			lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  	}
	  }

void case_462()
#line 3411 "cs-parser.jay"
{
	  	report.Error (1920, GetLocation (yyVals[-1+yyTop]), "An element initializer cannot be empty");
		yyVal = new CollectionElementInitializer (new List<Expression> (), GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_467()
#line 3430 "cs-parser.jay"
{ 
		Arguments list = new Arguments (4);
		list.Add ((Argument) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_468()
#line 3436 "cs-parser.jay"
{
		Arguments list = (Arguments) yyVals[-2+yyTop];
		if (list [list.Count - 1] is NamedArgument)
			Error_NamedArgumentExpected ((NamedArgument) list [list.Count - 1]);
		
		list.Add ((Argument) yyVals[0+yyTop]);
		lbag.AddLocation (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_469()
#line 3446 "cs-parser.jay"
{
		Arguments list = (Arguments) yyVals[-2+yyTop];
		NamedArgument a = (NamedArgument) yyVals[0+yyTop];
		for (int i = 0; i < list.Count; ++i) {
			NamedArgument na = list [i] as NamedArgument;
			if (na != null && na.Name == a.Name)
				report.Error (1740, na.Location, "Named argument `{0}' specified multiple times",
					na.Name);
		}
		
		list.Add (a);
		lbag.AddLocation (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_470()
#line 3461 "cs-parser.jay"
{
	  	if (lexer.putback_char == -1)
	  		lexer.putback (')'); /* TODO: Wrong but what can I do*/
		Error_SyntaxError (yyToken);
		yyVal = yyVals[-2+yyTop];
	  }

void case_471()
#line 3468 "cs-parser.jay"
{
	  	report.Error (839, GetLocation (yyVals[-1+yyTop]), "An argument is missing");
	  	yyVal = null;
	  }

void case_476()
#line 3489 "cs-parser.jay"
{ 
		yyVal = new Argument ((Expression) yyVals[0+yyTop], Argument.AType.Ref);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_477()
#line 3494 "cs-parser.jay"
{ 
		yyVal = new Argument ((Expression) yyVals[0+yyTop], Argument.AType.Out);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_478()
#line 3499 "cs-parser.jay"
{
		yyVal = new Argument (new Arglist ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop])));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_479()
#line 3504 "cs-parser.jay"
{
		yyVal = new Argument (new Arglist (GetLocation (yyVals[-2+yyTop])));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_481()
#line 3516 "cs-parser.jay"
{
		yyVal = new ElementAccess ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_482()
#line 3521 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new ElementAccess ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_483()
#line 3526 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new ElementAccess ((Expression) yyVals[-2+yyTop], null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_484()
#line 3534 "cs-parser.jay"
{
		var list = new List<Expression> (4);
		list.Add ((Expression) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_485()
#line 3540 "cs-parser.jay"
{
		var list = (List<Expression>) yyVals[-2+yyTop];
		list.Add ((Expression) yyVals[0+yyTop]);
		lbag.AddLocation (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_486()
#line 3550 "cs-parser.jay"
{
		Arguments args = new Arguments (4);
		args.Add ((Argument) yyVals[0+yyTop]);
		yyVal = args;
	  }

void case_487()
#line 3556 "cs-parser.jay"
{
		Arguments args = (Arguments) yyVals[-2+yyTop];
		if (args [args.Count - 1] is NamedArgument && !(yyVals[0+yyTop] is NamedArgument))
			Error_NamedArgumentExpected ((NamedArgument) args [args.Count - 1]);
	  
		args.Add ((Argument) yyVals[0+yyTop]);
		lbag.AddLocation (args, GetLocation (yyVals[-1+yyTop]));
		yyVal = args;	  
	  }

void case_491()
#line 3584 "cs-parser.jay"
{
	  	yyVal = new ElementAccess (new BaseThis (GetLocation (yyVals[-3+yyTop])), (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_492()
#line 3589 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = new ElementAccess (null, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_495()
#line 3611 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			if (lang_version <= LanguageVersion.ISO_2)
				FeatureIsNotAvailable (GetLocation (yyVals[-5+yyTop]), "object initializers");
				
			yyVal = new NewInitialize ((FullNamedExpression) yyVals[-4+yyTop], (Arguments) yyVals[-2+yyTop], (CollectionOrObjectInitializers) yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop]));
		} else {
			yyVal = new New ((FullNamedExpression) yyVals[-4+yyTop], (Arguments) yyVals[-2+yyTop], GetLocation (yyVals[-5+yyTop]));
		}
		
		lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_496()
#line 3624 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "collection initializers");
	  
		yyVal = new NewInitialize ((FullNamedExpression) yyVals[-1+yyTop], null, (CollectionOrObjectInitializers) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_497()
#line 3636 "cs-parser.jay"
{
		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-5+yyTop], (List<Expression>) yyVals[-3+yyTop],
				new ComposedTypeSpecifier (((List<Expression>) yyVals[-3+yyTop]).Count, GetLocation (yyVals[-4+yyTop])) {
	  				Next = (ComposedTypeSpecifier) yyVals[-1+yyTop]
			  	}, (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-6+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_498()
#line 3644 "cs-parser.jay"
{
	  	if (yyVals[0+yyTop] == null)
	  		report.Error (1586, GetLocation (yyVals[-3+yyTop]), "Array creation must have array size or array initializer");

		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-2+yyTop], (ComposedTypeSpecifier) yyVals[-1+yyTop], (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
	  }

void case_499()
#line 3651 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "implicitly typed arrays");
	  
		yyVal = new ImplicitlyTypedArrayCreation ((ComposedTypeSpecifier) yyVals[-1+yyTop], (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_500()
#line 3658 "cs-parser.jay"
{
		report.Error (178, GetLocation (yyVals[-1+yyTop]), "Invalid rank specifier, expecting `,' or `]'");
		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-5+yyTop], null, GetLocation (yyVals[-6+yyTop]));
	  }

void case_501()
#line 3663 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		/* It can be any of new expression, create the most common one*/
		yyVal = new New ((FullNamedExpression) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_503()
#line 3675 "cs-parser.jay"
{
		--lexer.parsing_type;
		yyVal = yyVals[0+yyTop];
	  }

void case_504()
#line 3683 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
	  		FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "anonymous types");

		yyVal = new NewAnonymousType ((List<AnonymousTypeParameter>) yyVals[-1+yyTop], current_container, GetLocation (yyVals[-3+yyTop]));
		
		/* TODO: lbag comma location*/
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_509()
#line 3706 "cs-parser.jay"
{
	  	var a = new List<AnonymousTypeParameter> (4);
	  	a.Add ((AnonymousTypeParameter) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_510()
#line 3712 "cs-parser.jay"
{
	  	var a = (List<AnonymousTypeParameter>) yyVals[-2+yyTop];
	  	a.Add ((AnonymousTypeParameter) yyVals[0+yyTop]);
	  	lbag.AddLocation (a, GetLocation (yyVals[-1+yyTop]));

	  	yyVal = a;
	  }

void case_511()
#line 3723 "cs-parser.jay"
{
		var lt = (LocatedToken)yyVals[-2+yyTop];
	  	yyVal = new AnonymousTypeParameter ((Expression)yyVals[0+yyTop], lt.Value, lt.Location);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_512()
#line 3729 "cs-parser.jay"
{
		var lt = (LocatedToken)yyVals[0+yyTop];
	  	yyVal = new AnonymousTypeParameter (new SimpleName (lt.Value, lt.Location),
	  		lt.Value, lt.Location);
	  }

void case_513()
#line 3735 "cs-parser.jay"
{
	  	MemberAccess ma = (MemberAccess) yyVals[0+yyTop];
	  	yyVal = new AnonymousTypeParameter (ma, ma.Name, ma.Location);
	  }

void case_514()
#line 3740 "cs-parser.jay"
{
		report.Error (746, lexer.Location,
			"Invalid anonymous type member declarator. Anonymous type members must be a member assignment, simple name or member access expression");
		yyVal = null;
	  }

void case_518()
#line 3755 "cs-parser.jay"
{
	  	((ComposedTypeSpecifier) yyVals[-1+yyTop]).Next = (ComposedTypeSpecifier) yyVals[0+yyTop];
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_519()
#line 3763 "cs-parser.jay"
{
		yyVal = ComposedTypeSpecifier.CreateArrayDimension (1, GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_520()
#line 3768 "cs-parser.jay"
{
		yyVal = ComposedTypeSpecifier.CreateArrayDimension ((int)yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_525()
#line 3798 "cs-parser.jay"
{
		var ai = new ArrayInitializer (0, GetLocation (yyVals[-1+yyTop]));
		ai.VariableDeclaration = current_variable;
		lbag.AddLocation (ai, GetLocation (yyVals[0+yyTop]));
		yyVal = ai;
	  }

void case_526()
#line 3805 "cs-parser.jay"
{
		var ai = new ArrayInitializer ((List<Expression>) yyVals[-2+yyTop], GetLocation (yyVals[-3+yyTop]));
		ai.VariableDeclaration = current_variable;
		if (yyVals[-1+yyTop] != null) {
			lbag.AddLocation (ai, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (ai, GetLocation (yyVals[0+yyTop]));
		}
		yyVal = ai;
	  }

void case_527()
#line 3819 "cs-parser.jay"
{
		var list = new List<Expression> (4);
		list.Add ((Expression) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_528()
#line 3825 "cs-parser.jay"
{
		var list = (List<Expression>) yyVals[-2+yyTop];
		list.Add ((Expression) yyVals[0+yyTop]);
		lbag.AddLocation (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_530()
#line 3839 "cs-parser.jay"
{
	  	lexer.TypeOfParsing = false;
		yyVal = new TypeOf ((FullNamedExpression) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_533()
#line 3850 "cs-parser.jay"
{
	 	Error_TypeExpected (lexer.Location);
	 	yyVal = null;
	 }

void case_534()
#line 3858 "cs-parser.jay"
{  
		var lt = (LocatedToken) yyVals[-1+yyTop];

		var sn = new SimpleName (lt.Value, (int) yyVals[0+yyTop], lt.Location);
		yyVal = sn;
		lbag.AddLocation (sn.TypeArguments, Lexer.GetGenericDimensionLocations ());
	  }

void case_535()
#line 3866 "cs-parser.jay"
{
		var lt1 = (LocatedToken) yyVals[-2+yyTop];
		var lt2 = (LocatedToken) yyVals[-1+yyTop];

		var qam = new QualifiedAliasMember (lt1.Value, lt2.Value, (int) yyVals[0+yyTop], lt1.Location);
		yyVal = qam;
		lbag.AddLocation (qam.TypeArguments, Lexer.GetGenericDimensionLocations ());
		lbag.AddLocation (yyVal, savedLocation, GetLocation (yyVals[-1+yyTop]));
	  }

void case_536()
#line 3876 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		
		yyVal = new MemberAccess ((Expression) yyVals[-2+yyTop], lt.Value, lt.Location);
		lbag.AddLocation (yyVal, savedLocation, GetLocation (yyVals[-1+yyTop]));
	  }

void case_537()
#line 3883 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		
		var ma = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (int) yyVals[0+yyTop], lt.Location);
		yyVal = ma;
		lbag.AddLocation (yyVal, savedLocation, GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (ma.TypeArguments, Lexer.GetGenericDimensionLocations ());
	  }

void case_538()
#line 3892 "cs-parser.jay"
{
		var tne = (ATypeNameExpression) yyVals[-3+yyTop];
		if (tne.HasTypeArguments)
			Error_TypeExpected (GetLocation (yyVals[0+yyTop]));

		var lt = (LocatedToken) yyVals[-1+yyTop];
		var ma = new MemberAccess (tne, lt.Value, (int) yyVals[0+yyTop], lt.Location);		
		yyVal = ma;
		lbag.AddLocation (ma.TypeArguments, Lexer.GetGenericDimensionLocations ());
	  }

void case_539()
#line 3906 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "generics");

		yyVal = yyVals[0+yyTop];
	  }

void case_540()
#line 3916 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		if (lang_version == LanguageVersion.ISO_1)
			FeatureIsNotAvailable (lt.Location, "namespace alias qualifier");
		savedLocation = GetLocation (yyVals[0+yyTop]);
		yyVal = lt;		
	  }

void case_541()
#line 3927 "cs-parser.jay"
{ 
		yyVal = new SizeOf ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_542()
#line 3932 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new SizeOf ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_543()
#line 3942 "cs-parser.jay"
{
		yyVal = new CheckedExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_544()
#line 3947 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new CheckedExpr (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_545()
#line 3956 "cs-parser.jay"
{
		yyVal = new UnCheckedExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_546()
#line 3961 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new UnCheckedExpr (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_547()
#line 3970 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (new Indirection ((Expression) yyVals[-3+yyTop], GetLocation (yyVals[-2+yyTop])), lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
	  }

void case_549()
#line 3982 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		if ((ParametersCompiled) yyVals[-2+yyTop] != ParametersCompiled.Undefined) {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), savedOpenLocation, savedCloseLocation);
		} else {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]));
		}
	  }

void case_551()
#line 3995 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		
		if ((ParametersCompiled) yyVals[-2+yyTop] != ParametersCompiled.Undefined) {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), savedOpenLocation, savedCloseLocation);
		} else {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]));
		}
	  }

void case_555()
#line 4020 "cs-parser.jay"
{
		valid_param_mod = 0;
	  	yyVal = yyVals[-1+yyTop];
	  	savedOpenLocation = GetLocation (yyVals[-3+yyTop]);
	  	savedCloseLocation = GetLocation (yyVals[-2+yyTop]);
	  }

void case_556()
#line 4030 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "default value expression");

		yyVal = new DefaultValueExpression ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_560()
#line 4050 "cs-parser.jay"
{
		yyVal = new Cast ((FullNamedExpression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_561()
#line 4055 "cs-parser.jay"
{
		if (!async_block) {
			 if (current_anonymous_method is LambdaExpression) {
				report.Error (4034, GetLocation (yyVals[-1+yyTop]),
					"The `await' operator can only be used when its containing lambda expression is marked with the `async' modifier");
			} else if (current_anonymous_method is AnonymousMethodExpression) {
				report.Error (4035, GetLocation (yyVals[-1+yyTop]),
					"The `await' operator can only be used when its containing anonymous method is marked with the `async' modifier");
			} else if (interactive_async != null) {
				current_block.Explicit.RegisterAsyncAwait ();
				interactive_async = true;
			} else {
				report.Error (4033, GetLocation (yyVals[-1+yyTop]),
					"The `await' operator can only be used when its containing method is marked with the `async' modifier");
			}
		} else {
			current_block.Explicit.RegisterAsyncAwait ();
		}
		
		yyVal = new Await ((Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_562()
#line 4077 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Unary (Unary.Operator.LogicalNot, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_563()
#line 4083 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Unary (Unary.Operator.OnesComplement, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_564()
#line 4089 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Cast ((FullNamedExpression) yyVals[-2+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_565()
#line 4096 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Await (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_573()
#line 4134 "cs-parser.jay"
{ 
		Error_SyntaxError (yyToken);

	  	yyVal = new Unary (Unary.Operator.UnaryPlus, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_574()
#line 4140 "cs-parser.jay"
{ 
		Error_SyntaxError (yyToken);

		yyVal = new Unary (Unary.Operator.UnaryNegation, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_575()
#line 4146 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new UnaryMutator (UnaryMutator.Mode.PreIncrement, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_576()
#line 4152 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new UnaryMutator (UnaryMutator.Mode.PreDecrement, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_577()
#line 4158 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Indirection (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_578()
#line 4164 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Unary (Unary.Operator.AddressOf, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_580()
#line 4174 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Multiply, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_581()
#line 4179 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Division, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_582()
#line 4184 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Modulus, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_583()
#line 4189 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Multiply, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_584()
#line 4196 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Division, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_585()
#line 4203 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Modulus, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_587()
#line 4214 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Addition, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_588()
#line 4219 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_591()
#line 4232 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Addition, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_592()
#line 4239 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_593()
#line 4246 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new As ((Expression) yyVals[-2+yyTop], null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_594()
#line 4252 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Is ((Expression) yyVals[-2+yyTop], null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_596()
#line 4262 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LeftShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_597()
#line 4267 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.RightShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_598()
#line 4272 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.LeftShift, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_599()
#line 4279 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.RightShift, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_601()
#line 4290 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LessThan, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_602()
#line 4295 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.GreaterThan, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_603()
#line 4300 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LessThanOrEqual, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_604()
#line 4305 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.GreaterThanOrEqual, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_605()
#line 4310 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.LessThan, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_606()
#line 4317 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.GreaterThan, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_607()
#line 4324 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.LessThanOrEqual, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_608()
#line 4331 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.GreaterThanOrEqual, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_610()
#line 4342 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Equality, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_611()
#line 4347 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Inequality, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_612()
#line 4352 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Equality, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_613()
#line 4359 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Inequality, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_615()
#line 4370 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.BitwiseAnd, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_616()
#line 4375 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.BitwiseAnd, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_618()
#line 4386 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.ExclusiveOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_619()
#line 4391 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.ExclusiveOr, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_621()
#line 4402 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.BitwiseOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_622()
#line 4407 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.BitwiseOr, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_624()
#line 4418 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LogicalAnd, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_625()
#line 4423 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.LogicalAnd, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_627()
#line 4434 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LogicalOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_628()
#line 4439 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.LogicalOr, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_630()
#line 4450 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "null coalescing operator");
			
		yyVal = new Nullable.NullCoalescingOperator ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_632()
#line 4462 "cs-parser.jay"
{
		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-4+yyTop]), (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_633()
#line 4467 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-3+yyTop]), (Expression) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_634()
#line 4473 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-4+yyTop]), (Expression) yyVals[-2+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_635()
#line 4480 "cs-parser.jay"
{
		Error_SyntaxError (Token.CLOSE_BRACE);

		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-4+yyTop]), (Expression) yyVals[-2+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
		lexer.putback ('}');
	  }

void case_636()
#line 4491 "cs-parser.jay"
{
		yyVal = new SimpleAssign ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_637()
#line 4496 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Multiply, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_638()
#line 4501 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Division, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_639()
#line 4506 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Modulus, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_640()
#line 4511 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Addition, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_641()
#line 4516 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_642()
#line 4521 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.LeftShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_643()
#line 4526 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.RightShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_644()
#line 4531 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.BitwiseAnd, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_645()
#line 4536 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.BitwiseOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_646()
#line 4541 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.ExclusiveOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_647()
#line 4549 "cs-parser.jay"
{
		var pars = new List<Parameter> (4);
		pars.Add ((Parameter) yyVals[0+yyTop]);
		parameterListCommas.Clear ();
		yyVal = pars;
	  }

void case_648()
#line 4556 "cs-parser.jay"
{
		var pars = (List<Parameter>) yyVals[-2+yyTop];
		Parameter p = (Parameter)yyVals[0+yyTop];
		if (pars[0].GetType () != p.GetType ()) {
			report.Error (748, p.Location, "All lambda parameters must be typed either explicitly or implicitly");
		}
		
		pars.Add (p);
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));

		yyVal = pars;
	  }

void case_649()
#line 4572 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];

		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Parameter.Modifier) yyVals[-2+yyTop], null, lt.Location);
	  }

void case_650()
#line 4578 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];

		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, Parameter.Modifier.NONE, null, lt.Location);
	  }

void case_651()
#line 4584 "cs-parser.jay"
{
	  	var lt = (LocatedToken) yyVals[0+yyTop];
		yyVal = new ImplicitLambdaParameter (lt.Value, lt.Location);
	  }

void case_652()
#line 4589 "cs-parser.jay"
{
	  	var lt = (LocatedToken) Error_AwaitAsIdentifier (yyVals[0+yyTop]);
		yyVal = new ImplicitLambdaParameter (lt.Value, lt.Location);
	  }

void case_654()
#line 4597 "cs-parser.jay"
{ 
		var pars_list = (List<Parameter>) yyVals[0+yyTop];
		yyVal = new ParametersCompiled (pars_list.ToArray ());
		lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_656()
#line 4609 "cs-parser.jay"
{
		Block b = end_block (Location.Null);
		b.IsCompilerGenerated = true;
		b.AddStatement (new ContextualReturn ((Expression) yyVals[0+yyTop]));
		yyVal = b;
	  }

void case_658()
#line 4617 "cs-parser.jay"
{
	  	/* Handles only cases like foo = x.FirstOrDefault (l => );*/
	  	/* where we must restore current_variable*/
		Block b = end_block (Location.Null);
		b.IsCompilerGenerated = true;

		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_660()
#line 4631 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_661()
#line 4639 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];	
		Parameter p = new ImplicitLambdaParameter (lt.Value, lt.Location);
		start_anonymous (true, new ParametersCompiled (p), false, lt.Location);
	  }

void case_662()
#line 4645 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_663()
#line 4650 "cs-parser.jay"
{
		var lt = (LocatedToken) Error_AwaitAsIdentifier (yyVals[-1+yyTop]);
		Parameter p = new ImplicitLambdaParameter (lt.Value, lt.Location);
		start_anonymous (true, new ParametersCompiled (p), false, lt.Location);
	  }

void case_664()
#line 4656 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_665()
#line 4661 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		Parameter p = new ImplicitLambdaParameter (lt.Value, lt.Location);
		start_anonymous (true, new ParametersCompiled (p), true, lt.Location);
	  }

void case_666()
#line 4667 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_668()
#line 4676 "cs-parser.jay"
{
	  	valid_param_mod = 0;
		start_anonymous (true, (ParametersCompiled) yyVals[-2+yyTop], false, GetLocation (yyVals[-4+yyTop]));
	  }

void case_669()
#line 4681 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_671()
#line 4690 "cs-parser.jay"
{
	  	valid_param_mod = 0;
		start_anonymous (true, (ParametersCompiled) yyVals[-2+yyTop], true, GetLocation (yyVals[-5+yyTop]));
	  }

void case_672()
#line 4695 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_679()
#line 4718 "cs-parser.jay"
{
		yyVal = new RefValueExpr ((Expression) yyVals[-3+yyTop], (FullNamedExpression) yyVals[-1+yyTop], GetLocation (yyVals[-5+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_680()
#line 4723 "cs-parser.jay"
{
		yyVal = new RefTypeExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_681()
#line 4728 "cs-parser.jay"
{
		yyVal = new MakeRefExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));	  
	  }

void case_685()
#line 4756 "cs-parser.jay"
{
		lexer.ConstraintsParsing = true;

		Class c = new Class (current_container, (MemberName) yyVals[0+yyTop], (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]);
		if (((c.ModFlags & Modifiers.STATIC) != 0) && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (c.Location, "static classes");
		}
			
		push_current_container (c, yyVals[-3+yyTop]);
		lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]));
	  }

void case_686()
#line 4769 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		if (yyVals[0+yyTop] != null)
			current_container.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support) {
			current_container.PartialContainer.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lexer.parsing_modifiers = true;
	  }

void case_687()
#line 4783 "cs-parser.jay"
{
		--lexer.parsing_declaration;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_688()
#line 4789 "cs-parser.jay"
{
		if (yyVals[0+yyTop] == null) {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		} else {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = pop_current_class ();
	  }

void case_691()
#line 4808 "cs-parser.jay"
{
	    mod_locations = null;
		yyVal = ModifierNone;
		lexer.parsing_modifiers = false;
	  }

void case_694()
#line 4822 "cs-parser.jay"
{ 
		var m1 = (Modifiers) yyVals[-1+yyTop];
		var m2 = (Modifiers) yyVals[0+yyTop];

		if ((m1 & m2) != 0) {
			report.Error (1004, lexer.Location - ModifiersExtensions.Name (m2).Length,
				"Duplicate `{0}' modifier", ModifiersExtensions.Name (m2));
		} else if ((m2 & Modifiers.AccessibilityMask) != 0 && (m1 & Modifiers.AccessibilityMask) != 0 &&
			((m2 | m1 & Modifiers.AccessibilityMask) != (Modifiers.PROTECTED | Modifiers.INTERNAL))) {
			report.Error (107, lexer.Location - ModifiersExtensions.Name (m2).Length,
				"More than one protection modifier specified");
		}
		
		yyVal = m1 | m2;
	  }

void case_695()
#line 4841 "cs-parser.jay"
{
		yyVal = Modifiers.NEW;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
		
		if (current_container.Kind == MemberKind.Namespace)
			report.Error (1530, GetLocation (yyVals[0+yyTop]), "Keyword `new' is not allowed on namespace elements");
	  }

void case_696()
#line 4849 "cs-parser.jay"
{
		yyVal = Modifiers.PUBLIC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_697()
#line 4854 "cs-parser.jay"
{
		yyVal = Modifiers.PROTECTED;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_698()
#line 4859 "cs-parser.jay"
{
		yyVal = Modifiers.INTERNAL;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_699()
#line 4864 "cs-parser.jay"
{
		yyVal = Modifiers.PRIVATE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_700()
#line 4869 "cs-parser.jay"
{
		yyVal = Modifiers.ABSTRACT;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_701()
#line 4874 "cs-parser.jay"
{
		yyVal = Modifiers.SEALED;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_702()
#line 4879 "cs-parser.jay"
{
		yyVal = Modifiers.STATIC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_703()
#line 4884 "cs-parser.jay"
{
		yyVal = Modifiers.READONLY;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_704()
#line 4889 "cs-parser.jay"
{
		yyVal = Modifiers.VIRTUAL;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_705()
#line 4894 "cs-parser.jay"
{
		yyVal = Modifiers.OVERRIDE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_706()
#line 4899 "cs-parser.jay"
{
		yyVal = Modifiers.EXTERN;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_707()
#line 4904 "cs-parser.jay"
{
		yyVal = Modifiers.VOLATILE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_708()
#line 4909 "cs-parser.jay"
{
		yyVal = Modifiers.UNSAFE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
		if (!settings.Unsafe)
			Error_UnsafeCodeNotAllowed (GetLocation (yyVals[0+yyTop]));
	  }

void case_709()
#line 4916 "cs-parser.jay"
{
		yyVal = Modifiers.ASYNC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_711()
#line 4925 "cs-parser.jay"
{
		current_type.SetBaseTypes ((List<FullNamedExpression>) yyVals[0+yyTop]);
		lbag.AppendToMember (current_type, GetLocation (yyVals[-1+yyTop]));
	 }

void case_712()
#line 4930 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		current_type.SetBaseTypes ((List<FullNamedExpression>) yyVals[-1+yyTop]);
	  }

void case_715()
#line 4947 "cs-parser.jay"
{
		var constraints = new List<Constraints> (1);
		constraints.Add ((Constraints) yyVals[0+yyTop]);
		yyVal = constraints;
	  }

void case_716()
#line 4953 "cs-parser.jay"
{
		var constraints = (List<Constraints>) yyVals[-1+yyTop];
		Constraints new_constraint = (Constraints)yyVals[0+yyTop];

		foreach (Constraints c in constraints) {
			if (new_constraint.TypeParameter.Value == c.TypeParameter.Value) {
				report.Error (409, new_constraint.Location,
					"A constraint clause has already been specified for type parameter `{0}'",
					new_constraint.TypeParameter.Value);
			}
		}

		constraints.Add (new_constraint);
		yyVal = constraints;
	  }

void case_717()
#line 4972 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new Constraints (new SimpleMemberName (lt.Value, lt.Location), (List<FullNamedExpression>) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_718()
#line 4978 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new Constraints (new SimpleMemberName (lt.Value, lt.Location), null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_719()
#line 4988 "cs-parser.jay"
{
		var constraints = new List<FullNamedExpression> (1);
		constraints.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = constraints;
	  }

void case_720()
#line 4994 "cs-parser.jay"
{
		var constraints = (List<FullNamedExpression>) yyVals[-2+yyTop];
		var prev = constraints [constraints.Count - 1] as SpecialContraintExpr;
		if (prev != null && (prev.Constraint & SpecialConstraint.Constructor) != 0) {			
			report.Error (401, GetLocation (yyVals[-1+yyTop]), "The `new()' constraint must be the last constraint specified");
		}
		
		prev = yyVals[0+yyTop] as SpecialContraintExpr;
		if (prev != null) {
			if ((prev.Constraint & (SpecialConstraint.Class | SpecialConstraint.Struct)) != 0) {
				report.Error (449, prev.Location, "The `class' or `struct' constraint must be the first constraint specified");			
			} else {
			 	prev = constraints [0] as SpecialContraintExpr;
			 	if (prev != null && (prev.Constraint & SpecialConstraint.Struct) != 0) {			
					report.Error (451, GetLocation (yyVals[0+yyTop]), "The `new()' constraint cannot be used with the `struct' constraint");
				}
			}
		}

		constraints.Add ((FullNamedExpression) yyVals[0+yyTop]);
		lbag.AddLocation (constraints, GetLocation (yyVals[-1+yyTop]));
		yyVal = constraints;
	  }

void case_721()
#line 5021 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is ComposedCast)
			report.Error (706, GetLocation (yyVals[0+yyTop]), "Invalid constraint type `{0}'", ((ComposedCast)yyVals[0+yyTop]).GetSignatureForError ());
	  
	  	yyVal = yyVals[0+yyTop];
	  }

void case_722()
#line 5028 "cs-parser.jay"
{
		yyVal = new SpecialContraintExpr (SpecialConstraint.Constructor, GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_726()
#line 5048 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.V_3)
			FeatureIsNotAvailable (lexer.Location, "generic type variance");
		
		yyVal = yyVals[0+yyTop];
	  }

void case_727()
#line 5058 "cs-parser.jay"
{
		yyVal = Variance.Covariant;
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_728()
#line 5063 "cs-parser.jay"
{
		yyVal = Variance.Contravariant;
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_729()
#line 5084 "cs-parser.jay"
{
		++lexer.parsing_block;
		start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_731()
#line 5096 "cs-parser.jay"
{
	 	--lexer.parsing_block;
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_732()
#line 5101 "cs-parser.jay"
{
	 	--lexer.parsing_block;
		yyVal = end_block (lexer.Location);
	  }

void case_733()
#line 5110 "cs-parser.jay"
{
		++lexer.parsing_block;
		current_block.StartLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_734()
#line 5115 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_735()
#line 5119 "cs-parser.jay"
{
		report.Error (1525, GetLocation (yyVals[0+yyTop]), "Unexpected symbol '}', expected '{'");
		lexer.putback ('}');
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_736()
#line 5128 "cs-parser.jay"
{
		++lexer.parsing_block;
		current_block.StartLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_737()
#line 5133 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_745()
#line 5161 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		var lt =(LocatedToken) yyVals[-1+yyTop];
		var sn = new SimpleName (lt.Value, lt.Location);
		current_block.AddStatement(new StatementErrorExpression (sn));
		yyVal = null;
	}

void case_746()
#line 5170 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_779()
#line 5234 "cs-parser.jay"
{
		  report.Error (1023, GetLocation (yyVals[0+yyTop]), "An embedded statement may not be a declaration or labeled statement");
		  yyVal = null;
	  }

void case_780()
#line 5239 "cs-parser.jay"
{
		  report.Error (1023, GetLocation (yyVals[0+yyTop]), "An embedded statement may not be a declaration or labeled statement");
		  yyVal = null;
	  }

void case_781()
#line 5244 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_782()
#line 5252 "cs-parser.jay"
{
		/* Uses lexer.Location because semicolon location is not kept in quick mode*/
		yyVal = new EmptyStatement (lexer.Location);
	  }

void case_783()
#line 5260 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		LabeledStatement labeled = new LabeledStatement (lt.Value, current_block, lt.Location);
		lbag.AddLocation (labeled, GetLocation (yyVals[0+yyTop]));
		current_block.AddLabel (labeled);
		current_block.AddStatement (labeled);
	  }

void case_786()
#line 5273 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] is VarExpr)
			yyVals[-1+yyTop] = new SimpleName ("var", ((VarExpr) yyVals[-1+yyTop]).Location);
	  
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_787()
#line 5289 "cs-parser.jay"
{ 
		/* Ok, the above "primary_expression" is there to get rid of*/
		/* both reduce/reduce and shift/reduces in the grammar, it should*/
		/* really just be "type_name".  If you use type_name, a reduce/reduce*/
		/* creeps up.  If you use namespace_or_type_name (which is all we need*/
		/* really) two shift/reduces appear.*/
		/* */

		/* So the super-trick is that primary_expression*/
		/* can only be either a SimpleName or a MemberAccess. */
		/* The MemberAccess case arises when you have a fully qualified type-name like :*/
		/* Foo.Bar.Blah i;*/
		/* SimpleName is when you have*/
		/* Blah i;*/
		
		Expression expr = (Expression) yyVals[-1+yyTop];
		if (yyVals[0+yyTop] == null) {
			SimpleName sn = expr as SimpleName;
			if (sn != null && sn.Name == "var")
				yyVal = new VarExpr (sn.Location);
			else
				yyVal = yyVals[-1+yyTop];
		} else if (expr is ATypeNameExpression) {
			yyVal = new ComposedCast ((ATypeNameExpression)expr, (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			Error_ExpectingTypeName (expr);
			yyVal = null;
		}
	  }

void case_788()
#line 5319 "cs-parser.jay"
{
		ATypeNameExpression expr = yyVals[-1+yyTop] as ATypeNameExpression;

		if (expr != null) {
			yyVal = new ComposedCast (expr, (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			Error_ExpectingTypeName ((Expression)yyVals[-1+yyTop]);
			yyVal = expr;
		}
	  }

void case_789()
#line 5330 "cs-parser.jay"
{
		if (yyVals[0+yyTop] == null)
			yyVal = yyVals[-1+yyTop];
		else
			yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_792()
#line 5345 "cs-parser.jay"
{
		Expression.Error_VoidInvalidInTheContext (GetLocation (yyVals[0+yyTop]), report);
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_794()
#line 5354 "cs-parser.jay"
{
	  	((ComposedTypeSpecifier) yyVals[-1+yyTop]).Next = (ComposedTypeSpecifier) yyVals[0+yyTop];
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_798()
#line 5377 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockVariable ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_799()
#line 5384 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
		if (yyVals[-2+yyTop] != null)
			lbag.AddLocation (yyVal, PopLocation (), GetLocation (yyVals[0+yyTop]));
		else
			lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_800()
#line 5393 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.Constant, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockConstant ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_801()
#line 5400 "cs-parser.jay"
{
		if (current_variable.Initializer != null) {
			lbag.AddLocation (current_variable, GetLocation (yyVals[-6+yyTop]), savedLocation, GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (current_variable, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = current_variable;;
		current_variable = null;
	  }

void case_803()
#line 5413 "cs-parser.jay"
{
		/* Redundant, but wont regress*/
		report.Error (1525, lexer.Location, "Unexpected symbol }");
		lexer.putback ('}');
		yyVal = yyVals[0+yyTop];
	  }

void case_805()
#line 5424 "cs-parser.jay"
{
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
		PushLocation (GetLocation (yyVals[-1+yyTop]));
		yyVal = current_variable;
	  }

void case_806()
#line 5430 "cs-parser.jay"
{
	  	if (yyToken == Token.OPEN_BRACKET_EXPR) {
			report.Error (650, lexer.Location,
				"Syntax error, bad array declarator. To declare a managed array the rank specifier precedes the variable's identifier. To declare a fixed size buffer field, use the fixed keyword before the field type");
		} else {
			Error_SyntaxError (yyToken);
		}
	  }

void case_810()
#line 5448 "cs-parser.jay"
{
		foreach (var d in current_variable.Declarators) {
			if (d.Initializer == null)
				Error_MissingInitializer (d.Variable.Location);
		}
	  }

void case_813()
#line 5463 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];	  
		var li = new LocalVariable (current_variable.Variable, lt.Value, lt.Location);
		var d = new BlockVariableDeclarator (li, null);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-1+yyTop]));
	  }

void case_814()
#line 5472 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];	  
		var li = new LocalVariable (current_variable.Variable, lt.Value, lt.Location);
		var d = new BlockVariableDeclarator (li, (Expression) yyVals[0+yyTop]);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_816()
#line 5488 "cs-parser.jay"
{
		savedLocation = GetLocation (yyVals[-1+yyTop]);
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
	  }

void case_821()
#line 5506 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];	  
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.Constant, lt.Location);
		var d = new BlockVariableDeclarator (li, (Expression) yyVals[0+yyTop]);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_823()
#line 5519 "cs-parser.jay"
{
		yyVal = new StackAlloc ((Expression) yyVals[-3+yyTop], (Expression) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_824()
#line 5524 "cs-parser.jay"
{
		report.Error (1575, GetLocation (yyVals[-1+yyTop]), "A stackalloc expression requires [] after type");
		yyVal = new StackAlloc ((Expression) yyVals[0+yyTop], null, GetLocation (yyVals[-1+yyTop]));		
	  }

void case_825()
#line 5532 "cs-parser.jay"
{
		yyVal = yyVals[-1+yyTop];
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_827()
#line 5538 "cs-parser.jay"
{
		yyVal = yyVals[-1+yyTop];
		report.Error (1002, GetLocation (yyVals[0+yyTop]), "; expected");
		lexer.putback ('}');
	  }

void case_830()
#line 5556 "cs-parser.jay"
{
		ExpressionStatement s = yyVals[0+yyTop] as ExpressionStatement;
		if (s == null) {
			var expr = yyVals[0+yyTop] as Expression;
			yyVal = new StatementErrorExpression (expr);
		} else {
			yyVal = new StatementExpression (s);
		}
	  }

void case_831()
#line 5569 "cs-parser.jay"
{
		Expression expr = (Expression) yyVals[0+yyTop];
		yyVal = new StatementExpression (new OptionalAssign (expr, lexer.Location));
	  }

void case_832()
#line 5574 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_835()
#line 5588 "cs-parser.jay"
{ 
		if (yyVals[0+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
		
		yyVal = new If ((BooleanExpression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_836()
#line 5597 "cs-parser.jay"
{
		yyVal = new If ((BooleanExpression) yyVals[-4+yyTop], (Statement) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-6+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
		
		if (yyVals[-2+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[-2+yyTop]));
		if (yyVals[0+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_837()
#line 5607 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		
		yyVal = new If ((BooleanExpression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_839()
#line 5621 "cs-parser.jay"
{
		yyVal = new Switch ((Expression) yyVals[-5+yyTop], (ExplicitBlock) current_block.Explicit, GetLocation (yyVals[-7+yyTop]));	
		end_block (GetLocation (yyVals[0+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_840()
#line 5627 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  
		yyVal = new Switch ((Expression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));	
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_847()
#line 5658 "cs-parser.jay"
{
	  	var label = (SwitchLabel) yyVals[0+yyTop];
	  	label.SectionStart = true;
		current_block.AddStatement (label);
	  }

void case_849()
#line 5671 "cs-parser.jay"
{
	 	yyVal = new SwitchLabel ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	 	lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	 }

void case_850()
#line 5676 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new SwitchLabel ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_856()
#line 5695 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new While ((BooleanExpression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_857()
#line 5703 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		
		yyVal = new While ((BooleanExpression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_858()
#line 5713 "cs-parser.jay"
{
		yyVal = new Do ((Statement) yyVals[-5+yyTop], (BooleanExpression) yyVals[-2+yyTop], GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_859()
#line 5718 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Do ((Statement) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]), Location.Null);
	  }

void case_860()
#line 5723 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  
		yyVal = new Do ((Statement) yyVals[-4+yyTop], (BooleanExpression) yyVals[-1+yyTop], GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_861()
#line 5733 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[0+yyTop]));
		current_block.IsCompilerGenerated = true;
		For f = new For (GetLocation (yyVals[-1+yyTop]));
		current_block.AddStatement (f);
		lbag.AddStatement (f, current_block.StartLocation);
		yyVal = f;
	  }

void case_863()
#line 5750 "cs-parser.jay"
{
		For f =  (For) yyVals[-2+yyTop];
		f.Initializer = (Statement) yyVals[-1+yyTop];
		lbag.AddLocation (f, GetLocation (yyVals[0+yyTop]));
		yyVal = f;
	  }

void case_865()
#line 5760 "cs-parser.jay"
{
		report.Error (1525, GetLocation (yyVals[0+yyTop]), "Unexpected symbol ')', expected ';'");
		For f =  (For) yyVals[-2+yyTop];
		f.Initializer = (Statement) yyVals[-1+yyTop];
		lbag.AddLocation (f, GetLocation (yyVals[0+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	}

void case_866()
#line 5771 "cs-parser.jay"
{
		For f =  (For) yyVals[-2+yyTop];
		f.Condition = (BooleanExpression) yyVals[-1+yyTop];
		lbag.AddLocation (f, GetLocation (yyVals[0+yyTop]));
		yyVal = f;
	  }

void case_868()
#line 5782 "cs-parser.jay"
{
		report.Error (1525, GetLocation (yyVals[0+yyTop]), "Unexpected symbol ')', expected ';'");
		For f =  (For) yyVals[-2+yyTop];
		f.Condition = (BooleanExpression) yyVals[-1+yyTop];
		lbag.AddLocation (f, GetLocation (yyVals[0+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	}

void case_869()
#line 5794 "cs-parser.jay"
{
		For f =  (For) yyVals[-3+yyTop];
		f.Iterator = (Statement) yyVals[-2+yyTop];
		
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		f.Statement = (Statement) yyVals[0+yyTop];
		lbag.AddLocation (f, GetLocation (yyVals[-1+yyTop]));

		yyVal = end_block (GetLocation (yyVals[-1+yyTop]));
	  }

void case_870()
#line 5807 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = end_block (current_block.StartLocation);
	  }

void case_873()
#line 5820 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockVariable ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_874()
#line 5827 "cs-parser.jay"
{
		yyVal = current_variable;
		if (yyVals[-1+yyTop] != null)
			lbag.AddLocation (current_variable, PopLocation ());

		current_variable = null;
	  }

void case_882()
#line 5854 "cs-parser.jay"
{
	  	var sl = yyVals[-2+yyTop] as StatementList;
	  	if (sl == null) {
	  		sl = new StatementList ((Statement) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop]);
			lbag.AddStatement (sl, GetLocation (yyVals[-1+yyTop]));
	  	} else {
	  		sl.Add ((Statement) yyVals[0+yyTop]);
	  		lbag.AddLocation (sl, GetLocation (yyVals[-1+yyTop]));
	  		
	  	}
	  		
		yyVal = sl;
	  }

void case_883()
#line 5871 "cs-parser.jay"
{
		report.Error (230, GetLocation (yyVals[-3+yyTop]), "Type and identifier are both required in a foreach statement");

		start_block (GetLocation (yyVals[-2+yyTop]));
		current_block.IsCompilerGenerated = true;
		
		Foreach f = new Foreach ((Expression) yyVals[-1+yyTop], null, null, null, null, GetLocation (yyVals[-3+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-2+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_884()
#line 5884 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	
		start_block (GetLocation (yyVals[-3+yyTop]));
		current_block.IsCompilerGenerated = true;
		
		var lt = (LocatedToken) yyVals[-1+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.ForeachVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		
		Foreach f = new Foreach ((Expression) yyVals[-2+yyTop], li, null, null, null, GetLocation (yyVals[-4+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-3+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_885()
#line 5901 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-5+yyTop]));
		current_block.IsCompilerGenerated = true;
		
		var lt = (LocatedToken) yyVals[-3+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.ForeachVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		yyVal = li;
	  }

void case_886()
#line 5911 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
		
		Foreach f = new Foreach ((Expression) yyVals[-6+yyTop], (LocalVariable) yyVals[-1+yyTop], (Expression) yyVals[-3+yyTop], (Statement) yyVals[0+yyTop], current_block, GetLocation (yyVals[-8+yyTop]));
		lbag.AddStatement (f, GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		end_block (GetLocation (yyVals[-2+yyTop]));
		
		yyVal = f;
	  }

void case_887()
#line 5922 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-3+yyTop]));
		current_block.IsCompilerGenerated = true;
		var lt = yyVals[-1+yyTop] as LocatedToken;
		var li = lt != null ? new LocalVariable (current_block, lt.Value, LocalVariable.Flags.ForeachVariable | LocalVariable.Flags.Used, lt.Location) : null;
		
		Foreach f = new Foreach ((Expression) yyVals[-2+yyTop], li, null, null, null, GetLocation (yyVals[-4+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-3+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_888()
#line 5935 "cs-parser.jay"
{
		Foreach f = new Foreach ((Expression) yyVals[-1+yyTop], null, null, null, null, GetLocation (yyVals[-3+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-2+yyTop]));
		yyVal = f;
	  }

void case_895()
#line 5955 "cs-parser.jay"
{
		yyVal = new Break (GetLocation (yyVals[-1+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_896()
#line 5963 "cs-parser.jay"
{
		yyVal = new Continue (GetLocation (yyVals[-1+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_897()
#line 5968 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Continue (GetLocation (yyVals[-1+yyTop]));
	  }

void case_898()
#line 5976 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new Goto (lt.Value, GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_899()
#line 5982 "cs-parser.jay"
{
		yyVal = new GotoCase ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_900()
#line 5987 "cs-parser.jay"
{
		yyVal = new GotoDefault (GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_901()
#line 5995 "cs-parser.jay"
{
		yyVal = new Return ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_902()
#line 6000 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Return ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_903()
#line 6005 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Return (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_904()
#line 6013 "cs-parser.jay"
{
		yyVal = new Throw ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_905()
#line 6018 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Throw ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_906()
#line 6023 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Throw (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_907()
#line 6031 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-3+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			report.Error (1003, lt.Location, "; expected");
		} else if (yyVals[-1+yyTop] == null) {
			report.Error (1627, GetLocation (yyVals[0+yyTop]), "Expression expected after yield return");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.Explicit.RegisterIteratorYield ();
		yyVal = new Yield ((Expression) yyVals[-1+yyTop], lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_908()
#line 6047 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		var lt = (LocatedToken) yyVals[-3+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			report.Error (1003, lt.Location, "; expected");
		} else if (yyVals[-1+yyTop] == null) {
			report.Error (1627, GetLocation (yyVals[0+yyTop]), "Expression expected after yield return");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.Explicit.RegisterIteratorYield ();
		yyVal = new Yield ((Expression) yyVals[-1+yyTop], lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_909()
#line 6065 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			report.Error (1003, lt.Location, "; expected");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.ParametersBlock.TopBlock.IsIterator = true;
		yyVal = new YieldBreak (lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_913()
#line 6091 "cs-parser.jay"
{
		yyVal = new TryFinally ((Statement) yyVals[-2+yyTop], (Block) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_914()
#line 6096 "cs-parser.jay"
{
		yyVal = new TryFinally (new TryCatch ((Block) yyVals[-3+yyTop], (List<Catch>) yyVals[-2+yyTop], GetLocation (yyVals[-4+yyTop]), true), (Block) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_915()
#line 6101 "cs-parser.jay"
{
		Error_SyntaxError (1524, yyToken);
		yyVal = new TryCatch ((Block) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]), false);
	  }

void case_916()
#line 6109 "cs-parser.jay"
{
		var l = new List<Catch> (2);

		l.Add ((Catch) yyVals[0+yyTop]);
		yyVal = l;
	  }

void case_917()
#line 6116 "cs-parser.jay"
{
		var l = (List<Catch>) yyVals[-1+yyTop];
		
		Catch c = (Catch) yyVals[0+yyTop];
		if (l [l.Count - 1].IsGeneral) {
			report.Error (1017, c.loc, "Try statement already has an empty catch block");
		}
		
		l.Add (c);
		yyVal = l;
	  }

void case_921()
#line 6140 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-3+yyTop]));
		var c = new Catch (current_block, GetLocation (yyVals[-4+yyTop]));
		c.TypeExpression = (FullNamedExpression) yyVals[-2+yyTop];

		if (yyVals[-1+yyTop] != null) {
			var lt = (LocatedToken) yyVals[-1+yyTop];
			c.Variable = new LocalVariable (current_block, lt.Value, lt.Location);
			current_block.AddLocalName (c.Variable);
		}

		lbag.AddLocation (c, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = c;
	  }

void case_923()
#line 6159 "cs-parser.jay"
{
	  	if (yyToken == Token.CLOSE_PARENS) {
			report.Error (1015, lexer.Location,
				"A type that derives from `System.Exception', `object', or `string' expected");
		} else {
			Error_SyntaxError (yyToken);
		}
		
		yyVal = new Catch (null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_924()
#line 6170 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		/* Required otherwise missing block could not be detected because*/
		/* start_block is run early*/
		var c = new Catch (null, GetLocation (yyVals[-5+yyTop]));
		c.TypeExpression = (FullNamedExpression) yyVals[-3+yyTop];
		
		if (yyVals[-2+yyTop] != null) {
			var lt = (LocatedToken) yyVals[-2+yyTop];
			c.Variable = new LocalVariable (current_block, lt.Value, lt.Location);
		}

		if (yyVals[-2+yyTop] != null) {
			var lt = (LocatedToken) yyVals[-2+yyTop];
			c.Variable = new LocalVariable (current_block, lt.Value, lt.Location);
		}

		lbag.AddLocation (c, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-1+yyTop]));

		yyVal = c;
	  }

void case_927()
#line 6210 "cs-parser.jay"
{
		if (!settings.Unsafe)
			Error_UnsafeCodeNotAllowed (GetLocation (yyVals[0+yyTop]));
	  }

void case_929()
#line 6220 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new Lock ((Expression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_930()
#line 6228 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Lock ((Expression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_931()
#line 6238 "cs-parser.jay"
{
	    start_block (GetLocation (yyVals[-2+yyTop]));
	    
		current_block.IsCompilerGenerated = true;
		var lt = (LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.FixedVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new Fixed.VariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_932()
#line 6248 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
	  }

void case_933()
#line 6253 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Fixed f = new Fixed ((Fixed.VariableDeclaration) yyVals[-1+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-9+yyTop]));
		current_block.AddStatement (f);
		lbag.AddStatement (f, GetLocation (yyVals[-8+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = end_block (GetLocation (yyVals[-2+yyTop]));
	  }

void case_934()
#line 6266 "cs-parser.jay"
{
	    start_block (GetLocation (yyVals[-2+yyTop]));
	    
		current_block.IsCompilerGenerated = true;
		var lt = (LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.UsingVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new Using.VariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_935()
#line 6276 "cs-parser.jay"
{
		yyVal = current_variable;	  
		current_variable = null;
	  }

void case_936()
#line 6281 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Using u = new Using ((Using.VariableDeclaration) yyVals[-1+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-8+yyTop]));
		lbag.AddStatement (u, GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-2+yyTop]));
		current_block.AddStatement (u);
		yyVal = end_block (GetLocation (yyVals[-2+yyTop]));
	  }

void case_937()
#line 6291 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new Using ((Expression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_938()
#line 6299 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		
		yyVal = new Using ((Expression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_940()
#line 6310 "cs-parser.jay"
{
		/* It has to be here for the parent to safely restore artificial block*/
	  	Error_SyntaxError (yyToken);
	  }

void case_942()
#line 6322 "cs-parser.jay"
{
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
		lbag.AddLocation (current_variable, GetLocation (yyVals[-1+yyTop]));
		yyVal = current_variable;
	  }

void case_943()
#line 6334 "cs-parser.jay"
{
		lexer.query_parsing = false;
			
		Linq.AQueryClause from = yyVals[-1+yyTop] as Linq.AQueryClause;
			
		from.Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = from;
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_944()
#line 6346 "cs-parser.jay"
{
		Linq.AQueryClause from = yyVals[-1+yyTop] as Linq.AQueryClause;
			
		from.Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = from;
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_945()
#line 6357 "cs-parser.jay"
{
	        lexer.query_parsing = false;
		yyVal = yyVals[-1+yyTop];

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_946()
#line 6364 "cs-parser.jay"
{
	        yyVal = yyVals[-1+yyTop];
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_947()
#line 6373 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var start = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (start, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (start);
	  }

void case_948()
#line 6383 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var start = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-4+yyTop])) {
			IdentifierType = (FullNamedExpression)yyVals[-3+yyTop]
		};
		lbag.AddLocation (start, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (start);
	  }

void case_949()
#line 6398 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var start = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (start, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (start);
	  }

void case_950()
#line 6408 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var start = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-4+yyTop])) {
			IdentifierType = (FullNamedExpression)yyVals[-3+yyTop]
		};
		lbag.AddLocation (start, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (start);
	  }

void case_952()
#line 6427 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		yyVal = new Linq.SelectMany ((Linq.QueryBlock)current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);

		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_954()
#line 6443 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);

		yyVal = new Linq.SelectMany ((Linq.QueryBlock)current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop])) {
			IdentifierType = (FullNamedExpression)yyVals[-4+yyTop]
		};
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_955()
#line 6462 "cs-parser.jay"
{
	  	Linq.AQueryClause head = (Linq.AQueryClause)yyVals[-1+yyTop];
		
		if (yyVals[0+yyTop] != null)
			head.Next = (Linq.AQueryClause)yyVals[0+yyTop];
				
		if (yyVals[-2+yyTop] != null) {
			Linq.AQueryClause clause = (Linq.AQueryClause)yyVals[-2+yyTop];
			clause.Tail.Next = head;
			head = clause;
		}
		
		yyVal = head;
	  }

void case_956()
#line 6477 "cs-parser.jay"
{
	  	Linq.AQueryClause head = (Linq.AQueryClause)yyVals[0+yyTop];

		if (yyVals[-1+yyTop] != null) {
			Linq.AQueryClause clause = (Linq.AQueryClause)yyVals[-1+yyTop];
			clause.Tail.Next = head;
			head = clause;
		}
		
		yyVal = head;
	  }

void case_958()
#line 6490 "cs-parser.jay"
{
		report.Error (742, GetLocation (yyVals[0+yyTop]), "Unexpected symbol `{0}'. A query body must end with select or group clause", GetSymbolName (yyToken));
		yyVal = yyVals[-1+yyTop];
	  }

void case_959()
#line 6495 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_961()
#line 6507 "cs-parser.jay"
{
		yyVal = new Linq.Select ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_962()
#line 6514 "cs-parser.jay"
{
	  	if (linq_clause_blocks == null)
	  		linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  	linq_clause_blocks.Push ((Linq.QueryBlock)current_block);
	  }

void case_963()
#line 6522 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_964()
#line 6529 "cs-parser.jay"
{
		var obj = (object[]) yyVals[0+yyTop];

		yyVal = new Linq.GroupBy ((Linq.QueryBlock)current_block, (Expression)yyVals[-2+yyTop], linq_clause_blocks.Pop (), (Expression)obj[0], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, (Location) obj[1]);
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_966()
#line 6546 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new object[2] { null, Location.Null };
	  }

void case_968()
#line 6555 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-1+yyTop]).Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-1+yyTop];
	  }

void case_975()
#line 6575 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
	  	yyVal = new Linq.Let ((Linq.QueryBlock) current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  	
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
	  }

void case_977()
#line 6594 "cs-parser.jay"
{
		yyVal = new Linq.Where ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_978()
#line 6604 "cs-parser.jay"
{
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_979()
#line 6612 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_980()
#line 6620 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_981()
#line 6628 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
	  
		var outer_selector = linq_clause_blocks.Pop ();
		var block = linq_clause_blocks.Pop ();

		var lt = (LocatedToken) yyVals[-10+yyTop];	
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		Linq.RangeVariable into;
		
		if (yyVals[0+yyTop] == null) {
			into = sn;
	  		yyVal = new Linq.Join (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, GetLocation (yyVals[-11+yyTop]));
			lbag.AddLocation (yyVal, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]));
		} else {
			/**/
			/* Set equals right side parent to beginning of linq query, it is not accessible therefore cannot cause name collisions*/
			/**/
			var parent = block.Parent;
			while (parent is Linq.QueryBlock) {
				parent = parent.Parent;
			}
			current_block.Parent = parent;
			
			((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
			lt = (LocatedToken) yyVals[0+yyTop];
			into = new Linq.RangeVariable (lt.Value, lt.Location);

			yyVal = new Linq.GroupJoin (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, into, GetLocation (yyVals[-11+yyTop]));	
			lbag.AddLocation (yyVal, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]), opt_intoStack.Pop ());
		}

		current_block = block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (into);
	  }

void case_982()
#line 6666 "cs-parser.jay"
{
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_983()
#line 6674 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_984()
#line 6682 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_985()
#line 6690 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
	  
		var outer_selector = linq_clause_blocks.Pop ();
		var block = linq_clause_blocks.Pop ();
		
		var lt = (LocatedToken) yyVals[-10+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		Linq.RangeVariable into;
		
		if (yyVals[0+yyTop] == null) {
			into = sn;		
	  		yyVal = new Linq.Join (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, GetLocation (yyVals[-12+yyTop])) {
	  			IdentifierType = (FullNamedExpression)yyVals[-11+yyTop]
	  		};
			lbag.AddLocation (yyVal, GetLocation (yyVals[-10+yyTop]), GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]));
		} else {
			/**/
			/* Set equals right side parent to beginning of linq query, it is not accessible therefore cannot cause name collisions*/
			/**/
			var parent = block.Parent;
			while (parent is Linq.QueryBlock) {
				parent = parent.Parent;
			}
			current_block.Parent = parent;
		
			((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
			lt = (LocatedToken) yyVals[0+yyTop];
			into = new Linq.RangeVariable (lt.Value, lt.Location); /* TODO:*/
			
			yyVal = new Linq.GroupJoin (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, into, GetLocation (yyVals[-12+yyTop])) {
	  			IdentifierType = (FullNamedExpression)yyVals[-11+yyTop]
	  		};			
			lbag.AddLocation (yyVal, GetLocation (yyVals[-10+yyTop]), GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), opt_intoStack.Pop ());
		}
		
		current_block = block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (into);		
	  }

void case_987()
#line 6736 "cs-parser.jay"
{
		opt_intoStack.Push (GetLocation (yyVals[-1+yyTop]));
		yyVal = yyVals[0+yyTop];
	  }

void case_988()
#line 6744 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		lbag.AddLocation (current_block, GetLocation (yyVals[0+yyTop]));
	  }

void case_989()
#line 6749 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		yyVal = yyVals[0+yyTop];
	  }

void case_991()
#line 6760 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_992()
#line 6767 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-3+yyTop]).Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-3+yyTop];
	  }

void case_994()
#line 6776 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock ((Linq.QueryBlock) current_block, lexer.Location);	 
	 }

void case_995()
#line 6783 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-3+yyTop]).Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-3+yyTop];
	 }

void case_997()
#line 6795 "cs-parser.jay"
{
		yyVal = new Linq.OrderByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_998()
#line 6800 "cs-parser.jay"
{
		yyVal = new Linq.OrderByDescending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_1000()
#line 6812 "cs-parser.jay"
{
		yyVal = new Linq.ThenByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_1001()
#line 6817 "cs-parser.jay"
{
		yyVal = new Linq.ThenByDescending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_1003()
#line 6827 "cs-parser.jay"
{
		/* query continuation block is not linked with query block but with block*/
		/* before. This means each query can use same range variable names for*/
		/* different identifiers.*/

		current_block.SetEndLocation (GetLocation (yyVals[-1+yyTop]));
		current_block = current_block.Parent;
	
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);		
	  }

void case_1004()
#line 6843 "cs-parser.jay"
{
		var current_block = linq_clause_blocks.Pop ();	  
		var lt = (LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
  		yyVal = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, null, rv, GetLocation (yyVals[-3+yyTop])) {
  			next = (Linq.AQueryClause)yyVals[0+yyTop]
  		};
	  }

void case_1007()
#line 6870 "cs-parser.jay"
{ 
		current_container = current_type = new Class (current_container, new MemberName ("<InteractiveExpressionClass>"), Modifiers.PUBLIC, null);

		/* (ref object retval)*/
		Parameter [] mpar = new Parameter [1];
		mpar [0] = new Parameter (new TypeExpression (compiler.BuiltinTypes.Object, Location.Null), "$retval", Parameter.Modifier.REF, null, Location.Null);

		ParametersCompiled pars = new ParametersCompiled (mpar);
		var mods = Modifiers.PUBLIC | Modifiers.STATIC;
		if (settings.Unsafe)
			mods |= Modifiers.UNSAFE;

		current_local_parameters = pars;
		var method = new InteractiveMethod (
			current_type,
			new TypeExpression (compiler.BuiltinTypes.Void, Location.Null),
			mods,
			pars);
			
		current_type.AddMember (method);			
		oob_stack.Push (method);

		interactive_async = false;

		++lexer.parsing_block;
		start_block (lexer.Location);
	  }

void case_1008()
#line 6898 "cs-parser.jay"
{
		--lexer.parsing_block;
		var method = (InteractiveMethod) oob_stack.Pop ();
		method.Block = (ToplevelBlock) end_block(lexer.Location);

		if (interactive_async == true) {
			method.ChangeToAsync ();
		}

		InteractiveResult = (Class) pop_current_class ();
		current_local_parameters = null;
	  }

void case_1018()
#line 6944 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedBuiltinType = (TypeExpression)yyVals[-1+yyTop];
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
		yyVal = null;
	  }

void case_1019()
#line 6950 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedBuiltinType = (TypeExpression)yyVals[-3+yyTop];
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName (lt.Value);
	  }

void case_1022()
#line 6965 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[-1+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-6+yyTop], MemberCache.IndexerNameAlias, Location.Null);
	  }

void case_1023()
#line 6970 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop] ?? new List<DocumentationParameter> (1);
		p.Add (new DocumentationParameter ((FullNamedExpression) yyVals[-1+yyTop]));
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = Operator.OpType.Explicit;
		yyVal = null;
	  }

void case_1024()
#line 6978 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop] ?? new List<DocumentationParameter> (1);
		p.Add (new DocumentationParameter ((FullNamedExpression) yyVals[-1+yyTop]));
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = Operator.OpType.Implicit;
		yyVal = null;
	  }

void case_1025()
#line 6986 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop] ?? new List<DocumentationParameter> (1);
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = (Operator.OpType) yyVals[-1+yyTop];
		yyVal = null;
	  }

void case_1033()
#line 7024 "cs-parser.jay"
{
		var parameters = new List<DocumentationParameter> ();
		parameters.Add ((DocumentationParameter) yyVals[0+yyTop]);
		yyVal = parameters;
	  }

void case_1034()
#line 7030 "cs-parser.jay"
{
		var parameters = yyVals[-2+yyTop] as List<DocumentationParameter>;
		parameters.Add ((DocumentationParameter) yyVals[0+yyTop]);
		yyVal = parameters;
	  }

void case_1035()
#line 7039 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != null)
			yyVal = new DocumentationParameter ((Parameter.Modifier) yyVals[-1+yyTop], (FullNamedExpression) yyVals[0+yyTop]);
		else
			yyVal = new DocumentationParameter ((FullNamedExpression) yyVals[0+yyTop]);
	  }

#line default
   static readonly short [] yyLhs  = {              -1,
    0,    4,    0,    0,    1,    1,    1,    1,    2,    2,
   11,   11,   12,   12,   13,   13,   14,   15,   15,   15,
   19,   20,   17,   17,   22,   22,   22,   18,   18,   18,
   23,   23,   24,   24,    7,    7,    6,    6,   21,   21,
    8,    8,   25,   25,   25,   26,   26,   26,   26,   26,
    9,    9,   10,   10,   34,   32,   37,   33,   33,   33,
   33,   35,   35,   35,   36,   36,   41,   38,   39,   40,
   40,   42,   42,   42,   42,   42,   43,   43,   43,   47,
   44,   46,   49,   49,   49,   51,   51,   52,   52,   53,
   53,   53,   53,   53,   53,   53,   53,   53,   53,   53,
   53,   53,   68,   70,   72,   73,   74,   28,   28,   77,
   54,   54,   78,   78,   79,   79,   80,   82,   76,   76,
   81,   81,   87,   55,   91,   55,   55,   86,   94,   86,
   88,   88,   95,   95,   96,   97,   96,   92,   92,   98,
   98,   99,  100,   90,   90,   93,   93,   93,  103,   56,
  106,  107,  101,  108,  109,  110,  101,  101,  101,  102,
  102,  105,  105,  113,  113,  113,  113,  113,  113,  113,
  113,  113,  113,  114,  114,  117,  117,  117,  117,  120,
  117,  118,  118,  121,  121,  122,  122,  122,  115,  115,
  115,  123,  123,  123,  116,  125,  127,  128,   57,  130,
  131,  132,   59,  126,  126,  126,  126,  126,  136,  133,
  137,  134,  135,  135,  135,  138,  139,  140,  142,   29,
   29,  141,  141,  143,  143,  144,  144,  144,  144,  144,
  144,  144,  144,  144,  147,   60,  146,  146,  148,  148,
  151,  145,  145,  150,  150,  150,  150,  150,  150,  150,
  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,
  150,  150,  150,  150,  150,  153,  152,  154,  152,  152,
  152,   61,  157,  159,  155,  156,  156,  158,  158,  163,
  161,  164,  161,  161,  161,  165,   62,  167,   58,  170,
  171,   58,   58,  166,  173,  166,  168,  168,  174,  174,
  175,  176,  175,  177,  172,  169,  169,  169,  169,  169,
  181,  178,  182,  179,  180,  180,   63,   64,  184,  186,
  187,   30,  183,  183,  183,  185,  185,  185,  188,  188,
  189,  190,  189,  189,  189,  191,  192,  193,   31,  194,
  194,   16,   16,  195,  195,  198,  197,  197,  197,  199,
  199,  201,   67,  124,  104,  104,  129,  129,  202,  202,
  202,  200,  200,  203,  203,  204,  204,  206,  206,   85,
   75,   75,   89,   89,  119,  119,  149,  149,  207,  207,
  207,  207,  207,  211,  211,  212,  210,  210,  210,  210,
  210,  210,  210,  213,  213,  213,  213,  213,  213,  213,
  213,  213,  214,  214,  214,  214,  214,  214,  214,  214,
  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,
  214,  214,  215,  215,  215,  216,  216,  216,  236,  236,
  237,  237,  238,  238,  218,  218,  235,  235,  235,  235,
  235,  235,  235,  235,  220,  220,  220,  240,  240,  241,
  241,  242,  242,  244,  244,  244,  245,  245,  245,  245,
  245,  245,  246,  246,  162,  162,  239,  239,  239,  239,
  239,  251,  251,  250,  250,  252,  252,  252,  252,  253,
  221,  221,  221,  249,  249,  254,  254,  255,  255,  222,
  223,  223,  224,  225,  226,  226,  217,  217,  217,  217,
  217,  260,  256,  227,  261,  261,  262,  262,  263,  263,
  264,  264,  264,  264,  257,  257,  208,  208,  259,  259,
  265,  265,  258,  258,   84,   84,  266,  266,  267,  228,
  268,  268,  268,  269,  269,  269,  269,  269,  270,  196,
  229,  229,  230,  230,  231,  231,  232,  272,  233,  273,
  233,  271,  271,  275,  274,  219,  276,  276,  276,  276,
  276,  276,  276,  276,  276,  277,  277,  277,  277,  277,
  277,  277,  277,  277,  277,  277,  277,  277,  278,  278,
  278,  278,  278,  278,  278,  279,  279,  279,  279,  279,
  279,  279,  279,  279,  280,  280,  280,  280,  280,  281,
  281,  281,  281,  281,  281,  281,  281,  281,  282,  282,
  282,  282,  282,  283,  283,  283,  284,  284,  284,  285,
  285,  285,  286,  286,  286,  287,  287,  287,  288,  288,
  289,  289,  289,  289,  289,  290,  290,  290,  290,  290,
  290,  290,  290,  290,  290,  290,  291,  291,  292,  292,
  292,  292,  293,  293,  295,  294,  294,  294,   50,   50,
  297,  296,  298,  296,  299,  296,  300,  301,  296,  302,
  303,  296,   45,   45,  247,  247,  247,  247,  234,  234,
  234,   83,  305,  306,  307,  308,  309,   27,   66,   66,
   65,   65,  111,  111,  310,  310,  310,  310,  310,  310,
  310,  310,  310,  310,  310,  310,  310,  310,  310,   69,
   69,   69,   71,   71,  311,  311,  312,  312,  313,  313,
  314,  314,  314,  314,  205,  205,  315,  315,  317,  112,
  318,  318,  319,  160,  160,  321,  320,  316,  316,  322,
  322,  323,  323,  323,  323,  323,  327,  327,  328,  328,
  328,  325,  325,  325,  325,  325,  325,  325,  325,  325,
  325,  325,  325,  325,  329,  329,  329,  329,  329,  329,
  329,  329,  329,  329,  329,  329,  329,  343,  343,  343,
  343,  330,  344,  326,  345,  345,  346,  346,  346,  346,
  346,  346,  209,  209,  347,   48,   48,  349,  324,  353,
  324,  351,  351,  348,  348,  348,  350,  350,  357,  357,
  356,  356,  358,  358,  352,  352,  354,  354,  359,  359,
  360,  355,  355,  355,  331,  331,  331,  342,  342,  361,
  362,  362,  332,  332,  363,  363,  363,  366,  364,  364,
  365,  365,  367,  367,  367,  368,  369,  369,  370,  370,
  370,  333,  333,  333,  333,  371,  371,  372,  372,  372,
  376,  373,  379,  375,  375,  382,  378,  378,  381,  381,
  377,  377,  385,  384,  384,  380,  380,  383,  383,  387,
  386,  386,  374,  374,  388,  374,  374,  374,  334,  334,
  334,  334,  334,  334,  389,  390,  390,  391,  391,  391,
  392,  392,  392,  393,  393,  393,  394,  394,  394,  395,
  395,  335,  335,  335,  335,  396,  396,  398,  398,  397,
  399,  397,  397,  397,  336,  337,  400,  340,  338,  338,
  402,  403,  341,  405,  406,  339,  339,  339,  404,  404,
  401,  401,  304,  304,  304,  304,  407,  407,  409,  409,
  411,  410,  412,  410,  408,  408,  408,  408,  408,  416,
  414,  417,  419,  414,  418,  418,  413,  413,  420,  420,
  420,  420,  420,  425,  421,  426,  422,  427,  428,  429,
  423,  431,  432,  433,  423,  430,  430,  435,  424,  434,
  438,  434,  437,  440,  437,  436,  436,  436,  439,  439,
  439,  415,  441,  415,    3,    3,  442,    3,    3,  443,
  443,  248,  248,  243,  243,    5,  444,  444,  444,  444,
  448,  444,  444,  444,  444,  445,  445,  446,  449,  446,
  447,  447,  450,  450,  451,
  };
   static readonly short [] yyLen = {           2,
    2,    0,    3,    1,    2,    4,    3,    1,    0,    1,
    1,    2,    4,    2,    1,    2,    1,    3,    5,    2,
    0,    0,   11,    3,    0,    1,    1,    1,    3,    1,
    0,    1,    0,    1,    0,    1,    0,    1,    0,    1,
    1,    2,    1,    1,    2,    1,    1,    1,    1,    1,
    0,    1,    1,    2,    0,    3,    0,    6,    3,    2,
    1,    1,    1,    1,    1,    3,    0,    3,    1,    0,
    3,    0,    1,    1,    3,    3,    1,    1,    1,    0,
    4,    4,    0,    1,    1,    0,    1,    1,    2,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    0,    0,    0,    0,    0,   16,    5,    0,
    9,    5,    0,    1,    1,    2,    3,    0,    3,    1,
    1,    1,    0,    8,    0,    9,    6,    0,    0,    3,
    0,    1,    1,    2,    2,    0,    5,    0,    1,    1,
    2,    3,    0,    4,    2,    1,    1,    1,    0,    3,
    0,    0,   10,    0,    0,    0,   12,    8,    5,    1,
    1,    0,    1,    1,    3,    3,    3,    5,    3,    5,
    1,    1,    1,    1,    3,    4,    6,    2,    4,    0,
    7,    0,    1,    1,    2,    1,    1,    1,    4,    6,
    4,    1,    2,    2,    1,    0,    0,    0,   10,    0,
    0,    0,   13,    1,    2,    1,    2,    1,    0,    5,
    0,    5,    1,    1,    1,    0,    0,    0,    0,   15,
    5,    0,    1,    1,    2,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    0,    5,    1,    1,    1,    1,
    0,    7,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    0,    7,    0,    7,    2,
    2,    2,    0,    0,    9,    1,    1,    0,    1,    0,
    6,    0,    6,    2,    1,    0,    8,    0,    9,    0,
    0,   10,    5,    0,    0,    3,    0,    1,    1,    2,
    2,    0,    5,    0,    2,    2,    2,    1,    1,    1,
    0,    5,    0,    5,    1,    1,    2,    4,    0,    0,
    0,   12,    0,    2,    2,    0,    1,    2,    1,    3,
    2,    0,    5,    3,    1,    0,    0,    0,   13,    0,
    1,    1,    3,    1,    4,    2,    0,    3,    2,    1,
    3,    0,    3,    1,    1,    3,    1,    2,    3,    4,
    4,    0,    3,    1,    3,    3,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    2,    2,    2,
    2,    2,    2,    1,    3,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    2,    2,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    3,    3,    4,    4,    4,    3,
    3,    4,    3,    4,    4,    4,    3,    0,    1,    3,
    4,    0,    1,    1,    3,    2,    3,    3,    1,    2,
    3,    2,    1,    1,    0,    1,    1,    3,    3,    3,
    2,    1,    1,    1,    1,    2,    2,    4,    3,    1,
    4,    4,    3,    1,    3,    1,    3,    1,    1,    1,
    4,    3,    2,    2,    6,    3,    7,    4,    3,    7,
    3,    0,    2,    4,    1,    2,    0,    1,    1,    3,
    3,    1,    1,    1,    0,    1,    1,    2,    2,    3,
    1,    2,    0,    1,    2,    4,    1,    3,    0,    5,
    1,    1,    1,    2,    3,    3,    4,    4,    1,    2,
    4,    4,    4,    2,    4,    2,    4,    0,    4,    0,
    5,    0,    1,    0,    4,    4,    1,    2,    2,    4,
    2,    2,    2,    4,    2,    1,    2,    2,    2,    2,
    2,    2,    2,    2,    2,    2,    2,    2,    1,    3,
    3,    3,    3,    3,    3,    1,    3,    3,    3,    3,
    3,    3,    3,    3,    1,    3,    3,    3,    3,    1,
    3,    3,    3,    3,    3,    3,    3,    3,    1,    3,
    3,    3,    3,    1,    3,    3,    1,    3,    3,    1,
    3,    3,    1,    3,    3,    1,    3,    3,    1,    3,
    1,    5,    4,    5,    5,    3,    3,    3,    3,    3,
    3,    3,    3,    3,    3,    3,    1,    3,    3,    2,
    1,    1,    0,    1,    0,    2,    1,    1,    1,    1,
    0,    4,    0,    4,    0,    5,    0,    0,    7,    0,
    0,    8,    1,    1,    1,    1,    1,    1,    6,    4,
    4,    1,    1,    0,    0,    0,    0,   15,    0,    1,
    0,    1,    1,    2,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    0,
    2,    3,    0,    1,    1,    2,    4,    3,    1,    3,
    1,    3,    1,    1,    0,    1,    1,    1,    0,    4,
    1,    1,    0,    4,    1,    0,    4,    0,    1,    1,
    2,    1,    1,    1,    2,    1,    1,    2,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    0,    4,    1,    2,    2,    2,    2,    2,
    2,    1,    1,    2,    1,    1,    1,    0,    6,    0,
    7,    1,    1,    0,    2,    1,    0,    1,    0,    1,
    1,    2,    2,    4,    0,    2,    0,    1,    1,    2,
    4,    1,    5,    2,    2,    2,    2,    2,    2,    1,
    1,    1,    1,    1,    5,    7,    4,    0,    8,    4,
    0,    1,    1,    2,    1,    2,    1,    2,    3,    3,
    1,    1,    1,    1,    1,    5,    4,    7,    3,    6,
    0,    4,    0,    4,    2,    0,    4,    2,    3,    1,
    0,    1,    0,    5,    1,    0,    1,    0,    1,    1,
    1,    3,    4,    5,    0,    9,    5,    4,    1,    1,
    1,    1,    1,    1,    2,    2,    2,    3,    4,    3,
    3,    3,    2,    3,    3,    2,    4,    4,    3,    0,
    1,    3,    4,    5,    3,    1,    2,    0,    1,    2,
    0,    7,    3,    6,    2,    2,    0,    3,    5,    4,
    0,    0,   10,    0,    0,    9,    5,    4,    2,    1,
    0,    2,    2,    2,    2,    2,    4,    5,    4,    5,
    0,    5,    0,    6,    3,    2,    2,    2,    1,    0,
    3,    0,    0,    5,    2,    1,    1,    2,    1,    1,
    1,    1,    1,    0,    5,    0,    3,    0,    0,    0,
   12,    0,    0,    0,   13,    0,    2,    0,    3,    1,
    0,    4,    1,    0,    4,    1,    2,    2,    1,    2,
    2,    0,    0,    4,    2,    3,    0,    4,    2,    2,
    3,    0,    1,    1,    1,    2,    2,    2,    4,    3,
    0,    7,    4,    4,    3,    1,    3,    0,    0,    4,
    0,    1,    1,    3,    2,
  };
   static readonly short [] yyDefRed = {            0,
    8,    0,    0,    0,    0,    0,    0,    0,    2,    4,
    0,    0,   11,   14,    0, 1005,    0,    0, 1009,    0,
    0,   15,   17,  389,  395,  402,  390,  392,    0,  391,
    0,  398,  400,  387,    0,  394,  396,  388,  399,  401,
  397,  352, 1026,    0,  393, 1016,    0,   10,    1,    0,
    0,    0,   12,    0,  832,    0,    0,    0,    0,    0,
    0,    0,    0,  430,    0,    0,    0,    0,    0,    0,
    0,  428,    0,    0,    0,  490,    0,  429,    0,  529,
    0,  927,    0,    0,    0,  678,    0,    0,    0,    0,
    0,    0,    0,  729,    0,  782,    0,    0,    0,    0,
    0,    0,    0,    0,  427,    0,  667,    0,  831,    0,
  765,    0,    0,    0,    0,  404,  405,  406,  407,  408,
  409,  410,  411,  412,  413,  414,  415,  416,  417,  418,
  419,  420,  421,  422,  425,  426,  674,  566,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  675,  673,  676,  677,  749,  751,    0,  747,  750,  766,
  768,  769,  770,  771,  772,  773,  774,  775,  776,  777,
  767,    0,    0,    0,  833,  834,  852,  853,  854,  855,
  889,  890,  891,  892,  893,  894,    0,    0,    0,   20,
    0,    0,  342,    0,  344, 1013,   16, 1006,    0,    0,
  249,  248,  245,  250,  251,  244,  263,  262,  255,  256,
  252,  254,  253,  257,  246,  247,  258,  259,  265,  264,
  260,  261,    0,    0, 1029,    0, 1018,    0, 1017,    3,
   55,    0,    0,    0,   44,   41,   43,   46,   47,   48,
   49,   50,   53,   13,    0,    0,    0,  895,  544,  431,
  432,  925,    0,    0,    0,    0,    0,    0,    0,  897,
  896,    0,  554,  548,  553,  781,  830,  752,  779,  778,
  780,  753,  754,  755,  756,  757,  758,  759,  760,  761,
  762,  763,  764,    0,    0,    0,  861,    0,    0,    0,
  797,  796,    0,    0,    0,    0,    0,    0,    0,    0,
  903,    0,    0,    0,    0,  403,    0,    0,    0,  906,
    0,    0,    0,    0,  546,  926,    0,    0,    0,  795,
  791,    0,    0,    0,    0,    0,    0,    0,  371,    0,
    0,    0,    0,    0,    0,    0,    0,  670,    0,  565,
  663,    0,  561,    0,    0,  563,  559,  573,  567,  574,
  568,  562,  558,  578,  572,  577,  571,  575,  569,  576,
  570,  661,  540,    0,  424,  423,    0,    0,    0,    0,
    0,  783,    0,  341,    0,  789,  790,    0,  493,  494,
    0,    0,    0,  787,  788,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1008,  748,
  798,  786,    0,  828,  829,  959,  976,    0,    0,  960,
  962,    0,  988,  945,  943,  969,    0,    0,  967,  970,
  971,  972,  973,  946,  944,    0,    0,    0,  346,    0,
   18,    0,    0,    0, 1025,    0,  353,    0,    0,    0,
 1027,    0,    0,   42,  700,  706,  698,    0,  695,  705,
  699,  697,  696,  703,  701,  702,  708,  704,  707,  709,
    0,    0,  693,   45,   54,  492,    0,  488,  489,    0,
    0,  486,    0,  800,    0,    0,    0,  859,    0,  827,
  825,  826,    0,    0,    0,  682,    0,  900,  898,  683,
    0,    0,  514,    0,    0,    0,    0,  505,    0,  509,
  519,  521,    0,  501,    0,    0,    0,    0,    0,  496,
    0,  499,    0,  503,  373,  902,  901,    0,    0,  905,
  904,  915,    0,    0,    0,  916,    0,    0,  928,    0,
    0,  794,    0,  383,  379,  380,    0,    0,  378,  381,
  382,    0,    0,    0,  579,    0,    0,  550,    0,  665,
    0,  746,    0,    0,    0,  740,  742,  743,  744,  435,
  436,    0,  349,  350,    0,  187,  186,  188,    0,  652,
    0,    0,    0,  375,    0,  647,    0,    0,  909,    0,
    0,    0,  440,    0,  443,    0,    0,  441,    0,    0,
  483,    0,  447,    0,    0,    0,    0,  472,  475,    0,
    0,  467,  474,  473,  636,  637,  638,  639,  640,  641,
  642,  643,  644,  646,  645,  583,  580,  585,  582,  584,
  581,  593,  589,  594,  590,  591,    0,  592,    0,  598,
    0,  599,    0,  605,    0,  606,    0,  607,    0,  608,
    0,  612,    0,  613,    0,  616,    0,  619,    0,  622,
    0,  625,    0,  628,    0,  630,    0,    0,  518,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  958,  957,
    0,  968,    0,  956,    0,    0,  343, 1023, 1024,  367,
    0,    0,    0,  364,    0,    0,  184,    0,    0, 1033,
 1019, 1021,   61,   63,   64,    0,    0,   56,    0,    0,
   65,   67,   30,   28,    0,    0,    0,  690,    0,  694,
  439,    0,  491,    0,  543,    0,  556,  173,  195,    0,
    0,    0,  163,    0,    0,    0,  174,  549,    0,  931,
    0,  881,  862,    0,  872,    0,  883,    0,  899,  837,
    0,  930,    0,    0,  504,    0,  520,  522,    0,    0,
    0,  459,    0,    0,  454,    0,    0,  660,  659,  484,
    0,  524,  498,    0,    0,  148,  525,  146,  147,  527,
    0,  542,  541,  840,    0,  920,    0,  913,    0,  917,
  533,    0,    0,    0,  368,    0,  531,    0,    0,  545,
  938,    0,  934,  857,    0,  949,    0,  947,    0,    0,
  680,  681,    0,    0,    0,  658,  657,  664,    0,  745,
  731,  732,  730,  741,  662,    0,  348,  650,    0,    0,
    0,  564,  560,  908,  907,  784,  444,  438,  442,  437,
  547,  482,  481,  480,  477,  476,    0,  471,  433,  434,
  445,  446,    0,  633,    0,  806,    0,    0,  977,  951,
    0,  978,    0,  961,  963,  974,    0,  989,    0,  955,
 1003,   19,  345,  728,  727,    0,  726,    0,  363, 1035,
  185, 1030,    0,    0,   60,   57,    0,    0,    0,    0,
    0,    0,  370,    0,  684,    0,    0,   85,   84,    0,
  487,    0,    0,    0,    0,    0,  178,  555,    0,    0,
    0,    0,    0,  873,  865,  863,    0,  884,    0,    0,
  929,  511,  510,    0,  462,    0,    0, 1014, 1015,  450,
  456,    0,  460,    0,    0,    0,    0,    0,    0,  838,
  923,    0,  914,    0,  539,  534,    0,    0,  530,    0,
  937,    0,  856,  950,  948,    0,  551,    0,  666,  656,
  351,  649,  648,  668,  479,    0,  470,  469,  468,  634,
  635,  632,    0,  822,  805,    0,    0,    0,  811,    0,
  953,    0,  982,    0,    0,  997,  998,  991,    0,  366,
  365, 1034,    0,    0,   66,   59,    0,   68,   29,   22,
    0,    0,  319,    0,  221,    0,  109,    0,   82,  816,
  121,  122,    0,    0,    0,  819,  193,  194,    0,    0,
    0,    0,  166,  175,  167,  169,  860,    0,    0,    0,
    0,    0,  882,    0,    0,  463,  464,  458,  461,  457,
  451,  455,    0,  516,    0,  485,  495,  449,  528,  526,
    0,  919,    0,    0,    0,  535,    0,  940,    0,    0,
  679,  671,    0,  478,    0,    0,  803,  802,  799,  812,
  952,    0,    0,    0,  966,    0,  964,  975,    0, 1004,
 1022,    0,   79,    0,    0,   73,   74,   77,   78,    0,
  336,  325,  324,    0,  685,  217,  104,    0,  801,  820,
  179,    0,  191,    0,    0,    0,  858,  942,    0,    0,
    0,    0,  864,    0,  885,  836,  500,  497,  845,    0,
  851,    0,    0,  843,    0,  847,    0,  538,  537,  939,
  935,    0,  669,    0,    0,  954,  979,    0,  965,    0,
    0,  993,    0,   80,   71,    0,    0,    0,  320,    0,
    0,    0,    0,    0,  180,    0,  170,  168,  932,  874,
  868,  866,    0,    0,  839,  844,    0,  848,  924,    0,
    0,  672,    0,  814,    0,  983, 1000, 1001,  994,   58,
    0,   75,   76,    0,    0,    0,    0,    0,    0,    0,
  821,  177,    0,  190,    0,    0,  886,  850,  849,  736,
  922,  936,  823,    0,    0,    0,   81,    0,    0,  337,
    0,    0,  335,  321,    0,  329,  386,    0,  384,    0,
  686,    0,  715,  218,  105,  181,  933,  870,  867,    0,
    0,  879,    0,  980,    0,  995,    0,    0,    0,  317,
    0,    0,  712,    0,    0,    0,  716,    0,    0,    0,
    0,    0,  984,   27,   26,   23,  338,  334,    0,    0,
  330,  385,  718,    0,    0,    0,  106,  869,  737,    0,
    0,    0,    0,   32,  322,  723,    0,  724,  721,    0,
  719,  102,    0,   99,    0,    0,   88,   90,   91,   92,
   93,   94,   95,   96,   97,   98,  100,  101,  149,    0,
    0,  234,  226,  227,  228,  229,  230,  231,  232,  233,
    0,    0,  224,    0,    0,  981,    0,  339,  333,    0,
    0,    0,  687,   89,    0,  733,  735,  277,  272,  276,
    0,  219,  225,    0,  987,  985,  722,  720,    0,    0,
    0,    0,    0,    0,    0,  286,    0,    0,  235,    0,
    0,  243,    0,  161,  150,  160,    0,    0,    0,  107,
    0,    0,  271,    0,    0,  270,    0,  154,    0,    0,
  357,  318,    0,  355,    0,    0,  196,    0,    0,    0,
    0,    0,  688,    0,  220,    0,  112,  110,  293,    0,
  354,    0,    0,    0,    0,  125,    0,    0,    0,    0,
    0,    0,  159,  151,    0,    0,  200,    0,  358,    0,
  238,  237,  236,    0,  734,  108,    0,  290,    0,  268,
  127,    0,  266,    0,    0,    0,  129,    0,  359,    0,
    0,  197,    0,    0,    0,  356,  241,  120,  118,    0,
    0,  295,    0,    0,    0,    0,    0,  155,    0,  274,
    0,    0,    0,    0,  133,    0,    0,    0,    0,  360,
  361,    0,    0,    0,    0,    0,  115,  310,    0,  291,
    0,    0,  304,    0,    0,    0,  299,    0,  145,    0,
    0,    0,    0,  140,    0,    0,  287,    0,  130,    0,
  124,  134,  152,  158,  208,    0,  198,    0,    0,  201,
    0,  119,    0,  111,  116,    0,    0,    0,  306,    0,
  307,  296,    0,    0,  289,  300,  269,    0,    0,  126,
  141,  267,    0,  285,    0,  275,  279,  136,    0,    0,
    0,  205,  207,    0,  242,  117,  311,  313,  292,    0,
    0,  305,  302,  144,  142,  156,  284,    0,    0,    0,
  153,  209,  211,  199,    0,    0,    0,  304,    0,  280,
  282,  137,    0,    0,  202,  315,  316,  312,  314,  303,
  157,    0,    0,  215,  214,  213,  210,  212,    0,    0,
    0,  203,  281,  283,
  };
  protected static readonly short [] yyDgoto  = {             7,
    8,   49,    9,   50,   10,   11,   51,  232,  740,  702,
   12,   13,   52,   22,   23,  326,  235,  725,  901, 1100,
 1219, 1266, 1576,  898,  236,  237,  238,  239,  240,  241,
  242,  243,  718,  462,  719,  720, 1004,  721,  722, 1008,
  899, 1095, 1096, 1097,  267,  619, 1191,  110,  910,  780,
 1295, 1296, 1297, 1298, 1299, 1300, 1301, 1302, 1303, 1304,
 1305, 1306, 1307, 1308,  481,  729, 1384, 1018, 1198, 1162,
 1231, 1259, 1324, 1396, 1227, 1450, 1427, 1475, 1476, 1477,
 1020, 1473, 1021,  789,  902, 1438, 1411, 1463,  534, 1456,
 1432, 1492,  984, 1461, 1464, 1465, 1560, 1493, 1494, 1490,
 1309, 1365, 1335, 1385,  742, 1440, 1539, 1408, 1496, 1569,
  482,  268,  743,  744,  745,  746,  747,  705,  592, 1203,
  706,  707,  916, 1387, 1416, 1507, 1468, 1541, 1388, 1443,
 1544, 1589, 1508, 1509, 1587, 1573, 1574, 1016, 1161, 1258,
 1321, 1369, 1322, 1323, 1359, 1423, 1391, 1360,  329,  223,
 1472, 1362, 1457, 1454, 1310, 1339, 1380, 1536, 1498, 1340,
 1537,  620, 1582, 1583, 1379, 1453, 1429, 1485, 1480, 1451,
 1517, 1522, 1483, 1486, 1487, 1568, 1523, 1481, 1482, 1578,
 1566, 1567, 1013, 1104, 1224, 1196, 1251, 1225, 1226, 1269,
 1158, 1248, 1282,  555,  193,  112,  366,  195,  585,  457,
  224, 1403,  703,  704,  886,  903,  330,  422,  554,  305,
 1228, 1229,   45,  114,  306,  116,  117,  118,  119,  120,
  121,  122,  123,  124,  125,  126,  127,  128,  129,  130,
  131,  132,  133,  134,  135,  136,  253,  861,  785, 1057,
 1047,  773,  940,  774,  775, 1048,  137,  198,  781,  622,
  623,  624,  855,  491,  492,  298, 1055,  783,  423,  300,
  517,  518,  519,  520,  523,  791,  314,  808,  809,  956,
  264,  497,  823,  265,  496,  138,  139,  140,  141,  142,
  143,  144,  145,  146,  147,  148,  149,  150,  151,  152,
  595,  596,  597,  828,  829,  153,  582,  571,  825,  367,
 1073,  569, 1142,  154,  511, 1014, 1160, 1256, 1363,  483,
 1232, 1233, 1290, 1291,  887,  574,  344,  833, 1367, 1211,
 1243,  575,  576,  269,  270,  271,  157,  158,  159,  272,
  273,  274,  275,  276,  277,  278,  279,  280,  281,  282,
  283,  171,  284,  602,  172,  173,  322,  868,  678,  987,
 1079,  913,  736, 1024,  985,  988, 1120,  989, 1025, 1026,
  285,  174,  175,  176, 1132, 1061, 1133, 1134, 1135, 1136,
  177,  178,  179,  180,  753,  504,  754, 1123, 1042, 1124,
 1239, 1206, 1240,  755, 1041,  756, 1242, 1173,  181,  182,
  183,  184,  185,  186,  307,  545,  546, 1063, 1180,  318,
 1040,  923, 1205, 1070,  962, 1181,  187,  435,  188,  436,
  990, 1082,  437,  438,  694,  685,  686, 1087,  994,  439,
  440,  441,  442,  443,  995,  680,  992, 1185, 1262, 1326,
 1084, 1215, 1281,  878,  688,  879, 1151, 1089, 1152, 1216,
  999,   17,   19,   46,   47,  227,  708,  894,  458,  709,
  710,
  };
  protected static readonly short [] yySindex = {         -100,
    0, -179, -141,  -43,   33,17069,    0,  162,    0,    0,
   33,  -43,    0,    0,   19,    0, 7076,   33,    0, -164,
   63,    0,    0,    0,    0,    0,    0,    0,  180,    0,
  191,    0,    0,    0, 3956,    0,    0,    0,    0,    0,
    0,    0,    0,  700,    0,    0,  726,    0,    0,  162,
  224,   33,    0,  184,    0,  333,  251, -183,16498,  -63,
 -266,  288, 7233,    0, -266, -266, -266, -185, -266, -266,
  757,    0, 9077, -266, -266,    0, 9234,    0,  319,    0,
 -163,    0, -266,  420, -266,    0,17088,17088,  450, -266,
 -266,   17,10307,    0,15737,    0,10438,10569,10700,10831,
10962,11093,11224,11355,    0,  151,    0, 8035,    0,  205,
    0,  123,  434,  437,  337,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1080,  795,
  227, -258,  588,  389,  460,  478,  504,  523, -274,  564,
    0,    0,    0,    0,    0,    0, 3657,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  123,  612, -286,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  225,  272,  224,    0,
  445,  219,    0,  608,    0,    0,    0,    0, 8035, 8035,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  635,  596,    0,  617,    0, -236,    0,    0,
    0,  224, 1481,  487,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  790,  123,15873,    0,    0,    0,
    0,    0,15737, -197, -161,  778,  370,  437,  123,    0,
    0, 8035,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, -180,  215,16498,    0, 8035,15737,  692,
    0,    0,  703,15737,15737,14106,  677, -201,  718, 8192,
    0,10307,  151,  835,  721,    0,  739, 8035,15737,    0,
  882,  769,  536, -266,    0,    0,15737,  319,15329,    0,
    0,  420,15737,  420, -276,  530,  863,  123,    0,  612,
  337,  868,  123,15737,15737,15737,  288,    0,  841,    0,
    0,11486,    0, 7390, -264,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1406,    0,    0,16895, -276,  817,  816,
15737,    0,  783,    0,  181,    0,    0,  254,    0,    0,
  784, 9391, 7704,    0,    0,15737,15737,15737,15737,15737,
15737,15737,15737,15737,15737,15737,11617,11748,11879, 4222,
 4540,12010,12141,12272,12403,12534,12665,12796,12927,13058,
13189,13320,13451,13582,13713,13844,16281,15737,    0,    0,
    0,    0,  612,    0,    0,    0,    0,17088,17088,    0,
    0,  123,    0,    0,    0,    0,  489,  856,    0,    0,
    0,    0,    0,    0,    0,  224,  487,  823,    0,  826,
    0,  783,  635,  635,    0,  129,    0,  539,  635,  881,
    0, -111, 1481,    0,    0,    0,    0, -158,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  289,17624,    0,    0,    0,    0,  783,    0,    0,  840,
  732,    0,  885,    0,  896,  198,  319,    0, -266,    0,
    0,    0,  123,15329, -176,    0,  878,    0,    0,    0,
   53,  100,    0,  370,  894,    0,  910,    0,  906,    0,
    0,    0,  742,    0, 8447,  744, 9548,  718,15193,    0,
 7861,    0,  420,    0,    0,    0,    0,  106,  125,    0,
    0,    0,  214,  319,  499,    0, 1129,  915,    0,  143,
  123,    0,  146,    0,    0,    0,15737,  988,    0,    0,
    0,15737,  994,  916,    0,  917,  919,    0,16895,    0,
   84,    0, -125,  127, 7390,    0,    0,    0,    0,    0,
    0,   84,    0,    0, -267,    0,    0,    0,  420,    0,
 -276,  123, 8623,    0,  918,    0,  921,13975,    0, 1038,
  920, 7390,    0,  869,    0,  783,  875,    0,  783,  783,
    0, -168,    0,15737,15737,  928, 1046,    0,    0,  201,
 -131,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  795,    0,  795,    0,
  227,    0,  227,    0, -258,    0, -258,    0, -258,    0,
 -258,    0,  588,    0,  588,    0,  389,    0,  460,    0,
  478,    0,  504,    0,  523,    0,   54, -155,    0, 9548,
 1014,  123, 1017,  123, 9548, 9548,  931,15737,    0,    0,
  856,    0,  123,    0,  534,  783,    0,    0,    0,    0,
  223,  224,  322,    0, 8623,  539,    0,  941,  940,    0,
    0,    0,    0,    0,    0,  -98,  942,    0,  945,  943,
    0,    0,    0,    0,  948, 8780,  898,    0, -162,    0,
    0,  631,    0,15873,    0,  949,    0,    0,    0,  577,
  131,  950,    0,  952,  958,  969,    0,    0,15737,    0,
  123,    0,    0,  764,    0,  971,    0,  372,    0,    0,
 7233,    0, 7233, 8606,    0,14106,    0,    0,10176, 8763,
  271,    0,  134,  102,    0,  895,  923,    0,    0,    0,
  767,    0,    0,  975,  976,    0,    0,    0,    0,    0,
  978,    0,    0,    0,  982,    0, 4699,    0,  319,    0,
    0,  420,  562,  932,    0,  150,    0,  983,  984,    0,
    0, 7233,    0,    0, 7233,    0,15737,    0,15737, 8035,
    0,    0,  319,  986,   84,    0,    0,    0,15737,    0,
    0,    0,    0,    0,    0, 8035,    0,    0,  123,16895,
 1020,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,15057,    0,    0,    0,
    0,    0, 8018,    0, 8920,    0, 8175,  992,    0,    0,
 1066,    0, 1073,    0,    0,    0,  797,    0,  996,    0,
    0,    0,    0,    0,    0,  953,    0,  129,    0,    0,
    0,    0,  539,  539,    0,    0,  823,  998, 1002,  956,
 1008,  898,    0, 1001,    0, 1121, 1122,    0,    0, 9548,
    0,15465, 1005,  577, 8623, 8035,    0,    0, -227, 1124,
 1126,  164, 1003,    0,    0,    0,15737,    0,15737, 1103,
    0,    0,    0,15601,    0,  451,15601,    0,    0,    0,
    0, 8311,    0, 1131,  612, 9548, 1021, 8606, 1022,    0,
    0,  123,    0,  266,    0,    0,  783,  932,    0,  123,
    0,   82,    0,    0,    0, 1019,    0, 1049,    0,    0,
    0,    0,    0,    0,    0,  801,    0,    0,    0,    0,
    0,    0, 8192,    0,    0,  123,  486,  992,    0, 9548,
    0, 9548,    0,  165, 9548,    0,    0,    0,  743,    0,
    0,    0, 1025,  823,    0,    0, 9705,    0,    0,    0,
 1018, 4864,    0,  898,    0,  898,    0,  898,    0,    0,
    0,    0,  123, 1024, 1005,    0,    0,    0, -174, -147,
 1023, 1027,    0,    0,    0,    0,    0, 1030, 8606,  992,
 -155,15737,    0, 1026, 7233,    0,    0,    0,    0,    0,
    0,    0, 1041,    0,  718,    0,    0,    0,    0,    0,
 -184,    0, 1040,  783,  932,    0,  932,    0,  992, 1042,
    0,    0,   84,    0,  990, 1037,    0,    0,    0,    0,
    0, 9548, 1074, 9548,    0, 9548,    0,    0,15737,    0,
    0,  943,    0,  302,  813,    0,    0,    0,    0,  -43,
    0,    0,    0, 1053,    0,    0,    0, 1044,    0,    0,
    0,  383,    0, 1045, 1166, 1167,    0,    0,  992, 1056,
  992, 1058,    0, 1059,    0,    0,    0,    0,    0,15737,
    0, 1064, -138,    0, 6917,    0, 1180,    0,    0,    0,
    0,   84,    0,15737, 8175,    0,    0, 1090,    0,  811,
 1065,    0, 1068,    0,    0, 9705,   33,  198,    0, 1067,
 1067, 1067,15465, 1076,    0,15737,    0,    0,    0,    0,
    0,    0, 7233,   74,    0,    0, 7390,    0,    0, 1083,
 7233,    0, 1084,    0, 9548,    0,    0,    0,    0,    0,
15737,    0,    0,  224, 1071,  224, 8035, 1114, 1114, 1114,
    0,    0,15737,    0, 7233, 9862,    0,    0,    0,    0,
    0,    0,    0, 1107, 9548,15737,    0,  224, 1089,    0,
 1047,  574,    0,    0, 1088,    0,    0,  103,    0, 1051,
    0, 1114,    0,    0,    0,    0,    0,    0,    0, 1092,
  971,    0, 7390,    0, 1123,    0,   41, 1114, 1214,    0,
 1104,  224,    0, 8035,   78, 1108,    0, 1109, 1110, 7233,
 1111, 9548,    0,    0,    0,    0,    0,    0, 1097, 1105,
    0,    0,    0,16577,  137,  224,    0,    0,    0, 1137,
 9548, 1118,15737,    0,    0,    0, 1132,    0,    0, 1134,
    0,    0,17624,    0, 1127,  137,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  621,
17624,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1143,  224,    0,  137,  123,    0, 1137,    0,    0, 1125,
16577,16743,    0,    0,  515,    0,    0,    0,    0,    0,
16775,    0,    0, 1144,    0,    0,    0,    0, 8035, 8035,
   83, 8192,  419,  420, 1176,    0, -276,14925,    0, 1209,
    0,    0, 1105,    0,    0,    0, 7390,14963, 1105,    0,
 -145, -144,    0, 8035, -137,    0, 8035,    0, 1099, 1148,
    0,    0, -276,    0,   55,14993,    0, 1146, 1112,  119,
  554, 3956,    0, 1153,    0, 1105,    0,    0,    0, -276,
    0, 1155, 1113, 1152, 1151,    0, 1157, 1115, 1158,  198,
 1154, 1159,    0,    0, 1163, 1171,    0,  783,    0,  604,
    0,    0,    0, 1168,    0,    0,   87,    0, 1160,    0,
    0, 1173,    0, 1174, 1172, 1178,    0, 1177,    0,  198,
  198,    0,  198, 1175, 1179,    0,    0,    0,    0, 1184,
  183,    0, 1185,  198, 1290, 1186,  198,    0,  515,    0,
 8606, 1135, 1191, 1177,    0, 1182, 1189,  189, 1192,    0,
    0,  198,15465, 1150, 1193, 1184,    0,    0,17624,    0,
  224,  224,    0, 1156, 1194, 1185,    0, 1199,    0,15737,
 1161, 1197, 1186,    0, 1203,  198,    0,   91,    0, 1195,
    0,    0,    0,    0,    0,17624,    0,  189,  189,    0,
 1205,    0,   87,    0,    0,   97, 1210,17624,    0,17624,
    0,    0, 8606, 1202,    0,    0,    0, 1215, 1173,    0,
    0,    0, 1212,    0,  287,    0,    0,    0, 1114,  814,
 1218,    0,    0, 1221,    0,    0,    0,    0,    0, 1286,
 1339,    0,    0,    0,    0,    0,    0, 1232, 1233, 8606,
    0,    0,    0,    0,  189,  580,  580,    0, 1114,    0,
    0,    0,   24,   24,    0,    0,    0,    0,    0,    0,
    0,15193,15193,    0,    0,    0,    0,    0, 1237, 1234,
 1235,    0,    0,    0,
  };
  protected static readonly short [] yyRindex = {         3086,
    0,    0, 7547, 3086,    0,    0,    0, 1608,    0,    0,
 3272, 1804,    0,    0,    0,    0,    0, 3272,    0,    0,
   44,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1609,    0,    0, 1609,    0,    0, 1608,
 3315, 3155,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1245,    0,    0,    0,    0,    0,    0,    0,    0,
 8937,    0, 1240,    0,    0,    0, 1240,    0,    0,    0,
    0,    0,    0,  310,    0,    0,    0,    0,    0,    0,
    0,    0,  233,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 4857,    0,    0,    0,    0,
    0,    0,  311, 4950, 4292,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 5106, 5174,
 5414, 5618, 5958, 1839, 6230, 6366, 6502, 6638, 1243,  524,
    0,    0,    0,    0,    0,    0,   44,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  294,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 3378,    0,
  603,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1609,   67,    0,    0,    0,    0,    0,    0,
    0, 3425,  632, 3492,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 3903,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1246,    0,    0,    0,    0,
    0,    0, 3903, 1244,    0,    0,    0,    0,    0,    0,
 1244,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 2404,    0, 2768,  341, 2534,    0,    0,    0, 2664,
 2534,    0,    0,    0,    0,    0, 1245,    0,    0,    0,
    0,    0,    0,  208,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1249, 1674,    0,    0,
 1240,    0, 3903,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  235,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1964,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 4024,    0,    0,
    0,    0,    0,    0,    0, 3535, 3578,    0,    0,    0,
    0, 2258, 1609, 1609,    0, -207,    0, 7721, 1609, 1622,
    0,    0,  207,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  425,16430,    0,    0,    0,    0, 3903,    0,    0,    0,
    0,    0,    0,    0,    0,16819,    0,    0,    0,    0,
    0,    0,    0,  771,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  836,  682,  936,    0,    0, 1255,    0,
    0,    0,    0,    0,  226,    0,    0, 4380, 1252,    0,
    0,    0,   42,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1581,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1249,    0,
16009,    0, 6757,    0,  252,    0,    0,    0,    0,    0,
    0,16009,    0,    0,    0,    0,    0,    0,  -28,    0,
  680,    0,    0,    0, 1253,    0,    0,    0,    0, 1244,
    0,    0,    0, 3744,    0, 3903, 3744,    0, 3903, 4539,
    0,    0,    0,    0,    0, -195,    0,    0,    0,    0,
  238,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 5278,    0, 5346,    0,
 5482,    0, 5550,    0, 5686,    0, 5754,    0, 5822,    0,
 5890,    0, 6026,    0, 6094,    0, 6162,    0, 6298,    0,
 6434,    0, 6570,    0, 6694,    0,    0,  660,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 4024,    0,    0,    0,    0, 2258,    0,    0,    0,    0,
 1208,14268,    0,    0,    0, 9094,    0,    0,  818,    0,
    0,    0,    0,    0,    0,  760,  687,    0,    0, 1257,
    0,    0,    0,    0, 3023,    0,    0,    0,    0,    0,
    0,10019,    0,    0,    0,  820,    0,    0,    0, 9251,
16966,    0,    0,  831,  846,  849,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  772,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1260,    0,    0,    0,    0,
 3810,    0,    0,  258,    0,   99, 4062,    0,    0,    0,
    0,    0,    0,    0, 1258,    0,    0,    0,    0,    0,
 1261,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  260,  626,    0,    0,    0,    0,    0, 1262,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,16009,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  618,    0,    0,
    0,    0,    0,    0,    0,    0, -177,    0,  613,    0,
    0,    0,    0,    0,    0,    0,    0, -207,    0,    0,
    0,    0, 9251, 7878,    0,    0, 1268,    0,  780,    0,
    0,    0,    0, 1265,    0, 1241, 1242,    0,    0,    0,
    0,    0, 1263, 9408,    0,    0,    0,    0,16998,    0,
    0,    0,  834,    0,    0,    0,    0,    0,    0, 2132,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 4221,    0, 4698, 1288,    0,    0,
    0,  950,    0,    0,    0,    0, -240,    0,    0,    0,
    0,  834,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  633,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  848,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1282,    0,    0,    0,    0,    0,
  866,  870,    0,    0,    0,    0,    0,    0,    0, 1289,
  512, 1287,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 4380,    0,    0,    0,    0,    0,
 1296,    0,    0, -240,    0,    0,  853,    0, 1289,    0,
    0,    0,16009,    0,  735,  749,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1257,    0,14107,    0,    0,    0,    0,    0,17136,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  704,    0,  716,    0,    0,    0,    0,  915,    0,
  787, 1291,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1297,    0,    0,    0, 1302,    0,    0,    0,
    0,16009,    0,    0,    0,    0,    0,    0,    0, -154,
  671,    0,    0,    0,    0,    0,17212,16819,    0,  432,
  432,  432,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, -182,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,17317,    0, -255,    0, 1303, 1303, 1303,
    0,    0,    0,    0,    0, 1306,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,17360,    0,    0,
    0,14571,    0,    0, 1307,    0,    0,  447,    0,    0,
    0,  591,    0,    0,    0,    0,    0,    0,    0,    0,
 1308,    0, 1311,    0,    0,    0, 3229, 1310,  363,    0,
    0,  -54,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 2937,
    0,    0,    0,    0,14373,14657,    0,    0,    0,  731,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  442,
    0,    0,16601,    0,    0,14472,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
16669,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,14751,    0,14373,    0,    0,  731,    0,    0,    0,
    0,  425,    0,    0,    0,    0,    0,    0,    0,    0,
  425,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 5080,  443,    0,14793,    0,    0,    0,
14863,    0, 2937,    0,    0,    0, 1311,    0, 2937,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  275,    0, 1315,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 2937,    0,    0,    0,  565,
    0,  664,    0,    0,    0,    0,    0,    0,    0,16819,
  877,    0,    0,    0,    0,    0,    0, 1314,    0,  402,
    0,    0,    0,    0,    0,    0,    0,    0,  886,    0,
    0,    0,    0,    0,    0,    0,    0, 1312,    0,16819,
16819,    0,16851,    0,    0,    0,    0,    0,    0, 1313,
17584,    0, 1316,16819,16145, 1319,16819,    0,    0,    0,
    0,    0,    0, 1320,    0,    0,    0,17554,    0,    0,
    0,16819,    0,    0,    0, 1321,    0,    0,  407,    0,
17478,17516,    0,    0,    0, 1322,    0,    0,    0,    0,
    0,    0, 1323,    0,    0,16819,    0,  665,    0,  887,
    0,    0,    0,    0,    0,  867,    0,17402,17440,    0,
    0,    0,    0,    0,    0,    0,    0, 1368,    0, 1421,
    0,    0,    0,  891,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  593,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,17554,16317,17254,    0,  593,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1252, 1252,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,
  };
  protected static readonly short [] yyGindex = {            0,
    0, 1641,    0,    0,    0,    1,  -15, -178,  -41,  -38,
    0, 1688, 1698,  342,    0,    8,    0,    0,    0,    0,
    0,    0, -974, -741, -214, -550,    0,    0,    0,    0,
    0, -220,    0,    0,    0,  701,    0,  807,    0,    0,
    0,    0,  551,  552,  -17, -230,    0,  -46,    0, -562,
  385,    0,  415, -615, -587, -568, -567, -540, -527, -526,
 -525,    0,-1102,    0,-1230,    0,   13,    0,   85,    0,
-1142,    0,    0,    0,  -79,  199,    0,    0,    0,  237,
-1120,    0, -269, -297, -350,    0,    0,    0, -945,  185,
    0,    0, -516,    0,    0,  255,    0,    0,  222,    0,
    0,  257,    0, -607, -853,    0,    0,    0,    0,    0,
 -534,  -10,    0,    0,  799,  802,  804,  987, -548,    0,
    0, -314,  812,  357,    0,-1412,    0,    0,    0,    0,
    0,    0,    0,    0,  156,    0,    0,    0,    0,    0,
    0,    0,    0,  409,    0,    0,    0,    0, -302,  340,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, -523,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  170,    0,    0,  253,    0,    0,  264,  267,  187,
    0,    0,    0,    0,    0,    0,    0,    0,  495,    0,
    0,    0,    0,  -45,    0,  403,  -56,    0,    0,  330,
    0, -515,    0,  876,    0, 1204, -288, -268,  -61,  905,
    0,  502,    0,  -33,  188,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, -257,    0, 1435,    0, -349,    0,
 -271,    0,    0,    0,  815,  821, -301, -126,  989,    0,
  897,    0, 1147, 1384, 1033,    0,    0,  713, 1699,    0,
    0,    0,    0, 1006,    0,    0,    0,    0,    0, -483,
 1432,    0,    0,    0,    0,    0, 1238,  871,  872,  763,
  874, 1361, 1363, 1360, 1364, 1365,    0, 1367,    0,    0,
    0,  946, 1216, -546,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, -299,    0,    0,    0,    0, -461,
    0,  555,    0,  463,    0,-1121,    0,    0,    0,    0,
    0,  661, -538,  -16, -319,  -13,    0, 1638,    0,   57,
    0,   58,   68,  111,  142,  147,  163,  195,  200,  204,
  247,    0, -712,    0,  -24,    0,    0,  756,    0,  678,
    0,    0,    0,    0,  655, -246,  734, -884,    0,  776,
 -472,    0,    0,    0,    0,    0,    0,  672,    0,  673,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  600,    0,    0,    0,    0,
    0,    0,    0,    0,  -30,    0, 1264,    0,    0,    0,
  845,    0,    0,    0,    0,    0,    0, -172,    0,    0,
    0,    0,    0, 1373, 1136,    0,    0,    0,    0, 1375,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  488,
    0,    0,    0,    0,    0,    0,    0,    0,  597,    0,
    0,    0,    0,    0,    0,   -7,  922,    0,    0,    0,
  925,
  };
  protected static readonly short [] yyTable = {           109,
  155,  532,  189,  156,   18,  784,  111,  328,  333,  233,
  446,  535,  234,  485,  790,  445,  489,  464,   43,  507,
  730,  293,  321,  553,  578,  258,  530,  192,  369,  528,
  419,  752,  564,  621,  259,  835,  834, 1075,  516,  229,
  327,  332, 1201, 1012,  839,  339,  312,  252,  930,  949,
  931,  377,  593,  385,  524,  304, 1234, 1235,  249,  311,
  678,  559, 1332,  846,  594,  373,  362,  376,  313,  384,
  316, 1129,  249,  160,  161,  498,   14,  345,  996,  757,
 1341, 1111,  289, 1130,  162,  846,   51,  852,  460,  424,
  290,  190,  315, 1223,  315, 1542, 1543,  723,   51,  961,
  866,  999,  963, 1080,  250, 1267,  836,  580, 1113,  905,
 1397, 1399,  326, 1031,  363,   16,  347,  869, 1405,  453,
  454, 1261,  874,  875,  862,  421,  416,  163,  347, 1130,
  830,  347,  347,  906,  449,  404,  405,  364,  417,  109,
  155,  231,  425,  156,  713,  347,  111,  233,  837, 1223,
  447,  489, 1575,  251,  679,    1,  890,  895,  164,  499,
  907,  996,   51,  165,  581,  525,  996,  526,  996,  250,
  714,  996,  996,  250,  996,  996,  678,  291,  678,  166,
  796,   42,  495,   94,  999,  846,  291,  250,  291,  999,
  463,  999,  260,  447,  999,  999,  996,  999,  999,  487,
  490,  853,  715,   94,  115,  734,    6,  250,  505,  250,
   51,  167,  494,  160,  161,  455,  168,  362,  251,  999,
  169,  527,  251,  776,  162,  867,  485,  376,  538,  488,
  782,  464,  292,  678, 1080,  493,  251, 1131,   15,  846,
  461,  292,  863,  292,  805, 1394,  115,  932, 1516,  515,
  115,  996,  258,  191,  593,  578,  251,    2,  251,  724,
  552,  503,  258,  170,  556,  363,  594,  163,  449,  561,
 1114,  506, 1398, 1400,  999, 1540,  510,  512,  969, 1584,
 1406,  558,  578, 1131,  584,  560,  563, 1550,  364, 1551,
  594,  539,  363,  337,  551, 1285, 1264,  374,  164,  548,
 1012,  550,  365,  165, 1195,  510,  716,  549,  760,  864,
 1413,  449,  261,  328,    2,  364,  603,  566,  567,  166,
  643,  645,  362,    3,    4,    5,    6,  577,  606, 1208,
  579,  609, 1126, 1273,  376,  490,  490, 1068, 1373,  826,
  601,  376, 1448,  376,  115,  376, 1534, 1019,  682,  684,
 1153,  167, 1512,  600, 1012,  762,  168,  941, 1253, 1547,
  169,  792,  197,   51,  488,  618, 1029,   20,  625,  626,
  627,  628,  629,  630,  631,  632,  633,  634,  635,  291,
  794,  681,  683, 1056,  700,  687,  917, 1374, 1393,  376,
   94,  891, 1292,  197, 1395,  697, 1561,   20,  811, 1585,
  677,  814,  594,  170,  233,  362, 1375,  447,  374,  374,
  374, 1548,  374,  374,  701,  374, 1265,  374,   48, 1037,
 1085, 1426,  194,  805,  761, 1414, 1581, 1081,  865, 1083,
  731, 1059, 1088,  362,  292,  338,   54,  362, 1478,  362,
  362,  362,  362, 1419, 1505,  698,  699,  362, 1209,  922,
   94,  711, 1274,  738, 1043,  695,  750,  741,  758,  374,
 1207,  374, 1039,    6,  374, 1535, 1012, 1449, 1212,  717,
  370,  763, 1012,  115, 1066,  942, 1254,  793,  691,  751,
  426,  485,  490,  691,  199,  291,  748,  691,  400,  194,
  194,  196, 1237,  362,  831,  200,  795,  231,  797,  231,
  804,  938,  691,  489,  813,  231,  115,  976,  516,  779,
  194,  618,  291,  788,  812, 1086,  884,  815,  371, 1146,
  485, 1148, 1118, 1149,  401,  593, 1143,  426,  885,  691,
  352,  115,  796,  798,  449, 1038, 1420,  594,  739,  816,
  292,  363, 1557,  291,  818,  838,  797, 1278,  691,  848,
 1558,  231,  850,  851,  803,  832, 1436,  231,  577,  244,
  827,  579,  939,  427,  364,  726,  231,  957,  428,  727,
  429,  827,  859,  430,  431,  738,  432,  433,  365,  372,
   94, 1138,  500, 1139,  250,  577, 1466, 1467,  579, 1469,
  501,  450,  231,  452,  451, 1182,  854,  854,  604, 1027,
 1488,  194,  194, 1495,  402,  403,  465,  797,  605,  466,
  427, 1559,  594,  362, 1022,  428,  291,  429, 1511,  739,
  430,  431, 1214,  432,  433,  453,  248,  928,  291,  860,
  728,  369,  978,  251,  796,  871,  738,  873,  834,  883,
  776,  352, 1533,  502,  362,  352,  881,  347,  123,  943,
  123,  937, 1245,  434,  452,  123,  785,  362,  263,  449,
 1313,  363,  779,  465,  194,  929,  466,  779,  779,  691,
  877,  607,  792,  340, 1376, 1058, 1054,  369,  792,  340,
  739,  608, 1154, 1064,  364,   94,  453,  490, 1314,  352,
  194,  115,  363,  374,  535,  888,  689,  347,  365, 1280,
  444,  245,  194,  347,  924,  246, 1313, 1315, 1316,  347,
  194,  785,  347,  347,  690,  364,  488,  952, 1327,  515,
  689,  691,  320, 1377, 1294, 1312,  347,  792,  340,  365,
  331,  510,  258,  752, 1314, 1317,  331,  889,  690,  904,
  966,  556, 1122,  332,  689, 1294,  788,  689, 1318, 1319,
 1320, 1164,  779, 1315, 1316,  247,  971,  782,  347,  958,
  363,  796,  115, 1165, 1401,  690,  194,  543,  362,  194,
  710, 1312,  362, 1294,  347,  362, 1099,  362, 1415,  631,
  717, 1317,  362,  364,  799,  711,  410,  411,  953,  115,
  374,  542,  972, 1119, 1318, 1319, 1320,  365,  710,  964,
 1434,  965,  194,  194,  543,  320,  375,  250,  717,  378,
  490,  970,  967,  711,  827,  578,  490,  717, 1049,  320,
  334,  544, 1119, 1386,  946,  448, 1090,  427,  379,  380,
  194,  194,  428, 1386,  429,  363, 1030,  430,  431,  618,
  432,  433, 1390,  412,  586,  618,  701,  982,  381,  788,
  194,  587, 1390, 1077,  484,  231,  251,  578,  364,  382,
 1174, 1078,  631,  588,  194, 1022,  413,  631,  990,  631,
  631,  631,  631,  631,  631,  631,  631,  631,  631,  631,
  741,   94,  586,  804,  914,  804,  374,  804,  414,  587,
 1364,  631,  779,  631,  506,  631, 1204,  631,  631,  631,
  697,  588,  450,  691,  717, 1062,  450, 1065,  691,  882,
   44, 1044,  691, 1067, 1011,  320, 1046,  690,  374, 1046,
   94,  113,  415,  578,  730, 1099,  992,  691,  779, 1421,
  788,  352, 1103, 1236,  954,  352,  908,  347,  352, 1076,
  352, 1250,  231,  909, 1499,  352,   94,  320,  115,  806,
  115,  990,  631,  418,  691, 1284,  990,  714,  990,  713,
  490,  990,  990,  113,  990,  990,  714,  113,  713,  406,
  407,  194,  779,  691,  779,  347, 1108,  779,  347,  352,
  297, 1358, 1112,  408,  409,  807,  986, 1336, 1337, 1098,
 1368,  331,  331,  807,  340,  194, 1338,  340,  426,  115,
  808,  485,  115,  464,  808,  225, 1552,  883,  808,  992,
  456,  717,  331, 1329,  992, 1218,  992,  364,  456,  992,
  992,  788,  992,  992,  510,  452, 1105,  804, 1106, 1361,
 1107,  278,  278,  804,  459,  804,  347,  288, 1361,  288,
  278,  990,  347, 1572,  288,  486,  521,  578,  347,  512,
  522,  651,  347,  651,  337,  512,   69,   69, 1590, 1591,
   69,  113,  827,  535,  779,  347,  779,  508,  779,  986,
  225, 1150,  226,  176,  986,  176,  986,  176,  509,  986,
  986,  427,  986,  986,  531,  189,  428,  189,  429,  189,
  536,  430,  431,  375,  432,  433,  225,  347,  228,  992,
 1157,  733,  824,  331,  331,  734,  824,  194,  824,  490,
  824,  767,  506,  777,  537,  768,  813,  522,  577,  741,
  813,  579,  813,  296,  813,  297, 1183,  788,  194,  347,
  347,  827,  347,  347,   62,  925,  945,  540, 1098,  926,
  946, 1194,  871,  875,  541,  506,  871,  875,  506,   70,
  996,  997,  233,   70, 1221,  447,  557, 1222,  807,  986,
  577,  562,  807,  579, 1187, 1188,  331,  779,  655,  657,
  659,  661, 1074, 1217,  863, 1022,  233, 1562, 1563,  447,
  397,  398,  399,  570, 1155,  506, 1156, 1032,  598, 1032,
  113,  599,  331,  815, 1289,  815,  364,  779, 1150,  194,
  164,  610,  164,  796,  331,  941,  347,  941,  347,  796,
 1221,  693,  331, 1222,  732,  171,  796,  171,  172,   72,
  172,   72,  194,  113,  536,  536,  577,  347,  347,  579,
  691,  691,  115, 1293, 1311,  195, 1222,  195,  194,  165,
  368,  165,  194,  696,  779, 1199, 1200,  347,  113,  712,
  128, 1289,  128,  759, 1293,  347,  735, 1222,  347,  294,
  135,  294,  135,  779,  301,  506,  301,  737,  331, 1371,
 1372,  331,  647,  649,  764,  651,  653,  765, 1345,  766,
 1311,  817, 1293,  663,  665, 1222,  810,  819,  821,  820,
  822,  840,  841,  844, 1404,  845,  847, 1407,  857,  194,
  449,  858,  849,  513,  331,  331,  425,  870,  425,  513,
  872,  876,  892,  893,  450,   42,  897,  194,  194,  896,
  900,  918,  115,  196, 1366,  919, 1412,  425,  425,  912,
  343,  920,  331,  331,  347,  349,  351,  353,  355,  357,
  359,  361,  921, 1412,  927,  944,  947,  425,  950,  863,
  577,  948,  955,  579,  959,  425,  960,  968,  425,  991,
  115, 1444,  974, 1445,  115,  986,  993, 1006,  115,  998,
 1000,  741, 1007, 1009, 1010, 1012, 1015, 1017, 1023, 1035,
 1422, 1036, 1045, 1039,  801,  194, 1053,  525, 1101, 1060,
 1071, 1072,  115,   24, 1091,   25, 1115, 1125,   26, 1109,
 1116,  741,  741,   27,  741, 1117,  194,   28,  113, 1479,
 1127, 1137, 1144, 1141,  194,  741,   30, 1145,  741, 1159,
 1147, 1167, 1168,   32, 1163, 1166, 1506, 1169,   33, 1171,
  115, 1175,   34,  741, 1172, 1179, 1186, 1190, 1189, 1518,
 1520, 1197, 1220,  788,   36, 1202,   37,  115, 1366, 1210,
   38,  331, 1230, 1213, 1244,  506, 1247,  741,   39,   40,
  386, 1252,   41, 1260, 1249,  802, 1506, 1506, 1255, 1268,
 1263, 1270, 1528,  331, 1275, 1276, 1277, 1283, 1279,  113,
 1284,  387,  388,  389,  390,  391,  392,  393,  394,  395,
  396,  291, 1325, 1328, 1333,  262, 1347,  331,  629,  286,
  287,  288, 1330,  294,  295,  788,  113, 1331,  308,  309,
 1342, 1370, 1378, 1392, 1417,  317, 1409,  319, 1410,  323,
 1425, 1428, 1430, 1506,  335,  336, 1431, 1433, 1435, 1418,
 1420, 1439, 1400, 1441, 1437,  490,  490, 1442, 1447,  343,
 1452, 1455,  788, 1459, 1458, 1489,  325, 1470,  383, 1460,
 1462, 1471, 1500, 1503,  115, 1577, 1577, 1474, 1484, 1491,
 1504, 1510, 1586, 1586,  618,  618, 1501, 1513, 1514, 1525,
 1527,  565, 1530, 1524, 1532, 1538, 1545, 1549, 1529,  343,
  912,  629, 1553, 1556, 1554, 1564,  629, 1565,  629,  629,
  629,  629,  629,  629,  629,  629,  629,  629,  629,  194,
 1548, 1547, 1570, 1571, 1592, 1593, 1594,    9, 1028,  331,
  629,  552,  629,  507,  629,  910,  629,  629,  629,  911,
  653, 1020,  508,  465,  654,  725,   33,  506,   33,  466,
  331,  323,  629,  532,  637,  639,  641,   34,  817,  565,
  565,  565,  565,  565,  565,  565,  565,  565,  565,  565,
  565,  565,  565,  565,  565,   34,  194,  818,  216,  103,
  809,  583,  876,  841,  842,  113,  877,  113,  921,  713,
   24,  629,   25,  347,  327,   26,  194,  878,  738,  880,
   27,  354,  691,  691,   28,  713,  347,  131,  113,  317,
  230,  297,  383,   30,  138,  132,  114,  298,  139,   53,
   32,  331,   21, 1005, 1092,   33, 1192, 1193, 1344,   34,
 1334, 1546, 1515, 1555, 1531, 1497,  113, 1032, 1502,  113,
 1033,   36, 1034,   37,  331, 1028,  915,   38, 1402, 1588,
 1343, 1424,  529,  194,  194,   39,   40, 1580, 1526,   41,
  331,  465,  324,  194,  331, 1521, 1271, 1519,  547, 1446,
  807,  194,  194, 1579,  194, 1272, 1052, 1050,  936,  979,
 1389,  856,  565, 1001,  466,  612,  911, 1128,  568,  299,
 1389,  933,  667,  671, 1389,  669,  194,  467,  673,  194,
  675,  468,  469,  676,  824,  973, 1257,  470, 1389,  471,
  472,  473,  474, 1348,  420, 1177, 1121,  475, 1170, 1184,
 1110,  476, 1140,   38, 1176, 1241, 1069, 1178,  800,  691,
 1389,  692, 1246,  477, 1346, 1003,  478, 1002,  479,  331,
  331,    0,    0,  368,    0,    0,  880,    0,    0,    0,
    0,    0,    0,    0,    0,  843,  912,  912,    0,    0,
    0,    0,  480,    0,  912,  912,  912,  912,  912,    0,
  912,  912,    0,  912,  912,  912,  912,  912,  912,  912,
  912,    0,    0,    0,    0,  912,    0,  912,  912,  912,
  912,  912,  912,    0,    0,  912,    0,    0,    0,  912,
  912,    0,  912,  912,  912,    0,    0,  331,    0,    0,
    0,    0,    0,    0,  912,    0,  912,    0,  912,  912,
    0,    0,  912,    0,  912,  912,  912,  912,  912,  912,
  912,  912,  912,  912,  912,  912,  331,  912,    0,    0,
  912,  912,    0,    0,  912,  912,    0,    0,    0,  347,
    0,    0,    0,  749,    0,  347,    0,    0,    0,  912,
  912,  912,  912,  912,    0,    0,    0,  912,  912,  113,
    0,  912,    0,    0,    0,    0,  912,  912,  912,  912,
  912,    0,    0,  517,  912,    0,  912,    0,    0,    0,
    0,  347,  912,  912,    0,    0,    0,  797,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  912,  912,  912,
  912,    0,  912,    0,    0,    0,  343,    0,    0,  912,
    0,    0,  347,    0,    0,    0,    0,  347,    0,  347,
  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
  347,    0,    0,    0,    0,    0,  347,    0,    0,  113,
  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
    0,  347,  347,    0,    0,  347,  347,  347,  347,  347,
   38,    0,  347,  347,   38,    0,    0,  347,  347,  347,
  347,  347,  347,  347,  347,   38,    0,  113,    0,    0,
   38,  113,    0,    0,   38,  113,  347,   38,    0,  347,
    0,  347,    0,  347,  614,    0,  347,    0,    0,   38,
   38,  331,  347,    0,   38,   38,    0,    0,    0,  113,
   38,    0,   38,   38,   38,   38,    0,    0,    0,    0,
   38,    0,    0,    0,   38,    0,   38,    0,    0,    0,
    0,  835,    0,    0,    0,    0,   38,    0,   38,   38,
    0,   38,    0,    0,    0,   38,    0,  113,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  331,    0,
    0,    0,    0,    0,  113,   38,    0,    0,    0,    0,
    0,   38,   38,    0,    0,    0,    0,  614,  331,  565,
    0,    0,  614,    0,  614,  614,  614,  614,  614,  614,
  614,  614,  614,  614,  614,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  614,    0,  614,    0,
  614,    0,  614,  614,  614,    0,    0,    0,    0,  517,
    0,    0,  614,  614,  517,  517,    0,  614,  614,    0,
    0,    0,    0,    0,    0,  331,  331,    0,  614,  614,
    0,    0,    0,    0,    0,  331,    0,  517,    0,    0,
    0,  614,    0,  331,  331,    0,  331,  347,    0,    0,
  517,  517,    0,    0,    0,  517,    0,  614,  517,    0,
  517,  113,  517,  517,  517,  517,    0,    0,  331,    0,
  517,  331,    0,    0,  517,    0,    0,    0,  517,    0,
    0,    0,    0,    0,    0,    0,  517,    0,    0,  517,
    0,  517,  517,    0,    0,    0,    0,  517,    0,  517,
  517,  517,  517,  517,  517,  517,  517,  517,  517,  517,
    0,    0,    0,    0,    0,  517,  517,    0,    0,    0,
  517,  517,    0,  517,  517,  517,  517,  517,  517,  517,
    0,  517,  517,    0,  517,  517,  517,  517,  517,  517,
  517,  517,  517,  517,    0,  517,  517,  517,  517,  517,
  517,  517,  517,  517,  517,  517,  517,  517,  517,  517,
  517,  517,  517,  517,  517,  517,  517,    0,    0,  517,
    0,  517,    0,  517,    0,    0,  517,  835,  835,    0,
    0,    0,  517,    0,    0,  835,  835,  835,  835,  835,
    0,  835,  835,  793,  835,  835,  835,  835,  835,  835,
  835,    0,    0,    0,    0,    0,  835,    0,  835,  835,
  835,  835,  835,  835,    0,    0,  835,    0,    0,    0,
  835,  835,    0,  835,  835,  835,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  835,    0,  835,    0,  835,
  835,    0,    0,  835,    0,  835,  835,  835,  835,  835,
  835,  835,  835,  835,  835,  835,  835,    0,  835,    0,
    0,  835,  835,    0,    0,  835,  835,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  835,  835,  835,  835,  835,    0,    0,    0,  835,  835,
    0,    0,  835,    0,    0,    0,    0,  835,  835,  835,
  835,  835,    0,  347,    0,  835,    0,  835,  347,  347,
    0,    0,    0,  835,  835,    0,    0,    0,    0,    0,
    0,    0,    0,  340,    0,    0,    0,    0,    0,    0,
    0,  347,    0,    0,    0,    0,    0,    0,  835,  835,
  835,  835,    0,  835,  347,  347,    0,    0,    0,  347,
  835,    0,  347,    0,  347,    0,  347,  347,  347,  347,
    0,    0,    0,    0,  347,    0,    0,    0,  347,    0,
    0,    0,  347,    0,    0,    0,    0,    0,    0,    0,
  347,    0,    0,  347,    0,  347,  347,    0,    0,    0,
    0,  347,    0,  347,  347,  347,  347,  347,  347,  347,
  347,  347,  347,  347,  347,    0,    0,    0,    0,  347,
  347,    0,    0,    0,  347,  347,  347,  347,  347,  347,
  347,  347,  347,  347,    0,  347,  347,    0,    0,  347,
  347,  347,  347,  347,    0,    0,  347,  347,    0,    0,
    0,  347,  347,  347,  347,  347,  347,  347,  347,  793,
    0,    0,    0,  377,  793,  793,    0,    0,    0,    0,
  347,    0,    0,  347,    0,  347,    0,  347,    0,    0,
  347,    0,    0,    0,    0,    0,  347,  793,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  793,  793,    0,    0,    0,  793,    0,    0,  793,    0,
  793,    0,  793,  793,  793,  793,    0,    0,    0,    0,
  793,    0,    0,    0,  793,    0,    0,    0,  793,    0,
    0,    0,    0,    0,    0,    0,  793,    0,    0,  793,
    0,  793,  793,    0,    0,    0,    0,  793,    0,  793,
  793,  793,  793,  793,  793,  793,  793,  793,  793,  793,
    0,    0,    0,    0,    0,  793,  793,  372,    0,    0,
  793,  793,  793,  793,  793,  793,    0,  793,  793,  793,
    0,  793,  793,    0,    0,  793,  793,  793,  793,  340,
    0,    0,  793,  793,  340,  340,    0,  793,  793,  793,
  793,  793,  793,  793,  793,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  793,  340,    0,  793,
    0,  793,    0,  793,    0,    0,  793,    0,    0,    0,
  340,  340,  793,    0,    0,  340,    0,    0,  340,    0,
  340,    0,  340,  340,  340,  340,    0,    0,    0,    0,
  340,    0,    0,    0,  340,    0,    0,    0,  340,    0,
    0,    0,    0,    0,    0,    0,  340,    0,    0,  340,
    0,  340,  340,    0,    0,    0,    0,  340,    0,  340,
  340,  340,  340,  340,  340,  340,  340,  340,  340,  340,
    0,    0,    0,    0,    0,  340,  340,    0,    0,    0,
  340,  340,  340,  340,  340,  340,    0,  340,  340,  340,
    0,  340,  340,    0,    0,  340,  340,  340,  340,  377,
    0,    0,  340,  340,  377,  377,    0,  340,  340,  340,
  340,  340,  340,  340,  340,    0,   31,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  340,  377,    0,  340,
    0,  340,    0,  340,    0,    0,  340,    0,    0,    0,
  377,  377,  340,    0,    0,  377,    0,    0,  377,    0,
  377,    0,  377,  377,  377,  377,    0,    0,    0,    0,
  377,    0,    0,    0,  377,    0,    0,    0,  377,    0,
    0,    0,    0,    0,    0,    0,  377,    0,    0,  377,
    0,  377,  377,    0,    0,    0,    0,  377,    0,  377,
  377,  377,  377,  377,  377,  377,  377,  377,  377,  377,
    0,    0,   24,  372,    0,  377,  377,    0,    0,  372,
  377,  377,    0,  377,  377,  377,    0,  377,  377,  377,
    0,  377,  377,    0,    0,  377,  377,  377,  377,    0,
    0,    0,  377,  377,    0,    0,    0,  377,  377,  377,
  377,  377,  377,  377,  377,  372,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  377,    0,    0,  377,
    0,  377,    0,    0,    0,   37,    0,    0,    0,    0,
    0,    0,  377,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  372,    0,    0,    0,
    0,  372,    0,  372,  372,  372,  372,  372,  372,  372,
  372,  372,  372,  372,    0,    0,    0,    0,    0,    0,
  372,    0,    0,    0,  372,  372,    0,  372,  372,  372,
    0,  372,  372,  372,    0,  372,  372,    0,    0,  372,
  372,  372,  372,    0,   36,    0,  372,  372,    0,    0,
    0,  372,  372,  372,  372,  372,  372,  372,  372,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  372,    0,    0,  372,    0,  372,    0,    0,    0,    0,
    0,    0,   31,   31,    0,    0,  372,   31,    0,    0,
    0,   31,    0,   31,    0,    0,   31,    0,   31,   31,
    0,   31,    0,   31,    0,   31,    0,   31,   31,   31,
   31,    0,    0,   31,   31,    0,    0,    0,   25,   31,
    0,   31,   31,   31,    0,    0,   31,   31,   31,    0,
   31,    0,    0,   31,    0,   31,   31,   31,   31,    0,
    0,    0,   31,   31,   31,    0,    0,   31,   31,   31,
    0,    0,    0,    0,    0,    0,   31,   31,    0,   31,
   31,   35,   31,   31,   31,    0,    0,    0,   31,   24,
    0,    0,    0,   24,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   24,    0,    0,    0,   31,   24,
    0,    0,    0,   24,   31,   31,   24,    0,    0,    0,
    0,    0,    0,   31,    5,    0,    0,    0,   24,   24,
    0,    0,    0,   24,   24,    0,    0,    0,    0,   24,
    0,   24,   24,   24,   24,    0,    0,    0,    0,   24,
    0,    0,   37,   24,    0,   24,   37,    0,    0,    0,
    0,    0,    0,    0,   31,   24,    0,   37,   24,    0,
   24,    0,   37,    0,   24,    0,   37,    0,    0,   37,
    0,    0,    0,    0,    0,    0,    0, 1010,    0,    0,
    0,   37,   37,    0,   24,    0,   37,   37,    0,   21,
   24,   24,   37,    0,   37,   37,   37,   37,    0,    0,
    0,    0,   37,    0,    0,    0,   37,    0,   37,    0,
    0,   36,    0,    0,    0,   36,    0,    0,   37,    0,
   37,   37,    0,   37,   51,    0,   36,   37,    0,    0,
    0,   36,    0,    0,    0,   36,    0,    0,   36,    0,
    0,    0,    0,    0,    0,    0,    0,   37,    0,    0,
   36,   36,    0,    0,   37,   36,   36,    0,    0,    0,
    0,   36,    0,   36,   36,   36,   36,    0,    0,    0,
    0,   36,    0,    0,    0,   36,    0,   36,    0,    0,
    0,    0,    0,    0,    0,   25,    0,   36,    0,   25,
   36,    7,   36,    0,    0,    0,   36,    0,    0,    0,
   25,    0,    0,    0,    0,   25,    0,    0,    0,   25,
    0,    0,   25,    0,    0,    0,   36,    0,    0,    0,
    0,    0,   36,   36,   25,   25,    0,    0,   35,   25,
   25,    0,   35,    0, 1011,   25,    0,   25,   25,   25,
   25,    0,    0,   35,    0,   25,    0,    0,   35,   25,
    0,   25,   35,    0,    0,   35,    0,    0,    0,    0,
    0,   25,    0,    0,   25,    0,   25,   35,   35,    0,
   25,    5,   35,   35,    0,   51,    0,   52,   35,    0,
   35,   35,   35,   35,    0,    0,   51,    0,   35,    0,
   25,   51,   35,    0,   35,   51,   25,   25,   51,    0,
    0,    0,    0,    0,   35,    0,    0,   35,    0,   35,
   51,   51,    0,   35,    0,   51,   51,    0,    0,    0,
    0,   51,    0,   51,   51,   51,   51,    0,    0,    0,
    0,   51,    0,   35, 1010,   51,    0,   51,   51,    0,
   35,    0,    0,    0,    0,    0,    0,   51,    0,   51,
   51,    0,   51,    0,   51,    0,   51,    0,   51,    0,
    0,   51,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   51,   51,    0,   51,    0,   51,   51,
    0,   51,    0,    0,   51,   51,   51,   51,   51,   51,
    0,    0,    0,    0,   51,    0,   51,    0,   51,    0,
   51,   51,    0,    0,    0,   51,    0,    0,   51,    0,
   51,    0,    0,   51,    0,   51,    0,    0,    0,   51,
   51,   51,    0,    0,    0,   51,   51,    0,    0,    0,
    0,   51,    0,   51,   51,   51,   51,    0,    0,   51,
    0,   51,    0,    0,    0,   51,    0,   51,    7,    0,
    0,    0,   52,    0,    0,    0,    0,   51,    0,    0,
   51,    0,   51,   52,    0,    0,   51,    0,   52,    0,
    0,    0,   52,    0,    0,   52,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   51,   52,   52,    0,
    0, 1011,   52,   52,    0,   51,    0,    0,   52,    0,
   52,   52,   52,   52,    0,    0,   51,    0,   52,    0,
    0,   51,   52,    0,   52,   51,    0,    0,   51,    0,
    0,    0,    0,    0,   52,    0,    0,   52,    0,   52,
   51,   51,    0,   52,   52,   51,   51,    0,   52,    0,
    0,   51,    0,   51,   51,   51,   51,    0,    0,   52,
    0,   51,    0,   52,   52,   51,    0,   51,   52,    0,
    0,   52,    0,    0,    0,    0,    0,   51,    0,    0,
   51,    0,   51,   52,   52,    0,   51,    0,   52,   52,
    0,    0,    0,    0,   52,    0,   52,   52,   52,   52,
    0,    0,    0,    0,   52,    0,   51,    0,   52,    0,
   52,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   52,    0,   55,   52,    0,   52,    0,    0,    0,   52,
   56,   24,   57,   25,    0,    0,   26,   58,    0,   59,
   60,   27,   61,   62,   63,   28,    0,    0,    0,   52,
    0,   64,    0,   65,   30,   66,   67,   68,   69,    0,
    0,   32,    0,    0,    0,   70,   33,    0,   71,   72,
   34,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   73,    0,   36,    0,   37,   74,    0,    0,   38,    0,
   75,   76,   77,   78,   79,   80,   39,   40,   81,   82,
   41,   83,    0,   84,    0,    0,   85,   86,    0,  796,
   87,   88,    0,    0,    0,  796,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   89,   90,   91,   92,   93,
    0,    0,    0,   94,    0,    0,    0,   95,    0,    0,
    0,    0,   96,   97,   98,   99,  100,    0,    0,    0,
  101,  796,  102,    0,    0,    0,    0,    0,  103,  104,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  347,    0,    0,    0,    0,
    0,  347,    0,  105,  106,  107,  108,    0,    0,    0,
    0,    0,  796,    0,    0,  196,    0,  796,    0,  796,
  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,
  796,    0,    0,    0,    0,    0,  796,  347,    0,    0,
    0,  796,  796,  796,  796,  796,  796,  796,  796,  796,
    0,  796,  796,    0,  796,  796,  796,  796,  796,  796,
  796,  796,  796,  796,    0,  796,  796,  796,  796,  796,
  796,  796,  796,  796,  796,  796,  796,  796,  796,  796,
  796,  796,  796,  796,  796,  796,  796,  796,  347,    0,
    0,  796,    0,  796,  347,    0,  796,    0,    0,    0,
    0,    0,  796,    0,    0,    0,    0,  347,    0,    0,
  347,    0,  347,  347,    0,    0,    0,  347,  347,    0,
    0,  347,  347,  347,  347,  347,  347,  347,  347,  347,
  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
  347,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  347,  347,    0,    0,    0,    0,    0,    0,  347,
    0,    0,  347,    0,    0,    0,    0,    0,  347,    0,
  201,  347,    0,    0,    0,    0,  347,    0,  347,  347,
  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
    0,    0,    0,    0,    0,  347,    0,    0,    0,    0,
  347,  347,  347,  347,  347,  347,  347,  347,  347, 1002,
  347,  347,  202,  347,  347,  347,  347,  347,  347,  347,
  347,  347,  347,    0,  347,  347,  347,  347,  347,  347,
  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
  347,  347,  347,  347,  347,  347,    0,  519,    0,    0,
  347,    0,  347,  519,    0,  347,    0,    0,    0,    0,
    0,  347,  203,  204,  205,  206,    0,  207,  208,  209,
  210,  211,  212,  213,  214,    0,    0,  215,  216,  217,
  218,  219,  220,  221,  222,    0,    0,    0,    0,  519,
    0,    0, 1002,    0,    0,    0,    0, 1002,    0, 1002,
 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1002,    0, 1002,    0, 1002,    0, 1002, 1002, 1002,
  519,    0,    0,    0,    0,  519,    0,  519,  519,  519,
  519,  519,  519,  519,  519,  519,  519,  519,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  519,  519,
  519,  519,  519,  519,  519,  519,  519,  519,    0,  519,
  519,    0,  519,  519,  519,  519,  519,  519,  519,  519,
  519,  519, 1002,  519,  519,  519,  519,  519,  519,  519,
  519,  519,  519,  519,  519,  519,  519,  519,  519,  519,
  519,  519,  519,  519,  519,    0,  515,  642,    0,    0,
    0,  519,  515,    0,    0,    0,   24,    0,   25,    0,
  519,   26,    0,    0,    0,    0,   27,    0,    0,    0,
   28,    0,    0,    0,    0,    0,    0,    0,    0,   30,
    0,    0,    0,    0,    0,    0,   32,    0,  515,    0,
    0,   33,    0,    0,    0,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
    0,    0,    0,   38,    0,    0,    0,  403,    0,    0,
    0,   39,   40,  403,    0,   41,    0,    0,  324,  515,
    0,    0,    0,    0,  515,    0,  515,  515,  515,  515,
  515,  515,  515,  515,  515,  515,  515,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  515,  515,  403,
  515,  515,  515,  515,  515,  515,  515,    0,  515,  515,
    0,  515,  515,  515,  515,  515,  515,  515,  515,  515,
  515,    0,  515,  515,  515,  515,  515,  515,  515,  515,
  515,  515,  515,  515,  515,  515,  515,  515,  515,  515,
  515,  515,  515,  515,    0,  523,    0,    0,    0,  368,
  515,  523,    0,  515,    0,    0,    0,    0,    0,  515,
    0,    0,    0,    0,  340,    0,    0,    0,    0,  403,
  340,    0,  403,  403,  403,  403,    0,  403,    0,  403,
  403,    0,  403,  403,  403,  403,  403,  523,  403,  403,
  403,  403,    0,  403,  403,  403,  403,  403,  403,  403,
  403,  403,  403,  403,  403,  403,  403,  403,  403,  403,
  403,  403,  403,  403,  403,    0,    0,    0,    0,  340,
    0,  403,    0,    0,  403,    0,    0,    0,  523,    0,
  403,    0,    0,  523,    0,  523,  523,  523,  523,  523,
  523,  523,  523,  523,  523,  523,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  523,    0,  523,
  523,  523,  523,  523,  523,  523,    0,  523,  523,    0,
  523,  523,  523,  523,  523,  523,  523,  523,  523,  523,
    0,  523,  523,  523,  523,  523,  523,  523,  523,  523,
  523,  523,  523,  523,  523,  523,  523,  523,  523,  523,
  523,  523,  523,    0,  347,  644,    0,    0,    0,  523,
  347,    0,  523,    0,   24,    0,   25,    0,  523,   26,
    0,    0,    0,    0,   27,    0,    0,    0,   28,    0,
    0,    0,    0,    0,    0,    0,    0,   30,    0,    0,
    0,    0,    0,    0,   32,    0,  347,    0,    0,   33,
    0,    0,    0,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,    0,    0,
    0,   38,    0,    0,    0,    0,    0,    0,    0,   39,
   40,    0,    0,   41,    0,    0,  324,  347,    0,    0,
    0,    0,  347,    0,  347,  347,  347,  347,  347,  347,
  347,  347,  347,  347,  347,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  347,    0,  347,  347,
  347,  347,  347,  347,  347,    0,  347,  347,    0,  347,
  347,  347,  347,  347,  347,  347,  347,  347,  347,    0,
  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
  347,  347,    0,  448,  951,    0,    0,  368,  347,  448,
    0,  347,    0,   24,    0,   25,    0,  347,   26,    0,
    0,    0,    0,   27,    0,    0,    0,   28,    0,    0,
    0,    0,    0,    0,    0,    0,   30,    0,    0,    0,
    0,    0,    0,   32,    0,  448,    0,    0,   33,    0,
    0,    0,   34,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   36,    0,   37,    0,    0,    0,
   38,    0,    0,    0,    0,    0,    0,    0,   39,   40,
    0,    0,   41,    0,    0,  324,  448,    0,    0,    0,
    0,  448,    0,  448,  448,  448,  448,  448,  448,  448,
  448,  448,  448,  448,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  448,    0,  448,  448,  448,
  448,  448,  448,  448,    0,  448,  448,    0,  448,  448,
  448,  448,  448,  448,  448,  448,  448,  448,    0,  448,
  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,
  448,  448,  448,  448,  448,  448,  448,  448,  448,  448,
  448,    0,  347,    0,    0,    0,  368,  448,  347, 1102,
  448,    0,  796,    0,    0,    0,  448,    0,   24,    0,
   25,    0,    0,   26,    0,    0,    0,    0,   27,    0,
    0,    0,   28,    0,    0,    0,    0,    0,    0,    0,
    0,   30,    0,    0,  347,    0,    0,    0,   32,    0,
    0,    0,    0,   33,    0,    0,    0,   34,    0,    0,
  796,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,    0,    0,    0,   38,    0,    0,    0,    0,
    0,    0,    0,   39,   40,    0,    0,   41,    0,    0,
  324,    0,    0,    0,    0,  557,    0,    0,    0,    0,
    0,  557,    0,  347,    0,    0,    0,    0,    0,  347,
    0,    0,    0,    0,  347,  347,  347,  347,  347,  347,
  347,  796,  347,    0,  347,  347,    0,  347,  347,  347,
  347,  347,  347,  347,  347,  347,  347,  557,  347,  347,
  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
    0,    0,    0,    0,  347,    0,  347,    0,    0,  347,
    0,  368,    0,    0,    0,  347,    0,    0,  557,    0,
    0,    0,    0,  557,    0,  557,  557,  557,  557,  557,
  557,  557,  557,  557,  557,  557,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  557,    0,  557,
    0,  557,    0,  557,  557,  557,    0,  557,  557,    0,
  557,  557,  557,  557,  557,  557,  557,  557,  557,  557,
  369,    0,    0,  557,  557,  557,  557,  557,  557,  557,
  557,  557,  557,  557,  557,  557,  557,  557,  557,  557,
  557,  579,  557,  369,    0,    0,    0,  579,    0,    0,
    0,    0,    0,    0,    0,    0,  369,    0,  557,    0,
    0,  369,    0,    0,  240,    0,  369,    0,  369,  369,
  369,  369,    0,    0,    0,    0,  369,    0,    0,    0,
  369,    0,    0,  579,  369,    0,    0,    0,    0,    0,
    0,    0,  369,    0,    0,  369,    0,  369,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  586,
    0,    0,    0,    0,    0,  586,    0,    0,    0,    0,
    0,  369,    0,    0,  579,    0,    0,  369,    0,  579,
    0,  579,  579,  579,  579,  579,  579,  579,  579,  579,
  579,  579,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  586,    0,  579,    0,  579,    0,  579,    0,  579,
  579,  579,    0,  579,  579,    0,    0,  579,  579,  579,
  579,  579,  579,  579,  579,  579,    0,  369,    0,  579,
  579,  579,  579,  579,  579,  579,  579,    0,    0,    0,
    0,    0,  586,    0,    0,    0,    0,  586,  579,  586,
  586,  586,  586,  586,  586,  586,  586,  586,  586,  586,
    0,    0,    0,  587,  579,    0,    0,    0,    0,  587,
    0,  586,    0,  586,    0,  586,    0,  586,  586,  586,
    0,  586,  586,    0,    0,  586,  586,  586,  586,    0,
    0,    0,  586,  586,    0,    0,    0,  586,  586,  586,
  586,  586,  586,  586,  586,  587,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  586,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  588,  586,    0,    0,    0,    0,  588,    0,    0,
    0,    0,    0,    0,    0,    0,  587,    0,    0,    0,
    0,  587,    0,  587,  587,  587,  587,  587,  587,  587,
  587,  587,  587,  587,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  588,    0,  587,    0,  587,    0,  587,
    0,  587,  587,  587,    0,  587,  587,    0,    0,  587,
  587,  587,  587,    0,    0,    0,  587,  587,    0,  595,
    0,  587,  587,  587,  587,  587,  587,  587,  587,    0,
    0,    0,    0,    0,  588,    0,    0,    0,    0,  588,
  587,  588,  588,  588,  588,  588,  588,  588,  588,  588,
  588,  588,    0,    0,    0,    0,  587,    0,    0,    0,
    0,    0,    0,  588,    0,  588,    0,  588,    0,  588,
  588,  588,    0,  588,  588,    0,    0,  588,  588,  588,
  588,    0,    0,    0,  588,  588,    0,  596,    0,  588,
  588,  588,  588,  588,  588,  588,  588,    0,    0,    0,
    0,    0,  595,    0,    0,    0,    0,  595,  588,  595,
  595,  595,  595,  595,  595,  595,  595,  595,  595,  595,
    0,    0,    0,    0,  588,    0,    0,    0,    0,    0,
    0,  595,    0,  595,    0,  595,    0,  595,  595,  595,
    0,    0,    0,    0,    0,  595,  595,  595,  595,    0,
    0,    0,  595,  595,    0,  597,    0,  595,  595,  595,
  595,  595,  595,  595,  595,    0,    0,    0,    0,    0,
  596,    0,    0,    0,    0,  596,  595,  596,  596,  596,
  596,  596,  596,  596,  596,  596,  596,  596,    0,    0,
    0,    0,  595,    0,    0,    0,    0,    0,    0,  596,
    0,  596,    0,  596,    0,  596,  596,  596,    0,    0,
    0,    0,    0,  596,  596,  596,  596,    0,    0,    0,
  596,  596,    0,  600,    0,  596,  596,  596,  596,  596,
  596,  596,  596,    0,    0,    0,    0,    0,  597,    0,
    0,    0,    0,  597,  596,  597,  597,  597,  597,  597,
  597,  597,  597,  597,  597,  597,    0,    0,    0,    0,
  596,    0,    0,    0,    0,    0,    0,  597,    0,  597,
    0,  597,    0,  597,  597,  597,    0,    0,    0,    0,
    0,  597,  597,  597,  597,    0,    0,    0,  597,  597,
    0,  601,    0,  597,  597,  597,  597,  597,  597,  597,
  597,    0,    0,    0,    0,    0,  600,    0,    0,    0,
    0,  600,  597,  600,  600,  600,  600,  600,  600,  600,
  600,  600,  600,  600,    0,    0,    0,    0,  597,    0,
    0,    0,    0,    0,    0,  600,    0,  600,    0,  600,
    0,  600,  600,  600,    0,    0,    0,    0,    0,  600,
  600,  600,  600,    0,    0,    0,  600,  600,    0,  602,
    0,    0,    0,  600,  600,  600,  600,  600,  600,    0,
    0,    0,    0,    0,  601,    0,    0,    0,    0,  601,
  600,  601,  601,  601,  601,  601,  601,  601,  601,  601,
  601,  601,    0,    0,    0,    0,  600,    0,    0,    0,
    0,    0,    0,  601,    0,  601,    0,  601,    0,  601,
  601,  601,    0,    0,    0,    0,    0,  601,  601,  601,
  601,    0,    0,    0,  601,  601,    0,  603,    0,    0,
    0,  601,  601,  601,  601,  601,  601,    0,    0,    0,
    0,    0,  602,    0,    0,    0,    0,  602,  601,  602,
  602,  602,  602,  602,  602,  602,  602,  602,  602,  602,
    0,    0,    0,    0,  601,    0,    0,    0,    0,    0,
    0,  602,    0,  602,    0,  602,    0,  602,  602,  602,
    0,    0,    0,    0,    0,  602,  602,  602,  602,    0,
    0,    0,  602,  602,    0,  604,    0,    0,    0,  602,
  602,  602,  602,  602,  602,    0,    0,    0,    0,    0,
  603,    0,    0,    0,    0,  603,  602,  603,  603,  603,
  603,  603,  603,  603,  603,  603,  603,  603,    0,    0,
    0,    0,  602,    0,    0,    0,    0,    0,    0,  603,
    0,  603,    0,  603,    0,  603,  603,  603,    0,    0,
    0,    0,    0,  603,  603,  603,  603,    0,    0,    0,
  603,  603,    0,  609,    0,    0,    0,  603,  603,  603,
  603,  603,  603,    0,    0,    0,    0,    0,  604,    0,
    0,    0,    0,  604,  603,  604,  604,  604,  604,  604,
  604,  604,  604,  604,  604,  604,    0,    0,    0,    0,
  603,    0,    0,    0,    0,    0,    0,  604,    0,  604,
    0,  604,    0,  604,  604,  604,    0,    0,    0,    0,
    0,  604,  604,  604,  604,    0,    0,    0,  604,  604,
    0,  610,    0,    0,    0,  604,  604,  604,  604,  604,
  604,    0,    0,    0,    0,    0,  609,    0,    0,    0,
    0,  609,  604,  609,  609,  609,  609,  609,  609,  609,
  609,  609,  609,  609,    0,    0,    0,    0,  604,    0,
    0,    0,    0,    0,    0,  609,    0,  609,    0,  609,
    0,  609,  609,  609,    0,    0,    0,    0,    0,    0,
    0,  609,  609,    0,    0,    0,  609,  609,    0,  611,
    0,    0,    0,    0,    0,  609,  609,  609,  609,    0,
    0,    0,    0,    0,  610,    0,    0,    0,    0,  610,
  609,  610,  610,  610,  610,  610,  610,  610,  610,  610,
  610,  610,    0,    0,    0,    0,  609,    0,    0,    0,
    0,    0,    0,  610,    0,  610,    0,  610,    0,  610,
  610,  610,    0,    0,    0,    0,    0,    0,    0,  610,
  610,    0,    0,    0,  610,  610,    0,  615,    0,    0,
    0,    0,    0,  610,  610,  610,  610,    0,    0,    0,
    0,    0,  611,    0,    0,    0,    0,  611,  610,  611,
  611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
    0,    0,    0,    0,  610,    0,    0,    0,    0,    0,
    0,  611,    0,  611,    0,  611,    0,  611,  611,  611,
    0,    0,    0,    0,    0,    0,    0,  611,  611,    0,
    0,    0,  611,  611,    0,  617,    0,    0,    0,    0,
    0,  611,  611,  611,  611,    0,    0,    0,    0,    0,
  615,    0,    0,    0,    0,  615,  611,  615,  615,  615,
  615,  615,  615,  615,  615,  615,  615,  615,    0,    0,
    0,    0,  611,    0,    0,    0,    0,    0,    0,  615,
    0,  615,    0,  615,    0,  615,  615,  615,    0,    0,
    0,    0,    0,    0,    0,  615,  615,    0,    0,    0,
  615,  615,    0,  618,    0,    0,    0,    0,    0,    0,
    0,  615,  615,    0,    0,    0,    0,    0,  617,    0,
    0,    0,    0,  617,  615,  617,  617,  617,  617,  617,
  617,  617,  617,  617,  617,  617,    0,    0,    0,    0,
  615,    0,    0,    0,    0,    0,    0,  617,    0,  617,
    0,  617,    0,  617,  617,  617,    0,    0,    0,    0,
    0,    0,    0,    0,  617,    0,    0,    0,  617,  617,
    0,  620,    0,    0,    0,    0,    0,    0,    0,  617,
  617,    0,    0,    0,    0,    0,  618,    0,    0,    0,
    0,  618,  617,  618,  618,  618,  618,  618,  618,  618,
  618,  618,  618,  618,    0,    0,    0,    0,  617,    0,
    0,    0,    0,    0,    0,  618,    0,  618,    0,  618,
    0,  618,  618,  618,    0,    0,    0,    0,    0,    0,
    0,    0,  618,    0,    0,    0,  618,  618,    0,  621,
    0,    0,    0,    0,    0,    0,    0,  618,  618,    0,
    0,    0,    0,    0,  620,    0,    0,    0,    0,  620,
  618,  620,  620,  620,  620,  620,  620,  620,  620,  620,
  620,  620,    0,    0,    0,    0,  618,    0,    0,    0,
    0,    0,    0,  620,    0,  620,    0,  620,    0,  620,
  620,  620,    0,    0,    0,    0,    0,    0,    0,    0,
  620,    0,    0,    0,    0,  620,    0,  623,    0,    0,
    0,    0,    0,    0,    0,  620,  620,    0,    0,    0,
    0,    0,  621,    0,    0,    0,    0,  621,  620,  621,
  621,  621,  621,  621,  621,  621,  621,  621,  621,  621,
    0,    0,    0,    0,  620,    0,    0,    0,    0,    0,
    0,  621,    0,  621,    0,  621,    0,  621,  621,  621,
    0,    0,    0,    0,    0,    0,    0,    0,  621,    0,
    0,    0,    0,  621,    0,  624,    0,    0,    0,    0,
    0,    0,    0,  621,  621,    0,    0,    0,    0,    0,
  623,    0,    0,    0,    0,  623,  621,  623,  623,  623,
  623,  623,  623,  623,  623,  623,  623,  623,    0,    0,
    0,    0,  621,    0,    0,    0,    0,    0,    0,  623,
    0,  623,    0,  623,    0,  623,  623,  623,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  623,    0,  626,    0,    0,    0,    0,    0,    0,
    0,  623,  623,    0,    0,    0,    0,    0,  624,    0,
    0,    0,    0,  624,  623,  624,  624,  624,  624,  624,
  624,  624,  624,  624,  624,  624,    0,    0,    0,    0,
  623,    0,    0,    0,    0,    0,    0,  624,    0,  624,
    0,  624,    0,  624,  624,  624,    0,    0,    0,  627,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  624,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  624,
  624,    0,    0,    0,    0,    0,  626,    0,    0,    0,
    0,  626,  624,  626,  626,  626,  626,  626,  626,  626,
  626,  626,  626,  626,    0,    0,    0,    0,  624,    0,
    0,    0,    0,    0,    0,  626,    0,  626,    0,  626,
    0,  626,  626,  626,    0,    0,    0,    0,  347,    0,
    0,    0,  796,    0,    0,    0,    0,  626,    0,    0,
    0,    0,  627,    0,    0,    0,    0,  627,  626,  627,
  627,  627,  627,  627,  627,  627,  627,  627,  627,  627,
  626,    0,    0,    0,  347,    0,    0,    0,    0,    0,
    0,  627,    0,  627,    0,  627,  626,  627,  627,  627,
  796,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  627,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  627,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  627,    0,    0,    0,
    0,    0,    0,  347,    0,    0,    0,    0,    0,  347,
    0,    0,  627,    0,  347,  347,    0,  347,    0,  347,
    0,  796,  347,    0,  347,  347,    0,  347,  347,  347,
  347,  347,  347,  347,  347,  347,  347,    0,  347,  347,
  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
    0,    0,  572,    0,  347,    0,  347,    0,    0,  347,
   56,   24,   57,   25, 1130,  347,   26,   58,    0,   59,
   60,   27,   61,   62,   63,   28,    0,    0,    0,    0,
    0,   64,    0,   65,   30,   66,   67,   68,   69,    0,
    0,   32,    0,    0,    0,   70,   33,    0,   71,   72,
   34,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   73,    0,   36,    0,   37,   74,    0,    0,   38,    0,
   75,   76,   77,   78,   79,   80,   39,   40,   81,   82,
   41,   83,    0,   84,    0,    0,   85,   86,    0,    0,
   87,   88,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   89,   90,   91,   92,   93,
    0,    0,    0,   94,    0,    0,    0,   95,    0,    0,
    0,    0,   96,   97,   98,   99,  100,    0,    0,    0,
  101,    0,  102,    0,    0,    0,    0,    0,  103,  104,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   55,    0,  105,  573,  107,  108,    0, 1131,   56,
   24,   57,   25,    0,    0,   26,   58,    0,   59,   60,
   27,   61,   62,   63,   28,    0,    0,    0,    0,    0,
   64,    0,   65,   30,   66,   67,   68,   69,    0,    0,
   32,    0,    0,    0,   70,   33,    0,   71,   72,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   73,
    0,   36,    0,   37,   74,    0,    0,   38,    0,   75,
   76,   77,   78,   79,   80,   39,   40,   81,   82,   41,
   83,    0,   84,    0,    0,   85,   86,    0,    0,   87,
   88,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   89,   90,   91,   92,   93,    0,
    0,    0,   94,    0,    0,    0,   95,    0,    0,    0,
    0,   96,   97,   98,   99,  100,    0,    0,    0,  101,
    0,  102,    0,    0,    0,    0,    0,  103,  104,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  266,    0,
    0,    0,  105,  106,  107,  108,   56,   24,   57,   25,
    0,    0,   26,   58,    0,   59,   60,   27,   61,   62,
   63,   28,    0,    0,    0,    0,    0,   64,    0,   65,
   30,   66,   67,   68,   69,    0,    0,   32,    0,    0,
    0,   70,   33,    0,   71,   72,   34,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   73,    0,   36,    0,
   37,   74,    0,    0,   38,    0,   75,   76,   77,   78,
   79,   80,   39,   40,   81,   82,   41,   83,    0,   84,
    0,    0,   85,   86,    0,    0,   87,   88,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   89,   90,   91,   92,   93,    0,    0,    0,   94,
    0,    0,    0,   95,    0,    0,    0,    0,   96,   97,
   98,   99,  100,    0,    0,    0,  101,    0,  102,    0,
    0,    0,    0,    0,  103,  104,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  572,    0,    0,    0,  105,
  106,  107,  108,   56,   24,   57,   25,    0,    0,   26,
   58,    0,   59,   60,   27,   61,   62,   63,   28,    0,
    0,    0,    0,    0,   64,    0,   65,   30,   66,   67,
   68,   69,    0,    0,   32,    0,    0,    0,   70,   33,
    0,   71,   72,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   73,    0,   36,    0,   37,   74,    0,
    0,   38,    0,   75,   76,   77,   78,   79,   80,   39,
   40,   81,   82,   41,   83,    0,   84,    0,    0,   85,
   86,    0,    0,   87,   88,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   89,   90,
   91,   92,   93,    0,    0,    0,   94,    0,    0,    0,
   95,    0,    0,    0,    0,   96,   97,   98,   99,  100,
    0,    0,    0,  101,    0,  102,    0,    0,    0,    0,
    0,  103,  104,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1007,    0,    0,    0,  105,  573,  107,  108,
 1007, 1007, 1007, 1007,    0,    0, 1007, 1007,    0, 1007,
 1007, 1007, 1007, 1007, 1007, 1007,    0,    0,    0,    0,
    0, 1007,    0, 1007, 1007, 1007, 1007, 1007, 1007,    0,
    0, 1007,    0,    0,    0, 1007, 1007,    0, 1007, 1007,
 1007,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1007,    0, 1007,    0, 1007, 1007,    0,    0, 1007,    0,
 1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007,
 1007, 1007,    0, 1007,    0,    0, 1007, 1007,    0,    0,
 1007, 1007,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1007, 1007, 1007, 1007, 1007,
    0,    0,    0, 1007,    0,    0,    0, 1007,    0,    0,
    0,    0, 1007, 1007, 1007, 1007, 1007,    0,    0,    0,
 1007,    0, 1007,    0,    0,    0,    0,    0, 1007, 1007,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  613,
    0,    0,    0, 1007, 1007, 1007, 1007,   56,   24,    0,
   25,    0,    0,   26,  254,    0,    0,    0,   27,   61,
   62,    0,   28,    0,    0,  182,    0,  182,   64,    0,
  182,   30,    0,    0,    0,  182,    0,    0,   32,  182,
    0,    0,    0,   33,    0,   71,   72,   34,  182,  614,
    0,    0,    0,    0,    0,  182,  615,    0,    0,   36,
  182,   37,   74,    0,  182,   38,    0,    0,   76,    0,
   78,    0,   80,   39,   40,  255,  182,   41,  182,    0,
    0,    0,  182,    0,  616,    0,    0,   87,   88,    0,
  182,  182,    0,    0,  182,    0,    0,  182,    0,    0,
    0,    0,   89,   90,   91,   92,   93,    0,    0,    0,
    0,    0,    0,    0,   95,    0,    0,  617,    0,    0,
   97,   98,   99,  100,    0,    0,    0,  101,    0,  102,
    0,    0, 1031,    0,    0,  103,  104,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  786,    0,    0,    0,
  105,  106,  107,  108,   56,   24,    0,   25,    0,    0,
   26,  254,    0,    0,    0,   27,   61,   62,  182,   28,
    0,    0,  182,    0,  182,   64,    0,  182,   30,    0,
    0,    0,  182,    0,    0,   32,  182,    0,    0,    0,
   33,    0,   71,   72,   34,  182,    0,    0,    0,    0,
    0,    0,  182,    0,    0,    0,   36,  182,   37,   74,
    0,  182,   38,    0,    0,   76,    0,   78,    0,   80,
   39,   40,  255,  182,   41,  182,    0,    0,    0,  182,
    0,   86,    0,    0,   87,   88,    0,  182,  182,    0,
    0,  182,    0,    0,  182,    0,    0,    0,    0,   89,
   90,   91,   92,  302,    0,    0,    0,  531,  787,    0,
    0,   95,    0,    0,    0,    0,    0,   97,   98,   99,
  100,    0,    0,    0,  101,    0,  102, 1031,    0,    0,
    0,    0,  103,  104,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  977,    0,    0,    0,  105,  303,  107,
  108,   56,   24,    0,   25,    0,    0,   26,  254,    0,
    0,    0,   27,   61,   62,  182,   28,    0,    0,   24,
    0,   25,   64,    0,   26,   30,    0,    0,    0,   27,
    0,    0,   32,   28,    0,    0,    0,   33,    0,   71,
   72,   34,   30,  614,    0,    0,    0,    0,    0,   32,
  615,    0,    0,   36,   33,   37,   74,    0,   34,   38,
    0,    0,   76,    0,   78,    0,   80,   39,   40,  255,
   36,   41,   37,    0,    0,    0,   38,    0,  616,    0,
    0,   87,   88,    0,   39,   40,    0,    0,   41,    0,
    0,  324,    0,    0,    0,    0,   89,   90,   91,   92,
   93,    0,    0,    0,    0,    0,    0,    0,   95,    0,
    0,    0,    0,    0,   97,   98,   99,  100,    0,    0,
    0,  101,    0,  102,    0,    0,    0,    0,    0,  103,
  104,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  786,    0,    0,    0,  105,  106,  107,  108,   56,   24,
    0,   25,    0,    0,   26,  254,    0,    0,    0,   27,
   61,   62,  368,   28,    0,    0,   24,    0,   25,   64,
    0,   26,   30,    0,    0,    0,   27,    0,    0,   32,
   28,    0,    0,    0,   33,    0,   71,   72,   34,   30,
    0,    0,    0,    0,    0,    0,   32,    0,    0,    0,
   36,   33,   37,   74,  983,   34,   38,    0,    0,   76,
    0,   78,    0,   80,   39,   40,  255,   36,   41,   37,
    0,    0,    0,   38,    0,   86,    0,    0,   87,   88,
    0,   39,   40,    0,    0,   41,    0,    0,  533,    0,
    0,    0,    0,   89,   90,   91,   92,  302,    0,    0,
    0,  531,    0,    0,    0,   95,    0,    0,    0,    0,
    0,   97,   98,   99,  100,    0,    0,    0,  101,    0,
  102,    0,    0,    0,    0,    0,  103,  104,    0,    0,
    0,    0,    0,    0,   56,   24,    0,   25,    0,    0,
   26,  254,    0,    0,    0,   27,   61,   62,    0,   28,
    0,  105,  303,  107,  108,   64,    0,    0,   30,    0,
    0,    0,    0,    0,    0,   32,    0,    0,    0,  368,
   33,    0,   71,   72,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   74,
    0,    0,   38,    0,    0,   76,    0,   78,    0,   80,
   39,   40,  255,    0,   41,    0,    0,    0,    0,    0,
    0,   86,    0,    0,   87,   88,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   89,
   90,   91,   92,  769,    0,    0,    0,  770, 1051,    0,
    0,   95,    0,    0,    0,    0,    0,   97,   98,   99,
  100,    0,    0,    0,  101,    0,  102,    0,    0,    0,
    0,    0,  103,  104,    0,    0,    0,    0,    0,    0,
   56,   24,    0,   25,    0,    0,   26,  254,    0,    0,
    0,   27,   61,   62,    0,   28,    0,  105,  771,  107,
  108,   64,    0,    0,   30,    0,    0,    0,  772,    0,
    0,   32,    0,    0,    0,    0,   33,    0,   71,   72,
   34,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   36,    0,   37,   74,    0,    0,   38,    0,
    0,   76,    0,   78,    0,   80,   39,   40,  255,    0,
   41,    0,    0,    0,    0,    0,    0,   86,    0,    0,
   87,   88,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   89,   90,   91,   92,  769,
    0,    0,    0,  770,    0,    0,    0,   95,    0,    0,
    0,    0,    0,   97,   98,   99,  100,    0,    0,    0,
  101,    0,  102,    0,    0,    0,    0,    0,  103,  104,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  786,    0,  105,  771,  107,  108,    0,    0,   56,
   24,    0,   25,    0,  772,   26,  254,    0,    0,    0,
   27,   61,   62,    0,   28,    0,    0,   24,    0,   25,
   64,    0,   26,   30,    0,    0,    0,   27,    0,    0,
   32,   28,    0,    0,    0,   33,    0,   71,   72,   34,
   30,    0,    0,    0,    0,    0,    0,   32,    0,    0,
    0,   36,   33,   37,   74,    0,   34,   38,    0,    0,
   76,    0,   78,    0,   80,   39,   40,  255,   36,   41,
   37,    0,    0,    0,   38,    0,   86,    0,    0,   87,
   88,    0,   39,   40,    0,    0,   41,    0,    0,  589,
    0,    0,    0,    0,   89,   90,   91,   92,  302,    0,
    0,    0,  531,    0,    0,    0,   95,    0,    0,    0,
    0,    0,   97,   98,   99,  100,    0,    0,    0,  101,
    0,  102,    0,    0,    0,    0,    0,  103,  104,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  778,    0,
    0,    0,  105,  303,  107,  108,   56,   24,    0,   25,
    0,    0,   26,  254,    0,    0,    0,   27,   61,   62,
  368,   28,    0,    0,   24,    0,   25,   64,    0,   26,
   30,    0,    0,    0,   27,    0,    0,   32,   28,    0,
    0,    0,   33,    0,   71,   72,   34,   30,    0,    0,
    0,    0,    0,    0,   32,    0,    0,    0,   36,   33,
   37,   74,    0,   34,   38,    0,    0,   76,    0,   78,
    0,   80,   39,   40,  255,   36,   41,   37,    0,    0,
    0,   38,    0,   86,    0,    0,   87,   88,    0,   39,
   40,    0,    0,   41,    0,    0,  802,    0,    0,    0,
    0,   89,   90,   91,   92,  302,    0,    0,    0,    0,
  935,    0,    0,   95,    0,    0,    0,    0,    0,   97,
   98,   99,  100,    0,    0,    0,  101,    0,  102,    0,
    0,    0,    0,    0,  103,  104,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  980,    0,    0,    0,  105,
  303,  107,  108,   56,   24,    0,   25,    0,    0,   26,
  254,    0,    0,    0,   27,   61,   62,  368,   28,    0,
    0,  502,    0,  502,   64,    0,  502,   30,    0,    0,
    0,  502,    0,    0,   32,  502,    0,    0,    0,   33,
    0,   71,   72,   34,  502,    0,    0,    0,    0,    0,
    0,  502,    0,    0,    0,   36,  502,   37,   74,    0,
  502,   38,    0,    0,   76,    0,   78,    0,   80,   39,
   40,  255,  502,   41,  502,    0,    0,    0,  502,    0,
   86,    0,    0,   87,   88,    0,  502,  502,    0,    0,
  502,    0,    0,  502,    0,    0,    0,    0,   89,   90,
   91,   92,  302,    0,    0,    0,    0,  981,    0,    0,
   95,    0,    0,    0,    0,    0,   97,   98,   99,  100,
    0,    0,    0,  101,    0,  102,    0,    0,    0,    0,
    0,  103,  104,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  301,    0,    0,    0,  105,  303,  107,  108,
   56,   24,    0,   25,    0,    0,   26,  254,    0,    0,
    0,   27,   61,   62,  502,   28,    0,    0,  183,    0,
  183,   64,    0,  183,   30,    0,    0,    0,  183,    0,
    0,   32,  183,    0,    0,    0,   33,    0,   71,   72,
   34,  183,    0,    0,    0,    0,    0,    0,  183,    0,
    0,    0,   36,  183,   37,   74,    0,  183,   38,    0,
    0,   76,    0,   78,    0,   80,   39,   40,  255,  183,
   41,  183,    0,    0,    0,  183,    0,   86,    0,    0,
   87,   88,    0,  183,  183,    0,    0,  183,    0,    0,
  183,    0,    0,    0,    0,   89,   90,   91,   92,  302,
    0,    0,    0,    0,    0,    0,    0,   95,    0,    0,
    0,    0,    0,   97,   98,   99,  100,    0,    0,    0,
  101,    0,  102,    0,    0,    0,    0,    0,  103,  104,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  310,
    0,    0,    0,  105,  303,  107,  108,   56,   24,    0,
   25,    0,    0,   26,  254,    0,    0,    0,   27,   61,
   62,  183,   28,    0,    0,  182,    0,  182,   64,    0,
  182,   30,    0,    0,    0,  182,    0,    0,   32,  182,
    0,    0,    0,   33,    0,   71,   72,   34,  182,    0,
    0,    0,    0,    0,    0,  182,    0,    0,    0,   36,
  182,   37,   74,    0,  182,   38,    0,    0,   76,    0,
   78,    0,   80,   39,   40,  255,  182,   41,  182,    0,
    0,    0,  182,    0,   86,    0,    0,   87,   88,    0,
  182,  182,    0,    0,  182,    0,    0,  182,    0,    0,
    0,    0,   89,   90,   91,   92,  302,    0,    0,    0,
    0,    0,    0,    0,   95,    0,    0,    0,    0,    0,
   97,   98,   99,  100,    0,    0,    0,  101,    0,  102,
    0,    0,    0,    0,    0,  103,  104,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  611,    0,    0,    0,
  105,  303,  107,  108,   56,   24,    0,   25,    0,    0,
   26,  254,    0,    0,    0,   27,   61,   62,  182,   28,
    0,    0,  192,    0,  192,   64,    0,  192,   30,    0,
    0,    0,  192,    0,    0,   32,  192,    0,    0,    0,
   33,    0,   71,   72,   34,  192,    0,    0,    0,    0,
    0,    0,  192,    0,    0,    0,   36,  192,   37,   74,
    0,  192,   38,    0,    0,   76,    0,   78,    0,   80,
   39,   40,  255,  192,   41,  192,    0,    0,    0,  192,
    0,   86,    0,    0,   87,   88,    0,  192,  192,    0,
    0,  192,    0,    0,  192,    0,    0,    0,    0,   89,
   90,   91,   92,   93,    0,    0,    0,    0,    0,    0,
    0,   95,    0,    0,    0,    0,    0,   97,   98,   99,
  100,    0,    0,    0,  101,    0,  102,    0,    0,    0,
    0,    0,  103,  104,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  778,    0,    0,    0,  105,  106,  107,
  108,   56,   24,    0,   25,    0,    0,   26,  254,    0,
    0,    0,   27,   61,   62,  192,   28,    0,    0,    0,
    0,    0,   64,    0,    0,   30,    0,    0,    0,    0,
    0,    0,   32,    0,    0,    0,    0,   33,    0,   71,
   72,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   74,    0,    0,   38,
    0,    0,   76,    0,   78,    0,   80,   39,   40,  255,
    0,   41,    0,    0,    0,    0,    0,    0,   86,    0,
    0,   87,   88,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   89,   90,   91,   92,
  302,    0,    0,    0,    0,    0,    0,    0,   95,    0,
    0,    0,    0,    0,   97,   98,   99,  100,    0,    0,
    0,  101,    0,  102,    0,    0,    0,    0,    0,  103,
  104,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1093,    0,    0,    0,  105,  303,  107,  108,   56,   24,
    0,   25,    0,    0,   26,  254,    0,    0,    0,   27,
   61,   62,    0,   28,    0,    0,    0,    0,    0,   64,
    0,    0,   30,    0,    0,    0,    0,    0,    0,   32,
    0,    0,    0,    0,   33,    0,   71,   72,   34,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   36,    0,   37,   74,    0,    0,   38,    0,    0,   76,
    0,   78,    0,   80,   39,   40,  255,    0,   41,    0,
    0,    0,    0,    0,    0,   86,    0,    0,   87,   88,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   89,   90,   91,   92,   93,    0,    0,
    0,    0,    0,    0,    0,   95,    0,    0,    0,    0,
    0,   97,   98,   99,  100,    0,    0,    0,  101,    0,
  102,    0,    0,    0,    0,    0,  103,  104,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1238,    0,    0,
    0,  105, 1094,  107,  108,   56,   24,    0,   25,    0,
    0,   26,  254,    0,    0,    0,   27,   61,   62,    0,
   28,    0,    0,    0,    0,    0,   64,    0,    0,   30,
    0,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   71,   72,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   74,    0,    0,   38,    0,    0,   76,    0,   78,    0,
   80,   39,   40,  255,    0,   41,    0,    0,    0,    0,
    0,    0,   86,    0,    0,   87,   88,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   89,   90,   91,   92,  302,    0,    0,    0,    0,    0,
    0,    0,   95,    0,    0,    0,    0,    0,   97,   98,
   99,  100,    0,    0,    0,  101,    0,  102,    0,    0,
    0,    0,    0,  103,  104,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   83,    0,    0,    0,  105,  303,
  107,  108,   83,   83,    0,   83,    0,    0,   83,   83,
    0,    0,    0,   83,   83,   83,    0,   83,    0,    0,
    0,    0,    0,   83,    0,    0,   83,    0,    0,    0,
    0,    0,    0,   83,    0,    0,    0,    0,   83,    0,
   83,   83,   83,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   83,    0,   83,   83,    0,    0,
   83,    0,    0,   83,    0,   83,    0,   83,   83,   83,
   83,    0,   83,    0,    0,    0,    0,    0,    0,   83,
    0,    0,   83,   83,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   83,   83,   83,
   83,   83,    0,    0,    0,    0,    0,    0,    0,   83,
    0,    0,    0,    0,    0,   83,   83,   83,   83,    0,
    0,    0,   83,    0,   83,    0,    0,    0,    0,    0,
   83,   83,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  340,    0,    0,    0,   83,   83,   83,   83,   56,
   24,    0,   25,    0,    0,   26,  254,    0,    0,    0,
   27,   61,   62,    0,   28,    0,    0,    0,    0,    0,
   64,    0,    0,   30,    0,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   71,   72,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   74,    0,    0,   38,    0,    0,
   76,    0,   78,    0,   80,   39,   40,  255,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,  341,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   89,   90,   91,  256,  342,    0,
    0,    0,    0,    0,    0,    0,   95,    0,    0,    0,
    0,    0,   97,   98,   99,  100,  934,    0,    0,  101,
    0,  102,  340,    0,    0,    0,    0,  103,  104,    0,
   56,   24,    0,   25,    0,    0,   26,  254,    0,    0,
    0,   27,   61,   62,    0,   28,    0,    0,    0,    0,
    0,   64,  105,  257,   30,  108,    0,    0,    0,    0,
    0,   32,    0,    0,    0,    0,   33,    0,   71,   72,
   34,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   36,    0,   37,   74,    0,    0,   38,    0,
    0,   76,    0,   78,    0,   80,   39,   40,  255,    0,
   41,    0,    0,    0,    0,    0,    0,    0,    0,  341,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   89,   90,   91,  256,  342,
    0,    0,    0,    0,    0,    0,    0,   95,    0,    0,
    0,    0,    0,   97,   98,   99,  100,    0,    0,    0,
  101,    0,  102,  346,    0,    0,    0,    0,  103,  104,
    0,   56,   24,    0,   25,    0,    0,   26,  254,    0,
    0,    0,   27,   61,   62,    0,   28,    0,    0,    0,
    0,    0,   64,  105,  257,   30,  108,    0,    0,    0,
    0,    0,   32,    0,    0,    0,    0,   33,    0,   71,
   72,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   74,    0,    0,   38,
    0,    0,   76,    0,   78,    0,   80,   39,   40,  255,
    0,   41,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   89,   90,   91,  256,
  342,    0,    0,    0,    0,    0,    0,    0,   95,    0,
    0,    0,    0,    0,   97,   98,   99,  100,    0,    0,
    0,  101,    0,  102,  348,    0,    0,    0,    0,  103,
  104,    0,   56,   24,    0,   25,    0,    0,   26,  254,
    0,    0,    0,   27,   61,   62,    0,   28,    0,    0,
    0,    0,    0,   64,  105,  257,   30,  108,    0,    0,
    0,    0,    0,   32,    0,    0,    0,    0,   33,    0,
   71,   72,   34,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   36,    0,   37,   74,    0,    0,
   38,    0,    0,   76,    0,   78,    0,   80,   39,   40,
  255,    0,   41,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   89,   90,   91,
  256,  342,    0,    0,    0,    0,    0,    0,    0,   95,
    0,    0,    0,    0,    0,   97,   98,   99,  100,    0,
    0,    0,  101,    0,  102,  350,    0,    0,    0,    0,
  103,  104,    0,   56,   24,    0,   25,    0,    0,   26,
  254,    0,    0,    0,   27,   61,   62,    0,   28,    0,
    0,    0,    0,    0,   64,  105,  257,   30,  108,    0,
    0,    0,    0,    0,   32,    0,    0,    0,    0,   33,
    0,   71,   72,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   74,    0,
    0,   38,    0,    0,   76,    0,   78,    0,   80,   39,
   40,  255,    0,   41,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   89,   90,
   91,  256,  342,    0,    0,    0,    0,    0,    0,    0,
   95,    0,    0,    0,    0,    0,   97,   98,   99,  100,
    0,    0,    0,  101,    0,  102,  352,    0,    0,    0,
    0,  103,  104,    0,   56,   24,    0,   25,    0,    0,
   26,  254,    0,    0,    0,   27,   61,   62,    0,   28,
    0,    0,    0,    0,    0,   64,  105,  257,   30,  108,
    0,    0,    0,    0,    0,   32,    0,    0,    0,    0,
   33,    0,   71,   72,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   74,
    0,    0,   38,    0,    0,   76,    0,   78,    0,   80,
   39,   40,  255,    0,   41,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   89,
   90,   91,  256,  342,    0,    0,    0,    0,    0,    0,
    0,   95,    0,    0,    0,    0,    0,   97,   98,   99,
  100,    0,    0,    0,  101,    0,  102,  354,    0,    0,
    0,    0,  103,  104,    0,   56,   24,    0,   25,    0,
    0,   26,  254,    0,    0,    0,   27,   61,   62,    0,
   28,    0,    0,    0,    0,    0,   64,  105,  257,   30,
  108,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   71,   72,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   74,    0,    0,   38,    0,    0,   76,    0,   78,    0,
   80,   39,   40,  255,    0,   41,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   89,   90,   91,  256,  342,    0,    0,    0,    0,    0,
    0,    0,   95,    0,    0,    0,    0,    0,   97,   98,
   99,  100,    0,    0,    0,  101,    0,  102,  356,    0,
    0,    0,    0,  103,  104,    0,   56,   24,    0,   25,
    0,    0,   26,  254,    0,    0,    0,   27,   61,   62,
    0,   28,    0,    0,    0,    0,    0,   64,  105,  257,
   30,  108,    0,    0,    0,    0,    0,   32,    0,    0,
    0,    0,   33,    0,   71,   72,   34,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   36,    0,
   37,   74,    0,    0,   38,    0,    0,   76,    0,   78,
    0,   80,   39,   40,  255,    0,   41,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   89,   90,   91,  256,  342,    0,    0,    0,    0,
    0,    0,    0,   95,    0,    0,    0,    0,    0,   97,
   98,   99,  100,    0,    0,    0,  101,    0,  102,  358,
    0,    0,    0,    0,  103,  104,    0,   56,   24,    0,
   25,    0,    0,   26,  254,    0,    0,    0,   27,   61,
   62,    0,   28,    0,    0,    0,    0,    0,   64,  105,
  257,   30,  108,    0,    0,    0,    0,    0,   32,    0,
    0,    0,    0,   33,    0,   71,   72,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,   74,    0,    0,   38,    0,    0,   76,    0,
   78,    0,   80,   39,   40,  255,    0,   41,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   89,   90,   91,  256,  342,    0,    0,    0,
    0,    0,    0,    0,   95,    0,    0,    0,    0,    0,
   97,   98,   99,  100,    0,    0,    0,  101,    0,  102,
  360,    0,    0,    0,    0,  103,  104,    0,   56,   24,
    0,   25,    0,    0,   26,  254,    0,    0,    0,   27,
   61,   62,    0,   28,    0,    0,    0,    0,    0,   64,
  105,  257,   30,  108,    0,    0,    0,    0,    0,   32,
    0,    0,    0,    0,   33,    0,   71,   72,   34,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   36,    0,   37,   74,    0,    0,   38,    0,    0,   76,
    0,   78,    0,   80,   39,   40,  255,    0,   41,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   89,   90,   91,  256,  342,    0,    0,
    0,    0,    0,    0,    0,   95,    0,    0,    0,    0,
    0,   97,   98,   99,  100,    0,    0,    0,  101,    0,
  102,  340,    0,    0,    0,    0,  103,  104,    0,   56,
   24,    0,   25,    0,    0,   26,  254,    0,    0,    0,
   27,   61,   62,    0,   28,    0,    0,    0,    0,    0,
   64,  105,  257,   30,  108,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   71,   72,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   74,    0,    0,   38,    0,    0,
   76,    0,   78,    0,   80,   39,   40,  255,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   89,   90,   91,  256,  342,    0,
    0,    0,    0,    0,    0,    0,   95,    0,    0,    0,
    0,    0,   97,   98,   99,  100,    0,    0,    0,  101,
    0,  102,  636,    0,    0,    0,    0,  103,  104,    0,
   56,   24,    0,   25,    0,    0,   26,  254,    0,    0,
    0,   27,   61,   62,    0,   28,    0,    0,    0,    0,
    0,   64,  105,  257,   30,  108,    0,    0,    0,    0,
    0,   32,    0,    0,    0,    0,   33,    0,   71,   72,
   34,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   36,    0,   37,   74,    0,    0,   38,    0,
    0,   76,    0,   78,    0,   80,   39,   40,  255,    0,
   41,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   89,   90,   91,  256,  342,
    0,    0,    0,    0,    0,    0,    0,   95,    0,    0,
    0,    0,    0,   97,   98,   99,  100,    0,    0,    0,
  101,    0,  102,  638,    0,    0,    0,    0,  103,  104,
    0,   56,   24,    0,   25,    0,    0,   26,  254,    0,
    0,    0,   27,   61,   62,    0,   28,    0,    0,    0,
    0,    0,   64,  105,  257,   30,  108,    0,    0,    0,
    0,    0,   32,    0,    0,    0,    0,   33,    0,   71,
   72,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   74,    0,    0,   38,
    0,    0,   76,    0,   78,    0,   80,   39,   40,  255,
    0,   41,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   89,   90,   91,  256,
  342,    0,    0,    0,    0,    0,    0,    0,   95,    0,
    0,    0,    0,    0,   97,   98,   99,  100,    0,    0,
    0,  101,    0,  102,  640,    0,    0,    0,    0,  103,
  104,    0,   56,   24,    0,   25,    0,    0,   26,  254,
    0,    0,    0,   27,   61,   62,    0,   28,    0,    0,
    0,    0,    0,   64,  105,  257,   30,  108,    0,    0,
    0,    0,    0,   32,    0,    0,    0,    0,   33,    0,
   71,   72,   34,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   36,    0,   37,   74,    0,    0,
   38,    0,    0,   76,    0,   78,    0,   80,   39,   40,
  255,    0,   41,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   89,   90,   91,
  256,  342,    0,    0,    0,    0,    0,    0,    0,   95,
    0,    0,    0,    0,    0,   97,   98,   99,  100,    0,
    0,    0,  101,    0,  102,  646,    0,    0,    0,    0,
  103,  104,    0,   56,   24,    0,   25,    0,    0,   26,
  254,    0,    0,    0,   27,   61,   62,    0,   28,    0,
    0,    0,    0,    0,   64,  105,  257,   30,  108,    0,
    0,    0,    0,    0,   32,    0,    0,    0,    0,   33,
    0,   71,   72,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   74,    0,
    0,   38,    0,    0,   76,    0,   78,    0,   80,   39,
   40,  255,    0,   41,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   89,   90,
   91,  256,  342,    0,    0,    0,    0,    0,    0,    0,
   95,    0,    0,    0,    0,    0,   97,   98,   99,  100,
    0,    0,    0,  101,    0,  102,  648,    0,    0,    0,
    0,  103,  104,    0,   56,   24,    0,   25,    0,    0,
   26,  254,    0,    0,    0,   27,   61,   62,    0,   28,
    0,    0,    0,    0,    0,   64,  105,  257,   30,  108,
    0,    0,    0,    0,    0,   32,    0,    0,    0,    0,
   33,    0,   71,   72,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   74,
    0,    0,   38,    0,    0,   76,    0,   78,    0,   80,
   39,   40,  255,    0,   41,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   89,
   90,   91,  256,  342,    0,    0,    0,    0,    0,    0,
    0,   95,    0,    0,    0,    0,    0,   97,   98,   99,
  100,    0,    0,    0,  101,    0,  102,  650,    0,    0,
    0,    0,  103,  104,    0,   56,   24,    0,   25,    0,
    0,   26,  254,    0,    0,    0,   27,   61,   62,    0,
   28,    0,    0,    0,    0,    0,   64,  105,  257,   30,
  108,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   71,   72,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   74,    0,    0,   38,    0,    0,   76,    0,   78,    0,
   80,   39,   40,  255,    0,   41,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   89,   90,   91,  256,  342,    0,    0,    0,    0,    0,
    0,    0,   95,    0,    0,    0,    0,    0,   97,   98,
   99,  100,    0,    0,    0,  101,    0,  102,  652,    0,
    0,    0,    0,  103,  104,    0,   56,   24,    0,   25,
    0,    0,   26,  254,    0,    0,    0,   27,   61,   62,
    0,   28,    0,    0,    0,    0,    0,   64,  105,  257,
   30,  108,    0,    0,    0,    0,    0,   32,    0,    0,
    0,    0,   33,    0,   71,   72,   34,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   36,    0,
   37,   74,    0,    0,   38,    0,    0,   76,    0,   78,
    0,   80,   39,   40,  255,    0,   41,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   89,   90,   91,  256,  342,    0,    0,    0,    0,
    0,    0,    0,   95,    0,    0,    0,    0,    0,   97,
   98,   99,  100,    0,    0,    0,  101,    0,  102,  654,
    0,    0,    0,    0,  103,  104,    0,   56,   24,    0,
   25,    0,    0,   26,  254,    0,    0,    0,   27,   61,
   62,    0,   28,    0,    0,    0,    0,    0,   64,  105,
  257,   30,  108,    0,    0,    0,    0,    0,   32,    0,
    0,    0,    0,   33,    0,   71,   72,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,   74,    0,    0,   38,    0,    0,   76,    0,
   78,    0,   80,   39,   40,  255,    0,   41,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   89,   90,   91,  256,  342,    0,    0,    0,
    0,    0,    0,    0,   95,    0,    0,    0,    0,    0,
   97,   98,   99,  100,    0,    0,    0,  101,    0,  102,
  656,    0,    0,    0,    0,  103,  104,    0,   56,   24,
    0,   25,    0,    0,   26,  254,    0,    0,    0,   27,
   61,   62,    0,   28,    0,    0,    0,    0,    0,   64,
  105,  257,   30,  108,    0,    0,    0,    0,    0,   32,
    0,    0,    0,    0,   33,    0,   71,   72,   34,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   36,    0,   37,   74,    0,    0,   38,    0,    0,   76,
    0,   78,    0,   80,   39,   40,  255,    0,   41,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   89,   90,   91,  256,  342,    0,    0,
    0,    0,    0,    0,    0,   95,    0,    0,    0,    0,
    0,   97,   98,   99,  100,    0,    0,    0,  101,    0,
  102,  658,    0,    0,    0,    0,  103,  104,    0,   56,
   24,    0,   25,    0,    0,   26,  254,    0,    0,    0,
   27,   61,   62,    0,   28,    0,    0,    0,    0,    0,
   64,  105,  257,   30,  108,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   71,   72,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   74,    0,    0,   38,    0,    0,
   76,    0,   78,    0,   80,   39,   40,  255,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   89,   90,   91,  256,  342,    0,
    0,    0,    0,    0,    0,    0,   95,    0,    0,    0,
    0,    0,   97,   98,   99,  100,    0,    0,    0,  101,
    0,  102,  660,    0,    0,    0,    0,  103,  104,    0,
   56,   24,    0,   25,    0,    0,   26,  254,    0,    0,
    0,   27,   61,   62,    0,   28,    0,    0,    0,    0,
    0,   64,  105,  257,   30,  108,    0,    0,    0,    0,
    0,   32,    0,    0,    0,    0,   33,    0,   71,   72,
   34,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   36,    0,   37,   74,    0,    0,   38,    0,
    0,   76,    0,   78,    0,   80,   39,   40,  255,    0,
   41,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   89,   90,   91,  256,  342,
    0,    0,    0,    0,    0,    0,    0,   95,    0,    0,
    0,    0,    0,   97,   98,   99,  100,    0,    0,    0,
  101,    0,  102,  662,    0,    0,    0,    0,  103,  104,
    0,   56,   24,    0,   25,    0,    0,   26,  254,    0,
    0,    0,   27,   61,   62,    0,   28,    0,    0,    0,
    0,    0,   64,  105,  257,   30,  108,    0,    0,    0,
    0,    0,   32,    0,    0,    0,    0,   33,    0,   71,
   72,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   74,    0,    0,   38,
    0,    0,   76,    0,   78,    0,   80,   39,   40,  255,
    0,   41,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   89,   90,   91,  256,
  342,    0,    0,    0,    0,    0,    0,    0,   95,    0,
    0,    0,    0,    0,   97,   98,   99,  100,    0,    0,
    0,  101,    0,  102,  664,    0,    0,    0,    0,  103,
  104,    0,   56,   24,    0,   25,    0,    0,   26,  254,
    0,    0,    0,   27,   61,   62,    0,   28,    0,    0,
    0,    0,    0,   64,  105,  257,   30,  108,    0,    0,
    0,    0,    0,   32,    0,    0,    0,    0,   33,    0,
   71,   72,   34,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   36,    0,   37,   74,    0,    0,
   38,    0,    0,   76,    0,   78,    0,   80,   39,   40,
  255,    0,   41,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   89,   90,   91,
  256,  342,    0,    0,    0,    0,    0,    0,    0,   95,
    0,    0,    0,    0,    0,   97,   98,   99,  100,    0,
    0,    0,  101,    0,  102,  666,    0,    0,    0,    0,
  103,  104,    0,   56,   24,    0,   25,    0,    0,   26,
  254,    0,    0,    0,   27,   61,   62,    0,   28,    0,
    0,    0,    0,    0,   64,  105,  257,   30,  108,    0,
    0,    0,    0,    0,   32,    0,    0,    0,    0,   33,
    0,   71,   72,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   74,    0,
    0,   38,    0,    0,   76,    0,   78,    0,   80,   39,
   40,  255,    0,   41,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   89,   90,
   91,  256,  342,    0,    0,    0,    0,    0,    0,    0,
   95,    0,    0,    0,    0,    0,   97,   98,   99,  100,
    0,    0,    0,  101,    0,  102,  668,    0,    0,    0,
    0,  103,  104,    0,   56,   24,    0,   25,    0,    0,
   26,  254,    0,    0,    0,   27,   61,   62,    0,   28,
    0,    0,    0,    0,    0,   64,  105,  257,   30,  108,
    0,    0,    0,    0,    0,   32,    0,    0,    0,    0,
   33,    0,   71,   72,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   74,
    0,    0,   38,    0,    0,   76,    0,   78,    0,   80,
   39,   40,  255,    0,   41,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   89,
   90,   91,  256,  342,    0,    0,    0,    0,    0,    0,
    0,   95,    0,    0,    0,    0,    0,   97,   98,   99,
  100,    0,    0,    0,  101,    0,  102,  670,    0,    0,
    0,    0,  103,  104,    0,   56,   24,    0,   25,    0,
    0,   26,  254,    0,    0,    0,   27,   61,   62,    0,
   28,    0,    0,    0,    0,    0,   64,  105,  257,   30,
  108,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   71,   72,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   74,    0,    0,   38,    0,    0,   76,    0,   78,    0,
   80,   39,   40,  255,    0,   41,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   89,   90,   91,  256,  342,    0,    0,    0,    0,    0,
    0,    0,   95,    0,    0,    0,    0,    0,   97,   98,
   99,  100,    0,    0,    0,  101,    0,  102,  672,    0,
    0,    0,    0,  103,  104,    0,   56,   24,    0,   25,
    0,    0,   26,  254,    0,    0,    0,   27,   61,   62,
    0,   28,    0,    0,    0,    0,    0,   64,  105,  257,
   30,  108,    0,    0,    0,    0,    0,   32,    0,    0,
    0,    0,   33,    0,   71,   72,   34,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   36,    0,
   37,   74,    0,    0,   38,    0,    0,   76,    0,   78,
    0,   80,   39,   40,  255,    0,   41,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   89,   90,   91,  256,  342,    0,    0,    0,    0,
    0,    0,    0,   95,    0,    0,    0,    0,    0,   97,
   98,   99,  100,    0,    0,    0,  101,    0,  102,  674,
    0,    0,    0,    0,  103,  104,    0,   56,   24,    0,
   25,    0,    0,   26,  254,    0,    0,    0,   27,   61,
   62,    0,   28,    0,    0,    0,    0,    0,   64,  105,
  257,   30,  108,    0,    0,    0,    0,    0,   32,    0,
    0,    0,    0,   33,    0,   71,   72,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,   74,    0,    0,   38,    0,    0,   76,    0,
   78,    0,   80,   39,   40,  255,    0,   41,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   89,   90,   91,  256,  342,    0,    0,    0,
    0,    0,    0,    0,   95,    0,    0,    0,    0,    0,
   97,   98,   99,  100,    0,    0,    0,  101,    0,  102,
  842,    0,    0,    0,    0,  103,  104,    0,   56,   24,
    0,   25,    0,    0,   26,  254,    0,    0,    0,   27,
   61,   62,    0,   28,    0,    0,    0,    0,    0,   64,
  105,  257,   30,  108,    0,    0,    0,    0,    0,   32,
    0,    0,    0,    0,   33,    0,   71,   72,   34,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   36,    0,   37,   74,    0,    0,   38,    0,    0,   76,
    0,   78,    0,   80,   39,   40,  255,    0,   41,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   89,   90,   91,  256,  342,    0,    0,
    0,    0,    0,    0,    0,   95,    0,    0,    0,    0,
    0,   97,   98,   99,  100,    0,    0,    0,  101,    0,
  102,  513,    0,    0,    0,    0,  103,  104,  347,   56,
   24,    0,   25,    0,    0,   26,  254,    0,    0,    0,
   27,   61,   62,    0,   28,    0,    0,    0,    0,    0,
   64,  105,  257,   30,  108,    0,    0,    0,    0,    0,
   32,    0,    0,    0,  347,   33,    0,   71,   72,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   74,    0,    0,   38,    0,    0,
   76,    0,   78,    0,   80,   39,   40,  255,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   89,   90,   91,  256,  291,    0,
    0,    0,    0,    0,    0,    0,   95,  347,  347,  347,
  347,  796,    0,    0,  347,  347,    0,    0,  347,  347,
  347,  347,  347,  347,  347,  347,  347,    0,  347,  347,
  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
  347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
    0,    0,  105,  514,    0,    0,  347,    0,   52,  347,
   52,    0,   52,    0,   52,    0,    0,   52,    0,   52,
   52,    0,   52,    0,   52,    0,   52,    0,   52,   52,
   52,   52,    0,    0,   52,   52,    0,    0,    0,    0,
   52,   52,   52,   52,   52,    0,    0,   52,    0,   52,
    0,   52,    0,   52,   52,    0,   52,   52,   52,   52,
    0,    0,   52,   52,   52,   52,    0,    0,   52,   52,
   52,    0,    0,    0,    0,    0,    0,   52,   52,    0,
   52,   52,    0,   52,   52,   52,    0,    0,    0,   52,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   52,
    0,   52,   52,   51,    0,    0,    0,   51,    0,   51,
    0,    0,   51,    0,   51,   51,    0,   51,    0,   51,
    0,   51,    0,   51,   51,   51,   51,    0,    0,   51,
   51,    0,    0,    0,    0,   51,    0,   51,   51,   51,
    0,    0,   51,    0,   51,    0,   51,    0,    0,   51,
    0,   51,   51,   51,   51,   52,    0,    0,   51,   51,
   51,    0,    0,   51,   51,   51,    0,    0,    0,    0,
    0,    0,   51,   51,    0,   51,   51,    0,   51,   51,
   51,    0,    0,    0,   51,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   51,    0,   51,    0,   51,    0,   51,    0,
   86,   51,    0,   51,   51,    0,   51,    0,   51,   51,
   51,    0,   51,   51,   51,   51,    0,    0,   51,   51,
    0,    0,    0,    0,   51,    0,   51,   51,   51,    0,
    0,   51,    0,   51,    0,   51,    0,    0,   51,    0,
   51,   51,   51,   51,    0,    0,    0,   51,   51,   51,
   51,    0,   51,   51,   51,    0,    0,    0,    0,    0,
    0,   51,   51,    0,   51,   51,    0,   51,   51,   51,
    0,    0,    0,   51,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   52,    0,   51,    0,   52,    0,   52,    0,   87,
   52,    0,   52,   52,    0,   52,    0,   52,   51,   52,
    0,   52,   52,   52,   52,    0,    0,   52,   52,    0,
    0,    0,    0,   52,    0,   52,   52,   52,    0,    0,
   52,    0,   52,    0,   52,    0,    0,   52,    0,   52,
   52,   52,   52,    0,    0,    0,   52,   52,   52,   51,
    0,   52,   52,   52,    0,    0,    0,    0,    0,    0,
   52,   52,    0,   52,   52,    0,   52,   52,   52,    0,
    0,    0,   52,    0,    0,    0,    0,   51,    0,    0,
    0,   51,    0,   51,    0,    0,   51,    0,   51,   51,
    0,   51,   52,   51,    0,   51,    0,   51,   51,   51,
   51,    0,    0,   51,   51,    0,    0,   52,    0,   51,
    0,   51,   51,   51,    0,    0,   51,    0,   51,    0,
   51,    0,    0,   51,    0,   51,   51,   51,   51,    0,
    0,    0,   51,   51,   51,    0,    0,   51,   51,   51,
    0,    0,    0,    0,    0,    0,   51,   51,   52,   51,
   51,    0,   51,   51,   51,    0,    0,    0,   51,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   51,    0,    0,    0,   51,    0,   51,   51,    0,
   51,    0,   51,   51,  222,   51,    0,   51,    0,   51,
    0,   51,   51,   51,   51,    0,    0,   51,   51,    0,
    0,    0,    0,   51,    0,   51,   51,   51,    0,    0,
   51,    0,   51,  347,   51,    0,    0,   51,    0,   51,
   51,   51,   51,    0,    0,    0,   51,   51,   51,    0,
    0,   51,   51,   51,   51,    0,  347,    0,    0,    0,
   51,   51,    0,   51,   51,    0,   51,   51,   51,  347,
    0,    0,   51,    0,  347,    0,    0,  347,    0,  347,
    0,  347,  347,  347,  347,    0,    0,    0,    0,  347,
    0,    0,   51,  347,    0,    0,    0,  347,  223,    0,
    0,    0,    0,  368,    0,  347,    0,    0,  347,    0,
  347,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  368,    0,    0,  347,
    0,    0,    0,    0,  347,    0,    0,    0,    0,  368,
  347,  347,    0,  273,  368,  347,    0,  239,   51,  368,
    0,  368,  368,  368,  368,    0,    0,    0,  347,  368,
    0,    0,    0,  368,    0,  465,    0,  368,    0,    0,
    0,    0,    0,    0,    0,  368,    0,    0,  368,    0,
  368,    0,    0,    0,    0,    0,    0,    0,  466,    0,
  347,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  467,    0,  465,  368,    0,  469,    0,    0,    0,
  368,  470,    0,  471,  472,  473,  474,    0,    0,    0,
    0,  475,    0,    0,    0,  476,  466,    0,    0, 1381,
    0,    0,    0,  465,    0,    0,    0,  477,    0,  467,
  478,    0,  479,    0,  469,    0,    0,    0,    0,  470,
    0,  471,  472,  473,  474,    0,  466,    0,    0,  475,
  368,    0,    0,  476,    0,    0,  480, 1381,    0,  467,
    0,    0, 1382,    0,  469,  477,    0,    0,  478,  470,
  479,  471,  472,  473,  474,    0,    0,    0,    0,  475,
    0,    0,    0,  476,    0,    0,    0,    0,    0,    0,
   56,   24,    0,   25,  480,  477,   26,  254,  478,    0,
  479,   27,   61,   62,    0,   28,    0,    0,    0,    0,
    0,   64, 1383,    0,   30,    0,    0,    0,    0,    0,
    0,   32,    0,    0,  480,    0,   33,    0,   71,   72,
   34,    0,  614,    0,    0,    0,    0,    0,    0,  615,
    0,    0,   36,    0,   37,   74,    0,    0,   38,    0,
 1383,   76,    0,   78,    0,   80,   39,   40,  255,    0,
   41,    0,    0,    0,    0,    0,    0,  616,    0,    0,
   87,   88,    0,    0,    0,    0,    0,    0,    0,    0,
 1400,    0,    0,    0,    0,   89,   90,   91,   92,   93,
    0,    0,    0,    0,    0,    0,    0,   95,  975,    0,
  617,    0,    0,   97,   98,   99,  100,    0,    0,    0,
  101,    0,  102,    0,    0,    0,    0,    0,  103,  104,
    0,    0,    0,    0,    0,    0,   56,   24,    0,   25,
    0,    0,   26,  254,    0,    0,    0,   27,   61,   62,
    0,   28,    0,  105,  106,  107,  108,   64,    0,    0,
   30,    0,    0,    0,    0,    0,    0,   32,    0,    0,
    0,    0,   33,    0,   71,   72,   34,    0,  614,    0,
    0,    0,    0,    0,    0,  615,    0,    0,   36,    0,
   37,   74,    0,    0,   38,    0,    0,   76,    0,   78,
    0,   80,   39,   40,  255,    0,   41,    0,    0,    0,
    0,    0,    0,  616,    0,    0,   87,   88,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   89,   90,   91,   92,   93,    0,    0,    0,    0,
    0,    0,    0,   95,    0,    0,  617,    0,    0,   97,
   98,   99,  100,    0,    0,    0,  101,    0,  102,    0,
    0,    0,    0,    0,  103,  104,    0,    0,    0,    0,
    0,    0,   56,   24,    0,   25,    0,    0,   26,  254,
    0,    0,    0,   27,   61,   62,    0,   28,    0,  105,
  106,  107,  108,   64,    0,    0,   30,    0,    0,    0,
    0,    0,    0,   32,    0,    0,    0,    0,   33,    0,
   71,   72,   34,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   36,    0,   37,   74,    0,    0,
   38,    0,    0,   76,    0,   78,    0,   80,   39,   40,
  255,    0,   41,    0,    0,   84,    0,    0,    0,   86,
    0,    0,   87,   88,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   89,   90,   91,
   92,  302,    0,    0,    0,    0,    0,    0,    0,   95,
    0,    0,    0,    0,    0,   97,   98,   99,  100,    0,
    0,    0,  101,    0,  102,    0,    0,    0,    0,    0,
  103,  104,    0,    0,    0,    0,    0,    0,   56,   24,
    0,   25,    0,    0,   26,  254,    0,    0,    0,   27,
   61,   62,    0,   28,    0,  105,  303,  107,  108,   64,
    0,    0,   30,    0,    0,    0,    0,    0,    0,   32,
    0,    0,    0,    0,   33,    0,   71,   72,   34,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   36,    0,   37,   74,    0,    0,   38,    0,    0,   76,
    0,   78,    0,   80,   39,   40,  255,    0,   41,    0,
    0,    0,    0,    0,    0,   86,    0,    0,   87,   88,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   89,   90,   91,   92,  302,    0,    0,
    0,  531,    0,    0,    0,   95,    0,    0,    0,    0,
    0,   97,   98,   99,  100,    0,    0,    0,  101,    0,
  102,    0,    0,    0,    0,    0,  103,  104,    0,    0,
    0,    0,    0,    0,   56,   24,    0,   25,    0,    0,
   26,  254,    0,    0,    0,   27,   61,   62,    0,   28,
    0,  105,  303,  107,  108,   64,    0,    0,   30,    0,
    0,    0,    0,    0,    0,   32,    0,    0,    0,    0,
   33,    0,   71,   72,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   74,
    0,    0,   38,    0,    0,   76,    0,   78,    0,   80,
   39,   40,  255,    0,   41,    0,    0,    0,    0,    0,
    0,   86,    0,    0,   87,   88,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   89,
   90,   91,   92,  302,    0,    0,    0,  525,    0,    0,
    0,   95,    0,    0,    0,    0,    0,   97,   98,   99,
  100,    0,    0,    0,  101,    0,  102,    0,    0,    0,
    0,    0,  103,  104,    0,    0,    0,    0,    0,    0,
   56,   24,    0,   25,    0,    0,   26,  254,    0,    0,
    0,   27,   61,   62,    0,   28,    0,  105,  303,  107,
  108,   64,    0,    0,   30,    0,    0,    0,    0,    0,
    0,   32,    0,    0,    0,    0,   33,    0,   71,   72,
   34,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   36,    0,   37,   74,    0,    0,   38,    0,
    0,   76,    0,   78,    0,   80,   39,   40,  255,    0,
   41,    0,    0,    0,    0,    0,    0,   86,    0,    0,
   87,   88,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   89,   90,   91,   92,  302,
    0,    0,    0,    0,    0,    0,    0,   95,    0,    0,
    0,    0,    0,   97,   98,   99,  100,    0,    0,    0,
  101,    0,  102,    0,    0,    0,    0,    0,  103,  104,
    0,    0,    0,    0,    0,    0,   56,   24,    0,   25,
    0,    0,   26,  254,    0,    0,    0,   27,   61,   62,
    0,   28,    0,  105,  303,  107,  108,   64,    0,    0,
   30,    0,    0,    0,    0,    0,    0,   32,    0,    0,
    0,    0,   33,    0,   71,   72,   34,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   36,    0,
   37,   74,    0,    0,   38,    0,    0,   76,    0,   78,
    0,   80,   39,   40,  255,    0,   41,    0,    0,    0,
    0,    0,    0,   86,    0,    0,   87,   88,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   89,   90,   91,   92,   93,    0,    0,    0,    0,
    0,    0,    0,   95,    0,    0,    0,    0,    0,   97,
   98,   99,  100,    0,    0,    0,  101,    0,  102,    0,
    0,    0,    0,    0,  103,  104,    0,    0,    0,    0,
    0,    0,  655,  655,    0,  655,    0,    0,  655,  655,
    0,    0,    0,  655,  655,  655,    0,  655,    0,  105,
  106,  107,  108,  655,    0,    0,  655,    0,    0,    0,
    0,    0,    0,  655,    0,    0,    0,    0,  655,    0,
  655,  655,  655,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  655,    0,  655,  655,    0,    0,
  655,    0,    0,  655,    0,  655,    0,  655,  655,  655,
  655,    0,  655,    0,    0,    0,    0,    0,    0,  655,
    0,    0,  655,  655,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  655,  655,  655,
  655,  655,    0,    0,    0,    0,    0,    0,    0,  655,
    0,    0,    0,    0,    0,  655,  655,  655,  655,    0,
    0,    0,  655,    0,  655,    0,    0,    0,    0,    0,
  655,  655,    0,    0,    0,    0,    0,    0,  143,  143,
    0,  143,    0,    0,  143,  143,    0,    0,    0,  143,
  143,  143,    0,  143,    0,  655,  655,  655,  655,  143,
    0,    0,  143,    0,    0,    0,    0,    0,    0,  143,
    0,    0,    0,    0,  143,    0,  143,  143,  143,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  143,    0,  143,  143,    0,    0,  143,    0,    0,  143,
    0,  143,    0,  143,  143,  143,  143,    0,  143,    0,
    0,    0,    0,    0,    0,  143,    0,    0,  143,  143,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  143,  143,  143,  143,  143,    0,    0,
    0,    0,    0,    0,    0,  143,    0,    0,    0,    0,
    0,  143,  143,  143,  143,    0,    0,    0,  143,    0,
  143,    0,    0,    0,    0,    0,  143,  143,    0,    0,
    0,    0,    0,    0,   56,   24,    0,   25,    0,    0,
   26,  254,    0,    0,    0,   27,   61,   62,    0,   28,
    0,  143,  143,  143,  143,   64,    0,    0,   30,    0,
    0,    0,    0,    0,    0,   32,    0,   31,    0,    0,
   33,    0,   71,   72,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,   74,
   31,    0,   38,    0,    0,   76,    0,   78,    0,   80,
   39,   40,  255,   31,   41,    0,    0,    0,   31,    0,
    0,    0,    0,   31,    0,   31,   31,   31,   31,    0,
    0,   31,    0,   31,    0,    0,    0,   31,    0,   89,
   90,   91,  256,  342,    0,    0,    0,    0,    0,   31,
    0,   95,   31,    0,   31,    0,    0,   97,   98,   99,
  100,    0,    0,    0,  101,    0,  102,    0,    0,    0,
    0,    0,  103,  104,    0,    0,    0,    0,   31,    0,
    0,    0,    0,    0,   31,   31,    0,    0,    0,    0,
    0,    0,  692,    0,  692,    0,  692,  105,  257,  692,
  108,  692,  692,    0,  692,    0,  692,    0,  692,    0,
  692,  692,  692,    0,    0,    0,  692,  692,    0,    0,
    0,    0,  692,    0,  692,  692,    0,    0,    0,  692,
    0,    0,    0,  692,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  692,  692,    0,  692,    0,    0,
    0,  692,  692,    0,    0,    0,    0,    0,    0,  692,
  692,   56,   24,  692,   25,    0,  692,   26,  254,    0,
    0,  692,   27,   61,   62,    0,   28,    0,    0,    0,
    0,    0,   64,    0,    0,   30,    0,    0,    0,    0,
    0,    0,   32,  692,  692,    0,    0,   33,    0,   71,
   72,   34,    0,    0,    0,    0,  692,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   74,    0,    0,   38,
    0,    0,   76,    0,   78,    0,   80,   39,   40,  255,
    0,   41,    0,    0,   84,    0,    0,    0,    0,    0,
    0,   24,    0,   25,    0,    0,   26,  692, 1286,    0,
    0,   27,    0,    0,    0,   28,   89,   90,   91,  256,
    0,    0,    0,    0,   30,  691,    0,  691,   95,    0,
  691,   32,  691,  691,    0,  691,   33,  691, 1287,  691,
   34,  691,  691,  691,    0,    0,    0,  691,  691,    0,
    0,    0,   36,  691,   37,  691,  691,    0,   38, 1288,
  691,    0,    0,    0,  691,    0,   39,   40,    0,    0,
   41,    0,    0,  324,  105,  257,  691,    0,  691,    0,
    0,    0,  691,  691,    0,    0,    0,    0,    0,    0,
  691,  691,    0,  691,  691,  691,    0,  691,  691,    0,
  691,  691,  691,  691,    0,  691,    0,  691,    0,  691,
  691,  691,    0,    0,    0,  691,  691,    0,    0,    0,
    0,  691,    0,  691,  691,    0,    0,    0,  691,    0,
    0,    0,  691,    0,    0,    0,    0,  691,    0,    0,
    0,    0,    0,    0,  691,    0,  691,    0,    0,    0,
  691,  691,    0,    0,  368,    0,    0,    0,  691,  691,
    0,    0,  691,    0,    0,  691,    0,   24,    0,   25,
  691,    0,   26,    0,    0, 1349,    0,   27,  691,  726,
    0,   28,    0,  727, 1350, 1351,    0,    0,    0, 1352,
   30,    0,    0,    0,    0, 1353,    0,   32,    0,   24,
    0,   25,   33,    0,   26,    0,   34, 1349,    0,   27,
    0,  726,    0,   28,    0,  727, 1350, 1351,   36,    0,
   37, 1352,   30,    0,   38,    0,    0, 1353,    0,   32,
    0,    0,   39,   40,   33,    0,   41,    0,   34, 1354,
    0,    0,    0,   51, 1355,   51,  691,    0,   51,    0,
   36,    0,   37,   51,    0,    0,   38,   51,    0,    0,
    0,    0,    0,    0,   39,   40,   51,    0,   41,    0,
    0, 1354,    0,   51,    0,   51, 1355,   51,   51, 1356,
   51,    0,   51,    0,   51,   51,   51,    0,    0,   51,
    0,   51,    0,    0,   51,    0,   51,    0,   51,    0,
   51,    0,    0,   51,    0,   51,    0,    0,   51,   51,
   51,    0,   51,    0,   51,   51,   51,    0,   51,   24,
 1357,   25,    0,   51,   26,    0,   51,    0,   51,   27,
    0,    0,   51,   28,    0,   51,    0,    0,    0,    0,
   51,   51,   30,    0,   51,    0,    0,   51,    0,   32,
  162,    0, 1357,    0,   33,    0,    0,    0,   34,    0,
  586,    0,    0,    0,    0,    0,    0,  587,    0,    0,
   36,    0,   37,    0,    0,    0,   38,    0,    0,  588,
  162,    0,    0,    0,   39,   40,    0,    0,   41,    0,
   52,  589,   52,    0,    0,   52,   51,    0,    0,    0,
   52,    0,    0,    0,   52,    0,    0,    0,    0,    0,
    0,    0,    0,   52,    0,    0,    0,  590,    0,    0,
   52,    0,   51,    0,   51,   52,    0,   51,   51,   52,
    0,   52,   51,   52,    0,    0,   51,    0,   52,    0,
    0,   52,    0,   52,    0,   51,    0,   52,    0,    0,
   52,    0,   51,    0,    0,   52,   52,   51,    0,   52,
    0,   51,   52,   51,    0,   51,    0,    0,    0,    0,
   51,    0,  591,   51,    0,   51,    0,    0,    0,   51,
    0,    0,   51,    0,    0,    0,    0,   51,   51,    0,
    0,   51,    0,   24,   51,   25,    0,    0,   26,    0,
    0,    0,    0,   27,    0,    0,    0,   28,    0,    0,
    0,   29,   24,    0,   25,    0,   30,   26,    0,    0,
    0,   31,   27,   32,    0,    0,   28,    0,   33,    0,
    0,    0,   34,   35,    0,   30,    0,    0,    0,    0,
    0,    0,   32,   52,   36,    0,   37,   33,    0,    0,
   38,   34,    0,    0,    0,    0,   37,    0,   39,   40,
    0,    0,   41,   36,    0,   37,    0,   37,    0,   38,
    0,    0,   37,    0,    0,   51,   37,   39,   40,   37,
    0,   41,    0,    0,  324,    0,    0,    0,    0,    0,
    0,   37,   37,    0,    0,    0,   37,   37,    0,    0,
    0,    0,   37,    0,   37,   37,   37,   37,    0,    0,
  291,    0,   37,    0,    0,    0,   37,    0,   37,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   37,    0,
   37,   37,   35,   37,    0,    0,    0,   37,    0,    0,
    0,    0,    0,   35,    0,    0,   42,    0,   35,    0,
    0,    0,   35,    0,    0,   35,    0,   37,    0,    0,
    0,    0,    0,   37,   37,  325,    0,   35,   35,    0,
    0,    0,   35,   35,   31,    0,   31,    0,   35,    0,
   35,   35,   35,   35,    0,    0,    0,    0,   35,    0,
    0,    0,   35,    0,   35,    0,    0,   31,    0,    0,
    0,    0,    0,    0,   35,    0,    0,   35,    0,   35,
   31,    0,    0,   35,    0,   31,    0,    0,    0,    0,
   31,    0,   31,   31,   31,   31,    0,    0,    0,    0,
   31,    0,    0,   35,   31,    0,    0,   51,    0,   35,
   35,    0,    0,    0,    0,    0,   31,    0,   51,   31,
    0,   31,    0,   51,    0,    0,    0,   51,    0,    0,
   51,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   51,   51,    0,   31,    0,   51,   51,    0,
   51,   31,   31,   51,    0,   51,   51,   51,   51,    0,
    0,   51,    0,   51,    0,    0,   51,   51,    0,   51,
   51,    0,    0,   51,    0,    0,    0,    0,    0,   51,
    0,    0,   51,    0,   51,   51,   51,    0,   51,    0,
   51,   51,   51,    0,    0,    0,   51,    0,   51,   51,
   51,   51,    0,    0,    0,    0,   51,    0,   51,    0,
   51,    0,   51,    0,   39,   51,    0,    0,    0,    0,
    0,    0,   51,    0,    0,   51,    0,   51,   51,    0,
   51,   51,    0,   51,    0,    0,    0,    0,   51,    0,
   51,   51,   51,   51,    0,    0,    0,    0,   51,    0,
    0,   51,   51,   51,    0,    0,    0,   40,    0,    0,
    0,    0,    0,    0,   51,    0,   51,   51,   51,   51,
    0,   51,    0,    0,    0,    0,   51,    0,   51,   51,
   51,   51,    0,    0,    0,    0,   51,    0,    0,    0,
   51,   51,    0,   51,    0,   51,   51,    0,    0,  204,
    0,    0,   51,    0,   51,   51,   51,   51,   51,   51,
    0,    0,    0,    0,   51,    0,   51,   51,   51,   51,
    0,    0,   51,    0,   51,    0,    0,    0,   51,   51,
    0,   51,    0,   51,   51,    0,    0,  206,    0,    0,
   51,    0,   51,   51,   51,   51,    0,   51,    0,    0,
    0,    0,   51,    0,   51,   51,   51,   51,    0,    0,
    0,    0,   51,    0,    0,    0,   51,   51,    0,   51,
    0,    0,    0,    0,   51,  308,   51,    0,   51,    0,
   51,   51,    0,   51,    0,   51,    0,    0,    0,    0,
   51,    0,   51,   51,   51,   51,    0,   51,    0,    0,
   51,    0,    0,    0,   51,    0,    0,   51,    0,    0,
   51,    0,    0,  309,  465,   51,   51,    0,    0,   51,
   51,   51,   51,   51,   51,   51,    0,    0,   51,    0,
   51,    0,    0,    0,   51,    0,    0,  466,    0,    0,
    0,    0,    0,    0,    0,   51,   51,   51,   51,   51,
  467,   51,    0,    0,    0,  469,    0,    0,    0,    0,
  470,    0,  471,  472,  473,  474,    0,    0,    0,    0,
  475,    0,    0,    0,  476,   51,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  477,    0,    0,  478,
    0,  479,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  480,
  };
  protected static readonly short [] yyCheck = {            17,
   17,  299,   18,   17,    4,  529,   17,   87,   88,   51,
  189,  300,   51,  234,  531,  188,  247,  232,    6,  289,
  482,   68,   84,  323,  344,   59,  298,   20,  108,  298,
  157,  504,  334,  383,   59,  582,  575,  983,  296,   47,
   87,   88, 1163,    0,  593,   92,   77,   58,  761,  791,
  763,  113,  367,  115,  256,   73, 1199, 1200,  256,   77,
  256,  330, 1293,  602,  367,  112,    0,  113,   79,  115,
   81,  256,  256,   17,   17,  256,  256,   95,  256,  256,
 1311,  256,  268,  268,   17,  268,  294,  256,  325,  376,
  276,  256,  256, 1196,  256, 1508, 1509,  256,  306,  812,
  256,  256,  815,  988,  371, 1248,  374,  372,  256,  272,
  256,  256,  368,  341,  391,  257,  357,  680,  256,  199,
  200, 1243,  685,  686,  256,  172,  401,   17,  369,  268,
  256,  372,  373,  296,  191,  394,  395,  414,  413,  157,
  157,  369,  429,  157,  256,  386,  157,  189,  416, 1252,
  189,  382, 1565,  420,  423,  256,  705,  256,   17,  340,
  323,  339,  418,   17,  429,  367,  344,  369,  346,  371,
  282,  349,  350,  371,  352,  353,  372,  363,  374,   17,
  421,  418,  262,  367,  339,  368,  363,  371,  363,  344,
  232,  346,  256,  232,  349,  350,  374,  352,  353,  246,
  247,  370,  314,  367,   17,  374,    0,  371,  288,  371,
  418,   17,  259,  157,  157,  223,   17,  343,  420,  374,
   17,  423,  420,  525,  157,  381,  447,  256,  308,  247,
  528,  446,  418,  429, 1119,  253,  420,  422,  418,  422,
  228,  418,  374,  418,  547, 1367,   59,  764, 1479,  296,
   63,  429,  286,  418,  569,  575,  420,  358,  420,  418,
  322,  286,  296,   17,  326,  391,  569,  157,  325,  331,
  418,  289,  418,  418,  429, 1506,  294,  295,  825,  256,
  418,  328,  602,  422,  364,  331,  333, 1518,  414, 1520,
  593,  309,  391,  277,  319, 1270,  256,  256,  157,  317,
  257,  319,  428,  157, 1158,  323,  418,  318,  256,  256,
  256,  368,  376,  368,  358,  414,  373,  335,  336,  157,
  400,  401,  256,  424,  425,  426,  427,  344,  375,  256,
  344,  378, 1045,  256,  363,  382,  383,  256,  256,  256,
  371,  370,  256,  372,  157,  374,  256,  910,  428,  429,
 1092,  157, 1473,  371,  256,  256,  157,  256,  256,  263,
  157,  256,   21,  418,  382,  383,  915,  335,  386,  387,
  388,  389,  390,  391,  392,  393,  394,  395,  396,  363,
  256,  428,  429,  946,  256,  432,  256,  305, 1363,  418,
  367,  706,  256,   52, 1369,  452, 1539,  335,  256,  376,
  418,  256,  705,  157,  446,  339, 1352,  446,  367,  368,
  369,  315,  371,  372,  456,  374,  376,  376,  257,  256,
  256, 1396,   20,  726,  372,  371, 1569,  990,  375,  992,
  487,  948,  995,  367,  418,  419,  418,  371,  256,  373,
  374,  375,  376,  325,  256,  453,  454,  381,  375,  749,
  367,  459,  375,  256,  927,  448,  503,  496,  505,  418,
 1173,  420,  381,  257,  423,  375,  368,  381, 1181,  462,
  266,  372,  374,  286,  958,  374,  374,  372,  272,  504,
  256,  702,  529,  277,  305,  363,  497,  281,  262,   87,
   88,  429, 1205,  343,  368,  305,  372,  369,  266,  369,
  547,  368,  296,  734,  551,  369,  319,  857,  766,  527,
  108,  529,  363,  531,  372,  351,  294,  372,  314, 1082,
  741, 1084, 1039, 1086,  298,  840, 1073,  256,  306,  323,
  256,  344,  543,  544,  591,  372,  418,  840,  341,  557,
  418,  391,  256,  363,  562,  592,  314, 1260,  342,  606,
  264,  369,  609,  610,  547,  429, 1410,  369,  575,  376,
  571,  575,  429,  339,  414,  277,  369,  418,  344,  281,
  346,  582,  372,  349,  350,  368,  352,  353,  428,  375,
  367, 1065,  368, 1067,  371,  602, 1440, 1441,  602, 1443,
  376,  373,  369,  368,  376, 1142,  614,  615,  418,  914,
 1454,  199,  200, 1457,  378,  379,  372,  375,  428,  372,
  339,  325,  915,  343,  912,  344,  363,  346, 1472,  368,
  349,  350, 1185,  352,  353,  368,  376,  256,  363,  429,
  342,  372,  863,  420,  294,  682,  429,  684, 1177,  696,
  942,  367, 1496,  429,  343,  371,  693,  373,  374,  776,
  376,  381, 1215,  429,  429,  381,  363,  256,  371,  716,
 1276,  391,  680,  429,  262,  294,  429,  685,  686,  263,
  688,  418,  363,  363,  256,  947,  945,  418,  369,  369,
  429,  428,  381,  418,  414,  367,  429,  734, 1276,  415,
  288,  504,  391,  357,  983,  374,  272,  357,  428, 1262,
  429,  369,  300,  363,  751,  373, 1322, 1276, 1276,  369,
  308,  418,  372,  373,  272,  414,  734,  797, 1281,  766,
  296,  315,  386,  305, 1275, 1276,  386,  418,  418,  428,
  368,  749,  766, 1206, 1322, 1276,  374,  416,  296,  727,
  820,  803, 1042,  381,  256, 1296,  764,  323, 1276, 1276,
 1276,  369,  770, 1322, 1322,  423,  836, 1055,  418,  806,
  391,  421,  575,  381, 1372,  323,  364,  269,  367,  367,
  339, 1322,  371, 1324,  373,  374, 1007,  376, 1386,  256,
  339, 1322,  381,  414,  286,  339,  398,  399,  799,  602,
  357,  256,  839, 1040, 1322, 1322, 1322,  428,  367,  817,
 1408,  819,  400,  401,  269,  386,  373,  371,  367,  373,
  857,  829,  823,  367,  825, 1135,  863,  376,  368,  386,
  371,  286, 1069, 1358,  374,  381,  999,  339,  392,  393,
  428,  429,  344, 1368,  346,  391,  916,  349,  350,  857,
  352,  353, 1358,  384,  306,  863,  888,  865,  412,  867,
  448,  313, 1368,  368,  368,  369,  420, 1177,  414,  423,
 1130,  376,  339,  325,  462, 1163,  389,  344,  256,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
  919,  367,  306,  372,  308,  374,  357,  376,  385,  313,
  376,  368,  910,  370,  912,  372, 1166,  374,  375,  376,
  957,  325,  373,  272,  897,  952,  373,  954,  277,  376,
    6,  929,  281,  960,  902,  386,  934,  429,  357,  937,
  367,   17,  400, 1243, 1386, 1156,  256,  296,  946,  376,
  948,  367, 1012, 1203,  373,  371,  306,  373,  374,  986,
  376,  368,  369,  313, 1461,  381,  367,  386,  761,  547,
  763,  339,  429,  390,  323,  376,  344,  367,  346,  367,
 1007,  349,  350,   59,  352,  353,  376,   63,  376,  382,
  383,  569,  990,  342,  992,  373, 1023,  995,  376,  415,
  369, 1332, 1029,  396,  397,  368,  256,  367,  368, 1007,
 1341,   87,   88,  376,  369,  593,  376,  372,  256,  812,
  368, 1222,  815, 1218,  372,  371, 1523, 1064,  376,  339,
  415, 1004,  108, 1283,  344, 1194,  346,  414,  415,  349,
  350, 1039,  352,  353, 1042,  418, 1014,  368, 1016, 1332,
 1018,  367,  368,  374,  418,  376,  357,  374, 1341,  376,
  376,  429,  363, 1560,  381,  256,  370, 1367,  369,  368,
  374,  372,  373,  374,  277,  374,  370,  371, 1582, 1583,
  374,  157, 1073, 1352, 1082,  386, 1084,  376, 1086,  339,
  371, 1089,  373,  370,  344,  372,  346,  374,  376,  349,
  350,  339,  352,  353,  367,  370,  344,  372,  346,  374,
  256,  349,  350,  373,  352,  353,  371,  418,  373,  429,
 1100,  370,  368,  199,  200,  374,  372,  705,  374, 1156,
  376,  370, 1130,  370,  376,  374,  368,  374, 1135, 1158,
  372, 1135,  374,  367,  376,  369, 1144, 1145,  726,  370,
  371, 1142,  373,  374,  375,  372,  370,  256, 1156,  376,
  374, 1157,  372,  372,  376, 1163,  376,  376, 1166,  370,
  354,  355, 1194,  374, 1196, 1194,  294, 1196,  372,  429,
 1177,  294,  376, 1177,  354,  355,  262, 1185,  406,  407,
  408,  409,  372, 1191,  374, 1473, 1218,  364,  365, 1218,
  386,  387,  388,  343,  372, 1203,  374,  370,  372,  372,
  286,  376,  288,  374, 1274,  376,  414, 1215, 1216,  797,
  370,  418,  372,  368,  300,  372,  371,  374,  373,  374,
 1252,  356,  308, 1252,  375,  370,  381,  372,  370,  372,
  372,  374,  820,  319,  372,  373, 1243,  392,  393, 1243,
  364,  365, 1045, 1275, 1276,  370, 1275,  372,  836,  370,
  418,  372,  840,  418, 1262, 1161, 1162,  412,  344,  369,
  374, 1331,  376,  376, 1296,  420,  372, 1296,  423,  374,
  374,  376,  376, 1281,  374, 1283,  376,  372,  364, 1349,
 1350,  367,  402,  403,  381,  404,  405,  368, 1325,  374,
 1322,  294, 1324,  410,  411, 1324,  372,  294,  372,  374,
  372,  374,  372,  256, 1374,  376,  428, 1377,  371,  897,
 1357,  256,  428,  368,  400,  401,  371,  294,  373,  374,
  294,  381,  372,  374,  373,  418,  374,  915,  916,  375,
  373,  372, 1135,  429, 1335,  374, 1383,  392,  393,  381,
   93,  374,  428,  429,   97,   98,   99,  100,  101,  102,
  103,  104,  374, 1400,  374,  423,  372,  412,  367,  374,
 1367,  374,  421, 1367,  372,  420,  373,  372,  423,  294,
 1173, 1418,  343, 1420, 1177,  374,  294,  370, 1181,  374,
  418, 1410,  371,  418,  367,  375,  256,  256,  374,  256,
 1391,  256,  280,  381,  256,  983,  256,  367,  371,  368,
  372,  343, 1205,  265,  370,  267,  374,  372,  270,  376,
  374, 1440, 1441,  275, 1443,  376, 1004,  279,  504, 1451,
  370,  372,  423,  372, 1012, 1454,  288,  381, 1457,  367,
  347,  256,  256,  295,  381,  381, 1468,  372,  300,  372,
 1243,  368,  304, 1472,  376,  256,  347,  370,  374, 1481,
 1482,  375,  372, 1461,  316,  370,  318, 1260, 1459,  367,
  322,  547,  339,  370,  348, 1473,  368, 1496,  330,  331,
  381,  374,  334,  372,  418,  337, 1508, 1509,  418,  256,
  348,  368, 1490,  569,  367,  367,  367,  381,  368,  575,
  376,  402,  403,  404,  405,  406,  407,  408,  409,  410,
  411,  363,  356,  376,  368,   61,  372,  593,  256,   65,
   66,   67,  371,   69,   70, 1523,  602,  374,   74,   75,
  368,  368,  337,  305,  369,   81,  418,   83,  371,   85,
  368,  367,  371, 1565,   90,   91,  376,  371,  371,  418,
  418,  373,  418,  371,  381, 1582, 1583,  367,  371,  302,
  381,  369, 1560,  372,  371,  256,  418,  373,  114,  372,
  374,  373,  418,  372, 1367, 1566, 1567,  374,  374,  374,
  372,  370, 1573, 1574, 1582, 1583,  376,  418,  376,  376,
  372,  334,  376,  418,  372,  381,  372,  368,  418,  342,
    0,  339,  381,  372,  370,  368,  344,  367,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356, 1197,
  315,  263,  371,  371,  368,  372,  372,    0,    0,  705,
  368,  367,  370,  368,  372,  376,  374,  375,  376,  376,
  372,    0,  368,  372,  372,  418,  370,  368,  368,  372,
  726,  367,  390,  372,  397,  398,  399,  370,  376,  402,
  403,  404,  405,  406,  407,  408,  409,  410,  411,  412,
  413,  414,  415,  416,  417,  368, 1254,  376,  418,  418,
  372,  256,  376,  368,  368,  761,  376,  763,  367,  367,
  265,  429,  267,    0,  368,  270, 1274,  372,  368,  372,
  275,  367,  315,  263,  279,  376,  373,  376,  376,  255,
   50,  376,  258,  288,  376,  376,  376,  376,  376,   12,
  295,  797,    5,  897, 1004,  300, 1156, 1156, 1324,  304,
 1296, 1513, 1476, 1529, 1493, 1459,  812,  919, 1464,  815,
  919,  316,  919,  318,  820,  914,  740,  322, 1372, 1574,
 1322, 1392,  298, 1331, 1332,  330,  331, 1568, 1486,  334,
  836,  261,  337, 1341,  840, 1482, 1252, 1481,  314, 1420,
  547, 1349, 1350, 1567, 1352, 1254,  942,  937,  770,  863,
 1358,  615,  525,  888,  284,  382,  734, 1055,  337,   71,
 1368,  766,  412,  414, 1372,  413, 1374,  297,  415, 1377,
  416,  301,  302,  417,  569,  840, 1232,  307, 1386,  309,
  310,  311,  312, 1331,  157, 1135, 1041,  317, 1121, 1145,
 1025,  321, 1069,    0, 1133, 1206,  962, 1135,  545,  437,
 1408,  437, 1216,  333, 1327,  894,  336,  893,  338,  915,
  916,   -1,   -1,  418,   -1,   -1,  691,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  598,  256,  257,   -1,   -1,
   -1,   -1,  362,   -1,  264,  265,  266,  267,  268,   -1,
  270,  271,   -1,  273,  274,  275,  276,  277,  278,  279,
  280,   -1,   -1,   -1,   -1,  285,   -1,  287,  288,  289,
  290,  291,  292,   -1,   -1,  295,   -1,   -1,   -1,  299,
  300,   -1,  302,  303,  304,   -1,   -1,  983,   -1,   -1,
   -1,   -1,   -1,   -1,  314,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,  324,  325,  326,  327,  328,  329,
  330,  331,  332,  333,  334,  335, 1012,  337,   -1,   -1,
  340,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,  256,
   -1,   -1,   -1,  499,   -1,  262,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,   -1,  367,  368, 1045,
   -1,  371,   -1,   -1,   -1,   -1,  376,  377,  378,  379,
  380,   -1,   -1,    0,  384,   -1,  386,   -1,   -1,   -1,
   -1,  298,  392,  393,   -1,   -1,   -1,  543,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  417,  418,  419,
  420,   -1,  422,   -1,   -1,   -1,  769,   -1,   -1,  429,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
  357,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1, 1135,
  367,  368,  369,  370,  371,  372,  373,  374,  375,  376,
   -1,  378,  379,   -1,   -1,  382,  383,  384,  385,  386,
  257,   -1,  389,  390,  261,   -1,   -1,  394,  395,  396,
  397,  398,  399,  400,  401,  272,   -1, 1173,   -1,   -1,
  277, 1177,   -1,   -1,  281, 1181,  413,  284,   -1,  416,
   -1,  418,   -1,  420,  256,   -1,  423,   -1,   -1,  296,
  297, 1197,  429,   -1,  301,  302,   -1,   -1,   -1, 1205,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,   -1,   -1,   -1,  321,   -1,  323,   -1,   -1,   -1,
   -1,    0,   -1,   -1,   -1,   -1,  333,   -1,  335,  336,
   -1,  338,   -1,   -1,   -1,  342,   -1, 1243,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 1254,   -1,
   -1,   -1,   -1,   -1, 1260,  362,   -1,   -1,   -1,   -1,
   -1,  368,  369,   -1,   -1,   -1,   -1,  339, 1274,  942,
   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,
  372,   -1,  374,  375,  376,   -1,   -1,   -1,   -1,  256,
   -1,   -1,  384,  385,  261,  262,   -1,  389,  390,   -1,
   -1,   -1,   -1,   -1,   -1, 1331, 1332,   -1,  400,  401,
   -1,   -1,   -1,   -1,   -1, 1341,   -1,  284,   -1,   -1,
   -1,  413,   -1, 1349, 1350,   -1, 1352,    0,   -1,   -1,
  297,  298,   -1,   -1,   -1,  302,   -1,  429,  305,   -1,
  307, 1367,  309,  310,  311,  312,   -1,   -1, 1374,   -1,
  317, 1377,   -1,   -1,  321,   -1,   -1,   -1,  325,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,
   -1,  338,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,   -1,  362,  363,   -1,   -1,   -1,
  367,  368,   -1,  370,  371,  372,  373,  374,  375,  376,
   -1,  378,  379,   -1,  381,  382,  383,  384,  385,  386,
  387,  388,  389,  390,   -1,  392,  393,  394,  395,  396,
  397,  398,  399,  400,  401,  402,  403,  404,  405,  406,
  407,  408,  409,  410,  411,  412,  413,   -1,   -1,  416,
   -1,  418,   -1,  420,   -1,   -1,  423,  256,  257,   -1,
   -1,   -1,  429,   -1,   -1,  264,  265,  266,  267,  268,
   -1,  270,  271,    0,  273,  274,  275,  276,  277,  278,
  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,  287,  288,
  289,  290,  291,  292,   -1,   -1,  295,   -1,   -1,   -1,
  299,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  314,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,  324,  325,  326,  327,  328,
  329,  330,  331,  332,  333,  334,  335,   -1,  337,   -1,
   -1,  340,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,  367,  368,
   -1,   -1,  371,   -1,   -1,   -1,   -1,  376,  377,  378,
  379,  380,   -1,  256,   -1,  384,   -1,  386,  261,  262,
   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,  417,  418,
  419,  420,   -1,  422,  297,  298,   -1,   -1,   -1,  302,
  429,   -1,  305,   -1,  307,   -1,  309,  310,  311,  312,
   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,  321,   -1,
   -1,   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  333,   -1,   -1,  336,   -1,  338,  339,   -1,   -1,   -1,
   -1,  344,   -1,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,  357,   -1,   -1,   -1,   -1,  362,
  363,   -1,   -1,   -1,  367,  368,  369,  370,  371,  372,
  373,  374,  375,  376,   -1,  378,  379,   -1,   -1,  382,
  383,  384,  385,  386,   -1,   -1,  389,  390,   -1,   -1,
   -1,  394,  395,  396,  397,  398,  399,  400,  401,  256,
   -1,   -1,   -1,    0,  261,  262,   -1,   -1,   -1,   -1,
  413,   -1,   -1,  416,   -1,  418,   -1,  420,   -1,   -1,
  423,   -1,   -1,   -1,   -1,   -1,  429,  284,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  297,  298,   -1,   -1,   -1,  302,   -1,   -1,  305,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,   -1,   -1,   -1,  321,   -1,   -1,   -1,  325,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,
   -1,  338,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,   -1,  362,  363,    0,   -1,   -1,
  367,  368,  369,  370,  371,  372,   -1,  374,  375,  376,
   -1,  378,  379,   -1,   -1,  382,  383,  384,  385,  256,
   -1,   -1,  389,  390,  261,  262,   -1,  394,  395,  396,
  397,  398,  399,  400,  401,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  413,  284,   -1,  416,
   -1,  418,   -1,  420,   -1,   -1,  423,   -1,   -1,   -1,
  297,  298,  429,   -1,   -1,  302,   -1,   -1,  305,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,   -1,   -1,   -1,  321,   -1,   -1,   -1,  325,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,
   -1,  338,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,   -1,  362,  363,   -1,   -1,   -1,
  367,  368,  369,  370,  371,  372,   -1,  374,  375,  376,
   -1,  378,  379,   -1,   -1,  382,  383,  384,  385,  256,
   -1,   -1,  389,  390,  261,  262,   -1,  394,  395,  396,
  397,  398,  399,  400,  401,   -1,    0,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  413,  284,   -1,  416,
   -1,  418,   -1,  420,   -1,   -1,  423,   -1,   -1,   -1,
  297,  298,  429,   -1,   -1,  302,   -1,   -1,  305,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,   -1,   -1,   -1,  321,   -1,   -1,   -1,  325,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,
   -1,  338,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,    0,  256,   -1,  362,  363,   -1,   -1,  262,
  367,  368,   -1,  370,  371,  372,   -1,  374,  375,  376,
   -1,  378,  379,   -1,   -1,  382,  383,  384,  385,   -1,
   -1,   -1,  389,  390,   -1,   -1,   -1,  394,  395,  396,
  397,  398,  399,  400,  401,  298,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  413,   -1,   -1,  416,
   -1,  418,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,
   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,   -1,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,
  363,   -1,   -1,   -1,  367,  368,   -1,  370,  371,  372,
   -1,  374,  375,  376,   -1,  378,  379,   -1,   -1,  382,
  383,  384,  385,   -1,    0,   -1,  389,  390,   -1,   -1,
   -1,  394,  395,  396,  397,  398,  399,  400,  401,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  413,   -1,   -1,  416,   -1,  418,   -1,   -1,   -1,   -1,
   -1,   -1,  256,  257,   -1,   -1,  429,  261,   -1,   -1,
   -1,  265,   -1,  267,   -1,   -1,  270,   -1,  272,  273,
   -1,  275,   -1,  277,   -1,  279,   -1,  281,  282,  283,
  284,   -1,   -1,  287,  288,   -1,   -1,   -1,    0,  293,
   -1,  295,  296,  297,   -1,   -1,  300,  301,  302,   -1,
  304,   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,   -1,  316,  317,  318,   -1,   -1,  321,  322,  323,
   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,   -1,  333,
  334,    0,  336,  337,  338,   -1,   -1,   -1,  342,  257,
   -1,   -1,   -1,  261,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  272,   -1,   -1,   -1,  362,  277,
   -1,   -1,   -1,  281,  368,  369,  284,   -1,   -1,   -1,
   -1,   -1,   -1,  377,    0,   -1,   -1,   -1,  296,  297,
   -1,   -1,   -1,  301,  302,   -1,   -1,   -1,   -1,  307,
   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,
   -1,   -1,  257,  321,   -1,  323,  261,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  418,  333,   -1,  272,  336,   -1,
  338,   -1,  277,   -1,  342,   -1,  281,   -1,   -1,  284,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,
   -1,  296,  297,   -1,  362,   -1,  301,  302,   -1,  367,
  368,  369,  307,   -1,  309,  310,  311,  312,   -1,   -1,
   -1,   -1,  317,   -1,   -1,   -1,  321,   -1,  323,   -1,
   -1,  257,   -1,   -1,   -1,  261,   -1,   -1,  333,   -1,
  335,  336,   -1,  338,    0,   -1,  272,  342,   -1,   -1,
   -1,  277,   -1,   -1,   -1,  281,   -1,   -1,  284,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,
  296,  297,   -1,   -1,  369,  301,  302,   -1,   -1,   -1,
   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,
   -1,  317,   -1,   -1,   -1,  321,   -1,  323,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  257,   -1,  333,   -1,  261,
  336,    0,  338,   -1,   -1,   -1,  342,   -1,   -1,   -1,
  272,   -1,   -1,   -1,   -1,  277,   -1,   -1,   -1,  281,
   -1,   -1,  284,   -1,   -1,   -1,  362,   -1,   -1,   -1,
   -1,   -1,  368,  369,  296,  297,   -1,   -1,  257,  301,
  302,   -1,  261,   -1,    0,  307,   -1,  309,  310,  311,
  312,   -1,   -1,  272,   -1,  317,   -1,   -1,  277,  321,
   -1,  323,  281,   -1,   -1,  284,   -1,   -1,   -1,   -1,
   -1,  333,   -1,   -1,  336,   -1,  338,  296,  297,   -1,
  342,  257,  301,  302,   -1,  261,   -1,    0,  307,   -1,
  309,  310,  311,  312,   -1,   -1,  272,   -1,  317,   -1,
  362,  277,  321,   -1,  323,  281,  368,  369,  284,   -1,
   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,
  296,  297,   -1,  342,   -1,  301,  302,   -1,   -1,   -1,
   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,
   -1,  317,   -1,  362,  257,  321,   -1,  323,  261,   -1,
  369,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,  272,
  336,   -1,  338,   -1,  277,   -1,  342,   -1,  281,   -1,
   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  296,  297,   -1,  362,   -1,  301,  302,
   -1,  257,   -1,   -1,  307,  261,  309,  310,  311,  312,
   -1,   -1,   -1,   -1,  317,   -1,  272,   -1,  321,   -1,
  323,  277,   -1,   -1,   -1,  281,   -1,   -1,  284,   -1,
  333,   -1,   -1,  336,   -1,  338,   -1,   -1,   -1,  342,
  296,  297,   -1,   -1,   -1,  301,  302,   -1,   -1,   -1,
   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,  362,
   -1,  317,   -1,   -1,   -1,  321,   -1,  323,  257,   -1,
   -1,   -1,  261,   -1,   -1,   -1,   -1,  333,   -1,   -1,
  336,   -1,  338,  272,   -1,   -1,  342,   -1,  277,   -1,
   -1,   -1,  281,   -1,   -1,  284,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  362,  296,  297,   -1,
   -1,  257,  301,  302,   -1,  261,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,  272,   -1,  317,   -1,
   -1,  277,  321,   -1,  323,  281,   -1,   -1,  284,   -1,
   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,
  296,  297,   -1,  342,  257,  301,  302,   -1,  261,   -1,
   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,  272,
   -1,  317,   -1,  362,  277,  321,   -1,  323,  281,   -1,
   -1,  284,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,
  336,   -1,  338,  296,  297,   -1,  342,   -1,  301,  302,
   -1,   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,
   -1,   -1,   -1,   -1,  317,   -1,  362,   -1,  321,   -1,
  323,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  333,   -1,  256,  336,   -1,  338,   -1,   -1,   -1,  342,
  264,  265,  266,  267,   -1,   -1,  270,  271,   -1,  273,
  274,  275,  276,  277,  278,  279,   -1,   -1,   -1,  362,
   -1,  285,   -1,  287,  288,  289,  290,  291,  292,   -1,
   -1,  295,   -1,   -1,   -1,  299,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  314,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
  324,  325,  326,  327,  328,  329,  330,  331,  332,  333,
  334,  335,   -1,  337,   -1,   -1,  340,  341,   -1,  256,
  344,  345,   -1,   -1,   -1,  262,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,
   -1,   -1,   -1,  367,   -1,   -1,   -1,  371,   -1,   -1,
   -1,   -1,  376,  377,  378,  379,  380,   -1,   -1,   -1,
  384,  298,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,   -1,
   -1,  262,   -1,  417,  418,  419,  420,   -1,   -1,   -1,
   -1,   -1,  339,   -1,   -1,  429,   -1,  344,   -1,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
  357,   -1,   -1,   -1,   -1,   -1,  363,  298,   -1,   -1,
   -1,  368,  369,  370,  371,  372,  373,  374,  375,  376,
   -1,  378,  379,   -1,  381,  382,  383,  384,  385,  386,
  387,  388,  389,  390,   -1,  392,  393,  394,  395,  396,
  397,  398,  399,  400,  401,  402,  403,  404,  405,  406,
  407,  408,  409,  410,  411,  412,  413,  414,  256,   -1,
   -1,  418,   -1,  420,  262,   -1,  423,   -1,   -1,   -1,
   -1,   -1,  429,   -1,   -1,   -1,   -1,  368,   -1,   -1,
  371,   -1,  373,  374,   -1,   -1,   -1,  378,  379,   -1,
   -1,  382,  383,  384,  385,  386,  387,  388,  389,  390,
  298,  392,  393,  394,  395,  396,  397,  398,  399,  400,
  401,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  412,  413,   -1,   -1,   -1,   -1,   -1,   -1,  420,
   -1,   -1,  423,   -1,   -1,   -1,   -1,   -1,  429,   -1,
  285,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,  357,
   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1,   -1,
  368,  369,  370,  371,  372,  373,  374,  375,  376,  256,
  378,  379,  327,  381,  382,  383,  384,  385,  386,  387,
  388,  389,  390,   -1,  392,  393,  394,  395,  396,  397,
  398,  399,  400,  401,  402,  403,  404,  405,  406,  407,
  408,  409,  410,  411,  412,  413,   -1,  256,   -1,   -1,
  418,   -1,  420,  262,   -1,  423,   -1,   -1,   -1,   -1,
   -1,  429,  377,  378,  379,  380,   -1,  382,  383,  384,
  385,  386,  387,  388,  389,   -1,   -1,  392,  393,  394,
  395,  396,  397,  398,  399,   -1,   -1,   -1,   -1,  298,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,
  339,   -1,   -1,   -1,   -1,  344,   -1,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  367,  368,
  369,  370,  371,  372,  373,  374,  375,  376,   -1,  378,
  379,   -1,  381,  382,  383,  384,  385,  386,  387,  388,
  389,  390,  429,  392,  393,  394,  395,  396,  397,  398,
  399,  400,  401,  402,  403,  404,  405,  406,  407,  408,
  409,  410,  411,  412,  413,   -1,  256,  256,   -1,   -1,
   -1,  420,  262,   -1,   -1,   -1,  265,   -1,  267,   -1,
  429,  270,   -1,   -1,   -1,   -1,  275,   -1,   -1,   -1,
  279,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,  298,   -1,
   -1,  300,   -1,   -1,   -1,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
   -1,   -1,   -1,  322,   -1,   -1,   -1,  256,   -1,   -1,
   -1,  330,  331,  262,   -1,  334,   -1,   -1,  337,  339,
   -1,   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  367,  368,  298,
  370,  371,  372,  373,  374,  375,  376,   -1,  378,  379,
   -1,  381,  382,  383,  384,  385,  386,  387,  388,  389,
  390,   -1,  392,  393,  394,  395,  396,  397,  398,  399,
  400,  401,  402,  403,  404,  405,  406,  407,  408,  409,
  410,  411,  412,  413,   -1,  256,   -1,   -1,   -1,  418,
  420,  262,   -1,  423,   -1,   -1,   -1,   -1,   -1,  429,
   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1,   -1,  368,
  369,   -1,  371,  372,  373,  374,   -1,  376,   -1,  378,
  379,   -1,  381,  382,  383,  384,  385,  298,  387,  388,
  389,  390,   -1,  392,  393,  394,  395,  396,  397,  398,
  399,  400,  401,  402,  403,  404,  405,  406,  407,  408,
  409,  410,  411,  412,  413,   -1,   -1,   -1,   -1,  418,
   -1,  420,   -1,   -1,  423,   -1,   -1,   -1,  339,   -1,
  429,   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,
  371,  372,  373,  374,  375,  376,   -1,  378,  379,   -1,
  381,  382,  383,  384,  385,  386,  387,  388,  389,  390,
   -1,  392,  393,  394,  395,  396,  397,  398,  399,  400,
  401,  402,  403,  404,  405,  406,  407,  408,  409,  410,
  411,  412,  413,   -1,  256,  256,   -1,   -1,   -1,  420,
  262,   -1,  423,   -1,  265,   -1,  267,   -1,  429,  270,
   -1,   -1,   -1,   -1,  275,   -1,   -1,   -1,  279,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,  298,   -1,   -1,  300,
   -1,   -1,   -1,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,   -1,   -1,
   -1,  322,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  330,
  331,   -1,   -1,  334,   -1,   -1,  337,  339,   -1,   -1,
   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,  371,
  372,  373,  374,  375,  376,   -1,  378,  379,   -1,  381,
  382,  383,  384,  385,  386,  387,  388,  389,  390,   -1,
  392,  393,  394,  395,  396,  397,  398,  399,  400,  401,
  402,  403,  404,  405,  406,  407,  408,  409,  410,  411,
  412,  413,   -1,  256,  256,   -1,   -1,  418,  420,  262,
   -1,  423,   -1,  265,   -1,  267,   -1,  429,  270,   -1,
   -1,   -1,   -1,  275,   -1,   -1,   -1,  279,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  288,   -1,   -1,   -1,
   -1,   -1,   -1,  295,   -1,  298,   -1,   -1,  300,   -1,
   -1,   -1,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  316,   -1,  318,   -1,   -1,   -1,
  322,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,
   -1,   -1,  334,   -1,   -1,  337,  339,   -1,   -1,   -1,
   -1,  344,   -1,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,  371,  372,
  373,  374,  375,  376,   -1,  378,  379,   -1,  381,  382,
  383,  384,  385,  386,  387,  388,  389,  390,   -1,  392,
  393,  394,  395,  396,  397,  398,  399,  400,  401,  402,
  403,  404,  405,  406,  407,  408,  409,  410,  411,  412,
  413,   -1,  256,   -1,   -1,   -1,  418,  420,  262,  256,
  423,   -1,  266,   -1,   -1,   -1,  429,   -1,  265,   -1,
  267,   -1,   -1,  270,   -1,   -1,   -1,   -1,  275,   -1,
   -1,   -1,  279,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  288,   -1,   -1,  298,   -1,   -1,   -1,  295,   -1,
   -1,   -1,   -1,  300,   -1,   -1,   -1,  304,   -1,   -1,
  314,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,
   -1,  318,   -1,   -1,   -1,  322,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  330,  331,   -1,   -1,  334,   -1,   -1,
  337,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,   -1,
   -1,  262,   -1,  357,   -1,   -1,   -1,   -1,   -1,  363,
   -1,   -1,   -1,   -1,  368,  369,  370,  371,  372,  373,
  374,  375,  376,   -1,  378,  379,   -1,  381,  382,  383,
  384,  385,  386,  387,  388,  389,  390,  298,  392,  393,
  394,  395,  396,  397,  398,  399,  400,  401,  402,  403,
  404,  405,  406,  407,  408,  409,  410,  411,  412,  413,
   -1,   -1,   -1,   -1,  418,   -1,  420,   -1,   -1,  423,
   -1,  418,   -1,   -1,   -1,  429,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,
   -1,  372,   -1,  374,  375,  376,   -1,  378,  379,   -1,
  381,  382,  383,  384,  385,  386,  387,  388,  389,  390,
  261,   -1,   -1,  394,  395,  396,  397,  398,  399,  400,
  401,  402,  403,  404,  405,  406,  407,  408,  409,  410,
  411,  256,  413,  284,   -1,   -1,   -1,  262,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  297,   -1,  429,   -1,
   -1,  302,   -1,   -1,  305,   -1,  307,   -1,  309,  310,
  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,
  321,   -1,   -1,  298,  325,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  333,   -1,   -1,  336,   -1,  338,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,
   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,   -1,
   -1,  362,   -1,   -1,  339,   -1,   -1,  368,   -1,  344,
   -1,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  298,   -1,  368,   -1,  370,   -1,  372,   -1,  374,
  375,  376,   -1,  378,  379,   -1,   -1,  382,  383,  384,
  385,  386,  387,  388,  389,  390,   -1,  418,   -1,  394,
  395,  396,  397,  398,  399,  400,  401,   -1,   -1,   -1,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,  256,  429,   -1,   -1,   -1,   -1,  262,
   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,
   -1,  378,  379,   -1,   -1,  382,  383,  384,  385,   -1,
   -1,   -1,  389,  390,   -1,   -1,   -1,  394,  395,  396,
  397,  398,  399,  400,  401,  298,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  413,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  256,  429,   -1,   -1,   -1,   -1,  262,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,   -1,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  298,   -1,  368,   -1,  370,   -1,  372,
   -1,  374,  375,  376,   -1,  378,  379,   -1,   -1,  382,
  383,  384,  385,   -1,   -1,   -1,  389,  390,   -1,  256,
   -1,  394,  395,  396,  397,  398,  399,  400,  401,   -1,
   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,
  413,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,
   -1,   -1,   -1,  368,   -1,  370,   -1,  372,   -1,  374,
  375,  376,   -1,  378,  379,   -1,   -1,  382,  383,  384,
  385,   -1,   -1,   -1,  389,  390,   -1,  256,   -1,  394,
  395,  396,  397,  398,  399,  400,  401,   -1,   -1,   -1,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,
   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,
   -1,   -1,   -1,   -1,   -1,  382,  383,  384,  385,   -1,
   -1,   -1,  389,  390,   -1,  256,   -1,  394,  395,  396,
  397,  398,  399,  400,  401,   -1,   -1,   -1,   -1,   -1,
  339,   -1,   -1,   -1,   -1,  344,  413,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,
   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,   -1,
   -1,   -1,   -1,  382,  383,  384,  385,   -1,   -1,   -1,
  389,  390,   -1,  256,   -1,  394,  395,  396,  397,  398,
  399,  400,  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,  413,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,
   -1,  372,   -1,  374,  375,  376,   -1,   -1,   -1,   -1,
   -1,  382,  383,  384,  385,   -1,   -1,   -1,  389,  390,
   -1,  256,   -1,  394,  395,  396,  397,  398,  399,  400,
  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,  413,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,  429,   -1,
   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,  372,
   -1,  374,  375,  376,   -1,   -1,   -1,   -1,   -1,  382,
  383,  384,  385,   -1,   -1,   -1,  389,  390,   -1,  256,
   -1,   -1,   -1,  396,  397,  398,  399,  400,  401,   -1,
   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,
  413,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,
   -1,   -1,   -1,  368,   -1,  370,   -1,  372,   -1,  374,
  375,  376,   -1,   -1,   -1,   -1,   -1,  382,  383,  384,
  385,   -1,   -1,   -1,  389,  390,   -1,  256,   -1,   -1,
   -1,  396,  397,  398,  399,  400,  401,   -1,   -1,   -1,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,
   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,
   -1,   -1,   -1,   -1,   -1,  382,  383,  384,  385,   -1,
   -1,   -1,  389,  390,   -1,  256,   -1,   -1,   -1,  396,
  397,  398,  399,  400,  401,   -1,   -1,   -1,   -1,   -1,
  339,   -1,   -1,   -1,   -1,  344,  413,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,
   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,   -1,
   -1,   -1,   -1,  382,  383,  384,  385,   -1,   -1,   -1,
  389,  390,   -1,  256,   -1,   -1,   -1,  396,  397,  398,
  399,  400,  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,  413,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,
   -1,  372,   -1,  374,  375,  376,   -1,   -1,   -1,   -1,
   -1,  382,  383,  384,  385,   -1,   -1,   -1,  389,  390,
   -1,  256,   -1,   -1,   -1,  396,  397,  398,  399,  400,
  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,  413,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,  429,   -1,
   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,  372,
   -1,  374,  375,  376,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  384,  385,   -1,   -1,   -1,  389,  390,   -1,  256,
   -1,   -1,   -1,   -1,   -1,  398,  399,  400,  401,   -1,
   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,
  413,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,
   -1,   -1,   -1,  368,   -1,  370,   -1,  372,   -1,  374,
  375,  376,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  384,
  385,   -1,   -1,   -1,  389,  390,   -1,  256,   -1,   -1,
   -1,   -1,   -1,  398,  399,  400,  401,   -1,   -1,   -1,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,
   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  384,  385,   -1,
   -1,   -1,  389,  390,   -1,  256,   -1,   -1,   -1,   -1,
   -1,  398,  399,  400,  401,   -1,   -1,   -1,   -1,   -1,
  339,   -1,   -1,   -1,   -1,  344,  413,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,
   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  384,  385,   -1,   -1,   -1,
  389,  390,   -1,  256,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  400,  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,  413,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,
   -1,  372,   -1,  374,  375,  376,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  385,   -1,   -1,   -1,  389,  390,
   -1,  256,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  400,
  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,  413,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,  429,   -1,
   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,  372,
   -1,  374,  375,  376,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  385,   -1,   -1,   -1,  389,  390,   -1,  256,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  400,  401,   -1,
   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,
  413,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,
   -1,   -1,   -1,  368,   -1,  370,   -1,  372,   -1,  374,
  375,  376,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  385,   -1,   -1,   -1,   -1,  390,   -1,  256,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  400,  401,   -1,   -1,   -1,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,
   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  385,   -1,
   -1,   -1,   -1,  390,   -1,  256,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  400,  401,   -1,   -1,   -1,   -1,   -1,
  339,   -1,   -1,   -1,   -1,  344,  413,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,
   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  390,   -1,  256,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  400,  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,  413,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,
   -1,  372,   -1,  374,  375,  376,   -1,   -1,   -1,  256,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  390,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  400,
  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,  413,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,  429,   -1,
   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,  372,
   -1,  374,  375,  376,   -1,   -1,   -1,   -1,  262,   -1,
   -1,   -1,  266,   -1,   -1,   -1,   -1,  390,   -1,   -1,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  401,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
  413,   -1,   -1,   -1,  298,   -1,   -1,   -1,   -1,   -1,
   -1,  368,   -1,  370,   -1,  372,  429,  374,  375,  376,
  314,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  390,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  401,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  413,   -1,   -1,   -1,
   -1,   -1,   -1,  357,   -1,   -1,   -1,   -1,   -1,  363,
   -1,   -1,  429,   -1,  368,  369,   -1,  371,   -1,  373,
   -1,  375,  376,   -1,  378,  379,   -1,  381,  382,  383,
  384,  385,  386,  387,  388,  389,  390,   -1,  392,  393,
  394,  395,  396,  397,  398,  399,  400,  401,  402,  403,
  404,  405,  406,  407,  408,  409,  410,  411,  412,  413,
   -1,   -1,  256,   -1,  418,   -1,  420,   -1,   -1,  423,
  264,  265,  266,  267,  268,  429,  270,  271,   -1,  273,
  274,  275,  276,  277,  278,  279,   -1,   -1,   -1,   -1,
   -1,  285,   -1,  287,  288,  289,  290,  291,  292,   -1,
   -1,  295,   -1,   -1,   -1,  299,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  314,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
  324,  325,  326,  327,  328,  329,  330,  331,  332,  333,
  334,  335,   -1,  337,   -1,   -1,  340,  341,   -1,   -1,
  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,
   -1,   -1,   -1,  367,   -1,   -1,   -1,  371,   -1,   -1,
   -1,   -1,  376,  377,  378,  379,  380,   -1,   -1,   -1,
  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  256,   -1,  417,  418,  419,  420,   -1,  422,  264,
  265,  266,  267,   -1,   -1,  270,  271,   -1,  273,  274,
  275,  276,  277,  278,  279,   -1,   -1,   -1,   -1,   -1,
  285,   -1,  287,  288,  289,  290,  291,  292,   -1,   -1,
  295,   -1,   -1,   -1,  299,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  314,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,  324,
  325,  326,  327,  328,  329,  330,  331,  332,  333,  334,
  335,   -1,  337,   -1,   -1,  340,  341,   -1,   -1,  344,
  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,  367,   -1,   -1,   -1,  371,   -1,   -1,   -1,
   -1,  376,  377,  378,  379,  380,   -1,   -1,   -1,  384,
   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,
   -1,   -1,  417,  418,  419,  420,  264,  265,  266,  267,
   -1,   -1,  270,  271,   -1,  273,  274,  275,  276,  277,
  278,  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,  287,
  288,  289,  290,  291,  292,   -1,   -1,  295,   -1,   -1,
   -1,  299,  300,   -1,  302,  303,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  314,   -1,  316,   -1,
  318,  319,   -1,   -1,  322,   -1,  324,  325,  326,  327,
  328,  329,  330,  331,  332,  333,  334,  335,   -1,  337,
   -1,   -1,  340,  341,   -1,   -1,  344,  345,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,  367,
   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,  376,  377,
  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,
   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  417,
  418,  419,  420,  264,  265,  266,  267,   -1,   -1,  270,
  271,   -1,  273,  274,  275,  276,  277,  278,  279,   -1,
   -1,   -1,   -1,   -1,  285,   -1,  287,  288,  289,  290,
  291,  292,   -1,   -1,  295,   -1,   -1,   -1,  299,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  314,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,  324,  325,  326,  327,  328,  329,  330,
  331,  332,  333,  334,  335,   -1,  337,   -1,   -1,  340,
  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,  367,   -1,   -1,   -1,
  371,   -1,   -1,   -1,   -1,  376,  377,  378,  379,  380,
   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,
   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  256,   -1,   -1,   -1,  417,  418,  419,  420,
  264,  265,  266,  267,   -1,   -1,  270,  271,   -1,  273,
  274,  275,  276,  277,  278,  279,   -1,   -1,   -1,   -1,
   -1,  285,   -1,  287,  288,  289,  290,  291,  292,   -1,
   -1,  295,   -1,   -1,   -1,  299,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  314,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
  324,  325,  326,  327,  328,  329,  330,  331,  332,  333,
  334,  335,   -1,  337,   -1,   -1,  340,  341,   -1,   -1,
  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,
   -1,   -1,   -1,  367,   -1,   -1,   -1,  371,   -1,   -1,
   -1,   -1,  376,  377,  378,  379,  380,   -1,   -1,   -1,
  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,
   -1,   -1,   -1,  417,  418,  419,  420,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,   -1,  279,   -1,   -1,  265,   -1,  267,  285,   -1,
  270,  288,   -1,   -1,   -1,  275,   -1,   -1,  295,  279,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,  288,  306,
   -1,   -1,   -1,   -1,   -1,  295,  313,   -1,   -1,  316,
  300,  318,  319,   -1,  304,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,  316,  334,  318,   -1,
   -1,   -1,  322,   -1,  341,   -1,   -1,  344,  345,   -1,
  330,  331,   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  371,   -1,   -1,  374,   -1,   -1,
  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,
   -1,   -1,  372,   -1,   -1,  392,  393,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,
  417,  418,  419,  420,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,  418,  279,
   -1,   -1,  265,   -1,  267,  285,   -1,  270,  288,   -1,
   -1,   -1,  275,   -1,   -1,  295,  279,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,  288,   -1,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,  316,  300,  318,  319,
   -1,  304,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,  316,  334,  318,   -1,   -1,   -1,  322,
   -1,  341,   -1,   -1,  344,  345,   -1,  330,  331,   -1,
   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,   -1,  367,  368,   -1,
   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,
  380,   -1,   -1,   -1,  384,   -1,  386,  370,   -1,   -1,
   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  256,   -1,   -1,   -1,  417,  418,  419,
  420,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,  418,  279,   -1,   -1,  265,
   -1,  267,  285,   -1,  270,  288,   -1,   -1,   -1,  275,
   -1,   -1,  295,  279,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,  288,  306,   -1,   -1,   -1,   -1,   -1,  295,
  313,   -1,   -1,  316,  300,  318,  319,   -1,  304,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
  316,  334,  318,   -1,   -1,   -1,  322,   -1,  341,   -1,
   -1,  344,  345,   -1,  330,  331,   -1,   -1,  334,   -1,
   -1,  337,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,
   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,
   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,
  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  256,   -1,   -1,   -1,  417,  418,  419,  420,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,  418,  279,   -1,   -1,  265,   -1,  267,  285,
   -1,  270,  288,   -1,   -1,   -1,  275,   -1,   -1,  295,
  279,   -1,   -1,   -1,  300,   -1,  302,  303,  304,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
  316,  300,  318,  319,  320,  304,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,  316,  334,  318,
   -1,   -1,   -1,  322,   -1,  341,   -1,   -1,  344,  345,
   -1,  330,  331,   -1,   -1,  334,   -1,   -1,  337,   -1,
   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,
   -1,  367,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,
  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,
   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,  417,  418,  419,  420,  285,   -1,   -1,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,  418,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,   -1,  367,  368,   -1,
   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,
  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,
   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,
  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,   -1,  279,   -1,  417,  418,  419,
  420,  285,   -1,   -1,  288,   -1,   -1,   -1,  428,   -1,
   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,
  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,
  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,
   -1,   -1,   -1,  367,   -1,   -1,   -1,  371,   -1,   -1,
   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,
  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  256,   -1,  417,  418,  419,  420,   -1,   -1,  264,
  265,   -1,  267,   -1,  428,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,  265,   -1,  267,
  285,   -1,  270,  288,   -1,   -1,   -1,  275,   -1,   -1,
  295,  279,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,
   -1,  316,  300,  318,  319,   -1,  304,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,  316,  334,
  318,   -1,   -1,   -1,  322,   -1,  341,   -1,   -1,  344,
  345,   -1,  330,  331,   -1,   -1,  334,   -1,   -1,  337,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,  367,   -1,   -1,   -1,  371,   -1,   -1,   -1,
   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,
   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,
   -1,   -1,  417,  418,  419,  420,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
  418,  279,   -1,   -1,  265,   -1,  267,  285,   -1,  270,
  288,   -1,   -1,   -1,  275,   -1,   -1,  295,  279,   -1,
   -1,   -1,  300,   -1,  302,  303,  304,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,  316,  300,
  318,  319,   -1,  304,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,  316,  334,  318,   -1,   -1,
   -1,  322,   -1,  341,   -1,   -1,  344,  345,   -1,  330,
  331,   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,
   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,
  368,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,
  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,
   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  417,
  418,  419,  420,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,  418,  279,   -1,
   -1,  265,   -1,  267,  285,   -1,  270,  288,   -1,   -1,
   -1,  275,   -1,   -1,  295,  279,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,  288,   -1,   -1,   -1,   -1,   -1,
   -1,  295,   -1,   -1,   -1,  316,  300,  318,  319,   -1,
  304,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,  316,  334,  318,   -1,   -1,   -1,  322,   -1,
  341,   -1,   -1,  344,  345,   -1,  330,  331,   -1,   -1,
  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,   -1,  368,   -1,   -1,
  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,
   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,
   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  256,   -1,   -1,   -1,  417,  418,  419,  420,
  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,  418,  279,   -1,   -1,  265,   -1,
  267,  285,   -1,  270,  288,   -1,   -1,   -1,  275,   -1,
   -1,  295,  279,   -1,   -1,   -1,  300,   -1,  302,  303,
  304,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,  316,  300,  318,  319,   -1,  304,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,  316,
  334,  318,   -1,   -1,   -1,  322,   -1,  341,   -1,   -1,
  344,  345,   -1,  330,  331,   -1,   -1,  334,   -1,   -1,
  337,   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,
   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,
  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,
   -1,   -1,   -1,  417,  418,  419,  420,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,  418,  279,   -1,   -1,  265,   -1,  267,  285,   -1,
  270,  288,   -1,   -1,   -1,  275,   -1,   -1,  295,  279,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,  316,
  300,  318,  319,   -1,  304,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,  316,  334,  318,   -1,
   -1,   -1,  322,   -1,  341,   -1,   -1,  344,  345,   -1,
  330,  331,   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,
  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,
   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,
  417,  418,  419,  420,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,  418,  279,
   -1,   -1,  265,   -1,  267,  285,   -1,  270,  288,   -1,
   -1,   -1,  275,   -1,   -1,  295,  279,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,  288,   -1,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,  316,  300,  318,  319,
   -1,  304,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,  316,  334,  318,   -1,   -1,   -1,  322,
   -1,  341,   -1,   -1,  344,  345,   -1,  330,  331,   -1,
   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,
  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,
   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  256,   -1,   -1,   -1,  417,  418,  419,
  420,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,  418,  279,   -1,   -1,   -1,
   -1,   -1,  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,
   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,
   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,
   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,
  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  256,   -1,   -1,   -1,  417,  418,  419,  420,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,
   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,
   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,
  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,
   -1,  417,  418,  419,  420,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,
  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,
   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  417,  418,
  419,  420,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,
   -1,   -1,   -1,  285,   -1,   -1,  288,   -1,   -1,   -1,
   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,
   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,
   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,
   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,
  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  256,   -1,   -1,   -1,  417,  418,  419,  420,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  343,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,
   -1,   -1,  377,  378,  379,  380,  381,   -1,   -1,  384,
   -1,  386,  256,   -1,   -1,   -1,   -1,  392,  393,   -1,
  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,
   -1,  285,  417,  418,  288,  420,   -1,   -1,   -1,   -1,
   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,
  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  343,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,
   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,
  384,   -1,  386,  256,   -1,   -1,   -1,   -1,  392,  393,
   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,   -1,
   -1,   -1,  285,  417,  418,  288,  420,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,
   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,
   -1,  384,   -1,  386,  256,   -1,   -1,   -1,   -1,  392,
  393,   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,
   -1,   -1,   -1,  285,  417,  418,  288,  420,   -1,   -1,
   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,
   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,
   -1,   -1,  384,   -1,  386,  256,   -1,   -1,   -1,   -1,
  392,  393,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
   -1,   -1,   -1,   -1,  285,  417,  418,  288,  420,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,
   -1,   -1,   -1,  384,   -1,  386,  256,   -1,   -1,   -1,
   -1,  392,  393,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,   -1,   -1,   -1,   -1,  285,  417,  418,  288,  420,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,
  380,   -1,   -1,   -1,  384,   -1,  386,  256,   -1,   -1,
   -1,   -1,  392,  393,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,   -1,   -1,   -1,   -1,  285,  417,  418,  288,
  420,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,
  379,  380,   -1,   -1,   -1,  384,   -1,  386,  256,   -1,
   -1,   -1,   -1,  392,  393,   -1,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,  417,  418,
  288,  420,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,
   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,
  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,
  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,  256,
   -1,   -1,   -1,   -1,  392,  393,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,  417,
  418,  288,  420,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,
  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,
  256,   -1,   -1,   -1,   -1,  392,  393,   -1,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,
  417,  418,  288,  420,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,
  386,  256,   -1,   -1,   -1,   -1,  392,  393,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,  417,  418,  288,  420,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,
   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,
   -1,  386,  256,   -1,   -1,   -1,   -1,  392,  393,   -1,
  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,
   -1,  285,  417,  418,  288,  420,   -1,   -1,   -1,   -1,
   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,
  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,
   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,
  384,   -1,  386,  256,   -1,   -1,   -1,   -1,  392,  393,
   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,   -1,
   -1,   -1,  285,  417,  418,  288,  420,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,
   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,
   -1,  384,   -1,  386,  256,   -1,   -1,   -1,   -1,  392,
  393,   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,
   -1,   -1,   -1,  285,  417,  418,  288,  420,   -1,   -1,
   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,
   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,
   -1,   -1,  384,   -1,  386,  256,   -1,   -1,   -1,   -1,
  392,  393,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
   -1,   -1,   -1,   -1,  285,  417,  418,  288,  420,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,
   -1,   -1,   -1,  384,   -1,  386,  256,   -1,   -1,   -1,
   -1,  392,  393,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,   -1,   -1,   -1,   -1,  285,  417,  418,  288,  420,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,
  380,   -1,   -1,   -1,  384,   -1,  386,  256,   -1,   -1,
   -1,   -1,  392,  393,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,   -1,   -1,   -1,   -1,  285,  417,  418,  288,
  420,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,
  379,  380,   -1,   -1,   -1,  384,   -1,  386,  256,   -1,
   -1,   -1,   -1,  392,  393,   -1,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,  417,  418,
  288,  420,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,
   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,
  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,
  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,  256,
   -1,   -1,   -1,   -1,  392,  393,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,  417,
  418,  288,  420,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,
  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,
  256,   -1,   -1,   -1,   -1,  392,  393,   -1,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,
  417,  418,  288,  420,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,
  386,  256,   -1,   -1,   -1,   -1,  392,  393,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,  417,  418,  288,  420,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,
   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,
   -1,  386,  256,   -1,   -1,   -1,   -1,  392,  393,   -1,
  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,
   -1,  285,  417,  418,  288,  420,   -1,   -1,   -1,   -1,
   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,
  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,
   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,
  384,   -1,  386,  256,   -1,   -1,   -1,   -1,  392,  393,
   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,   -1,
   -1,   -1,  285,  417,  418,  288,  420,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,
   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,
   -1,  384,   -1,  386,  256,   -1,   -1,   -1,   -1,  392,
  393,   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,
   -1,   -1,   -1,  285,  417,  418,  288,  420,   -1,   -1,
   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,
   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,
   -1,   -1,  384,   -1,  386,  256,   -1,   -1,   -1,   -1,
  392,  393,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
   -1,   -1,   -1,   -1,  285,  417,  418,  288,  420,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,
   -1,   -1,   -1,  384,   -1,  386,  256,   -1,   -1,   -1,
   -1,  392,  393,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,   -1,   -1,   -1,   -1,  285,  417,  418,  288,  420,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,
  380,   -1,   -1,   -1,  384,   -1,  386,  256,   -1,   -1,
   -1,   -1,  392,  393,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,   -1,   -1,   -1,   -1,  285,  417,  418,  288,
  420,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,
  379,  380,   -1,   -1,   -1,  384,   -1,  386,  256,   -1,
   -1,   -1,   -1,  392,  393,   -1,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,  417,  418,
  288,  420,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,
   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,
  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,
  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,  256,
   -1,   -1,   -1,   -1,  392,  393,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,  417,
  418,  288,  420,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,
  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,
  256,   -1,   -1,   -1,   -1,  392,  393,   -1,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,
  417,  418,  288,  420,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,
  386,  256,   -1,   -1,   -1,   -1,  392,  393,  262,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,  417,  418,  288,  420,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,  298,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  371,  371,  372,  373,
  374,  375,   -1,   -1,  378,  379,   -1,   -1,  382,  383,
  384,  385,  386,  387,  388,  389,  390,   -1,  392,  393,
  394,  395,  396,  397,  398,  399,  400,  401,  402,  403,
  404,  405,  406,  407,  408,  409,  410,  411,  412,  413,
   -1,   -1,  417,  418,   -1,   -1,  420,   -1,  261,  423,
  263,   -1,  265,   -1,  267,   -1,   -1,  270,   -1,  272,
  273,   -1,  275,   -1,  277,   -1,  279,   -1,  281,  282,
  283,  284,   -1,   -1,  287,  288,   -1,   -1,   -1,   -1,
  293,  294,  295,  296,  297,   -1,   -1,  300,   -1,  302,
   -1,  304,   -1,  306,  307,   -1,  309,  310,  311,  312,
   -1,   -1,  315,  316,  317,  318,   -1,   -1,  321,  322,
  323,   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,   -1,
  333,  334,   -1,  336,  337,  338,   -1,   -1,   -1,  342,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,
   -1,  364,  365,  261,   -1,   -1,   -1,  265,   -1,  267,
   -1,   -1,  270,   -1,  272,  273,   -1,  275,   -1,  277,
   -1,  279,   -1,  281,  282,  283,  284,   -1,   -1,  287,
  288,   -1,   -1,   -1,   -1,  293,   -1,  295,  296,  297,
   -1,   -1,  300,   -1,  302,   -1,  304,   -1,   -1,  307,
   -1,  309,  310,  311,  312,  418,   -1,   -1,  316,  317,
  318,   -1,   -1,  321,  322,  323,   -1,   -1,   -1,   -1,
   -1,   -1,  330,  331,   -1,  333,  334,   -1,  336,  337,
  338,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  261,   -1,  362,   -1,  265,   -1,  267,   -1,
  368,  270,   -1,  272,  273,   -1,  275,   -1,  277,  377,
  279,   -1,  281,  282,  283,  284,   -1,   -1,  287,  288,
   -1,   -1,   -1,   -1,  293,   -1,  295,  296,  297,   -1,
   -1,  300,   -1,  302,   -1,  304,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,  316,  317,  318,
  418,   -1,  321,  322,  323,   -1,   -1,   -1,   -1,   -1,
   -1,  330,  331,   -1,  333,  334,   -1,  336,  337,  338,
   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  261,   -1,  362,   -1,  265,   -1,  267,   -1,  368,
  270,   -1,  272,  273,   -1,  275,   -1,  277,  377,  279,
   -1,  281,  282,  283,  284,   -1,   -1,  287,  288,   -1,
   -1,   -1,   -1,  293,   -1,  295,  296,  297,   -1,   -1,
  300,   -1,  302,   -1,  304,   -1,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,   -1,  316,  317,  318,  418,
   -1,  321,  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,
  330,  331,   -1,  333,  334,   -1,  336,  337,  338,   -1,
   -1,   -1,  342,   -1,   -1,   -1,   -1,  261,   -1,   -1,
   -1,  265,   -1,  267,   -1,   -1,  270,   -1,  272,  273,
   -1,  275,  362,  277,   -1,  279,   -1,  281,  282,  283,
  284,   -1,   -1,  287,  288,   -1,   -1,  377,   -1,  293,
   -1,  295,  296,  297,   -1,   -1,  300,   -1,  302,   -1,
  304,   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,   -1,  316,  317,  318,   -1,   -1,  321,  322,  323,
   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,  418,  333,
  334,   -1,  336,  337,  338,   -1,   -1,   -1,  342,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  261,   -1,   -1,   -1,  265,   -1,  267,  362,   -1,
  270,   -1,  272,  273,  368,  275,   -1,  277,   -1,  279,
   -1,  281,  282,  283,  284,   -1,   -1,  287,  288,   -1,
   -1,   -1,   -1,  293,   -1,  295,  296,  297,   -1,   -1,
  300,   -1,  302,  261,  304,   -1,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,   -1,  316,  317,  318,   -1,
   -1,  321,  322,  323,  418,   -1,  284,   -1,   -1,   -1,
  330,  331,   -1,  333,  334,   -1,  336,  337,  338,  297,
   -1,   -1,  342,   -1,  302,   -1,   -1,  305,   -1,  307,
   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,
   -1,   -1,  362,  321,   -1,   -1,   -1,  325,  368,   -1,
   -1,   -1,   -1,  261,   -1,  333,   -1,   -1,  336,   -1,
  338,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,   -1,  357,
   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,  297,
  368,  369,   -1,  371,  302,  373,   -1,  305,  418,  307,
   -1,  309,  310,  311,  312,   -1,   -1,   -1,  386,  317,
   -1,   -1,   -1,  321,   -1,  261,   -1,  325,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,
  338,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,
  418,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  297,   -1,  261,  362,   -1,  302,   -1,   -1,   -1,
  368,  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,
   -1,  317,   -1,   -1,   -1,  321,  284,   -1,   -1,  325,
   -1,   -1,   -1,  261,   -1,   -1,   -1,  333,   -1,  297,
  336,   -1,  338,   -1,  302,   -1,   -1,   -1,   -1,  307,
   -1,  309,  310,  311,  312,   -1,  284,   -1,   -1,  317,
  418,   -1,   -1,  321,   -1,   -1,  362,  325,   -1,  297,
   -1,   -1,  368,   -1,  302,  333,   -1,   -1,  336,  307,
  338,  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,
   -1,   -1,   -1,  321,   -1,   -1,   -1,   -1,   -1,   -1,
  264,  265,   -1,  267,  362,  333,  270,  271,  336,   -1,
  338,  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,
   -1,  285,  418,   -1,  288,   -1,   -1,   -1,   -1,   -1,
   -1,  295,   -1,   -1,  362,   -1,  300,   -1,  302,  303,
  304,   -1,  306,   -1,   -1,   -1,   -1,   -1,   -1,  313,
   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
  418,  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,
  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,
  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  418,   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,  372,   -1,
  374,   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,
  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,
   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
   -1,  279,   -1,  417,  418,  419,  420,  285,   -1,   -1,
  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,
   -1,   -1,  300,   -1,  302,  303,  304,   -1,  306,   -1,
   -1,   -1,   -1,   -1,   -1,  313,   -1,   -1,  316,   -1,
  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,
   -1,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  371,   -1,   -1,  374,   -1,   -1,  377,
  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,
   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,
   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,  417,
  418,  419,  420,  285,   -1,   -1,  288,   -1,   -1,   -1,
   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,  341,
   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,
   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,
   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,
  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,   -1,  279,   -1,  417,  418,  419,  420,  285,
   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,
   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,
   -1,  367,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,
  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,
   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,  417,  418,  419,  420,  285,   -1,   -1,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,   -1,  367,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,
  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,
   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,
  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,   -1,  279,   -1,  417,  418,  419,
  420,  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,
   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,
  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,
  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,
   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,
  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,
   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
   -1,  279,   -1,  417,  418,  419,  420,  285,   -1,   -1,
  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,
   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,
  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,
   -1,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,
  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,
   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,
   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,  417,
  418,  419,  420,  285,   -1,   -1,  288,   -1,   -1,   -1,
   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,
   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,
   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,
   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,
  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,   -1,  279,   -1,  417,  418,  419,  420,  285,
   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,
   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,
  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,
   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,  417,  418,  419,  420,  285,   -1,   -1,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,  261,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
  284,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,  297,  334,   -1,   -1,   -1,  302,   -1,
   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,  315,   -1,  317,   -1,   -1,   -1,  321,   -1,  359,
  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,  333,
   -1,  371,  336,   -1,  338,   -1,   -1,  377,  378,  379,
  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,
   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,  362,   -1,
   -1,   -1,   -1,   -1,  368,  369,   -1,   -1,   -1,   -1,
   -1,   -1,  263,   -1,  265,   -1,  267,  417,  418,  270,
  420,  272,  273,   -1,  275,   -1,  277,   -1,  279,   -1,
  281,  282,  283,   -1,   -1,   -1,  287,  288,   -1,   -1,
   -1,   -1,  293,   -1,  295,  296,   -1,   -1,   -1,  300,
   -1,   -1,   -1,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  315,  316,   -1,  318,   -1,   -1,
   -1,  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,  330,
  331,  264,  265,  334,  267,   -1,  337,  270,  271,   -1,
   -1,  342,  275,  276,  277,   -1,  279,   -1,   -1,   -1,
   -1,   -1,  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,
   -1,   -1,  295,  364,  365,   -1,   -1,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,  377,   -1,   -1,   -1,
   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,   -1,
   -1,  265,   -1,  267,   -1,   -1,  270,  418,  272,   -1,
   -1,  275,   -1,   -1,   -1,  279,  359,  360,  361,  362,
   -1,   -1,   -1,   -1,  288,  265,   -1,  267,  371,   -1,
  270,  295,  272,  273,   -1,  275,  300,  277,  302,  279,
  304,  281,  282,  283,   -1,   -1,   -1,  287,  288,   -1,
   -1,   -1,  316,  293,  318,  295,  296,   -1,  322,  323,
  300,   -1,   -1,   -1,  304,   -1,  330,  331,   -1,   -1,
  334,   -1,   -1,  337,  417,  418,  316,   -1,  318,   -1,
   -1,   -1,  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,
  330,  331,   -1,  265,  334,  267,   -1,  337,  270,   -1,
  272,  273,  342,  275,   -1,  277,   -1,  279,   -1,  281,
  282,  283,   -1,   -1,   -1,  287,  288,   -1,   -1,   -1,
   -1,  293,   -1,  295,  296,   -1,   -1,   -1,  300,   -1,
   -1,   -1,  304,   -1,   -1,   -1,   -1,  377,   -1,   -1,
   -1,   -1,   -1,   -1,  316,   -1,  318,   -1,   -1,   -1,
  322,  323,   -1,   -1,  418,   -1,   -1,   -1,  330,  331,
   -1,   -1,  334,   -1,   -1,  337,   -1,  265,   -1,  267,
  342,   -1,  270,   -1,   -1,  273,   -1,  275,  418,  277,
   -1,  279,   -1,  281,  282,  283,   -1,   -1,   -1,  287,
  288,   -1,   -1,   -1,   -1,  293,   -1,  295,   -1,  265,
   -1,  267,  300,   -1,  270,   -1,  304,  273,   -1,  275,
   -1,  277,   -1,  279,   -1,  281,  282,  283,  316,   -1,
  318,  287,  288,   -1,  322,   -1,   -1,  293,   -1,  295,
   -1,   -1,  330,  331,  300,   -1,  334,   -1,  304,  337,
   -1,   -1,   -1,  265,  342,  267,  418,   -1,  270,   -1,
  316,   -1,  318,  275,   -1,   -1,  322,  279,   -1,   -1,
   -1,   -1,   -1,   -1,  330,  331,  288,   -1,  334,   -1,
   -1,  337,   -1,  295,   -1,  265,  342,  267,  300,  377,
  270,   -1,  304,   -1,  306,  275,  308,   -1,   -1,  279,
   -1,  313,   -1,   -1,  316,   -1,  318,   -1,  288,   -1,
  322,   -1,   -1,  325,   -1,  295,   -1,   -1,  330,  331,
  300,   -1,  334,   -1,  304,  337,  306,   -1,  308,  265,
  418,  267,   -1,  313,  270,   -1,  316,   -1,  318,  275,
   -1,   -1,  322,  279,   -1,  325,   -1,   -1,   -1,   -1,
  330,  331,  288,   -1,  334,   -1,   -1,  337,   -1,  295,
  372,   -1,  418,   -1,  300,   -1,   -1,   -1,  304,   -1,
  306,   -1,   -1,   -1,   -1,   -1,   -1,  313,   -1,   -1,
  316,   -1,  318,   -1,   -1,   -1,  322,   -1,   -1,  325,
  370,   -1,   -1,   -1,  330,  331,   -1,   -1,  334,   -1,
  265,  337,  267,   -1,   -1,  270,  418,   -1,   -1,   -1,
  275,   -1,   -1,   -1,  279,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  288,   -1,   -1,   -1,  363,   -1,   -1,
  295,   -1,  265,   -1,  267,  300,   -1,  270,  418,  304,
   -1,  306,  275,  308,   -1,   -1,  279,   -1,  313,   -1,
   -1,  316,   -1,  318,   -1,  288,   -1,  322,   -1,   -1,
  325,   -1,  295,   -1,   -1,  330,  331,  300,   -1,  334,
   -1,  304,  337,  306,   -1,  308,   -1,   -1,   -1,   -1,
  313,   -1,  418,  316,   -1,  318,   -1,   -1,   -1,  322,
   -1,   -1,  325,   -1,   -1,   -1,   -1,  330,  331,   -1,
   -1,  334,   -1,  265,  337,  267,   -1,   -1,  270,   -1,
   -1,   -1,   -1,  275,   -1,   -1,   -1,  279,   -1,   -1,
   -1,  283,  265,   -1,  267,   -1,  288,  270,   -1,   -1,
   -1,  293,  275,  295,   -1,   -1,  279,   -1,  300,   -1,
   -1,   -1,  304,  305,   -1,  288,   -1,   -1,   -1,   -1,
   -1,   -1,  295,  418,  316,   -1,  318,  300,   -1,   -1,
  322,  304,   -1,   -1,   -1,   -1,  261,   -1,  330,  331,
   -1,   -1,  334,  316,   -1,  318,   -1,  272,   -1,  322,
   -1,   -1,  277,   -1,   -1,  418,  281,  330,  331,  284,
   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,   -1,
   -1,  296,  297,   -1,   -1,   -1,  301,  302,   -1,   -1,
   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
  363,   -1,  317,   -1,   -1,   -1,  321,   -1,  323,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,
  335,  336,  261,  338,   -1,   -1,   -1,  342,   -1,   -1,
   -1,   -1,   -1,  272,   -1,   -1,  418,   -1,  277,   -1,
   -1,   -1,  281,   -1,   -1,  284,   -1,  362,   -1,   -1,
   -1,   -1,   -1,  368,  369,  418,   -1,  296,  297,   -1,
   -1,   -1,  301,  302,  261,   -1,  263,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,
   -1,   -1,  321,   -1,  323,   -1,   -1,  284,   -1,   -1,
   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,
  297,   -1,   -1,  342,   -1,  302,   -1,   -1,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,   -1,   -1,  362,  321,   -1,   -1,  261,   -1,  368,
  369,   -1,   -1,   -1,   -1,   -1,  333,   -1,  272,  336,
   -1,  338,   -1,  277,   -1,   -1,   -1,  281,   -1,   -1,
  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  296,  297,   -1,  362,   -1,  301,  302,   -1,
  261,  368,  369,  307,   -1,  309,  310,  311,  312,   -1,
   -1,  272,   -1,  317,   -1,   -1,  277,  321,   -1,  323,
  281,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,  333,
   -1,   -1,  336,   -1,  338,  296,  297,   -1,  342,   -1,
  301,  302,  261,   -1,   -1,   -1,  307,   -1,  309,  310,
  311,  312,   -1,   -1,   -1,   -1,  317,   -1,  362,   -1,
  321,   -1,  323,   -1,  368,  284,   -1,   -1,   -1,   -1,
   -1,   -1,  333,   -1,   -1,  336,   -1,  338,  297,   -1,
  261,  342,   -1,  302,   -1,   -1,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,
   -1,  362,  321,  284,   -1,   -1,   -1,  368,   -1,   -1,
   -1,   -1,   -1,   -1,  333,   -1,  297,  336,  261,  338,
   -1,  302,   -1,   -1,   -1,   -1,  307,   -1,  309,  310,
  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,
  321,  284,   -1,  362,   -1,  364,  365,   -1,   -1,  368,
   -1,   -1,  333,   -1,  297,  336,  261,  338,  263,  302,
   -1,   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,
   -1,   -1,  315,   -1,  317,   -1,   -1,   -1,  321,  284,
   -1,  362,   -1,  364,  365,   -1,   -1,  368,   -1,   -1,
  333,   -1,  297,  336,  261,  338,   -1,  302,   -1,   -1,
   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
   -1,   -1,  317,   -1,   -1,   -1,  321,  284,   -1,  362,
   -1,   -1,   -1,   -1,  261,  368,  263,   -1,  333,   -1,
  297,  336,   -1,  338,   -1,  302,   -1,   -1,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,  284,   -1,   -1,
  317,   -1,   -1,   -1,  321,   -1,   -1,  362,   -1,   -1,
  297,   -1,   -1,  368,  261,  302,  333,   -1,   -1,  336,
  307,  338,  309,  310,  311,  312,   -1,   -1,  315,   -1,
  317,   -1,   -1,   -1,  321,   -1,   -1,  284,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  362,  333,  364,  365,  336,
  297,  338,   -1,   -1,   -1,  302,   -1,   -1,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,   -1,   -1,   -1,  321,  362,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,
   -1,  338,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  362,
  };

#line 7048 "cs-parser.jay"

// <summary>
//  A class used to hold info about an operator declarator
// </summary>
class OperatorDeclaration {
	public readonly Operator.OpType optype;
	public readonly FullNamedExpression ret_type;
	public readonly Location location;

	public OperatorDeclaration (Operator.OpType op, FullNamedExpression ret_type, Location location)
	{
		optype = op;
		this.ret_type = ret_type;
		this.location = location;
	}
}

void Error_ExpectingTypeName (Expression expr)
{
	if (expr is Invocation){
		report.Error (1002, expr.Location, "Expecting `;'");
	} else {
		expr.Error_InvalidExpressionStatement (report);
	}
}

void Error_ParameterModifierNotValid (string modifier, Location loc)
{
	report.Error (631, loc, "The parameter modifier `{0}' is not valid in this context",
			              modifier);
}

void Error_DuplicateParameterModifier (Location loc, Parameter.Modifier mod)
{
	report.Error (1107, loc, "Duplicate parameter modifier `{0}'",
  		Parameter.GetModifierSignature (mod));
}

void Error_TypeExpected (Location loc)
{
	report.Error (1031, loc, "Type expected");
}

void Error_UnsafeCodeNotAllowed (Location loc)
{
	report.Error (227, loc, "Unsafe code requires the `unsafe' command line option to be specified");
}

void Warning_EmptyStatement (Location loc)
{
	report.Warning (642, 3, loc, "Possible mistaken empty statement");
}

void Error_NamedArgumentExpected (NamedArgument a)
{
	report.Error (1738, a.Location, "Named arguments must appear after the positional arguments");
}

void Error_MissingInitializer (Location loc)
{
	report.Error (210, loc, "You must provide an initializer in a fixed or using statement declaration");
}

object Error_AwaitAsIdentifier (object token)
{
	if (async_block) {
		report.Error (4003, GetLocation (token), "`await' cannot be used as an identifier within an async method or lambda expression");
		return new LocatedToken ("await", GetLocation (token));
	}

	return token;
}

void push_current_container (TypeDefinition tc, object partial_token)
{
	if (module.Evaluator != null){
		tc.Definition.Modifiers = tc.ModFlags = (tc.ModFlags & ~Modifiers.AccessibilityMask) | Modifiers.PUBLIC;
		if (undo == null)
			undo = new Undo ();

		undo.AddTypeContainer (current_container, tc);
	}
	
	if (partial_token != null)
		current_container.AddPartial (tc);
	else
		current_container.AddTypeContainer (tc);
		
	++lexer.parsing_declaration;
	current_container = tc;
	current_type = tc;
}

TypeContainer pop_current_class ()
{
	var retval = current_container;

	current_container = current_container.Parent;
	current_type = current_type.Parent as TypeDefinition;

	return retval;
}

[System.Diagnostics.Conditional ("FULL_AST")]
void StoreModifierLocation (object token, Location loc)
{
	if (lbag == null)
		return;

	if (mod_locations == null)
  		mod_locations = new List<Tuple<Modifiers, Location>> ();

	mod_locations.Add (Tuple.Create ((Modifiers) token, loc));
}

List<Tuple<Modifiers, Location>> GetModifierLocations ()
{
	var result = mod_locations;
	mod_locations = null;
	return result;
}

[System.Diagnostics.Conditional ("FULL_AST")]
void PushLocation (Location loc)
{
	if (location_stack == null)
		location_stack = new Stack<Location> ();

	location_stack.Push (loc);
}

Location PopLocation ()
{
	if (location_stack == null)
		return Location.Null;

	return location_stack.Pop ();
}

string CheckAttributeTarget (string a, Location l)
{
	switch (a) {
	case "assembly" : case "module" : case "field" : case "method" : case "param" : case "property" : case "type" :
			return a;
	}

	report.Warning (658, 1, l,
		 "`{0}' is invalid attribute target. All attributes in this attribute section will be ignored", a);
	return string.Empty;
}

static bool IsUnaryOperator (Operator.OpType op)
{
	switch (op) {
		
	case Operator.OpType.LogicalNot: 
	case Operator.OpType.OnesComplement: 
	case Operator.OpType.Increment:
	case Operator.OpType.Decrement:
	case Operator.OpType.True: 
	case Operator.OpType.False: 
	case Operator.OpType.UnaryPlus: 
	case Operator.OpType.UnaryNegation:
		return true;
	}
	return false;
}

void syntax_error (Location l, string msg)
{
	report.Error (1003, l, "Syntax error, " + msg);
}

Tokenizer lexer;

public Tokenizer Lexer {
	get {
		return lexer;
	}
}		   

public CSharpParser (SeekableStreamReader reader, CompilationSourceFile file, ParserSession session)
	: this (reader, file, file.Compiler.Report, session)
{
}

public CSharpParser (SeekableStreamReader reader, CompilationSourceFile file, Report report, ParserSession session)
{
	this.file = file;
	current_container = current_namespace = file;
	
	this.module = file.Module;
	this.compiler = file.Compiler;
	this.settings = compiler.Settings;
	this.report = report;
	
	lang_version = settings.Version;
	yacc_verbose_flag = settings.VerboseParserFlag;
	doc_support = settings.DocumentationFile != null;
	lexer = new Tokenizer (reader, file, session);
	oob_stack = new Stack<object> ();
	lbag = session.LocationsBag;
	use_global_stacks = session.UseJayGlobalArrays;
	parameters_bucket = session.ParametersStack;
}

public void parse ()
{
	eof_token = Token.EOF;
	
	try {
		if (yacc_verbose_flag > 1)
			yyparse (lexer, new yydebug.yyDebugSimple ());
		else
			yyparse (lexer);
			
		Tokenizer tokenizer = lexer as Tokenizer;
		tokenizer.cleanup ();		
	} catch (Exception e){
	  	if (e is yyParser.yyUnexpectedEof) {
			Error_SyntaxError (yyToken);
			UnexpectedEOF = true;
			return;
		}
			
		if (e is yyParser.yyException) {
			if (report.Errors == 0)
				report.Error (-25, lexer.Location, "Parsing error");
		} else {
			// Used by compiler-tester to test internal errors
			if (yacc_verbose_flag > 0 || e is FatalException)
				throw;
		
			report.Error (589, lexer.Location, "Internal compiler error during parsing" + e);
		}
	}
}

void CheckToken (int error, int yyToken, string msg, Location loc)
{
	if (yyToken >= Token.FIRST_KEYWORD && yyToken <= Token.LAST_KEYWORD)
		report.Error (error, loc, "{0}: `{1}' is a keyword", msg, GetTokenName (yyToken));
	else
		report.Error (error, loc, msg);
}

string ConsumeStoredComment ()
{
	string s = tmpComment;
	tmpComment = null;
	Lexer.doc_state = XmlCommentState.Allowed;
	return s;
}

void FeatureIsNotAvailable (Location loc, string feature)
{
	report.FeatureIsNotAvailable (compiler, loc, feature);
}

Location GetLocation (object obj)
{
	var lt = obj as LocatedToken;
	if (lt != null)
		return lt.Location;
		
	var mn = obj as MemberName;
	if (mn != null)
		return mn.Location;
		
	var expr = obj as Expression;
	if (expr != null)
		return expr.Location;

	return lexer.Location;
}

void start_block (Location loc)
{
	if (current_block == null) {
		current_block = new ToplevelBlock (compiler, current_local_parameters, loc);
		parsing_anonymous_method = false;
	} else if (parsing_anonymous_method) {
		current_block = new ParametersBlock (current_block, current_local_parameters, loc);
		parsing_anonymous_method = false;
	} else {
		current_block = new ExplicitBlock (current_block, loc, Location.Null);
	}
}

Block
end_block (Location loc)
{
	Block retval = current_block.Explicit;
	retval.SetEndLocation (loc);
	current_block = retval.Parent;
	return retval;
}

void start_anonymous (bool isLambda, ParametersCompiled parameters, bool isAsync, Location loc)
{
	oob_stack.Push (current_anonymous_method);
	oob_stack.Push (current_local_parameters);
	oob_stack.Push (current_variable);
	oob_stack.Push (async_block);

	current_local_parameters = parameters;
	if (isLambda) {
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (loc, "lambda expressions");

		current_anonymous_method = new LambdaExpression (loc);
	} else {
		if (lang_version == LanguageVersion.ISO_1)
			FeatureIsNotAvailable (loc, "anonymous methods");
			
		current_anonymous_method = new AnonymousMethodExpression (loc);
	}
	current_anonymous_method.IsAsync = isAsync;
	
	async_block = isAsync;
	// Force the next block to be created as a ToplevelBlock
	parsing_anonymous_method = true;
}

/*
 * Completes the anonymous method processing, if lambda_expr is null, this
 * means that we have a Statement instead of an Expression embedded 
 */
AnonymousMethodExpression end_anonymous (ParametersBlock anon_block)
{
	AnonymousMethodExpression retval;

	if (async_block)
		anon_block.IsAsync = true;

	current_anonymous_method.Block = anon_block;
	retval = current_anonymous_method;

	async_block = (bool) oob_stack.Pop ();
	current_variable = (BlockVariable) oob_stack.Pop ();
	current_local_parameters = (ParametersCompiled) oob_stack.Pop ();
	current_anonymous_method = (AnonymousMethodExpression) oob_stack.Pop ();

	return retval;
}

void Error_SyntaxError (int token)
{
	Error_SyntaxError (0, token);
}

void Error_SyntaxError (int error_code, int token)
{
	Error_SyntaxError (error_code, token, "Unexpected symbol");
}

void Error_SyntaxError (int error_code, int token, string msg)
{
	Lexer.CompleteOnEOF = false;

	// An error message has been reported by tokenizer
	if (token == Token.ERROR)
		return;
	
	// Avoid duplicit error message after unterminated string literals
	if (token == Token.LITERAL && lexer.Location.Column == 0)
		return;

	string symbol = GetSymbolName (token);
	string expecting = GetExpecting ();
	var loc = lexer.Location - symbol.Length;
	
	if (error_code == 0) {
		if (expecting == "`identifier'") {
			if (token > Token.FIRST_KEYWORD && token < Token.LAST_KEYWORD) {
				report.Error (1041, loc, "Identifier expected, `{0}' is a keyword", symbol);
				return;
			}
			
			error_code = 1001;
			expecting = "identifier";
		} else if (expecting == "`)'") {
			error_code = 1026;
		} else {
			error_code = 1525;
		}
	}
	
	if (string.IsNullOrEmpty (expecting))
		report.Error (error_code, loc, "{1} `{0}'", symbol, msg);
	else
		report.Error (error_code, loc, "{2} `{0}', expecting {1}", symbol, expecting, msg);	  
}

string GetExpecting ()
{
	int [] tokens = yyExpectingTokens (yyExpectingState);
	var names = new List<string> (tokens.Length);
	bool has_type = false;
	bool has_identifier = false;
	for (int i = 0; i < tokens.Length; i++){
		int token = tokens [i];
		has_identifier |= token == Token.IDENTIFIER;
		
		string name = GetTokenName (token);
		if (name == "<internal>")
			continue;
			
		has_type |= name == "type";
		if (names.Contains (name))
			continue;
		
		names.Add (name);
	}

	//
	// Too many tokens to enumerate
	//
	if (names.Count > 8)
		return null;

	if (has_type && has_identifier)
		names.Remove ("identifier");

	if (names.Count == 1)
		return "`" + GetTokenName (tokens [0]) + "'";
	
	StringBuilder sb = new StringBuilder ();
	names.Sort ();
	int count = names.Count;
	for (int i = 0; i < count; i++){
		bool last = i + 1 == count;
		if (last)
			sb.Append ("or ");
		sb.Append ('`');
		sb.Append (names [i]);
		sb.Append (last ? "'" : count < 3 ? "' " : "', ");
	}
	return sb.ToString ();
}


string GetSymbolName (int token)
{
	switch (token){
	case Token.LITERAL:
		return ((Constant)lexer.Value).GetValue ().ToString ();
	case Token.IDENTIFIER:
		return ((LocatedToken)lexer.Value).Value;

	case Token.BOOL:
		return "bool";
	case Token.BYTE:
		return "byte";
	case Token.CHAR:
		return "char";
	case Token.VOID:
		return "void";
	case Token.DECIMAL:
		return "decimal";
	case Token.DOUBLE:
		return "double";
	case Token.FLOAT:
		return "float";
	case Token.INT:
		return "int";
	case Token.LONG:
		return "long";
	case Token.SBYTE:
		return "sbyte";
	case Token.SHORT:
		return "short";
	case Token.STRING:
		return "string";
	case Token.UINT:
		return "uint";
	case Token.ULONG:
		return "ulong";
	case Token.USHORT:
		return "ushort";
	case Token.OBJECT:
		return "object";
		
	case Token.PLUS:
		return "+";
	case Token.UMINUS:
	case Token.MINUS:
		return "-";
	case Token.BANG:
		return "!";
	case Token.BITWISE_AND:
		return "&";
	case Token.BITWISE_OR:
		return "|";
	case Token.STAR:
		return "*";
	case Token.PERCENT:
		return "%";
	case Token.DIV:
		return "/";
	case Token.CARRET:
		return "^";
	case Token.OP_INC:
		return "++";
	case Token.OP_DEC:
		return "--";
	case Token.OP_SHIFT_LEFT:
		return "<<";
	case Token.OP_SHIFT_RIGHT:
		return ">>";
	case Token.OP_LT:
		return "<";
	case Token.OP_GT:
		return ">";
	case Token.OP_LE:
		return "<=";
	case Token.OP_GE:
		return ">=";
	case Token.OP_EQ:
		return "==";
	case Token.OP_NE:
		return "!=";
	case Token.OP_AND:
		return "&&";
	case Token.OP_OR:
		return "||";
	case Token.OP_PTR:
		return "->";
	case Token.OP_COALESCING:	
		return "??";
	case Token.OP_MULT_ASSIGN:
		return "*=";
	case Token.OP_DIV_ASSIGN:
		return "/=";
	case Token.OP_MOD_ASSIGN:
		return "%=";
	case Token.OP_ADD_ASSIGN:
		return "+=";
	case Token.OP_SUB_ASSIGN:
		return "-=";
	case Token.OP_SHIFT_LEFT_ASSIGN:
		return "<<=";
	case Token.OP_SHIFT_RIGHT_ASSIGN:
		return ">>=";
	case Token.OP_AND_ASSIGN:
		return "&=";
	case Token.OP_XOR_ASSIGN:
		return "^=";
	case Token.OP_OR_ASSIGN:
		return "|=";
	}

	return GetTokenName (token);
}

static string GetTokenName (int token)
{
	switch (token){
	case Token.ABSTRACT:
		return "abstract";
	case Token.AS:
		return "as";
	case Token.ADD:
		return "add";
	case Token.ASYNC:
		return "async";
	case Token.BASE:
		return "base";
	case Token.BREAK:
		return "break";
	case Token.CASE:
		return "case";
	case Token.CATCH:
		return "catch";
	case Token.CHECKED:
		return "checked";
	case Token.CLASS:
		return "class";
	case Token.CONST:
		return "const";
	case Token.CONTINUE:
		return "continue";
	case Token.DEFAULT:
		return "default";
	case Token.DELEGATE:
		return "delegate";
	case Token.DO:
		return "do";
	case Token.ELSE:
		return "else";
	case Token.ENUM:
		return "enum";
	case Token.EVENT:
		return "event";
	case Token.EXPLICIT:
		return "explicit";
	case Token.EXTERN:
	case Token.EXTERN_ALIAS:
		return "extern";
	case Token.FALSE:
		return "false";
	case Token.FINALLY:
		return "finally";
	case Token.FIXED:
		return "fixed";
	case Token.FOR:
		return "for";
	case Token.FOREACH:
		return "foreach";
	case Token.GOTO:
		return "goto";
	case Token.IF:
		return "if";
	case Token.IMPLICIT:
		return "implicit";
	case Token.IN:
		return "in";
	case Token.INTERFACE:
		return "interface";
	case Token.INTERNAL:
		return "internal";
	case Token.IS:
		return "is";
	case Token.LOCK:
		return "lock";
	case Token.NAMESPACE:
		return "namespace";
	case Token.NEW:
		return "new";
	case Token.NULL:
		return "null";
	case Token.OPERATOR:
		return "operator";
	case Token.OUT:
		return "out";
	case Token.OVERRIDE:
		return "override";
	case Token.PARAMS:
		return "params";
	case Token.PRIVATE:
		return "private";
	case Token.PROTECTED:
		return "protected";
	case Token.PUBLIC:
		return "public";
	case Token.READONLY:
		return "readonly";
	case Token.REF:
		return "ref";
	case Token.RETURN:
		return "return";
	case Token.REMOVE:
		return "remove";
	case Token.SEALED:
		return "sealed";
	case Token.SIZEOF:
		return "sizeof";
	case Token.STACKALLOC:
		return "stackalloc";
	case Token.STATIC:
		return "static";
	case Token.STRUCT:
		return "struct";
	case Token.SWITCH:
		return "switch";
	case Token.THIS:
		return "this";
	case Token.THROW:
		return "throw";
	case Token.TRUE:
		return "true";
	case Token.TRY:
		return "try";
	case Token.TYPEOF:
		return "typeof";
	case Token.UNCHECKED:
		return "unchecked";
	case Token.UNSAFE:
		return "unsafe";
	case Token.USING:
		return "using";
	case Token.VIRTUAL:
		return "virtual";
	case Token.VOLATILE:
		return "volatile";
	case Token.WHERE:
		return "where";
	case Token.WHILE:
		return "while";
	case Token.ARGLIST:
		return "__arglist";
	case Token.REFVALUE:
		return "__refvalue";
	case Token.REFTYPE:
		return "__reftype";
	case Token.MAKEREF:
		return "__makeref";
	case Token.PARTIAL:
		return "partial";
	case Token.ARROW:
		return "=>";
	case Token.FROM:
	case Token.FROM_FIRST:
		return "from";
	case Token.JOIN:
		return "join";
	case Token.ON:
		return "on";
	case Token.EQUALS:
		return "equals";
	case Token.SELECT:
		return "select";
	case Token.GROUP:
		return "group";
	case Token.BY:
		return "by";
	case Token.LET:
		return "let";
	case Token.ORDERBY:
		return "orderby";
	case Token.ASCENDING:
		return "ascending";
	case Token.DESCENDING:
		return "descending";
	case Token.INTO:
		return "into";
	case Token.GET:
		return "get";
	case Token.SET:
		return "set";
	case Token.OPEN_BRACE:
		return "{";
	case Token.CLOSE_BRACE:
		return "}";
	case Token.OPEN_BRACKET:
	case Token.OPEN_BRACKET_EXPR:
		return "[";
	case Token.CLOSE_BRACKET:
		return "]";
	case Token.OPEN_PARENS_CAST:
	case Token.OPEN_PARENS_LAMBDA:
	case Token.OPEN_PARENS:
		return "(";
	case Token.CLOSE_PARENS:
		return ")";
	case Token.DOT:
		return ".";
	case Token.COMMA:
		return ",";
	case Token.DEFAULT_COLON:
		return "default:";
	case Token.COLON:
		return ":";
	case Token.SEMICOLON:
		return ";";
	case Token.TILDE:
		return "~";
		
	case Token.PLUS:
	case Token.UMINUS:
	case Token.MINUS:
	case Token.BANG:
	case Token.OP_LT:
	case Token.OP_GT:
	case Token.BITWISE_AND:
	case Token.BITWISE_OR:
	case Token.STAR:
	case Token.PERCENT:
	case Token.DIV:
	case Token.CARRET:
	case Token.OP_INC:
	case Token.OP_DEC:
	case Token.OP_SHIFT_LEFT:
	case Token.OP_SHIFT_RIGHT:
	case Token.OP_LE:
	case Token.OP_GE:
	case Token.OP_EQ:
	case Token.OP_NE:
	case Token.OP_AND:
	case Token.OP_OR:
	case Token.OP_PTR:
	case Token.OP_COALESCING:	
	case Token.OP_MULT_ASSIGN:
	case Token.OP_DIV_ASSIGN:
	case Token.OP_MOD_ASSIGN:
	case Token.OP_ADD_ASSIGN:
	case Token.OP_SUB_ASSIGN:
	case Token.OP_SHIFT_LEFT_ASSIGN:
	case Token.OP_SHIFT_RIGHT_ASSIGN:
	case Token.OP_AND_ASSIGN:
	case Token.OP_XOR_ASSIGN:
	case Token.OP_OR_ASSIGN:
		return "<operator>";

	case Token.BOOL:
	case Token.BYTE:
	case Token.CHAR:
	case Token.VOID:
	case Token.DECIMAL:
	case Token.DOUBLE:
	case Token.FLOAT:
	case Token.INT:
	case Token.LONG:
	case Token.SBYTE:
	case Token.SHORT:
	case Token.STRING:
	case Token.UINT:
	case Token.ULONG:
	case Token.USHORT:
	case Token.OBJECT:
		return "type";
	
	case Token.ASSIGN:
		return "=";
	case Token.OP_GENERICS_LT:
	case Token.GENERIC_DIMENSION:
		return "<";
	case Token.OP_GENERICS_GT:
		return ">";
	case Token.INTERR:
	case Token.INTERR_NULLABLE:
		return "?";
	case Token.DOUBLE_COLON:
		return "::";
	case Token.LITERAL:
		return "value";
	case Token.IDENTIFIER:
	case Token.AWAIT:
		return "identifier";

	case Token.EOF:
		return "end-of-file";

		// All of these are internal.
	case Token.NONE:
	case Token.ERROR:
	case Token.FIRST_KEYWORD:
	case Token.EVAL_COMPILATION_UNIT_PARSER:
	case Token.EVAL_USING_DECLARATIONS_UNIT_PARSER:
	case Token.EVAL_STATEMENT_PARSER:
	case Token.LAST_KEYWORD:
	case Token.GENERATE_COMPLETION:
	case Token.COMPLETE_COMPLETION:
		return "<internal>";

		// A bit more robust.
	default:
		return yyNames [token];
        }
}

/* end end end */
}
#line default
namespace yydebug {
        using System;
	 internal interface yyDebug {
		 void push (int state, Object value);
		 void lex (int state, int token, string name, Object value);
		 void shift (int from, int to, int errorFlag);
		 void pop (int state);
		 void discard (int state, int token, string name, Object value);
		 void reduce (int from, int to, int rule, string text, int len);
		 void shift (int from, int to);
		 void accept (Object value);
		 void error (string message);
		 void reject ();
	 }
	 
	 class yyDebugSimple : yyDebug {
		 void println (string s){
			 Console.Error.WriteLine (s);
		 }
		 
		 public void push (int state, Object value) {
			 println ("push\tstate "+state+"\tvalue "+value);
		 }
		 
		 public void lex (int state, int token, string name, Object value) {
			 println("lex\tstate "+state+"\treading "+name+"\tvalue "+value);
		 }
		 
		 public void shift (int from, int to, int errorFlag) {
			 switch (errorFlag) {
			 default:				// normally
				 println("shift\tfrom state "+from+" to "+to);
				 break;
			 case 0: case 1: case 2:		// in error recovery
				 println("shift\tfrom state "+from+" to "+to
					     +"\t"+errorFlag+" left to recover");
				 break;
			 case 3:				// normally
				 println("shift\tfrom state "+from+" to "+to+"\ton error");
				 break;
			 }
		 }
		 
		 public void pop (int state) {
			 println("pop\tstate "+state+"\ton error");
		 }
		 
		 public void discard (int state, int token, string name, Object value) {
			 println("discard\tstate "+state+"\ttoken "+name+"\tvalue "+value);
		 }
		 
		 public void reduce (int from, int to, int rule, string text, int len) {
			 println("reduce\tstate "+from+"\tuncover "+to
				     +"\trule ("+rule+") "+text);
		 }
		 
		 public void shift (int from, int to) {
			 println("goto\tfrom state "+from+" to "+to);
		 }
		 
		 public void accept (Object value) {
			 println("accept\tvalue "+value);
		 }
		 
		 public void error (string message) {
			 println("error\t"+message);
		 }
		 
		 public void reject () {
			 println("reject");
		 }
		 
	 }
}
// %token constants
 class Token {
  public const int EOF = 257;
  public const int NONE = 258;
  public const int ERROR = 259;
  public const int FIRST_KEYWORD = 260;
  public const int ABSTRACT = 261;
  public const int AS = 262;
  public const int ADD = 263;
  public const int BASE = 264;
  public const int BOOL = 265;
  public const int BREAK = 266;
  public const int BYTE = 267;
  public const int CASE = 268;
  public const int CATCH = 269;
  public const int CHAR = 270;
  public const int CHECKED = 271;
  public const int CLASS = 272;
  public const int CONST = 273;
  public const int CONTINUE = 274;
  public const int DECIMAL = 275;
  public const int DEFAULT = 276;
  public const int DELEGATE = 277;
  public const int DO = 278;
  public const int DOUBLE = 279;
  public const int ELSE = 280;
  public const int ENUM = 281;
  public const int EVENT = 282;
  public const int EXPLICIT = 283;
  public const int EXTERN = 284;
  public const int FALSE = 285;
  public const int FINALLY = 286;
  public const int FIXED = 287;
  public const int FLOAT = 288;
  public const int FOR = 289;
  public const int FOREACH = 290;
  public const int GOTO = 291;
  public const int IF = 292;
  public const int IMPLICIT = 293;
  public const int IN = 294;
  public const int INT = 295;
  public const int INTERFACE = 296;
  public const int INTERNAL = 297;
  public const int IS = 298;
  public const int LOCK = 299;
  public const int LONG = 300;
  public const int NAMESPACE = 301;
  public const int NEW = 302;
  public const int NULL = 303;
  public const int OBJECT = 304;
  public const int OPERATOR = 305;
  public const int OUT = 306;
  public const int OVERRIDE = 307;
  public const int PARAMS = 308;
  public const int PRIVATE = 309;
  public const int PROTECTED = 310;
  public const int PUBLIC = 311;
  public const int READONLY = 312;
  public const int REF = 313;
  public const int RETURN = 314;
  public const int REMOVE = 315;
  public const int SBYTE = 316;
  public const int SEALED = 317;
  public const int SHORT = 318;
  public const int SIZEOF = 319;
  public const int STACKALLOC = 320;
  public const int STATIC = 321;
  public const int STRING = 322;
  public const int STRUCT = 323;
  public const int SWITCH = 324;
  public const int THIS = 325;
  public const int THROW = 326;
  public const int TRUE = 327;
  public const int TRY = 328;
  public const int TYPEOF = 329;
  public const int UINT = 330;
  public const int ULONG = 331;
  public const int UNCHECKED = 332;
  public const int UNSAFE = 333;
  public const int USHORT = 334;
  public const int USING = 335;
  public const int VIRTUAL = 336;
  public const int VOID = 337;
  public const int VOLATILE = 338;
  public const int WHERE = 339;
  public const int WHILE = 340;
  public const int ARGLIST = 341;
  public const int PARTIAL = 342;
  public const int ARROW = 343;
  public const int FROM = 344;
  public const int FROM_FIRST = 345;
  public const int JOIN = 346;
  public const int ON = 347;
  public const int EQUALS = 348;
  public const int SELECT = 349;
  public const int GROUP = 350;
  public const int BY = 351;
  public const int LET = 352;
  public const int ORDERBY = 353;
  public const int ASCENDING = 354;
  public const int DESCENDING = 355;
  public const int INTO = 356;
  public const int INTERR_NULLABLE = 357;
  public const int EXTERN_ALIAS = 358;
  public const int REFVALUE = 359;
  public const int REFTYPE = 360;
  public const int MAKEREF = 361;
  public const int ASYNC = 362;
  public const int AWAIT = 363;
  public const int GET = 364;
  public const int SET = 365;
  public const int LAST_KEYWORD = 366;
  public const int OPEN_BRACE = 367;
  public const int CLOSE_BRACE = 368;
  public const int OPEN_BRACKET = 369;
  public const int CLOSE_BRACKET = 370;
  public const int OPEN_PARENS = 371;
  public const int CLOSE_PARENS = 372;
  public const int DOT = 373;
  public const int COMMA = 374;
  public const int COLON = 375;
  public const int SEMICOLON = 376;
  public const int TILDE = 377;
  public const int PLUS = 378;
  public const int MINUS = 379;
  public const int BANG = 380;
  public const int ASSIGN = 381;
  public const int OP_LT = 382;
  public const int OP_GT = 383;
  public const int BITWISE_AND = 384;
  public const int BITWISE_OR = 385;
  public const int STAR = 386;
  public const int PERCENT = 387;
  public const int DIV = 388;
  public const int CARRET = 389;
  public const int INTERR = 390;
  public const int DOUBLE_COLON = 391;
  public const int OP_INC = 392;
  public const int OP_DEC = 393;
  public const int OP_SHIFT_LEFT = 394;
  public const int OP_SHIFT_RIGHT = 395;
  public const int OP_LE = 396;
  public const int OP_GE = 397;
  public const int OP_EQ = 398;
  public const int OP_NE = 399;
  public const int OP_AND = 400;
  public const int OP_OR = 401;
  public const int OP_MULT_ASSIGN = 402;
  public const int OP_DIV_ASSIGN = 403;
  public const int OP_MOD_ASSIGN = 404;
  public const int OP_ADD_ASSIGN = 405;
  public const int OP_SUB_ASSIGN = 406;
  public const int OP_SHIFT_LEFT_ASSIGN = 407;
  public const int OP_SHIFT_RIGHT_ASSIGN = 408;
  public const int OP_AND_ASSIGN = 409;
  public const int OP_XOR_ASSIGN = 410;
  public const int OP_OR_ASSIGN = 411;
  public const int OP_PTR = 412;
  public const int OP_COALESCING = 413;
  public const int OP_GENERICS_LT = 414;
  public const int OP_GENERICS_LT_DECL = 415;
  public const int OP_GENERICS_GT = 416;
  public const int LITERAL = 417;
  public const int IDENTIFIER = 418;
  public const int OPEN_PARENS_LAMBDA = 419;
  public const int OPEN_PARENS_CAST = 420;
  public const int GENERIC_DIMENSION = 421;
  public const int DEFAULT_COLON = 422;
  public const int OPEN_BRACKET_EXPR = 423;
  public const int EVAL_STATEMENT_PARSER = 424;
  public const int EVAL_COMPILATION_UNIT_PARSER = 425;
  public const int EVAL_USING_DECLARATIONS_UNIT_PARSER = 426;
  public const int DOC_SEE = 427;
  public const int GENERATE_COMPLETION = 428;
  public const int COMPLETE_COMPLETION = 429;
  public const int UMINUS = 430;
  public const int yyErrorCode = 256;
 }
 namespace yyParser {
  using System;
  /** thrown for irrecoverable syntax errors and stack overflow.
    */
  internal class yyException : System.Exception {
    public yyException (string message) : base (message) {
    }
  }
  internal class yyUnexpectedEof : yyException {
    public yyUnexpectedEof (string message) : base (message) {
    }
    public yyUnexpectedEof () : base ("") {
    }
  }

  /** must be implemented by a scanner object to supply input to the parser.
    */
  internal interface yyInput {
    /** move on to next token.
        @return false if positioned beyond tokens.
        @throws IOException on input error.
      */
    bool advance (); // throws java.io.IOException;
    /** classifies current token.
        Should not be called if advance() returned false.
        @return current %token or single character.
      */
    int token ();
    /** associated with current token.
        Should not be called if advance() returned false.
        @return value for token().
      */
    Object value ();
  }
 }
} // close outermost namespace, that MUST HAVE BEEN opened in the prolog
