/* NVTV nv_type -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * Extends the NVRec type and introduces new types, and should
 * eventually be merged with the original XFree file.  
 * 
 */

#ifndef _NV_TYPE_H
#define _NV_TYPE_H

#include "xfree.h" 
#include "xf86i2c.h"
#include "tv_common.h"

/* Number of TV Busses */
#define NV_MAXBUS 3

typedef struct {
  int major; /* major architecutre, replaces riva.architecture */
  int exact; /* exact architecture */
  int heads; /* number of heads */
  CARD32 boot; /* boot mask */
  long crystalFreq; /* replaces riva.CrystalFreqKHz */
  long minVco;      /* minimum frequency of VCO for VPLL, in kHz */
  long maxVco;      /* maximum frequency of VCO for VPLL, in kHz */
  long maxVclk[2];  /* maximum frequency of VPLL, per head, in kHz */
  long freqM[4];    /* ascending limit frequencies for maxM, in kHz */
  int maxM[4];      /* maximum M below limit frequency; ends with 0 */
  int maxP;         /* maximum P */
  int minM;         /* minimum M */
} NVArch;

typedef struct {
  RIVA_HW_INST        riva;
  /* ... */
  CARD32              IOAddress;
  /* ... */
  int                 Chipset;
  /* ... */
  /* new members */
  NVArch	      arch; /* Architecture dependend info */
  TVEncoderObj	      tvEncoder;
  I2CChainPtr         TvChain; /* chain of devices on all busses */
  I2CBusPtr           TvBusses[NV_MAXBUS];
  int                 TvMaxBus;
  int                 TvHead; /* head tv bus is associated to */
} NVRec, *NVPtr;

#define NVPTR(p) ((NVPtr)((p)->driverPrivate))

#endif /* _NV_TYPE_H */

