/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.upload;

import javax.servlet.http.HttpServletRequest;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.servlet.TurbineServlet;
import org.apache.turbine.services.upload.UploadService;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.TurbineException;

public abstract class BaseUploadService
extends TurbineBaseService
implements UploadService {
    public static final int MAX_HEADER_SIZE = 1024;

    public void init() {
        String realPath;
        String path = this.getProperties().getProperty("repository", ".".toString());
        if (!path.startsWith("/") && (realPath = TurbineServlet.getRealPath(path)) != null) {
            path = realPath;
        }
        this.getProperties().setProperty("repository", path);
        this.setInit(true);
    }

    public abstract void parseRequest(HttpServletRequest var1, ParameterParser var2, String var3) throws TurbineException;

    public int getSizeMax() {
        String sizeMax = this.getProperties().getProperty("size.max", UploadService.SIZE_MAX_DEFAULT.toString());
        try {
            return Integer.parseInt(sizeMax);
        }
        catch (NumberFormatException e) {
            return UploadService.SIZE_MAX_DEFAULT;
        }
    }

    public int getSizeThreshold() {
        String sizeThreshold = this.getProperties().getProperty("size.threshold", UploadService.SIZE_THRESHOLD_DEFAULT.toString());
        try {
            return Integer.parseInt(sizeThreshold);
        }
        catch (NumberFormatException e) {
            return UploadService.SIZE_THRESHOLD_DEFAULT;
        }
    }

    public String getRepository() {
        return this.getProperties().getProperty("repository", ".".toString());
    }
}

