/*
             Common Public License Version 0.5

             THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF
             THIS COMMON PUBLIC LICENSE ("AGREEMENT"). ANY USE,
             REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
             RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.

             1. DEFINITIONS

             "Contribution" means:
                   a) in the case of the initial Contributor, the
                   initial code and documentation distributed under
                   this Agreement, and

                   b) in the case of each subsequent Contributor:
                   i) changes to the Program, and
                   ii) additions to the Program;

                   where such changes and/or additions to the Program
                   originate from and are distributed by that
                   particular Contributor. A Contribution 'originates'
                   from a Contributor if it was added to the Program
                   by such Contributor itself or anyone acting on such
                   Contributor's behalf. Contributions do not include
                   additions to the Program which: (i) are separate
                   modules of software distributed in conjunction with
                   the Program under their own license agreement, and
                   (ii) are not derivative works of the Program.


             "Contributor" means any person or entity that distributes
             the Program.

             "Licensed Patents " mean patent claims licensable by a
             Contributor which are necessarily infringed by the use or
             sale of its Contribution alone or when combined with the
             Program.

             "Program" means the Contributions distributed in
             accordance with this Agreement.

             "Recipient" means anyone who receives the Program under
             this Agreement, including all Contributors.

             2. GRANT OF RIGHTS

                   a) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free copyright
                   license to reproduce, prepare derivative works of,
                   publicly display, publicly perform, distribute and
                   sublicense the Contribution of such Contributor, if
                   any, and such derivative works, in source code and
                   object code form.

                   b) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free patent
                   license under Licensed Patents to make, use, sell,
                   offer to sell, import and otherwise transfer the
                   Contribution of such Contributor, if any, in source
                   code and object code form. This patent license
                   shall apply to the combination of the Contribution
                   and the Program if, at the time the Contribution is
                   added by the Contributor, such addition of the
                   Contribution causes such combination to be covered
                   by the Licensed Patents. The patent license shall
                   not apply to any other combinations which include
                   the Contribution. No hardware per se is licensed
                   hereunder.

                   c) Recipient understands that although each
                   Contributor grants the licenses to its
                   Contributions set forth herein, no assurances are
                   provided by any Contributor that the Program does
                   not infringe the patent or other intellectual
                   property rights of any other entity. Each
                   Contributor disclaims any liability to Recipient
                   for claims brought by any other entity based on
                   infringement of intellectual property rights or
                   otherwise. As a condition to exercising the rights
                   and licenses granted hereunder, each Recipient
                   hereby assumes sole responsibility to secure any
                   other intellectual property rights needed, if any.

                   For example, if a third party patent license is
                   required to allow Recipient to distribute the
                   Program, it is Recipient's responsibility to
                   acquire that license before distributing the
                   Program.

                   d) Each Contributor represents that to its
                   knowledge it has sufficient copyright rights in its
                   Contribution, if any, to grant the copyright
                   license set forth in this Agreement.

             3. REQUIREMENTS

             A Contributor may choose to distribute the Program in
             object code form under its own license agreement, provided
             that:
                   a) it complies with the terms and conditions of
                   this Agreement; and

                   b) its license agreement:
                   i) effectively disclaims on behalf of all
                   Contributors all warranties and conditions, express
                   and implied, including warranties or conditions of
                   title and non-infringement, and implied warranties
                   or conditions of merchantability and fitness for a
                   particular purpose;

                   ii) effectively excludes on behalf of all
                   Contributors all liability for damages, including
                   direct, indirect, special, incidental and
                   consequential damages, such as lost profits;

                   iii) states that any provisions which differ from
                   this Agreement are offered by that Contributor
                   alone and not by any other party; and

                   iv) states that source code for the Program is
                   available from such Contributor, and informs
                   licensees how to obtain it in a reasonable manner
                   on or through a medium customarily used for
                   software exchange.

             When the Program is made available in source code form:
                   a) it must be made available under this Agreement;
                   and
                   b) a copy of this Agreement must be included with
                   each copy of the Program.

             Contributors may not remove or alter any copyright notices
             contained within the Program.

             Each Contributor must identify itself as the originator of
             its Contribution, if any, in a manner that reasonably
             allows subsequent Recipients to identify the originator of
             the Contribution.


             4. COMMERCIAL DISTRIBUTION

             Commercial distributors of software may accept certain
             responsibilities with respect to end users, business
             partners and the like. While this license is intended to
             facilitate the commercial use of the Program, the
             Contributor who includes the Program in a commercial
             product offering should do so in a manner which does not
             create potential liability for other Contributors.
             Therefore, if a Contributor includes the Program in a
             commercial product offering, such Contributor ("Commercial
             Contributor") hereby agrees to defend and indemnify every
             other Contributor ("Indemnified Contributor") against any
             losses, damages and costs (collectively "Losses") arising
             from claims, lawsuits and other legal actions brought by a
             third party against the Indemnified Contributor to the
             extent caused by the acts or omissions of such Commercial
             Contributor in connection with its distribution of the
             Program in a commercial product offering. The obligations
             in this section do not apply to any claims or Losses
             relating to any actual or alleged intellectual property
             infringement. In order to qualify, an Indemnified
             Contributor must: a) promptly notify the Commercial
             Contributor in writing of such claim, and b) allow the
             Commercial Contributor to control, and cooperate with the
             Commercial Contributor in, the defense and any related
             settlement negotiations. The Indemnified Contributor may
             participate in any such claim at its own expense.


             For example, a Contributor might include the Program in a
             commercial product offering, Product X. That Contributor
             is then a Commercial Contributor. If that Commercial
             Contributor then makes performance claims, or offers
             warranties related to Product X, those performance claims
             and warranties are such Commercial Contributor's
             responsibility alone. Under this section, the Commercial
             Contributor would have to defend claims against the other
             Contributors related to those performance claims and
             warranties, and if a court requires any other Contributor
             to pay any damages as a result, the Commercial Contributor
             must pay those damages.


             5. NO WARRANTY

             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE
             PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT
             WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR
             IMPLIED INCLUDING, WITHOUT LIMITATION, ANY WARRANTIES OR
             CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR
             FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is solely
             responsible for determining the appropriateness of using
             and distributing the Program and assumes all risks
             associated with its exercise of rights under this
             Agreement, including but not limited to the risks and
             costs of program errors, compliance with applicable laws,
             damage to or loss of data, programs or equipment, and
             unavailability or interruption of operations.

             6. DISCLAIMER OF LIABILITY
             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER
             RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY
             FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
             OR CONSEQUENTIAL DAMAGES (INCLUDING WITHOUT LIMITATION
             LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
             LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
             (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
             OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE
             OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
             POSSIBILITY OF SUCH DAMAGES.

             7. GENERAL

             If any provision of this Agreement is invalid or
             unenforceable under applicable law, it shall not affect
             the validity or enforceability of the remainder of the
             terms of this Agreement, and without further action by the
             parties hereto, such provision shall be reformed to the
             minimum extent necessary to make such provision valid and
             enforceable.


             If Recipient institutes patent litigation against a
             Contributor with respect to a patent applicable to
             software (including a cross-claim or counterclaim in a
             lawsuit), then any patent licenses granted by that
             Contributor to such Recipient under this Agreement shall
             terminate as of the date such litigation is filed. In
             addition, If Recipient institutes patent litigation
             against any entity (including a cross-claim or
             counterclaim in a lawsuit) alleging that the Program
             itself (excluding combinations of the Program with other
             software or hardware) infringes such Recipient's
             patent(s), then such Recipient's rights granted under
             Section 2(b) shall terminate as of the date such
             litigation is filed.

             All Recipient's rights under this Agreement shall
             terminate if it fails to comply with any of the material
             terms or conditions of this Agreement and does not cure
             such failure in a reasonable period of time after becoming
             aware of such noncompliance. If all Recipient's rights
             under this Agreement terminate, Recipient agrees to cease
             use and distribution of the Program as soon as reasonably
             practicable. However, Recipient's obligations under this
             Agreement and any licenses granted by Recipient relating
             to the Program shall continue and survive.

             Everyone is permitted to copy and distribute copies of
             this Agreement, but in order to avoid inconsistency the
             Agreement is copyrighted and may only be modified in the
             following manner. The Agreement Steward reserves the right
             to publish new versions (including revisions) of this
             Agreement from time to time. No one other than the
             Agreement Steward has the right to modify this Agreement.

             IBM is the initial Agreement Steward. IBM may assign the
             responsibility to serve as the Agreement Steward to a
             suitable separate entity. Each new version of the
             Agreement will be given a distinguishing version number.
             The Program (including Contributions) may always be
             distributed subject to the version of the Agreement under
             which it was received. In addition, after a new version of
             the Agreement is published, Contributor may elect to
             distribute the Program (including its Contributions) under
             the new version. Except as expressly stated in Sections
             2(a) and 2(b) above, Recipient receives no rights or
             licenses to the intellectual property of any Contributor
             under this Agreement, whether expressly, by implication,
             estoppel or otherwise. All rights in the Program not
             expressly granted under this Agreement are reserved.


             This Agreement is governed by the laws of the State of New
             York and the intellectual property laws of the United
             States of America. No party to this Agreement will bring a
             legal action under this Agreement more than one year after
             the cause of action arose. Each party waives its rights to
             a jury trial in any resulting litigation.



*/

/* (C) COPYRIGHT International Business Machines Corp. 2001,2002          */


#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "pkcs11types.h"

#define _sym2str(X)     case X: return #X

//
// p11_get_ckr - return textual interpretation of a CKR_ error code
// @rc is the CKR_.. error
//
char *p11_get_ckr( CK_RV rc )
{
   switch (rc) {
      _sym2str(CKR_OK);
      _sym2str(CKR_CANCEL);
      _sym2str(CKR_HOST_MEMORY);
      _sym2str(CKR_SLOT_ID_INVALID);
      _sym2str(CKR_GENERAL_ERROR);
      _sym2str(CKR_FUNCTION_FAILED);
      _sym2str(CKR_ARGUMENTS_BAD);
      _sym2str(CKR_NO_EVENT);
      _sym2str(CKR_NEED_TO_CREATE_THREADS);
      _sym2str(CKR_CANT_LOCK);
      _sym2str(CKR_ATTRIBUTE_READ_ONLY);
      _sym2str(CKR_ATTRIBUTE_SENSITIVE);
      _sym2str(CKR_ATTRIBUTE_TYPE_INVALID);
      _sym2str(CKR_ATTRIBUTE_VALUE_INVALID);
      _sym2str(CKR_DATA_INVALID);
      _sym2str(CKR_DATA_LEN_RANGE);
      _sym2str(CKR_DEVICE_ERROR);
      _sym2str(CKR_DEVICE_MEMORY);
      _sym2str(CKR_DEVICE_REMOVED);
      _sym2str(CKR_ENCRYPTED_DATA_INVALID);
      _sym2str(CKR_ENCRYPTED_DATA_LEN_RANGE);
      _sym2str(CKR_FUNCTION_CANCELED);
      _sym2str(CKR_FUNCTION_NOT_PARALLEL);
      _sym2str(CKR_FUNCTION_NOT_SUPPORTED);
      _sym2str(CKR_KEY_HANDLE_INVALID);
      _sym2str(CKR_KEY_SIZE_RANGE);
      _sym2str(CKR_KEY_TYPE_INCONSISTENT);
      _sym2str(CKR_KEY_NOT_NEEDED);
      _sym2str(CKR_KEY_CHANGED);
      _sym2str(CKR_KEY_NEEDED);
      _sym2str(CKR_KEY_INDIGESTIBLE);
      _sym2str(CKR_KEY_FUNCTION_NOT_PERMITTED);
      _sym2str(CKR_KEY_NOT_WRAPPABLE);
      _sym2str(CKR_KEY_UNEXTRACTABLE);
      _sym2str(CKR_MECHANISM_INVALID);
      _sym2str(CKR_MECHANISM_PARAM_INVALID);
      _sym2str(CKR_OBJECT_HANDLE_INVALID);
      _sym2str(CKR_OPERATION_ACTIVE);
      _sym2str(CKR_OPERATION_NOT_INITIALIZED);
      _sym2str(CKR_PIN_INCORRECT);
      _sym2str(CKR_PIN_INVALID);
      _sym2str(CKR_PIN_LEN_RANGE);
      _sym2str(CKR_PIN_EXPIRED);
      _sym2str(CKR_PIN_LOCKED);
      _sym2str(CKR_SESSION_CLOSED);
      _sym2str(CKR_SESSION_COUNT);
      _sym2str(CKR_SESSION_HANDLE_INVALID);
      _sym2str(CKR_SESSION_PARALLEL_NOT_SUPPORTED);
      _sym2str(CKR_SESSION_READ_ONLY);
      _sym2str(CKR_SESSION_EXISTS);
      _sym2str(CKR_SESSION_READ_ONLY_EXISTS);
      _sym2str(CKR_SESSION_READ_WRITE_SO_EXISTS);
      _sym2str(CKR_SIGNATURE_INVALID);
      _sym2str(CKR_SIGNATURE_LEN_RANGE);
      _sym2str(CKR_TEMPLATE_INCOMPLETE);
      _sym2str(CKR_TEMPLATE_INCONSISTENT);
      _sym2str(CKR_TOKEN_NOT_PRESENT);
      _sym2str(CKR_TOKEN_NOT_RECOGNIZED);
      _sym2str(CKR_TOKEN_WRITE_PROTECTED);
      _sym2str(CKR_UNWRAPPING_KEY_HANDLE_INVALID);
      _sym2str(CKR_UNWRAPPING_KEY_SIZE_RANGE);
      _sym2str(CKR_UNWRAPPING_KEY_TYPE_INCONSISTENT);
      _sym2str(CKR_USER_ALREADY_LOGGED_IN);
      _sym2str(CKR_USER_NOT_LOGGED_IN);
      _sym2str(CKR_USER_PIN_NOT_INITIALIZED);
      _sym2str(CKR_USER_TYPE_INVALID);
      _sym2str(CKR_USER_ANOTHER_ALREADY_LOGGED_IN);
      _sym2str(CKR_USER_TOO_MANY_TYPES);
      _sym2str(CKR_WRAPPED_KEY_INVALID);
      _sym2str(CKR_WRAPPED_KEY_LEN_RANGE);
      _sym2str(CKR_WRAPPING_KEY_HANDLE_INVALID);
      _sym2str(CKR_WRAPPING_KEY_SIZE_RANGE);
      _sym2str(CKR_WRAPPING_KEY_TYPE_INCONSISTENT);
      _sym2str(CKR_RANDOM_SEED_NOT_SUPPORTED);
      _sym2str(CKR_RANDOM_NO_RNG);
      _sym2str(CKR_BUFFER_TOO_SMALL);
      _sym2str(CKR_SAVED_STATE_INVALID);
      _sym2str(CKR_INFORMATION_SENSITIVE);
      _sym2str(CKR_STATE_UNSAVEABLE);
      _sym2str(CKR_CRYPTOKI_NOT_INITIALIZED);
      _sym2str(CKR_CRYPTOKI_ALREADY_INITIALIZED);
      _sym2str(CKR_MUTEX_BAD);
      _sym2str(CKR_MUTEX_NOT_LOCKED);
      default:					return "UNKNOWN";
   }
}

// is_attribute_defined()
//
// determine whether the specified attribute is defined by Cryptoki
//
CK_BBOOL
is_attribute_defined( CK_ATTRIBUTE_TYPE type )
{
   if (type >= CKA_VENDOR_DEFINED)
      return TRUE;

   switch (type)
   {
      case  CKA_CLASS:
      case  CKA_TOKEN:
      case  CKA_PRIVATE:
      case  CKA_LABEL:
      case  CKA_APPLICATION:
      case  CKA_VALUE:
      case  CKA_CERTIFICATE_TYPE:
      case  CKA_ISSUER:
      case  CKA_SERIAL_NUMBER:
      case  CKA_KEY_TYPE:
      case  CKA_SUBJECT:
      case  CKA_ID:
      case  CKA_SENSITIVE:
      case  CKA_ENCRYPT:
      case  CKA_DECRYPT:
      case  CKA_WRAP:
      case  CKA_UNWRAP:
      case  CKA_SIGN:
      case  CKA_SIGN_RECOVER:
      case  CKA_VERIFY:
      case  CKA_VERIFY_RECOVER:
      case  CKA_DERIVE:
      case  CKA_START_DATE:
      case  CKA_END_DATE:
      case  CKA_MODULUS:
      case  CKA_MODULUS_BITS:
      case  CKA_PUBLIC_EXPONENT:
      case  CKA_PRIVATE_EXPONENT:
      case  CKA_PRIME_1:
      case  CKA_PRIME_2:
      case  CKA_EXPONENT_1:
      case  CKA_EXPONENT_2:
      case  CKA_COEFFICIENT:
      case  CKA_PRIME:
      case  CKA_SUBPRIME:
      case  CKA_BASE:
      case  CKA_VALUE_BITS:
      case  CKA_VALUE_LEN:
      case  CKA_EXTRACTABLE:
      case  CKA_LOCAL:
      case  CKA_NEVER_EXTRACTABLE:
      case  CKA_ALWAYS_SENSITIVE:
      case  CKA_MODIFIABLE:
      case  CKA_ECDSA_PARAMS:
      case  CKA_EC_POINT:
      case  CKA_HW_FEATURE_TYPE:
      case  CKA_HAS_RESET:
      case  CKA_RESET_ON_INIT:
      case  CKA_KEY_GEN_MECHANISM:
      case  CKA_PRIME_BITS:
      case  CKA_SUBPRIME_BITS:
      case  CKA_OBJECT_ID:
      case  CKA_AC_ISSUER:
      case  CKA_OWNER:
      case  CKA_ATTR_TYPES:
      case  CKA_TRUSTED:
         return TRUE;
   }

   return FALSE;
}


char *
p11_get_ckm(CK_ULONG mechanism)
{
	switch (mechanism) {
	_sym2str(CKM_RSA_PKCS_KEY_PAIR_GEN);
	_sym2str(CKM_RSA_PKCS);
	_sym2str(CKM_RSA_9796);
	_sym2str(CKM_RSA_X_509);
	_sym2str(CKM_MD2_RSA_PKCS);
	_sym2str(CKM_MD5_RSA_PKCS);
	_sym2str(CKM_SHA1_RSA_PKCS);
	_sym2str(CKM_RIPEMD128_RSA_PKCS);
	_sym2str(CKM_RIPEMD160_RSA_PKCS);
	_sym2str(CKM_RSA_PKCS_OAEP);
	_sym2str(CKM_RSA_X9_31_KEY_PAIR_GEN);
	_sym2str(CKM_RSA_X9_31);
	_sym2str(CKM_SHA1_RSA_X9_31);
	_sym2str(CKM_RSA_PKCS_PSS);
	_sym2str(CKM_SHA1_RSA_PKCS_PSS);
	_sym2str(CKM_DSA_KEY_PAIR_GEN);
	_sym2str(CKM_DSA);
	_sym2str(CKM_DSA_SHA1);
	_sym2str(CKM_DH_PKCS_KEY_PAIR_GEN);
	_sym2str(CKM_DH_PKCS_DERIVE);
	_sym2str(CKM_X9_42_DH_KEY_PAIR_GEN);
	_sym2str(CKM_X9_42_DH_DERIVE);
	_sym2str(CKM_X9_42_DH_HYBRID_DERIVE);
	_sym2str(CKM_X9_42_MQV_DERIVE);
	_sym2str(CKM_SHA256_RSA_PKCS);
	_sym2str(CKM_SHA384_RSA_PKCS);
	_sym2str(CKM_SHA512_RSA_PKCS);
	_sym2str(CKM_RC2_KEY_GEN);
	_sym2str(CKM_RC2_ECB);
	_sym2str(CKM_RC2_CBC);
	_sym2str(CKM_RC2_MAC);
	_sym2str(CKM_RC2_MAC_GENERAL);
	_sym2str(CKM_RC2_CBC_PAD);
	_sym2str(CKM_RC4_KEY_GEN);
	_sym2str(CKM_RC4);
	_sym2str(CKM_DES_KEY_GEN);
	_sym2str(CKM_DES_ECB);
	_sym2str(CKM_DES_CBC);
	_sym2str(CKM_DES_MAC);
	_sym2str(CKM_DES_MAC_GENERAL);
	_sym2str(CKM_DES_CBC_PAD);
	_sym2str(CKM_DES2_KEY_GEN);
	_sym2str(CKM_DES3_KEY_GEN);
	_sym2str(CKM_DES3_ECB);
	_sym2str(CKM_DES3_CBC);
	_sym2str(CKM_DES3_MAC);
	_sym2str(CKM_DES3_MAC_GENERAL);
	_sym2str(CKM_DES3_CBC_PAD);
	_sym2str(CKM_CDMF_KEY_GEN);
	_sym2str(CKM_CDMF_ECB);
	_sym2str(CKM_CDMF_CBC);
	_sym2str(CKM_CDMF_MAC);
	_sym2str(CKM_CDMF_MAC_GENERAL);
	_sym2str(CKM_CDMF_CBC_PAD);
	_sym2str(CKM_MD2);
	_sym2str(CKM_MD2_HMAC);
	_sym2str(CKM_MD2_HMAC_GENERAL);
	_sym2str(CKM_MD5);
	_sym2str(CKM_MD5_HMAC);
	_sym2str(CKM_MD5_HMAC_GENERAL);
	_sym2str(CKM_SHA_1);
	_sym2str(CKM_SHA_1_HMAC);
	_sym2str(CKM_SHA_1_HMAC_GENERAL);
	_sym2str(CKM_RIPEMD128);
	_sym2str(CKM_RIPEMD128_HMAC);
	_sym2str(CKM_RIPEMD128_HMAC_GENERAL);
	_sym2str(CKM_RIPEMD160);
	_sym2str(CKM_RIPEMD160_HMAC);
	_sym2str(CKM_RIPEMD160_HMAC_GENERAL);
	_sym2str(CKM_SHA256);
	_sym2str(CKM_SHA256_HMAC);
	_sym2str(CKM_SHA256_HMAC_GENERAL);
	_sym2str(CKM_SHA384);
	_sym2str(CKM_SHA384_HMAC);
	_sym2str(CKM_SHA384_HMAC_GENERAL);
	_sym2str(CKM_SHA512);
	_sym2str(CKM_SHA512_HMAC);
	_sym2str(CKM_SHA512_HMAC_GENERAL);
	_sym2str(CKM_CAST_KEY_GEN);
	_sym2str(CKM_CAST_ECB);
	_sym2str(CKM_CAST_CBC);
	_sym2str(CKM_CAST_MAC);
	_sym2str(CKM_CAST_MAC_GENERAL);
	_sym2str(CKM_CAST_CBC_PAD);
	_sym2str(CKM_CAST3_KEY_GEN);
	_sym2str(CKM_CAST3_ECB);
	_sym2str(CKM_CAST3_CBC);
	_sym2str(CKM_CAST3_MAC);
	_sym2str(CKM_CAST3_MAC_GENERAL);
	_sym2str(CKM_CAST3_CBC_PAD);
	_sym2str(CKM_CAST5_KEY_GEN);
	_sym2str(CKM_CAST5_ECB);
	_sym2str(CKM_CAST5_CBC);
	_sym2str(CKM_CAST5_MAC);
	_sym2str(CKM_CAST5_MAC_GENERAL);
	_sym2str(CKM_CAST5_CBC_PAD);
	_sym2str(CKM_RC5_KEY_GEN);
	_sym2str(CKM_RC5_ECB);
	_sym2str(CKM_RC5_CBC);
	_sym2str(CKM_RC5_MAC);
	_sym2str(CKM_RC5_MAC_GENERAL);
	_sym2str(CKM_RC5_CBC_PAD);
	_sym2str(CKM_IDEA_KEY_GEN);
	_sym2str(CKM_IDEA_ECB);
	_sym2str(CKM_IDEA_CBC);
	_sym2str(CKM_IDEA_MAC);
	_sym2str(CKM_IDEA_MAC_GENERAL);
	_sym2str(CKM_IDEA_CBC_PAD);
	_sym2str(CKM_GENERIC_SECRET_KEY_GEN);
	_sym2str(CKM_CONCATENATE_BASE_AND_KEY);
	_sym2str(CKM_CONCATENATE_BASE_AND_DATA);
	_sym2str(CKM_CONCATENATE_DATA_AND_BASE);
	_sym2str(CKM_XOR_BASE_AND_DATA);
	_sym2str(CKM_EXTRACT_KEY_FROM_KEY);
	_sym2str(CKM_SSL3_PRE_MASTER_KEY_GEN);
	_sym2str(CKM_SSL3_MASTER_KEY_DERIVE);
	_sym2str(CKM_SSL3_KEY_AND_MAC_DERIVE);
	_sym2str(CKM_SSL3_MASTER_KEY_DERIVE_DH);
	_sym2str(CKM_TLS_PRE_MASTER_KEY_GEN);
	_sym2str(CKM_TLS_MASTER_KEY_DERIVE);
	_sym2str(CKM_TLS_KEY_AND_MAC_DERIVE);
	_sym2str(CKM_TLS_MASTER_KEY_DERIVE_DH);
	_sym2str(CKM_SSL3_MD5_MAC);
	_sym2str(CKM_SSL3_SHA1_MAC);
	_sym2str(CKM_MD5_KEY_DERIVATION);
	_sym2str(CKM_MD2_KEY_DERIVATION);
	_sym2str(CKM_SHA1_KEY_DERIVATION);
	_sym2str(CKM_SHA256_KEY_DERIVATION);
	_sym2str(CKM_PBE_MD2_DES_CBC);
	_sym2str(CKM_PBE_MD5_DES_CBC);
	_sym2str(CKM_PBE_MD5_CAST_CBC);
	_sym2str(CKM_PBE_MD5_CAST3_CBC);
	_sym2str(CKM_PBE_MD5_CAST5_CBC);
	_sym2str(CKM_PBE_SHA1_CAST5_CBC);
	_sym2str(CKM_PBE_SHA1_RC4_128);
	_sym2str(CKM_PBE_SHA1_RC4_40);
	_sym2str(CKM_PBE_SHA1_DES3_EDE_CBC);
	_sym2str(CKM_PBE_SHA1_DES2_EDE_CBC);
	_sym2str(CKM_PBE_SHA1_RC2_128_CBC);
	_sym2str(CKM_PBE_SHA1_RC2_40_CBC);
	_sym2str(CKM_PKCS5_PBKD2);
	_sym2str(CKM_PBA_SHA1_WITH_SHA1_HMAC);
	_sym2str(CKM_KEY_WRAP_LYNKS);
	_sym2str(CKM_KEY_WRAP_SET_OAEP);
	_sym2str(CKM_SKIPJACK_KEY_GEN);
	_sym2str(CKM_SKIPJACK_ECB64);
	_sym2str(CKM_SKIPJACK_CBC64);
	_sym2str(CKM_SKIPJACK_OFB64);
	_sym2str(CKM_SKIPJACK_CFB64);
	_sym2str(CKM_SKIPJACK_CFB32);
	_sym2str(CKM_SKIPJACK_CFB16);
	_sym2str(CKM_SKIPJACK_CFB8);
	_sym2str(CKM_SKIPJACK_WRAP);
	_sym2str(CKM_SKIPJACK_PRIVATE_WRAP);
	_sym2str(CKM_SKIPJACK_RELAYX);
	_sym2str(CKM_KEA_KEY_PAIR_GEN);
	_sym2str(CKM_KEA_KEY_DERIVE);
	_sym2str(CKM_FORTEZZA_TIMESTAMP);
	_sym2str(CKM_BATON_KEY_GEN);
	_sym2str(CKM_BATON_ECB128);
	_sym2str(CKM_BATON_ECB96);
	_sym2str(CKM_BATON_CBC128);
	_sym2str(CKM_BATON_COUNTER);
	_sym2str(CKM_BATON_SHUFFLE);
	_sym2str(CKM_BATON_WRAP);
	_sym2str(CKM_EC_KEY_PAIR_GEN);
	_sym2str(CKM_ECDSA);
	_sym2str(CKM_ECDSA_SHA1);
	_sym2str(CKM_ECDH1_DERIVE);
	_sym2str(CKM_ECDH1_COFACTOR_DERIVE);
	_sym2str(CKM_ECMQV_DERIVE);
	_sym2str(CKM_JUNIPER_KEY_GEN);
	_sym2str(CKM_JUNIPER_ECB128);
	_sym2str(CKM_JUNIPER_CBC128);
	_sym2str(CKM_JUNIPER_COUNTER);
	_sym2str(CKM_JUNIPER_SHUFFLE);
	_sym2str(CKM_JUNIPER_WRAP);
	_sym2str(CKM_FASTHASH);
	_sym2str(CKM_AES_KEY_GEN);
	_sym2str(CKM_AES_ECB);
	_sym2str(CKM_AES_CBC);
	_sym2str(CKM_AES_MAC);
	_sym2str(CKM_AES_MAC_GENERAL);
	_sym2str(CKM_AES_CBC_PAD);
	_sym2str(CKM_AES_CTR);
	_sym2str(CKM_DSA_PARAMETER_GEN);
	_sym2str(CKM_DH_PKCS_PARAMETER_GEN);
	_sym2str(CKM_X9_42_DH_PARAMETER_GEN);
	_sym2str(CKM_VENDOR_DEFINED);
	default:				return "UNKNOWN";
	}
}

// Allocates memory on *dst and puts hex dump from ptr
// with len bytes.
// *dst must be freed by the caller
char *
p11_ahex_dump(char **dst, CK_BYTE_PTR ptr, CK_ULONG len)
{
    CK_ULONG i;

    if (dst == NULL) {
        return NULL;
    }

    *dst = (char *) calloc(2*len + 1 , sizeof(char));
    if (*dst == NULL) {
        return NULL;
    }

    for (i = 0; i < len; i++) {
            sprintf(*dst + 2*i, "%02hhX", ptr[i]);
    }
    *(*dst + 2*len) = '\0';      // null-terminate

    return *dst;
}


/* p11_bigint_trim() - trim a big integer. Returns pointer that is
 *        contained within 'in' + '*size' that represents
 *        the same number, but without leading zeros.
 *  @in   points to a sequence of bytes forming a big integer,
 *        unsigned, right-aligned and big-endian
 *  @size points to the size of @in on input, and the minimum
 *        size that can represent it on output
 */
CK_BYTE_PTR
p11_bigint_trim(CK_BYTE_PTR in, CK_ULONG_PTR size) {
   CK_ULONG i;

   for (i = 0;
        (i < *size) && in[i] == 0x00;
        i++);
   *size -= i;
   return in + i;
}

/* p11_attribute_trim() - trim a PKCS#11 CK_ATTRIBUTE in place,
 *      using memmove() to move the data and adjusting
 *      ulValueLen. The resulting "pValue" pointer stays the
 *      same so that the caller can free() it normally
 * @attr is the pointer to the CK_ATTRIBUTE to be trimmed
 */
void
p11_attribute_trim(CK_ATTRIBUTE *attr) {

   CK_BYTE_PTR ptr;
   CK_ULONG    size;

   if (attr != NULL) {
      size = attr->ulValueLen;
      ptr = p11_bigint_trim(attr->pValue, &size);

      if (ptr != attr->pValue) {
         attr->ulValueLen = size;
         memmove(attr->pValue, ptr, size);
      }
   }
}
